MONHASH = {
:BULBASAUR => {
	:name => "Bulbasaur",
	:dexnum => 1,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [45, 49, 49, 45, 65, 65],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:OVERGROW,:CHLOROPHYLL],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 64,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:CHARM,:CURSE,:ENDURE,:GIGADRAIN,:GRASSWHISTLE,:GRASSYTERRAIN,:INGRAIN,:LEAFSTORM,:MAGICALLEAF,:NATUREPOWER,:PETALDANCE,:POWERWHIP,:SKULLBASH,:SLUDGE],
	:Moveset => [
		[1,:TACKLE],
		[3,:GROWL],
		[7,:LEECHSEED],
		[9,:VINEWHIP],
		[13,:POISONPOWDER],
		[13,:SLEEPPOWDER],
		[15,:TAKEDOWN],
		[19,:RAZORLEAF],
		[21,:SWEETSCENT],
		[25,:GROWTH],
		[27,:DOUBLEEDGE],
		[31,:WORRYSEED],
		[33,:SYNTHESIS],
		[37,:SEEDBOMB]],
	:tmlist => [:FURYCUTTER,:STRINGSHOT,:KNOCKOFF,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:LIGHTSCREEN,:REST,:CONFIDE,:CELEBRATE,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Grass],
	:Height => 7,
	:Weight => 69,
	:kind => "Seed",
	:dexentry => "Bulbasaur can be seen napping in bright sunlight. There is a seed on its back. By soaking up the sun's rays, the seed grows progressively larger.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:IVYSAUR,:Level,16]
	]
},

:IVYSAUR => {
	:name => "Ivysaur",
	:dexnum => 2,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [60, 62, 63, 60, 80, 80],
	:EVs => [0, 0, 0, 0, 1, 1],
	:Abilities => [:OVERGROW,:CHLOROPHYLL],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[1,:LEECHSEED],
		[3,:GROWL],
		[7,:LEECHSEED],
		[9,:VINEWHIP],
		[13,:POISONPOWDER],
		[13,:SLEEPPOWDER],
		[15,:TAKEDOWN],
		[20,:RAZORLEAF],
		[23,:SWEETSCENT],
		[28,:GROWTH],
		[31,:DOUBLEEDGE],
		[36,:WORRYSEED],
		[39,:SYNTHESIS],
		[44,:SOLARBEAM]],
	:tmlist => [:FURYCUTTER,:STRINGSHOT,:KNOCKOFF,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:LIGHTSCREEN,:REST,:CONFIDE,:CELEBRATE,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Grass],
	:Height => 10,
	:Weight => 130,
	:kind => "Seed",
	:dexentry => "To support its bulb, Ivysaur's legs grow sturdy. If it spends more time lying in the sunlight, the bud will soon bloom into a large flower.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:VENUSAUR,:Level,32]
	]
},

:VENUSAUR => {
	:name => "Venusaur",
	:dexnum => 3,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [80, 82, 83, 80, 100, 100],
	:EVs => [0, 0, 0, 0, 2, 1],
	:Abilities => [:OVERGROW,:CHLOROPHYLL],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 236,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:PETALDANCE],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:LEECHSEED],
		[1,:VINEWHIP],
		[3,:GROWL],
		[7,:LEECHSEED],
		[9,:VINEWHIP],
		[13,:POISONPOWDER],
		[13,:SLEEPPOWDER],
		[15,:TAKEDOWN],
		[20,:RAZORLEAF],
		[23,:SWEETSCENT],
		[28,:GROWTH],
		[31,:DOUBLEEDGE],
		[39,:WORRYSEED],
		[45,:SYNTHESIS],
		[50,:PETALBLIZZARD],
		[53,:SOLARBEAM]],
	:tmlist => [:FURYCUTTER,:STRINGSHOT,:KNOCKOFF,:OUTRAGE,:ROCKSMASH,:SUNNYDAY,:FRENZYPLANT,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:LIGHTSCREEN,:REST,:CONFIDE,:STOMPINGTANTRUM,:CELEBRATE,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Grass],
	:Height => 20,
	:Weight => 1000,
	:kind => "Seed",
	:dexentry => "Venusaur's flower is said to take on vivid colors if it gets plenty of nutrition and sunlight. The flower's aroma soothes the emotions of people.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:CHARMANDER => {
	:name => "Charmander",
	:dexnum => 4,
	:Type1 => :FIRE,
	:BaseStats => [39, 52, 43, 65, 60, 50],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:BLAZE,:SOLARPOWER],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 62,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AIRCUTTER,:ANCIENTPOWER,:BEATUP,:BELLYDRUM,:BITE,:COUNTER,:CRUNCH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRUSH,:FLAREBLITZ,:FOCUSPUNCH,:METALCLAW,:OUTRAGE],
	:Moveset => [
		[1,:SCRATCH],
		[1,:GROWL],
		[7,:EMBER],
		[10,:SMOKESCREEN],
		[16,:DRAGONRAGE],
		[19,:SCARYFACE],
		[25,:FIREFANG],
		[28,:FLAMEBURST],
		[34,:SLASH],
		[37,:FLAMETHROWER],
		[43,:FIRESPIN],
		[46,:INFERNO]],
	:tmlist => [:FURYCUTTER,:FLING,:DRAGONCLAW,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWCLAW,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:CONFIDE,:POWERUPPUNCH,:CELEBRATE,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:Monster,:Dragon],
	:Height => 6,
	:Weight => 85,
	:kind => "Lizard",
	:dexentry => "The flame that burns at the tip of its tail is an indication of its emotions. The flame wavers when Charmander is happy, and blazes when it is enraged.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CHARMELEON,:Level,16]
	]
},

:CHARMELEON => {
	:name => "Charmeleon",
	:dexnum => 5,
	:Type1 => :FIRE,
	:BaseStats => [58, 64, 58, 80, 80, 65],
	:EVs => [0, 0, 0, 1, 1, 0],
	:Abilities => [:BLAZE,:SOLARPOWER],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:SCRATCH],
		[1,:GROWL],
		[1,:EMBER],
		[7,:EMBER],
		[10,:SMOKESCREEN],
		[17,:DRAGONRAGE],
		[21,:SCARYFACE],
		[28,:FIREFANG],
		[32,:FLAMEBURST],
		[39,:SLASH],
		[43,:FLAMETHROWER],
		[50,:FIRESPIN],
		[54,:INFERNO]],
	:tmlist => [:FURYCUTTER,:FLING,:DRAGONCLAW,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWCLAW,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:CONFIDE,:POWERUPPUNCH,:CELEBRATE,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:Monster,:Dragon],
	:Height => 11,
	:Weight => 190,
	:kind => "Flame",
	:dexentry => "Without pity, its sharp claws destroy foes. If it encounters a strong enemy, it becomes agitated, and the flame on its tail flares with a bluish white color.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CHARIZARD,:Level,36]
	]
},

:CHARIZARD => {
	:name => "Charizard",
	:dexnum => 6,
	:Type1 => :FIRE,
	:Type2 => :FLYING,
	:BaseStats => [78, 84, 78, 100, 109, 85],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:BLAZE,:SOLARPOWER],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 240,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:WINGATTACK],
		[1,:FLAREBLITZ],
		[1,:HEATWAVE],
		[1,:AIRSLASH],
		[1,:DRAGONCLAW],
		[1,:SHADOWCLAW],
		[1,:SCRATCH],
		[1,:GROWL],
		[1,:SMOKESCREEN],
		[1,:EMBER],
		[7,:EMBER],
		[10,:SMOKESCREEN],
		[17,:DRAGONRAGE],
		[21,:SCARYFACE],
		[28,:FIREFANG],
		[32,:FLAMEBURST],
		[41,:SLASH],
		[47,:FLAMETHROWER],
		[56,:FIRESPIN],
		[62,:INFERNO],
		[71,:HEATWAVE],
		[77,:FLAREBLITZ]],
	:tmlist => [:FURYCUTTER,:FLING,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:TWISTER,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:BLASTBURN,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWCLAW,:OMINOUSWIND,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:STEELWING,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:CELEBRATE,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:Monster,:Dragon],
	:Height => 17,
	:Weight => 905,
	:kind => "Flame",
	:dexentry => "A Charizard flies about in search of strong opponents. It breathes intense flames that can melt any material. However, it will never torch a weaker foe.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 2,
	:BattlerAltitude => 0,
},

:SQUIRTLE => {
	:name => "Squirtle",
	:dexnum => 7,
	:Type1 => :WATER,
	:BaseStats => [44, 48, 65, 43, 50, 64],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:TORRENT,:RAINDISH],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 63,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AQUAJET,:AQUARING,:AURASPHERE,:BRINE,:DRAGONPULSE,:FAKEOUT,:FLAIL,:FORESIGHT,:HAZE,:MIRRORCOAT,:MIST,:MUDSPORT,:MUDDYWATER,:REFRESH,:WATERSPOUT,:YAWN],
	:Moveset => [
		[1,:TACKLE],
		[4,:TAILWHIP],
		[7,:WATERGUN],
		[10,:WITHDRAW],
		[13,:BUBBLE],
		[16,:BITE],
		[19,:RAPIDSPIN],
		[22,:PROTECT],
		[25,:WATERPULSE],
		[28,:AQUATAIL],
		[31,:SKULLBASH],
		[34,:IRONDEFENSE],
		[37,:RAINDANCE],
		[40,:HYDROPUMP]],
	:tmlist => [:FLING,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROCKTOMB,:ROLLOUT,:IRONTAIL,:GYROBALL,:IRONDEFENSE,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:CELEBRATE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 5,
	:Weight => 90,
	:kind => "Tiny Turtle",
	:dexentry => "Its shell is not just for protection. Its rounded shape and the grooves on its surface minimize resistance in water, enabling Squirtle to swim at high speeds.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WARTORTLE,:Level,16]
	]
},

:WARTORTLE => {
	:name => "Wartortle",
	:dexnum => 8,
	:Type1 => :WATER,
	:BaseStats => [59, 63, 80, 58, 65, 80],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:TORRENT,:RAINDISH],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:TAILWHIP],
		[1,:WATERGUN],
		[4,:TAILWHIP],
		[7,:WATERGUN],
		[10,:WITHDRAW],
		[13,:BUBBLE],
		[17,:BITE],
		[21,:RAPIDSPIN],
		[25,:PROTECT],
		[29,:WATERPULSE],
		[33,:AQUATAIL],
		[37,:SKULLBASH],
		[41,:IRONDEFENSE],
		[45,:RAINDANCE],
		[49,:HYDROPUMP]],
	:tmlist => [:FLING,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROCKTOMB,:ROLLOUT,:IRONTAIL,:GYROBALL,:IRONDEFENSE,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:CELEBRATE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 10,
	:Weight => 225,
	:kind => "Turtle",
	:dexentry => "Its large tail is covered with rich, thick fur that deepens in color with age. The scratches on its shell are evidence of this Pokémon's toughness in battle.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BLASTOISE,:Level,36]
	]
},

:BLASTOISE => {
	:name => "Blastoise",
	:dexnum => 9,
	:Type1 => :WATER,
	:BaseStats => [79, 83, 100, 78, 85, 105],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:TORRENT,:RAINDISH],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 239,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:FLASHCANNON],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[1,:WATERGUN],
		[1,:WITHDRAW],
		[4,:TAILWHIP],
		[7,:WATERGUN],
		[10,:WITHDRAW],
		[13,:BUBBLE],
		[17,:BITE],
		[21,:RAPIDSPIN],
		[25,:PROTECT],
		[29,:WATERPULSE],
		[33,:AQUATAIL],
		[40,:SKULLBASH],
		[47,:IRONDEFENSE],
		[54,:RAINDANCE],
		[60,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:DARKPULSE,:FLING,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:IRONTAIL,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:HYDROCANNON,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LIQUIDATION,:CELEBRATE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 16,
	:Weight => 855,
	:kind => "Shellfish",
	:dexentry => "The waterspouts that protrude from its shell are highly accurate. Their bullets of water can precisely nail tin cans from a distance of over 160 feet.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:CATERPIE => {
	:name => "Caterpie",
	:dexnum => 10,
	:Type1 => :BUG,
	:BaseStats => [45, 30, 35, 45, 20, 20],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:SHIELDDUST,:RUNAWAY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 39,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:TACKLE],
		[1,:STRINGSHOT],
		[9,:BUGBITE]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:SNORE,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 3,
	:Weight => 29,
	:kind => "Worm",
	:dexentry => "Its voracious appetite compels it to devour leaves bigger than itself without hesitation. It releases a terribly strong odor from its antennae.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:METAPOD,:Level,7]
	]
},

:METAPOD => {
	:name => "Metapod",
	:dexnum => 11,
	:Type1 => :BUG,
	:BaseStats => [50, 20, 55, 30, 25, 25],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SHEDSKIN],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 72,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:HARDEN],
		[1,:HARDEN]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:IRONDEFENSE,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 7,
	:Weight => 99,
	:kind => "Cocoon",
	:dexentry => "Its shell is as hard as an iron slab. A Metapod does not move very much because it is preparing its soft innards for evolution inside the shell.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BUTTERFREE,:Level,10]
	]
},

:BUTTERFREE => {
	:name => "Butterfree",
	:dexnum => 12,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [60, 45, 50, 70, 90, 80],
	:EVs => [0, 0, 0, 0, 2, 1],
	:Abilities => [:COMPOUNDEYES,:TINTEDLENS],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:GUST],
		[1,:CONFUSION],
		[11,:CONFUSION],
		[13,:POISONPOWDER],
		[13,:STUNSPORE],
		[13,:SLEEPPOWDER],
		[17,:PSYBEAM],
		[19,:SILVERWIND],
		[23,:SUPERSONIC],
		[25,:SAFEGUARD],
		[29,:WHIRLWIND],
		[31,:BUGBUZZ],
		[35,:RAGEPOWDER],
		[37,:CAPTIVATE],
		[41,:TAILWIND],
		[43,:AIRSLASH],
		[47,:QUIVERDANCE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:TWISTER,:ELECTROWEB,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:VENOSHOCK,:TOXIC,:DREAMEATER,:PSYCHIC,:REST,:SKILLSWAP,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "White",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 11,
	:Weight => 320,
	:WildItemUncommon => :SILVERPOWDER,
	:kind => "Butterfly",
	:dexentry => "It has a superior ability to search for delicious honey from flowers. It can seek, extract, and carry honey from flowers blooming over six miles away.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 15,
},

:WEEDLE => {
	:name => "Weedle",
	:dexnum => 13,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [40, 35, 30, 50, 20, 20],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SHIELDDUST,:RUNAWAY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 39,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:POISONSTING],
		[1,:STRINGSHOT],
		[9,:BUGBITE]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 3,
	:Weight => 32,
	:kind => "Hairy Bug",
	:dexentry => "A Weedle has an extremely acute sense of smell. It distinguishes its favorite kinds of leaves from those it dislikes by sniffing with its big red nose.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 0,
	:evolutions => [
		[:KAKUNA,:Level,7]
	]
},

:KAKUNA => {
	:name => "Kakuna",
	:dexnum => 14,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [45, 25, 50, 35, 25, 25],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SHEDSKIN],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 72,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:HARDEN],
		[1,:HARDEN]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:IRONDEFENSE,],
	:Color => "Yellow",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 6,
	:Weight => 100,
	:kind => "Cocoon",
	:dexentry => "It remains virtually immobile while it clings to a tree. However, on the inside, it busily prepares for evolution. This is evident from how hot its shell becomes.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 11,
	:evolutions => [
		[:BEEDRILL,:Level,10]
	]
},

:BEEDRILL => {
	:name => "Beedrill",
	:dexnum => 15,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [65, 90, 40, 75, 45, 80],
	:EVs => [0, 2, 0, 0, 0, 1],
	:Abilities => [:SWARM,:SNIPER],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:TWINEEDLE],
		[1,:FURYATTACK],
		[11,:FURYATTACK],
		[14,:RAGE],
		[17,:PURSUIT],
		[20,:FOCUSENERGY],
		[23,:VENOSHOCK],
		[26,:ASSURANCE],
		[29,:TOXICSPIKES],
		[32,:PINMISSILE],
		[35,:POISONJAB],
		[38,:AGILITY],
		[41,:ENDEAVOR],
		[44,:FELLSTINGER]],
	:tmlist => [:XSCISSOR,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:STRINGSHOT,:PAYBACK,:THIEF,:KNOCKOFF,:ELECTROWEB,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:DRILLRUN,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:CONFIDE,:INFESTATION,:BRUTALSWING,:LASERFOCUS,:THROATCHOP,],
	:Color => "Yellow",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 10,
	:Weight => 295,
	:WildItemUncommon => :POISONBARB,
	:kind => "Poison Bee",
	:dexentry => "A Beedrill is extremely territorial. For safety reasons, no one should ever approach its nest. If angered, they will attack in a swarm.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 11,
},

:PIDGEY => {
	:name => "Pidgey",
	:dexnum => 16,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [40, 45, 40, 56, 35, 35],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:KEENEYE,:TANGLEDFEET],
	:HiddenAbilities => :BIGPECKS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 50,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:AIRCUTTER,:AIRSLASH,:BRAVEBIRD,:DEFOG,:FEINTATTACK,:FORESIGHT,:PURSUIT,:STEELWING,:UPROAR],
	:Moveset => [
		[1,:TACKLE],
		[5,:SANDATTACK],
		[9,:GUST],
		[13,:QUICKATTACK],
		[17,:WHIRLWIND],
		[21,:TWISTER],
		[25,:FEATHERDANCE],
		[29,:AGILITY],
		[33,:WINGATTACK],
		[37,:ROOST],
		[41,:TAILWIND],
		[45,:MIRRORMOVE],
		[49,:AIRSLASH],
		[53,:HURRICANE]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Flying],
	:Height => 3,
	:Weight => 18,
	:kind => "Tiny Bird",
	:dexentry => "It has an extremely sharp sense of direction. It can unerringly return home to its nest, however far it may be removed from its familiar surroundings.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PIDGEOTTO,:Level,18]
	]
},

:PIDGEOTTO => {
	:name => "Pidgeotto",
	:dexnum => 17,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [63, 60, 55, 71, 50, 50],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:KEENEYE,:TANGLEDFEET],
	:HiddenAbilities => :BIGPECKS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 122,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:TACKLE],
		[1,:SANDATTACK],
		[1,:GUST],
		[5,:SANDATTACK],
		[9,:GUST],
		[13,:QUICKATTACK],
		[17,:WHIRLWIND],
		[22,:TWISTER],
		[27,:FEATHERDANCE],
		[32,:AGILITY],
		[37,:WINGATTACK],
		[42,:ROOST],
		[47,:TAILWIND],
		[52,:MIRRORMOVE],
		[57,:AIRSLASH],
		[62,:HURRICANE]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Flying],
	:Height => 11,
	:Weight => 300,
	:kind => "Bird",
	:dexentry => "This Pokémon flies around, patrolling its large territory. If its living space is violated, it shows no mercy in thoroughly punishing the foe with its sharp claws.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PIDGEOT,:Level,36]
	]
},

:PIDGEOT => {
	:name => "Pidgeot",
	:dexnum => 18,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [83, 80, 75, 101, 70, 70],
	:EVs => [0, 0, 0, 3, 0, 0],
	:Abilities => [:KEENEYE,:TANGLEDFEET],
	:HiddenAbilities => :BIGPECKS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 211,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:HURRICANE],
		[1,:TACKLE],
		[1,:SANDATTACK],
		[1,:GUST],
		[1,:QUICKATTACK],
		[5,:SANDATTACK],
		[9,:GUST],
		[13,:QUICKATTACK],
		[17,:WHIRLWIND],
		[22,:TWISTER],
		[27,:FEATHERDANCE],
		[32,:AGILITY],
		[38,:WINGATTACK],
		[44,:ROOST],
		[50,:TAILWIND],
		[56,:MIRRORMOVE],
		[62,:AIRSLASH],
		[68,:HURRICANE]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Flying],
	:Height => 15,
	:Weight => 395,
	:kind => "Bird",
	:dexentry => "This Pokémon has gorgeous feathers. Many Trainers are so captivated by the feathers on its head, that they choose Pidgeot as their Pokémon.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 11,
},

:RATTATA => {
	:name => "Rattata",
	:dexnum => 19,
	:Type1 => :NORMAL,
	:BaseStats => [30, 56, 35, 72, 25, 35],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:RUNAWAY,:GUTS],
	:HiddenAbilities => :HUSTLE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 51,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BITE,:COUNTER,:FINALGAMBIT,:FLAMEWHEEL,:FURYSWIPES,:LASTRESORT,:MEFIRST,:REVENGE,:REVERSAL,:SCREECH,:UPROAR],
	:Moveset => [
		[1,:TACKLE],
		[1,:TAILWHIP],
		[4,:QUICKATTACK],
		[7,:FOCUSENERGY],
		[10,:BITE],
		[13,:PURSUIT],
		[16,:HYPERFANG],
		[19,:ASSURANCE],
		[22,:CRUNCH],
		[25,:SUCKERPUNCH],
		[28,:SUPERFANG],
		[31,:DOUBLEEDGE],
		[34,:ENDEAVOR]],
	:tmlist => [:UTURN,:SUCKERPUNCH,:THIEF,:TAUNT,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:IRONTAIL,:RAINDANCE,],
	:Color => "Purple",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 3,
	:Weight => 35,
	:kind => "Mouse",
	:dexentry => "A Rattata is cautious in the extreme. Even while it is asleep, it constantly moves its ears and listens for danger. It will make its nest anywhere.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:RATICATE,:Level,20]
	]
},

:RATICATE => {
	:name => "Raticate",
	:dexnum => 20,
	:Type1 => :NORMAL,
	:BaseStats => [55, 81, 60, 97, 50, 70],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:RUNAWAY,:GUTS],
	:HiddenAbilities => :HUSTLE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 145,
	:CatchRate => 127,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:SCARYFACE],
		[1,:SWORDSDANCE],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[1,:QUICKATTACK],
		[1,:FOCUSENERGY],
		[4,:QUICKATTACK],
		[7,:FOCUSENERGY],
		[10,:BITE],
		[13,:PURSUIT],
		[16,:HYPERFANG],
		[19,:ASSURANCE],
		[24,:CRUNCH],
		[29,:SUCKERPUNCH],
		[34,:SUPERFANG],
		[39,:DOUBLEEDGE],
		[44,:ENDEAVOR]],
	:tmlist => [:UTURN,:SUCKERPUNCH,:THIEF,:TAUNT,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:IRONTAIL,:RAINDANCE,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 7,
	:Weight => 185,
	:kind => "Mouse",
	:dexentry => "A Raticate's sturdy fangs grow steadily. To keep them ground down, it gnaws on rocks and logs. It may even chew on the walls of houses.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:SPEAROW => {
	:name => "Spearow",
	:dexnum => 21,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [40, 60, 30, 70, 31, 31],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:KEENEYE,:SNIPER],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 52,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:ASTONISH,:FEINTATTACK,:FEATHERDANCE,:QUICKATTACK,:RAZORWIND,:SCARYFACE,:SKYATTACK,:STEELWING,:TRIATTACK,:UPROAR,:WHIRLWIND],
	:Moveset => [
		[1,:PECK],
		[1,:GROWL],
		[4,:LEER],
		[8,:PURSUIT],
		[11,:FURYATTACK],
		[15,:AERIALACE],
		[18,:MIRRORMOVE],
		[22,:ASSURANCE],
		[25,:AGILITY],
		[29,:FOCUSENERGY],
		[32,:ROOST],
		[36,:DRILLPECK]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:DRILLRUN,:MUDSLAP,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Flying],
	:Height => 3,
	:Weight => 20,
	:WildItemUncommon => :SHARPBEAK,
	:kind => "Tiny Bird",
	:dexentry => "Its loud cry can be heard over half a mile away. If its high, keening cry is heard echoing all around, it is a sign that they are warning of danger.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:FEAROW,:Level,20]
	]
},

:FEAROW => {
	:name => "Fearow",
	:dexnum => 22,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [65, 90, 65, 100, 61, 61],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:KEENEYE,:SNIPER],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 155,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:DRILLRUN],
		[1,:PLUCK],
		[1,:PECK],
		[1,:GROWL],
		[1,:LEER],
		[1,:PURSUIT],
		[4,:LEER],
		[8,:PURSUIT],
		[11,:FURYATTACK],
		[15,:AERIALACE],
		[18,:MIRRORMOVE],
		[23,:ASSURANCE],
		[27,:AGILITY],
		[32,:FOCUSENERGY],
		[36,:ROOST],
		[41,:DRILLPECK],
		[45,:DRILLRUN]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:DRILLRUN,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,:LASERFOCUS,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Flying],
	:Height => 12,
	:Weight => 380,
	:WildItemUncommon => :SHARPBEAK,
	:kind => "Beak",
	:dexentry => "Its long neck and elongated beak are ideal for catching prey in soil or water. It deftly moves this extended and skinny beak to pluck prey.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 4,
	:BattlerAltitude => 8,
},

:EKANS => {
	:name => "Ekans",
	:dexnum => 23,
	:Type1 => :POISON,
	:BaseStats => [35, 60, 44, 55, 40, 54],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:SHEDSKIN],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BEATUP,:DISABLE,:IRONTAIL,:POISONFANG,:POISONTAIL,:PURSUIT,:SCARYFACE,:SLAM,:SNATCH,:SPITE,:SUCKERPUNCH,:SWITCHEROO],
	:Moveset => [
		[1,:WRAP],
		[1,:LEER],
		[4,:POISONSTING],
		[9,:BITE],
		[12,:GLARE],
		[17,:SCREECH],
		[20,:ACID],
		[25,:STOCKPILE],
		[25,:SPITUP],
		[25,:SWALLOW],
		[28,:ACIDSPRAY],
		[33,:MUDBOMB],
		[36,:GASTROACID],
		[38,:BELCH],
		[41,:HAZE],
		[44,:COIL],
		[49,:GUNKSHOT]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:SNATCH,:TORMENT,:SUNNYDAY,:SPITE,:SEEDBOMB,:GIGADRAIN,:EARTHQUAKE,:BULLDOZE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:INFESTATION,:BRUTALSWING,],
	:Color => "Purple",
	:Habitat => "Grassland",
	:EggGroups => [:Field,:Dragon],
	:Height => 20,
	:Weight => 69,
	:kind => "Snake",
	:dexentry => "An Ekans curls itself up in a spiral while it rests. This position allows it to quickly respond to an enemy from any direction with its upraised head.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ARBOK,:Level,22]
	]
},

:ARBOK => {
	:name => "Arbok",
	:dexnum => 24,
	:Type1 => :POISON,
	:BaseStats => [60, 95, 69, 80, 65, 79],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:SHEDSKIN],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 153,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:CRUNCH],
		[1,:ICEFANG],
		[1,:THUNDERFANG],
		[1,:FIREFANG],
		[1,:WRAP],
		[1,:LEER],
		[1,:BITE],
		[1,:POISONSTING],
		[4,:POISONSTING],
		[9,:BITE],
		[12,:GLARE],
		[17,:SCREECH],
		[20,:ACID],
		[27,:STOCKPILE],
		[27,:SPITUP],
		[27,:SWALLOW],
		[32,:ACIDSPRAY],
		[39,:MUDBOMB],
		[44,:GASTROACID],
		[48,:BELCH],
		[51,:HAZE],
		[56,:COIL],
		[63,:GUNKSHOT]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:SNATCH,:TORMENT,:DRAGONTAIL,:SUNNYDAY,:SPITE,:SEEDBOMB,:GIGADRAIN,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:INFESTATION,:BRUTALSWING,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Purple",
	:Habitat => "Grassland",
	:EggGroups => [:Field,:Dragon],
	:Height => 35,
	:Weight => 650,
	:kind => "Cobra",
	:dexentry => "This Pokémon has a terrifically strong constricting power. It can even flatten steel oil drums. Once it wraps its body around its foe, escaping is impossible.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:PIKACHU => {
	:name => "Pikachu",
	:dexnum => 25,
	:Type1 => :ELECTRIC,
	:BaseStats => [35, 55, 40, 90, 50, 50],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:STATIC,:LIGHTNINGROD],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 105,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 2805,
	:Moveset => [
		[1,:TAILWHIP],
		[1,:THUNDERSHOCK],
		[5,:GROWL],
		[7,:PLAYNICE],
		[10,:QUICKATTACK],
		[13,:ELECTROBALL],
		[18,:THUNDERWAVE],
		[21,:FEINT],
		[23,:DOUBLETEAM],
		[26,:SPARK],
		[29,:NUZZLE],
		[34,:DISCHARGE],
		[37,:SLAM],
		[42,:THUNDERBOLT],
		[45,:AGILITY],
		[50,:WILDCHARGE],
		[53,:LIGHTSCREEN],
		[58,:THUNDER]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:FLING,:THUNDER,:VOLTTACKLE,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:GRASSKNOT,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Yellow",
	:Habitat => "Forest",
	:EggGroups => [:Field,:Fairy],
	:Height => 4,
	:Weight => 60,
	:WildItemRare => :LIGHTBALL,
	:kind => "Mouse",
	:dexentry => "It stores electricity in the electric sacs on its cheeks. When it releases pent-up energy in a burst, the electric power is equal to a lightning bolt.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
	:evolutions => [
		[:RAICHU,:Item,:THUNDERSTONE]
	]
},

:RAICHU => {
	:name => "Raichu",
	:dexnum => 26,
	:Type1 => :ELECTRIC,
	:BaseStats => [60, 90, 55, 110, 90, 80],
	:EVs => [0, 0, 0, 3, 0, 0],
	:Abilities => [:STATIC,:LIGHTNINGROD],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 214,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 2805,
	:Moveset => [
		[1,:THUNDERSHOCK],
		[1,:TAILWHIP],
		[1,:QUICKATTACK],
		[1,:THUNDERBOLT]],
	:tmlist => [:SIGNALBEAM,:THIEF,:KNOCKOFF,:FLING,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:GRASSKNOT,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Yellow",
	:Habitat => "Forest",
	:EggGroups => [:Field,:Fairy],
	:Height => 8,
	:Weight => 300,
	:kind => "Mouse",
	:dexentry => "If it stores too much electricity, its behavior turns aggressive. To avoid this, it occasionally discharges excess energy and calms itself down.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:SANDSHREW => {
	:name => "Sandshrew",
	:dexnum => 27,
	:Type1 => :GROUND,
	:BaseStats => [50, 75, 85, 40, 20, 30],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SANDVEIL,:SANDRUSH],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CHIPAWAY,:COUNTER,:CRUSHCLAW,:ENDURE,:FLAIL,:HONECLAWS,:METALCLAW,:MUDSHOT,:NIGHTSLASH,:RAPIDSPIN,:ROCKCLIMB,:ROTOTILLER],
	:Moveset => [
		[1,:SCRATCH],
		[1,:DEFENSECURL],
		[3,:SANDATTACK],
		[5,:POISONSTING],
		[7,:ROLLOUT],
		[9,:RAPIDSPIN],
		[11,:FURYCUTTER],
		[14,:MAGNITUDE],
		[17,:SWIFT],
		[20,:FURYSWIPES],
		[23,:SANDTOMB],
		[26,:SLASH],
		[30,:DIG],
		[34,:GYROBALL],
		[38,:SWORDSDANCE],
		[42,:SANDSTORM],
		[46,:EARTHQUAKE]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:GYROBALL,:CONFIDE,:AURORAVEIL,:STOMPINGTANTRUM,],
	:Color => "Yellow",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 120,
	:WildItemUncommon => :GRIPCLAW,
	:kind => "Mouse",
	:dexentry => "When it curls up in a ball, it can make any attack bounce off harmlessly. Its hide has turned tough and solid as a result of living in the desert.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SANDSLASH,:Level,22]
	]
},

:SANDSLASH => {
	:name => "Sandslash",
	:dexnum => 28,
	:Type1 => :GROUND,
	:BaseStats => [75, 100, 110, 65, 45, 55],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SANDVEIL,:SANDRUSH],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 158,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:CRUSHCLAW],
		[1,:SCRATCH],
		[1,:DEFENSECURL],
		[1,:SANDATTACK],
		[1,:POISONSTING],
		[3,:SANDATTACK],
		[5,:POISONSTING],
		[7,:ROLLOUT],
		[9,:RAPIDSPIN],
		[11,:FURYCUTTER],
		[14,:MAGNITUDE],
		[17,:SWIFT],
		[20,:FURYSWIPES],
		[24,:SANDTOMB],
		[28,:SLASH],
		[33,:DIG],
		[38,:GYROBALL],
		[43,:SWORDSDANCE],
		[48,:SANDSTORM],
		[53,:EARTHQUAKE]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:GYROBALL,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Yellow",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 295,
	:WildItemUncommon => :GRIPCLAW,
	:kind => "Mouse",
	:dexentry => "It curls up in a ball to protect itself from enemy attacks. It also curls up to prevent heatstroke during the daytime when temperatures rise sharply.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:NIDORANfE => {
	:name => "Nidoran",
	:dexnum => 29,
	:Type1 => :POISON,
	:BaseStats => [55, 47, 52, 41, 40, 40],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:POISONPOINT,:RIVALRY],
	:HiddenAbilities => :HUSTLE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 55,
	:CatchRate => 235,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BEATUP,:CHARM,:CHIPAWAY,:COUNTER,:DISABLE,:ENDURE,:FOCUSENERGY,:IRONTAIL,:POISONTAIL,:PURSUIT,:SKULLBASH,:SUPERSONIC,:TAKEDOWN,:VENOMDRENCH],
	:Moveset => [
		[1,:GROWL],
		[1,:SCRATCH],
		[7,:TAILWHIP],
		[9,:DOUBLEKICK],
		[13,:POISONSTING],
		[19,:FURYSWIPES],
		[21,:BITE],
		[25,:HELPINGHAND],
		[31,:TOXICSPIKES],
		[33,:FLATTER],
		[37,:CRUNCH],
		[43,:CAPTIVATE],
		[45,:POISONFANG]],
	:tmlist => [:THIEF,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:MUDSLAP,:BLIZZARD,:ICEBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Field],
	:Height => 4,
	:Weight => 70,
	:kind => "Poison Pin",
	:dexentry => "Its highly toxic barbs are thought to have developed as protection for this small-bodied Pokémon. When enraged, it releases a horrible toxin from its horn.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:NIDORINA,:Level,16]
	]
},

:NIDORINA => {
	:name => "Nidorina",
	:dexnum => 30,
	:Type1 => :POISON,
	:BaseStats => [70, 62, 67, 56, 55, 55],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:POISONPOINT,:RIVALRY],
	:HiddenAbilities => :HUSTLE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 128,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:GROWL],
		[1,:SCRATCH],
		[7,:TAILWHIP],
		[9,:DOUBLEKICK],
		[13,:POISONSTING],
		[20,:FURYSWIPES],
		[23,:BITE],
		[28,:HELPINGHAND],
		[35,:TOXICSPIKES],
		[38,:FLATTER],
		[43,:CRUNCH],
		[50,:CAPTIVATE],
		[58,:POISONFANG]],
	:tmlist => [:THIEF,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:MUDSLAP,:BLIZZARD,:ICEBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Undiscovered],
	:Height => 8,
	:Weight => 200,
	:kind => "Poison Pin",
	:dexentry => "When it is with its friends or family, its barbs are tucked away to prevent injury. It appears to become nervous if separated from the others.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:NIDOQUEEN,:Item,:MOONSTONE]
	]
},

:NIDOQUEEN => {
	:name => "Nidoqueen",
	:dexnum => 31,
	:Type1 => :POISON,
	:Type2 => :GROUND,
	:BaseStats => [90, 92, 87, 76, 75, 85],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:POISONPOINT,:RIVALRY],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 223,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:SUPERPOWER],
		[1,:SCRATCH],
		[1,:TAILWHIP],
		[1,:DOUBLEKICK],
		[1,:POISONSTING],
		[23,:CHIPAWAY],
		[35,:BODYSLAM],
		[43,:EARTHPOWER],
		[58,:SUPERPOWER]],
	:tmlist => [:THIEF,:FLING,:QUASH,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Undiscovered],
	:Height => 13,
	:Weight => 600,
	:kind => "Drill",
	:dexentry => "It is adept at sending foes flying with harsh tackles using its tough, scaly body. This Pokémon is at its strongest when it is defending its young.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:NIDORANmA => {
	:name => "Nidoran",
	:dexnum => 32,
	:Type1 => :POISON,
	:BaseStats => [46, 57, 40, 50, 40, 40],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:POISONPOINT,:RIVALRY],
	:HiddenAbilities => :HUSTLE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemZero",
	:BaseEXP => 55,
	:CatchRate => 235,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:BEATUP,:CHIPAWAY,:CONFUSION,:COUNTER,:DISABLE,:ENDURE,:HEADSMASH,:IRONTAIL,:POISONTAIL,:SUCKERPUNCH,:SUPERSONIC,:TAKEDOWN,:VENOMDRENCH],
	:Moveset => [
		[1,:LEER],
		[1,:PECK],
		[7,:FOCUSENERGY],
		[9,:DOUBLEKICK],
		[13,:POISONSTING],
		[19,:FURYATTACK],
		[21,:HORNATTACK],
		[25,:HELPINGHAND],
		[31,:TOXICSPIKES],
		[33,:FLATTER],
		[37,:POISONJAB],
		[43,:CAPTIVATE],
		[45,:HORNDRILL]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWCLAW,:DRILLRUN,:MUDSLAP,:BLIZZARD,:ICEBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:SMARTSTRIKE,],
	:Color => "Purple",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Field],
	:Height => 5,
	:Weight => 90,
	:kind => "Poison Pin",
	:dexentry => "The male Nidoran has developed muscles that freely move its ears in any direction. Even the slightest sound does not escape this Pokémon's notice.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:NIDORINO,:Level,16]
	]
},

:NIDORINO => {
	:name => "Nidorino",
	:dexnum => 33,
	:Type1 => :POISON,
	:BaseStats => [61, 72, 57, 65, 55, 55],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:POISONPOINT,:RIVALRY],
	:HiddenAbilities => :HUSTLE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemZero",
	:BaseEXP => 128,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:LEER],
		[1,:PECK],
		[7,:FOCUSENERGY],
		[9,:DOUBLEKICK],
		[13,:POISONSTING],
		[20,:FURYATTACK],
		[23,:HORNATTACK],
		[28,:HELPINGHAND],
		[35,:TOXICSPIKES],
		[38,:FLATTER],
		[43,:POISONJAB],
		[50,:CAPTIVATE],
		[58,:HORNDRILL]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWCLAW,:DRILLRUN,:MUDSLAP,:BLIZZARD,:ICEBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:SMARTSTRIKE,:STOMPINGTANTRUM,],
	:Color => "Purple",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Field],
	:Height => 9,
	:Weight => 195,
	:kind => "Poison Pin",
	:dexentry => "Its horn is harder than a diamond. If it senses a hostile presence, all the barbs on its back bristle up at once, and it challenges the foe with all its might.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:NIDOKING,:Item,:MOONSTONE]
	]
},

:NIDOKING => {
	:name => "Nidoking",
	:dexnum => 34,
	:Type1 => :POISON,
	:Type2 => :GROUND,
	:BaseStats => [81, 102, 77, 85, 85, 75],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:POISONPOINT,:RIVALRY],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemZero",
	:BaseEXP => 223,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:MEGAHORN],
		[1,:PECK],
		[1,:FOCUSENERGY],
		[1,:DOUBLEKICK],
		[1,:POISONSTING],
		[23,:CHIPAWAY],
		[35,:THRASH],
		[43,:EARTHPOWER],
		[58,:MEGAHORN]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:FLING,:QUASH,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:SMARTSTRIKE,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Purple",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Field],
	:Height => 14,
	:Weight => 620,
	:kind => "Drill",
	:dexentry => "A Nidoking's thick tail packs enormously destructive power capable of toppling a metal transmission tower. Once it goes on a rampage, there is no stopping it.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:CLEFAIRY => {
	:name => "Clefairy",
	:dexnum => 35,
	:Type1 => :FAIRY,
	:BaseStats => [70, 45, 48, 35, 60, 65],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:CUTECHARM,:MAGICGUARD],
	:HiddenAbilities => :FRIENDGUARD,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 113,
	:CatchRate => 150,
	:Happiness => 140,
	:EggSteps => 2805,
	:Moveset => [
		[1,:SPOTLIGHT],
		[1,:DISARMINGVOICE],
		[1,:POUND],
		[1,:GROWL],
		[1,:ENCORE],
		[7,:SING],
		[10,:DOUBLESLAP],
		[13,:DEFENSECURL],
		[16,:FOLLOWME],
		[19,:BESTOW],
		[22,:WAKEUPSLAP],
		[25,:MINIMIZE],
		[28,:STOREDPOWER],
		[31,:METRONOME],
		[34,:COSMICPOWER],
		[37,:LUCKYCHANT],
		[40,:BODYSLAM],
		[43,:MOONLIGHT],
		[46,:MOONBLAST],
		[49,:GRAVITY],
		[50,:METEORMASH],
		[55,:HEALINGWISH],
		[58,:AFTERYOU]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:FLING,:SNATCH,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:WONDERROOM,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,],
	:Color => "Pink",
	:Habitat => "Mountain",
	:EggGroups => [:Fairy],
	:Height => 6,
	:Weight => 75,
	:WildItemUncommon => :MOONSTONE,
	:kind => "Fairy",
	:dexentry => "On every night of a full moon, they come out to play. When dawn arrives, the tired Clefairy go to sleep nestled up against each other in deep and quiet mountains.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CLEFABLE,:Item,:MOONSTONE]
	]
},

:CLEFABLE => {
	:name => "Clefable",
	:dexnum => 36,
	:Type1 => :FAIRY,
	:BaseStats => [95, 70, 73, 60, 95, 90],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:CUTECHARM,:MAGICGUARD],
	:HiddenAbilities => :UNAWARE,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 213,
	:CatchRate => 25,
	:Happiness => 140,
	:EggSteps => 2805,
	:Moveset => [
		[1,:SPOTLIGHT],
		[1,:DISARMINGVOICE],
		[1,:SING],
		[1,:DOUBLESLAP],
		[1,:MINIMIZE],
		[1,:METRONOME]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:FLING,:SNATCH,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:WONDERROOM,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Pink",
	:Habitat => "Mountain",
	:EggGroups => [:Fairy],
	:Height => 13,
	:Weight => 400,
	:WildItemUncommon => :MOONSTONE,
	:kind => "Fairy",
	:dexentry => "A Clefable uses its wings to skip lightly as if it were flying. Its bouncy step lets it even walk on water. On quiet, moonlit nights, it strolls on lakes.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
},

:VULPIX => {
	:name => "Vulpix",
	:dexnum => 37,
	:Type1 => :FIRE,
	:BaseStats => [38, 41, 40, 65, 50, 65],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:FLASHFIRE,:DROUGHT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 60,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CAPTIVATE,:DISABLE,:EXTRASENSORY,:FEINTATTACK,:FLAIL,:FLAREBLITZ,:HEATWAVE,:HEX,:HOWL,:HYPNOSIS,:POWERSWAP,:SECRETPOWER,:SPITE,:TAILSLAP],
	:Moveset => [
		[1,:EMBER],
		[4,:TAILWHIP],
		[7,:ROAR],
		[9,:BABYDOLLEYES],
		[10,:QUICKATTACK],
		[12,:CONFUSERAY],
		[15,:FIRESPIN],
		[18,:PAYBACK],
		[20,:WILLOWISP],
		[23,:FEINTATTACK],
		[26,:HEX],
		[28,:FLAMEBURST],
		[31,:EXTRASENSORY],
		[34,:SAFEGUARD],
		[36,:FLAMETHROWER],
		[39,:IMPRISON],
		[42,:FIREBLAST],
		[44,:GRUDGE],
		[47,:CAPTIVATE],
		[50,:INFERNO]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:PAYBACK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:OMINOUSWIND,:SPITE,:ENERGYBALL,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:MAGICCOAT,:REST,:IRONTAIL,:CONFIDE,:CELEBRATE,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 99,
	:WildItemUncommon => :CHARCOAL,
	:kind => "Fox",
	:dexentry => "At the time of its birth, Vulpix has one white tail. It separates into six if this Pokémon receives plenty of love. The six tails become magnificently curled.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:NINETALES,:Item,:FIRESTONE]
	]
},

:NINETALES => {
	:name => "Ninetales",
	:dexnum => 38,
	:Type1 => :FIRE,
	:BaseStats => [73, 76, 75, 100, 81, 100],
	:EVs => [0, 0, 0, 1, 0, 1],
	:Abilities => [:FLASHFIRE,:DROUGHT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 177,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:IMPRISON],
		[1,:NASTYPLOT],
		[1,:FLAMETHROWER],
		[1,:QUICKATTACK],
		[1,:CONFUSERAY],
		[1,:SAFEGUARD]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:PAYBACK,:OMINOUSWIND,:SPITE,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:MAGICCOAT,:REST,:IRONTAIL,:CONFIDE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 11,
	:Weight => 199,
	:WildItemUncommon => :CHARCOAL,
	:kind => "Fox",
	:dexentry => "It has long been said that each of the nine tails embody an enchanted power. A long-lived Ninetales will have fur that shines like gold.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:JIGGLYPUFF => {
	:name => "Jigglypuff",
	:dexnum => 39,
	:Type1 => :NORMAL,
	:Type2 => :FAIRY,
	:BaseStats => [115, 45, 20, 20, 45, 25],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:CUTECHARM,:COMPETITIVE],
	:HiddenAbilities => :FRIENDGUARD,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 95,
	:CatchRate => 170,
	:Happiness => 70,
	:EggSteps => 2805,
	:Moveset => [
		[1,:SING],
		[3,:DEFENSECURL],
		[5,:POUND],
		[9,:PLAYNICE],
		[11,:DISARMINGVOICE],
		[14,:DISABLE],
		[17,:DOUBLESLAP],
		[20,:ROLLOUT],
		[22,:ROUND],
		[25,:STOCKPILE],
		[25,:SWALLOW],
		[25,:SPITUP],
		[27,:WAKEUPSLAP],
		[30,:REST],
		[32,:BODYSLAM],
		[35,:GYROBALL],
		[38,:MIMIC],
		[41,:HYPERVOICE],
		[45,:DOUBLEEDGE]],
	:tmlist => [:KNOCKOFF,:FLING,:SNATCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:ROLLOUT,:STEALTHROCK,:GYROBALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,],
	:Color => "Pink",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy],
	:Height => 5,
	:Weight => 55,
	:WildItemUncommon => :MOONSTONE,
	:kind => "Balloon",
	:dexentry => "Nothing can avoid falling asleep hearing a Jigglypuff's song. The sound waves of its singing voice match the brain waves of someone in a deep sleep.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WIGGLYTUFF,:Item,:MOONSTONE]
	]
},

:WIGGLYTUFF => {
	:name => "Wigglytuff",
	:dexnum => 40,
	:Type1 => :NORMAL,
	:Type2 => :FAIRY,
	:BaseStats => [140, 70, 45, 45, 85, 50],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:CUTECHARM,:COMPETITIVE],
	:HiddenAbilities => :FRISK,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 191,
	:CatchRate => 50,
	:Happiness => 70,
	:EggSteps => 2805,
	:Moveset => [
		[1,:DOUBLEEDGE],
		[1,:SING],
		[1,:DISABLE],
		[1,:DEFENSECURL],
		[1,:DOUBLESLAP],
		[1,:PLAYROUGH]],
	:tmlist => [:KNOCKOFF,:FLING,:SNATCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:ROLLOUT,:STEALTHROCK,:GYROBALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Pink",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy],
	:Height => 10,
	:Weight => 120,
	:WildItemUncommon => :MOONSTONE,
	:kind => "Balloon",
	:dexentry => "Its fur is the ultimate in luxuriousness. Sleeping alongside a Wigglytuff is simply divine. Its body expands seemingly without end when it inhales.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:ZUBAT => {
	:name => "Zubat",
	:dexnum => 41,
	:Type1 => :POISON,
	:Type2 => :FLYING,
	:BaseStats => [40, 45, 35, 55, 30, 40],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:INNERFOCUS,:INFILTRATOR],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 49,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BRAVEBIRD,:CURSE,:DEFOG,:FEINTATTACK,:GIGADRAIN,:GUST,:HYPNOSIS,:NASTYPLOT,:PURSUIT,:QUICKATTACK,:STEELWING,:VENOMDRENCH,:WHIRLWIND,:ZENHEADBUTT],
	:Moveset => [
		[1,:ABSORB],
		[5,:SUPERSONIC],
		[7,:ASTONISH],
		[11,:BITE],
		[13,:WINGATTACK],
		[17,:CONFUSERAY],
		[19,:AIRCUTTER],
		[23,:SWIFT],
		[25,:POISONFANG],
		[29,:MEANLOOK],
		[31,:LEECHLIFE],
		[35,:HAZE],
		[37,:VENOSHOCK],
		[41,:AIRSLASH],
		[43,:QUICKGUARD]],
	:tmlist => [:UTURN,:LEECHLIFE,:PAYBACK,:THIEF,:SNATCH,:TAUNT,:TORMENT,:TWISTER,:HEATWAVE,:SUNNYDAY,:FLY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:GIGADRAIN,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:ZENHEADBUTT,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:Habitat => "Cave",
	:EggGroups => [:Flying],
	:Height => 8,
	:Weight => 75,
	:kind => "Bat",
	:dexentry => "While living in pitch-black caverns, their eyes gradually grew shut and deprived them of vision. They use ultrasonic waves to detect obstacles.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 13,
	:evolutions => [
		[:GOLBAT,:Level,22]
	]
},

:GOLBAT => {
	:name => "Golbat",
	:dexnum => 42,
	:Type1 => :POISON,
	:Type2 => :FLYING,
	:BaseStats => [75, 80, 70, 90, 65, 75],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:INNERFOCUS,:INFILTRATOR],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 159,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:SCREECH],
		[1,:ABSORB],
		[1,:SUPERSONIC],
		[1,:ASTONISH],
		[1,:BITE],
		[5,:SUPERSONIC],
		[7,:ASTONISH],
		[11,:BITE],
		[13,:WINGATTACK],
		[17,:CONFUSERAY],
		[19,:AIRCUTTER],
		[24,:SWIFT],
		[27,:POISONFANG],
		[32,:MEANLOOK],
		[35,:LEECHLIFE],
		[40,:HAZE],
		[43,:VENOSHOCK],
		[48,:AIRSLASH],
		[51,:QUICKGUARD]],
	:tmlist => [:UTURN,:LEECHLIFE,:PAYBACK,:THIEF,:SNATCH,:TAUNT,:TORMENT,:TWISTER,:HEATWAVE,:SUNNYDAY,:FLY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:ZENHEADBUTT,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:Habitat => "Cave",
	:EggGroups => [:Flying],
	:Height => 16,
	:Weight => 550,
	:kind => "Bat",
	:dexentry => "Its fangs puncture even thick hide. It loves to feast on the blood of people and Pokémon. It flits about in darkness and strikes from behind.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 12,
	:evolutions => [
		[:CROBAT,:Happiness,0]
	]
},

:ODDISH => {
	:name => "Oddish",
	:dexnum => 43,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [45, 50, 55, 30, 75, 65],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:CHLOROPHYLL,:RUNAWAY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 64,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AFTERYOU,:CHARM,:FLAIL,:INGRAIN,:NATUREPOWER,:RAZORLEAF,:SECRETPOWER,:STRENGTHSAP,:SYNTHESIS,:TEETERDANCE,:TICKLE],
	:Moveset => [
		[1,:ABSORB],
		[1,:GROWTH],
		[5,:SWEETSCENT],
		[9,:ACID],
		[13,:POISONPOWDER],
		[14,:STUNSPORE],
		[15,:SLEEPPOWDER],
		[19,:MEGADRAIN],
		[23,:LUCKYCHANT],
		[27,:MOONLIGHT],
		[31,:GIGADRAIN],
		[35,:TOXIC],
		[39,:NATURALGIFT],
		[43,:MOONBLAST],
		[47,:GRASSYTERRAIN],
		[51,:PETALDANCE]],
	:tmlist => [:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Grass],
	:Height => 5,
	:Weight => 54,
	:WildItemUncommon => :ABSORBBULB,
	:kind => "Weed",
	:dexentry => "This Pokémon grows by absorbing moonlight. During the daytime, it buries itself, leaving only its leaves exposed to avoid detection by its enemies.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GLOOM,:Level,21]
	]
},

:GLOOM => {
	:name => "Gloom",
	:dexnum => 44,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [60, 65, 70, 40, 85, 75],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:CHLOROPHYLL,:STENCH],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 138,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ABSORB],
		[1,:GROWTH],
		[1,:SWEETSCENT],
		[1,:ACID],
		[5,:SWEETSCENT],
		[9,:ACID],
		[13,:POISONPOWDER],
		[14,:STUNSPORE],
		[15,:SLEEPPOWDER],
		[19,:MEGADRAIN],
		[24,:LUCKYCHANT],
		[29,:MOONLIGHT],
		[34,:GIGADRAIN],
		[39,:TOXIC],
		[44,:NATURALGIFT],
		[49,:PETALBLIZZARD],
		[54,:GRASSYTERRAIN],
		[59,:PETALDANCE]],
	:tmlist => [:FLING,:DRAINPUNCH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Grass],
	:Height => 8,
	:Weight => 86,
	:WildItemUncommon => :ABSORBBULB,
	:kind => "Weed",
	:dexentry => "A horribly noxious honey drools from its mouth. One whiff of the honey can result in memory loss. Some fans are said to enjoy this overwhelming stink, however.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:VILEPLUME,:Item,:LEAFSTONE],
		[:BELLOSSOM,:Item,:SUNSTONE]
	]
},

:VILEPLUME => {
	:name => "Vileplume",
	:dexnum => 45,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [75, 80, 85, 50, 110, 90],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:CHLOROPHYLL,:EFFECTSPORE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 216,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:MEGADRAIN],
		[1,:AROMATHERAPY],
		[1,:STUNSPORE],
		[1,:POISONPOWDER],
		[49,:PETALBLIZZARD],
		[59,:PETALDANCE],
		[69,:SOLARBEAM]],
	:tmlist => [:FLING,:DRAINPUNCH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Red",
	:Habitat => "Grassland",
	:EggGroups => [:Grass],
	:Height => 12,
	:Weight => 186,
	:WildItemUncommon => :ABSORBBULB,
	:kind => "Flower",
	:dexentry => "In seasons when it produces more pollen, the air around a Vileplume turns yellow with the powder as it walks. The pollen is highly toxic and causes paralysis.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:PARAS => {
	:name => "Paras",
	:dexnum => 46,
	:Type1 => :BUG,
	:Type2 => :GRASS,
	:BaseStats => [35, 70, 55, 25, 45, 55],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:EFFECTSPORE,:DRYSKIN],
	:HiddenAbilities => :DAMP,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 57,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:BUGBITE,:COUNTER,:CROSSPOISON,:ENDURE,:FELLSTINGER,:FLAIL,:GRASSYTERRAIN,:LEECHSEED,:METALCLAW,:NATURALGIFT,:PSYBEAM,:PURSUIT,:ROTOTILLER,:SCREECH,:SWEETSCENT,:WIDEGUARD],
	:Moveset => [
		[1,:SCRATCH],
		[6,:STUNSPORE],
		[6,:POISONPOWDER],
		[11,:ABSORB],
		[17,:FURYCUTTER],
		[22,:SPORE],
		[27,:SLASH],
		[33,:GROWTH],
		[38,:GIGADRAIN],
		[43,:AROMATHERAPY],
		[49,:RAGEPOWDER],
		[54,:XSCISSOR]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:LEECHLIFE,:STRINGSHOT,:THIEF,:KNOCKOFF,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:LIGHTSCREEN,:REST,:CONFIDE,],
	:Color => "Red",
	:Habitat => "Forest",
	:EggGroups => [:Bug,:Grass],
	:Height => 3,
	:Weight => 54,
	:WildItemCommon => :TINYMUSHROOM,
	:WildItemUncommon => :BIGMUSHROOM,
	:kind => "Mushroom",
	:dexentry => "A Paras has parasitic tochukaso mushrooms growing on its back. They grow by drawing nutrients from the host. They are valued as medicine.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 35,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PARASECT,:Level,24]
	]
},

:PARASECT => {
	:name => "Parasect",
	:dexnum => 47,
	:Type1 => :BUG,
	:Type2 => :GRASS,
	:BaseStats => [60, 95, 80, 30, 60, 80],
	:EVs => [0, 2, 1, 0, 0, 0],
	:Abilities => [:EFFECTSPORE,:DRYSKIN],
	:HiddenAbilities => :DAMP,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 142,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:CROSSPOISON],
		[1,:SCRATCH],
		[1,:STUNSPORE],
		[1,:POISONPOWDER],
		[1,:ABSORB],
		[6,:STUNSPORE],
		[6,:POISONPOWDER],
		[11,:ABSORB],
		[17,:FURYCUTTER],
		[22,:SPORE],
		[29,:SLASH],
		[37,:GROWTH],
		[44,:GIGADRAIN],
		[51,:AROMATHERAPY],
		[59,:RAGEPOWDER],
		[66,:XSCISSOR]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:LEECHLIFE,:STRINGSHOT,:THIEF,:KNOCKOFF,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:LIGHTSCREEN,:REST,:CONFIDE,:THROATCHOP,],
	:Color => "Red",
	:Habitat => "Forest",
	:EggGroups => [:Bug,:Grass],
	:Height => 10,
	:Weight => 295,
	:WildItemCommon => :TINYMUSHROOM,
	:WildItemUncommon => :BIGMUSHROOM,
	:kind => "Mushroom",
	:dexentry => "Parasect are known to infest the roots of large trees en masse and drain nutrients. When an infested tree dies, they move onto another tree all at once.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:VENONAT => {
	:name => "Venonat",
	:dexnum => 48,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [60, 55, 50, 45, 40, 55],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:COMPOUNDEYES,:TINTEDLENS],
	:HiddenAbilities => :RUNAWAY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:BATONPASS,:BUGBITE,:GIGADRAIN,:MORNINGSUN,:RAGEPOWDER,:SCREECH,:SECRETPOWER,:SIGNALBEAM,:SKILLSWAP,:TOXICSPIKES],
	:Moveset => [
		[1,:TACKLE],
		[1,:DISABLE],
		[1,:FORESIGHT],
		[5,:SUPERSONIC],
		[11,:CONFUSION],
		[13,:POISONPOWDER],
		[17,:PSYBEAM],
		[23,:STUNSPORE],
		[25,:SIGNALBEAM],
		[29,:SLEEPPOWDER],
		[35,:LEECHLIFE],
		[37,:ZENHEADBUTT],
		[41,:POISONFANG],
		[47,:PSYCHIC]],
	:tmlist => [:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:STRINGSHOT,:THIEF,:SUNNYDAY,:SOLARBEAM,:GIGADRAIN,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:PSYCHIC,:ZENHEADBUTT,:REST,:SKILLSWAP,:CONFIDE,:INFESTATION,],
	:Color => "Purple",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 10,
	:Weight => 300,
	:kind => "Insect",
	:dexentry => "Its coat of thin, stiff hair that covers its entire body is said to have evolved for protection. Its large eyes never fail to spot even miniscule prey.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
	:evolutions => [
		[:VENOMOTH,:Level,31]
	]
},

:VENOMOTH => {
	:name => "Venomoth",
	:dexnum => 49,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [70, 65, 60, 90, 90, 75],
	:EVs => [0, 0, 0, 1, 1, 0],
	:Abilities => [:SHIELDDUST,:TINTEDLENS],
	:HiddenAbilities => :WONDERSKIN,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 158,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:GUST],
		[1,:QUIVERDANCE],
		[1,:BUGBUZZ],
		[1,:SILVERWIND],
		[1,:TACKLE],
		[1,:DISABLE],
		[1,:FORESIGHT],
		[1,:SUPERSONIC],
		[5,:SUPERSONIC],
		[11,:CONFUSION],
		[13,:POISONPOWDER],
		[17,:PSYBEAM],
		[23,:STUNSPORE],
		[25,:SIGNALBEAM],
		[29,:SLEEPPOWDER],
		[37,:LEECHLIFE],
		[41,:ZENHEADBUTT],
		[47,:POISONFANG],
		[55,:PSYCHIC],
		[59,:BUGBUZZ],
		[63,:QUIVERDANCE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:STRINGSHOT,:THIEF,:TWISTER,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:PSYCHIC,:ZENHEADBUTT,:REST,:SKILLSWAP,:CONFIDE,:INFESTATION,],
	:Color => "Purple",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 15,
	:Weight => 125,
	:WildItemUncommon => :SHEDSHELL,
	:kind => "Poison Moth",
	:dexentry => "Venomoth are nocturnal-- they only are active at night. Their favorite prey are insects that gather around streetlights, attracted by the light.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 15,
},

:DIGLETT => {
	:name => "Diglett",
	:dexnum => 50,
	:Type1 => :GROUND,
	:BaseStats => [10, 55, 25, 95, 35, 45],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SANDVEIL,:ARENATRAP],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 53,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:ASTONISH,:BEATUP,:ENDURE,:FEINTATTACK,:FINALGAMBIT,:HEADBUTT,:MEMENTO,:MUDBOMB,:PURSUIT,:REVERSAL,:SCREECH,:UPROAR],
	:Moveset => [
		[1,:SCRATCH],
		[1,:SANDATTACK],
		[4,:GROWL],
		[7,:ASTONISH],
		[10,:MUDSLAP],
		[14,:MAGNITUDE],
		[18,:BULLDOZE],
		[22,:SUCKERPUNCH],
		[25,:MUDBOMB],
		[28,:EARTHPOWER],
		[31,:DIG],
		[35,:SLASH],
		[39,:EARTHQUAKE],
		[43,:FISSURE]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Cave",
	:EggGroups => [:Field],
	:Height => 2,
	:Weight => 8,
	:WildItemUncommon => :SOFTSAND,
	:kind => "Mole",
	:dexentry => "Diglett are raised in most farms. The reason is simple-- wherever they burrow, the soil is left perfectly tilled for growing delicious crops.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DUGTRIO,:Level,26]
	]
},

:DUGTRIO => {
	:name => "Dugtrio",
	:dexnum => 51,
	:Type1 => :GROUND,
	:BaseStats => [35, 100, 50, 120, 50, 70],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:SANDVEIL,:ARENATRAP],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 142,
	:CatchRate => 50,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SANDTOMB],
		[1,:ROTOTILLER],
		[1,:NIGHTSLASH],
		[1,:TRIATTACK],
		[1,:SCRATCH],
		[1,:SANDATTACK],
		[1,:GROWL],
		[4,:GROWL],
		[7,:ASTONISH],
		[10,:MUDSLAP],
		[14,:MAGNITUDE],
		[18,:BULLDOZE],
		[22,:SUCKERPUNCH],
		[25,:MUDBOMB],
		[30,:EARTHPOWER],
		[35,:DIG],
		[41,:SLASH],
		[47,:EARTHQUAKE],
		[53,:FISSURE]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Cave",
	:EggGroups => [:Field],
	:Height => 7,
	:Weight => 333,
	:WildItemUncommon => :SOFTSAND,
	:kind => "Mole",
	:dexentry => "Because the triplets originally split from one body, they think exactly alike. They work cooperatively to burrow endlessly through the ground.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
},

:MEOWTH => {
	:name => "Meowth",
	:dexnum => 52,
	:Type1 => :NORMAL,
	:BaseStats => [40, 45, 35, 90, 40, 40],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:PICKUP,:TECHNICIAN],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:ASSIST,:CHARM,:FLAIL,:FOULPLAY,:HYPNOSIS,:IRONTAIL,:LASTRESORT,:ODORSLEUTH,:PUNISHMENT,:SNATCH,:SPITE,:TAILWHIP],
	:Moveset => [
		[1,:SCRATCH],
		[1,:GROWL],
		[6,:BITE],
		[9,:FAKEOUT],
		[14,:FURYSWIPES],
		[17,:SCREECH],
		[22,:FEINTATTACK],
		[25,:TAUNT],
		[30,:PAYDAY],
		[33,:SLASH],
		[38,:NASTYPLOT],
		[41,:ASSURANCE],
		[46,:CAPTIVATE],
		[49,:NIGHTSLASH],
		[50,:FEINT]],
	:tmlist => [:UTURN,:FOULPLAY,:DARKPULSE,:PAYBACK,:THIEF,:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:SEEDBOMB,:MUDSLAP,:ICYWIND,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:DREAMEATER,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:THROATCHOP,],
	:Color => "Yellow",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 42,
	:WildItemUncommon => :QUICKCLAW,
	:kind => "Scratch Cat",
	:dexentry => "Meowth withdraw their sharp claws into their paws to silently sneak about. For some reason, this Pokémon loves shiny coins that glitter with light.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PERSIAN,:Level,28]
	]
},

:PERSIAN => {
	:name => "Persian",
	:dexnum => 53,
	:Type1 => :NORMAL,
	:BaseStats => [65, 70, 60, 115, 65, 65],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:LIMBER,:TECHNICIAN],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 154,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SWIFT],
		[1,:PLAYROUGH],
		[1,:SWITCHEROO],
		[1,:SCRATCH],
		[1,:GROWL],
		[1,:BITE],
		[1,:FAKEOUT],
		[6,:BITE],
		[9,:FAKEOUT],
		[14,:FURYSWIPES],
		[17,:SCREECH],
		[22,:FEINTATTACK],
		[25,:TAUNT],
		[32,:POWERGEM],
		[37,:SLASH],
		[44,:NASTYPLOT],
		[49,:ASSURANCE],
		[56,:CAPTIVATE],
		[61,:NIGHTSLASH],
		[65,:FEINT]],
	:tmlist => [:UTURN,:FOULPLAY,:DARKPULSE,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:SEEDBOMB,:MUDSLAP,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:DREAMEATER,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:THROATCHOP,],
	:Color => "Yellow",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 320,
	:WildItemUncommon => :QUICKCLAW,
	:kind => "Classy Cat",
	:dexentry => "A Persian's six bold whiskers sense air movements to determine what is in its vicinity. It becomes docile if grabbed by the whiskers.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:PSYDUCK => {
	:name => "Psyduck",
	:dexnum => 54,
	:Type1 => :WATER,
	:BaseStats => [50, 52, 48, 55, 65, 50],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:DAMP,:CLOUDNINE],
	:HiddenAbilities => :SWIFTSWIM,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 64,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CLEARSMOG,:CONFUSERAY,:CROSSCHOP,:ENCORE,:FORESIGHT,:FUTURESIGHT,:HYPNOSIS,:MUDBOMB,:PSYBEAM,:REFRESH,:SECRETPOWER,:SIMPLEBEAM,:SLEEPTALK,:SYNCHRONOISE,:YAWN],
	:Moveset => [
		[1,:WATERSPORT],
		[1,:SCRATCH],
		[4,:TAILWHIP],
		[7,:WATERGUN],
		[10,:CONFUSION],
		[13,:FURYSWIPES],
		[16,:WATERPULSE],
		[19,:DISABLE],
		[22,:SCREECH],
		[25,:ZENHEADBUTT],
		[28,:AQUATAIL],
		[31,:SOAK],
		[34,:PSYCHUP],
		[37,:AMNESIA],
		[40,:HYDROPUMP],
		[43,:WONDERROOM]],
	:tmlist => [:SIGNALBEAM,:FLING,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:AERIALACE,:SHADOWCLAW,:WORRYSEED,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REST,:TELEKINESIS,:WONDERROOM,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Yellow",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Field],
	:Height => 8,
	:Weight => 196,
	:kind => "Duck",
	:dexentry => "When its headache intensifies, it starts using strange powers. However, it has no recollection of its powers, so it always looks befuddled and bewildered.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GOLDUCK,:Level,33]
	]
},

:GOLDUCK => {
	:name => "Golduck",
	:dexnum => 55,
	:Type1 => :WATER,
	:BaseStats => [80, 82, 78, 85, 95, 80],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:DAMP,:CLOUDNINE],
	:HiddenAbilities => :SWIFTSWIM,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:MEFIRST],
		[1,:AQUAJET],
		[1,:WATERSPORT],
		[1,:SCRATCH],
		[1,:TAILWHIP],
		[1,:WATERGUN],
		[4,:TAILWHIP],
		[7,:WATERGUN],
		[10,:CONFUSION],
		[13,:FURYSWIPES],
		[16,:WATERPULSE],
		[19,:DISABLE],
		[22,:SCREECH],
		[25,:ZENHEADBUTT],
		[28,:AQUATAIL],
		[31,:SOAK],
		[36,:PSYCHUP],
		[41,:AMNESIA],
		[46,:HYDROPUMP],
		[51,:WONDERROOM]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:AERIALACE,:SHADOWCLAW,:WORRYSEED,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REST,:TELEKINESIS,:WONDERROOM,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:LIQUIDATION,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Field],
	:Height => 17,
	:Weight => 766,
	:kind => "Duck",
	:dexentry => "A Golduck is an adept swimmer. It sometimes joins competitive swimmers in training. It uses psychic powers when its forehead shimmers with light.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:MANKEY => {
	:name => "Mankey",
	:dexnum => 56,
	:Type1 => :FIGHTING,
	:BaseStats => [40, 80, 35, 70, 35, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:VITALSPIRIT,:ANGERPOINT],
	:HiddenAbilities => :DEFIANT,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BEATUP,:CLOSECOMBAT,:COUNTER,:ENCORE,:FOCUSPUNCH,:FORESIGHT,:MEDITATE,:NIGHTSLASH,:POWERTRIP,:REVENGE,:REVERSAL,:SLEEPTALK,:SMELLINGSALTS],
	:Moveset => [
		[1,:COVET],
		[1,:SCRATCH],
		[1,:LOWKICK],
		[1,:LEER],
		[1,:FOCUSENERGY],
		[5,:FURYSWIPES],
		[8,:KARATECHOP],
		[12,:PURSUIT],
		[15,:SEISMICTOSS],
		[19,:SWAGGER],
		[22,:CROSSCHOP],
		[26,:ASSURANCE],
		[29,:PUNISHMENT],
		[33,:THRASH],
		[36,:CLOSECOMBAT],
		[40,:SCREECH],
		[43,:STOMPINGTANTRUM],
		[47,:OUTRAGE],
		[50,:FINALGAMBIT]],
	:tmlist => [:UTURN,:PAYBACK,:THIEF,:FLING,:TAUNT,:OUTRAGE,:DUALCHOP,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:OVERHEAT,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:ACROBATICS,:SPITE,:SEEDBOMB,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:POISONJAB,:TOXIC,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:IRONTAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 280,
	:kind => "Pig Monkey",
	:dexentry => "When it starts shaking and its nasal breathing turns rough, it is a sure sign of anger. However, since this happens instantly, there is no time to flee.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PRIMEAPE,:Level,28]
	]
},

:PRIMEAPE => {
	:name => "Primeape",
	:dexnum => 57,
	:Type1 => :FIGHTING,
	:BaseStats => [65, 105, 60, 95, 60, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:VITALSPIRIT,:ANGERPOINT],
	:HiddenAbilities => :DEFIANT,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 159,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:RAGE],
		[1,:FINALGAMBIT],
		[1,:FLING],
		[1,:SCRATCH],
		[1,:LOWKICK],
		[1,:LEER],
		[1,:FOCUSENERGY],
		[5,:FURYSWIPES],
		[8,:KARATECHOP],
		[12,:PURSUIT],
		[15,:SEISMICTOSS],
		[19,:SWAGGER],
		[22,:CROSSCHOP],
		[26,:ASSURANCE],
		[30,:PUNISHMENT],
		[35,:THRASH],
		[39,:CLOSECOMBAT],
		[44,:SCREECH],
		[48,:STOMPINGTANTRUM],
		[53,:OUTRAGE],
		[57,:FINALGAMBIT]],
	:tmlist => [:UTURN,:PAYBACK,:THIEF,:FLING,:TAUNT,:OUTRAGE,:DUALCHOP,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:OVERHEAT,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:ACROBATICS,:SPITE,:SEEDBOMB,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:POISONJAB,:TOXIC,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:IRONTAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 320,
	:kind => "Pig Monkey",
	:dexentry => "It has been known to become so angry that it dies as a result. Its face looks peaceful in death, however.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:GROWLITHE => {
	:name => "Growlithe",
	:dexnum => 58,
	:Type1 => :FIRE,
	:BaseStats => [55, 70, 45, 60, 70, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:FLASHFIRE],
	:HiddenAbilities => :JUSTIFIED,
	:GrowthRate => "Slow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 70,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BODYSLAM,:BURNUP,:CLOSECOMBAT,:COVET,:CRUNCH,:DOUBLEKICK,:DOUBLEEDGE,:FIRESPIN,:FLAREBLITZ,:HEATWAVE,:HOWL,:IRONTAIL,:MORNINGSUN,:THRASH],
	:Moveset => [
		[1,:BITE],
		[1,:ROAR],
		[6,:EMBER],
		[8,:LEER],
		[10,:ODORSLEUTH],
		[12,:HELPINGHAND],
		[17,:FLAMEWHEEL],
		[19,:REVERSAL],
		[21,:FIREFANG],
		[23,:TAKEDOWN],
		[28,:FLAMEBURST],
		[30,:AGILITY],
		[32,:RETALIATE],
		[34,:FLAMETHROWER],
		[39,:CRUNCH],
		[41,:HEATWAVE],
		[43,:OUTRAGE],
		[45,:FLAREBLITZ]],
	:tmlist => [:SNARL,:THIEF,:OUTRAGE,:WILDCHARGE,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:IRONTAIL,:IRONHEAD,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 7,
	:Weight => 190,
	:kind => "Puppy",
	:dexentry => "Its superb sense of smell ensures that this Pokémon won't forget any scent, no matter what. It uses its sense of smell to detect the emotions of others.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ARCANINE,:Item,:FIRESTONE]
	]
},

:ARCANINE => {
	:name => "Arcanine",
	:dexnum => 59,
	:Type1 => :FIRE,
	:BaseStats => [90, 110, 80, 95, 100, 80],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:FLASHFIRE],
	:HiddenAbilities => :JUSTIFIED,
	:GrowthRate => "Slow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 194,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:THUNDERFANG],
		[1,:BITE],
		[1,:ROAR],
		[1,:ODORSLEUTH],
		[1,:FIREFANG],
		[34,:EXTREMESPEED]],
	:tmlist => [:SNARL,:THIEF,:OUTRAGE,:DRAGONPULSE,:WILDCHARGE,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SOLARBEAM,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:IRONTAIL,:IRONHEAD,:CONFIDE,:LASERFOCUS,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 19,
	:Weight => 1550,
	:kind => "Legendary",
	:dexentry => "This fleet-footed Pokémon is said to run over 6,200 miles in a single day and night. The fire that blazes wildly within its body is its source of power.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
},

:POLIWAG => {
	:name => "Poliwag",
	:dexnum => 60,
	:Type1 => :WATER,
	:BaseStats => [40, 50, 40, 90, 40, 40],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:WATERABSORB,:DAMP],
	:HiddenAbilities => :SWIFTSWIM,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BUBBLEBEAM,:ENCORE,:ENDEAVOR,:ENDURE,:HAZE,:ICEBALL,:MINDREADER,:MIST,:MUDSHOT,:REFRESH,:SPLASH,:WATERPULSE,:WATERSPORT],
	:Moveset => [
		[1,:WATERSPORT],
		[5,:WATERGUN],
		[8,:HYPNOSIS],
		[11,:BUBBLE],
		[15,:DOUBLESLAP],
		[18,:RAINDANCE],
		[21,:BODYSLAM],
		[25,:BUBBLEBEAM],
		[28,:MUDSHOT],
		[31,:BELLYDRUM],
		[35,:WAKEUPSLAP],
		[38,:HYDROPUMP],
		[41,:MUDBOMB]],
	:tmlist => [:THIEF,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:REST,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1],
	:Height => 6,
	:Weight => 124,
	:kind => "Tadpole",
	:dexentry => "It is possible to see this Pokémon's spiral innards right through its thin skin. However, the skin is also very flexible. Even sharp fangs bounce off it.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:POLIWHIRL,:Level,25]
	]
},

:POLIWHIRL => {
	:name => "Poliwhirl",
	:dexnum => 61,
	:Type1 => :WATER,
	:BaseStats => [65, 65, 65, 90, 50, 50],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:WATERABSORB,:DAMP],
	:HiddenAbilities => :SWIFTSWIM,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 135,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:WATERSPORT],
		[1,:WATERGUN],
		[1,:HYPNOSIS],
		[5,:WATERGUN],
		[8,:HYPNOSIS],
		[11,:BUBBLE],
		[15,:DOUBLESLAP],
		[18,:RAINDANCE],
		[21,:BODYSLAM],
		[27,:BUBBLEBEAM],
		[32,:MUDSHOT],
		[37,:BELLYDRUM],
		[43,:WAKEUPSLAP],
		[48,:HYDROPUMP],
		[53,:MUDBOMB]],
	:tmlist => [:THIEF,:FLING,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:REST,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1],
	:Height => 10,
	:Weight => 200,
	:WildItemUncommon => :KINGSROCK,
	:kind => "Tadpole",
	:dexentry => "Its body surface is always wet and slick with an oily fluid. Because of this greasy covering, it can easily slip and slide out of the clutches of any enemy in battle.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:POLIWRATH,:Item,:WATERSTONE],
		[:POLITOED,:TradeItem,:KINGSROCK]
	]
},

:POLIWRATH => {
	:name => "Poliwrath",
	:dexnum => 62,
	:Type1 => :WATER,
	:Type2 => :FIGHTING,
	:BaseStats => [90, 95, 95, 70, 70, 90],
	:EVs => [0, 0, 3, 0, 0, 0],
	:Abilities => [:WATERABSORB,:DAMP],
	:HiddenAbilities => :SWIFTSWIM,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 225,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SUBMISSION],
		[1,:CIRCLETHROW],
		[1,:BUBBLEBEAM],
		[1,:HYPNOSIS],
		[1,:DOUBLESLAP],
		[32,:DYNAMICPUNCH],
		[43,:MINDREADER],
		[53,:CIRCLETHROW]],
	:tmlist => [:PAYBACK,:THIEF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:BULKUP,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:PSYCHIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:THROATCHOP,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1],
	:Height => 13,
	:Weight => 540,
	:WildItemUncommon => :KINGSROCK,
	:kind => "Tadpole",
	:dexentry => "Its highly developed muscles never grow fatigued, however much it exercises. This Pokémon can swim back and forth across an entire ocean without effort.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:ABRA => {
	:name => "Abra",
	:dexnum => 63,
	:Type1 => :PSYCHIC,
	:BaseStats => [25, 20, 15, 90, 105, 55],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:SYNCHRONIZE,:INNERFOCUS],
	:HiddenAbilities => :MAGICGUARD,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 62,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ALLYSWITCH,:BARRIER,:ENCORE,:FIREPUNCH,:GUARDSPLIT,:GUARDSWAP,:ICEPUNCH,:KNOCKOFF,:POWERTRICK,:PSYCHICTERRAIN,:PSYCHOSHIFT,:SKILLSWAP,:THUNDERPUNCH],
	:Moveset => [
		[1,:TELEPORT]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:DRAINPUNCH,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:ICEPUNCH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Brown",
	:Habitat => "Urban",
	:EggGroups => [:HumanLike],
	:Height => 9,
	:Weight => 195,
	:WildItemUncommon => :TWISTEDSPOON,
	:kind => "Psi",
	:dexentry => "A Pokémon that sleeps 18 hours a day. Observation revealed that it uses Teleport to change its location once every hour.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:KADABRA,:Level,16]
	]
},

:KADABRA => {
	:name => "Kadabra",
	:dexnum => 64,
	:Type1 => :PSYCHIC,
	:BaseStats => [40, 35, 30, 105, 120, 70],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:SYNCHRONIZE,:INNERFOCUS],
	:HiddenAbilities => :MAGICGUARD,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 140,
	:CatchRate => 100,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:KINESIS],
		[1,:TELEPORT],
		[1,:CONFUSION],
		[16,:CONFUSION],
		[18,:DISABLE],
		[21,:PSYBEAM],
		[23,:MIRACLEEYE],
		[26,:REFLECT],
		[28,:PSYCHOCUT],
		[31,:RECOVER],
		[33,:TELEKINESIS],
		[36,:ALLYSWITCH],
		[38,:PSYCHIC],
		[41,:ROLEPLAY],
		[43,:FUTURESIGHT],
		[46,:TRICK]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:DRAINPUNCH,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:ICEPUNCH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Brown",
	:Habitat => "Urban",
	:EggGroups => [:HumanLike],
	:Height => 13,
	:Weight => 565,
	:WildItemUncommon => :TWISTEDSPOON,
	:kind => "Psi",
	:dexentry => "It is rumored that a boy with psychic abilities suddenly transformed into Kadabra while he was assisting research into extrasensory powers.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ALAKAZAM,:Trade,0]
	]
},

:ALAKAZAM => {
	:name => "Alakazam",
	:dexnum => 65,
	:Type1 => :PSYCHIC,
	:BaseStats => [55, 50, 45, 120, 135, 95],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:SYNCHRONIZE,:INNERFOCUS],
	:HiddenAbilities => :MAGICGUARD,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 221,
	:CatchRate => 50,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:KINESIS],
		[1,:TELEPORT],
		[1,:CONFUSION],
		[16,:CONFUSION],
		[18,:DISABLE],
		[21,:PSYBEAM],
		[23,:MIRACLEEYE],
		[26,:REFLECT],
		[28,:PSYCHOCUT],
		[31,:RECOVER],
		[33,:TELEKINESIS],
		[36,:ALLYSWITCH],
		[38,:PSYCHIC],
		[41,:CALMMIND],
		[43,:FUTURESIGHT],
		[46,:TRICK]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:DRAINPUNCH,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,],
	:Color => "Brown",
	:Habitat => "Urban",
	:EggGroups => [:HumanLike],
	:Height => 15,
	:Weight => 480,
	:WildItemUncommon => :TWISTEDSPOON,
	:kind => "Psi",
	:dexentry => "While it has strong psychic abilities and high intelligence, an Alakazam's muscles are very weak. It uses psychic power to move its body.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:MACHOP => {
	:name => "Machop",
	:dexnum => 66,
	:Type1 => :FIGHTING,
	:BaseStats => [70, 80, 50, 35, 35, 35],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:GUTS,:NOGUARD],
	:HiddenAbilities => :STEADFAST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 61,
	:CatchRate => 180,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BULLETPUNCH,:CLOSECOMBAT,:COUNTER,:ENCORE,:FIREPUNCH,:HEAVYSLAM,:ICEPUNCH,:KNOCKOFF,:MEDITATE,:POWERTRICK,:QUICKGUARD,:ROLLINGKICK,:SMELLINGSALTS,:THUNDERPUNCH,:TICKLE],
	:Moveset => [
		[1,:LOWKICK],
		[1,:LEER],
		[3,:FOCUSENERGY],
		[7,:KARATECHOP],
		[9,:FORESIGHT],
		[13,:LOWSWEEP],
		[15,:SEISMICTOSS],
		[19,:REVENGE],
		[21,:KNOCKOFF],
		[25,:VITALTHROW],
		[27,:WAKEUPSLAP],
		[31,:DUALCHOP],
		[33,:SUBMISSION],
		[37,:BULKUP],
		[39,:CROSSCHOP],
		[43,:SCARYFACE],
		[45,:DYNAMICPUNCH]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:LIGHTSCREEN,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Gray",
	:Habitat => "Mountain",
	:EggGroups => [:HumanLike],
	:Height => 8,
	:Weight => 195,
	:WildItemUncommon => :FOCUSBAND,
	:kind => "Superpower",
	:dexentry => "It continually undertakes strenuous training to master all forms of martial arts. Its strength lets it easily hoist a sumo wrestler onto its shoulders.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MACHOKE,:Level,28]
	]
},

:MACHOKE => {
	:name => "Machoke",
	:dexnum => 67,
	:Type1 => :FIGHTING,
	:BaseStats => [80, 100, 70, 45, 50, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:GUTS,:NOGUARD],
	:HiddenAbilities => :STEADFAST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 142,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:LOWKICK],
		[1,:LEER],
		[1,:FOCUSENERGY],
		[1,:KARATECHOP],
		[3,:FOCUSENERGY],
		[7,:KARATECHOP],
		[9,:FORESIGHT],
		[13,:LOWSWEEP],
		[15,:SEISMICTOSS],
		[19,:REVENGE],
		[21,:KNOCKOFF],
		[25,:VITALTHROW],
		[27,:WAKEUPSLAP],
		[33,:DUALCHOP],
		[37,:SUBMISSION],
		[43,:BULKUP],
		[47,:CROSSCHOP],
		[53,:SCARYFACE],
		[57,:DYNAMICPUNCH]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:LIGHTSCREEN,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "Mountain",
	:EggGroups => [:HumanLike],
	:Height => 15,
	:Weight => 705,
	:WildItemUncommon => :FOCUSBAND,
	:kind => "Superpower",
	:dexentry => "A belt is worn by a Machoke to keep its overwhelming power under control. Because it is so dangerous, no one has ever removed the belt.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MACHAMP,:Trade,0]
	]
},

:MACHAMP => {
	:name => "Machamp",
	:dexnum => 68,
	:Type1 => :FIGHTING,
	:BaseStats => [90, 130, 80, 55, 65, 85],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:GUTS,:NOGUARD],
	:HiddenAbilities => :STEADFAST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 227,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:STRENGTH],
		[1,:WIDEGUARD],
		[1,:LOWKICK],
		[1,:LEER],
		[1,:FOCUSENERGY],
		[1,:KARATECHOP],
		[3,:FOCUSENERGY],
		[7,:KARATECHOP],
		[9,:FORESIGHT],
		[13,:LOWSWEEP],
		[15,:SEISMICTOSS],
		[19,:REVENGE],
		[21,:KNOCKOFF],
		[25,:VITALTHROW],
		[27,:WAKEUPSLAP],
		[33,:DUALCHOP],
		[37,:SUBMISSION],
		[43,:BULKUP],
		[47,:CROSSCHOP],
		[53,:SCARYFACE],
		[57,:DYNAMICPUNCH]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:LIGHTSCREEN,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Gray",
	:Habitat => "Mountain",
	:EggGroups => [:HumanLike],
	:Height => 16,
	:Weight => 1300,
	:WildItemUncommon => :FOCUSBAND,
	:kind => "Superpower",
	:dexentry => "It is impossible to defend against punches and chops doled out by its four arms. Its fighting spirit flares up when it faces a tough opponent.",
	:BattlerPlayerY => 10,
	:BattlerEnemyY => 3,
	:BattlerAltitude => 0,
},

:BELLSPROUT => {
	:name => "Bellsprout",
	:dexnum => 69,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [50, 75, 35, 40, 70, 30],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:GLUTTONY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACIDSPRAY,:BELCH,:BULLETSEED,:CLEARSMOG,:ENCORE,:GIGADRAIN,:INGRAIN,:LEECHLIFE,:MAGICALLEAF,:NATURALGIFT,:POWERWHIP,:STRENGTHSAP,:SYNTHESIS,:TICKLE,:WEATHERBALL,:WORRYSEED],
	:Moveset => [
		[1,:VINEWHIP],
		[7,:GROWTH],
		[11,:WRAP],
		[13,:SLEEPPOWDER],
		[15,:POISONPOWDER],
		[17,:STUNSPORE],
		[23,:ACID],
		[27,:KNOCKOFF],
		[29,:SWEETSCENT],
		[35,:GASTROACID],
		[39,:RAZORLEAF],
		[41,:POISONJAB],
		[47,:SLAM],
		[50,:WRINGOUT]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:KNOCKOFF,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:GASTROACID,:TOXIC,:REFLECT,:REST,:CONFIDE,:INFESTATION,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Grass],
	:Height => 7,
	:Weight => 40,
	:kind => "Flower",
	:dexentry => "A Bellsprout's thin and flexible body lets it bend and sway to avoid any attack, however strong it may be. Its mouth leaks a fluid that melts even iron.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WEEPINBELL,:Level,21]
	]
},

:WEEPINBELL => {
	:name => "Weepinbell",
	:dexnum => 70,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [65, 90, 50, 55, 85, 45],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:GLUTTONY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 137,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:VINEWHIP],
		[1,:GROWTH],
		[1,:WRAP],
		[7,:GROWTH],
		[11,:WRAP],
		[13,:SLEEPPOWDER],
		[15,:POISONPOWDER],
		[17,:STUNSPORE],
		[24,:ACID],
		[29,:KNOCKOFF],
		[32,:SWEETSCENT],
		[39,:GASTROACID],
		[44,:RAZORLEAF],
		[47,:POISONJAB],
		[54,:SLAM],
		[58,:WRINGOUT]],
	:tmlist => [:BUGBITE,:SUCKERPUNCH,:THIEF,:KNOCKOFF,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:GASTROACID,:TOXIC,:REFLECT,:REST,:CONFIDE,:INFESTATION,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Grass],
	:Height => 10,
	:Weight => 64,
	:kind => "Flycatcher",
	:dexentry => "At night, a Weepinbell hangs on to a tree branch with its hooked rear and sleeps. If it moves around in its sleep, it may wake up to find itself on the ground.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 10,
	:evolutions => [
		[:VICTREEBEL,:Item,:LEAFSTONE]
	]
},

:VICTREEBEL => {
	:name => "Victreebel",
	:dexnum => 71,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [80, 105, 65, 70, 100, 70],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:GLUTTONY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 216,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:LEAFTORNADO],
		[1,:STOCKPILE],
		[1,:SWALLOW],
		[1,:SPITUP],
		[1,:VINEWHIP],
		[1,:SLEEPPOWDER],
		[1,:RAZORLEAF],
		[1,:SWEETSCENT],
		[32,:LEAFSTORM],
		[44,:LEAFBLADE]],
	:tmlist => [:BUGBITE,:SUCKERPUNCH,:THIEF,:KNOCKOFF,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:GASTROACID,:TOXIC,:REFLECT,:REST,:CONFIDE,:INFESTATION,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Grass],
	:Height => 17,
	:Weight => 155,
	:kind => "Flycatcher",
	:dexentry => "The long vine extending from its head is waved about as if it were a living thing to attract prey. When an unsuspecting victim approaches, it is swallowed whole.",
	:BattlerPlayerY => 10,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 11,
},

:TENTACOOL => {
	:name => "Tentacool",
	:dexnum => 72,
	:Type1 => :WATER,
	:Type2 => :POISON,
	:BaseStats => [40, 40, 35, 70, 50, 100],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:CLEARBODY,:LIQUIDOOZE],
	:HiddenAbilities => :RAINDISH,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 67,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACUPRESSURE,:AQUARING,:AURORABEAM,:BUBBLE,:CONFUSERAY,:HAZE,:KNOCKOFF,:MIRRORCOAT,:MUDDYWATER,:RAPIDSPIN,:TICKLE],
	:Moveset => [
		[1,:POISONSTING],
		[4,:SUPERSONIC],
		[7,:CONSTRICT],
		[10,:ACID],
		[13,:TOXICSPIKES],
		[16,:WATERPULSE],
		[19,:WRAP],
		[22,:ACIDSPRAY],
		[25,:BUBBLEBEAM],
		[28,:BARRIER],
		[31,:POISONJAB],
		[34,:BRINE],
		[37,:SCREECH],
		[40,:HEX],
		[43,:SLUDGEWAVE],
		[46,:HYDROPUMP],
		[49,:WRINGOUT]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:GIGADRAIN,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:ROLEPLAY,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water3],
	:Height => 9,
	:Weight => 455,
	:WildItemUncommon => :POISONBARB,
	:kind => "Jellyfish",
	:dexentry => "Its body is almost entirely composed of water. It ensnares its foe with its two long tentacles, then stabs with the poison stingers at their tips.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 8,
	:evolutions => [
		[:TENTACRUEL,:Level,30]
	]
},

:TENTACRUEL => {
	:name => "Tentacruel",
	:dexnum => 73,
	:Type1 => :WATER,
	:Type2 => :POISON,
	:BaseStats => [80, 70, 65, 100, 80, 120],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:CLEARBODY,:LIQUIDOOZE],
	:HiddenAbilities => :RAINDISH,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 180,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:REFLECTTYPE],
		[1,:WRINGOUT],
		[1,:POISONSTING],
		[1,:SUPERSONIC],
		[1,:CONSTRICT],
		[1,:ACID],
		[4,:SUPERSONIC],
		[7,:CONSTRICT],
		[10,:ACID],
		[13,:TOXICSPIKES],
		[16,:WATERPULSE],
		[19,:WRAP],
		[22,:ACIDSPRAY],
		[25,:BUBBLEBEAM],
		[28,:BARRIER],
		[32,:POISONJAB],
		[36,:BRINE],
		[40,:SCREECH],
		[44,:HEX],
		[48,:SLUDGEWAVE],
		[52,:HYDROPUMP],
		[56,:WRINGOUT]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:GIGADRAIN,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:ROLEPLAY,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water3],
	:Height => 16,
	:Weight => 550,
	:WildItemUncommon => :POISONBARB,
	:kind => "Jellyfish",
	:dexentry => "It lives in complex rock formations on the ocean floor and traps prey using its 80 tentacles. Its red orbs glow when it grows excited or agitated.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 7,
},

:GEODUDE => {
	:name => "Geodude",
	:dexnum => 74,
	:Type1 => :ROCK,
	:Type2 => :GROUND,
	:BaseStats => [40, 80, 100, 20, 30, 30],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:STURDY],
	:HiddenAbilities => :SANDVEIL,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:AUTOTOMIZE,:BLOCK,:CURSE,:ENDURE,:FLAIL,:FOCUSPUNCH,:HAMMERARM,:MEGAPUNCH,:ROCKCLIMB,:WIDEGUARD],
	:Moveset => [
		[1,:TACKLE],
		[1,:DEFENSECURL],
		[4,:MUDSPORT],
		[6,:ROCKPOLISH],
		[10,:ROLLOUT],
		[12,:MAGNITUDE],
		[16,:ROCKTHROW],
		[18,:SMACKDOWN],
		[22,:BULLDOZE],
		[24,:SELFDESTRUCT],
		[28,:STEALTHROCK],
		[30,:ROCKBLAST],
		[34,:EARTHQUAKE],
		[36,:EXPLOSION],
		[40,:DOUBLEEDGE],
		[42,:STONEEDGE]],
	:tmlist => [:SUCKERPUNCH,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:GYROBALL,:IRONDEFENSE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Mineral],
	:Height => 4,
	:Weight => 200,
	:WildItemUncommon => :EVERSTONE,
	:kind => "Rock",
	:dexentry => "It climbs mountain paths using only the power of its arms. Because they look just like boulders lining paths, hikers may step on them without noticing.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 16,
	:evolutions => [
		[:GRAVELER,:Level,25]
	]
},

:GRAVELER => {
	:name => "Graveler",
	:dexnum => 75,
	:Type1 => :ROCK,
	:Type2 => :GROUND,
	:BaseStats => [55, 95, 115, 35, 45, 45],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:STURDY],
	:HiddenAbilities => :SANDVEIL,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 137,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:TACKLE],
		[1,:DEFENSECURL],
		[1,:MUDSPORT],
		[1,:ROCKPOLISH],
		[4,:MUDSPORT],
		[6,:ROCKPOLISH],
		[10,:ROLLOUT],
		[12,:MAGNITUDE],
		[16,:ROCKTHROW],
		[18,:SMACKDOWN],
		[22,:BULLDOZE],
		[24,:SELFDESTRUCT],
		[30,:STEALTHROCK],
		[34,:ROCKBLAST],
		[40,:EARTHQUAKE],
		[44,:EXPLOSION],
		[50,:DOUBLEEDGE],
		[54,:STONEEDGE]],
	:tmlist => [:SUCKERPUNCH,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:GYROBALL,:IRONDEFENSE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Mineral],
	:Height => 10,
	:Weight => 1050,
	:WildItemUncommon => :EVERSTONE,
	:kind => "Rock",
	:dexentry => "They descend from mountains by tumbling down steep slopes. They are so brutal, they smash aside trees and massive boulders with thunderous tackles.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GOLEM,:Trade,0]
	]
},

:GOLEM => {
	:name => "Golem",
	:dexnum => 76,
	:Type1 => :ROCK,
	:Type2 => :GROUND,
	:BaseStats => [80, 120, 130, 45, 55, 65],
	:EVs => [0, 0, 3, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:STURDY],
	:HiddenAbilities => :SANDVEIL,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 218,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:HEAVYSLAM],
		[1,:TACKLE],
		[1,:DEFENSECURL],
		[1,:MUDSPORT],
		[1,:ROCKPOLISH],
		[4,:MUDSPORT],
		[6,:ROCKPOLISH],
		[10,:STEAMROLLER],
		[12,:MAGNITUDE],
		[16,:ROCKTHROW],
		[18,:SMACKDOWN],
		[22,:BULLDOZE],
		[24,:SELFDESTRUCT],
		[30,:STEALTHROCK],
		[34,:ROCKBLAST],
		[40,:EARTHQUAKE],
		[44,:EXPLOSION],
		[50,:DOUBLEEDGE],
		[54,:STONEEDGE],
		[60,:HEAVYSLAM]],
	:tmlist => [:FURYCUTTER,:SUCKERPUNCH,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:GYROBALL,:IRONDEFENSE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Mineral],
	:Height => 14,
	:Weight => 3000,
	:WildItemUncommon => :EVERSTONE,
	:kind => "Megaton",
	:dexentry => "It is said to live in volcanic craters on mountain peaks. Once a year, it sheds its hide and grows larger. The shed hide crumbles and returns to the soil.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:PONYTA => {
	:name => "Ponyta",
	:dexnum => 77,
	:Type1 => :FIRE,
	:BaseStats => [50, 85, 55, 90, 65, 65],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:RUNAWAY,:FLASHFIRE],
	:HiddenAbilities => :FLAMEBODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 82,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ALLYSWITCH,:CAPTIVATE,:CHARM,:DOUBLEKICK,:DOUBLEEDGE,:FLAMEWHEEL,:HIGHHORSEPOWER,:HORNDRILL,:HYPNOSIS,:LOWKICK,:MORNINGSUN,:THRASH],
	:Moveset => [
		[1,:GROWL],
		[1,:TACKLE],
		[4,:TAILWHIP],
		[9,:EMBER],
		[13,:FLAMEWHEEL],
		[17,:STOMP],
		[21,:FLAMECHARGE],
		[25,:FIRESPIN],
		[29,:TAKEDOWN],
		[33,:INFERNO],
		[37,:AGILITY],
		[41,:FIREBLAST],
		[45,:BOUNCE],
		[49,:FLAREBLITZ]],
	:tmlist => [:WILDCHARGE,:LOWKICK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:BOUNCE,:SOLARBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:REST,:IRONTAIL,:CONFIDE,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 300,
	:kind => "Fire Horse",
	:dexentry => "A Ponyta is very weak at birth. It can barely stand up. Its legs become stronger as it stumbles and falls while trying to keep up with its parent.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
	:evolutions => [
		[:RAPIDASH,:Level,40]
	]
},

:RAPIDASH => {
	:name => "Rapidash",
	:dexnum => 78,
	:Type1 => :FIRE,
	:BaseStats => [65, 100, 70, 105, 80, 80],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:RUNAWAY,:FLASHFIRE],
	:HiddenAbilities => :FLAMEBODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:FURYATTACK],
		[1,:POISONJAB],
		[1,:MEGAHORN],
		[1,:GROWL],
		[1,:QUICKATTACK],
		[1,:EMBER],
		[1,:TAILWHIP],
		[4,:TAILWHIP],
		[9,:EMBER],
		[13,:FLAMEWHEEL],
		[17,:STOMP],
		[21,:FLAMECHARGE],
		[25,:FIRESPIN],
		[29,:TAKEDOWN],
		[33,:INFERNO],
		[37,:AGILITY],
		[41,:FIREBLAST],
		[45,:BOUNCE],
		[49,:FLAREBLITZ]],
	:tmlist => [:WILDCHARGE,:LOWKICK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:BOUNCE,:SOLARBEAM,:DRILLRUN,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:ALLYSWITCH,:REST,:IRONTAIL,:CONFIDE,:SMARTSTRIKE,:THROATCHOP,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 17,
	:Weight => 950,
	:kind => "Fire Horse",
	:dexentry => "It usually canters casually in the fields and plains. But once a Rapidash turns serious, its fiery manes flare and blaze as it gallops its way up to 150 mph.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:SLOWPOKE => {
	:name => "Slowpoke",
	:dexnum => 79,
	:Type1 => :WATER,
	:Type2 => :PSYCHIC,
	:BaseStats => [90, 65, 65, 15, 40, 40],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:OBLIVIOUS,:OWNTEMPO],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 63,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BELCH,:BELLYDRUM,:BLOCK,:FUTURESIGHT,:MEFIRST,:MUDSPORT,:SLEEPTALK,:SNORE,:STOMP,:WONDERROOM,:ZENHEADBUTT],
	:Moveset => [
		[1,:CURSE],
		[1,:YAWN],
		[1,:TACKLE],
		[5,:GROWL],
		[9,:WATERGUN],
		[14,:CONFUSION],
		[19,:DISABLE],
		[23,:HEADBUTT],
		[28,:WATERPULSE],
		[32,:ZENHEADBUTT],
		[36,:SLACKOFF],
		[41,:AMNESIA],
		[45,:PSYCHIC],
		[49,:RAINDANCE],
		[54,:PSYCHUP],
		[58,:HEALPULSE]],
	:tmlist => [:SIGNALBEAM,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:LIGHTSCREEN,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Pink",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 12,
	:Weight => 360,
	:WildItemUncommon => :LAGGINGTAIL,
	:kind => "Dopey",
	:dexentry => "It catches prey by dipping its tail in water at the side of a river. But it often forgets what its doing and spends days loafing at water's edge.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SLOWBRO,:Level,37],
		[:SLOWKING,:TradeItem,:KINGSROCK]
	]
},

:SLOWBRO => {
	:name => "Slowbro",
	:dexnum => 80,
	:Type1 => :WATER,
	:Type2 => :PSYCHIC,
	:BaseStats => [95, 75, 110, 30, 100, 80],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:OBLIVIOUS,:OWNTEMPO],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 172,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:WITHDRAW],
		[1,:HEALPULSE],
		[1,:CURSE],
		[1,:YAWN],
		[1,:TACKLE],
		[1,:GROWL],
		[5,:GROWL],
		[9,:WATERGUN],
		[14,:CONFUSION],
		[19,:DISABLE],
		[23,:HEADBUTT],
		[28,:WATERPULSE],
		[32,:ZENHEADBUTT],
		[36,:SLACKOFF],
		[43,:AMNESIA],
		[49,:PSYCHIC],
		[55,:RAINDANCE],
		[62,:PSYCHUP],
		[68,:HEALPULSE]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:FOULPLAY,:FLING,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:LIGHTSCREEN,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:IRONDEFENSE,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Pink",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 16,
	:Weight => 785,
	:WildItemUncommon => :KINGSROCK,
	:kind => "Hermit Crab",
	:dexentry => "Its tail has a Shellder firmly attached with a bite. As a result, the tail can't be used for fishing anymore. This forces it to reluctantly swim and catch prey.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:MAGNEMITE => {
	:name => "Magnemite",
	:dexnum => 81,
	:Type1 => :ELECTRIC,
	:Type2 => :STEEL,
	:BaseStats => [25, 35, 70, 45, 95, 55],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:MAGNETPULL,:STURDY],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 89,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:SUPERSONIC],
		[5,:THUNDERSHOCK],
		[7,:THUNDERWAVE],
		[11,:MAGNETBOMB],
		[13,:LIGHTSCREEN],
		[17,:SONICBOOM],
		[19,:SPARK],
		[23,:MIRRORSHOT],
		[25,:METALSOUND],
		[29,:ELECTROBALL],
		[31,:FLASHCANNON],
		[35,:SCREECH],
		[37,:DISCHARGE],
		[41,:LOCKON],
		[43,:MAGNETRISE],
		[47,:GYROBALL],
		[49,:ZAPCANNON]],
	:tmlist => [:SIGNALBEAM,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:SUNNYDAY,:EXPLOSION,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:ROLLOUT,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Mineral],
	:Height => 3,
	:Weight => 60,
	:WildItemUncommon => :METALCOAT,
	:kind => "Magnet",
	:dexentry => "The units at its sides are extremely powerful magnets. They generate enough magnetism to draw in iron objects from over 300 feet away.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 29,
	:BattlerAltitude => 19,
	:evolutions => [
		[:MAGNETON,:Level,30]
	]
},

:MAGNETON => {
	:name => "Magneton",
	:dexnum => 82,
	:Type1 => :ELECTRIC,
	:Type2 => :STEEL,
	:BaseStats => [50, 60, 95, 70, 120, 70],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:MAGNETPULL,:STURDY],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 163,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:TRIATTACK],
		[1,:ZAPCANNON],
		[1,:ELECTRICTERRAIN],
		[1,:TACKLE],
		[1,:SUPERSONIC],
		[1,:THUNDERSHOCK],
		[1,:MAGNETBOMB],
		[5,:THUNDERSHOCK],
		[7,:THUNDERWAVE],
		[11,:MAGNETBOMB],
		[13,:LIGHTSCREEN],
		[17,:SONICBOOM],
		[19,:SPARK],
		[23,:MIRRORSHOT],
		[25,:METALSOUND],
		[29,:ELECTROBALL],
		[33,:FLASHCANNON],
		[39,:SCREECH],
		[43,:DISCHARGE],
		[49,:LOCKON],
		[53,:MAGNETRISE],
		[59,:GYROBALL],
		[63,:ZAPCANNON]],
	:tmlist => [:SIGNALBEAM,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:SUNNYDAY,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:ROLLOUT,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Mineral],
	:Height => 10,
	:Weight => 600,
	:WildItemUncommon => :METALCOAT,
	:kind => "Magnet",
	:dexentry => "It is actually three Magnemite linked by magnetism. It generates powerful radio waves that raise temperatures by 3.6 degrees F within a 3,300-foot radius.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 15,
	:evolutions => [
		[:MAGNEZONE,:Location,281]
	]
},

:FARFETCHD => {
	:name => "Farfetch'd",
	:dexnum => 83,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [52, 90, 55, 60, 58, 62],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:KEENEYE,:INNERFOCUS],
	:HiddenAbilities => :DEFIANT,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 123,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:COVET,:CURSE,:FEATHERDANCE,:FIRSTIMPRESSION,:FINALGAMBIT,:FLAIL,:FORESIGHT,:GUST,:LEAFBLADE,:MIRRORMOVE,:MUDSLAP,:NIGHTSLASH,:QUICKATTACK,:REVENGE,:ROOST,:SIMPLEBEAM,:STEELWING,:TRUMPCARD],
	:Moveset => [
		[1,:BRAVEBIRD],
		[1,:POISONJAB],
		[1,:PECK],
		[1,:SANDATTACK],
		[1,:LEER],
		[1,:FURYCUTTER],
		[7,:FURYATTACK],
		[9,:AERIALACE],
		[13,:KNOCKOFF],
		[19,:SLASH],
		[21,:AIRCUTTER],
		[25,:SWORDSDANCE],
		[31,:AGILITY],
		[33,:NIGHTSLASH],
		[37,:ACROBATICS],
		[43,:FEINT],
		[45,:FALSESWIPE],
		[49,:AIRSLASH],
		[55,:BRAVEBIRD]],
	:tmlist => [:UTURN,:FURYCUTTER,:THIEF,:KNOCKOFF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:REST,:IRONTAIL,:STEELWING,:CONFIDE,:BRUTALSWING,:LASERFOCUS,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Flying,:Field],
	:Height => 8,
	:Weight => 150,
	:WildItemUncommon => :STICK,
	:kind => "Wild Duck",
	:dexentry => "It is always seen with a stick from a plant. Apparently, there are good sticks and bad sticks. This Pokémon occasionally fights over choice sticks.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:DODUO => {
	:name => "Doduo",
	:dexnum => 84,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [35, 85, 45, 75, 35, 35],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:RUNAWAY,:EARLYBIRD],
	:HiddenAbilities => :TANGLEDFEET,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 62,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ASSURANCE,:BRAVEBIRD,:ENDEAVOR,:FEINTATTACK,:FLAIL,:HAZE,:MIRRORMOVE,:NATURALGIFT,:QUICKATTACK,:SUPERSONIC],
	:Moveset => [
		[1,:PECK],
		[1,:GROWL],
		[5,:QUICKATTACK],
		[8,:RAGE],
		[12,:FURYATTACK],
		[15,:PURSUIT],
		[19,:PLUCK],
		[22,:DOUBLEHIT],
		[26,:AGILITY],
		[29,:UPROAR],
		[33,:ACUPRESSURE],
		[36,:SWORDSDANCE],
		[40,:JUMPKICK],
		[43,:DRILLPECK],
		[47,:ENDEAVOR],
		[50,:THRASH]],
	:tmlist => [:THIEF,:KNOCKOFF,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:ROOST,:MUDSLAP,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Flying],
	:Height => 14,
	:Weight => 392,
	:WildItemUncommon => :SHARPBEAK,
	:kind => "Twin Bird",
	:dexentry => "Even while eating or sleeping, one of the heads remains always vigilant for any sign of danger. When threatened, it flees at over 60 miles per hour.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DODRIO,:Level,31]
	]
},

:DODRIO => {
	:name => "Dodrio",
	:dexnum => 85,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [60, 110, 70, 110, 60, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:RUNAWAY,:EARLYBIRD],
	:HiddenAbilities => :TANGLEDFEET,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:TRIATTACK],
		[1,:PECK],
		[1,:GROWL],
		[1,:QUICKATTACK],
		[1,:RAGE],
		[5,:QUICKATTACK],
		[8,:RAGE],
		[12,:FURYATTACK],
		[15,:PURSUIT],
		[19,:PLUCK],
		[22,:DOUBLEHIT],
		[26,:AGILITY],
		[29,:UPROAR],
		[34,:ACUPRESSURE],
		[38,:SWORDSDANCE],
		[43,:JUMPKICK],
		[47,:DRILLPECK],
		[52,:ENDEAVOR],
		[56,:THRASH]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:TAUNT,:TORMENT,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:ROOST,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Flying],
	:Height => 18,
	:Weight => 852,
	:WildItemUncommon => :SHARPBEAK,
	:kind => "Triple Bird",
	:dexentry => "A peculiar Pokémon species with three heads. It vigorously races across grassy plains even in arid seasons with little rainfall.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 3,
	:BattlerAltitude => 0,
},

:SEEL => {
	:name => "Seel",
	:dexnum => 86,
	:Type1 => :WATER,
	:BaseStats => [65, 45, 55, 45, 45, 70],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:THICKFAT,:HYDRATION],
	:HiddenAbilities => :ICEBODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 65,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BELCH,:DISABLE,:ENCORE,:ENTRAINMENT,:FAKEOUT,:HORNDRILL,:ICICLESPEAR,:IRONTAIL,:LICK,:PERISHSONG,:SIGNALBEAM,:SLAM,:SLEEPTALK,:SPITUP,:STOCKPILE,:SWALLOW,:WATERPULSE],
	:Moveset => [
		[1,:HEADBUTT],
		[3,:GROWL],
		[7,:WATERSPORT],
		[11,:ICYWIND],
		[13,:ENCORE],
		[17,:ICESHARD],
		[21,:REST],
		[23,:AQUARING],
		[27,:AURORABEAM],
		[31,:AQUAJET],
		[33,:BRINE],
		[37,:TAKEDOWN],
		[41,:DIVE],
		[43,:AQUATAIL],
		[47,:ICEBEAM],
		[51,:SAFEGUARD],
		[53,:HAIL]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:DRILLRUN,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:SMARTSTRIKE,],
	:Color => "White",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Field],
	:Height => 11,
	:Weight => 900,
	:kind => "Sea Lion",
	:dexentry => "Seel hunt for prey in frigid, ice-covered seas. When it needs to breathe, it punches a hole through the ice with the sharply protruding section of its head.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DEWGONG,:Level,34]
	]
},

:DEWGONG => {
	:name => "Dewgong",
	:dexnum => 87,
	:Type1 => :WATER,
	:Type2 => :ICE,
	:BaseStats => [90, 70, 80, 70, 70, 95],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:THICKFAT,:HYDRATION],
	:HiddenAbilities => :ICEBODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SHEERCOLD],
		[1,:HEADBUTT],
		[1,:GROWL],
		[1,:SIGNALBEAM],
		[1,:ICYWIND],
		[3,:GROWL],
		[7,:SIGNALBEAM],
		[11,:ICYWIND],
		[13,:ENCORE],
		[17,:ICESHARD],
		[21,:REST],
		[23,:AQUARING],
		[27,:AURORABEAM],
		[31,:AQUAJET],
		[33,:BRINE],
		[39,:TAKEDOWN],
		[45,:DIVE],
		[49,:AQUATAIL],
		[55,:ICEBEAM],
		[61,:SAFEGUARD],
		[65,:HAIL]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:DRILLRUN,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,:SMARTSTRIKE,],
	:Color => "White",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Field],
	:Height => 17,
	:Weight => 1200,
	:kind => "Sea Lion",
	:dexentry => "It loves to snooze on bitterly cold ice. The sight of this Pokémon sleeping on a glacier was mistakenly thought to be a mermaid by a mariner long ago.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:GRIMER => {
	:name => "Grimer",
	:dexnum => 88,
	:Type1 => :POISON,
	:BaseStats => [80, 80, 50, 25, 40, 50],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:STENCH,:STICKYHOLD],
	:HiddenAbilities => :POISONTOUCH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 65,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACIDSPRAY,:CURSE,:HAZE,:IMPRISON,:LICK,:MEANLOOK,:POWERUPPUNCH,:SCARYFACE,:SHADOWPUNCH,:SHADOWSNEAK,:SPITUP,:STOCKPILE,:SWALLOW],
	:Moveset => [
		[1,:POUND],
		[1,:POISONGAS],
		[4,:HARDEN],
		[7,:MUDSLAP],
		[12,:DISABLE],
		[15,:SLUDGE],
		[18,:MUDBOMB],
		[21,:MINIMIZE],
		[26,:FLING],
		[29,:SLUDGEBOMB],
		[32,:SLUDGEWAVE],
		[37,:SCREECH],
		[40,:GUNKSHOT],
		[43,:ACIDARMOR],
		[46,:BELCH],
		[48,:MEMENTO]],
	:tmlist => [:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:GIGADRAIN,:MUDSLAP,:ICEPUNCH,:EXPLOSION,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Purple",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 9,
	:Weight => 300,
	:WildItemUncommon => :BLACKSLUDGE,
	:kind => "Sludge",
	:dexentry => "Born from polluted sludge in the sea, Grimer's favorite food is anything filthy. They feed on wastewater pumped out from factories.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MUK,:Level,38]
	]
},

:MUK => {
	:name => "Muk",
	:dexnum => 89,
	:Type1 => :POISON,
	:BaseStats => [105, 105, 75, 50, 65, 100],
	:EVs => [1, 1, 0, 0, 0, 0],
	:Abilities => [:STENCH,:STICKYHOLD],
	:HiddenAbilities => :POISONTOUCH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:VENOMDRENCH],
		[1,:POISONGAS],
		[1,:POUND],
		[1,:HARDEN],
		[1,:MUDSLAP],
		[4,:HARDEN],
		[7,:MUDSLAP],
		[12,:DISABLE],
		[15,:SLUDGE],
		[18,:MUDBOMB],
		[21,:MINIMIZE],
		[26,:FLING],
		[29,:SLUDGEBOMB],
		[32,:SLUDGEWAVE],
		[37,:SCREECH],
		[40,:GUNKSHOT],
		[46,:ACIDARMOR],
		[52,:BELCH],
		[57,:MEMENTO]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:GIGADRAIN,:MUDSLAP,:ICEPUNCH,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Purple",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 12,
	:Weight => 300,
	:WildItemUncommon => :BLACKSLUDGE,
	:kind => "Sludge",
	:dexentry => "It prefers warm and humid habitats. In the summertime, the toxic substances in its body intensify, making Muk reek like putrid kitchen garbage.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:SHELLDER => {
	:name => "Shellder",
	:dexnum => 90,
	:Type1 => :WATER,
	:BaseStats => [30, 65, 100, 40, 45, 25],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SHELLARMOR,:SKILLLINK],
	:HiddenAbilities => :OVERCOAT,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AQUARING,:AVALANCHE,:BARRIER,:BUBBLEBEAM,:ICICLESPEAR,:MUDSHOT,:RAPIDSPIN,:ROCKBLAST,:SCREECH,:TAKEDOWN,:TWINEEDLE,:WATERPULSE],
	:Moveset => [
		[1,:TACKLE],
		[1,:WATERGUN],
		[4,:WITHDRAW],
		[8,:SUPERSONIC],
		[13,:ICICLESPEAR],
		[16,:PROTECT],
		[20,:LEER],
		[25,:CLAMP],
		[28,:ICESHARD],
		[32,:RAZORSHELL],
		[37,:AURORABEAM],
		[40,:WHIRLPOOL],
		[44,:BRINE],
		[49,:IRONDEFENSE],
		[52,:ICEBEAM],
		[56,:SHELLSMASH],
		[61,:HYDROPUMP]],
	:tmlist => [:PAYBACK,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:EXPLOSION,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:IRONDEFENSE,:SURF,:DIVE,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Purple",
	:Habitat => "Sea",
	:EggGroups => [:Water3],
	:Height => 3,
	:Weight => 40,
	:WildItemCommon => :PEARL,
	:WildItemUncommon => :BIGPEARL,
	:kind => "Bivalve",
	:dexentry => "At night, it burrows a hole in the seafloor with its broad tongue to make a place to sleep. While asleep, it closes its shell, but leaves its tongue hanging out.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CLOYSTER,:Item,:WATERSTONE]
	]
},

:CLOYSTER => {
	:name => "Cloyster",
	:dexnum => 91,
	:Type1 => :WATER,
	:Type2 => :ICE,
	:BaseStats => [50, 95, 180, 70, 85, 45],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SHELLARMOR,:SKILLLINK],
	:HiddenAbilities => :OVERCOAT,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 184,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:HYDROPUMP],
		[1,:SHELLSMASH],
		[1,:TOXICSPIKES],
		[1,:WITHDRAW],
		[1,:SUPERSONIC],
		[1,:PROTECT],
		[1,:AURORABEAM],
		[13,:SPIKECANNON],
		[28,:SPIKES],
		[50,:ICICLECRASH]],
	:tmlist => [:SIGNALBEAM,:PAYBACK,:TORMENT,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:REST,:IRONDEFENSE,:SURF,:DIVE,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,:SMARTSTRIKE,],
	:Color => "Purple",
	:Habitat => "Sea",
	:EggGroups => [:Water3],
	:Height => 15,
	:Weight => 1325,
	:WildItemCommon => :PEARL,
	:WildItemUncommon => :BIGPEARL,
	:kind => "Bivalve",
	:dexentry => "It swims in the sea by swallowing water, then jetting it out toward the rear. The Cloyster shoots spikes from its shell using the same system.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:GASTLY => {
	:name => "Gastly",
	:dexnum => 92,
	:Type1 => :GHOST,
	:Type2 => :POISON,
	:BaseStats => [30, 35, 30, 80, 100, 35],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 62,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ASTONISH,:CLEARSMOG,:DISABLE,:FIREPUNCH,:GRUDGE,:HAZE,:ICEPUNCH,:PERISHSONG,:PSYWAVE,:REFLECTTYPE,:SCARYFACE,:SMOG,:THUNDERPUNCH],
	:Moveset => [
		[1,:HYPNOSIS],
		[1,:LICK],
		[5,:SPITE],
		[8,:MEANLOOK],
		[12,:CURSE],
		[15,:NIGHTSHADE],
		[19,:CONFUSERAY],
		[22,:SUCKERPUNCH],
		[26,:PAYBACK],
		[29,:SHADOWBALL],
		[33,:DREAMEATER],
		[36,:DARKPULSE],
		[40,:DESTINYBOND],
		[43,:HEX],
		[47,:NIGHTMARE]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERBOLT,:THUNDERPUNCH,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:OMINOUSWIND,:SPITE,:ENERGYBALL,:GIGADRAIN,:ICEPUNCH,:ICYWIND,:EXPLOSION,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Purple",
	:Habitat => "Cave",
	:EggGroups => [:Amorphous],
	:Height => 13,
	:Weight => 1,
	:kind => "Gas",
	:dexentry => "When exposed to a strong wind, a Gastly's gaseous body quickly dwindles away. They cluster under the eaves of houses to escape the ravages of wind.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 13,
	:evolutions => [
		[:HAUNTER,:Level,25]
	]
},

:HAUNTER => {
	:name => "Haunter",
	:dexnum => 93,
	:Type1 => :GHOST,
	:Type2 => :POISON,
	:BaseStats => [45, 50, 45, 95, 115, 55],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 142,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SHADOWPUNCH],
		[1,:HYPNOSIS],
		[1,:LICK],
		[1,:SPITE],
		[5,:SPITE],
		[8,:MEANLOOK],
		[12,:CURSE],
		[15,:NIGHTSHADE],
		[19,:CONFUSERAY],
		[22,:SUCKERPUNCH],
		[28,:PAYBACK],
		[33,:SHADOWBALL],
		[39,:DREAMEATER],
		[44,:DARKPULSE],
		[50,:DESTINYBOND],
		[55,:HEX],
		[61,:NIGHTMARE]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERBOLT,:THUNDERPUNCH,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SHADOWCLAW,:OMINOUSWIND,:SPITE,:ENERGYBALL,:GIGADRAIN,:ICEPUNCH,:ICYWIND,:EXPLOSION,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Purple",
	:Habitat => "Cave",
	:EggGroups => [:Amorphous],
	:Height => 16,
	:Weight => 1,
	:kind => "Gas",
	:dexentry => "If a Haunter beckons you while it is floating in darkness, don't approach it. This Pokémon will try to lick you with its tongue and steal your life away.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 14,
	:evolutions => [
		[:GENGAR,:Trade,0]
	]
},

:GENGAR => {
	:name => "Gengar",
	:dexnum => 94,
	:Type1 => :GHOST,
	:Type2 => :POISON,
	:BaseStats => [60, 65, 60, 110, 130, 75],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:CURSEDBODY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 225,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SHADOWPUNCH],
		[1,:HYPNOSIS],
		[1,:LICK],
		[1,:SPITE],
		[5,:SPITE],
		[8,:MEANLOOK],
		[12,:CURSE],
		[15,:NIGHTSHADE],
		[19,:CONFUSERAY],
		[22,:SUCKERPUNCH],
		[28,:PAYBACK],
		[33,:SHADOWBALL],
		[39,:DREAMEATER],
		[44,:DARKPULSE],
		[50,:DESTINYBOND],
		[55,:HEX],
		[61,:NIGHTMARE]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SHADOWCLAW,:OMINOUSWIND,:SPITE,:ENERGYBALL,:GIGADRAIN,:ICEPUNCH,:ICYWIND,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:MAGICCOAT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Purple",
	:Habitat => "Cave",
	:EggGroups => [:Amorphous],
	:Height => 15,
	:Weight => 405,
	:kind => "Shadow",
	:dexentry => "Deep in the night, your shadow cast by a streetlight may suddenly overtake you. It is actually a Gengar running past you, pretending to be your shadow.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:ONIX => {
	:name => "Onix",
	:dexnum => 95,
	:Type1 => :ROCK,
	:Type2 => :GROUND,
	:BaseStats => [35, 45, 160, 70, 30, 45],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:STURDY],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 77,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:BLOCK,:DEFENSECURL,:FLAIL,:HEAVYSLAM,:ROCKBLAST,:ROCKCLIMB,:ROLLOUT,:ROTOTILLER,:STEALTHROCK,:WIDEGUARD],
	:Moveset => [
		[1,:MUDSPORT],
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:BIND],
		[4,:CURSE],
		[7,:ROCKTHROW],
		[10,:ROCKTOMB],
		[13,:RAGE],
		[16,:STEALTHROCK],
		[19,:ROCKPOLISH],
		[20,:GYROBALL],
		[22,:SMACKDOWN],
		[25,:DRAGONBREATH],
		[28,:SLAM],
		[31,:SCREECH],
		[34,:ROCKSLIDE],
		[37,:SANDTOMB],
		[40,:IRONTAIL],
		[43,:DIG],
		[46,:STONEEDGE],
		[49,:DOUBLEEDGE],
		[52,:SANDSTORM]],
	:tmlist => [:PAYBACK,:TAUNT,:TORMENT,:DRAGONPULSE,:DRAGONTAIL,:TWISTER,:ROCKSMASH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:GYROBALL,:CONFIDE,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "Cave",
	:EggGroups => [:Mineral],
	:Height => 88,
	:Weight => 2100,
	:kind => "Rock Snake",
	:dexentry => "An Onix never loses direction while tunneling, thanks to a magnet on its brain. As it grows older, its body becomes steadily rounder and smoother.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
	:evolutions => [
		[:STEELIX,:TradeItem,:METALCOAT]
	]
},

:DROWZEE => {
	:name => "Drowzee",
	:dexnum => 96,
	:Type1 => :PSYCHIC,
	:BaseStats => [60, 48, 45, 42, 43, 90],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:INSOMNIA,:FOREWARN],
	:HiddenAbilities => :INNERFOCUS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ASSIST,:BARRIER,:FIREPUNCH,:FLATTER,:GUARDSWAP,:ICEPUNCH,:NASTYPLOT,:POWERSPLIT,:PSYCHICTERRAIN,:PSYCHOCUT,:ROLEPLAY,:SECRETPOWER,:SKILLSWAP,:THUNDERPUNCH],
	:Moveset => [
		[1,:POUND],
		[1,:HYPNOSIS],
		[5,:DISABLE],
		[9,:CONFUSION],
		[13,:HEADBUTT],
		[17,:POISONGAS],
		[21,:MEDITATE],
		[25,:PSYBEAM],
		[29,:WAKEUPSLAP],
		[33,:PSYCHUP],
		[37,:SYNCHRONOISE],
		[41,:ZENHEADBUTT],
		[45,:SWAGGER],
		[49,:PSYCHIC],
		[53,:NASTYPLOT],
		[57,:PSYSHOCK],
		[61,:FUTURESIGHT]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:ICEPUNCH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:HumanLike],
	:Height => 10,
	:Weight => 324,
	:kind => "Hypnosis",
	:dexentry => "If your nose becomes itchy while you are sleeping, it is a sure sign that a Drowzee is standing above your pillow and trying to eat your dream through your nostrils.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
	:evolutions => [
		[:HYPNO,:Level,26]
	]
},

:HYPNO => {
	:name => "Hypno",
	:dexnum => 97,
	:Type1 => :PSYCHIC,
	:BaseStats => [85, 73, 70, 67, 73, 115],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:INSOMNIA,:FOREWARN],
	:HiddenAbilities => :INNERFOCUS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 169,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:FUTURESIGHT],
		[1,:NASTYPLOT],
		[1,:NIGHTMARE],
		[1,:SWITCHEROO],
		[1,:POUND],
		[1,:HYPNOSIS],
		[1,:DISABLE],
		[1,:CONFUSION],
		[5,:DISABLE],
		[9,:CONFUSION],
		[13,:HEADBUTT],
		[17,:POISONGAS],
		[21,:MEDITATE],
		[25,:PSYBEAM],
		[29,:WAKEUPSLAP],
		[33,:PSYCHUP],
		[37,:SYNCHRONOISE],
		[41,:ZENHEADBUTT],
		[45,:SWAGGER],
		[49,:PSYCHIC],
		[53,:NASTYPLOT],
		[57,:PSYSHOCK],
		[61,:FUTURESIGHT]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:HumanLike],
	:Height => 16,
	:Weight => 756,
	:kind => "Hypnosis",
	:dexentry => "The arcing movement and glitter of the pendulum in a Hypno's hand lull the foe into deep hypnosis. While searching for prey, it polishes the pendulum.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:KRABBY => {
	:name => "Krabby",
	:dexnum => 98,
	:Type1 => :WATER,
	:BaseStats => [30, 105, 90, 50, 25, 25],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:SHELLARMOR],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 65,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:ALLYSWITCH,:AMNESIA,:ANCIENTPOWER,:BIDE,:CHIPAWAY,:ENDURE,:FLAIL,:HAZE,:KNOCKOFF,:SLAM,:TICKLE],
	:Moveset => [
		[1,:MUDSPORT],
		[1,:BUBBLE],
		[5,:VICEGRIP],
		[9,:LEER],
		[11,:HARDEN],
		[15,:BUBBLEBEAM],
		[19,:MUDSHOT],
		[21,:METALCLAW],
		[25,:STOMP],
		[29,:PROTECT],
		[31,:GUILLOTINE],
		[35,:SLAM],
		[39,:BRINE],
		[41,:CRABHAMMER],
		[45,:FLAIL]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:ALLYSWITCH,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:IRONDEFENSE,:SURF,:DIVE,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Red",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water3],
	:Height => 4,
	:Weight => 65,
	:kind => "River Crab",
	:dexentry => "Krabby live in holes dug into beaches. On sandy shores with little in the way of food, they can be seen squabbling with each other over territory.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:KINGLER,:Level,28]
	]
},

:KINGLER => {
	:name => "Kingler",
	:dexnum => 99,
	:Type1 => :WATER,
	:BaseStats => [55, 130, 115, 75, 50, 50],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:SHELLARMOR],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:WIDEGUARD],
		[1,:MUDSPORT],
		[1,:BUBBLE],
		[1,:VICEGRIP],
		[1,:LEER],
		[5,:VICEGRIP],
		[9,:LEER],
		[11,:HARDEN],
		[15,:BUBBLEBEAM],
		[19,:MUDSHOT],
		[21,:METALCLAW],
		[25,:STOMP],
		[32,:PROTECT],
		[37,:GUILLOTINE],
		[44,:SLAM],
		[51,:BRINE],
		[56,:CRABHAMMER],
		[63,:FLAIL]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:QUASH,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:ALLYSWITCH,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:IRONDEFENSE,:SURF,:DIVE,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,:STOMPINGTANTRUM,],
	:Color => "Red",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water3],
	:Height => 13,
	:Weight => 600,
	:kind => "Pincer",
	:dexentry => "It waves its huge, oversized claw in the air to communicate with others. But since the claw is so heavy, this Pokémon quickly tires.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:VOLTORB => {
	:name => "Voltorb",
	:dexnum => 100,
	:Type1 => :ELECTRIC,
	:BaseStats => [40, 30, 50, 100, 55, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SOUNDPROOF,:STATIC],
	:HiddenAbilities => :AFTERMATH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 66,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:CHARGE],
		[1,:TACKLE],
		[4,:SONICBOOM],
		[6,:EERIEIMPULSE],
		[9,:SPARK],
		[11,:ROLLOUT],
		[13,:SCREECH],
		[16,:CHARGEBEAM],
		[20,:SWIFT],
		[22,:ELECTROBALL],
		[26,:SELFDESTRUCT],
		[29,:LIGHTSCREEN],
		[34,:MAGNETRISE],
		[37,:DISCHARGE],
		[41,:EXPLOSION],
		[46,:GYROBALL],
		[48,:MIRRORCOAT]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:SUCKERPUNCH,:THIEF,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:EXPLOSION,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLEPLAY,:ROLLOUT,:GYROBALL,:RAINDANCE,:CONFIDE,],
	:Color => "Red",
	:Habitat => "Urban",
	:EggGroups => [:Mineral],
	:Height => 5,
	:Weight => 104,
	:kind => "Ball",
	:dexentry => "It bears an uncanny and unexplained resemblance to a Poké Ball. Because it explodes at the slightest shock, even veteran Trainers treat it with caution.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ELECTRODE,:Level,30]
	]
},

:ELECTRODE => {
	:name => "Electrode",
	:dexnum => 101,
	:Type1 => :ELECTRIC,
	:BaseStats => [60, 50, 70, 150, 80, 80],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:SOUNDPROOF,:STATIC],
	:HiddenAbilities => :AFTERMATH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 168,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:MAGNETICFLUX],
		[1,:CHARGE],
		[1,:TACKLE],
		[1,:SONICBOOM],
		[1,:EERIEIMPULSE],
		[4,:SONICBOOM],
		[6,:EERIEIMPULSE],
		[9,:SPARK],
		[11,:ROLLOUT],
		[13,:SCREECH],
		[16,:CHARGEBEAM],
		[20,:SWIFT],
		[22,:ELECTROBALL],
		[26,:SELFDESTRUCT],
		[29,:LIGHTSCREEN],
		[36,:MAGNETRISE],
		[41,:DISCHARGE],
		[47,:EXPLOSION],
		[54,:GYROBALL],
		[58,:MIRRORCOAT]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:SUCKERPUNCH,:THIEF,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLEPLAY,:TELEKINESIS,:ROLLOUT,:GYROBALL,:RAINDANCE,:CONFIDE,],
	:Color => "Red",
	:Habitat => "Urban",
	:EggGroups => [:Mineral],
	:Height => 12,
	:Weight => 666,
	:kind => "Ball",
	:dexentry => "They appear in great numbers at electric power plants. Because they feed on electricity, they cause massive and chaotic blackouts in nearby cities.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
},

:EXEGGCUTE => {
	:name => "Exeggcute",
	:dexnum => 102,
	:Type1 => :GRASS,
	:Type2 => :PSYCHIC,
	:BaseStats => [60, 40, 80, 40, 60, 45],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:HARVEST],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 65,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:BLOCK,:CURSE,:GIGADRAIN,:GRASSYTERRAIN,:INGRAIN,:LEAFSTORM,:LUCKYCHANT,:MOONLIGHT,:NATURALGIFT,:NATUREPOWER,:POWERSWAP,:SKILLSWAP,:SYNTHESIS],
	:Moveset => [
		[1,:BARRAGE],
		[1,:UPROAR],
		[1,:HYPNOSIS],
		[7,:REFLECT],
		[11,:LEECHSEED],
		[17,:BULLETSEED],
		[19,:STUNSPORE],
		[21,:POISONPOWDER],
		[23,:SLEEPPOWDER],
		[27,:CONFUSION],
		[33,:WORRYSEED],
		[37,:NATURALGIFT],
		[43,:SOLARBEAM],
		[47,:EXTRASENSORY],
		[50,:BESTOW]],
	:tmlist => [:THIEF,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EXPLOSION,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:TOXIC,:DREAMEATER,:PSYCHIC,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICKROOM,:ANCIENTPOWER,:ROLLOUT,:CONFIDE,:INFESTATION,:CELEBRATE,],
	:Color => "Pink",
	:Habitat => "Forest",
	:EggGroups => [:Grass],
	:Height => 4,
	:Weight => 25,
	:WildItemUncommon => :MAGICALSEED,
	:kind => "Egg",
	:dexentry => "It consists of six eggs that care for each other. They attract each other and spin around. It evolves when various cracks start to appear.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 32,
	:BattlerAltitude => 0,
	:evolutions => [
		[:EXEGGUTOR,:Item,:LEAFSTONE]
	]
},

:EXEGGUTOR => {
	:name => "Exeggutor",
	:dexnum => 103,
	:Type1 => :GRASS,
	:Type2 => :PSYCHIC,
	:BaseStats => [95, 95, 85, 55, 125, 75],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:CHLOROPHYLL,:HARVEST],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 182,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:STOMP],
		[1,:SEEDBOMB],
		[1,:BARRAGE],
		[1,:HYPNOSIS],
		[1,:CONFUSION],
		[17,:PSYSHOCK],
		[27,:EGGBOMB],
		[37,:WOODHAMMER],
		[47,:LEAFSTORM]],
	:tmlist => [:THIEF,:LOWKICK,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICKROOM,:ANCIENTPOWER,:ROLLOUT,:CONFIDE,:INFESTATION,:STOMPINGTANTRUM,:CELEBRATE,],
	:Color => "Yellow",
	:Habitat => "Forest",
	:EggGroups => [:Grass],
	:Height => 20,
	:Weight => 1200,
	:kind => "Coconut",
	:dexentry => "Originally from the tropics, Exeggutor's heads grow larger from exposure to strong sunlight. When the heads fall, they group to form an Exeggcute.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 5,
	:BattlerAltitude => 0,
},

:CUBONE => {
	:name => "Cubone",
	:dexnum => 104,
	:Type1 => :GROUND,
	:BaseStats => [50, 50, 95, 35, 40, 50],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:LIGHTNINGROD],
	:HiddenAbilities => :BATTLEARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 64,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:BELLYDRUM,:CHIPAWAY,:CURSE,:DETECT,:DOUBLEKICK,:ENDURE,:IRONHEAD,:PERISHSONG,:SCREECH,:SKULLBASH],
	:Moveset => [
		[1,:GROWL],
		[3,:TAILWHIP],
		[7,:BONECLUB],
		[11,:HEADBUTT],
		[13,:LEER],
		[17,:FOCUSENERGY],
		[21,:BONEMERANG],
		[23,:RAGE],
		[27,:FALSESWIPE],
		[31,:THRASH],
		[33,:FLING],
		[37,:STOMPINGTANTRUM],
		[41,:ENDEAVOR],
		[43,:DOUBLEEDGE],
		[47,:RETALIATE],
		[51,:BONERUSH]],
	:tmlist => [:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 4,
	:Weight => 65,
	:WildItemUncommon => :THICKCLUB,
	:kind => "Lonely",
	:dexentry => "It pines for the mother it will never see again. Seeing a likeness of its mother in the full moon, it cries. The stains on the skull it wears are from its tears.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MAROWAK,:Level,28]
	]
},

:MAROWAK => {
	:name => "Marowak",
	:dexnum => 105,
	:Type1 => :GROUND,
	:BaseStats => [60, 80, 110, 45, 50, 80],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:LIGHTNINGROD],
	:HiddenAbilities => :BATTLEARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 149,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:GROWL],
		[1,:TAILWHIP],
		[1,:BONECLUB],
		[1,:HEADBUTT],
		[3,:TAILWHIP],
		[7,:BONECLUB],
		[11,:HEADBUTT],
		[13,:LEER],
		[17,:FOCUSENERGY],
		[21,:BONEMERANG],
		[23,:RAGE],
		[27,:FALSESWIPE],
		[33,:THRASH],
		[37,:FLING],
		[43,:STOMPINGTANTRUM],
		[49,:ENDEAVOR],
		[53,:DOUBLEEDGE],
		[59,:RETALIATE],
		[65,:BONERUSH]],
	:tmlist => [:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:OUTRAGE,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:LASERFOCUS,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 10,
	:Weight => 450,
	:WildItemUncommon => :THICKCLUB,
	:kind => "Bone Keeper",
	:dexentry => "A Marowak is a Cubone that has grown tough by overcoming the grief of losing its mother. Its hardened spirit is not easily broken.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
},

:HITMONLEE => {
	:name => "Hitmonlee",
	:dexnum => 106,
	:Type1 => :FIGHTING,
	:BaseStats => [50, 120, 53, 87, 35, 110],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:LIMBER,:RECKLESS],
	:HiddenAbilities => :UNBURDEN,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemZero",
	:BaseEXP => 159,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[0,:DOUBLEKICK],
		[1,:REVERSAL],
		[1,:CLOSECOMBAT],
		[1,:MEGAKICK],
		[1,:REVENGE],
		[1,:MEDITATE],
		[1,:ROLLINGKICK],
		[1,:JUMPKICK],
		[5,:MEDITATE],
		[9,:ROLLINGKICK],
		[13,:JUMPKICK],
		[17,:BRICKBREAK],
		[21,:FOCUSENERGY],
		[25,:FEINT],
		[29,:HIJUMPKICK],
		[33,:MINDREADER],
		[37,:FORESIGHT],
		[41,:WIDEGUARD],
		[45,:BLAZEKICK],
		[49,:ENDURE],
		[53,:MEGAKICK],
		[57,:CLOSECOMBAT],
		[61,:REVERSAL]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:KNOCKOFF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:SUNNYDAY,:BOUNCE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Urban",
	:EggGroups => [:HumanLike],
	:Height => 15,
	:Weight => 498,
	:kind => "Kicking",
	:dexentry => "Its legs freely stretch and contract. Using these springlike limbs, it bowls over foes with devastating kicks. After battle, it rubs down its tired legs.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:HITMONCHAN => {
	:name => "Hitmonchan",
	:dexnum => 107,
	:Type1 => :FIGHTING,
	:BaseStats => [50, 105, 79, 76, 35, 110],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:KEENEYE,:IRONFIST],
	:HiddenAbilities => :INNERFOCUS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemZero",
	:BaseEXP => 159,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[0,:COMETPUNCH],
		[1,:CLOSECOMBAT],
		[1,:COUNTER],
		[1,:FOCUSPUNCH],
		[1,:REVENGE],
		[1,:AGILITY],
		[1,:PURSUIT],
		[1,:MACHPUNCH],
		[6,:AGILITY],
		[11,:PURSUIT],
		[16,:MACHPUNCH],
		[16,:BULLETPUNCH],
		[21,:FEINT],
		[26,:VACUUMWAVE],
		[31,:QUICKGUARD],
		[36,:FIREPUNCH],
		[36,:ICEPUNCH],
		[36,:THUNDERPUNCH],
		[41,:SKYUPPERCUT],
		[46,:MEGAPUNCH],
		[50,:DETECT],
		[56,:FOCUSPUNCH],
		[61,:COUNTER],
		[66,:CLOSECOMBAT]],
	:tmlist => [:THIEF,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Urban",
	:EggGroups => [:HumanLike],
	:Height => 14,
	:Weight => 502,
	:kind => "Punching",
	:dexentry => "A Hitmonchan is said to possess the spirit of a boxer who aimed to become the world champion. Having an indomitable spirit means that it will never give up.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:LICKITUNG => {
	:name => "Lickitung",
	:dexnum => 108,
	:Type1 => :NORMAL,
	:BaseStats => [90, 55, 75, 30, 60, 75],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:OWNTEMPO,:OBLIVIOUS],
	:HiddenAbilities => :CLOUDNINE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 77,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:BELCH,:BELLYDRUM,:BODYSLAM,:CURSE,:HAMMERARM,:MAGNITUDE,:MUDDYWATER,:SLEEPTALK,:SMELLINGSALTS,:SNORE,:THRASH,:ZENHEADBUTT],
	:Moveset => [
		[1,:LICK],
		[5,:SUPERSONIC],
		[9,:DEFENSECURL],
		[13,:KNOCKOFF],
		[17,:WRAP],
		[21,:STOMP],
		[25,:DISABLE],
		[29,:SLAM],
		[33,:ROLLOUT],
		[37,:CHIPAWAY],
		[41,:MEFIRST],
		[45,:REFRESH],
		[49,:SCREECH],
		[53,:POWERWHIP],
		[57,:WRINGOUT]],
	:tmlist => [:THIEF,:FLING,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:DREAMEATER,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:IRONTAIL,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Pink",
	:Habitat => "Grassland",
	:EggGroups => [:Monster],
	:Height => 12,
	:Weight => 655,
	:WildItemUncommon => :LAGGINGTAIL,
	:kind => "Licking",
	:dexentry => "Whenever it sees something unfamiliar, it always licks the object because it memorizes things by texture and taste. It is somewhat put off by sour things.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LICKILICKY,:HasMove,510]
	]
},

:KOFFING => {
	:name => "Koffing",
	:dexnum => 109,
	:Type1 => :POISON,
	:BaseStats => [40, 65, 95, 35, 60, 45],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 68,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CURSE,:DESTINYBOND,:GRUDGE,:PAINSPLIT,:PSYBEAM,:PSYWAVE,:SCREECH,:SPITE,:SPITUP,:STOCKPILE,:SWALLOW,:TOXICSPIKES,:VENOMDRENCH],
	:Moveset => [
		[1,:POISONGAS],
		[1,:TACKLE],
		[4,:SMOG],
		[7,:SMOKESCREEN],
		[12,:ASSURANCE],
		[15,:CLEARSMOG],
		[18,:SLUDGE],
		[23,:SELFDESTRUCT],
		[26,:HAZE],
		[29,:GYROBALL],
		[34,:SLUDGEBOMB],
		[37,:EXPLOSION],
		[40,:DESTINYBOND],
		[42,:BELCH],
		[45,:MEMENTO]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SPITE,:EXPLOSION,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:REST,:ROLLOUT,:GYROBALL,:RAINDANCE,],
	:Color => "Purple",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 6,
	:Weight => 10,
	:WildItemUncommon => :SMOKEBALL,
	:kind => "Poison Gas",
	:dexentry => "Getting up close to a Koffing will give you a chance to observe, through its thin skin, the toxic gases swirling inside. It blows up at the slightest stimulation.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 16,
	:evolutions => [
		[:WEEZING,:Level,35]
	]
},

:WEEZING => {
	:name => "Weezing",
	:dexnum => 110,
	:Type1 => :POISON,
	:BaseStats => [65, 90, 120, 60, 85, 70],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 172,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:DOUBLEHIT],
		[1,:POISONGAS],
		[1,:TACKLE],
		[1,:SMOG],
		[1,:SMOKESCREEN],
		[4,:SMOG],
		[7,:SMOKESCREEN],
		[12,:ASSURANCE],
		[15,:CLEARSMOG],
		[18,:SLUDGE],
		[23,:SELFDESTRUCT],
		[26,:HAZE],
		[29,:GYROBALL],
		[34,:SLUDGEBOMB],
		[40,:EXPLOSION],
		[46,:DESTINYBOND],
		[51,:BELCH],
		[57,:MEMENTO]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SPITE,:MUDSLAP,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:REST,:GYROBALL,:RAINDANCE,],
	:Color => "Purple",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 12,
	:Weight => 95,
	:WildItemUncommon => :SMOKEBALL,
	:kind => "Poison Gas",
	:dexentry => "By diluting its toxic gases with a special process, the highest grade of perfume can be extracted. To Weezing, gases from garbage are the ultimate feast.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 8,
},

:RHYHORN => {
	:name => "Rhyhorn",
	:dexnum => 111,
	:Type1 => :GROUND,
	:Type2 => :ROCK,
	:BaseStats => [80, 85, 95, 25, 30, 30],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:LIGHTNINGROD,:ROCKHEAD],
	:HiddenAbilities => :RECKLESS,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 69,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:COUNTER,:CRUNCH,:CRUSHCLAW,:CURSE,:DRAGONRUSH,:FIREFANG,:GUARDSPLIT,:ICEFANG,:IRONTAIL,:MAGNITUDE,:METALBURST,:REVERSAL,:ROCKCLIMB,:ROTOTILLER,:SKULLBASH,:THUNDERFANG],
	:Moveset => [
		[1,:HORNATTACK],
		[1,:TAILWHIP],
		[5,:FURYATTACK],
		[9,:SCARYFACE],
		[13,:SMACKDOWN],
		[17,:STOMP],
		[21,:BULLDOZE],
		[25,:CHIPAWAY],
		[29,:ROCKBLAST],
		[33,:DRILLRUN],
		[37,:TAKEDOWN],
		[41,:STONEEDGE],
		[45,:EARTHQUAKE],
		[49,:MEGAHORN],
		[53,:HORNDRILL]],
	:tmlist => [:PAYBACK,:THIEF,:DRAGONPULSE,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:SUPERPOWER,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:SPITE,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:SMARTSTRIKE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Monster,:Field],
	:Height => 10,
	:Weight => 1150,
	:kind => "Spikes",
	:dexentry => "Once it starts running, it doesn't stop. Its tiny brain makes it so stupid that it can't remember why it started running in the first place.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:RHYDON,:Level,42]
	]
},

:RHYDON => {
	:name => "Rhydon",
	:dexnum => 112,
	:Type1 => :GROUND,
	:Type2 => :ROCK,
	:BaseStats => [105, 130, 120, 40, 45, 45],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:LIGHTNINGROD,:ROCKHEAD],
	:HiddenAbilities => :RECKLESS,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 170,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:HAMMERARM],
		[1,:HORNDRILL],
		[1,:HORNATTACK],
		[1,:TAILWHIP],
		[1,:FURYATTACK],
		[1,:SCARYFACE],
		[5,:FURYATTACK],
		[9,:SCARYFACE],
		[13,:SMACKDOWN],
		[17,:STOMP],
		[21,:BULLDOZE],
		[25,:CHIPAWAY],
		[29,:ROCKBLAST],
		[33,:DRILLRUN],
		[37,:TAKEDOWN],
		[41,:STONEEDGE],
		[48,:EARTHQUAKE],
		[55,:MEGAHORN],
		[62,:HORNDRILL]],
	:tmlist => [:FURYCUTTER,:PAYBACK,:THIEF,:FLING,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWCLAW,:SPITE,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:SURF,:AQUATAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:SMARTSTRIKE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Monster,:Field],
	:Height => 19,
	:Weight => 1200,
	:kind => "Drill",
	:dexentry => "Its horn, which rotates like a drill, destroys tall buildings with one strike. It stands on its hind legs, and its brain is well developed.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
	:evolutions => [
		[:RHYPERIOR,:TradeItem,:PROTECTOR]
	]
},

:CHANSEY => {
	:name => "Chansey",
	:dexnum => 113,
	:Type1 => :NORMAL,
	:BaseStats => [250, 5, 5, 50, 35, 105],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:NATURALCURE,:SERENEGRACE],
	:HiddenAbilities => :HEALER,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 395,
	:CatchRate => 30,
	:Happiness => 140,
	:EggSteps => 10455,
	:EggMoves => [:AROMATHERAPY,:COUNTER,:ENDURE,:GRAVITY,:HEALBELL,:HELPINGHAND,:METRONOME,:MUDBOMB,:NATURALGIFT,:PRESENT,:SEISMICTOSS],
	:Moveset => [
		[1,:DOUBLEEDGE],
		[1,:DEFENSECURL],
		[1,:POUND],
		[1,:GROWL],
		[5,:TAILWHIP],
		[9,:REFRESH],
		[12,:DOUBLESLAP],
		[16,:SOFTBOILED],
		[20,:BESTOW],
		[23,:MINIMIZE],
		[27,:TAKEDOWN],
		[31,:SING],
		[35,:FLING],
		[39,:HEALPULSE],
		[44,:EGGBOMB],
		[50,:LIGHTSCREEN],
		[57,:HEALINGWISH],
		[65,:DOUBLEEDGE]],
	:tmlist => [:FLING,:SNATCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REST,:SKILLSWAP,:TELEKINESIS,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,:CELEBRATE,],
	:Color => "Pink",
	:Habitat => "Urban",
	:EggGroups => [:Fairy],
	:Height => 11,
	:Weight => 346,
	:WildItemCommon => :LUCKYPUNCH,
	:kind => "Egg",
	:dexentry => "Chansey lay nutritionally excellent eggs every day. The eggs are so delicious, they are eagerly devoured by even those who have lost their appetite.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BLISSEY,:Happiness,0]
	]
},

:TANGELA => {
	:name => "Tangela",
	:dexnum => 114,
	:Type1 => :GRASS,
	:BaseStats => [65, 55, 115, 60, 100, 40],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:LEAFGUARD],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 87,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:CONFUSION,:ENDEAVOR,:FLAIL,:GIGADRAIN,:LEAFSTORM,:LEECHSEED,:MEGADRAIN,:NATURALGIFT,:NATUREPOWER,:POWERSWAP,:RAGEPOWDER,:WAKEUPSLAP],
	:Moveset => [
		[1,:INGRAIN],
		[1,:CONSTRICT],
		[4,:SLEEPPOWDER],
		[7,:VINEWHIP],
		[10,:ABSORB],
		[14,:POISONPOWDER],
		[17,:BIND],
		[20,:GROWTH],
		[23,:MEGADRAIN],
		[27,:KNOCKOFF],
		[30,:STUNSPORE],
		[33,:NATURALGIFT],
		[36,:GIGADRAIN],
		[38,:ANCIENTPOWER],
		[41,:SLAM],
		[44,:TICKLE],
		[46,:WRINGOUT],
		[48,:GRASSYTERRAIN],
		[50,:POWERWHIP]],
	:tmlist => [:THIEF,:KNOCKOFF,:SHOCKWAVE,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:TOXIC,:REFLECT,:REST,:ANCIENTPOWER,:CONFIDE,:INFESTATION,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Grass],
	:Height => 10,
	:Weight => 350,
	:kind => "Vine",
	:dexentry => "Its vines snap off easily and painlessly if they are grabbed, allowing it to make a quick getaway. The lost vines are replaced by new growth the next day.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:TANGROWTH,:HasMove,506]
	]
},

:KANGASKHAN => {
	:name => "Kangaskhan",
	:dexnum => 115,
	:Type1 => :NORMAL,
	:BaseStats => [105, 95, 80, 90, 40, 80],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:EARLYBIRD,:SCRAPPY],
	:HiddenAbilities => :INNERFOCUS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 172,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CIRCLETHROW,:COUNTER,:CRUSHCLAW,:DISABLE,:DOUBLEEDGE,:ENDEAVOR,:FOCUSENERGY,:FOCUSPUNCH,:FORESIGHT,:HAMMERARM,:STOMP,:TRUMPCARD,:UPROAR],
	:Moveset => [
		[1,:COMETPUNCH],
		[1,:LEER],
		[7,:FAKEOUT],
		[10,:TAILWHIP],
		[13,:BITE],
		[19,:DOUBLEHIT],
		[22,:RAGE],
		[25,:MEGAPUNCH],
		[31,:CHIPAWAY],
		[34,:DIZZYPUNCH],
		[37,:CRUNCH],
		[43,:ENDURE],
		[46,:OUTRAGE],
		[49,:SUCKERPUNCH],
		[50,:REVERSAL]],
	:tmlist => [:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:OUTRAGE,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:LOWKICK,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:IRONTAIL,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Monster],
	:Height => 22,
	:Weight => 800,
	:kind => "Parent",
	:dexentry => "If you come across a young Kangaskhan playing by itself, never try to catch it. The baby's parent is sure to be in the area, and it will become violently enraged.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:HORSEA => {
	:name => "Horsea",
	:dexnum => 116,
	:Type1 => :WATER,
	:BaseStats => [30, 40, 70, 60, 70, 25],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:SWIFTSWIM,:SNIPER],
	:HiddenAbilities => :DAMP,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 59,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AURORABEAM,:CLEARSMOG,:DISABLE,:DRAGONRAGE,:DRAGONBREATH,:FLAIL,:MUDDYWATER,:OCTAZOOKA,:OUTRAGE,:RAZORWIND,:SIGNALBEAM,:SPLASH,:WATERPULSE],
	:Moveset => [
		[1,:BUBBLE],
		[5,:SMOKESCREEN],
		[9,:LEER],
		[13,:WATERGUN],
		[17,:TWISTER],
		[21,:BUBBLEBEAM],
		[26,:FOCUSENERGY],
		[31,:BRINE],
		[36,:AGILITY],
		[41,:DRAGONPULSE],
		[46,:DRAGONDANCE],
		[52,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:OUTRAGE,:DRAGONPULSE,:TWISTER,:BOUNCE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:FLASHCANNON,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Dragon],
	:Height => 4,
	:Weight => 80,
	:WildItemUncommon => :DRAGONSCALE,
	:kind => "Dragon",
	:dexentry => "By cleverly flicking the fins on its back side to side, it moves in any direction while facing forward. It spits ink to escape if it senses danger.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 13,
	:evolutions => [
		[:SEADRA,:Level,32]
	]
},

:SEADRA => {
	:name => "Seadra",
	:dexnum => 117,
	:Type1 => :WATER,
	:BaseStats => [55, 65, 95, 85, 95, 45],
	:EVs => [0, 0, 1, 0, 1, 0],
	:Abilities => [:POISONPOINT,:SNIPER],
	:HiddenAbilities => :DAMP,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 154,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:HYDROPUMP],
		[1,:BUBBLE],
		[1,:SMOKESCREEN],
		[1,:LEER],
		[1,:WATERGUN],
		[5,:SMOKESCREEN],
		[9,:LEER],
		[13,:WATERGUN],
		[17,:TWISTER],
		[21,:BUBBLEBEAM],
		[26,:FOCUSENERGY],
		[31,:BRINE],
		[38,:AGILITY],
		[45,:DRAGONPULSE],
		[52,:DRAGONDANCE],
		[60,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:OUTRAGE,:DRAGONPULSE,:TWISTER,:BOUNCE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:FLASHCANNON,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Dragon],
	:Height => 12,
	:Weight => 250,
	:WildItemUncommon => :DRAGONSCALE,
	:kind => "Dragon",
	:dexentry => "The poisonous barbs over its body are highly valued as ingredients for traditional herbal medicine. It shows no mercy to anything approaching its nest.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 11,
	:evolutions => [
		[:KINGDRA,:TradeItem,:DRAGONSCALE]
	]
},

:GOLDEEN => {
	:name => "Goldeen",
	:dexnum => 118,
	:Type1 => :WATER,
	:BaseStats => [45, 67, 60, 63, 35, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:WATERVEIL],
	:HiddenAbilities => :LIGHTNINGROD,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 64,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AQUATAIL,:BODYSLAM,:HAZE,:HYDROPUMP,:MUDSHOT,:MUDSPORT,:MUDSLAP,:PSYBEAM,:SIGNALBEAM,:SKULLBASH,:SLEEPTALK],
	:Moveset => [
		[1,:PECK],
		[1,:TAILWHIP],
		[1,:WATERSPORT],
		[5,:SUPERSONIC],
		[8,:HORNATTACK],
		[13,:FLAIL],
		[16,:WATERPULSE],
		[21,:AQUARING],
		[24,:FURYATTACK],
		[29,:AGILITY],
		[32,:WATERFALL],
		[37,:HORNDRILL],
		[40,:SOAK],
		[45,:MEGAHORN]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:KNOCKOFF,:BOUNCE,:DRILLRUN,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:REST,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:SMARTSTRIKE,:THROATCHOP,],
	:Color => "Red",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water2],
	:Height => 6,
	:Weight => 150,
	:WildItemUncommon => :MYSTICWATER,
	:kind => "Goldfish",
	:dexentry => "In the springtime, schools of Goldeen can be seen swimming up falls and rivers. It metes out staggering damage with its single horn.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 11,
	:evolutions => [
		[:SEAKING,:Level,33]
	]
},

:SEAKING => {
	:name => "Seaking",
	:dexnum => 119,
	:Type1 => :WATER,
	:BaseStats => [80, 92, 65, 68, 65, 80],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:WATERVEIL],
	:HiddenAbilities => :LIGHTNINGROD,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 158,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:MEGAHORN],
		[1,:POISONJAB],
		[1,:PECK],
		[1,:TAILWHIP],
		[1,:WATERSPORT],
		[1,:SUPERSONIC],
		[5,:SUPERSONIC],
		[8,:HORNATTACK],
		[13,:FLAIL],
		[16,:WATERPULSE],
		[21,:AQUARING],
		[24,:FURYATTACK],
		[29,:AGILITY],
		[32,:WATERFALL],
		[40,:HORNDRILL],
		[46,:SOAK],
		[54,:MEGAHORN]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:KNOCKOFF,:BOUNCE,:DRILLRUN,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:REST,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:SMARTSTRIKE,:THROATCHOP,],
	:Color => "Red",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water2],
	:Height => 13,
	:Weight => 390,
	:WildItemUncommon => :MYSTICWATER,
	:kind => "Goldfish",
	:dexentry => "It punches holes in boulders on stream- beds. This is a clever innovation that prevents its eggs from being attacked or washed away by the current.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 10,
},

:STARYU => {
	:name => "Staryu",
	:dexnum => 120,
	:Type1 => :WATER,
	:BaseStats => [30, 45, 55, 85, 70, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:ILLUMINATE,:NATURALCURE],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 68,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:HARDEN],
		[4,:WATERGUN],
		[7,:RAPIDSPIN],
		[10,:RECOVER],
		[13,:PSYWAVE],
		[16,:SWIFT],
		[18,:BUBBLEBEAM],
		[22,:CAMOUFLAGE],
		[24,:GYROBALL],
		[28,:BRINE],
		[31,:MINIMIZE],
		[35,:REFLECTTYPE],
		[37,:POWERGEM],
		[40,:CONFUSERAY],
		[42,:PSYCHIC],
		[46,:LIGHTSCREEN],
		[49,:COSMICPOWER],
		[53,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:TWISTER,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:ROLLOUT,:FLASHCANNON,:GYROBALL,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Brown",
	:Habitat => "Sea",
	:EggGroups => [:Water3],
	:Height => 8,
	:Weight => 345,
	:WildItemCommon => :STARDUST,
	:WildItemUncommon => :STARPIECE,
	:kind => "Star Shape",
	:dexentry => "It gathers with others in the night and makes its red core glow on and off with the twinkling stars. It can regenerate limbs if they are severed from its body.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:STARMIE,:Item,:WATERSTONE]
	]
},

:STARMIE => {
	:name => "Starmie",
	:dexnum => 121,
	:Type1 => :WATER,
	:Type2 => :PSYCHIC,
	:BaseStats => [60, 75, 85, 115, 100, 85],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:ILLUMINATE,:NATURALCURE],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 182,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:HYDROPUMP],
		[1,:SPOTLIGHT],
		[1,:WATERGUN],
		[1,:RAPIDSPIN],
		[1,:RECOVER],
		[1,:SWIFT],
		[40,:CONFUSERAY]],
	:tmlist => [:SIGNALBEAM,:TWISTER,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:GRASSKNOT,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ALLYSWITCH,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROLLOUT,:FLASHCANNON,:GYROBALL,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Purple",
	:Habitat => "Sea",
	:EggGroups => [:Water3],
	:Height => 11,
	:Weight => 800,
	:WildItemCommon => :STARDUST,
	:WildItemUncommon => :STARPIECE,
	:kind => "Mysterious",
	:dexentry => "People in ancient times imagined that Starmie were transformed from the reflections of stars that twinkled on gentle waves at night.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:MRMIME => {
	:name => "Mr. Mime",
	:dexnum => 122,
	:Type1 => :PSYCHIC,
	:Type2 => :FAIRY,
	:BaseStats => [40, 45, 65, 90, 100, 120],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:SOUNDPROOF,:FILTER],
	:HiddenAbilities => :TECHNICIAN,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:CONFUSERAY,:FAKEOUT,:FUTURESIGHT,:HYPNOSIS,:ICYWIND,:MAGICROOM,:MIMIC,:NASTYPLOT,:POWERSPLIT,:PSYCHICTERRAIN,:TEETERDANCE,:TRICK,:WAKEUPSLAP],
	:Moveset => [
		[1,:MISTYTERRAIN],
		[1,:MAGICALLEAF],
		[1,:QUICKGUARD],
		[1,:WIDEGUARD],
		[1,:POWERSWAP],
		[1,:GUARDSWAP],
		[1,:BARRIER],
		[1,:POUND],
		[1,:CONFUSION],
		[4,:COPYCAT],
		[8,:MEDITATE],
		[11,:DOUBLESLAP],
		[15,:MIMIC],
		[15,:PSYWAVE],
		[18,:ENCORE],
		[22,:LIGHTSCREEN],
		[22,:REFLECT],
		[25,:PSYBEAM],
		[29,:SUBSTITUTE],
		[32,:RECYCLE],
		[36,:TRICK],
		[39,:PSYCHIC],
		[43,:ROLEPLAY],
		[46,:BATONPASS],
		[50,:SAFEGUARD]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:PAYBACK,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Pink",
	:Habitat => "Urban",
	:EggGroups => [:HumanLike],
	:Height => 13,
	:Weight => 545,
	:kind => "Barrier",
	:dexentry => "A Mr. Mime is a master of pantomime. It can convince others that something unseeable exists. Once believed, the imaginary object becomes real.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:SCYTHER => {
	:name => "Scyther",
	:dexnum => 123,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [70, 110, 80, 105, 55, 80],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SWARM,:TECHNICIAN],
	:HiddenAbilities => :STEADFAST,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 100,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:BATONPASS,:BUGBUZZ,:COUNTER,:DEFOG,:ENDURE,:NIGHTSLASH,:QUICKGUARD,:RAZORWIND,:REVERSAL,:SILVERWIND,:STEELWING],
	:Moveset => [
		[1,:VACUUMWAVE],
		[1,:QUICKATTACK],
		[1,:LEER],
		[5,:FOCUSENERGY],
		[9,:PURSUIT],
		[13,:FALSESWIPE],
		[17,:AGILITY],
		[21,:WINGATTACK],
		[25,:FURYCUTTER],
		[29,:SLASH],
		[33,:RAZORWIND],
		[37,:DOUBLETEAM],
		[41,:XSCISSOR],
		[45,:NIGHTSLASH],
		[49,:DOUBLEHIT],
		[53,:AIRSLASH],
		[57,:SWORDSDANCE],
		[61,:FEINT]],
	:tmlist => [:XSCISSOR,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:THIEF,:KNOCKOFF,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:LIGHTSCREEN,:REST,:STEELWING,:RAINDANCE,:CONFIDE,:BRUTALSWING,:LASERFOCUS,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Bug],
	:Height => 15,
	:Weight => 560,
	:kind => "Mantis",
	:dexentry => "Its blindingly fast speed adds to the sharpness of its twin forearm scythes. The scythes can slice through thick logs in one wicked stroke.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SCIZOR,:TradeItem,:METALCOAT]
	]
},

:JYNX => {
	:name => "Jynx",
	:dexnum => 124,
	:Type1 => :ICE,
	:Type2 => :PSYCHIC,
	:BaseStats => [65, 50, 35, 95, 115, 95],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:OBLIVIOUS,:FOREWARN],
	:HiddenAbilities => :DRYSKIN,
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 159,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:DRAININGKISS],
		[1,:PERISHSONG],
		[1,:POUND],
		[1,:LICK],
		[1,:LOVELYKISS],
		[1,:POWDERSNOW],
		[5,:LICK],
		[8,:LOVELYKISS],
		[11,:POWDERSNOW],
		[15,:DOUBLESLAP],
		[18,:ICEPUNCH],
		[21,:HEARTSTAMP],
		[25,:MEANLOOK],
		[28,:FAKETEARS],
		[33,:WAKEUPSLAP],
		[39,:AVALANCHE],
		[44,:BODYSLAM],
		[49,:WRINGOUT],
		[55,:PERISHSONG],
		[60,:BLIZZARD]],
	:tmlist => [:SIGNALBEAM,:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:AURORAVEIL,],
	:Color => "Red",
	:Habitat => "Urban",
	:EggGroups => [:HumanLike],
	:Height => 14,
	:Weight => 406,
	:kind => "Human Shape",
	:dexentry => "A Jynx sashays rhythmically as if it were dancing. Its motions are so bouncingly alluring, people seeing it are compelled to shake their hips without noticing.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:ELECTABUZZ => {
	:name => "Electabuzz",
	:dexnum => 125,
	:Type1 => :ELECTRIC,
	:BaseStats => [65, 83, 57, 105, 95, 85],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:STATIC,:VITALSPIRIT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 172,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:QUICKATTACK],
		[1,:LEER],
		[1,:THUNDERSHOCK],
		[5,:THUNDERSHOCK],
		[8,:LOWKICK],
		[12,:SWIFT],
		[15,:SHOCKWAVE],
		[19,:THUNDERWAVE],
		[22,:ELECTROBALL],
		[26,:LIGHTSCREEN],
		[29,:THUNDERPUNCH],
		[36,:DISCHARGE],
		[42,:SCREECH],
		[49,:THUNDERBOLT],
		[55,:THUNDER]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:DUALCHOP,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:HumanLike],
	:Height => 11,
	:Weight => 300,
	:WildItemUncommon => :ELECTIRIZER,
	:kind => "Electric",
	:dexentry => "Electricity permeates its body. It swings its arms round and round to charge up electricity before unleashing a punch.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ELECTIVIRE,:TradeItem,:ELECTIRIZER]
	]
},

:MAGMAR => {
	:name => "Magmar",
	:dexnum => 126,
	:Type1 => :FIRE,
	:BaseStats => [65, 95, 57, 93, 100, 85],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:FLAMEBODY,:VITALSPIRIT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:SMOG],
		[1,:LEER],
		[1,:EMBER],
		[5,:EMBER],
		[8,:SMOKESCREEN],
		[12,:FEINTATTACK],
		[15,:FIRESPIN],
		[19,:CLEARSMOG],
		[22,:FLAMEBURST],
		[26,:CONFUSERAY],
		[29,:FIREPUNCH],
		[36,:LAVAPLUME],
		[42,:SUNNYDAY],
		[49,:FLAMETHROWER],
		[55,:FIREBLAST]],
	:tmlist => [:THIEF,:FLING,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:REST,:IRONTAIL,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:HumanLike],
	:Height => 13,
	:Weight => 445,
	:WildItemUncommon => :MAGMARIZER,
	:kind => "Spitfire",
	:dexentry => "It blows out intense flames from all over its body to intimidate its foe. These fiery bursts create heat waves that ignite grass and trees in the area.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MAGMORTAR,:TradeItem,:MAGMARIZER]
	]
},

:PINSIR => {
	:name => "Pinsir",
	:dexnum => 127,
	:Type1 => :BUG,
	:BaseStats => [65, 125, 100, 85, 55, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:MOLDBREAKER],
	:HiddenAbilities => :MOXIE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:BUGBITE,:CLOSECOMBAT,:FEINTATTACK,:FEINT,:FLAIL,:FURYATTACK,:MEFIRST,:QUICKATTACK,:SUPERPOWER],
	:Moveset => [
		[1,:VICEGRIP],
		[1,:FOCUSENERGY],
		[4,:BIND],
		[8,:SEISMICTOSS],
		[11,:HARDEN],
		[15,:REVENGE],
		[18,:VITALTHROW],
		[22,:DOUBLEHIT],
		[26,:BRICKBREAK],
		[29,:XSCISSOR],
		[33,:SUBMISSION],
		[36,:STORMTHROW],
		[40,:SWORDSDANCE],
		[43,:THRASH],
		[47,:SUPERPOWER],
		[50,:GUILLOTINE]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:STRINGSHOT,:THIEF,:KNOCKOFF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:BULKUP,:SUNNYDAY,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:STEALTHROCK,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:BRUTALSWING,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 15,
	:Weight => 550,
	:kind => "Stag Beetle",
	:dexentry => "Their pincers are strong enough to shatter thick logs. Because they dislike cold, Pinsir burrow and sleep under the ground on chilly nights.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:TAUROS => {
	:name => "Tauros",
	:dexnum => 128,
	:Type1 => :NORMAL,
	:BaseStats => [75, 100, 95, 110, 40, 70],
	:EVs => [0, 1, 0, 1, 0, 0],
	:Abilities => [:INTIMIDATE,:ANGERPOINT],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemZero",
	:BaseEXP => 172,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[3,:TAILWHIP],
		[5,:RAGE],
		[8,:HORNATTACK],
		[11,:SCARYFACE],
		[15,:PURSUIT],
		[19,:REST],
		[24,:PAYBACK],
		[29,:WORKUP],
		[35,:TAKEDOWN],
		[41,:ZENHEADBUTT],
		[48,:SWAGGER],
		[55,:THRASH],
		[63,:DOUBLEEDGE],
		[71,:GIGAIMPACT]],
	:tmlist => [:PAYBACK,:OUTRAGE,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:SPITE,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:MAGICCOAT,:REST,:ROLEPLAY,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:IRONTAIL,:IRONHEAD,:SURF,:WATERPULSE,:RAINDANCE,:CONFIDE,:SMARTSTRIKE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 14,
	:Weight => 884,
	:kind => "Wild Bull",
	:dexentry => "It is not satisfied unless it is rampaging at all times. If there is no opponent for Tauros to battle, it will charge at thick trees and knock them down to calm itself.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:MAGIKARP => {
	:name => "Magikarp",
	:dexnum => 129,
	:Type1 => :WATER,
	:BaseStats => [20, 10, 55, 80, 15, 20],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SWIFTSWIM,:RATTLED],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 40,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 1530,
	:Moveset => [
		[1,:SPLASH],
		[15,:TACKLE],
		[30,:FLAIL]],
	:tmlist => [:BOUNCE,:CELEBRATE,],
	:Color => "Red",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water2,:Dragon],
	:Height => 9,
	:Weight => 100,
	:kind => "Fish",
	:dexentry => "Its swimming muscles are weak, so it is easily washed away. In places where water pools, you can see many Magikarp deposited there by the flow.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 10,
	:evolutions => [
		[:GYARADOS,:Level,20]
	]
},

:GYARADOS => {
	:name => "Gyarados",
	:dexnum => 130,
	:Type1 => :WATER,
	:Type2 => :FLYING,
	:BaseStats => [95, 125, 79, 81, 60, 100],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:MOXIE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 189,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 1530,
	:Moveset => [
		[0,:BITE],
		[1,:THRASH],
		[21,:LEER],
		[24,:TWISTER],
		[27,:ICEFANG],
		[30,:AQUATAIL],
		[33,:SCARYFACE],
		[36,:DRAGONRAGE],
		[39,:CRUNCH],
		[42,:HYDROPUMP],
		[45,:DRAGONDANCE],
		[48,:HURRICANE],
		[51,:RAINDANCE],
		[54,:HYPERBEAM]],
	:tmlist => [:DARKPULSE,:PAYBACK,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:THUNDERWAVE,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:BOUNCE,:SPITE,:EARTHQUAKE,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:SANDSTORM,:IRONTAIL,:IRONHEAD,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:BRUTALSWING,:CELEBRATE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water2,:Dragon],
	:Height => 65,
	:Weight => 2350,
	:kind => "Atrocious",
	:dexentry => "It is an extremely vicious and violent Pokémon. When humans begin to fight, it will appear and burn everything to the ground with intensely hot flames.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 2,
	:BattlerAltitude => 2,
},

:LAPRAS => {
	:name => "Lapras",
	:dexnum => 131,
	:Type1 => :WATER,
	:Type2 => :ICE,
	:BaseStats => [130, 85, 80, 60, 85, 95],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:WATERABSORB,:SHELLARMOR],
	:HiddenAbilities => :HYDRATION,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 187,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 10455,
	:EggMoves => [:ANCIENTPOWER,:AVALANCHE,:CURSE,:DRAGONDANCE,:DRAGONPULSE,:FISSURE,:FORESIGHT,:FUTURESIGHT,:FREEZEDRY,:HORNDRILL,:REFRESH,:SLEEPTALK,:TICKLE,:WHIRLPOOL],
	:Moveset => [
		[1,:SING],
		[1,:GROWL],
		[1,:WATERGUN],
		[4,:MIST],
		[7,:CONFUSERAY],
		[10,:ICESHARD],
		[14,:WATERPULSE],
		[18,:BODYSLAM],
		[22,:RAINDANCE],
		[27,:PERISHSONG],
		[32,:ICEBEAM],
		[37,:BRINE],
		[43,:SAFEGUARD],
		[47,:HYDROPUMP],
		[50,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:OUTRAGE,:DRAGONPULSE,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ROCKSMASH,:DRILLRUN,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:HEALBELL,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:REST,:ANCIENTPOWER,:IRONTAIL,:IRONHEAD,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:SMARTSTRIKE,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Monster,:Water1],
	:Height => 25,
	:Weight => 2200,
	:WildItemCommon => :MYSTICWATER,
	:WildItemUncommon => :MYSTICWATER,
	:WildItemRare => :MYSTICWATER,
	:kind => "Transport",
	:dexentry => "People have driven Lapras almost to the point of extinction. In the evenings, it is said to sing plaintively as it seeks what few others of its kind still remain.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:DITTO => {
	:name => "Ditto",
	:dexnum => 132,
	:Type1 => :NORMAL,
	:BaseStats => [48, 48, 48, 48, 48, 48],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:LIMBER,:IMPOSTER],
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 101,
	:CatchRate => 35,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TRANSFORM]],
	:tmlist => [],
	:Color => "Purple",
	:Habitat => "Urban",
	:EggGroups => [],
	:Height => 3,
	:Weight => 40,
	:WildItemCommon => :QUICKPOWDER,
	:WildItemUncommon => :METALPOWDER,
	:kind => "Transform",
	:dexentry => "A Ditto rearranges its cell structure to transform itself. However, if it tries to change based on its memory, it will get details wrong.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
},

:EEVEE => {
	:name => "Eevee",
	:dexnum => 133,
	:Type1 => :NORMAL,
	:BaseStats => [55, 55, 50, 55, 45, 65],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:RUNAWAY,:ADAPTABILITY],
	:HiddenAbilities => :ANTICIPATION,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 65,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 9180,
	:EggMoves => [:CAPTIVATE,:CHARM,:COVET,:CURSE,:DETECT,:ENDURE,:FAKETEARS,:FLAIL,:NATURALGIFT,:STOREDPOWER,:SYNCHRONOISE,:TICKLE,:WISH,:YAWN],
	:Moveset => [
		[1,:COVET],
		[1,:HELPINGHAND],
		[1,:GROWL],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[5,:SANDATTACK],
		[9,:BABYDOLLEYES],
		[13,:QUICKATTACK],
		[17,:BITE],
		[17,:SWIFT],
		[20,:REFRESH],
		[25,:TAKEDOWN],
		[29,:CHARM],
		[33,:BATONPASS],
		[37,:DOUBLEEDGE],
		[41,:LASTRESORT],
		[45,:TRUMPCARD]],
	:tmlist => [:SUNNYDAY,:SHADOWBALL,:MUDSLAP,:LASTRESORT,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HEALBELL,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Brown",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 3,
	:Weight => 65,
	:kind => "Evolution",
	:dexentry => "An Eevee has an unstable genetic makeup that suddenly mutates due to its environment. Radiation from various stones causes this Pokémon to evolve.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:VAPOREON,:Item,:WATERSTONE],
		[:JOLTEON,:Item,:THUNDERSTONE],
		[:FLAREON,:Item,:FIRESTONE],
		[:LEAFEON,:Item,:LEAFSTONE],
		[:GLACEON,:Item,:ICESTONE],
		[:LEAFEON,:Location,465],
		[:GLACEON,:Location,433],
		[:SYLVEON,:Affection,18],
		[:ESPEON,:HappinessDay,0],
		[:UMBREON,:HappinessNight,0]
	]
},

:VAPOREON => {
	:name => "Vaporeon",
	:dexnum => 134,
	:Type1 => :WATER,
	:BaseStats => [130, 65, 60, 65, 110, 95],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:WATERABSORB,:WATERABSORB],
	:HiddenAbilities => :HYDRATION,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 184,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 9180,
	:Moveset => [
		[0,:WATERGUN],
		[1,:HELPINGHAND],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[5,:SANDATTACK],
		[9,:BABYDOLLEYES],
		[13,:QUICKATTACK],
		[17,:WATERPULSE],
		[20,:AURORABEAM],
		[25,:AQUARING],
		[29,:ACIDARMOR],
		[33,:HAZE],
		[37,:MUDDYWATER],
		[41,:LASTRESORT],
		[45,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HEALBELL,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Blue",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 290,
	:kind => "Bubble Jet",
	:dexentry => "Vaporeon underwent a spontaneous mutation and grew fins and gills that allow them to live underwater. They have the ability to freely control water.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:JOLTEON => {
	:name => "Jolteon",
	:dexnum => 135,
	:Type1 => :ELECTRIC,
	:BaseStats => [65, 65, 60, 130, 110, 95],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:VOLTABSORB,:VOLTABSORB],
	:HiddenAbilities => :QUICKFEET,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 184,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 9180,
	:Moveset => [
		[0,:THUNDERSHOCK],
		[1,:HELPINGHAND],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[5,:SANDATTACK],
		[9,:BABYDOLLEYES],
		[13,:QUICKATTACK],
		[17,:DOUBLEKICK],
		[20,:THUNDERFANG],
		[25,:PINMISSILE],
		[29,:AGILITY],
		[33,:THUNDERWAVE],
		[37,:DISCHARGE],
		[41,:LASTRESORT],
		[45,:THUNDER]],
	:tmlist => [:SIGNALBEAM,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Yellow",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 8,
	:Weight => 245,
	:kind => "Lightning",
	:dexentry => "Its cells generate weak power that is amplified by its fur's static electricity to drop thunderbolts. The bristling fur is made of electrically charged needles.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:FLAREON => {
	:name => "Flareon",
	:dexnum => 136,
	:Type1 => :FIRE,
	:BaseStats => [65, 130, 60, 65, 95, 110],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:FLASHFIRE,:FLASHFIRE],
	:HiddenAbilities => :GUTS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 184,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 9180,
	:Moveset => [
		[0,:EMBER],
		[1,:HELPINGHAND],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[5,:SANDATTACK],
		[9,:BABYDOLLEYES],
		[13,:QUICKATTACK],
		[17,:BITE],
		[20,:FIREFANG],
		[25,:FIRESPIN],
		[29,:SCARYFACE],
		[33,:SMOG],
		[37,:LAVAPLUME],
		[41,:LASTRESORT],
		[45,:FLAREBLITZ]],
	:tmlist => [:SUPERPOWER,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HEALBELL,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Red",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 9,
	:Weight => 250,
	:kind => "Flame",
	:dexentry => "Flareon's fluffy fur releases heat into the air so that its body does not get excessively hot. Its body temperature can rise to a maximum of 1,650 degrees F.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:PORYGON => {
	:name => "Porygon",
	:dexnum => 137,
	:Type1 => :NORMAL,
	:BaseStats => [65, 60, 70, 40, 85, 75],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:TRACE,:DOWNLOAD],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 79,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:CONVERSION2],
		[1,:TACKLE],
		[1,:CONVERSION],
		[1,:SHARPEN],
		[7,:PSYBEAM],
		[12,:AGILITY],
		[18,:RECOVER],
		[23,:MAGNETRISE],
		[29,:SIGNALBEAM],
		[34,:RECYCLE],
		[40,:DISCHARGE],
		[45,:LOCKON],
		[50,:TRIATTACK],
		[56,:MAGICCOAT],
		[62,:ZAPCANNON]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:THIEF,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SOLARBEAM,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:GRAVITY,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:RAINDANCE,],
	:Color => "Pink",
	:Habitat => "Urban",
	:EggGroups => [:Mineral],
	:Height => 8,
	:Weight => 365,
	:kind => "Virtual",
	:dexentry => "It is capable of reverting itself entirely back to program data in order to enter cyberspace. A Porygon is copy- protected so it cannot be duplicated.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 8,
	:evolutions => [
		[:PORYGON2,:TradeItem,:UPGRADE]
	]
},

:OMANYTE => {
	:name => "Omanyte",
	:dexnum => 138,
	:Type1 => :ROCK,
	:Type2 => :WATER,
	:BaseStats => [35, 40, 100, 35, 90, 55],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:SHELLARMOR],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 71,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:AURORABEAM,:BIDE,:BUBBLEBEAM,:HAZE,:KNOCKOFF,:MUDDYWATER,:REFLECTTYPE,:SLAM,:SPIKES,:SUPERSONIC,:TOXICSPIKES,:WATERPULSE,:WHIRLPOOL,:WRINGOUT],
	:Moveset => [
		[1,:CONSTRICT],
		[1,:WITHDRAW],
		[7,:BITE],
		[10,:WATERGUN],
		[16,:ROLLOUT],
		[19,:LEER],
		[25,:MUDSHOT],
		[28,:BRINE],
		[34,:PROTECT],
		[37,:ANCIENTPOWER],
		[43,:TICKLE],
		[46,:ROCKBLAST],
		[50,:SHELLSMASH],
		[55,:HYDROPUMP]],
	:tmlist => [:THIEF,:KNOCKOFF,:ROCKSMASH,:EARTHPOWER,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:GYROBALL,:IRONDEFENSE,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Water3],
	:Height => 4,
	:Weight => 75,
	:kind => "Spiral",
	:dexentry => "An ancient and long-since-extinct Pokémon that has been regenerated from fossils. If attacked, it withdraws into its hard shell.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:OMASTAR,:Level,40]
	]
},

:OMASTAR => {
	:name => "Omastar",
	:dexnum => 139,
	:Type1 => :ROCK,
	:Type2 => :WATER,
	:BaseStats => [70, 60, 125, 55, 115, 70],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:SHELLARMOR],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:Moveset => [
		[0,:SPIKECANNON],
		[1,:HYDROPUMP],
		[1,:CONSTRICT],
		[1,:WITHDRAW],
		[1,:BITE],
		[7,:BITE],
		[10,:WATERGUN],
		[16,:ROLLOUT],
		[19,:LEER],
		[25,:MUDSHOT],
		[28,:BRINE],
		[34,:PROTECT],
		[37,:ANCIENTPOWER],
		[48,:TICKLE],
		[56,:ROCKBLAST],
		[67,:SHELLSMASH],
		[75,:HYDROPUMP]],
	:tmlist => [:THIEF,:KNOCKOFF,:ROCKSMASH,:EARTHPOWER,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:GYROBALL,:IRONDEFENSE,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Water3],
	:Height => 10,
	:Weight => 350,
	:kind => "Spiral",
	:dexentry => "An Omastar uses its tentacles to capture its prey. It became extinct because its shell grew too large, making its movements slow and ponderous.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:KABUTO => {
	:name => "Kabuto",
	:dexnum => 140,
	:Type1 => :ROCK,
	:Type2 => :WATER,
	:BaseStats => [30, 80, 90, 55, 55, 45],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:BATTLEARMOR],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 71,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:AURORABEAM,:BUBBLEBEAM,:CONFUSERAY,:FLAIL,:FORESIGHT,:GIGADRAIN,:ICYWIND,:KNOCKOFF,:MUDSHOT,:RAPIDSPIN,:SCREECH,:TAKEDOWN],
	:Moveset => [
		[1,:SCRATCH],
		[1,:HARDEN],
		[6,:ABSORB],
		[11,:LEER],
		[16,:MUDSHOT],
		[21,:SANDATTACK],
		[26,:ENDURE],
		[31,:AQUAJET],
		[36,:MEGADRAIN],
		[41,:METALSOUND],
		[46,:ANCIENTPOWER],
		[50,:WRINGOUT]],
	:tmlist => [:THIEF,:KNOCKOFF,:ROCKSMASH,:GIGADRAIN,:EARTHPOWER,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONDEFENSE,:SURF,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Water3],
	:Height => 5,
	:Weight => 115,
	:kind => "Shellfish",
	:dexentry => "A Pokémon that has been regenerated from a fossil. However, living examples have been discovered. Kabuto haven't changed for 300 million years.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
	:evolutions => [
		[:KABUTOPS,:Level,40]
	]
},

:KABUTOPS => {
	:name => "Kabutops",
	:dexnum => 141,
	:Type1 => :ROCK,
	:Type2 => :WATER,
	:BaseStats => [60, 115, 105, 80, 65, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:BATTLEARMOR],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:Moveset => [
		[0,:SLASH],
		[1,:NIGHTSLASH],
		[1,:FEINT],
		[1,:SCRATCH],
		[1,:HARDEN],
		[1,:ABSORB],
		[1,:LEER],
		[6,:ABSORB],
		[11,:LEER],
		[16,:MUDSHOT],
		[21,:SANDATTACK],
		[26,:ENDURE],
		[31,:AQUAJET],
		[36,:MEGADRAIN],
		[45,:METALSOUND],
		[54,:ANCIENTPOWER],
		[63,:WRINGOUT],
		[72,:NIGHTSLASH]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:THIEF,:KNOCKOFF,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:AERIALACE,:GIGADRAIN,:EARTHPOWER,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONDEFENSE,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Brown",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Water3],
	:Height => 13,
	:Weight => 405,
	:kind => "Shellfish",
	:dexentry => "Kabutops once swam underwater to hunt for prey. It evolved from being a water dweller to living on land as evident from changes in its gills and legs.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:AERODACTYL => {
	:name => "Aerodactyl",
	:dexnum => 142,
	:Type1 => :ROCK,
	:Type2 => :FLYING,
	:BaseStats => [80, 105, 65, 130, 60, 75],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:ROCKHEAD,:PRESSURE],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 180,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 9180,
	:EggMoves => [:ASSURANCE,:CURSE,:DRAGONBREATH,:FORESIGHT,:PURSUIT,:ROOST,:STEELWING,:TAILWIND,:WHIRLWIND,:WIDEGUARD],
	:Moveset => [
		[1,:IRONHEAD],
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:WINGATTACK],
		[1,:SUPERSONIC],
		[1,:BITE],
		[1,:SCARYFACE],
		[9,:ROAR],
		[17,:AGILITY],
		[25,:ANCIENTPOWER],
		[33,:CRUNCH],
		[41,:TAKEDOWN],
		[49,:SKYDROP],
		[57,:IRONHEAD],
		[65,:HYPERBEAM],
		[73,:ROCKSLIDE],
		[81,:GIGAIMPACT]],
	:tmlist => [:PAYBACK,:THIEF,:TAUNT,:TORMENT,:DRAGONPULSE,:DRAGONCLAW,:TWISTER,:ROCKSMASH,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:STEELWING,:AQUATAIL,:RAINDANCE,:CONFIDE,:BRUTALSWING,:LASERFOCUS,:CELEBRATE,],
	:Color => "Purple",
	:Habitat => "Mountain",
	:EggGroups => [:Flying],
	:Height => 18,
	:Weight => 590,
	:kind => "Fossil",
	:dexentry => "Aerodactyl is a Pokémon from the age of dinosaurs. It was regenerated from DNA extracted from amber. It is imagined to have been the king of the skies.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 20,
},

:SNORLAX => {
	:name => "Snorlax",
	:dexnum => 143,
	:Type1 => :NORMAL,
	:BaseStats => [160, 110, 65, 30, 65, 110],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:IMMUNITY,:THICKFAT],
	:HiddenAbilities => :GLUTTONY,
	:GrowthRate => "Slow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 189,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 10455,
	:EggMoves => [:AFTERYOU,:BELCH,:CHARM,:COUNTER,:CURSE,:DOUBLEEDGE,:FISSURE,:LICK,:NATURALGIFT,:POWERUPPUNCH,:PURSUIT,:WHIRLWIND],
	:Moveset => [
		[1,:TACKLE],
		[4,:DEFENSECURL],
		[9,:AMNESIA],
		[12,:LICK],
		[17,:CHIPAWAY],
		[20,:YAWN],
		[25,:BODYSLAM],
		[28,:REST],
		[28,:SNORE],
		[33,:SLEEPTALK],
		[35,:GIGAIMPACT],
		[36,:ROLLOUT],
		[41,:BLOCK],
		[44,:BELLYDRUM],
		[49,:CRUNCH],
		[50,:HEAVYSLAM],
		[57,:HIGHHORSEPOWER]],
	:tmlist => [:FLING,:OUTRAGE,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:SEEDBOMB,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:PSYCHIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:SANDSTORM,:IRONHEAD,:SURF,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,:CELEBRATE,],
	:Color => "Black",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 21,
	:Weight => 4600,
	:WildItemCommon => :LEFTOVERS,
	:WildItemUncommon => :LEFTOVERS,
	:WildItemRare => :LEFTOVERS,
	:kind => "Sleeping",
	:dexentry => "Snorlax's typical day consists of eating and sleeping. It is such a docile Pokémon that there are children who use its big belly as a place to play.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:ARTICUNO => {
	:name => "Articuno",
	:dexnum => 144,
	:Type1 => :ICE,
	:Type2 => :FLYING,
	:BaseStats => [90, 85, 100, 85, 95, 125],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:PRESSURE,:SNOWCLOAK],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:GUST],
		[1,:POWDERSNOW],
		[8,:MIST],
		[15,:ICESHARD],
		[22,:MINDREADER],
		[29,:ANCIENTPOWER],
		[36,:AGILITY],
		[43,:FREEZEDRY],
		[50,:REFLECT],
		[57,:HAIL],
		[64,:TAILWIND],
		[71,:ICEBEAM],
		[78,:BLIZZARD],
		[85,:ROOST],
		[92,:HURRICANE],
		[99,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:UTURN,:TWISTER,:ROCKSMASH,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REFLECT,:REST,:ANCIENTPOWER,:SANDSTORM,:STEELWING,:WATERPULSE,:RAINDANCE,:CONFIDE,:AURORAVEIL,:LASERFOCUS,],
	:Color => "Blue",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 17,
	:Weight => 554,
	:kind => "Freeze",
	:dexentry => "Articuno is a legendary bird Pokémon that can control ice. The flapping of its wings chills the air. It is said that when this Pokémon flies, snow will fall.",
	:BattlerPlayerY => 5,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
},

:ZAPDOS => {
	:name => "Zapdos",
	:dexnum => 145,
	:Type1 => :ELECTRIC,
	:Type2 => :FLYING,
	:BaseStats => [90, 90, 85, 100, 125, 90],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:PRESSURE,:STATIC],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:PECK],
		[1,:THUNDERSHOCK],
		[8,:THUNDERWAVE],
		[15,:DETECT],
		[22,:PLUCK],
		[29,:ANCIENTPOWER],
		[36,:CHARGE],
		[43,:AGILITY],
		[50,:DISCHARGE],
		[57,:RAINDANCE],
		[64,:LIGHTSCREEN],
		[71,:DRILLPECK],
		[78,:THUNDER],
		[85,:ROOST],
		[92,:MAGNETICFLUX],
		[99,:ZAPCANNON]],
	:tmlist => [:SIGNALBEAM,:UTURN,:TWISTER,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ANCIENTPOWER,:SANDSTORM,:STEELWING,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Yellow",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 16,
	:Weight => 526,
	:kind => "Electric",
	:dexentry => "Zapdos is a legendary bird Pokémon that has the ability to control electricity. It usually lives in thunderclouds. It gains power if it is stricken by lightning bolts.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 8,
},

:MOLTRES => {
	:name => "Moltres",
	:dexnum => 146,
	:Type1 => :FIRE,
	:Type2 => :FLYING,
	:BaseStats => [90, 100, 90, 90, 125, 85],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:PRESSURE,:FLAMEBODY],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:WINGATTACK],
		[1,:EMBER],
		[8,:FIRESPIN],
		[15,:AGILITY],
		[22,:ENDURE],
		[29,:ANCIENTPOWER],
		[36,:FLAMETHROWER],
		[43,:SAFEGUARD],
		[50,:AIRSLASH],
		[57,:SUNNYDAY],
		[64,:HEATWAVE],
		[71,:SOLARBEAM],
		[78,:SKYATTACK],
		[85,:ROOST],
		[92,:HURRICANE],
		[99,:BURNUP]],
	:tmlist => [:UTURN,:TWISTER,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ANCIENTPOWER,:SANDSTORM,:STEELWING,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Yellow",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 20,
	:Weight => 600,
	:kind => "Flame",
	:dexentry => "Moltres is a legendary bird Pokémon that can control fire. If injured, it is said to dip its body in the molten magma of a volcano to burn and heal itself.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
},

:DRATINI => {
	:name => "Dratini",
	:dexnum => 147,
	:Type1 => :DRAGON,
	:BaseStats => [41, 64, 45, 50, 50, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SHEDSKIN,:MARVELSCALE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:EggMoves => [:AQUAJET,:DRAGONBREATH,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRUSH,:EXTREMESPEED,:HAZE,:IRONTAIL,:MIST,:SUPERSONIC,:WATERPULSE],
	:Moveset => [
		[1,:WRAP],
		[1,:LEER],
		[5,:THUNDERWAVE],
		[11,:TWISTER],
		[15,:DRAGONRAGE],
		[21,:SLAM],
		[25,:AGILITY],
		[31,:DRAGONTAIL],
		[35,:AQUATAIL],
		[41,:DRAGONRUSH],
		[45,:SAFEGUARD],
		[51,:DRAGONDANCE],
		[55,:OUTRAGE],
		[61,:HYPERBEAM]],
	:tmlist => [:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:SURF,:AQUATAIL,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:BRUTALSWING,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Dragon],
	:Height => 18,
	:Weight => 33,
	:WildItemUncommon => :DRAGONSCALE,
	:kind => "Dragon",
	:dexentry => "A Dratini continually molts and sloughs off its old skin. It does so because the life energy within its body steadily builds to reach uncontrollable levels.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DRAGONAIR,:Level,30]
	]
},

:DRAGONAIR => {
	:name => "Dragonair",
	:dexnum => 148,
	:Type1 => :DRAGON,
	:BaseStats => [61, 84, 65, 70, 70, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SHEDSKIN,:MARVELSCALE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 147,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[1,:WRAP],
		[1,:LEER],
		[1,:THUNDERWAVE],
		[1,:TWISTER],
		[5,:THUNDERWAVE],
		[11,:TWISTER],
		[15,:DRAGONRAGE],
		[21,:SLAM],
		[25,:AGILITY],
		[33,:DRAGONTAIL],
		[39,:AQUATAIL],
		[47,:DRAGONRUSH],
		[53,:SAFEGUARD],
		[61,:DRAGONDANCE],
		[67,:OUTRAGE],
		[75,:HYPERBEAM]],
	:tmlist => [:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:SURF,:AQUATAIL,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:BRUTALSWING,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Dragon],
	:Height => 40,
	:Weight => 165,
	:WildItemUncommon => :DRAGONSCALE,
	:kind => "Dragon",
	:dexentry => "A Dragonair stores an enormous amount of energy inside its body. It alters the weather around it by loosing energy from the crystals on its neck and tail.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DRAGONITE,:Level,55]
	]
},

:DRAGONITE => {
	:name => "Dragonite",
	:dexnum => 149,
	:Type1 => :DRAGON,
	:Type2 => :FLYING,
	:BaseStats => [91, 134, 95, 80, 100, 100],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:INNERFOCUS,:MULTISCALE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 270,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[0,:WINGATTACK],
		[1,:HURRICANE],
		[1,:FIREPUNCH],
		[1,:THUNDERPUNCH],
		[1,:ROOST],
		[1,:WRAP],
		[1,:LEER],
		[1,:THUNDERWAVE],
		[1,:TWISTER],
		[5,:THUNDERWAVE],
		[11,:TWISTER],
		[15,:DRAGONRAGE],
		[21,:SLAM],
		[25,:AGILITY],
		[33,:DRAGONTAIL],
		[39,:AQUATAIL],
		[47,:DRAGONRUSH],
		[53,:SAFEGUARD],
		[61,:DRAGONDANCE],
		[67,:OUTRAGE],
		[75,:HYPERBEAM],
		[81,:HURRICANE]],
	:tmlist => [:FURYCUTTER,:FLING,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:IRONTAIL,:IRONHEAD,:STEELWING,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,],
	:Color => "Brown",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Dragon],
	:Height => 22,
	:Weight => 2100,
	:WildItemUncommon => :DRAGONSCALE,
	:kind => "Dragon",
	:dexentry => "It can circle the globe in just 16 hours. It is a kindhearted Pokémon that leads lost and foundering ships in a storm to the safety of land.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 3,
	:BattlerAltitude => 0,
},

:MEWTWO => {
	:name => "Mewtwo",
	:dexnum => 150,
	:Type1 => :PSYCHIC,
	:BaseStats => [106, 110, 90, 130, 154, 90],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:PRESSURE,:UNNERVE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 306,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:LASERFOCUS],
		[1,:PSYWAVE],
		[1,:CONFUSION],
		[1,:DISABLE],
		[1,:SAFEGUARD],
		[8,:SWIFT],
		[15,:FUTURESIGHT],
		[22,:PSYCHUP],
		[29,:MIRACLEEYE],
		[36,:PSYCHOCUT],
		[43,:POWERSWAP],
		[43,:GUARDSWAP],
		[50,:RECOVER],
		[57,:PSYCHIC],
		[64,:BARRIER],
		[70,:AURASPHERE],
		[79,:AMNESIA],
		[86,:MIST],
		[93,:MEFIRST],
		[100,:PSYSTRIKE]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:IRONTAIL,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:LASERFOCUS,],
	:Color => "Purple",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 20,
	:Weight => 1220,
	:kind => "Genetic",
	:dexentry => "A Pokémon that was created by genetic manipulation. However, even though the scientific power of humans made its body, they failed to give it a warm heart.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:MEW => {
	:name => "Mew",
	:dexnum => 151,
	:Type1 => :PSYCHIC,
	:BaseStats => [100, 100, 100, 100, 100, 100],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:SYNCHRONIZE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "Genderless",
	:BaseEXP => 270,
	:CatchRate => 45,
	:Happiness => 100,
	:EggSteps => 30855,
	:Moveset => [
		[1,:POUND],
		[1,:REFLECTTYPE],
		[1,:TRANSFORM],
		[10,:MEGAPUNCH],
		[20,:METRONOME],
		[30,:PSYCHIC],
		[40,:BARRIER],
		[50,:ANCIENTPOWER],
		[60,:AMNESIA],
		[70,:MEFIRST],
		[80,:BATONPASS],
		[90,:NASTYPLOT],
		[100,:AURASPHERE]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:LEECHLIFE,:STRINGSHOT,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:QUASH,:SNATCH,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:DUALCHOP,:TWISTER,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SKYATTACK,:FLY,:BOUNCE,:AERIALACE,:SKYDROP,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:SHADOWCLAW,:OMINOUSWIND,:SPITE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:FALSESWIPE,:SNORE,:BIND,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:NATUREPOWER,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:GASTROACID,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:STEELWING,:GYROBALL,:IRONDEFENSE,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:AURORAVEIL,:BRUTALSWING,:LASERFOCUS,:LIQUIDATION,:SMARTSTRIKE,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Pink",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 4,
	:Weight => 40,
	:WildItemCommon => :LUMBERRY,
	:WildItemUncommon => :LUMBERRY,
	:WildItemRare => :LUMBERRY,
	:kind => "New Species",
	:dexentry => "A Mew is said to possess the genes of all Pokémon. It is capable of making itself invisible at will, so it entirely avoids notice even if it approaches people.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 13,
},

:CHIKORITA => {
	:name => "Chikorita",
	:dexnum => 152,
	:Type1 => :GRASS,
	:BaseStats => [45, 49, 65, 45, 49, 65],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:OVERGROW,:LEAFGUARD],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 64,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:AROMATHERAPY,:BODYSLAM,:COUNTER,:FLAIL,:GRASSWHISTLE,:GRASSYTERRAIN,:HEALPULSE,:INGRAIN,:LEAFSTORM,:LEECHSEED,:NATUREPOWER,:REFRESH,:VINEWHIP,:WRINGOUT],
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[6,:RAZORLEAF],
		[9,:POISONPOWDER],
		[12,:SYNTHESIS],
		[17,:REFLECT],
		[20,:MAGICALLEAF],
		[23,:NATURALGIFT],
		[28,:SWEETSCENT],
		[31,:LIGHTSCREEN],
		[34,:BODYSLAM],
		[39,:SAFEGUARD],
		[42,:AROMATHERAPY],
		[45,:SOLARBEAM]],
	:tmlist => [:FURYCUTTER,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:ANCIENTPOWER,:IRONTAIL,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Grass],
	:Height => 9,
	:Weight => 64,
	:kind => "Leaf",
	:dexentry => "It waves its leaf around to keep foes at bay. However, a sweet fragrance also wafts from the leaf, creating a friendly atmosphere that becalms the battlers.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BAYLEEF,:Level,16]
	]
},

:BAYLEEF => {
	:name => "Bayleef",
	:dexnum => 153,
	:Type1 => :GRASS,
	:BaseStats => [60, 62, 80, 60, 63, 80],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:OVERGROW,:LEAFGUARD],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[1,:RAZORLEAF],
		[1,:POISONPOWDER],
		[6,:RAZORLEAF],
		[9,:POISONPOWDER],
		[12,:SYNTHESIS],
		[18,:REFLECT],
		[22,:MAGICALLEAF],
		[26,:NATURALGIFT],
		[32,:SWEETSCENT],
		[36,:LIGHTSCREEN],
		[40,:BODYSLAM],
		[46,:SAFEGUARD],
		[50,:AROMATHERAPY],
		[54,:SOLARBEAM]],
	:tmlist => [:FURYCUTTER,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:ANCIENTPOWER,:IRONTAIL,:LASERFOCUS,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Grass],
	:Height => 12,
	:Weight => 158,
	:kind => "Leaf",
	:dexentry => "A Bayleef's neck is ringed by curled-up leaves. Inside each leaf is a small tree shoot. The fragrance of this shoot makes people peppy.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MEGANIUM,:Level,32]
	]
},

:MEGANIUM => {
	:name => "Meganium",
	:dexnum => 154,
	:Type1 => :GRASS,
	:BaseStats => [80, 82, 100, 80, 83, 100],
	:EVs => [0, 0, 1, 0, 0, 2],
	:Abilities => [:OVERGROW,:LEAFGUARD],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 236,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:PETALDANCE],
		[1,:PETALBLIZZARD],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:RAZORLEAF],
		[1,:POISONPOWDER],
		[6,:RAZORLEAF],
		[9,:POISONPOWDER],
		[12,:SYNTHESIS],
		[18,:REFLECT],
		[22,:MAGICALLEAF],
		[26,:NATURALGIFT],
		[34,:SWEETSCENT],
		[40,:LIGHTSCREEN],
		[46,:BODYSLAM],
		[54,:SAFEGUARD],
		[60,:AROMATHERAPY],
		[66,:SOLARBEAM],
		[70,:PETALBLIZZARD]],
	:tmlist => [:FURYCUTTER,:OUTRAGE,:DRAGONTAIL,:ROCKSMASH,:SUNNYDAY,:FRENZYPLANT,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:ANCIENTPOWER,:IRONTAIL,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Grass],
	:Height => 18,
	:Weight => 1005,
	:kind => "Herb",
	:dexentry => "The fragrance of a Meganium's flower soothes and calms emotions. In battle, it gives off more of its becalming scent to blunt the foe's fighting spirit.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 4,
	:BattlerAltitude => 0,
},

:CYNDAQUIL => {
	:name => "Cyndaquil",
	:dexnum => 155,
	:Type1 => :FIRE,
	:BaseStats => [39, 52, 43, 65, 60, 50],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:BLAZE,:FLASHFIRE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 62,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:COVET,:CRUSHCLAW,:DOUBLEKICK,:DOUBLEEDGE,:EXTRASENSORY,:FLAMEBURST,:FLAREBLITZ,:FORESIGHT,:FURYSWIPES,:HOWL,:NATUREPOWER,:QUICKATTACK,:REVERSAL,:THRASH],
	:Moveset => [
		[1,:TACKLE],
		[1,:LEER],
		[6,:SMOKESCREEN],
		[10,:EMBER],
		[13,:QUICKATTACK],
		[19,:FLAMEWHEEL],
		[22,:DEFENSECURL],
		[28,:FLAMECHARGE],
		[31,:SWIFT],
		[37,:LAVAPLUME],
		[40,:FLAMETHROWER],
		[46,:INFERNO],
		[49,:ROLLOUT],
		[55,:DOUBLEEDGE],
		[58,:BURNUP],
		[64,:ERUPTION]],
	:tmlist => [:WILDCHARGE,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:MUDSLAP,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROLLOUT,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 79,
	:kind => "Fire Mouse",
	:dexentry => "It flares flames from its back to protect itself. The fire burns vigorously if the Pokémon is angry. When it is tired, it sputters with incomplete combustion.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:QUILAVA,:Level,14]
	]
},

:QUILAVA => {
	:name => "Quilava",
	:dexnum => 156,
	:Type1 => :FIRE,
	:BaseStats => [58, 64, 58, 80, 80, 65],
	:EVs => [0, 0, 0, 1, 1, 0],
	:Abilities => [:BLAZE,:FLASHFIRE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:LEER],
		[1,:SMOKESCREEN],
		[6,:SMOKESCREEN],
		[10,:EMBER],
		[13,:QUICKATTACK],
		[20,:FLAMEWHEEL],
		[24,:DEFENSECURL],
		[31,:SWIFT],
		[35,:FLAMECHARGE],
		[42,:LAVAPLUME],
		[46,:FLAMETHROWER],
		[53,:INFERNO],
		[57,:ROLLOUT],
		[64,:DOUBLEEDGE],
		[68,:BURNUP],
		[75,:ERUPTION]],
	:tmlist => [:FURYCUTTER,:WILDCHARGE,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROLLOUT,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 9,
	:Weight => 190,
	:kind => "Volcano",
	:dexentry => "It intimidates foes with intense gusts of flames and superheated air. Its quick nimbleness lets it dodge attacks even while scorching an enemy.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:TYPHLOSION,:Level,36]
	]
},

:TYPHLOSION => {
	:name => "Typhlosion",
	:dexnum => 157,
	:Type1 => :FIRE,
	:BaseStats => [78, 84, 78, 100, 109, 85],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:BLAZE,:FLASHFIRE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 240,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ERUPTION],
		[1,:DOUBLEEDGE],
		[1,:GYROBALL],
		[1,:TACKLE],
		[1,:LEER],
		[1,:SMOKESCREEN],
		[1,:EMBER],
		[6,:SMOKESCREEN],
		[10,:EMBER],
		[13,:QUICKATTACK],
		[20,:FLAMEWHEEL],
		[24,:DEFENSECURL],
		[31,:SWIFT],
		[35,:FLAMECHARGE],
		[43,:LAVAPLUME],
		[48,:FLAMETHROWER],
		[56,:INFERNO],
		[61,:ROLLOUT],
		[69,:DOUBLEEDGE],
		[74,:BURNUP],
		[82,:ERUPTION]],
	:tmlist => [:FURYCUTTER,:FLING,:WILDCHARGE,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:BLASTBURN,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWCLAW,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:GYROBALL,:LASERFOCUS,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 17,
	:Weight => 795,
	:kind => "Volcano",
	:dexentry => "It can hide behind a heat haze that it creates using its flames. Typhlosion create blazing explosive blasts that burn everything to cinders.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 4,
	:BattlerAltitude => 0,
},

:TOTODILE => {
	:name => "Totodile",
	:dexnum => 158,
	:Type1 => :WATER,
	:BaseStats => [50, 65, 64, 43, 44, 48],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:TORRENT,:SHEERFORCE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 63,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:AQUAJET,:BLOCK,:CRUNCH,:DRAGONDANCE,:FAKETEARS,:FLATTER,:HYDROPUMP,:ICEPUNCH,:METALCLAW,:MUDSPORT,:THRASH,:WATERPULSE,:WATERSPORT],
	:Moveset => [
		[1,:SCRATCH],
		[1,:LEER],
		[6,:WATERGUN],
		[8,:RAGE],
		[13,:BITE],
		[15,:SCARYFACE],
		[20,:ICEFANG],
		[22,:FLAIL],
		[27,:CRUNCH],
		[29,:CHIPAWAY],
		[34,:SLASH],
		[36,:SCREECH],
		[41,:THRASH],
		[43,:AQUATAIL],
		[48,:SUPERPOWER],
		[50,:HYDROPUMP]],
	:tmlist => [:FLING,:DRAGONCLAW,:FOCUSPUNCH,:BRICKBREAK,:LOWKICK,:AERIALACE,:SHADOWCLAW,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 6,
	:Weight => 95,
	:kind => "Big Jaw",
	:dexentry => "Despite its small body, Totodile's jaws are very powerful. While it may think it is just playfully nipping, its bite can cause serious injury.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CROCONAW,:Level,18]
	]
},

:CROCONAW => {
	:name => "Croconaw",
	:dexnum => 159,
	:Type1 => :WATER,
	:BaseStats => [65, 80, 80, 58, 59, 63],
	:EVs => [0, 1, 1, 0, 0, 0],
	:Abilities => [:TORRENT,:SHEERFORCE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:SCRATCH],
		[1,:LEER],
		[1,:WATERGUN],
		[6,:WATERGUN],
		[8,:RAGE],
		[13,:BITE],
		[15,:SCARYFACE],
		[21,:ICEFANG],
		[24,:FLAIL],
		[30,:CRUNCH],
		[33,:CHIPAWAY],
		[39,:SLASH],
		[42,:SCREECH],
		[48,:THRASH],
		[51,:AQUATAIL],
		[57,:SUPERPOWER],
		[60,:HYDROPUMP]],
	:tmlist => [:FURYCUTTER,:FLING,:DRAGONCLAW,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:AERIALACE,:SHADOWCLAW,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 11,
	:Weight => 250,
	:kind => "Big Jaw",
	:dexentry => "Once its jaws clamp down on its foe, it will not let go. Because the tips of its fangs are forked back like fishhooks, they become irremovably embedded.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
	:evolutions => [
		[:FERALIGATR,:Level,30]
	]
},

:FERALIGATR => {
	:name => "Feraligatr",
	:dexnum => 160,
	:Type1 => :WATER,
	:BaseStats => [85, 105, 100, 78, 79, 83],
	:EVs => [0, 2, 1, 0, 0, 0],
	:Abilities => [:TORRENT,:SHEERFORCE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 239,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:AGILITY],
		[1,:SCRATCH],
		[1,:LEER],
		[1,:WATERGUN],
		[1,:RAGE],
		[6,:WATERGUN],
		[8,:RAGE],
		[13,:BITE],
		[15,:SCARYFACE],
		[21,:ICEFANG],
		[24,:FLAIL],
		[32,:CRUNCH],
		[37,:CHIPAWAY],
		[45,:SLASH],
		[50,:SCREECH],
		[58,:THRASH],
		[63,:AQUATAIL],
		[71,:SUPERPOWER],
		[76,:HYDROPUMP]],
	:tmlist => [:FURYCUTTER,:FLING,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:AERIALACE,:SHADOWCLAW,:SPITE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:IRONTAIL,:HYDROCANNON,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:LIQUIDATION,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 23,
	:Weight => 888,
	:kind => "Big Jaw",
	:dexentry => "It opens its huge mouth to intimidate enemies. In battle, it runs using its thick and powerful hind legs to charge the foe with incredible speed.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
},

:SENTRET => {
	:name => "Sentret",
	:dexnum => 161,
	:Type1 => :NORMAL,
	:BaseStats => [35, 46, 34, 20, 35, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:RUNAWAY,:KEENEYE],
	:HiddenAbilities => :FRISK,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 43,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:ASSIST,:BABYDOLLEYES,:CAPTIVATE,:CHARM,:COVET,:DOUBLEEDGE,:FOCUSENERGY,:IRONTAIL,:LASTRESORT,:NATURALGIFT,:PURSUIT,:REVERSAL,:SLASH,:TRICK],
	:Moveset => [
		[1,:SCRATCH],
		[1,:FORESIGHT],
		[4,:DEFENSECURL],
		[7,:QUICKATTACK],
		[13,:FURYSWIPES],
		[16,:HELPINGHAND],
		[19,:FOLLOWME],
		[25,:SLAM],
		[28,:REST],
		[31,:SUCKERPUNCH],
		[36,:AMNESIA],
		[39,:BATONPASS],
		[42,:MEFIRST],
		[47,:HYPERVOICE]],
	:tmlist => [:UTURN,:FURYCUTTER,:SUCKERPUNCH,:THIEF,:KNOCKOFF,:FLING,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:FOCUSPUNCH,:BRICKBREAK,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:ICEBEAM,:ICEPUNCH,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:TRICK,:ROLLOUT,:IRONTAIL,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 8,
	:Weight => 60,
	:kind => "Scout",
	:dexentry => "They take turns standing guard at night. The sentry awakens the others if it senses danger. If one becomes separated, it turns sleepless with fear.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
	:evolutions => [
		[:FURRET,:Level,15]
	]
},

:FURRET => {
	:name => "Furret",
	:dexnum => 162,
	:Type1 => :NORMAL,
	:BaseStats => [85, 76, 64, 90, 45, 55],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:RUNAWAY,:KEENEYE],
	:HiddenAbilities => :FRISK,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 145,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:AGILITY],
		[1,:COIL],
		[1,:SCRATCH],
		[1,:FORESIGHT],
		[1,:DEFENSECURL],
		[1,:QUICKATTACK],
		[4,:DEFENSECURL],
		[7,:QUICKATTACK],
		[13,:FURYSWIPES],
		[17,:HELPINGHAND],
		[21,:FOLLOWME],
		[28,:SLAM],
		[32,:REST],
		[36,:SUCKERPUNCH],
		[42,:AMNESIA],
		[46,:BATONPASS],
		[50,:MEFIRST],
		[56,:HYPERVOICE]],
	:tmlist => [:UTURN,:FURYCUTTER,:SUCKERPUNCH,:THIEF,:KNOCKOFF,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:TRICK,:ROLLOUT,:IRONTAIL,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 18,
	:Weight => 325,
	:kind => "Long Body",
	:dexentry => "A Furret has a very slim build. When under attack, it can fit through narrow spaces and get away. In spite of its short limbs, it is very nimble.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:HOOTHOOT => {
	:name => "Hoothoot",
	:dexnum => 163,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [60, 30, 30, 50, 36, 56],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:INSOMNIA,:KEENEYE],
	:HiddenAbilities => :TINTEDLENS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 52,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:AGILITY,:DEFOG,:FEATHERDANCE,:FEINTATTACK,:HURRICANE,:MEANLOOK,:MIRRORMOVE,:NIGHTSHADE,:SKYATTACK,:SUPERSONIC,:WHIRLWIND,:WINGATTACK],
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[1,:FORESIGHT],
		[4,:HYPNOSIS],
		[7,:PECK],
		[10,:CONFUSION],
		[13,:ECHOEDVOICE],
		[16,:ZENHEADBUTT],
		[19,:PSYCHOSHIFT],
		[22,:EXTRASENSORY],
		[25,:TAKEDOWN],
		[28,:REFLECT],
		[31,:AIRSLASH],
		[34,:UPROAR],
		[37,:ROOST],
		[40,:MOONBLAST],
		[43,:SYNCHRONOISE],
		[46,:DREAMEATER]],
	:tmlist => [:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:MUDSLAP,:HYPERVOICE,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:REFLECT,:REST,:ROLEPLAY,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Flying],
	:Height => 7,
	:Weight => 212,
	:kind => "Owl",
	:dexentry => "It has an internal organ that senses the earth's rotation. Using this special organ, a Hoothoot begins hooting at precisely the same time every day.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:NOCTOWL,:Level,20]
	]
},

:NOCTOWL => {
	:name => "Noctowl",
	:dexnum => 164,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [100, 50, 50, 70, 86, 96],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:INSOMNIA,:KEENEYE],
	:HiddenAbilities => :TINTEDLENS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 155,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:DREAMEATER],
		[1,:SKYATTACK],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:FORESIGHT],
		[1,:HYPNOSIS],
		[4,:HYPNOSIS],
		[7,:PECK],
		[10,:CONFUSION],
		[13,:ECHOEDVOICE],
		[16,:ZENHEADBUTT],
		[19,:PSYCHOSHIFT],
		[23,:EXTRASENSORY],
		[27,:TAKEDOWN],
		[31,:REFLECT],
		[35,:AIRSLASH],
		[39,:UPROAR],
		[43,:ROOST],
		[47,:MOONBLAST],
		[51,:SYNCHRONOISE],
		[55,:DREAMEATER]],
	:tmlist => [:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:REFLECT,:REST,:ROLEPLAY,:STEELWING,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Flying],
	:Height => 16,
	:Weight => 408,
	:kind => "Owl",
	:dexentry => "It unfailingly catches prey in darkness. Noctowl owe their success to superior vision that allows them to see at night, and to their silent wings.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:LEDYBA => {
	:name => "Ledyba",
	:dexnum => 165,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [40, 20, 30, 55, 40, 80],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:SWARM,:EARLYBIRD],
	:HiddenAbilities => :RATTLED,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 53,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BIDE,:BUGBITE,:BUGBUZZ,:COUNTER,:DIZZYPUNCH,:DRAINPUNCH,:ENCORE,:ENDURE,:FOCUSPUNCH,:KNOCKOFF,:PSYBEAM,:SCREECH,:SILVERWIND,:TAILWIND],
	:Moveset => [
		[1,:TACKLE],
		[5,:SUPERSONIC],
		[8,:SWIFT],
		[12,:LIGHTSCREEN],
		[12,:REFLECT],
		[12,:SAFEGUARD],
		[15,:MACHPUNCH],
		[19,:SILVERWIND],
		[22,:COMETPUNCH],
		[26,:BATONPASS],
		[29,:AGILITY],
		[33,:BUGBUZZ],
		[36,:AIRSLASH],
		[40,:DOUBLEEDGE]],
	:tmlist => [:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:KNOCKOFF,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:ICEPUNCH,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:ROLLOUT,:CONFIDE,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Red",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 10,
	:Weight => 108,
	:kind => "Five Star",
	:dexentry => "Ledyba communicate using a fluid that they secrete from where the legs join the body. They can convey feelings to others by altering the fluid's scent.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LEDIAN,:Level,18]
	]
},

:LEDIAN => {
	:name => "Ledian",
	:dexnum => 166,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [55, 35, 50, 85, 55, 110],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:SWARM,:EARLYBIRD],
	:HiddenAbilities => :IRONFIST,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 137,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:TACKLE],
		[1,:SUPERSONIC],
		[1,:SWIFT],
		[5,:SUPERSONIC],
		[8,:SWIFT],
		[12,:LIGHTSCREEN],
		[12,:REFLECT],
		[12,:SAFEGUARD],
		[15,:MACHPUNCH],
		[20,:SILVERWIND],
		[24,:COMETPUNCH],
		[29,:BATONPASS],
		[33,:AGILITY],
		[38,:BUGBUZZ],
		[42,:AIRSLASH],
		[47,:DOUBLEEDGE]],
	:tmlist => [:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:KNOCKOFF,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:CONFIDE,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Red",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 14,
	:Weight => 356,
	:kind => "Five Star",
	:dexentry => "It is said that in lands with clean air, where the stars fill the sky, Ledian thrive. For good reason, they use the light of the stars as energy.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:SPINARAK => {
	:name => "Spinarak",
	:dexnum => 167,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [40, 60, 40, 30, 40, 40],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SWARM,:INSOMNIA],
	:HiddenAbilities => :SNIPER,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 50,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BATONPASS,:DISABLE,:ELECTROWEB,:LUNGE,:MEGAHORN,:NIGHTSLASH,:PSYBEAM,:PURSUIT,:RAGEPOWDER,:SIGNALBEAM,:SONICBOOM,:TOXICSPIKES,:TWINEEDLE],
	:Moveset => [
		[1,:POISONSTING],
		[1,:STRINGSHOT],
		[1,:CONSTRICT],
		[5,:ABSORB],
		[8,:INFESTATION],
		[12,:SCARYFACE],
		[15,:NIGHTSHADE],
		[19,:SHADOWSNEAK],
		[22,:FURYSWIPES],
		[26,:SUCKERPUNCH],
		[29,:SPIDERWEB],
		[33,:AGILITY],
		[36,:PINMISSILE],
		[40,:PSYCHIC],
		[43,:POISONJAB],
		[47,:CROSSPOISON],
		[50,:STICKYWEB],
		[54,:TOXICTHREAD]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:STRINGSHOT,:FOULPLAY,:SUCKERPUNCH,:THIEF,:ELECTROWEB,:SUNNYDAY,:BOUNCE,:SOLARBEAM,:GIGADRAIN,:FACADE,:SECRETPOWER,:ROUND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:PSYCHIC,:REST,:CONFIDE,:INFESTATION,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 5,
	:Weight => 85,
	:kind => "String Spit",
	:dexentry => "The web it spins can be considered its second nervous system. A Spinarak can determine its prey by the tiny vibrations it feels through the web.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ARIADOS,:Level,22]
	]
},

:ARIADOS => {
	:name => "Ariados",
	:dexnum => 168,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [70, 90, 70, 40, 60, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SWARM,:INSOMNIA],
	:HiddenAbilities => :SNIPER,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 137,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:SWORDSDANCE],
		[1,:FOCUSENERGY],
		[1,:VENOMDRENCH],
		[1,:FELLSTINGER],
		[1,:BUGBITE],
		[1,:POISONSTING],
		[1,:STRINGSHOT],
		[1,:CONSTRICT],
		[1,:ABSORB],
		[5,:ABSORB],
		[8,:INFESTATION],
		[12,:SCARYFACE],
		[15,:NIGHTSHADE],
		[19,:SHADOWSNEAK],
		[23,:FURYSWIPES],
		[28,:SUCKERPUNCH],
		[32,:SPIDERWEB],
		[37,:AGILITY],
		[41,:PINMISSILE],
		[46,:PSYCHIC],
		[50,:POISONJAB],
		[55,:CROSSPOISON],
		[58,:STICKYWEB],
		[60,:TOXICTHREAD]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:STRINGSHOT,:FOULPLAY,:SUCKERPUNCH,:THIEF,:ELECTROWEB,:SUNNYDAY,:BOUNCE,:SOLARBEAM,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:PSYCHIC,:REST,:CONFIDE,:INFESTATION,:SMARTSTRIKE,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Red",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 11,
	:Weight => 335,
	:kind => "Long Leg",
	:dexentry => "Its feet are tipped with tiny claws that enable it to scuttle on ceilings and vertical walls. It constricts its foe with thin and strong silk webbing.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:CROBAT => {
	:name => "Crobat",
	:dexnum => 169,
	:Type1 => :POISON,
	:Type2 => :FLYING,
	:BaseStats => [85, 90, 80, 130, 70, 80],
	:EVs => [0, 0, 0, 3, 0, 0],
	:Abilities => [:INNERFOCUS,:INFILTRATOR],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 241,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:CROSSPOISON],
		[1,:SCREECH],
		[1,:ABSORB],
		[1,:SUPERSONIC],
		[1,:ASTONISH],
		[1,:BITE],
		[5,:SUPERSONIC],
		[7,:ASTONISH],
		[11,:BITE],
		[13,:WINGATTACK],
		[17,:CONFUSERAY],
		[19,:AIRCUTTER],
		[24,:SWIFT],
		[27,:POISONFANG],
		[32,:MEANLOOK],
		[35,:LEECHLIFE],
		[40,:HAZE],
		[43,:VENOSHOCK],
		[48,:AIRSLASH],
		[51,:QUICKGUARD]],
	:tmlist => [:XSCISSOR,:UTURN,:LEECHLIFE,:DARKPULSE,:PAYBACK,:THIEF,:SNATCH,:TAUNT,:TORMENT,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:ZENHEADBUTT,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:Habitat => "Cave",
	:EggGroups => [:Flying],
	:Height => 18,
	:Weight => 750,
	:kind => "Bat",
	:dexentry => "Over the course of evolution, its hind legs turned into wings. By alternately resting its front and rear wings, it can fly all day without having to stop.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 10,
},

:CHINCHOU => {
	:name => "Chinchou",
	:dexnum => 170,
	:Type1 => :WATER,
	:Type2 => :ELECTRIC,
	:BaseStats => [75, 38, 38, 67, 56, 56],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:VOLTABSORB,:ILLUMINATE],
	:HiddenAbilities => :WATERABSORB,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:AMNESIA,:BRINE,:FLAIL,:MIST,:PSYBEAM,:SCREECH,:SHOCKWAVE,:SOAK,:WATERPULSE,:WHIRLPOOL],
	:Moveset => [
		[1,:BUBBLE],
		[1,:SUPERSONIC],
		[6,:THUNDERWAVE],
		[9,:ELECTROBALL],
		[12,:WATERGUN],
		[17,:CONFUSERAY],
		[20,:BUBBLEBEAM],
		[23,:SPARK],
		[28,:SIGNALBEAM],
		[31,:FLAIL],
		[34,:DISCHARGE],
		[39,:TAKEDOWN],
		[42,:AQUARING],
		[45,:HYDROPUMP],
		[47,:IONDELUGE],
		[50,:CHARGE]],
	:tmlist => [:SIGNALBEAM,:SUCKERPUNCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:BOUNCE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water2],
	:Height => 5,
	:Weight => 120,
	:WildItemUncommon => :DEEPSEASCALE,
	:kind => "Angler",
	:dexentry => "When it senses danger, it discharges positive and negative electricity from its two antennae. It lives in depths beyond sunlight's reach.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 10,
	:evolutions => [
		[:LANTURN,:Level,27]
	]
},

:LANTURN => {
	:name => "Lanturn",
	:dexnum => 171,
	:Type1 => :WATER,
	:Type2 => :ELECTRIC,
	:BaseStats => [125, 58, 58, 67, 76, 76],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:VOLTABSORB,:ILLUMINATE],
	:HiddenAbilities => :WATERABSORB,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:STOCKPILE],
		[0,:SWALLOW],
		[0,:SPITUP],
		[1,:EERIEIMPULSE],
		[1,:SPOTLIGHT],
		[1,:BUBBLE],
		[1,:SUPERSONIC],
		[1,:THUNDERWAVE],
		[1,:ELECTROBALL],
		[6,:THUNDERWAVE],
		[9,:ELECTROBALL],
		[12,:WATERGUN],
		[17,:CONFUSERAY],
		[20,:BUBBLEBEAM],
		[23,:SPARK],
		[29,:SIGNALBEAM],
		[33,:FLAIL],
		[37,:DISCHARGE],
		[43,:TAKEDOWN],
		[47,:AQUARING],
		[51,:HYDROPUMP],
		[54,:IONDELUGE],
		[58,:CHARGE]],
	:tmlist => [:SIGNALBEAM,:SUCKERPUNCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:BOUNCE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water2],
	:Height => 12,
	:Weight => 225,
	:WildItemUncommon => :DEEPSEASCALE,
	:kind => "Light",
	:dexentry => "The light-emitting orbs on its back are very bright. They are formed from a part of its dorsal fin. It illuminates the inky darkness of deep seas.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 11,
},

:PICHU => {
	:name => "Pichu",
	:dexnum => 172,
	:Type1 => :ELECTRIC,
	:BaseStats => [20, 40, 15, 60, 35, 35],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:STATIC,:LIGHTNINGROD],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 41,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 2805,
	:EggMoves => [:BESTOW,:BIDE,:CHARGE,:DISARMINGVOICE,:DOUBLESLAP,:ELECTRICTERRAIN,:ENCORE,:ENDURE,:FAKEOUT,:FLAIL,:LUCKYCHANT,:PRESENT,:REVERSAL,:THUNDERPUNCH,:TICKLE,:WISH,:VOLTTACKLE],
	:Moveset => [
		[1,:THUNDERSHOCK],
		[1,:CHARM],
		[5,:TAILWHIP],
		[10,:SWEETKISS],
		[13,:NASTYPLOT],
		[18,:THUNDERWAVE]],
	:tmlist => [:SIGNALBEAM,:FLING,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:GRASSKNOT,:MUDSLAP,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONTAIL,:RAINDANCE,:CONFIDE,:CELEBRATE,],
	:Color => "Yellow",
	:Habitat => "Forest",
	:EggGroups => [:Undiscovered],
	:Height => 3,
	:Weight => 20,
	:kind => "Tiny Mouse",
	:dexentry => "It is still inept at retaining electricity. When it is startled, it discharges power accidentally. It gets better at holding power as it grows older.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PIKACHU,:Happiness,0]
	]
},

:CLEFFA => {
	:name => "Cleffa",
	:dexnum => 173,
	:Type1 => :FAIRY,
	:BaseStats => [50, 25, 28, 15, 45, 55],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:CUTECHARM,:MAGICGUARD],
	:HiddenAbilities => :FRIENDGUARD,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 44,
	:CatchRate => 150,
	:Happiness => 140,
	:EggSteps => 2805,
	:EggMoves => [:AMNESIA,:AROMATHERAPY,:BELLYDRUM,:COVET,:FAKETEARS,:HEALPULSE,:METRONOME,:MIMIC,:MISTYTERRAIN,:PRESENT,:SPLASH,:STOREDPOWER,:TICKLE,:WISH],
	:Moveset => [
		[1,:POUND],
		[1,:CHARM],
		[4,:ENCORE],
		[7,:SING],
		[10,:SWEETKISS],
		[13,:COPYCAT],
		[16,:MAGICALLEAF]],
	:tmlist => [:SIGNALBEAM,:FLING,:SHOCKWAVE,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:ICYWIND,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:WONDERROOM,:ROLLOUT,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Pink",
	:Habitat => "Mountain",
	:EggGroups => [:Undiscovered],
	:Height => 3,
	:Weight => 30,
	:WildItemUncommon => :MOONSTONE,
	:kind => "Star Shape",
	:dexentry => "On nights with many shooting stars, Cleffa can be seen dancing in a ring. They dance until daybreak, when they quench their thirst with the morning dew.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 29,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CLEFAIRY,:Happiness,0]
	]
},

:IGGLYBUFF => {
	:name => "Igglybuff",
	:dexnum => 174,
	:Type1 => :NORMAL,
	:Type2 => :FAIRY,
	:BaseStats => [90, 30, 15, 15, 40, 20],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:CUTECHARM,:COMPETITIVE],
	:HiddenAbilities => :FRIENDGUARD,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 42,
	:CatchRate => 170,
	:Happiness => 70,
	:EggSteps => 2805,
	:EggMoves => [:CAPTIVATE,:COVET,:FAKETEARS,:FEINTATTACK,:GRAVITY,:HEALPULSE,:LASTRESORT,:MISTYTERRAIN,:PERISHSONG,:PRESENT,:PUNISHMENT,:SLEEPTALK,:WISH],
	:Moveset => [
		[1,:SING],
		[1,:CHARM],
		[3,:DEFENSECURL],
		[5,:POUND],
		[9,:SWEETKISS],
		[11,:COPYCAT]],
	:tmlist => [:FLING,:WILDCHARGE,:SHOCKWAVE,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:ICYWIND,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Pink",
	:Habitat => "Grassland",
	:EggGroups => [:Undiscovered],
	:Height => 3,
	:Weight => 10,
	:kind => "Balloon",
	:dexentry => "Its soft and pliable body is very bouncy. When it sings continuously with all its might, its body steadily turns a deepening pink color.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:JIGGLYPUFF,:Happiness,0]
	]
},

:TOGEPI => {
	:name => "Togepi",
	:dexnum => 175,
	:Type1 => :FAIRY,
	:BaseStats => [35, 20, 65, 20, 40, 65],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:HUSTLE,:SERENEGRACE],
	:HiddenAbilities => :SUPERLUCK,
	:GrowthRate => "Fast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 49,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 2805,
	:EggMoves => [:EXTRASENSORY,:FORESIGHT,:FUTURESIGHT,:LUCKYCHANT,:MIRRORMOVE,:MORNINGSUN,:NASTYPLOT,:PECK,:PRESENT,:PSYCHOSHIFT,:SECRETPOWER,:STOREDPOWER],
	:Moveset => [
		[1,:GROWL],
		[1,:CHARM],
		[5,:METRONOME],
		[9,:SWEETKISS],
		[13,:YAWN],
		[17,:ENCORE],
		[21,:FOLLOWME],
		[25,:BESTOW],
		[29,:WISH],
		[33,:ANCIENTPOWER],
		[37,:SAFEGUARD],
		[41,:BATONPASS],
		[45,:DOUBLEEDGE],
		[49,:LASTRESORT],
		[53,:AFTERYOU]],
	:tmlist => [:SIGNALBEAM,:FLING,:SHOCKWAVE,:THUNDERWAVE,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "White",
	:Habitat => "Forest",
	:EggGroups => [:Undiscovered],
	:Height => 3,
	:Weight => 15,
	:kind => "Spike Ball",
	:dexentry => "As its energy, it uses the positive feelings exuded by people and Pokémon. It stores up happy feelings in its shell, then shares them.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
	:evolutions => [
		[:TOGETIC,:Happiness,0]
	]
},

:TOGETIC => {
	:name => "Togetic",
	:dexnum => 176,
	:Type1 => :FAIRY,
	:Type2 => :FLYING,
	:BaseStats => [55, 40, 85, 40, 80, 105],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:HUSTLE,:SERENEGRACE],
	:HiddenAbilities => :SUPERLUCK,
	:GrowthRate => "Fast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 2805,
	:Moveset => [
		[1,:MAGICALLEAF],
		[1,:GROWL],
		[1,:CHARM],
		[1,:METRONOME],
		[1,:SWEETKISS],
		[5,:METRONOME],
		[9,:SWEETKISS],
		[13,:YAWN],
		[14,:FAIRYWIND],
		[17,:ENCORE],
		[21,:FOLLOWME],
		[25,:BESTOW],
		[29,:WISH],
		[33,:ANCIENTPOWER],
		[37,:SAFEGUARD],
		[41,:BATONPASS],
		[45,:DOUBLEEDGE],
		[49,:LASTRESORT],
		[53,:AFTERYOU]],
	:tmlist => [:SIGNALBEAM,:FLING,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:ANCIENTPOWER,:ROLLOUT,:STEELWING,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:SMARTSTRIKE,],
	:Color => "White",
	:Habitat => "Forest",
	:EggGroups => [:Flying,:Fairy],
	:Height => 6,
	:Weight => 32,
	:kind => "Happiness",
	:dexentry => "It is said to be a Pokémon that brings good luck. When it spots someone who is pure of heart, a Togetic appears and shares its happiness with them.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 13,
	:evolutions => [
		[:TOGEKISS,:Item,:SHINYSTONE]
	]
},

:NATU => {
	:name => "Natu",
	:dexnum => 177,
	:Type1 => :PSYCHIC,
	:Type2 => :FLYING,
	:BaseStats => [40, 50, 45, 70, 70, 45],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:SYNCHRONIZE,:EARLYBIRD],
	:HiddenAbilities => :MAGICBOUNCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 64,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ALLYSWITCH,:DRILLPECK,:FEATHERDANCE,:FEINTATTACK,:HAZE,:QUICKATTACK,:REFRESH,:ROOST,:SIMPLEBEAM,:SKILLSWAP,:STEELWING,:SUCKERPUNCH,:SYNCHRONOISE,:ZENHEADBUTT],
	:Moveset => [
		[1,:PECK],
		[1,:LEER],
		[6,:NIGHTSHADE],
		[9,:TELEPORT],
		[12,:LUCKYCHANT],
		[17,:STOREDPOWER],
		[20,:OMINOUSWIND],
		[23,:CONFUSERAY],
		[28,:WISH],
		[33,:PSYCHIC],
		[36,:MIRACLEEYE],
		[39,:PSYCHOSHIFT],
		[44,:FUTURESIGHT],
		[47,:POWERSWAP],
		[47,:GUARDSWAP],
		[50,:MEFIRST]],
	:tmlist => [:SIGNALBEAM,:UTURN,:SUCKERPUNCH,:THIEF,:TWISTER,:THUNDERWAVE,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:AERIALACE,:AIRCUTTER,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:GRASSKNOT,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:STEELWING,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Flying],
	:Height => 2,
	:Weight => 20,
	:kind => "Tiny Bird",
	:dexentry => "It runs up short trees that grow on the savanna to peck at new shoots. A Natu's eyes look as if they are always observing something.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
	:evolutions => [
		[:XATU,:Level,25]
	]
},

:XATU => {
	:name => "Xatu",
	:dexnum => 178,
	:Type1 => :PSYCHIC,
	:Type2 => :FLYING,
	:BaseStats => [65, 75, 70, 95, 95, 70],
	:EVs => [0, 0, 0, 1, 1, 0],
	:Abilities => [:SYNCHRONIZE,:EARLYBIRD],
	:HiddenAbilities => :MAGICBOUNCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 165,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:AIRSLASH],
		[1,:TAILWIND],
		[1,:PECK],
		[1,:LEER],
		[1,:NIGHTSHADE],
		[1,:TELEPORT],
		[6,:NIGHTSHADE],
		[9,:TELEPORT],
		[12,:LUCKYCHANT],
		[17,:STOREDPOWER],
		[20,:OMINOUSWIND],
		[23,:CONFUSERAY],
		[29,:WISH],
		[35,:PSYCHIC],
		[39,:MIRACLEEYE],
		[43,:PSYCHOSHIFT],
		[49,:FUTURESIGHT],
		[53,:POWERSWAP],
		[53,:GUARDSWAP],
		[57,:MEFIRST]],
	:tmlist => [:SIGNALBEAM,:UTURN,:FOULPLAY,:SUCKERPUNCH,:THIEF,:TWISTER,:THUNDERWAVE,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:STEELWING,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Flying],
	:Height => 15,
	:Weight => 150,
	:kind => "Mystic",
	:dexentry => "It has the enigmatic power of foreseeing the future. Some people in different lands have long believed that Xatu are emissaries from another world.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:MAREEP => {
	:name => "Mareep",
	:dexnum => 179,
	:Type1 => :ELECTRIC,
	:BaseStats => [55, 40, 40, 35, 65, 45],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:STATIC,:PLUS],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 56,
	:CatchRate => 235,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AFTERYOU,:AGILITY,:BODYSLAM,:CHARGE,:EERIEIMPULSE,:ELECTRICTERRAIN,:FLATTER,:IRONTAIL,:ODORSLEUTH,:SANDATTACK,:SCREECH,:TAKEDOWN],
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[4,:THUNDERWAVE],
		[8,:THUNDERSHOCK],
		[11,:COTTONSPORE],
		[15,:CHARGE],
		[18,:TAKEDOWN],
		[22,:ELECTROBALL],
		[25,:CONFUSERAY],
		[29,:POWERGEM],
		[32,:DISCHARGE],
		[36,:COTTONGUARD],
		[39,:SIGNALBEAM],
		[43,:LIGHTSCREEN],
		[46,:THUNDER]],
	:tmlist => [:SIGNALBEAM,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Field],
	:Height => 6,
	:Weight => 78,
	:kind => "Wool",
	:dexentry => "Its fluffy wool rubs together and builds a static charge. The more energy is charged, the more brightly the lightbulb at the tip of its tail glows.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:FLAAFFY,:Level,15]
	]
},

:FLAAFFY => {
	:name => "Flaaffy",
	:dexnum => 180,
	:Type1 => :ELECTRIC,
	:BaseStats => [70, 55, 55, 45, 80, 60],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:STATIC,:PLUS],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 128,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[1,:THUNDERWAVE],
		[1,:THUNDERSHOCK],
		[4,:THUNDERWAVE],
		[8,:THUNDERSHOCK],
		[11,:COTTONSPORE],
		[16,:CHARGE],
		[20,:TAKEDOWN],
		[25,:ELECTROBALL],
		[29,:CONFUSERAY],
		[34,:POWERGEM],
		[38,:DISCHARGE],
		[43,:COTTONGUARD],
		[47,:SIGNALBEAM],
		[52,:LIGHTSCREEN],
		[56,:THUNDER]],
	:tmlist => [:SIGNALBEAM,:FLING,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:FIREPUNCH,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Pink",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Field],
	:Height => 8,
	:Weight => 133,
	:kind => "Wool",
	:dexentry => "Its fleece quality changes to generate strong static electricity with a small amount of wool. The bare, slick parts of its hide are shielded against electricity.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
	:evolutions => [
		[:AMPHAROS,:Level,30]
	]
},

:AMPHAROS => {
	:name => "Ampharos",
	:dexnum => 181,
	:Type1 => :ELECTRIC,
	:BaseStats => [90, 75, 85, 55, 115, 90],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:STATIC,:PLUS],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 225,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:THUNDERPUNCH],
		[1,:ZAPCANNON],
		[1,:MAGNETICFLUX],
		[1,:IONDELUGE],
		[1,:DRAGONPULSE],
		[1,:FIREPUNCH],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:THUNDERWAVE],
		[1,:THUNDERSHOCK],
		[4,:THUNDERWAVE],
		[8,:THUNDERSHOCK],
		[11,:COTTONSPORE],
		[16,:CHARGE],
		[20,:TAKEDOWN],
		[25,:ELECTROBALL],
		[29,:CONFUSERAY],
		[35,:POWERGEM],
		[40,:DISCHARGE],
		[46,:COTTONGUARD],
		[51,:SIGNALBEAM],
		[57,:LIGHTSCREEN],
		[62,:THUNDER],
		[65,:DRAGONPULSE]],
	:tmlist => [:SIGNALBEAM,:FLING,:OUTRAGE,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:FIREPUNCH,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:LASERFOCUS,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Monster,:Field],
	:Height => 14,
	:Weight => 615,
	:kind => "Light",
	:dexentry => "It gives off so much light that it can be seen from space. People in the old days used its light to send signals back and forth with others far away.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:BELLOSSOM => {
	:name => "Bellossom",
	:dexnum => 182,
	:Type1 => :GRASS,
	:BaseStats => [75, 80, 95, 50, 90, 100],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:CHLOROPHYLL,:HEALER],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 216,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:MAGICALLEAF],
		[1,:LEAFSTORM],
		[1,:LEAFBLADE],
		[1,:MEGADRAIN],
		[1,:SWEETSCENT],
		[1,:STUNSPORE],
		[1,:SUNNYDAY],
		[39,:QUIVERDANCE],
		[49,:PETALBLIZZARD],
		[59,:PETALDANCE],
		[69,:LEAFSTORM]],
	:tmlist => [:FLING,:DRAINPUNCH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,:LASERFOCUS,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Grass],
	:Height => 4,
	:Weight => 58,
	:WildItemUncommon => :ABSORBBULB,
	:kind => "Flower",
	:dexentry => "Its flower petals deepen in color through exposure to sunlight. When cloudy weather persists, it does a dance that is thought to summon the sun.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
},

:MARILL => {
	:name => "Marill",
	:dexnum => 183,
	:Type1 => :WATER,
	:Type2 => :FAIRY,
	:BaseStats => [70, 20, 50, 40, 20, 50],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:THICKFAT,:HUGEPOWER],
	:HiddenAbilities => :SAPSIPPER,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 88,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 2805,
	:EggMoves => [:AMNESIA,:AQUAJET,:BELLYDRUM,:BODYSLAM,:CAMOUFLAGE,:FUTURESIGHT,:MUDDYWATER,:PERISHSONG,:PRESENT,:REFRESH,:SUPERPOWER,:SUPERSONIC,:WATERSPORT],
	:Moveset => [
		[1,:TACKLE],
		[1,:WATERGUN],
		[2,:TAILWHIP],
		[5,:WATERSPORT],
		[7,:BUBBLE],
		[10,:DEFENSECURL],
		[10,:ROLLOUT],
		[13,:BUBBLEBEAM],
		[16,:HELPINGHAND],
		[20,:AQUATAIL],
		[23,:PLAYROUGH],
		[28,:AQUARING],
		[31,:RAINDANCE],
		[37,:DOUBLEEDGE],
		[40,:SUPERPOWER],
		[47,:HYDROPUMP]],
	:tmlist => [:KNOCKOFF,:FLING,:FOCUSPUNCH,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:BOUNCE,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Fairy],
	:Height => 4,
	:Weight => 85,
	:kind => "Aqua Mouse",
	:dexentry => "It is covered with water-repellent fur. Because of the fur, it can swim through water at high speed without being slowed by the water's resistance.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:AZUMARILL,:Level,18]
	]
},

:AZUMARILL => {
	:name => "Azumarill",
	:dexnum => 184,
	:Type1 => :WATER,
	:Type2 => :FAIRY,
	:BaseStats => [100, 50, 80, 50, 60, 80],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:THICKFAT,:HUGEPOWER],
	:HiddenAbilities => :SAPSIPPER,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 185,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 2805,
	:Moveset => [
		[1,:TACKLE],
		[1,:WATERGUN],
		[1,:TAILWHIP],
		[1,:WATERSPORT],
		[2,:TAILWHIP],
		[5,:WATERSPORT],
		[7,:WATERGUN],
		[10,:DEFENSECURL],
		[10,:ROLLOUT],
		[13,:BUBBLEBEAM],
		[16,:HELPINGHAND],
		[21,:AQUATAIL],
		[25,:PLAYROUGH],
		[31,:AQUARING],
		[35,:RAINDANCE],
		[42,:DOUBLEEDGE],
		[46,:SUPERPOWER],
		[55,:HYDROPUMP]],
	:tmlist => [:KNOCKOFF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:BOUNCE,:GRASSKNOT,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LIQUIDATION,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Fairy],
	:Height => 8,
	:Weight => 285,
	:kind => "Aqua Rabbit",
	:dexentry => "It lives in water virtually all day long. Its body color and pattern act as camouflage that makes it tough for enemies to spot in water.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:SUDOWOODO => {
	:name => "Sudowoodo",
	:dexnum => 185,
	:Type1 => :ROCK,
	:BaseStats => [70, 100, 115, 30, 30, 65],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:STURDY,:ROCKHEAD],
	:HiddenAbilities => :RATTLED,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 65,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CURSE,:DEFENSECURL,:ENDURE,:HARDEN,:HEADBUTT,:ROLLOUT,:SANDTOMB,:SELFDESTRUCT,:STEALTHROCK],
	:Moveset => [
		[0,:SLAM],
		[1,:WOODHAMMER],
		[1,:COPYCAT],
		[1,:FLAIL],
		[1,:LOWKICK],
		[1,:ROCKTHROW],
		[5,:FLAIL],
		[8,:LOWKICK],
		[12,:ROCKTHROW],
		[15,:MIMIC],
		[19,:FEINTATTACK],
		[22,:TEARFULLOOK],
		[26,:ROCKTOMB],
		[29,:BLOCK],
		[33,:ROCKSLIDE],
		[36,:COUNTER],
		[40,:SUCKERPUNCH],
		[43,:DOUBLEEDGE],
		[47,:STONEEDGE],
		[50,:HAMMERARM],
		[54,:HEADSMASH]],
	:tmlist => [:FOULPLAY,:SUCKERPUNCH,:THIEF,:FLING,:TAUNT,:TORMENT,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:EXPLOSION,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:CALMMIND,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Mineral],
	:Height => 12,
	:Weight => 380,
	:kind => "Imitation",
	:dexentry => "It mimics a tree to avoid enemies. But since its forelegs remain green throughout the year, it is easily identified as a fake in the winter.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:POLITOED => {
	:name => "Politoed",
	:dexnum => 186,
	:Type1 => :WATER,
	:BaseStats => [90, 75, 75, 70, 90, 100],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:WATERABSORB,:DAMP],
	:HiddenAbilities => :DRIZZLE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 225,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:BUBBLEBEAM],
		[1,:HYPNOSIS],
		[1,:DOUBLESLAP],
		[1,:PERISHSONG],
		[27,:SWAGGER],
		[37,:BOUNCE],
		[48,:HYPERVOICE]],
	:tmlist => [:PAYBACK,:THIEF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:BOUNCE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:REST,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Green",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1],
	:Height => 11,
	:Weight => 339,
	:WildItemUncommon => :KINGSROCK,
	:kind => "Frog",
	:dexentry => "The curled hair on its head proves its status as a king. It is said that the longer and curlier the hair, the more respect it earns from its peers.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 5,
},

:HOPPIP => {
	:name => "Hoppip",
	:dexnum => 187,
	:Type1 => :GRASS,
	:Type2 => :FLYING,
	:BaseStats => [35, 35, 40, 50, 35, 55],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:CHLOROPHYLL,:LEAFGUARD],
	:HiddenAbilities => :INFILTRATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 50,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:AROMATHERAPY,:CONFUSION,:COTTONGUARD,:DOUBLEEDGE,:ENCORE,:ENDURE,:GRASSYTERRAIN,:HELPINGHAND,:SEEDBOMB,:STRENGTHSAP,:WORRYSEED],
	:Moveset => [
		[1,:SPLASH],
		[1,:ABSORB],
		[4,:SYNTHESIS],
		[6,:TAILWHIP],
		[8,:TACKLE],
		[10,:FAIRYWIND],
		[12,:POISONPOWDER],
		[14,:STUNSPORE],
		[16,:SLEEPPOWDER],
		[19,:BULLETSEED],
		[22,:LEECHSEED],
		[25,:MEGADRAIN],
		[28,:ACROBATICS],
		[31,:RAGEPOWDER],
		[34,:COTTONSPORE],
		[37,:UTURN],
		[40,:WORRYSEED],
		[43,:GIGADRAIN],
		[46,:BOUNCE],
		[49,:MEMENTO]],
	:tmlist => [:UTURN,:SUNNYDAY,:BOUNCE,:AERIALACE,:ACROBATICS,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REFLECT,:REST,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Pink",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy,:Grass],
	:Height => 4,
	:Weight => 5,
	:kind => "Cottonweed",
	:dexentry => "This Pokémon drifts with the wind. If it senses the approach of strong winds, a Hoppip links leaves with others to prepare against being blown away.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 13,
	:evolutions => [
		[:SKIPLOOM,:Level,18]
	]
},

:SKIPLOOM => {
	:name => "Skiploom",
	:dexnum => 188,
	:Type1 => :GRASS,
	:Type2 => :FLYING,
	:BaseStats => [55, 45, 50, 80, 45, 65],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:CHLOROPHYLL,:LEAFGUARD],
	:HiddenAbilities => :INFILTRATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 119,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:SPLASH],
		[1,:ABSORB],
		[1,:SYNTHESIS],
		[1,:TAILWHIP],
		[4,:SYNTHESIS],
		[6,:TAILWHIP],
		[8,:TACKLE],
		[10,:FAIRYWIND],
		[12,:POISONPOWDER],
		[14,:STUNSPORE],
		[16,:SLEEPPOWDER],
		[20,:BULLETSEED],
		[24,:LEECHSEED],
		[28,:MEGADRAIN],
		[32,:ACROBATICS],
		[36,:RAGEPOWDER],
		[40,:COTTONSPORE],
		[44,:UTURN],
		[48,:WORRYSEED],
		[52,:GIGADRAIN],
		[56,:BOUNCE],
		[60,:MEMENTO]],
	:tmlist => [:UTURN,:SUNNYDAY,:BOUNCE,:AERIALACE,:ACROBATICS,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REFLECT,:REST,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy,:Grass],
	:Height => 6,
	:Weight => 10,
	:kind => "Cottonweed",
	:dexentry => "It blossoms when the temperature rises above 64 degrees F. Because its flower's blooming changes with the temperature, it is used as a thermometer.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 15,
	:evolutions => [
		[:JUMPLUFF,:Level,27]
	]
},

:JUMPLUFF => {
	:name => "Jumpluff",
	:dexnum => 189,
	:Type1 => :GRASS,
	:Type2 => :FLYING,
	:BaseStats => [75, 55, 70, 110, 55, 95],
	:EVs => [0, 0, 0, 3, 0, 0],
	:Abilities => [:CHLOROPHYLL,:LEAFGUARD],
	:HiddenAbilities => :INFILTRATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 203,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:SPLASH],
		[1,:ABSORB],
		[1,:SYNTHESIS],
		[1,:TAILWHIP],
		[4,:SYNTHESIS],
		[6,:TAILWHIP],
		[8,:TACKLE],
		[10,:FAIRYWIND],
		[12,:POISONPOWDER],
		[14,:STUNSPORE],
		[16,:SLEEPPOWDER],
		[20,:BULLETSEED],
		[24,:LEECHSEED],
		[29,:MEGADRAIN],
		[34,:ACROBATICS],
		[39,:RAGEPOWDER],
		[44,:COTTONSPORE],
		[49,:UTURN],
		[54,:WORRYSEED],
		[59,:GIGADRAIN],
		[64,:BOUNCE],
		[69,:MEMENTO]],
	:tmlist => [:UTURN,:SUNNYDAY,:BOUNCE,:AERIALACE,:ACROBATICS,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REFLECT,:REST,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy,:Grass],
	:Height => 8,
	:Weight => 30,
	:kind => "Cottonweed",
	:dexentry => "Jumpluff ride warm southern winds to cross the sea and fly to foreign lands. This Pokémon lands when it encounters cold air while it is floating.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 15,
},

:AIPOM => {
	:name => "Aipom",
	:dexnum => 190,
	:Type1 => :NORMAL,
	:BaseStats => [55, 70, 55, 85, 40, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:RUNAWAY,:PICKUP],
	:HiddenAbilities => :SKILLLINK,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 72,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:BEATUP,:BOUNCE,:COUNTER,:COVET,:DOUBLESLAP,:FAKEOUT,:PURSUIT,:QUICKGUARD,:REVENGE,:SCREECH,:SLAM,:SPITE,:SWITCHEROO,:TAILSLAP],
	:Moveset => [
		[1,:SCRATCH],
		[1,:TAILWHIP],
		[4,:SANDATTACK],
		[8,:ASTONISH],
		[11,:BATONPASS],
		[15,:TICKLE],
		[18,:FURYSWIPES],
		[22,:SWIFT],
		[25,:SCREECH],
		[29,:AGILITY],
		[32,:DOUBLEHIT],
		[36,:FLING],
		[39,:NASTYPLOT],
		[43,:LASTRESORT]],
	:tmlist => [:UTURN,:FURYCUTTER,:FOULPLAY,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:SNATCH,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:AERIALACE,:ACROBATICS,:SHADOWBALL,:SHADOWCLAW,:SPITE,:SOLARBEAM,:SEEDBOMB,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:LASTRESORT,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:DREAMEATER,:MAGICCOAT,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Purple",
	:Habitat => "Forest",
	:EggGroups => [:Field],
	:Height => 8,
	:Weight => 115,
	:kind => "Long Tail",
	:dexentry => "Its tail ends with a dexterous, handlike appendage. However, because it uses the tail so much, Aipom's real hands have become rather clumsy.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
	:evolutions => [
		[:AMBIPOM,:HasMove,313]
	]
},

:SUNKERN => {
	:name => "Sunkern",
	:dexnum => 191,
	:Type1 => :GRASS,
	:BaseStats => [30, 30, 30, 30, 30, 30],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:CHLOROPHYLL,:SOLARPOWER],
	:HiddenAbilities => :EARLYBIRD,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 36,
	:CatchRate => 235,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BIDE,:CURSE,:ENCORE,:ENDURE,:GRASSWHISTLE,:GRASSYTERRAIN,:HELPINGHAND,:INGRAIN,:LEECHSEED,:MORNINGSUN,:NATURALGIFT,:SWEETSCENT],
	:Moveset => [
		[1,:ABSORB],
		[1,:GROWTH],
		[4,:INGRAIN],
		[7,:GRASSWHISTLE],
		[10,:MEGADRAIN],
		[13,:LEECHSEED],
		[16,:RAZORLEAF],
		[19,:WORRYSEED],
		[22,:GIGADRAIN],
		[25,:ENDEAVOR],
		[28,:SYNTHESIS],
		[31,:NATURALGIFT],
		[34,:SOLARBEAM],
		[37,:DOUBLEEDGE],
		[40,:SUNNYDAY],
		[43,:SEEDBOMB]],
	:tmlist => [:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:TOXIC,:LIGHTSCREEN,:REST,:CONFIDE,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Grass],
	:Height => 3,
	:Weight => 18,
	:kind => "Seed",
	:dexentry => "Sunkern try to conserve the nutrients they have stored in their bodies for evolution. They will not eat, subsisting only on morning dew.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 8,
	:evolutions => [
		[:SUNFLORA,:Item,:SUNSTONE]
	]
},

:SUNFLORA => {
	:name => "Sunflora",
	:dexnum => 192,
	:Type1 => :GRASS,
	:BaseStats => [75, 75, 55, 30, 105, 85],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:CHLOROPHYLL,:SOLARPOWER],
	:HiddenAbilities => :EARLYBIRD,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 149,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:FLOWERSHIELD],
		[1,:ABSORB],
		[1,:POUND],
		[1,:GROWTH],
		[4,:INGRAIN],
		[7,:GRASSWHISTLE],
		[10,:MEGADRAIN],
		[13,:LEECHSEED],
		[16,:RAZORLEAF],
		[19,:WORRYSEED],
		[22,:GIGADRAIN],
		[25,:BULLETSEED],
		[28,:PETALDANCE],
		[31,:NATURALGIFT],
		[34,:SOLARBEAM],
		[37,:DOUBLEEDGE],
		[40,:SUNNYDAY],
		[43,:LEAFSTORM],
		[50,:PETALBLIZZARD]],
	:tmlist => [:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHPOWER,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:TOXIC,:LIGHTSCREEN,:REST,:CONFIDE,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Grass],
	:Height => 8,
	:Weight => 85,
	:kind => "Sun",
	:dexentry => "Sunflora convert solar energy into nutrition. They are highly active in the warm daytime but suddenly stop moving as soon as the sun sets.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:YANMA => {
	:name => "Yanma",
	:dexnum => 193,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [65, 65, 45, 95, 75, 45],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SPEEDBOOST,:COMPOUNDEYES],
	:HiddenAbilities => :FRISK,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 78,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:DOUBLEEDGE,:FEINT,:FEINTATTACK,:LEECHLIFE,:PURSUIT,:REVERSAL,:SECRETPOWER,:SIGNALBEAM,:SILVERWIND,:WHIRLWIND],
	:Moveset => [
		[1,:TACKLE],
		[1,:FORESIGHT],
		[6,:QUICKATTACK],
		[11,:DOUBLETEAM],
		[14,:SONICBOOM],
		[17,:DETECT],
		[22,:SUPERSONIC],
		[27,:UPROAR],
		[30,:PURSUIT],
		[33,:ANCIENTPOWER],
		[38,:HYPNOSIS],
		[43,:WINGATTACK],
		[46,:SCREECH],
		[49,:UTURN],
		[54,:AIRSLASH],
		[57,:BUGBUZZ]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRINGSHOT,:THIEF,:SUNNYDAY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:REST,:ANCIENTPOWER,:STEELWING,:CONFIDE,],
	:Color => "Red",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 12,
	:Weight => 380,
	:WildItemUncommon => :WIDELENS,
	:kind => "Clear Wing",
	:dexentry => "It can see 360 degrees without moving its eyes. It is a great flier capable of making sudden stops and turning midair to quickly chase down targeted prey.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 15,
	:evolutions => [
		[:YANMEGA,:HasMove,506]
	]
},

:WOOPER => {
	:name => "Wooper",
	:dexnum => 194,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [55, 45, 45, 15, 25, 25],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:DAMP,:WATERABSORB],
	:HiddenAbilities => :UNAWARE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 42,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACIDSPRAY,:AFTERYOU,:ANCIENTPOWER,:BODYSLAM,:COUNTER,:CURSE,:DOUBLEKICK,:EERIEIMPULSE,:ENCORE,:GUARDSWAP,:MUDSPORT,:POWERUPPUNCH,:RECOVER,:SLEEPTALK,:SPITUP,:STOCKPILE,:SWALLOW],
	:Moveset => [
		[1,:WATERGUN],
		[1,:TAILWHIP],
		[5,:MUDSPORT],
		[9,:MUDSHOT],
		[15,:SLAM],
		[19,:MUDBOMB],
		[23,:AMNESIA],
		[29,:YAWN],
		[33,:EARTHQUAKE],
		[37,:RAINDANCE],
		[43,:MIST],
		[43,:HAZE],
		[47,:MUDDYWATER]],
	:tmlist => [:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:REST,:ANCIENTPOWER,:ROLLOUT,:SANDSTORM,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Field],
	:Height => 4,
	:Weight => 85,
	:kind => "Water Fish",
	:dexentry => "Wooper usually live in water but come out onto land seeking food occasionally. On land, they coat their bodies with a gooey, toxic film.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:QUAGSIRE,:Level,20]
	]
},

:QUAGSIRE => {
	:name => "Quagsire",
	:dexnum => 195,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [95, 85, 85, 35, 65, 65],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:DAMP,:WATERABSORB],
	:HiddenAbilities => :UNAWARE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 151,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:WATERGUN],
		[1,:TAILWHIP],
		[1,:MUDSPORT],
		[5,:MUDSPORT],
		[9,:MUDSHOT],
		[15,:SLAM],
		[19,:MUDBOMB],
		[24,:AMNESIA],
		[31,:YAWN],
		[36,:EARTHQUAKE],
		[41,:RAINDANCE],
		[48,:MIST],
		[48,:HAZE],
		[53,:MUDDYWATER]],
	:tmlist => [:THIEF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Field],
	:Height => 14,
	:Weight => 750,
	:kind => "Water Fish",
	:dexentry => "A Quagsire hunts by leaving its mouth wide open in water and waiting for its prey to blunder in. Because it doesn't move, it does not get very hungry.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:ESPEON => {
	:name => "Espeon",
	:dexnum => 196,
	:Type1 => :PSYCHIC,
	:BaseStats => [65, 65, 60, 110, 130, 95],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:SYNCHRONIZE,:SYNCHRONIZE],
	:HiddenAbilities => :MAGICBOUNCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 184,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 9180,
	:Moveset => [
		[0,:CONFUSION],
		[1,:HELPINGHAND],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[5,:SANDATTACK],
		[9,:BABYDOLLEYES],
		[13,:QUICKATTACK],
		[17,:SWIFT],
		[20,:PSYBEAM],
		[25,:FUTURESIGHT],
		[29,:PSYCHUP],
		[33,:MORNINGSUN],
		[37,:PSYCHIC],
		[41,:LASTRESORT],
		[45,:POWERSWAP]],
	:tmlist => [:SIGNALBEAM,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:IRONTAIL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,:CELEBRATE,],
	:Color => "Purple",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 9,
	:Weight => 265,
	:kind => "Sun",
	:dexentry => "An Espeon is loyal to any Trainer it considers to be worthy. It is said to have developed precognitive powers to protect its Trainer from harm.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:UMBREON => {
	:name => "Umbreon",
	:dexnum => 197,
	:Type1 => :DARK,
	:BaseStats => [95, 65, 110, 65, 60, 130],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:SYNCHRONIZE,:SYNCHRONIZE],
	:HiddenAbilities => :INNERFOCUS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 184,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 9180,
	:Moveset => [
		[0,:PURSUIT],
		[1,:HELPINGHAND],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[5,:SANDATTACK],
		[9,:BABYDOLLEYES],
		[13,:QUICKATTACK],
		[17,:CONFUSERAY],
		[20,:FEINTATTACK],
		[25,:ASSURANCE],
		[29,:SCREECH],
		[33,:MOONLIGHT],
		[37,:MEANLOOK],
		[41,:LASTRESORT],
		[45,:GUARDSWAP]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:SNATCH,:TAUNT,:TORMENT,:SUNNYDAY,:SHADOWBALL,:SPITE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:REST,:WONDERROOM,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:THROATCHOP,:CELEBRATE,],
	:Color => "Black",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 270,
	:kind => "Moonlight",
	:dexentry => "Umbreon evolved from exposure to the moon's energy. It lurks in darkness and waits for its foes to move. The rings on its body glow when it attacks.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:MURKROW => {
	:name => "Murkrow",
	:dexnum => 198,
	:Type1 => :DARK,
	:Type2 => :FLYING,
	:BaseStats => [60, 85, 42, 91, 85, 42],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:INSOMNIA,:SUPERLUCK],
	:HiddenAbilities => :PRANKSTER,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 81,
	:CatchRate => 30,
	:Happiness => 35,
	:EggSteps => 5355,
	:EggMoves => [:ASSURANCE,:BRAVEBIRD,:CONFUSERAY,:DRILLPECK,:FEATHERDANCE,:FEINTATTACK,:FLATTER,:MIRRORMOVE,:PERISHSONG,:PSYCHOSHIFT,:PUNISHMENT,:ROOST,:SCREECH,:SKYATTACK,:WHIRLWIND,:WINGATTACK],
	:Moveset => [
		[1,:PECK],
		[1,:ASTONISH],
		[5,:PURSUIT],
		[11,:HAZE],
		[15,:WINGATTACK],
		[21,:NIGHTSHADE],
		[25,:ASSURANCE],
		[31,:TAUNT],
		[35,:FEINTATTACK],
		[41,:MEANLOOK],
		[45,:FOULPLAY],
		[50,:TAILWIND],
		[55,:SUCKERPUNCH],
		[61,:TORMENT],
		[65,:QUASH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:EMBARGO,:QUASH,:SNATCH,:TAUNT,:TORMENT,:TWISTER,:THUNDERWAVE,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SPITE,:MUDSLAP,:ICYWIND,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:CALMMIND,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Black",
	:Habitat => "Forest",
	:EggGroups => [:Flying],
	:Height => 5,
	:Weight => 21,
	:kind => "Darkness",
	:dexentry => "Murkrow were feared as the bearers of ill fortune. It shows strong interest in anything that sparkles. It will even try to steal rings from women.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 21,
	:evolutions => [
		[:HONCHKROW,:Item,:DUSKSTONE]
	]
},

:SLOWKING => {
	:name => "Slowking",
	:dexnum => 199,
	:Type1 => :WATER,
	:Type2 => :PSYCHIC,
	:BaseStats => [95, 75, 80, 30, 100, 110],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:OBLIVIOUS,:OWNTEMPO],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 172,
	:CatchRate => 70,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:HEALPULSE],
		[1,:POWERGEM],
		[1,:HIDDENPOWER],
		[1,:CURSE],
		[1,:YAWN],
		[1,:TACKLE],
		[5,:GROWL],
		[9,:WATERGUN],
		[14,:CONFUSION],
		[19,:DISABLE],
		[23,:HEADBUTT],
		[28,:WATERPULSE],
		[32,:ZENHEADBUTT],
		[36,:NASTYPLOT],
		[41,:SWAGGER],
		[45,:PSYCHIC],
		[49,:TRUMPCARD],
		[54,:PSYCHUP],
		[58,:HEALPULSE]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:FOULPLAY,:FLING,:QUASH,:DRAGONTAIL,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:IRONDEFENSE,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Pink",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 20,
	:Weight => 795,
	:WildItemUncommon => :KINGSROCK,
	:kind => "Royal",
	:dexentry => "It undertakes research every day to solve the mysteries of the world. Apparently it forgets everything if the Shellder on its head comes off.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:MISDREAVUS => {
	:name => "Misdreavus",
	:dexnum => 200,
	:Type1 => :GHOST,
	:BaseStats => [60, 60, 60, 85, 85, 85],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 87,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 6630,
	:EggMoves => [:CURSE,:DESTINYBOND,:IMPRISON,:MEFIRST,:MEMENTO,:NASTYPLOT,:OMINOUSWIND,:SCREECH,:SHADOWSNEAK,:SKILLSWAP,:SPITE,:SUCKERPUNCH,:WONDERROOM],
	:Moveset => [
		[1,:GROWL],
		[1,:PSYWAVE],
		[5,:SPITE],
		[10,:ASTONISH],
		[14,:CONFUSERAY],
		[19,:MEANLOOK],
		[23,:HEX],
		[28,:PSYBEAM],
		[32,:PAINSPLIT],
		[37,:PAYBACK],
		[41,:SHADOWBALL],
		[46,:PERISHSONG],
		[50,:GRUDGE],
		[55,:POWERGEM]],
	:tmlist => [:FOULPLAY,:SUCKERPUNCH,:EMBARGO,:SNATCH,:TAUNT,:SHOCKWAVE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWBALL,:OMINOUSWIND,:SPITE,:ICYWIND,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HEALBELL,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:MAGICROOM,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:WONDERROOM,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:Habitat => "Cave",
	:EggGroups => [:Amorphous],
	:Height => 7,
	:Weight => 10,
	:kind => "Screech",
	:dexentry => "A Misdreavus frightens people with a creepy, sobbing cry. It apparently uses its red spheres to absorb the fear of foes as its nutrition.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 17,
	:evolutions => [
		[:MISMAGIUS,:Item,:DUSKSTONE]
	]
},

:UNOWN => {
	:name => "Unown",
	:dexnum => 201,
	:Type1 => :PSYCHIC,
	:BaseStats => [48, 72, 48, 48, 72, 48],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 118,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 10455,
	:Moveset => [
		[1,:HIDDENPOWER]],
	:tmlist => [],
	:Color => "Black",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 5,
	:Weight => 50,
	:kind => "Symbol",
	:dexentry => "This Pokémon is shaped like ancient text characters. Although research is ongoing, it is a mystery as to which came first, the writings or the Unown.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 19,
},

:WOBBUFFET => {
	:name => "Wobbuffet",
	:dexnum => 202,
	:Type1 => :PSYCHIC,
	:BaseStats => [190, 33, 58, 33, 33, 58],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:SHADOWTAG,:TELEPATHY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:COUNTER],
		[1,:MIRRORCOAT],
		[1,:SAFEGUARD],
		[1,:DESTINYBOND]],
	:tmlist => [],
	:Color => "Blue",
	:Habitat => "Cave",
	:EggGroups => [:Amorphous],
	:Height => 13,
	:Weight => 285,
	:kind => "Patient",
	:dexentry => "Usually docile, a Wobbuffet strikes back ferociously if its black tail is attacked. It makes its lair in caves where it waits for nightfall.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:GIRAFARIG => {
	:name => "Girafarig",
	:dexnum => 203,
	:Type1 => :NORMAL,
	:Type2 => :PSYCHIC,
	:BaseStats => [70, 80, 65, 85, 90, 65],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:INNERFOCUS,:EARLYBIRD],
	:HiddenAbilities => :SAPSIPPER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 159,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:BEATUP,:DOUBLEKICK,:FORESIGHT,:FUTURESIGHT,:MAGICCOAT,:MEANLOOK,:MIRRORCOAT,:RAZORWIND,:PSYCHICFANGS,:PSYCHICTERRAIN,:SECRETPOWER,:SKILLSWAP,:TAKEDOWN,:WISH],
	:Moveset => [
		[1,:POWERSWAP],
		[1,:GUARDSWAP],
		[1,:ASTONISH],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:CONFUSION],
		[5,:ODORSLEUTH],
		[10,:ASSURANCE],
		[14,:STOMP],
		[19,:PSYBEAM],
		[23,:AGILITY],
		[28,:DOUBLEHIT],
		[32,:ZENHEADBUTT],
		[37,:CRUNCH],
		[41,:BATONPASS],
		[46,:NASTYPLOT],
		[50,:PSYCHIC]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:SUCKERPUNCH,:THIEF,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:IRONTAIL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:STOMPINGTANTRUM,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 15,
	:Weight => 415,
	:kind => "Long Neck",
	:dexentry => "A Girafarig is a herbivore-- it eats grass and tree shoots. While it is eating, its tail makes chewing and swallowing motions as if it were also eating.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:PINECO => {
	:name => "Pineco",
	:dexnum => 204,
	:Type1 => :BUG,
	:BaseStats => [50, 65, 90, 15, 35, 35],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:STURDY,:OVERCOAT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:COUNTER,:DOUBLEEDGE,:ENDURE,:FLAIL,:PINMISSILE,:POWERTRICK,:REVENGE,:SANDTOMB,:STEALTHROCK,:SWIFT,:TOXICSPIKES],
	:Moveset => [
		[1,:TACKLE],
		[1,:PROTECT],
		[6,:SELFDESTRUCT],
		[9,:BUGBITE],
		[12,:TAKEDOWN],
		[17,:RAPIDSPIN],
		[20,:BIDE],
		[23,:NATURALGIFT],
		[28,:SPIKES],
		[31,:PAYBACK],
		[34,:EXPLOSION],
		[39,:IRONDEFENSE],
		[42,:GYROBALL],
		[45,:DOUBLEEDGE]],
	:tmlist => [:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:PAYBACK,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:GIGADRAIN,:EARTHQUAKE,:DRILLRUN,:BULLDOZE,:EXPLOSION,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:VENOSHOCK,:TOXIC,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:GYROBALL,:IRONDEFENSE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 6,
	:Weight => 72,
	:kind => "Bagworm",
	:dexentry => "A Pineco hangs from a branch and waits for prey. While eating, if it is disturbed by someone shaking its tree, it falls on the ground and explodes.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 10,
	:evolutions => [
		[:FORRETRESS,:Level,31]
	]
},

:FORRETRESS => {
	:name => "Forretress",
	:dexnum => 205,
	:Type1 => :BUG,
	:Type2 => :STEEL,
	:BaseStats => [75, 90, 140, 40, 60, 60],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:STURDY,:OVERCOAT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 163,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:MIRRORSHOT],
		[0,:AUTOTOMIZE],
		[1,:HEAVYSLAM],
		[1,:ZAPCANNON],
		[1,:MAGNETRISE],
		[1,:TOXICSPIKES],
		[1,:TACKLE],
		[1,:PROTECT],
		[1,:SELFDESTRUCT],
		[1,:BUGBITE],
		[6,:SELFDESTRUCT],
		[9,:BUGBITE],
		[12,:TAKEDOWN],
		[17,:RAPIDSPIN],
		[20,:BIDE],
		[23,:NATURALGIFT],
		[28,:SPIKES],
		[32,:PAYBACK],
		[36,:EXPLOSION],
		[42,:IRONDEFENSE],
		[46,:GYROBALL],
		[50,:DOUBLEEDGE],
		[56,:MAGNETRISE],
		[60,:ZAPCANNON],
		[64,:HEAVYSLAM]],
	:tmlist => [:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:PAYBACK,:VOLTSWITCH,:MAGNETRISE,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:GIGADRAIN,:EARTHQUAKE,:DRILLRUN,:BULLDOZE,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:VENOSHOCK,:TOXIC,:ALLYSWITCH,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:TELEKINESIS,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:CONFIDE,:LASERFOCUS,],
	:Color => "Purple",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 12,
	:Weight => 1258,
	:kind => "Bagworm",
	:dexentry => "It keeps itself inside its steel shell. The shell is opened when it is catching prey, but it is so quick that the shell's inside cannot be seen.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
},

:DUNSPARCE => {
	:name => "Dunsparce",
	:dexnum => 206,
	:Type1 => :NORMAL,
	:BaseStats => [100, 70, 70, 45, 65, 65],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:SERENEGRACE,:RUNAWAY],
	:HiddenAbilities => :RATTLED,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 145,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:ANCIENTPOWER,:ASTONISH,:BIDE,:BITE,:CURSE,:HEADBUTT,:HEX,:MAGICCOAT,:SECRETPOWER,:SLEEPTALK,:SNORE,:TRUMPCARD],
	:Moveset => [
		[1,:RAGE],
		[1,:DEFENSECURL],
		[3,:ROLLOUT],
		[6,:SPITE],
		[8,:PURSUIT],
		[11,:SCREECH],
		[13,:MUDSLAP],
		[16,:YAWN],
		[18,:ANCIENTPOWER],
		[21,:BODYSLAM],
		[23,:DRILLRUN],
		[26,:ROOST],
		[28,:TAKEDOWN],
		[31,:COIL],
		[33,:DIG],
		[36,:GLARE],
		[38,:DOUBLEEDGE],
		[41,:ENDEAVOR],
		[43,:AIRSLASH],
		[46,:DRAGONRUSH],
		[48,:ENDURE],
		[51,:FLAIL]],
	:tmlist => [:THIEF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:ROOST,:SHADOWBALL,:SPITE,:SOLARBEAM,:EARTHQUAKE,:DRILLRUN,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:LASTRESORT,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:DREAMEATER,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:REST,:ROLEPLAY,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:GYROBALL,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Yellow",
	:Habitat => "Cave",
	:EggGroups => [:Field],
	:Height => 15,
	:Weight => 140,
	:kind => "Land Snake",
	:dexentry => "Its drill-tipped tail is used to burrow into the ground backwards. This Pokémon is known to make its nest in complex shapes deep under the ground.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
},

:GLIGAR => {
	:name => "Gligar",
	:dexnum => 207,
	:Type1 => :GROUND,
	:Type2 => :FLYING,
	:BaseStats => [65, 75, 105, 85, 35, 65],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:SANDVEIL],
	:HiddenAbilities => :IMMUNITY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 86,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:BATONPASS,:COUNTER,:CROSSPOISON,:DOUBLEEDGE,:FEINT,:METALCLAW,:NIGHTSLASH,:POISONTAIL,:POWERTRICK,:RAZORWIND,:ROCKCLIMB,:SANDTOMB,:WINGATTACK],
	:Moveset => [
		[1,:POISONSTING],
		[4,:SANDATTACK],
		[7,:HARDEN],
		[10,:KNOCKOFF],
		[13,:QUICKATTACK],
		[16,:FURYCUTTER],
		[19,:FEINTATTACK],
		[22,:ACROBATICS],
		[27,:SLASH],
		[30,:UTURN],
		[35,:SCREECH],
		[40,:XSCISSOR],
		[45,:SKYUPPERCUT],
		[50,:SWORDSDANCE],
		[55,:GUILLOTINE]],
	:tmlist => [:XSCISSOR,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:DARKPULSE,:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:ACROBATICS,:DEFOG,:ROOST,:TAILWIND,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:ALLYSWITCH,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:STEELWING,:AQUATAIL,:RAINDANCE,:CONFIDE,:THROATCHOP,],
	:Color => "Purple",
	:Habitat => "Mountain",
	:EggGroups => [:Bug],
	:Height => 11,
	:Weight => 648,
	:kind => "FlyScorpion",
	:dexentry => "It glides without making a single sound. It grasps the face of its foe using its hind and large front claws, then stabs with its poison barb.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 8,
	:evolutions => [
		[:GLISCOR,:NightHoldItem,:RAZORFANG]
	]
},

:STEELIX => {
	:name => "Steelix",
	:dexnum => 208,
	:Type1 => :STEEL,
	:Type2 => :GROUND,
	:BaseStats => [75, 85, 200, 30, 55, 65],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:STURDY],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 179,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:THUNDERFANG],
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:MUDSPORT],
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:BIND],
		[4,:CURSE],
		[7,:ROCKTHROW],
		[10,:ROCKTOMB],
		[13,:RAGE],
		[16,:STEALTHROCK],
		[19,:AUTOTOMIZE],
		[20,:GYROBALL],
		[22,:SMACKDOWN],
		[25,:DRAGONBREATH],
		[28,:SLAM],
		[31,:SCREECH],
		[34,:ROCKSLIDE],
		[37,:CRUNCH],
		[40,:IRONTAIL],
		[43,:DIG],
		[46,:STONEEDGE],
		[49,:DOUBLEEDGE],
		[52,:SANDSTORM]],
	:tmlist => [:DARKPULSE,:PAYBACK,:TAUNT,:TORMENT,:DRAGONPULSE,:DRAGONTAIL,:TWISTER,:MAGNETRISE,:ROCKSMASH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:GYROBALL,:AQUATAIL,:CONFIDE,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "Cave",
	:EggGroups => [:Mineral],
	:Height => 92,
	:Weight => 4000,
	:WildItemUncommon => :METALCOAT,
	:kind => "Iron Snake",
	:dexentry => "Steelix live even further underground than Onix. This Pokémon digs toward the earth's core, reaching a depth of over six-tenths of a mile underground.",
	:BattlerPlayerY => 8,
	:BattlerEnemyY => 4,
	:BattlerAltitude => 0,
},

:SNUBBULL => {
	:name => "Snubbull",
	:dexnum => 209,
	:Type1 => :FAIRY,
	:BaseStats => [60, 80, 50, 30, 40, 40],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:RUNAWAY],
	:HiddenAbilities => :RATTLED,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 60,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CLOSECOMBAT,:CRUNCH,:DOUBLEEDGE,:FAKETEARS,:FEINTATTACK,:FIREFANG,:FOCUSPUNCH,:HEALBELL,:ICEFANG,:METRONOME,:MIMIC,:PRESENT,:SMELLINGSALTS,:SNORE,:THUNDERFANG],
	:Moveset => [
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:TACKLE],
		[1,:SCARYFACE],
		[1,:TAILWHIP],
		[1,:CHARM],
		[7,:BITE],
		[13,:LICK],
		[19,:HEADBUTT],
		[25,:ROAR],
		[31,:RAGE],
		[37,:PLAYROUGH],
		[43,:PAYBACK],
		[49,:CRUNCH]],
	:tmlist => [:SNARL,:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:BULKUP,:OVERHEAT,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HEALBELL,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:SLUDGEBOMB,:TOXIC,:ALLYSWITCH,:REFLECT,:REST,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,],
	:Color => "Pink",
	:Habitat => "Urban",
	:EggGroups => [:Field,:Fairy],
	:Height => 6,
	:Weight => 78,
	:kind => "Fairy",
	:dexentry => "By baring its fangs and making a scary face, it sends smaller Pokémon scurrying in terror. Snubbull does seem a little sad at making its foes flee.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GRANBULL,:Level,23]
	]
},

:GRANBULL => {
	:name => "Granbull",
	:dexnum => 210,
	:Type1 => :FAIRY,
	:BaseStats => [90, 120, 75, 45, 60, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:QUICKFEET],
	:HiddenAbilities => :RATTLED,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 158,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:OUTRAGE],
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:TACKLE],
		[1,:SCARYFACE],
		[1,:TAILWHIP],
		[1,:CHARM],
		[7,:BITE],
		[13,:LICK],
		[19,:HEADBUTT],
		[27,:ROAR],
		[35,:RAGE],
		[43,:PLAYROUGH],
		[51,:PAYBACK],
		[59,:CRUNCH],
		[67,:OUTRAGE]],
	:tmlist => [:SNARL,:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:OUTRAGE,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:BULKUP,:OVERHEAT,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HEALBELL,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:SLUDGEBOMB,:TOXIC,:ALLYSWITCH,:REFLECT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Purple",
	:Habitat => "Urban",
	:EggGroups => [:Field,:Fairy],
	:Height => 14,
	:Weight => 487,
	:kind => "Fairy",
	:dexentry => "It has a particularly well-developed lower jaw. The huge fangs are heavy, causing it to tilt its head. Unless it is startled, it will not try to bite.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:QWILFISH => {
	:name => "Qwilfish",
	:dexnum => 211,
	:Type1 => :WATER,
	:Type2 => :POISON,
	:BaseStats => [65, 95, 85, 85, 55, 55],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:POISONPOINT,:SWIFTSWIM],
	:HiddenAbilities => :INTIMIDATE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 86,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACIDSPRAY,:AQUAJET,:ASTONISH,:BRINE,:BUBBLEBEAM,:FLAIL,:HAZE,:SIGNALBEAM,:SUPERSONIC,:WATERPULSE],
	:Moveset => [
		[1,:FELLSTINGER],
		[1,:HYDROPUMP],
		[1,:DESTINYBOND],
		[1,:WATERGUN],
		[1,:SPIKES],
		[1,:TACKLE],
		[1,:POISONSTING],
		[9,:HARDEN],
		[9,:MINIMIZE],
		[13,:BUBBLE],
		[17,:ROLLOUT],
		[21,:TOXICSPIKES],
		[25,:STOCKPILE],
		[25,:SPITUP],
		[29,:REVENGE],
		[33,:BRINE],
		[37,:PINMISSILE],
		[41,:TAKEDOWN],
		[45,:AQUATAIL],
		[49,:POISONJAB],
		[53,:DESTINYBOND],
		[57,:HYDROPUMP],
		[60,:FELLSTINGER]],
	:tmlist => [:SIGNALBEAM,:PAYBACK,:TAUNT,:SHOCKWAVE,:THUNDERWAVE,:BOUNCE,:SHADOWBALL,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:EXPLOSION,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:ALLYSWITCH,:REST,:GYROBALL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,:THROATCHOP,],
	:Color => "Gray",
	:Habitat => "Sea",
	:EggGroups => [:Water2],
	:Height => 5,
	:Weight => 39,
	:WildItemUncommon => :POISONBARB,
	:kind => "Balloon",
	:dexentry => "A Qwilfish uses the pressure of water it swallows to shoot toxic quills out from all over its body. It finds swimming to be somewhat challenging.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 12,
},

:SCIZOR => {
	:name => "Scizor",
	:dexnum => 212,
	:Type1 => :BUG,
	:Type2 => :STEEL,
	:BaseStats => [70, 130, 100, 65, 55, 80],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SWARM,:TECHNICIAN],
	:HiddenAbilities => :LIGHTMETAL,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:FEINT],
		[1,:BULLETPUNCH],
		[1,:QUICKATTACK],
		[1,:LEER],
		[5,:FOCUSENERGY],
		[9,:PURSUIT],
		[13,:FALSESWIPE],
		[17,:AGILITY],
		[21,:METALCLAW],
		[25,:FURYCUTTER],
		[29,:SLASH],
		[33,:RAZORWIND],
		[37,:IRONDEFENSE],
		[41,:XSCISSOR],
		[45,:NIGHTSLASH],
		[49,:DOUBLEHIT],
		[50,:IRONHEAD],
		[57,:SWORDSDANCE],
		[61,:FEINT]],
	:tmlist => [:XSCISSOR,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:ACROBATICS,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:VENOSHOCK,:TOXIC,:ALLYSWITCH,:LIGHTSCREEN,:REST,:SANDSTORM,:FLASHCANNON,:IRONHEAD,:STEELWING,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:BRUTALSWING,:LASERFOCUS,],
	:Color => "Red",
	:Habitat => "Grassland",
	:EggGroups => [:Bug],
	:Height => 18,
	:Weight => 1180,
	:kind => "Pincer",
	:dexentry => "A Scizor has a body as hard as steel. It is not easily fazed by ordinary sorts of attacks. It flaps its wings to regulate its body temperature.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:SHUCKLE => {
	:name => "Shuckle",
	:dexnum => 213,
	:Type1 => :BUG,
	:Type2 => :ROCK,
	:BaseStats => [20, 10, 230, 5, 10, 230],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:STURDY,:GLUTTONY],
	:HiddenAbilities => :CONTRARY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 177,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACID,:ACUPRESSURE,:FINALGAMBIT,:HELPINGHAND,:KNOCKOFF,:MUDSLAP,:ROCKBLAST,:SANDTOMB,:SWEETSCENT],
	:Moveset => [
		[1,:STICKYWEB],
		[1,:WITHDRAW],
		[1,:CONSTRICT],
		[1,:BIDE],
		[1,:ROLLOUT],
		[5,:ENCORE],
		[9,:WRAP],
		[12,:STRUGGLEBUG],
		[16,:SAFEGUARD],
		[20,:REST],
		[23,:ROCKTHROW],
		[27,:GASTROACID],
		[31,:POWERTRICK],
		[34,:SHELLSMASH],
		[38,:ROCKSLIDE],
		[42,:BUGBITE],
		[45,:POWERSPLIT],
		[45,:GUARDSPLIT],
		[49,:STONEEDGE],
		[53,:STICKYWEB]],
	:tmlist => [:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:KNOCKOFF,:ROCKSMASH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:ALLYSWITCH,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:GYROBALL,:CONFIDE,:INFESTATION,],
	:Color => "Yellow",
	:Habitat => "Mountain",
	:EggGroups => [:Bug],
	:Height => 6,
	:Weight => 205,
	:WildItemCommon => :BERRYJUICE,
	:WildItemUncommon => :BERRYJUICE,
	:WildItemRare => :BERRYJUICE,
	:kind => "Mold",
	:dexentry => "A Shuckle hides under rocks, keeping its body inside its shell while eating stored berries. The berries mix with its body fluids to become a juice.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
},

:HERACROSS => {
	:name => "Heracross",
	:dexnum => 214,
	:Type1 => :BUG,
	:Type2 => :FIGHTING,
	:BaseStats => [80, 125, 75, 85, 40, 95],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SWARM,:GUTS],
	:HiddenAbilities => :MOXIE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:BIDE,:DOUBLEEDGE,:FLAIL,:FOCUSPUNCH,:HARDEN,:MEGAHORN,:PURSUIT,:REVENGE,:ROCKBLAST,:SEISMICTOSS],
	:Moveset => [
		[1,:ARMTHRUST],
		[1,:BULLETSEED],
		[1,:NIGHTSLASH],
		[1,:TACKLE],
		[1,:LEER],
		[1,:HORNATTACK],
		[1,:ENDURE],
		[7,:FEINT],
		[10,:AERIALACE],
		[16,:CHIPAWAY],
		[19,:COUNTER],
		[25,:FURYATTACK],
		[28,:BRICKBREAK],
		[31,:PINMISSILE],
		[34,:TAKEDOWN],
		[37,:MEGAHORN],
		[43,:CLOSECOMBAT],
		[46,:REVERSAL]],
	:tmlist => [:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:VENOSHOCK,:TOXIC,:ALLYSWITCH,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:BRUTALSWING,:THROATCHOP,],
	:Color => "Blue",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 15,
	:Weight => 540,
	:kind => "Single Horn",
	:dexentry => "They gather in forests seeking the sap of trees. It is completely clad in a steel-hard shell. It is proud of its horn, which it uses to fling foes.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:SNEASEL => {
	:name => "Sneasel",
	:dexnum => 215,
	:Type1 => :DARK,
	:Type2 => :ICE,
	:BaseStats => [55, 95, 55, 115, 35, 75],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:INNERFOCUS,:KEENEYE],
	:HiddenAbilities => :PICKPOCKET,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 86,
	:CatchRate => 60,
	:Happiness => 35,
	:EggSteps => 5355,
	:EggMoves => [:ASSIST,:AVALANCHE,:BITE,:COUNTER,:CRUSHCLAW,:DOUBLEHIT,:FAKEOUT,:FEINT,:FORESIGHT,:ICEPUNCH,:ICESHARD,:ICICLECRASH,:PUNISHMENT,:PURSUIT,:SPITE,:THROATCHOP],
	:Moveset => [
		[1,:SCRATCH],
		[1,:LEER],
		[1,:TAUNT],
		[8,:QUICKATTACK],
		[10,:FEINTATTACK],
		[14,:ICYWIND],
		[16,:FURYSWIPES],
		[20,:AGILITY],
		[22,:METALCLAW],
		[25,:HONECLAWS],
		[28,:BEATUP],
		[32,:SCREECH],
		[35,:SLASH],
		[40,:SNATCH],
		[44,:PUNISHMENT],
		[47,:ICESHARD]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:FOCUSPUNCH,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:DREAMEATER,:ALLYSWITCH,:CALMMIND,:REFLECT,:REST,:IRONTAIL,:SURF,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Black",
	:Habitat => "Forest",
	:EggGroups => [:Field],
	:Height => 9,
	:Weight => 280,
	:WildItemUncommon => :QUICKCLAW,
	:kind => "Sharp Claw",
	:dexentry => "A Sneasel scales trees by punching its hooked claws into the bark. It seeks out unguarded nests and steals eggs for food while the parents are away.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WEAVILE,:NightHoldItem,:RAZORCLAW]
	]
},

:TEDDIURSA => {
	:name => "Teddiursa",
	:dexnum => 216,
	:Type1 => :NORMAL,
	:BaseStats => [60, 80, 50, 40, 50, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:PICKUP,:QUICKFEET],
	:HiddenAbilities => :HONEYGATHER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BELLYDRUM,:CHIPAWAY,:CLOSECOMBAT,:COUNTER,:CROSSCHOP,:CRUNCH,:DOUBLEEDGE,:FAKETEARS,:METALCLAW,:NIGHTSLASH,:PLAYROUGH,:SEISMICTOSS,:SLEEPTALK,:TAKEDOWN,:YAWN],
	:Moveset => [
		[1,:FLING],
		[1,:COVET],
		[1,:SCRATCH],
		[1,:BABYDOLLEYES],
		[1,:LICK],
		[1,:FAKETEARS],
		[8,:FURYSWIPES],
		[15,:FEINTATTACK],
		[22,:SWEETSCENT],
		[25,:PLAYNICE],
		[29,:SLASH],
		[36,:CHARM],
		[43,:REST],
		[43,:SNORE],
		[50,:THRASH],
		[57,:FLING]],
	:tmlist => [:FURYCUTTER,:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:THUNDERPUNCH,:FOCUSPUNCH,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:BULKUP,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SEEDBOMB,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GUNKSHOT,:TOXIC,:ALLYSWITCH,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 88,
	:kind => "Little Bear",
	:dexentry => "It licks its palms that are sweetened by being soaked in honey. A Teddiursa makes its own honey by blending fruits and pollen collected by Beedrill.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:URSARING,:Level,30]
	]
},

:URSARING => {
	:name => "Ursaring",
	:dexnum => 217,
	:Type1 => :NORMAL,
	:BaseStats => [90, 130, 75, 55, 75, 75],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:GUTS,:QUICKFEET],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:HAMMERARM],
		[1,:COVET],
		[1,:SCRATCH],
		[1,:LEER],
		[1,:LICK],
		[1,:FAKETEARS],
		[8,:FURYSWIPES],
		[15,:FEINTATTACK],
		[22,:SWEETSCENT],
		[25,:PLAYNICE],
		[29,:SLASH],
		[38,:SCARYFACE],
		[47,:REST],
		[49,:SNORE],
		[58,:THRASH],
		[67,:HAMMERARM]],
	:tmlist => [:FURYCUTTER,:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SEEDBOMB,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GUNKSHOT,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 18,
	:Weight => 1258,
	:kind => "Hibernator",
	:dexentry => "It is said that there are many streams and towering trees where an Ursaring gathers food. It walks through its forest collecting food every day.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:SLUGMA => {
	:name => "Slugma",
	:dexnum => 218,
	:Type1 => :FIRE,
	:BaseStats => [40, 40, 40, 20, 70, 40],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:MAGMAARMOR,:FLAMEBODY],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 50,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACIDARMOR,:CURSE,:EARTHPOWER,:GUARDSWAP,:HEATWAVE,:INFERNO,:MEMENTO,:ROLLOUT,:SMOKESCREEN,:SPITUP,:STOCKPILE,:SWALLOW],
	:Moveset => [
		[1,:YAWN],
		[1,:SMOG],
		[6,:EMBER],
		[8,:ROCKTHROW],
		[13,:HARDEN],
		[15,:INCINERATE],
		[20,:CLEARSMOG],
		[22,:ANCIENTPOWER],
		[27,:FLAMEBURST],
		[29,:ROCKSLIDE],
		[34,:LAVAPLUME],
		[36,:AMNESIA],
		[41,:BODYSLAM],
		[43,:RECOVER],
		[48,:FLAMETHROWER],
		[50,:EARTHPOWER]],
	:tmlist => [:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:EARTHPOWER,:MUDSLAP,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:IRONDEFENSE,:CONFIDE,:INFESTATION,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:Amorphous],
	:Height => 7,
	:Weight => 350,
	:kind => "Lava",
	:dexentry => "It is a species of Pokémon that lives in volcanic areas. If its body cools, its skin hardens and immobilizes it. To avoid that, it sleeps near magma.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MAGCARGO,:Level,38]
	]
},

:MAGCARGO => {
	:name => "Magcargo",
	:dexnum => 219,
	:Type1 => :FIRE,
	:Type2 => :ROCK,
	:BaseStats => [60, 50, 120, 30, 90, 80],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:MAGMAARMOR,:FLAMEBODY],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SHELLSMASH],
		[1,:EARTHPOWER],
		[1,:YAWN],
		[1,:SMOG],
		[1,:EMBER],
		[1,:ROCKTHROW],
		[6,:EMBER],
		[8,:ROCKTHROW],
		[13,:HARDEN],
		[15,:INCINERATE],
		[20,:CLEARSMOG],
		[22,:ANCIENTPOWER],
		[27,:FLAMEBURST],
		[29,:ROCKSLIDE],
		[34,:LAVAPLUME],
		[36,:AMNESIA],
		[43,:BODYSLAM],
		[47,:RECOVER],
		[54,:FLAMETHROWER],
		[58,:EARTHPOWER]],
	:tmlist => [:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:GYROBALL,:IRONDEFENSE,:CONFIDE,:INFESTATION,:STOMPINGTANTRUM,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:Amorphous],
	:Height => 8,
	:Weight => 550,
	:kind => "Lava",
	:dexentry => "The shell on its back is made of hardened magma. Tens of thousands of years spent living in volcanic craters have turned Magcargo's bodies into magma.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:SWINUB => {
	:name => "Swinub",
	:dexnum => 220,
	:Type1 => :ICE,
	:Type2 => :GROUND,
	:BaseStats => [50, 50, 40, 50, 30, 30],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:OBLIVIOUS,:SNOWCLOAK],
	:HiddenAbilities => :THICKFAT,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 50,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:AVALANCHE,:BITE,:BODYSLAM,:CURSE,:DOUBLEEDGE,:FISSURE,:FREEZEDRY,:ICICLECRASH,:ICICLESPEAR,:MUDSHOT,:STEALTHROCK,:TAKEDOWN],
	:Moveset => [
		[1,:TACKLE],
		[1,:ODORSLEUTH],
		[5,:MUDSPORT],
		[8,:POWDERSNOW],
		[11,:MUDSLAP],
		[14,:ENDURE],
		[18,:MUDBOMB],
		[21,:ICYWIND],
		[24,:ICESHARD],
		[28,:TAKEDOWN],
		[35,:MIST],
		[37,:EARTHQUAKE],
		[40,:FLAIL],
		[44,:BLIZZARD],
		[48,:AMNESIA]],
	:tmlist => [:SUPERPOWER,:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Cave",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 65,
	:kind => "Pig",
	:dexentry => "It roots for food by rubbing its snout against the ground. It likes mushrooms that grow under dried grass. It occasionally roots out hot springs.",
	:BattlerPlayerY => 36,
	:BattlerEnemyY => 31,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PILOSWINE,:Level,33]
	]
},

:PILOSWINE => {
	:name => "Piloswine",
	:dexnum => 221,
	:Type1 => :ICE,
	:Type2 => :GROUND,
	:BaseStats => [100, 100, 80, 50, 60, 60],
	:EVs => [1, 1, 0, 0, 0, 0],
	:Abilities => [:OBLIVIOUS,:SNOWCLOAK],
	:HiddenAbilities => :THICKFAT,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 158,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:FURYATTACK],
		[1,:ANCIENTPOWER],
		[1,:PECK],
		[1,:ODORSLEUTH],
		[1,:MUDSPORT],
		[1,:POWDERSNOW],
		[5,:MUDSPORT],
		[8,:POWDERSNOW],
		[11,:MUDSLAP],
		[14,:ENDURE],
		[18,:MUDBOMB],
		[21,:ICYWIND],
		[24,:ICEFANG],
		[28,:TAKEDOWN],
		[37,:MIST],
		[41,:THRASH],
		[46,:EARTHQUAKE],
		[52,:BLIZZARD],
		[58,:AMNESIA]],
	:tmlist => [:SUPERPOWER,:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Cave",
	:EggGroups => [:Field],
	:Height => 11,
	:Weight => 558,
	:kind => "Swine",
	:dexentry => "A Piloswine is covered by a thick coat of long hair for enduring freezing cold. It uses its tusks to dig up food that has been buried under ice.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MAMOSWINE,:HasMove,506]
	]
},

:CORSOLA => {
	:name => "Corsola",
	:dexnum => 222,
	:Type1 => :WATER,
	:Type2 => :ROCK,
	:BaseStats => [65, 55, 95, 35, 65, 95],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:HUSTLE,:NATURALCURE],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 133,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:AQUARING,:BARRIER,:BIDE,:CAMOUFLAGE,:CONFUSERAY,:CURSE,:HEADSMASH,:ICICLESPEAR,:INGRAIN,:LIQUIDATION,:MIST,:NATUREPOWER,:SCREECH,:WATERPULSE],
	:Moveset => [
		[1,:TACKLE],
		[1,:HARDEN],
		[4,:BUBBLE],
		[8,:RECOVER],
		[10,:BUBBLEBEAM],
		[13,:REFRESH],
		[17,:ANCIENTPOWER],
		[20,:SPIKECANNON],
		[23,:LUCKYCHANT],
		[27,:BRINE],
		[29,:IRONDEFENSE],
		[31,:ROCKBLAST],
		[35,:ENDURE],
		[38,:AQUARING],
		[41,:POWERGEM],
		[45,:MIRRORCOAT],
		[47,:EARTHPOWER],
		[50,:FLAIL]],
	:tmlist => [:SUCKERPUNCH,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:EXPLOSION,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONDEFENSE,:SURF,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Pink",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Water3],
	:Height => 6,
	:Weight => 50,
	:WildItemUncommon => :LUMINOUSMOSS,
	:kind => "Coral",
	:dexentry => "Corsola live in warm southern seas. If the sea becomes polluted, the beautiful coral stalks become discolored and crumble away in tatters.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:REMORAID => {
	:name => "Remoraid",
	:dexnum => 223,
	:Type1 => :WATER,
	:BaseStats => [35, 65, 35, 65, 65, 35],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:HUSTLE,:SNIPER],
	:HiddenAbilities => :MOODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACIDSPRAY,:AURORABEAM,:ENTRAINMENT,:FLAIL,:HAZE,:MUDSHOT,:OCTAZOOKA,:ROCKBLAST,:SCREECH,:SNORE,:SUPERSONIC,:SWIFT,:WATERPULSE,:WATERSPOUT],
	:Moveset => [
		[1,:WATERGUN],
		[6,:LOCKON],
		[10,:PSYBEAM],
		[14,:AURORABEAM],
		[18,:BUBBLEBEAM],
		[22,:FOCUSENERGY],
		[26,:WATERPULSE],
		[30,:SIGNALBEAM],
		[34,:ICEBEAM],
		[38,:BULLETSEED],
		[42,:HYDROPUMP],
		[46,:HYPERBEAM],
		[50,:SOAK]],
	:tmlist => [:SIGNALBEAM,:STRINGSHOT,:THIEF,:CHARGEBEAM,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:BOUNCE,:SEEDBOMB,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:PSYCHIC,:REST,:SMACKDOWN,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Water2],
	:Height => 6,
	:Weight => 120,
	:kind => "Jet",
	:dexentry => "Remoraid uses its abdominal muscles to expel swallowed water, then shoot down flying prey. When evolution approaches, it travels down rivers.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 11,
	:evolutions => [
		[:OCTILLERY,:Level,25]
	]
},

:OCTILLERY => {
	:name => "Octillery",
	:dexnum => 224,
	:Type1 => :WATER,
	:BaseStats => [75, 105, 75, 45, 105, 75],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:SUCTIONCUPS,:SNIPER],
	:HiddenAbilities => :MOODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 168,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:OCTAZOOKA],
		[1,:GUNKSHOT],
		[1,:ROCKBLAST],
		[1,:WATERGUN],
		[1,:CONSTRICT],
		[1,:PSYBEAM],
		[1,:AURORABEAM],
		[6,:CONSTRICT],
		[10,:PSYBEAM],
		[14,:AURORABEAM],
		[18,:BUBBLEBEAM],
		[22,:FOCUSENERGY],
		[28,:WRINGOUT],
		[34,:SIGNALBEAM],
		[40,:ICEBEAM],
		[46,:BULLETSEED],
		[52,:HYDROPUMP],
		[58,:HYPERBEAM],
		[64,:SOAK]],
	:tmlist => [:SIGNALBEAM,:STRINGSHOT,:PAYBACK,:THIEF,:CHARGEBEAM,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:BOUNCE,:ENERGYBALL,:SEEDBOMB,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:PSYCHIC,:REST,:SMACKDOWN,:FLASHCANNON,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Red",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Water2],
	:Height => 9,
	:Weight => 285,
	:kind => "Jet",
	:dexentry => "It ensnares its foe with its suction- cupped tentacles before delivering the final blow. If the foe turns out to be too strong, it spews ink to escape.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
},

:DELIBIRD => {
	:name => "Delibird",
	:dexnum => 225,
	:Type1 => :ICE,
	:Type2 => :FLYING,
	:BaseStats => [45, 55, 45, 75, 65, 45],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:VITALSPIRIT,:HUSTLE],
	:HiddenAbilities => :INSOMNIA,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 116,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AURORABEAM,:BESTOW,:COUNTER,:DESTINYBOND,:FAKEOUT,:FREEZEDRY,:FUTURESIGHT,:ICEBALL,:ICEPUNCH,:ICESHARD,:ICYWIND,:QUICKATTACK,:RAPIDSPIN,:SPIKES,:SPLASH],
	:Moveset => [
		[1,:PRESENT],
		[25,:DRILLPECK]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:FOCUSPUNCH,:BRICKBREAK,:SKYATTACK,:FLY,:BOUNCE,:AERIALACE,:DEFOG,:SEEDBOMB,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:REST,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:AURORAVEIL,:BRUTALSWING,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:Water1,:Field],
	:Height => 9,
	:Weight => 160,
	:kind => "Delivery",
	:dexentry => "Delibird carries food bundled up in its tail. Once, a famous explorer managed to climb the world's highest mountain only thanks to a Delibird sharing its food.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:MANTINE => {
	:name => "Mantine",
	:dexnum => 226,
	:Type1 => :WATER,
	:Type2 => :FLYING,
	:BaseStats => [85, 40, 70, 70, 80, 140],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:SWIFTSWIM,:WATERABSORB],
	:HiddenAbilities => :WATERVEIL,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 163,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:AMNESIA,:HAZE,:HYDROPUMP,:MIRRORCOAT,:MUDSPORT,:SLAM,:SPLASH,:TWISTER,:WATERSPORT,:WIDEGUARD],
	:Moveset => [
		[1,:PSYBEAM],
		[1,:BULLETSEED],
		[1,:SIGNALBEAM],
		[1,:TACKLE],
		[1,:BUBBLE],
		[1,:SUPERSONIC],
		[1,:BUBBLEBEAM],
		[1,:ROOST],
		[3,:SUPERSONIC],
		[7,:BUBBLEBEAM],
		[11,:CONFUSERAY],
		[14,:WINGATTACK],
		[16,:HEADBUTT],
		[19,:WATERPULSE],
		[23,:WIDEGUARD],
		[27,:TAKEDOWN],
		[32,:AGILITY],
		[36,:AIRSLASH],
		[39,:AQUARING],
		[46,:BOUNCE],
		[49,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:STRINGSHOT,:BOUNCE,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SEEDBOMB,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONHEAD,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Purple",
	:Habitat => "Sea",
	:EggGroups => [:Water1],
	:Height => 21,
	:Weight => 2200,
	:kind => "Kite",
	:dexentry => "On sunny days, schools of Mantine can be seen elegantly leaping over the waves. It is not bothered by the Remoraid that hitches rides.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 15,
},

:SKARMORY => {
	:name => "Skarmory",
	:dexnum => 227,
	:Type1 => :STEEL,
	:Type2 => :FLYING,
	:BaseStats => [65, 80, 140, 70, 40, 70],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:KEENEYE,:STURDY],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 163,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:ASSURANCE,:BRAVEBIRD,:CURSE,:DRILLPECK,:ENDURE,:GUARDSWAP,:PURSUIT,:SKYATTACK,:STEALTHROCK,:WHIRLWIND],
	:Moveset => [
		[1,:LEER],
		[1,:PECK],
		[6,:SANDATTACK],
		[9,:METALCLAW],
		[12,:AIRCUTTER],
		[17,:FURYATTACK],
		[20,:FEINT],
		[23,:SWIFT],
		[28,:SPIKES],
		[31,:AGILITY],
		[34,:STEELWING],
		[39,:SLASH],
		[42,:METALSOUND],
		[45,:AIRSLASH],
		[50,:AUTOTOMIZE],
		[53,:NIGHTSLASH]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:DARKPULSE,:PAYBACK,:THIEF,:TAUNT,:TORMENT,:TWISTER,:ROCKSMASH,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:ICYWIND,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:STEELWING,:IRONDEFENSE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Flying],
	:Height => 17,
	:Weight => 505,
	:WildItemUncommon => :METALCOAT,
	:kind => "Armor Bird",
	:dexentry => "A Pokémon that has a body and wings of steel. People in the past used feathers fallen from Skarmory to make swords and knives.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:HOUNDOUR => {
	:name => "Houndour",
	:dexnum => 228,
	:Type1 => :DARK,
	:Type2 => :FIRE,
	:BaseStats => [45, 60, 30, 65, 80, 50],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:EARLYBIRD,:FLASHFIRE],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 120,
	:Happiness => 35,
	:EggSteps => 5355,
	:EggMoves => [:BEATUP,:COUNTER,:DESTINYBOND,:FEINT,:FIREFANG,:FIRESPIN,:NASTYPLOT,:PUNISHMENT,:PURSUIT,:RAGE,:REVERSAL,:SPITE,:SUCKERPUNCH,:THUNDERFANG],
	:Moveset => [
		[1,:LEER],
		[1,:EMBER],
		[4,:HOWL],
		[8,:SMOG],
		[13,:ROAR],
		[16,:BITE],
		[20,:ODORSLEUTH],
		[25,:BEATUP],
		[28,:FIREFANG],
		[32,:FEINTATTACK],
		[37,:EMBARGO],
		[40,:FOULPLAY],
		[44,:FLAMETHROWER],
		[49,:CRUNCH],
		[52,:NASTYPLOT],
		[56,:INFERNO]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SPITE,:SOLARBEAM,:MUDSLAP,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:DREAMEATER,:MAGICCOAT,:REST,:IRONTAIL,:CONFIDE,],
	:Color => "Black",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 108,
	:kind => "Dark",
	:dexentry => "Houndour communicate with each other using a variety of cries to corner their prey. This Pokémon's remarkable teamwork is simply unparalleled.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:HOUNDOOM,:Level,24]
	]
},

:HOUNDOOM => {
	:name => "Houndoom",
	:dexnum => 229,
	:Type1 => :DARK,
	:Type2 => :FIRE,
	:BaseStats => [75, 90, 50, 95, 110, 80],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:EARLYBIRD,:FLASHFIRE],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 5355,
	:Moveset => [
		[1,:INFERNO],
		[1,:NASTYPLOT],
		[1,:THUNDERFANG],
		[1,:LEER],
		[1,:EMBER],
		[1,:HOWL],
		[1,:SMOG],
		[4,:HOWL],
		[8,:SMOG],
		[13,:ROAR],
		[16,:BITE],
		[20,:ODORSLEUTH],
		[26,:BEATUP],
		[30,:FIREFANG],
		[35,:FEINTATTACK],
		[41,:EMBARGO],
		[45,:FOULPLAY],
		[50,:FLAMETHROWER],
		[56,:CRUNCH],
		[60,:NASTYPLOT],
		[65,:INFERNO]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SPITE,:SOLARBEAM,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:DREAMEATER,:MAGICCOAT,:REST,:IRONTAIL,:CONFIDE,:LASERFOCUS,:THROATCHOP,],
	:Color => "Black",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Field],
	:Height => 14,
	:Weight => 350,
	:kind => "Dark",
	:dexentry => "In a Houndoom pack, the one with its horns raked sharply back serves a leadership role. They choose their leader by fighting among themselves.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:KINGDRA => {
	:name => "Kingdra",
	:dexnum => 230,
	:Type1 => :WATER,
	:Type2 => :DRAGON,
	:BaseStats => [75, 95, 95, 85, 95, 95],
	:EVs => [0, 1, 0, 0, 1, 1],
	:Abilities => [:SWIFTSWIM,:SNIPER],
	:HiddenAbilities => :DAMP,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 243,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:HYDROPUMP],
		[1,:YAWN],
		[1,:BUBBLE],
		[1,:SMOKESCREEN],
		[1,:LEER],
		[1,:WATERGUN],
		[5,:SMOKESCREEN],
		[9,:LEER],
		[13,:WATERGUN],
		[17,:TWISTER],
		[21,:BUBBLEBEAM],
		[26,:FOCUSENERGY],
		[31,:BRINE],
		[38,:AGILITY],
		[45,:DRAGONPULSE],
		[52,:DRAGONDANCE],
		[60,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:QUASH,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:TWISTER,:BOUNCE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:FLASHCANNON,:IRONHEAD,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Dragon],
	:Height => 18,
	:Weight => 1520,
	:WildItemUncommon => :DRAGONSCALE,
	:kind => "Dragon",
	:dexentry => "It sleeps quietly, deep on the seafloor. When it comes up to the surface, it creates a huge whirlpool that can swallow even ships.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 9,
},

:PHANPY => {
	:name => "Phanpy",
	:dexnum => 231,
	:Type1 => :GROUND,
	:BaseStats => [90, 60, 60, 40, 40, 40],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:PICKUP,:SANDVEIL],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:BODYSLAM,:COUNTER,:ENDEAVOR,:FISSURE,:FOCUSENERGY,:HEADSMASH,:HEAVYSLAM,:HIGHHORSEPOWER,:ICESHARD,:MUDSLAP,:PLAYROUGH,:SNORE],
	:Moveset => [
		[1,:ODORSLEUTH],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:DEFENSECURL],
		[6,:FLAIL],
		[10,:ROLLOUT],
		[15,:NATURALGIFT],
		[19,:ENDURE],
		[24,:SLAM],
		[28,:TAKEDOWN],
		[33,:CHARM],
		[37,:LASTRESORT],
		[42,:DOUBLEEDGE]],
	:tmlist => [:KNOCKOFF,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:SEEDBOMB,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 335,
	:kind => "Long Nose",
	:dexentry => "Phanpy's big ears serve as broad fans. When it becomes hot, it flaps the ears busily to cool down. Even the young are very strong.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DONPHAN,:Level,25]
	]
},

:DONPHAN => {
	:name => "Donphan",
	:dexnum => 232,
	:Type1 => :GROUND,
	:BaseStats => [90, 120, 120, 50, 60, 60],
	:EVs => [0, 1, 1, 0, 0, 0],
	:Abilities => [:STURDY,:SANDVEIL],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:FURYATTACK],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:HORNATTACK],
		[1,:BULLDOZE],
		[1,:GROWL],
		[1,:DEFENSECURL],
		[6,:RAPIDSPIN],
		[10,:ROLLOUT],
		[15,:ASSURANCE],
		[19,:KNOCKOFF],
		[24,:SLAM],
		[30,:MAGNITUDE],
		[37,:SCARYFACE],
		[43,:EARTHQUAKE],
		[50,:GIGAIMPACT]],
	:tmlist => [:KNOCKOFF,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:BOUNCE,:SEEDBOMB,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:GYROBALL,:IRONDEFENSE,:CONFIDE,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Field],
	:Height => 11,
	:Weight => 1200,
	:kind => "Armor",
	:dexentry => "A Donphan is so strong it can easily haul a dump truck. Its hide has toughened to a rock-hard state. An ordinary attack won't even leave a scratch.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:PORYGON2 => {
	:name => "Porygon2",
	:dexnum => 233,
	:Type1 => :NORMAL,
	:BaseStats => [85, 80, 90, 60, 105, 95],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:TRACE,:DOWNLOAD],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 180,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ZAPCANNON],
		[1,:MAGICCOAT],
		[1,:CONVERSION2],
		[1,:TACKLE],
		[1,:CONVERSION],
		[1,:DEFENSECURL],
		[7,:PSYBEAM],
		[12,:AGILITY],
		[18,:RECOVER],
		[23,:MAGNETRISE],
		[29,:SIGNALBEAM],
		[34,:RECYCLE],
		[40,:DISCHARGE],
		[45,:LOCKON],
		[50,:TRIATTACK],
		[56,:MAGICCOAT],
		[62,:ZAPCANNON],
		[67,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:THIEF,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SOLARBEAM,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:GRAVITY,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:RAINDANCE,],
	:Color => "Red",
	:Habitat => "Urban",
	:EggGroups => [:Mineral],
	:Height => 6,
	:Weight => 325,
	:kind => "Virtual",
	:dexentry => "It was created using the power of science. It has been given artificial intelligence that enables it to learn new gestures and emotions on its own.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 11,
	:evolutions => [
		[:PORYGONZ,:TradeItem,:DUBIOUSDISC]
	]
},

:STANTLER => {
	:name => "Stantler",
	:dexnum => 234,
	:Type1 => :NORMAL,
	:BaseStats => [73, 95, 62, 85, 85, 65],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:FRISK],
	:HiddenAbilities => :SAPSIPPER,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 163,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BITE,:DISABLE,:DOUBLEKICK,:EXTRASENSORY,:MEFIRST,:MEGAHORN,:MUDSPORT,:RAGE,:SPITE,:THRASH,:ZENHEADBUTT],
	:Moveset => [
		[1,:MEFIRST],
		[1,:TACKLE],
		[3,:LEER],
		[7,:ASTONISH],
		[10,:HYPNOSIS],
		[13,:STOMP],
		[16,:SANDATTACK],
		[21,:TAKEDOWN],
		[23,:CONFUSERAY],
		[27,:CALMMIND],
		[33,:ROLEPLAY],
		[38,:ZENHEADBUTT],
		[43,:JUMPKICK],
		[49,:IMPRISON],
		[50,:CAPTIVATE],
		[55,:MEFIRST]],
	:tmlist => [:SIGNALBEAM,:SUCKERPUNCH,:THIEF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SPITE,:SOLARBEAM,:ENERGYBALL,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:SKILLSWAP,:TRICKROOM,:IRONTAIL,:RAINDANCE,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Field],
	:Height => 14,
	:Weight => 712,
	:kind => "Big Horn",
	:dexentry => "Stantler's magnificent antlers were once traded at high prices as works of art. As a result, this Pokémon was hunted close to extinction.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
},

:SMEARGLE => {
	:name => "Smeargle",
	:dexnum => 235,
	:Type1 => :NORMAL,
	:BaseStats => [55, 20, 35, 75, 20, 45],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:OWNTEMPO,:TECHNICIAN],
	:HiddenAbilities => :MOODY,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 88,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:SKETCH],
		[11,:SKETCH],
		[21,:SKETCH],
		[31,:SKETCH],
		[41,:SKETCH],
		[51,:SKETCH],
		[61,:SKETCH],
		[71,:SKETCH],
		[81,:SKETCH],
		[91,:SKETCH]],
	:tmlist => [],
	:Color => "White",
	:Habitat => "Urban",
	:EggGroups => [:Field],
	:Height => 12,
	:Weight => 580,
	:kind => "Painter",
	:dexentry => "A Smeargle marks its territory using a fluid that leaks out from the tip of its tail. About 5,000 different marks left by this Pokémon have been found.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:TYROGUE => {
	:name => "Tyrogue",
	:dexnum => 236,
	:Type1 => :FIGHTING,
	:BaseStats => [35, 35, 35, 35, 35, 35],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:GUTS,:STEADFAST],
	:HiddenAbilities => :VITALSPIRIT,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemZero",
	:BaseEXP => 42,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:BULLETPUNCH,:COUNTER,:ENDURE,:FEINT,:HELPINGHAND,:HIJUMPKICK,:MACHPUNCH,:MINDREADER,:PURSUIT,:RAPIDSPIN,:VACUUMWAVE],
	:Moveset => [
		[1,:TACKLE],
		[1,:HELPINGHAND],
		[1,:FAKEOUT],
		[1,:FORESIGHT]],
	:tmlist => [:THIEF,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:SUNNYDAY,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:MAGICCOAT,:REST,:ROCKSLIDE,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Purple",
	:Habitat => "Urban",
	:EggGroups => [:Undiscovered],
	:Height => 7,
	:Weight => 210,
	:kind => "Scuffle",
	:dexentry => "Tyrogue become stressed out if they do not get to train every day. When raising this Pokémon, the Trainer must establish a regular training schedule.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:HITMONLEE,:AttackGreater,20],
		[:HITMONCHAN,:DefenseGreater,20],
		[:HITMONTOP,:AtkDefEqual,20]
	]
},

:HITMONTOP => {
	:name => "Hitmontop",
	:dexnum => 237,
	:Type1 => :FIGHTING,
	:BaseStats => [50, 95, 95, 70, 35, 110],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:INTIMIDATE,:TECHNICIAN],
	:HiddenAbilities => :STEADFAST,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemZero",
	:BaseEXP => 159,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[0,:ROLLINGKICK],
		[1,:ENDEAVOR],
		[1,:CLOSECOMBAT],
		[1,:DETECT],
		[1,:REVENGE],
		[1,:FOCUSENERGY],
		[1,:PURSUIT],
		[1,:QUICKATTACK],
		[6,:FOCUSENERGY],
		[10,:PURSUIT],
		[15,:QUICKATTACK],
		[19,:RAPIDSPIN],
		[24,:FEINT],
		[28,:COUNTER],
		[33,:TRIPLEKICK],
		[37,:AGILITY],
		[42,:GYROBALL],
		[46,:WIDEGUARD],
		[46,:QUICKGUARD],
		[50,:DETECT],
		[55,:CLOSECOMBAT],
		[60,:ENDEAVOR]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:TWISTER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:SUNNYDAY,:AERIALACE,:EARTHQUAKE,:DRILLRUN,:BULLDOZE,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROLLOUT,:SANDSTORM,:GYROBALL,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Brown",
	:Habitat => "Urban",
	:EggGroups => [:HumanLike],
	:Height => 14,
	:Weight => 480,
	:kind => "Handstand",
	:dexentry => "Its technique of kicking while spinning is a remarkable mix of both offense and defense. Hitmontop travel faster spinning than they do walking.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:SMOOCHUM => {
	:name => "Smoochum",
	:dexnum => 238,
	:Type1 => :ICE,
	:Type2 => :PSYCHIC,
	:BaseStats => [45, 30, 15, 65, 85, 65],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:OBLIVIOUS,:FOREWARN],
	:HiddenAbilities => :HYDRATION,
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 61,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:CAPTIVATE,:FAKEOUT,:ICEPUNCH,:MEDITATE,:MIRACLEEYE,:NASTYPLOT,:WAKEUPSLAP,:WISH],
	:Moveset => [
		[1,:POUND],
		[5,:LICK],
		[8,:SWEETKISS],
		[11,:POWDERSNOW],
		[15,:CONFUSION],
		[18,:SING],
		[21,:HEARTSTAMP],
		[25,:MEANLOOK],
		[28,:FAKETEARS],
		[31,:LUCKYCHANT],
		[35,:AVALANCHE],
		[38,:PSYCHIC],
		[41,:COPYCAT],
		[45,:PERISHSONG],
		[48,:BLIZZARD]],
	:tmlist => [:SIGNALBEAM,:PAYBACK,:THIEF,:FLING,:SHADOWBALL,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TRICK,:TRICKROOM,:WONDERROOM,:WATERPULSE,:RAINDANCE,:CONFIDE,:AURORAVEIL,],
	:Color => "Pink",
	:Habitat => "Urban",
	:EggGroups => [:Undiscovered],
	:Height => 4,
	:Weight => 60,
	:kind => "Kiss",
	:dexentry => "It actively runs about, but also falls often. Whenever it falls, it will check its reflection on a lake's surface to make sure its face isn't dirty.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:JYNX,:Level,30]
	]
},

:ELEKID => {
	:name => "Elekid",
	:dexnum => 239,
	:Type1 => :ELECTRIC,
	:BaseStats => [45, 63, 37, 95, 65, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:STATIC,:VITALSPIRIT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 72,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:BARRIER,:CROSSCHOP,:DYNAMICPUNCH,:FEINT,:FIREPUNCH,:FOCUSPUNCH,:HAMMERARM,:ICEPUNCH,:KARATECHOP,:MEDITATE,:ROLLINGKICK],
	:Moveset => [
		[1,:QUICKATTACK],
		[1,:LEER],
		[5,:THUNDERSHOCK],
		[8,:LOWKICK],
		[12,:SWIFT],
		[15,:SHOCKWAVE],
		[19,:THUNDERWAVE],
		[22,:ELECTROBALL],
		[26,:LIGHTSCREEN],
		[29,:THUNDERPUNCH],
		[33,:DISCHARGE],
		[36,:SCREECH],
		[40,:THUNDERBOLT],
		[43,:THUNDER]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:DUALCHOP,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:MUDSLAP,:ICEPUNCH,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:LIGHTSCREEN,:REST,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Undiscovered],
	:Height => 6,
	:Weight => 235,
	:WildItemUncommon => :ELECTIRIZER,
	:kind => "Electric",
	:dexentry => "If it touches metal and discharges the electricity it has stored in its body, an Elekid begins swinging its arms in circles to recharge itself.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ELECTABUZZ,:Level,30]
	]
},

:MAGBY => {
	:name => "Magby",
	:dexnum => 240,
	:Type1 => :FIRE,
	:BaseStats => [45, 75, 37, 83, 70, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:FLAMEBODY,:VITALSPIRIT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 73,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:BARRIER,:BELCH,:BELLYDRUM,:CROSSCHOP,:DYNAMICPUNCH,:FLAREBLITZ,:FOCUSENERGY,:IRONTAIL,:KARATECHOP,:MACHPUNCH,:MEGAPUNCH,:POWERSWAP,:SCREECH,:THUNDERPUNCH],
	:Moveset => [
		[1,:SMOG],
		[1,:LEER],
		[5,:EMBER],
		[8,:SMOKESCREEN],
		[12,:FEINTATTACK],
		[15,:FIRESPIN],
		[19,:CLEARSMOG],
		[22,:FLAMEBURST],
		[26,:CONFUSERAY],
		[29,:FIREPUNCH],
		[33,:LAVAPLUME],
		[36,:SUNNYDAY],
		[40,:FLAMETHROWER],
		[43,:FIREBLAST]],
	:tmlist => [:THIEF,:FLING,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:MUDSLAP,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:REST,:IRONTAIL,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:Undiscovered],
	:Height => 7,
	:Weight => 214,
	:WildItemUncommon => :MAGMARIZER,
	:kind => "Live Coal",
	:dexentry => "If a Magby is spouting yellow flames from its mouth, it is in good health. When it is fatigued, black smoke will be mixed in with the flames.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MAGMAR,:Level,30]
	]
},

:MILTANK => {
	:name => "Miltank",
	:dexnum => 241,
	:Type1 => :NORMAL,
	:BaseStats => [95, 80, 105, 100, 40, 70],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:THICKFAT,:SCRAPPY],
	:HiddenAbilities => :SAPSIPPER,
	:GrowthRate => "Slow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 172,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BELCH,:CURSE,:DIZZYPUNCH,:DOUBLEEDGE,:ENDURE,:HAMMERARM,:HEARTSTAMP,:HELPINGHAND,:NATURALGIFT,:PRESENT,:PUNISHMENT,:REVERSAL,:SEISMICTOSS,:SLEEPTALK],
	:Moveset => [
		[1,:TACKLE],
		[3,:GROWL],
		[5,:DEFENSECURL],
		[8,:STOMP],
		[11,:MILKDRINK],
		[15,:BIDE],
		[19,:ROLLOUT],
		[24,:BODYSLAM],
		[29,:ZENHEADBUTT],
		[35,:CAPTIVATE],
		[41,:GYROBALL],
		[48,:HEALBELL],
		[50,:WAKEUPSLAP]],
	:tmlist => [:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:GYROBALL,:SURF,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Pink",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 12,
	:Weight => 755,
	:WildItemCommon => :MOOMOOMILK,
	:WildItemUncommon => :MOOMOOMILK,
	:WildItemRare => :MOOMOOMILK,
	:kind => "Milk Cow",
	:dexentry => "It gives over five gallons of milk daily. Its milk is enjoyed by children and grown-ups alike. People who can't drink milk turn it into yogurt instead.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:BLISSEY => {
	:name => "Blissey",
	:dexnum => 242,
	:Type1 => :NORMAL,
	:BaseStats => [255, 10, 10, 55, 75, 135],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:NATURALCURE,:SERENEGRACE],
	:HiddenAbilities => :HEALER,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 608,
	:CatchRate => 30,
	:Happiness => 140,
	:EggSteps => 10455,
	:Moveset => [
		[1,:DOUBLEEDGE],
		[1,:DEFENSECURL],
		[1,:POUND],
		[1,:GROWL],
		[5,:TAILWHIP],
		[9,:REFRESH],
		[12,:DOUBLESLAP],
		[16,:SOFTBOILED],
		[20,:BESTOW],
		[23,:MINIMIZE],
		[27,:TAKEDOWN],
		[31,:SING],
		[34,:FLING],
		[39,:HEALPULSE],
		[44,:EGGBOMB],
		[50,:LIGHTSCREEN],
		[57,:HEALINGWISH],
		[65,:DOUBLEEDGE]],
	:tmlist => [:FLING,:SNATCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REST,:SKILLSWAP,:TELEKINESIS,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Pink",
	:Habitat => "Urban",
	:EggGroups => [:Fairy],
	:Height => 15,
	:Weight => 468,
	:WildItemUncommon => :LUCKYEGG,
	:kind => "Happiness",
	:dexentry => "If it senses sadness with its fluffy fur, a Blissey will rush over to the sad person to share an egg of happiness that brings a smile to any face.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:RAIKOU => {
	:name => "Raikou",
	:dexnum => 243,
	:Type1 => :ELECTRIC,
	:BaseStats => [90, 85, 75, 115, 115, 100],
	:EVs => [0, 0, 0, 2, 1, 0],
	:Abilities => [:PRESSURE,:INNERFOCUS],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:ZAPCANNON],
		[1,:WEATHERBALL],
		[1,:AURASPHERE],
		[1,:EXTREMESPEED],
		[1,:EXTRASENSORY],
		[1,:DISCHARGE],
		[1,:BITE],
		[1,:LEER],
		[8,:THUNDERSHOCK],
		[15,:ROAR],
		[22,:QUICKATTACK],
		[29,:SPARK],
		[36,:REFLECT],
		[43,:CRUNCH],
		[50,:THUNDERFANG],
		[57,:DISCHARGE],
		[64,:EXTRASENSORY],
		[71,:RAINDANCE],
		[78,:CALMMIND],
		[85,:THUNDER]],
	:tmlist => [:SIGNALBEAM,:SNARL,:QUASH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:SANDSTORM,:IRONTAIL,:IRONHEAD,:RAINDANCE,:CONFIDE,:LASERFOCUS,:THROATCHOP,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Undiscovered],
	:Height => 19,
	:Weight => 1780,
	:kind => "Thunder",
	:dexentry => "Raikou embodies the speed of lightning. Its roars send shock waves shuddering through the air and ground as if lightning bolts were crashing down.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:ENTEI => {
	:name => "Entei",
	:dexnum => 244,
	:Type1 => :FIRE,
	:BaseStats => [115, 115, 85, 100, 90, 75],
	:EVs => [1, 2, 0, 0, 0, 0],
	:Abilities => [:PRESSURE,:INNERFOCUS],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:FLAREBLITZ],
		[1,:CRUSHCLAW],
		[1,:HOWL],
		[1,:EXTREMESPEED],
		[1,:SACREDFIRE],
		[1,:ERUPTION],
		[1,:EXTRASENSORY],
		[1,:LAVAPLUME],
		[1,:BITE],
		[1,:LEER],
		[8,:EMBER],
		[15,:ROAR],
		[22,:FIRESPIN],
		[29,:STOMP],
		[36,:FLAMETHROWER],
		[43,:SWAGGER],
		[50,:FIREFANG],
		[57,:LAVAPLUME],
		[64,:EXTRASENSORY],
		[71,:FIREBLAST],
		[78,:CALMMIND],
		[85,:ERUPTION]],
	:tmlist => [:SNARL,:QUASH,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SOLARBEAM,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:CALMMIND,:REFLECT,:REST,:STONEEDGE,:SANDSTORM,:IRONTAIL,:IRONHEAD,:RAINDANCE,:CONFIDE,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Undiscovered],
	:Height => 21,
	:Weight => 1980,
	:kind => "Volcano",
	:dexentry => "Entei embodies the passion of magma. It is thought to have been born in the eruption of a volcano. It blasts fire that consumes all that it touches.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
},

:SUICUNE => {
	:name => "Suicune",
	:dexnum => 245,
	:Type1 => :WATER,
	:BaseStats => [100, 75, 115, 85, 90, 115],
	:EVs => [0, 0, 1, 0, 0, 2],
	:Abilities => [:PRESSURE,:INNERFOCUS],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:AIRSLASH],
		[1,:AQUARING],
		[1,:EXTREMESPEED],
		[1,:BITE],
		[1,:LEER],
		[1,:BUBBLEBEAM],
		[1,:RAINDANCE],
		[8,:BUBBLEBEAM],
		[15,:RAINDANCE],
		[22,:GUST],
		[29,:AURORABEAM],
		[36,:MIST],
		[43,:MIRRORCOAT],
		[50,:ICEFANG],
		[57,:TAILWIND],
		[64,:EXTRASENSORY],
		[71,:HYDROPUMP],
		[78,:CALMMIND],
		[85,:BLIZZARD]],
	:tmlist => [:SIGNALBEAM,:SNARL,:QUASH,:ROCKSMASH,:SUNNYDAY,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:CALMMIND,:REFLECT,:REST,:SANDSTORM,:IRONTAIL,:IRONHEAD,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Undiscovered],
	:Height => 20,
	:Weight => 1870,
	:kind => "Aurora",
	:dexentry => "Suicune embodies the compassion of a pure spring of water. It runs across the land with gliding elegance. It has the power to purify dirty water.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:LARVITAR => {
	:name => "Larvitar",
	:dexnum => 246,
	:Type1 => :ROCK,
	:Type2 => :GROUND,
	:BaseStats => [50, 64, 50, 41, 45, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:GUTS,:SANDVEIL],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:EggMoves => [:ANCIENTPOWER,:ASSURANCE,:CURSE,:DRAGONDANCE,:FOCUSENERGY,:IRONDEFENSE,:IRONHEAD,:IRONTAIL,:OUTRAGE,:PURSUIT,:STEALTHROCK,:STOMP],
	:Moveset => [
		[1,:BITE],
		[1,:LEER],
		[5,:SANDSTORM],
		[10,:SCREECH],
		[14,:CHIPAWAY],
		[19,:ROCKSLIDE],
		[23,:SCARYFACE],
		[28,:THRASH],
		[32,:DARKPULSE],
		[37,:PAYBACK],
		[41,:CRUNCH],
		[46,:EARTHQUAKE],
		[50,:STONEEDGE],
		[55,:HYPERBEAM]],
	:tmlist => [:DARKPULSE,:SNARL,:PAYBACK,:TAUNT,:TORMENT,:OUTRAGE,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:HYPERBEAM,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Green",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 6,
	:Weight => 720,
	:kind => "Rock Skin",
	:dexentry => "A Larvitar is born deep under the ground. It must eat its way through the soil above and reach the surface for it to see its parents' faces.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PUPITAR,:Level,30]
	]
},

:PUPITAR => {
	:name => "Pupitar",
	:dexnum => 247,
	:Type1 => :ROCK,
	:Type2 => :GROUND,
	:BaseStats => [70, 84, 70, 51, 65, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SHEDSKIN],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[1,:BITE],
		[1,:LEER],
		[1,:SANDSTORM],
		[1,:SCREECH],
		[5,:SANDSTORM],
		[10,:SCREECH],
		[14,:CHIPAWAY],
		[19,:ROCKSLIDE],
		[23,:SCARYFACE],
		[28,:THRASH],
		[34,:DARKPULSE],
		[41,:PAYBACK],
		[47,:CRUNCH],
		[54,:EARTHQUAKE],
		[60,:STONEEDGE],
		[67,:HYPERBEAM]],
	:tmlist => [:DARKPULSE,:SNARL,:PAYBACK,:TAUNT,:TORMENT,:OUTRAGE,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:HYPERBEAM,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Gray",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 12,
	:Weight => 1520,
	:kind => "Hard Shell",
	:dexentry => "A Pupitar creates a gas inside its body that it ejects under compression to propel itself. Its body can withstand a collision with solid steel.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 8,
	:evolutions => [
		[:TYRANITAR,:Level,55]
	]
},

:TYRANITAR => {
	:name => "Tyranitar",
	:dexnum => 248,
	:Type1 => :ROCK,
	:Type2 => :DARK,
	:BaseStats => [100, 134, 110, 61, 95, 100],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:SANDSTREAM,:UNNERVE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 270,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[1,:THUNDERFANG],
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:BITE],
		[1,:LEER],
		[1,:SANDSTORM],
		[1,:SCREECH],
		[5,:SANDSTORM],
		[10,:SCREECH],
		[14,:CHIPAWAY],
		[19,:ROCKSLIDE],
		[23,:SCARYFACE],
		[28,:THRASH],
		[34,:DARKPULSE],
		[41,:PAYBACK],
		[47,:CRUNCH],
		[54,:EARTHQUAKE],
		[63,:STONEEDGE],
		[73,:HYPERBEAM],
		[82,:GIGAIMPACT]],
	:tmlist => [:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:FLING,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Green",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 20,
	:Weight => 2020,
	:kind => "Armor",
	:dexentry => "A Tyranitar is so overwhelmingly strong, it can bring down a whole mountain to make its nest. It roams in mountains seeking new opponents to fight.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
},

:LUGIA => {
	:name => "Lugia",
	:dexnum => 249,
	:Type1 => :PSYCHIC,
	:Type2 => :FLYING,
	:BaseStats => [106, 90, 130, 110, 90, 154],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:PRESSURE,:MULTISCALE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 306,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:WHIRLWIND],
		[1,:WEATHERBALL],
		[9,:GUST],
		[15,:DRAGONRUSH],
		[23,:EXTRASENSORY],
		[29,:RAINDANCE],
		[37,:HYDROPUMP],
		[43,:AEROBLAST],
		[50,:PUNISHMENT],
		[57,:ANCIENTPOWER],
		[65,:SAFEGUARD],
		[71,:RECOVER],
		[79,:FUTURESIGHT],
		[85,:NATURALGIFT],
		[93,:CALMMIND],
		[99,:SKYATTACK]],
	:tmlist => [:SIGNALBEAM,:DRAGONPULSE,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:GIGADRAIN,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:WONDERROOM,:ANCIENTPOWER,:SANDSTORM,:IRONTAIL,:IRONHEAD,:STEELWING,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:LASERFOCUS,],
	:Color => "White",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 52,
	:Weight => 2160,
	:kind => "Diving",
	:dexentry => "Lugia is so powerful that even a light fluttering of its wings can blow apart houses. As a result, it chooses to live out of sight deep under the sea.",
	:BattlerPlayerY => 7,
	:BattlerEnemyY => 5,
	:BattlerAltitude => 6,
},

:HOOH => {
	:name => "Ho-Oh",
	:dexnum => 250,
	:Type1 => :FIRE,
	:Type2 => :FLYING,
	:BaseStats => [106, 130, 90, 90, 110, 154],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:PRESSURE,:REGENERATOR],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 306,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:WHIRLWIND],
		[1,:WEATHERBALL],
		[9,:GUST],
		[15,:BRAVEBIRD],
		[23,:EXTRASENSORY],
		[29,:SUNNYDAY],
		[37,:FIREBLAST],
		[43,:SACREDFIRE],
		[50,:PUNISHMENT],
		[57,:ANCIENTPOWER],
		[65,:SAFEGUARD],
		[71,:RECOVER],
		[79,:FUTURESIGHT],
		[85,:NATURALGIFT],
		[93,:CALMMIND],
		[99,:SKYATTACK]],
	:tmlist => [:SIGNALBEAM,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:ANCIENTPOWER,:SANDSTORM,:IRONHEAD,:STEELWING,:RAINDANCE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Red",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 38,
	:Weight => 1990,
	:WildItemCommon => :SACREDASH,
	:WildItemUncommon => :SACREDASH,
	:WildItemRare => :SACREDASH,
	:kind => "Rainbow",
	:dexentry => "Its feathers-- which glow in seven colors depending on the angle at which they are struck by light-- are thought to bring joy.",
	:BattlerPlayerY => 6,
	:BattlerEnemyY => 2,
	:BattlerAltitude => 8,
},

:CELEBI => {
	:name => "Celebi",
	:dexnum => 251,
	:Type1 => :PSYCHIC,
	:Type2 => :GRASS,
	:BaseStats => [100, 100, 100, 100, 100, 100],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:NATURALCURE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "Genderless",
	:BaseEXP => 270,
	:CatchRate => 45,
	:Happiness => 100,
	:EggSteps => 30855,
	:Moveset => [
		[1,:LEECHSEED],
		[1,:CONFUSION],
		[1,:RECOVER],
		[1,:HEALBELL],
		[10,:SAFEGUARD],
		[19,:MAGICALLEAF],
		[28,:ANCIENTPOWER],
		[37,:BATONPASS],
		[46,:NATURALGIFT],
		[55,:HEALBLOCK],
		[64,:FUTURESIGHT],
		[73,:HEALINGWISH],
		[82,:LEAFSTORM],
		[91,:PERISHSONG]],
	:tmlist => [:SIGNALBEAM,:UTURN,:FLING,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHPOWER,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:NATUREPOWER,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ANCIENTPOWER,:SANDSTORM,:STEALTHROCK,:WATERPULSE,:RAINDANCE,:LASERFOCUS,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Undiscovered],
	:Height => 6,
	:Weight => 50,
	:WildItemCommon => :LUMBERRY,
	:WildItemUncommon => :LUMBERRY,
	:WildItemRare => :LUMBERRY,
	:kind => "Time Travel",
	:dexentry => "This Pokémon came from the future by crossing over time. It is thought that so long as Celebi appears, a bright and shining future awaits us.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 13,
},

:TREECKO => {
	:name => "Treecko",
	:dexnum => 252,
	:Type1 => :GRASS,
	:BaseStats => [40, 45, 35, 70, 65, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:OVERGROW,:UNBURDEN],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 62,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BULLETSEED,:CRUNCH,:CRUSHCLAW,:DOUBLEKICK,:DRAGONBREATH,:ENDEAVOR,:GRASSWHISTLE,:GRASSYTERRAIN,:LEAFSTORM,:LEECHSEED,:MAGICALLEAF,:MUDSPORT,:NATURALGIFT,:RAZORWIND,:SYNTHESIS,:WORRYSEED],
	:Moveset => [
		[1,:POUND],
		[1,:LEER],
		[5,:ABSORB],
		[9,:QUICKATTACK],
		[13,:MEGADRAIN],
		[17,:PURSUIT],
		[21,:GIGADRAIN],
		[25,:AGILITY],
		[29,:SLAM],
		[33,:DETECT],
		[37,:ENERGYBALL],
		[41,:QUICKGUARD],
		[45,:ENDEAVOR],
		[49,:SCREECH]],
	:tmlist => [:FURYCUTTER,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:AERIALACE,:ACROBATICS,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Monster,:Dragon],
	:Height => 5,
	:Weight => 50,
	:kind => "Wood Gecko",
	:dexentry => "It makes its nest in trees in the forest. It ferociously guards against anything near its territory. It is said to be the protector of the forest's trees.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GROVYLE,:Level,16]
	]
},

:GROVYLE => {
	:name => "Grovyle",
	:dexnum => 253,
	:Type1 => :GRASS,
	:BaseStats => [50, 65, 45, 95, 85, 65],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:OVERGROW,:UNBURDEN],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:FURYCUTTER],
		[1,:POUND],
		[1,:LEER],
		[1,:ABSORB],
		[1,:QUICKATTACK],
		[5,:ABSORB],
		[9,:QUICKATTACK],
		[13,:MEGADRAIN],
		[18,:PURSUIT],
		[23,:LEAFBLADE],
		[28,:AGILITY],
		[33,:SLAM],
		[38,:DETECT],
		[43,:XSCISSOR],
		[48,:FALSESWIPE],
		[53,:QUICKGUARD],
		[58,:LEAFSTORM],
		[63,:SCREECH]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:AERIALACE,:ACROBATICS,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Monster,:Dragon],
	:Height => 9,
	:Weight => 216,
	:kind => "Wood Gecko",
	:dexentry => "Leaves grow out of this Pokémon's body. They help obscure a Grovyle from the eyes of its enemies while it is in a thickly overgrown forest.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SCEPTILE,:Level,36]
	]
},

:SCEPTILE => {
	:name => "Sceptile",
	:dexnum => 254,
	:Type1 => :GRASS,
	:BaseStats => [70, 85, 65, 120, 105, 85],
	:EVs => [0, 0, 0, 3, 0, 0],
	:Abilities => [:OVERGROW,:UNBURDEN],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 239,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:DUALCHOP],
		[1,:FURYCUTTER],
		[1,:LEAFSTORM],
		[1,:NIGHTSLASH],
		[1,:POUND],
		[1,:LEER],
		[1,:ABSORB],
		[1,:QUICKATTACK],
		[5,:ABSORB],
		[9,:QUICKATTACK],
		[13,:MEGADRAIN],
		[18,:PURSUIT],
		[23,:LEAFBLADE],
		[28,:AGILITY],
		[33,:SLAM],
		[39,:DETECT],
		[45,:XSCISSOR],
		[51,:FALSESWIPE],
		[57,:QUICKGUARD],
		[63,:LEAFSTORM],
		[69,:SCREECH]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:FLING,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:AERIALACE,:ACROBATICS,:FRENZYPLANT,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:BRUTALSWING,:LASERFOCUS,:THROATCHOP,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Monster,:Dragon],
	:Height => 17,
	:Weight => 522,
	:kind => "Forest",
	:dexentry => "In the jungle, its power is without equal. This Pokémon carefully grows trees and plants. It regulates its body temperature by basking in sunlight.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:TORCHIC => {
	:name => "Torchic",
	:dexnum => 255,
	:Type1 => :FIRE,
	:BaseStats => [45, 60, 40, 45, 70, 50],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:BLAZE,:SPEEDBOOST],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 62,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:BATONPASS,:COUNTER,:CRUSHCLAW,:CURSE,:ENDURE,:FEATHERDANCE,:FEINT,:FLAMEBURST,:LASTRESORT,:LOWKICK,:NIGHTSLASH,:REVERSAL,:SMELLINGSALTS],
	:Moveset => [
		[1,:SCRATCH],
		[1,:GROWL],
		[5,:EMBER],
		[10,:SANDATTACK],
		[14,:PECK],
		[19,:FIRESPIN],
		[23,:QUICKATTACK],
		[28,:FLAMEBURST],
		[32,:FOCUSENERGY],
		[37,:SLASH],
		[41,:MIRRORMOVE],
		[46,:FLAMETHROWER]],
	:tmlist => [:ROCKSMASH,:LOWKICK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:BOUNCE,:AERIALACE,:DEFOG,:SHADOWCLAW,:MUDSLAP,:LASTRESORT,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:CONFIDE,],
	:Color => "Red",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 25,
	:kind => "Chick",
	:dexentry => "If attacked, it strikes back by spitting balls of fire it forms in its stomach. A Torchic dislikes darkness because it can't see its surroundings.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:COMBUSKEN,:Level,16]
	]
},

:COMBUSKEN => {
	:name => "Combusken",
	:dexnum => 256,
	:Type1 => :FIRE,
	:Type2 => :FIGHTING,
	:BaseStats => [60, 85, 60, 55, 85, 60],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:BLAZE,:SPEEDBOOST],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:DOUBLEKICK],
		[1,:SCRATCH],
		[1,:GROWL],
		[1,:EMBER],
		[1,:SANDATTACK],
		[5,:EMBER],
		[10,:SANDATTACK],
		[14,:PECK],
		[20,:FLAMECHARGE],
		[25,:QUICKATTACK],
		[31,:BULKUP],
		[36,:FOCUSENERGY],
		[42,:SLASH],
		[47,:MIRRORMOVE],
		[53,:SKYUPPERCUT],
		[58,:FLAREBLITZ]],
	:tmlist => [:FURYCUTTER,:FLING,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:BOUNCE,:AERIALACE,:DEFOG,:SHADOWCLAW,:MUDSLAP,:LASTRESORT,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Red",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 9,
	:Weight => 195,
	:kind => "Young Fowl",
	:dexentry => "It lashes out with 10 kicks per second. Its strong fighting instinct compels it to keep up its offensive until the opponent gives up.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BLAZIKEN,:Level,36]
	]
},

:BLAZIKEN => {
	:name => "Blaziken",
	:dexnum => 257,
	:Type1 => :FIRE,
	:Type2 => :FIGHTING,
	:BaseStats => [80, 120, 70, 80, 110, 70],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:BLAZE,:SPEEDBOOST],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 239,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:BLAZEKICK],
		[1,:DOUBLEKICK],
		[1,:FLAREBLITZ],
		[1,:FIREPUNCH],
		[1,:HIJUMPKICK],
		[1,:SCRATCH],
		[1,:GROWL],
		[1,:EMBER],
		[1,:SANDATTACK],
		[5,:EMBER],
		[10,:SANDATTACK],
		[14,:PECK],
		[20,:FLAMECHARGE],
		[25,:QUICKATTACK],
		[31,:BULKUP],
		[37,:FOCUSENERGY],
		[44,:SLASH],
		[50,:BRAVEBIRD],
		[57,:SKYUPPERCUT],
		[63,:FLAREBLITZ]],
	:tmlist => [:FURYCUTTER,:KNOCKOFF,:FLING,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:BLASTBURN,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:BOUNCE,:AERIALACE,:ACROBATICS,:DEFOG,:SHADOWCLAW,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Red",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 19,
	:Weight => 520,
	:kind => "Blaze",
	:dexentry => "It learns martial arts that use punches and kicks. Every several years, its old feathers burn off, and new, supple feathers grow back in their place.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
},

:MUDKIP => {
	:name => "Mudkip",
	:dexnum => 258,
	:Type1 => :WATER,
	:BaseStats => [50, 70, 50, 40, 50, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:TORRENT,:DAMP],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 62,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:AVALANCHE,:BARRIER,:BITE,:COUNTER,:CURSE,:DOUBLEEDGE,:ICEBALL,:MIRRORCOAT,:MUDBOMB,:REFRESH,:SLUDGE,:STOMP,:UPROAR,:WHIRLPOOL,:WIDEGUARD,:YAWN],
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[4,:WATERGUN],
		[9,:MUDSLAP],
		[12,:FORESIGHT],
		[17,:BIDE],
		[20,:MUDSPORT],
		[25,:ROCKTHROW],
		[28,:PROTECT],
		[33,:WHIRLPOOL],
		[36,:TAKEDOWN],
		[41,:HYDROPUMP],
		[44,:ENDEAVOR]],
	:tmlist => [:SUPERPOWER,:ROCKSMASH,:LOWKICK,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:SLUDGEWAVE,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 4,
	:Weight => 76,
	:kind => "Mud Fish",
	:dexentry => "On land, it can powerfully lift large boulders by planting its four feet and heaving. It sleeps by burying itself in soil at the water's edge.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MARSHTOMP,:Level,16]
	]
},

:MARSHTOMP => {
	:name => "Marshtomp",
	:dexnum => 259,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [70, 85, 70, 50, 60, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:TORRENT,:DAMP],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:MUDSHOT],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:WATERGUN],
		[1,:MUDSLAP],
		[4,:WATERGUN],
		[9,:MUDSLAP],
		[12,:FORESIGHT],
		[18,:BIDE],
		[22,:MUDBOMB],
		[28,:ROCKSLIDE],
		[32,:PROTECT],
		[38,:MUDDYWATER],
		[42,:TAKEDOWN],
		[48,:EARTHQUAKE],
		[52,:ENDEAVOR]],
	:tmlist => [:FLING,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:SLUDGEWAVE,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:POWERUPPUNCH,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 7,
	:Weight => 280,
	:kind => "Mud Fish",
	:dexentry => "Its toughened hind legs enable it to stand upright. Because it weakens if its skin dries out, it replenishes fluids by playing in mud.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SWAMPERT,:Level,36]
	]
},

:SWAMPERT => {
	:name => "Swampert",
	:dexnum => 260,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [100, 110, 90, 60, 85, 90],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:TORRENT,:DAMP],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 241,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:MUDSHOT],
		[1,:HAMMERARM],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:WATERGUN],
		[1,:MUDSLAP],
		[4,:WATERGUN],
		[9,:MUDSLAP],
		[12,:FORESIGHT],
		[18,:BIDE],
		[22,:MUDBOMB],
		[28,:ROCKSLIDE],
		[32,:PROTECT],
		[39,:MUDDYWATER],
		[44,:TAKEDOWN],
		[51,:EARTHQUAKE],
		[56,:ENDEAVOR],
		[63,:HAMMERARM]],
	:tmlist => [:FLING,:OUTRAGE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:SLUDGEWAVE,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:HYDROCANNON,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Monster,:Water1],
	:Height => 15,
	:Weight => 819,
	:kind => "Mud Fish",
	:dexentry => "If it senses the approach of a storm and a tidal wave, it protects its seaside nest by piling up boulders. It swims as fast as a jet ski.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:POOCHYENA => {
	:name => "Poochyena",
	:dexnum => 261,
	:Type1 => :DARK,
	:BaseStats => [35, 55, 35, 35, 30, 30],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:RUNAWAY,:QUICKFEET],
	:HiddenAbilities => :RATTLED,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 44,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:ASTONISH,:COVET,:FIREFANG,:ICEFANG,:LEER,:MEFIRST,:PLAYROUGH,:POISONFANG,:SLEEPTALK,:SNATCH,:SUCKERPUNCH,:THUNDERFANG,:YAWN],
	:Moveset => [
		[1,:TACKLE],
		[4,:HOWL],
		[7,:SANDATTACK],
		[10,:BITE],
		[13,:ODORSLEUTH],
		[16,:ROAR],
		[19,:SWAGGER],
		[22,:ASSURANCE],
		[25,:SCARYFACE],
		[28,:EMBARGO],
		[31,:TAUNT],
		[34,:CRUNCH],
		[37,:YAWN],
		[40,:TAKEDOWN],
		[43,:SUCKERPUNCH],
		[46,:PLAYROUGH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:SPITE,:MUDSLAP,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 136,
	:kind => "Bite",
	:dexentry => "It savagely threatens foes with bared fangs. It chases after fleeing targets tenaciously. It turns tail and runs, however, if the foe strikes back.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MIGHTYENA,:Level,18]
	]
},

:MIGHTYENA => {
	:name => "Mightyena",
	:dexnum => 262,
	:Type1 => :DARK,
	:BaseStats => [70, 90, 70, 70, 60, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:QUICKFEET],
	:HiddenAbilities => :MOXIE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 147,
	:CatchRate => 127,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:SNARL],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:ICEFANG],
		[1,:CRUNCH],
		[1,:THIEF],
		[1,:TACKLE],
		[1,:HOWL],
		[1,:SANDATTACK],
		[1,:BITE],
		[4,:HOWL],
		[7,:SANDATTACK],
		[10,:BITE],
		[13,:ODORSLEUTH],
		[16,:ROAR],
		[20,:SWAGGER],
		[24,:ASSURANCE],
		[28,:SCARYFACE],
		[32,:EMBARGO],
		[36,:TAUNT],
		[40,:CRUNCH],
		[44,:YAWN],
		[48,:TAKEDOWN],
		[52,:SUCKERPUNCH],
		[56,:PLAYROUGH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:SPITE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:THROATCHOP,],
	:Color => "Gray",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 370,
	:kind => "Bite",
	:dexentry => "In the wild, Mightyena live in a pack. They never defy their leader's orders. They defeat foes with perfectly coordinated teamwork.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:ZIGZAGOON => {
	:name => "Zigzagoon",
	:dexnum => 263,
	:Type1 => :NORMAL,
	:BaseStats => [38, 30, 41, 60, 30, 41],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:PICKUP,:GLUTTONY],
	:HiddenAbilities => :QUICKFEET,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 48,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:CHARM,:EXTREMESPEED,:HELPINGHAND,:MUDSLAP,:PURSUIT,:ROCKCLIMB,:SIMPLEBEAM,:SLEEPTALK,:TICKLE,:TRICK],
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[5,:TAILWHIP],
		[7,:SANDATTACK],
		[11,:HEADBUTT],
		[12,:BABYDOLLEYES],
		[13,:ODORSLEUTH],
		[17,:MUDSPORT],
		[19,:PINMISSILE],
		[23,:COVET],
		[25,:BESTOW],
		[29,:FLAIL],
		[31,:TAKEDOWN],
		[35,:REST],
		[37,:BELLYDRUM],
		[41,:FLING]],
	:tmlist => [:FURYCUTTER,:THIEF,:FLING,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:SEEDBOMB,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:REST,:TRICK,:ROLLOUT,:IRONTAIL,:SURF,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 175,
	:WildItemCommon => :POTION,
	:WildItemUncommon => :REVIVE,
	:kind => "TinyRaccoon",
	:dexentry => "Rubbing its nose against the ground, it always wanders about back and forth in search of something. It is distinguished by the zigzag footprints it leaves.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LINOONE,:Level,20]
	]
},

:LINOONE => {
	:name => "Linoone",
	:dexnum => 264,
	:Type1 => :NORMAL,
	:BaseStats => [78, 70, 61, 100, 50, 61],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:PICKUP,:GLUTTONY],
	:HiddenAbilities => :QUICKFEET,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 147,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:PLAYROUGH],
		[1,:ROTOTILLER],
		[1,:SWITCHEROO],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:TAILWHIP],
		[1,:SANDATTACK],
		[5,:TAILWHIP],
		[7,:SANDATTACK],
		[11,:HEADBUTT],
		[13,:ODORSLEUTH],
		[17,:MUDSPORT],
		[19,:FURYSWIPES],
		[24,:COVET],
		[27,:BESTOW],
		[32,:SLASH],
		[35,:DOUBLEEDGE],
		[40,:REST],
		[43,:BELLYDRUM],
		[48,:FLING]],
	:tmlist => [:FURYCUTTER,:THIEF,:FLING,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:SHADOWCLAW,:SEEDBOMB,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:REST,:TRICK,:ROLLOUT,:IRONTAIL,:SURF,:WATERPULSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "White",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 325,
	:WildItemCommon => :POTION,
	:WildItemUncommon => :MAXREVIVE,
	:kind => "Rushing",
	:dexentry => "It is exceedingly fast if it only has to run in a straight line. When it spots prey underwater, it leaps in and catches it with its sharp claws.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
},

:WURMPLE => {
	:name => "Wurmple",
	:dexnum => 265,
	:Type1 => :BUG,
	:BaseStats => [45, 45, 35, 20, 20, 30],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:SHIELDDUST,:RUNAWAY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 39,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:TACKLE],
		[1,:STRINGSHOT],
		[5,:POISONSTING],
		[15,:BUGBITE]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:SNORE,],
	:Color => "Red",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 3,
	:Weight => 36,
	:WildItemCommon => :PECHABERRY,
	:WildItemUncommon => :BRIGHTPOWDER,
	:kind => "Worm",
	:dexentry => "It sticks to tree branches and eats leaves. The thread it spits from its mouth slows the movement of its foes.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SILCOON,:Silcoon,7],
		[:CASCOON,:Cascoon,7]
	]
},

:SILCOON => {
	:name => "Silcoon",
	:dexnum => 266,
	:Type1 => :BUG,
	:BaseStats => [50, 35, 55, 15, 25, 25],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SHEDSKIN],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 72,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:HARDEN]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:IRONDEFENSE,],
	:Color => "White",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 6,
	:Weight => 100,
	:kind => "Cocoon",
	:dexentry => "It prepares for evolution using the energy it stored while it was a Wurmple. It keeps watch over the surroundings with its two eyes.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BEAUTIFLY,:Level,10]
	]
},

:BEAUTIFLY => {
	:name => "Beautifly",
	:dexnum => 267,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [60, 70, 50, 65, 100, 50],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:SWARM,:RIVALRY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:GUST],
		[12,:ABSORB],
		[15,:STUNSPORE],
		[17,:MORNINGSUN],
		[20,:AIRCUTTER],
		[22,:MEGADRAIN],
		[25,:SILVERWIND],
		[27,:ATTRACT],
		[30,:WHIRLWIND],
		[32,:GIGADRAIN],
		[35,:BUGBUZZ],
		[37,:RAGE],
		[40,:QUIVERDANCE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:TWISTER,:ELECTROWEB,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:VENOSHOCK,:TOXIC,:PSYCHIC,:REST,:CONFIDE,:INFESTATION,:LASERFOCUS,],
	:Color => "Yellow",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 10,
	:Weight => 284,
	:WildItemUncommon => :SHEDSHELL,
	:kind => "Butterfly",
	:dexentry => "Its colorfully patterned wings are its most striking feature. It flies through flower-covered fields collecting pollen. It attacks ferociously when angered.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 17,
},

:CASCOON => {
	:name => "Cascoon",
	:dexnum => 268,
	:Type1 => :BUG,
	:BaseStats => [50, 35, 55, 15, 25, 25],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SHEDSKIN],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 41,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:HARDEN]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:IRONDEFENSE,],
	:Color => "Purple",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 7,
	:Weight => 115,
	:kind => "Cocoon",
	:dexentry => "To avoid detection by its enemies, it hides beneath large leaves and in the gaps of branches. It also attaches dead leaves to its body for camouflage.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DUSTOX,:Level,10]
	]
},

:DUSTOX => {
	:name => "Dustox",
	:dexnum => 269,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [60, 50, 70, 65, 50, 90],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:SHIELDDUST,:COMPOUNDEYES],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 135,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:GUST],
		[12,:CONFUSION],
		[15,:POISONPOWDER],
		[17,:MOONLIGHT],
		[20,:VENOSHOCK],
		[22,:PSYBEAM],
		[25,:SILVERWIND],
		[27,:LIGHTSCREEN],
		[30,:WHIRLWIND],
		[32,:TOXIC],
		[35,:BUGBUZZ],
		[37,:PROTECT],
		[40,:QUIVERDANCE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:TWISTER,:ELECTROWEB,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:PSYCHIC,:LIGHTSCREEN,:REST,:CONFIDE,:INFESTATION,:LASERFOCUS,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 12,
	:Weight => 316,
	:WildItemUncommon => :SHEDSHELL,
	:kind => "Poison Moth",
	:dexentry => "It is a nocturnal Pokémon that flies from fields and mountains to the attraction of streetlights at night. It looses highly toxic powder from its wings.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 15,
},

:LOTAD => {
	:name => "Lotad",
	:dexnum => 270,
	:Type1 => :WATER,
	:Type2 => :GRASS,
	:BaseStats => [40, 30, 30, 30, 40, 50],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:SWIFTSWIM,:RAINDISH],
	:HiddenAbilities => :OWNTEMPO,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 44,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:COUNTER,:FLAIL,:GIGADRAIN,:LEECHSEED,:RAZORLEAF,:SWEETSCENT,:SYNTHESIS,:TEETERDANCE,:TICKLE,:WATERGUN],
	:Moveset => [
		[1,:ASTONISH],
		[3,:GROWL],
		[6,:ABSORB],
		[9,:BUBBLE],
		[12,:NATURALGIFT],
		[15,:MIST],
		[18,:MEGADRAIN],
		[21,:BUBBLEBEAM],
		[24,:NATUREPOWER],
		[27,:RAINDANCE],
		[30,:GIGADRAIN],
		[33,:ZENHEADBUTT],
		[36,:ENERGYBALL]],
	:tmlist => [:THIEF,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:ZENHEADBUTT,:REST,:SURF,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Green",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Grass],
	:Height => 5,
	:Weight => 26,
	:WildItemUncommon => :MENTALHERB,
	:kind => "Water Weed",
	:dexentry => "This Pokémon lives in ponds with clean water. It is known to ferry small Pokémon across ponds by carrying them on the broad leaf on its head.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LOMBRE,:Level,14]
	]
},

:LOMBRE => {
	:name => "Lombre",
	:dexnum => 271,
	:Type1 => :WATER,
	:Type2 => :GRASS,
	:BaseStats => [60, 50, 50, 50, 60, 70],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:SWIFTSWIM,:RAINDISH],
	:HiddenAbilities => :OWNTEMPO,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 119,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:ASTONISH],
		[3,:GROWL],
		[6,:ABSORB],
		[9,:BUBBLE],
		[12,:FURYSWIPES],
		[16,:FAKEOUT],
		[20,:WATERSPORT],
		[24,:BUBBLEBEAM],
		[28,:NATUREPOWER],
		[32,:UPROAR],
		[36,:KNOCKOFF],
		[40,:ZENHEADBUTT],
		[44,:HYDROPUMP]],
	:tmlist => [:THIEF,:FLING,:THUNDERPUNCH,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:ZENHEADBUTT,:REST,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Green",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Grass],
	:Height => 12,
	:Weight => 325,
	:WildItemUncommon => :MENTALHERB,
	:kind => "Jolly",
	:dexentry => "In the evening, it takes great delight in popping out of rivers and startling people. It feeds on aquatic moss that grows on rocks in the riverbed.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LUDICOLO,:Item,:WATERSTONE]
	]
},

:LUDICOLO => {
	:name => "Ludicolo",
	:dexnum => 272,
	:Type1 => :WATER,
	:Type2 => :GRASS,
	:BaseStats => [80, 70, 70, 70, 90, 100],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:SWIFTSWIM,:RAINDISH],
	:HiddenAbilities => :OWNTEMPO,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 216,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:ASTONISH],
		[1,:GROWL],
		[1,:MEGADRAIN],
		[1,:NATUREPOWER]],
	:tmlist => [:THIEF,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:ZENHEADBUTT,:REST,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Green",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Grass],
	:Height => 15,
	:Weight => 550,
	:WildItemUncommon => :MENTALHERB,
	:kind => "Carefree",
	:dexentry => "When it hears festive music, all its cells become stimulated, and it begins moving in rhythm. It does not quail even when it faces a tough opponent.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:SEEDOT => {
	:name => "Seedot",
	:dexnum => 273,
	:Type1 => :GRASS,
	:BaseStats => [40, 40, 50, 30, 30, 30],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:EARLYBIRD],
	:HiddenAbilities => :PICKPOCKET,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 44,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:AMNESIA,:BEATUP,:BULLETSEED,:DEFOG,:FOULPLAY,:GRASSYTERRAIN,:LEECHSEED,:NASTYPLOT,:POWERSWAP,:QUICKATTACK,:RAZORWIND,:TAKEDOWN,:WORRYSEED],
	:Moveset => [
		[1,:BIDE],
		[3,:HARDEN],
		[9,:GROWTH],
		[15,:NATUREPOWER],
		[21,:SYNTHESIS],
		[27,:SUNNYDAY],
		[33,:EXPLOSION]],
	:tmlist => [:FOULPLAY,:ROCKSMASH,:SUNNYDAY,:DEFOG,:SHADOWBALL,:SPITE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:EXPLOSION,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:ROLLOUT,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Field,:Grass],
	:Height => 5,
	:Weight => 40,
	:WildItemUncommon => :POWERHERB,
	:kind => "Acorn",
	:dexentry => "It hangs off branches and absorbs nutrients. When it finishes eating, its body becomes so heavy that it drops to the ground with a thump.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:NUZLEAF,:Level,14]
	]
},

:NUZLEAF => {
	:name => "Nuzleaf",
	:dexnum => 274,
	:Type1 => :GRASS,
	:Type2 => :DARK,
	:BaseStats => [70, 70, 40, 60, 60, 40],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:EARLYBIRD],
	:HiddenAbilities => :PICKPOCKET,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 119,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:RAZORLEAF],
		[1,:POUND],
		[3,:HARDEN],
		[6,:GROWTH],
		[12,:FAKEOUT],
		[16,:NATUREPOWER],
		[20,:RAZORWIND],
		[24,:FEINTATTACK],
		[28,:LEAFBLADE],
		[32,:SWAGGER],
		[36,:EXTRASENSORY]],
	:tmlist => [:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:FLING,:EMBARGO,:TORMENT,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:DEFOG,:SHADOWBALL,:SPITE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:EXPLOSION,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Field,:Grass],
	:Height => 10,
	:Weight => 280,
	:WildItemUncommon => :POWERHERB,
	:kind => "Wily",
	:dexentry => "A forest-dwelling Pokémon that is skilled at climbing trees. Its long and pointed nose is its weak point. It loses power if the nose is gripped.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SHIFTRY,:Item,:LEAFSTONE]
	]
},

:SHIFTRY => {
	:name => "Shiftry",
	:dexnum => 275,
	:Type1 => :GRASS,
	:Type2 => :DARK,
	:BaseStats => [90, 100, 60, 80, 90, 60],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:EARLYBIRD],
	:HiddenAbilities => :PICKPOCKET,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 216,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:RAZORLEAF],
		[1,:FEINTATTACK],
		[1,:WHIRLWIND],
		[1,:NASTYPLOT],
		[20,:LEAFTORNADO],
		[32,:HURRICANE],
		[44,:LEAFSTORM]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:TORMENT,:TWISTER,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:BOUNCE,:AERIALACE,:AIRCUTTER,:DEFOG,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SPITE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:ICYWIND,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Field,:Grass],
	:Height => 13,
	:Weight => 596,
	:WildItemUncommon => :POWERHERB,
	:kind => "Wicked",
	:dexentry => "It is said to arrive on chilly, wintry winds. Feared from long ago as the guardian of forests, this Pokémon lives in a deep forest without people.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:TAILLOW => {
	:name => "Taillow",
	:dexnum => 276,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [40, 55, 30, 85, 30, 30],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:GUTS,:SCRAPPY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 54,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BOOMBURST,:BRAVEBIRD,:DEFOG,:HURRICANE,:MIRRORMOVE,:PURSUIT,:RAGE,:REFRESH,:ROOST,:SKYATTACK,:STEELWING,:SUPERSONIC,:WHIRLWIND],
	:Moveset => [
		[1,:PECK],
		[1,:GROWL],
		[5,:FOCUSENERGY],
		[9,:QUICKATTACK],
		[13,:WINGATTACK],
		[17,:DOUBLETEAM],
		[21,:AERIALACE],
		[25,:QUICKGUARD],
		[29,:AGILITY],
		[33,:AIRSLASH],
		[37,:ENDEAVOR],
		[41,:BRAVEBIRD],
		[45,:REVERSAL]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Flying],
	:Height => 3,
	:Weight => 23,
	:kind => "TinySwallow",
	:dexentry => "Although it is small, it is very courageous. It will take on a larger Skarmory on an equal footing. However, its will weakens if it becomes hungry.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 20,
	:evolutions => [
		[:SWELLOW,:Level,22]
	]
},

:SWELLOW => {
	:name => "Swellow",
	:dexnum => 277,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [60, 85, 60, 125, 75, 50],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:GUTS,:SCRAPPY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 151,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:BRAVEBIRD],
		[1,:AIRSLASH],
		[1,:PLUCK],
		[1,:PECK],
		[1,:GROWL],
		[1,:FOCUSENERGY],
		[1,:QUICKATTACK],
		[5,:FOCUSENERGY],
		[9,:QUICKATTACK],
		[13,:WINGATTACK],
		[17,:DOUBLETEAM],
		[21,:AERIALACE],
		[27,:QUICKGUARD],
		[33,:AGILITY],
		[39,:AIRSLASH],
		[45,:ENDEAVOR],
		[51,:BRAVEBIRD],
		[57,:REVERSAL]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Flying],
	:Height => 7,
	:Weight => 198,
	:kind => "Swallow",
	:dexentry => "A Swellow dives upon prey from far above. It never misses its targets. It takes to the skies in search of lands with a warm climate.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 10,
},

:WINGULL => {
	:name => "Wingull",
	:dexnum => 278,
	:Type1 => :WATER,
	:Type2 => :FLYING,
	:BaseStats => [40, 30, 30, 85, 55, 30],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:KEENEYE,:HYDRATION],
	:HiddenAbilities => :RAINDISH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 54,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:AQUARING,:BRINE,:GUST,:KNOCKOFF,:MIST,:ROOST,:SOAK,:TWISTER,:WATERSPORT,:WIDEGUARD],
	:Moveset => [
		[1,:GROWL],
		[1,:WATERGUN],
		[5,:SUPERSONIC],
		[8,:WINGATTACK],
		[12,:MIST],
		[15,:WATERPULSE],
		[19,:QUICKATTACK],
		[22,:AIRCUTTER],
		[26,:PURSUIT],
		[29,:AERIALACE],
		[33,:ROOST],
		[36,:AGILITY],
		[40,:AIRSLASH],
		[43,:HURRICANE]],
	:tmlist => [:UTURN,:THIEF,:KNOCKOFF,:TWISTER,:SHOCKWAVE,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STEELWING,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "White",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Flying],
	:Height => 6,
	:Weight => 95,
	:WildItemCommon => :PRETTYWING,
	:kind => "Seagull",
	:dexentry => "It makes its nest on a sheer cliff at the edge of the sea. It has trouble keeping its wings flapping in flight. Instead, it soars on updrafts.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 18,
	:evolutions => [
		[:PELIPPER,:Level,25]
	]
},

:PELIPPER => {
	:name => "Pelipper",
	:dexnum => 279,
	:Type1 => :WATER,
	:Type2 => :FLYING,
	:BaseStats => [60, 50, 100, 65, 95, 70],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:KEENEYE,:DRIZZLE],
	:HiddenAbilities => :RAINDISH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 151,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:PROTECT],
		[1,:HURRICANE],
		[1,:HYDROPUMP],
		[1,:TAILWIND],
		[1,:SOAK],
		[1,:GROWL],
		[1,:WATERGUN],
		[1,:WATERSPORT],
		[1,:WINGATTACK],
		[5,:SUPERSONIC],
		[8,:WINGATTACK],
		[12,:MIST],
		[15,:WATERPULSE],
		[19,:PAYBACK],
		[22,:BRINE],
		[28,:FLING],
		[33,:STOCKPILE],
		[33,:SWALLOW],
		[33,:SPITUP],
		[39,:ROOST],
		[44,:TAILWIND],
		[50,:HYDROPUMP],
		[55,:HURRICANE]],
	:tmlist => [:UTURN,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TWISTER,:SHOCKWAVE,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SEEDBOMB,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:REST,:STEELWING,:SURF,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Yellow",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Flying],
	:Height => 12,
	:Weight => 280,
	:WildItemCommon => :PRETTYWING,
	:kind => "Water Bird",
	:dexentry => "It skims the tops of waves as it flies. When it spots prey, it uses its large beak to scoop up the victim with water. It protects its eggs in its beak.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 13,
},

:RALTS => {
	:name => "Ralts",
	:dexnum => 280,
	:Type1 => :PSYCHIC,
	:Type2 => :FAIRY,
	:BaseStats => [28, 25, 25, 40, 45, 35],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:SYNCHRONIZE,:TRACE],
	:HiddenAbilities => :TELEPATHY,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 40,
	:CatchRate => 235,
	:Happiness => 35,
	:EggSteps => 5355,
	:EggMoves => [:ALLYSWITCH,:CONFUSERAY,:DESTINYBOND,:DISABLE,:ENCORE,:GRUDGE,:MEANLOOK,:MEMENTO,:MISTYTERRAIN,:SHADOWSNEAK,:SKILLSWAP,:SYNCHRONOISE],
	:Moveset => [
		[1,:GROWL],
		[4,:CONFUSION],
		[6,:DOUBLETEAM],
		[9,:TELEPORT],
		[11,:DISARMINGVOICE],
		[14,:LUCKYCHANT],
		[17,:MAGICALLEAF],
		[19,:HEALPULSE],
		[22,:DRAININGKISS],
		[24,:CALMMIND],
		[27,:PSYCHIC],
		[29,:IMPRISON],
		[32,:FUTURESIGHT],
		[34,:CHARM],
		[37,:HYPNOSIS],
		[39,:DREAMEATER],
		[42,:STOREDPOWER]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:ICYWIND,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "White",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 4,
	:Weight => 66,
	:kind => "Feeling",
	:dexentry => "A Ralts has the power to sense the emotions of people and Pokémon with the horns on its head. It takes cover if it senses any hostility.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:KIRLIA,:Level,20]
	]
},

:KIRLIA => {
	:name => "Kirlia",
	:dexnum => 281,
	:Type1 => :PSYCHIC,
	:Type2 => :FAIRY,
	:BaseStats => [38, 35, 35, 50, 65, 55],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:SYNCHRONIZE,:TRACE],
	:HiddenAbilities => :TELEPATHY,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 97,
	:CatchRate => 120,
	:Happiness => 35,
	:EggSteps => 5355,
	:Moveset => [
		[1,:GROWL],
		[1,:CONFUSION],
		[1,:DOUBLETEAM],
		[1,:TELEPORT],
		[4,:CONFUSION],
		[6,:DOUBLETEAM],
		[9,:TELEPORT],
		[11,:DISARMINGVOICE],
		[14,:LUCKYCHANT],
		[17,:MAGICALLEAF],
		[19,:HEALPULSE],
		[23,:DRAININGKISS],
		[26,:CALMMIND],
		[30,:PSYCHIC],
		[33,:IMPRISON],
		[37,:FUTURESIGHT],
		[40,:CHARM],
		[44,:HYPNOSIS],
		[47,:DREAMEATER],
		[51,:STOREDPOWER]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:ICYWIND,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "White",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 8,
	:Weight => 202,
	:kind => "Emotion",
	:dexentry => "A Kirlia has the psychic power to create a rip in the dimensions and see into the future. It is said to dance with pleasure on sunny mornings.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GARDEVOIR,:Level,30],
		[:GALLADE,:ItemMale,:DAWNSTONE]
	]
},

:GARDEVOIR => {
	:name => "Gardevoir",
	:dexnum => 282,
	:Type1 => :PSYCHIC,
	:Type2 => :FAIRY,
	:BaseStats => [68, 65, 65, 80, 125, 115],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:SYNCHRONIZE,:TRACE],
	:HiddenAbilities => :TELEPATHY,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 233,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 5355,
	:Moveset => [
		[1,:MOONBLAST],
		[1,:STOREDPOWER],
		[1,:MISTYTERRAIN],
		[1,:HEALINGWISH],
		[1,:GROWL],
		[1,:CONFUSION],
		[1,:DOUBLETEAM],
		[1,:TELEPORT],
		[4,:CONFUSION],
		[6,:DOUBLETEAM],
		[9,:TELEPORT],
		[11,:DISARMINGVOICE],
		[14,:WISH],
		[17,:MAGICALLEAF],
		[19,:HEALPULSE],
		[23,:DRAININGKISS],
		[26,:CALMMIND],
		[31,:PSYCHIC],
		[35,:IMPRISON],
		[40,:FUTURESIGHT],
		[44,:CAPTIVATE],
		[49,:HYPNOSIS],
		[53,:DREAMEATER],
		[58,:STOREDPOWER],
		[62,:MOONBLAST]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSBLAST,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,],
	:Color => "White",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 16,
	:Weight => 484,
	:kind => "Embrace",
	:dexentry => "It apparently does not feel the pull of gravity because it supports itself with psychic power. It will give its life to protect its Trainer.",
	:BattlerPlayerY => 10,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:SURSKIT => {
	:name => "Surskit",
	:dexnum => 283,
	:Type1 => :BUG,
	:Type2 => :WATER,
	:BaseStats => [40, 30, 32, 65, 50, 52],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SWIFTSWIM,:RAINDISH],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 54,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:AQUAJET,:BUGBITE,:ENDURE,:FELLSTINGER,:FORESIGHT,:HYDROPUMP,:MINDREADER,:MUDSHOT,:POWERSPLIT,:PSYBEAM,:SIGNALBEAM],
	:Moveset => [
		[1,:BUBBLE],
		[6,:QUICKATTACK],
		[9,:SWEETSCENT],
		[14,:WATERSPORT],
		[17,:BUBBLEBEAM],
		[22,:AGILITY],
		[25,:MIST],
		[25,:HAZE],
		[30,:AQUAJET],
		[35,:BATONPASS],
		[38,:STICKYWEB]],
	:tmlist => [:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:LIQUIDATION,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Bug],
	:Height => 5,
	:Weight => 17,
	:WildItemCommon => :HONEY,
	:kind => "Pond Skater",
	:dexentry => "They gather on puddles after evening downpours, gliding across the surface of water as if sliding. It secretes honey with a sweet aroma from its head.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MASQUERAIN,:Level,22]
	]
},

:MASQUERAIN => {
	:name => "Masquerain",
	:dexnum => 284,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [70, 60, 62, 80, 100, 82],
	:EVs => [0, 0, 0, 0, 1, 1],
	:Abilities => [:INTIMIDATE,:UNNERVE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 145,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:QUIVERDANCE],
		[1,:WHIRLWIND],
		[1,:BUGBUZZ],
		[1,:OMINOUSWIND],
		[1,:BUBBLE],
		[1,:QUICKATTACK],
		[1,:SWEETSCENT],
		[1,:WATERSPORT],
		[6,:QUICKATTACK],
		[9,:SWEETSCENT],
		[14,:WATERSPORT],
		[17,:GUST],
		[22,:SCARYFACE],
		[22,:AIRCUTTER],
		[26,:STUNSPORE],
		[32,:SILVERWIND],
		[38,:AIRSLASH],
		[42,:BUGBUZZ],
		[48,:WHIRLWIND],
		[52,:QUIVERDANCE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:TWISTER,:SUNNYDAY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:GIGADRAIN,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:LIQUIDATION,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Bug],
	:Height => 8,
	:Weight => 36,
	:WildItemUncommon => :SILVERPOWDER,
	:kind => "Eyeball",
	:dexentry => "It intimidates foes with the eyelike patterns on its antennae. Since it can't fly with wet wings, it shelters itself from rain under large trees and eaves.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 9,
},

:SHROOMISH => {
	:name => "Shroomish",
	:dexnum => 285,
	:Type1 => :GRASS,
	:BaseStats => [60, 40, 60, 35, 40, 60],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:EFFECTSPORE,:POISONHEAL],
	:HiddenAbilities => :QUICKFEET,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 59,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BULLETSEED,:CHARM,:DRAINPUNCH,:FAKETEARS,:FOCUSPUNCH,:HELPINGHAND,:NATURALGIFT,:SEEDBOMB,:WAKEUPSLAP,:WORRYSEED],
	:Moveset => [
		[1,:ABSORB],
		[1,:TACKLE],
		[5,:STUNSPORE],
		[8,:LEECHSEED],
		[12,:MEGADRAIN],
		[15,:HEADBUTT],
		[19,:POISONPOWDER],
		[22,:WORRYSEED],
		[26,:GIGADRAIN],
		[29,:GROWTH],
		[33,:TOXIC],
		[36,:SEEDBOMB],
		[40,:SPORE]],
	:tmlist => [:SNATCH,:FOCUSPUNCH,:DRAINPUNCH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:REST,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Fairy,:Grass],
	:Height => 4,
	:Weight => 45,
	:WildItemCommon => :TINYMUSHROOM,
	:WildItemUncommon => :BIGMUSHROOM,
	:kind => "Mushroom",
	:dexentry => "It loves to eat damp, composted soil in forests. If you enter a forest after a long rain, you can see many Shroomish feasting on composted soil.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BRELOOM,:Level,23]
	]
},

:BRELOOM => {
	:name => "Breloom",
	:dexnum => 286,
	:Type1 => :GRASS,
	:Type2 => :FIGHTING,
	:BaseStats => [60, 130, 80, 70, 60, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:EFFECTSPORE,:POISONHEAL],
	:HiddenAbilities => :TECHNICIAN,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:MACHPUNCH],
		[1,:ABSORB],
		[1,:TACKLE],
		[1,:STUNSPORE],
		[1,:LEECHSEED],
		[5,:STUNSPORE],
		[8,:LEECHSEED],
		[12,:MEGADRAIN],
		[15,:HEADBUTT],
		[19,:FEINT],
		[22,:COUNTER],
		[28,:FORCEPALM],
		[33,:MINDREADER],
		[39,:SKYUPPERCUT],
		[44,:SEEDBOMB],
		[50,:DYNAMICPUNCH]],
	:tmlist => [:FURYCUTTER,:FLING,:SNATCH,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:BULKUP,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Fairy,:Grass],
	:Height => 12,
	:Weight => 392,
	:WildItemCommon => :TINYMUSHROOM,
	:WildItemUncommon => :BIGMUSHROOM,
	:kind => "Mushroom",
	:dexentry => "It scatters spores from holes in the cap on its head. It loves warm and humid climates. It feeds on trees and plants in fields and forests.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:SLAKOTH => {
	:name => "Slakoth",
	:dexnum => 287,
	:Type1 => :NORMAL,
	:BaseStats => [60, 60, 60, 30, 35, 35],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:TRUANT],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 56,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:AFTERYOU,:BODYSLAM,:CRUSHCLAW,:CURSE,:HAMMERARM,:NIGHTSLASH,:PURSUIT,:SLASH,:SLEEPTALK,:SNORE,:TICKLE],
	:Moveset => [
		[1,:SCRATCH],
		[1,:YAWN],
		[6,:ENCORE],
		[9,:SLACKOFF],
		[14,:FEINTATTACK],
		[17,:AMNESIA],
		[22,:COVET],
		[25,:CHIPAWAY],
		[30,:COUNTER],
		[33,:FLAIL],
		[38,:PLAYROUGH]],
	:tmlist => [:FURYCUTTER,:SUCKERPUNCH,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:BULKUP,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:WATERPULSE,:RAINDANCE,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Field],
	:Height => 8,
	:Weight => 240,
	:kind => "Slacker",
	:dexentry => "It sleeps virtually all day and night long. It doesn't change its nest its entire life, but it sometimes travels great distances by swimming in rivers.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:VIGOROTH,:Level,18]
	]
},

:VIGOROTH => {
	:name => "Vigoroth",
	:dexnum => 288,
	:Type1 => :NORMAL,
	:BaseStats => [80, 80, 80, 90, 55, 55],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:VITALSPIRIT],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 154,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:REVERSAL],
		[1,:SCRATCH],
		[1,:FOCUSENERGY],
		[1,:ENCORE],
		[1,:UPROAR],
		[6,:ENCORE],
		[9,:UPROAR],
		[14,:FURYSWIPES],
		[17,:ENDURE],
		[23,:SLASH],
		[27,:CHIPAWAY],
		[33,:COUNTER],
		[37,:FOCUSPUNCH],
		[43,:REVERSAL]],
	:tmlist => [:FURYCUTTER,:SUCKERPUNCH,:FLING,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:WATERPULSE,:RAINDANCE,],
	:Color => "White",
	:Habitat => "Forest",
	:EggGroups => [:Field],
	:Height => 14,
	:Weight => 465,
	:kind => "Wild Monkey",
	:dexentry => "It can't keep still because its filled with energy. It runs through fields and mountains all day to calm itself. If it doesn't, it can't sleep at night.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SLAKING,:Level,36]
	]
},

:SLAKING => {
	:name => "Slaking",
	:dexnum => 289,
	:Type1 => :NORMAL,
	:BaseStats => [150, 160, 100, 100, 95, 65],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:TRUANT],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 252,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:SWAGGER],
		[1,:HAMMERARM],
		[1,:PUNISHMENT],
		[1,:FLING],
		[1,:SCRATCH],
		[1,:YAWN],
		[1,:ENCORE],
		[1,:SLACKOFF],
		[6,:ENCORE],
		[9,:SLACKOFF],
		[14,:FEINTATTACK],
		[17,:AMNESIA],
		[23,:COVET],
		[27,:CHIPAWAY],
		[33,:COUNTER],
		[39,:FLAIL],
		[47,:FLING],
		[53,:PUNISHMENT],
		[61,:HAMMERARM]],
	:tmlist => [:FURYCUTTER,:SUCKERPUNCH,:FLING,:QUASH,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:WATERPULSE,:RAINDANCE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Field],
	:Height => 20,
	:Weight => 1305,
	:kind => "Lazy",
	:dexentry => "Hordes of Slaking gather around trees when fruits come into season. They wait around patiently for ripened fruits to fall out of the trees.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:NINCADA => {
	:name => "Nincada",
	:dexnum => 290,
	:Type1 => :BUG,
	:Type2 => :GROUND,
	:BaseStats => [31, 45, 90, 40, 30, 30],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:COMPOUNDEYES,:RUNAWAY],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 53,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BUGBITE,:BUGBUZZ,:ENDURE,:FEINTATTACK,:FINALGAMBIT,:GUST,:NIGHTSLASH,:SILVERWIND],
	:Moveset => [
		[1,:SCRATCH],
		[1,:HARDEN],
		[5,:ABSORB],
		[9,:SANDATTACK],
		[13,:FURYSWIPES],
		[17,:MUDSLAP],
		[21,:METALCLAW],
		[25,:MINDREADER],
		[29,:BIDE],
		[33,:FALSESWIPE],
		[37,:DIG]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:LEECHLIFE,:STRINGSHOT,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SPITE,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:SANDSTORM,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 5,
	:Weight => 55,
	:WildItemUncommon => :SOFTSAND,
	:kind => "Trainee",
	:dexentry => "It makes its nest at the roots of a mighty tree. Using its whiskerlike antennae, it probes its surroundings in the pitch-black darkness of soil.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 29,
	:BattlerAltitude => 0,
	:evolutions => [
		[:NINJASK,:Ninjask,20],
		[:SHEDINJA,:Shedinja,20]
	]
},

:NINJASK => {
	:name => "Ninjask",
	:dexnum => 291,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [61, 90, 45, 160, 50, 50],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:SPEEDBOOST,:INFILTRATOR],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 160,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:DOUBLETEAM],
		[0,:SCREECH],
		[0,:FURYCUTTER],
		[1,:BUGBITE],
		[1,:SCRATCH],
		[1,:HARDEN],
		[1,:ABSORB],
		[1,:SANDATTACK],
		[5,:ABSORB],
		[9,:SANDATTACK],
		[13,:FURYSWIPES],
		[17,:AGILITY],
		[23,:SLASH],
		[29,:MINDREADER],
		[35,:BATONPASS],
		[41,:SWORDSDANCE],
		[47,:XSCISSOR]],
	:tmlist => [:XSCISSOR,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:LEECHLIFE,:STRINGSHOT,:THIEF,:SUNNYDAY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:SHADOWBALL,:OMINOUSWIND,:SPITE,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:SANDSTORM,:CONFIDE,:LASERFOCUS,],
	:Color => "Yellow",
	:Habitat => "Forest",
	:EggGroups => [:Bug],
	:Height => 8,
	:Weight => 120,
	:kind => "Ninja",
	:dexentry => "Because it darts about vigorously at high speed, it is very difficult to see. Hearing its distinctive cries for too long induces a headache.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 16,
},

:SHEDINJA => {
	:name => "Shedinja",
	:dexnum => 292,
	:Type1 => :BUG,
	:Type2 => :GHOST,
	:BaseStats => [1, 90, 45, 40, 30, 30],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:WONDERGUARD],
	:GrowthRate => "Erratic",
	:GenderRatio => "Genderless",
	:BaseEXP => 83,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:SCRATCH],
		[1,:HARDEN],
		[1,:ABSORB],
		[1,:SANDATTACK],
		[5,:ABSORB],
		[9,:SANDATTACK],
		[13,:FURYSWIPES],
		[17,:SPITE],
		[21,:SHADOWSNEAK],
		[25,:MINDREADER],
		[29,:CONFUSERAY],
		[33,:SHADOWBALL],
		[37,:GRUDGE],
		[41,:HEALBLOCK],
		[45,:PHANTOMFORCE]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:LEECHLIFE,:STRINGSHOT,:SUCKERPUNCH,:THIEF,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:ALLYSWITCH,:REST,:TELEKINESIS,:TRICK,:SANDSTORM,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "Forest",
	:EggGroups => [:Mineral],
	:Height => 8,
	:Weight => 12,
	:kind => "Shed",
	:dexentry => "A peculiar Pokémon that floats in air even though its wings remain completely still. The inside of its body is hollow and utterly dark.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 13,
},

:WHISMUR => {
	:name => "Whismur",
	:dexnum => 293,
	:Type1 => :NORMAL,
	:BaseStats => [64, 51, 23, 28, 51, 23],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:SOUNDPROOF,:RATTLED],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 48,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CIRCLETHROW,:DISARMINGVOICE,:ENDEAVOR,:EXTRASENSORY,:FAKETEARS,:HAMMERARM,:SMELLINGSALTS,:SMOKESCREEN,:SNORE,:TAKEDOWN,:WHIRLWIND],
	:Moveset => [
		[1,:POUND],
		[4,:ECHOEDVOICE],
		[8,:ASTONISH],
		[11,:HOWL],
		[15,:SCREECH],
		[18,:SUPERSONIC],
		[22,:STOMP],
		[25,:UPROAR],
		[29,:ROAR],
		[32,:REST],
		[36,:SLEEPTALK],
		[39,:HYPERVOICE],
		[43,:SYNCHRONOISE]],
	:tmlist => [:FLING,:THUNDERPUNCH,:SHOCKWAVE,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Pink",
	:Habitat => "Cave",
	:EggGroups => [:Monster,:Field],
	:Height => 6,
	:Weight => 163,
	:kind => "Whisper",
	:dexentry => "Its cries equal a jet plane in volume. It inhales through its ear canals. Because of this, it can cry continually without having to catch its breath.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LOUDRED,:Level,20]
	]
},

:LOUDRED => {
	:name => "Loudred",
	:dexnum => 294,
	:Type1 => :NORMAL,
	:BaseStats => [84, 71, 43, 48, 71, 43],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:SOUNDPROOF,:SCRAPPY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 126,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:BITE],
		[1,:POUND],
		[1,:ECHOEDVOICE],
		[1,:ASTONISH],
		[1,:HOWL],
		[4,:ECHOEDVOICE],
		[9,:ASTONISH],
		[11,:HOWL],
		[15,:SCREECH],
		[18,:SUPERSONIC],
		[23,:STOMP],
		[27,:UPROAR],
		[32,:ROAR],
		[36,:REST],
		[41,:SLEEPTALK],
		[45,:HYPERVOICE],
		[50,:SYNCHRONOISE]],
	:tmlist => [:FLING,:TAUNT,:TORMENT,:THUNDERPUNCH,:SHOCKWAVE,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:OVERHEAT,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "Cave",
	:EggGroups => [:Monster,:Field],
	:Height => 10,
	:Weight => 405,
	:kind => "Big Voice",
	:dexentry => "It positions the round speakers on its head to assail foes with ultrasonic waves at massive volume. It builds power by stomping the ground.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
	:evolutions => [
		[:EXPLOUD,:Level,40]
	]
},

:EXPLOUD => {
	:name => "Exploud",
	:dexnum => 295,
	:Type1 => :NORMAL,
	:BaseStats => [104, 91, 63, 68, 91, 73],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:SOUNDPROOF,:SCRAPPY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 216,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:CRUNCH],
		[1,:BITE],
		[1,:BOOMBURST],
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:POUND],
		[1,:ECHOEDVOICE],
		[1,:ASTONISH],
		[1,:HOWL],
		[4,:ECHOEDVOICE],
		[9,:ASTONISH],
		[11,:HOWL],
		[15,:SCREECH],
		[18,:SUPERSONIC],
		[23,:STOMP],
		[27,:UPROAR],
		[32,:ROAR],
		[36,:REST],
		[42,:SLEEPTALK],
		[47,:HYPERVOICE],
		[53,:SYNCHRONOISE],
		[58,:BOOMBURST],
		[64,:HYPERBEAM]],
	:tmlist => [:FLING,:TAUNT,:TORMENT,:OUTRAGE,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:OVERHEAT,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:SURF,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "Cave",
	:EggGroups => [:Monster,:Field],
	:Height => 15,
	:Weight => 840,
	:kind => "Loud Noise",
	:dexentry => "It has sound-generating organs all over its body. It communicates with others by adjusting the tone and volume of the cries it emits.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:MAKUHITA => {
	:name => "Makuhita",
	:dexnum => 296,
	:Type1 => :FIGHTING,
	:BaseStats => [72, 60, 30, 25, 20, 30],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:THICKFAT,:GUTS],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 47,
	:CatchRate => 180,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BULLETPUNCH,:CHIPAWAY,:COUNTER,:CROSSCHOP,:DETECT,:DYNAMICPUNCH,:FEINT,:FEINTATTACK,:FOCUSPUNCH,:FORESIGHT,:HELPINGHAND,:REVENGE,:WAKEUPSLAP,:WIDEGUARD],
	:Moveset => [
		[1,:TACKLE],
		[1,:FOCUSENERGY],
		[4,:SANDATTACK],
		[7,:ARMTHRUST],
		[10,:FAKEOUT],
		[13,:FORCEPALM],
		[16,:WHIRLWIND],
		[19,:KNOCKOFF],
		[22,:VITALTHROW],
		[25,:BELLYDRUM],
		[28,:SMELLINGSALTS],
		[31,:SEISMICTOSS],
		[34,:WAKEUPSLAP],
		[37,:ENDURE],
		[40,:CLOSECOMBAT],
		[43,:REVERSAL],
		[46,:HEAVYSLAM]],
	:tmlist => [:KNOCKOFF,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:SURF,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Yellow",
	:Habitat => "Mountain",
	:EggGroups => [:HumanLike],
	:Height => 10,
	:Weight => 864,
	:WildItemUncommon => :BLACKBELT,
	:kind => "Guts",
	:dexentry => "It loves to toughen up its body above all else. If you hear quaking rumbles in a cave, it is the sound of Makuhita undertaking strenuous training.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:HARIYAMA,:Level,24]
	]
},

:HARIYAMA => {
	:name => "Hariyama",
	:dexnum => 297,
	:Type1 => :FIGHTING,
	:BaseStats => [144, 120, 60, 50, 40, 60],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:THICKFAT,:GUTS],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 166,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:BRINE],
		[1,:TACKLE],
		[1,:FOCUSENERGY],
		[1,:SANDATTACK],
		[1,:ARMTHRUST],
		[4,:SANDATTACK],
		[7,:ARMTHRUST],
		[10,:FAKEOUT],
		[13,:FORCEPALM],
		[16,:WHIRLWIND],
		[19,:KNOCKOFF],
		[22,:VITALTHROW],
		[26,:BELLYDRUM],
		[30,:SMELLINGSALTS],
		[34,:SEISMICTOSS],
		[38,:WAKEUPSLAP],
		[42,:ENDURE],
		[46,:CLOSECOMBAT],
		[50,:REVERSAL],
		[54,:HEAVYSLAM]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:IRONHEAD,:SURF,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:HumanLike],
	:Height => 23,
	:Weight => 2538,
	:WildItemUncommon => :KINGSROCK,
	:kind => "Arm Thrust",
	:dexentry => "It has the habit of challenging others without hesitation to test its strength. It has been known to stop trains using forearm thrusts.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:AZURILL => {
	:name => "Azurill",
	:dexnum => 298,
	:Type1 => :NORMAL,
	:Type2 => :FAIRY,
	:BaseStats => [50, 20, 40, 20, 20, 40],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:THICKFAT,:HUGEPOWER],
	:HiddenAbilities => :SAPSIPPER,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 38,
	:CatchRate => 150,
	:Happiness => 70,
	:EggSteps => 2805,
	:EggMoves => [:BODYSLAM,:CAMOUFLAGE,:COPYCAT,:ENCORE,:FAKETEARS,:MUDDYWATER,:REFRESH,:SING,:SLAM,:SOAK,:TICKLE,:WATERSPORT],
	:Moveset => [
		[1,:SPLASH],
		[1,:WATERGUN],
		[2,:TAILWHIP],
		[5,:WATERSPORT],
		[7,:BUBBLE],
		[10,:CHARM],
		[13,:BUBBLEBEAM],
		[16,:HELPINGHAND],
		[20,:SLAM],
		[23,:BOUNCE]],
	:tmlist => [:KNOCKOFF,:BOUNCE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:SURF,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Undiscovered],
	:Height => 2,
	:Weight => 20,
	:kind => "Polka Dot",
	:dexentry => "Its tail, which is packed with nutrition, is very bouncy like a rubber ball. On sunny days they gather at the edge of water and splash about for fun.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MARILL,:Happiness,0]
	]
},

:NOSEPASS => {
	:name => "Nosepass",
	:dexnum => 299,
	:Type1 => :ROCK,
	:BaseStats => [30, 45, 135, 30, 45, 90],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:STURDY,:MAGNETPULL],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 75,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BLOCK,:DOUBLEEDGE,:ENDURE,:MAGNITUDE,:ROLLOUT,:STEALTHROCK,:WIDEGUARD],
	:Moveset => [
		[1,:TACKLE],
		[4,:HARDEN],
		[7,:BLOCK],
		[10,:ROCKTHROW],
		[13,:THUNDERWAVE],
		[16,:REST],
		[19,:SPARK],
		[22,:ROCKSLIDE],
		[25,:POWERGEM],
		[28,:ROCKBLAST],
		[31,:DISCHARGE],
		[34,:SANDSTORM],
		[37,:EARTHPOWER],
		[40,:STONEEDGE],
		[43,:LOCKON],
		[43,:ZAPCANNON]],
	:tmlist => [:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:EXPLOSION,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:ROLEPLAY,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONDEFENSE,:CONFIDE,:DAZZLINGGLEAM,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "Cave",
	:EggGroups => [:Mineral],
	:Height => 10,
	:Weight => 970,
	:WildItemUncommon => :MAGNET,
	:kind => "Compass",
	:dexentry => "Its body emits a powerful magnetism. It feeds on prey that is pulled in by the force. Its magnetism is stronger in cold seasons.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PROBOPASS,:Location,281]
	]
},

:SKITTY => {
	:name => "Skitty",
	:dexnum => 300,
	:Type1 => :NORMAL,
	:BaseStats => [50, 45, 45, 50, 35, 35],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:CUTECHARM,:NORMALIZE],
	:HiddenAbilities => :WONDERSKIN,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 52,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BATONPASS,:CAPTIVATE,:COSMICPOWER,:FAKEOUT,:FAKETEARS,:HELPINGHAND,:LASTRESORT,:MUDBOMB,:SIMPLEBEAM,:SUCKERPUNCH,:TICKLE,:UPROAR,:WISH,:ZENHEADBUTT],
	:Moveset => [
		[1,:FAKEOUT],
		[1,:GROWL],
		[1,:TAILWHIP],
		[1,:TACKLE],
		[4,:FORESIGHT],
		[7,:SING],
		[10,:ATTRACT],
		[13,:DISARMINGVOICE],
		[16,:DOUBLESLAP],
		[19,:COPYCAT],
		[22,:FEINTATTACK],
		[25,:CHARM],
		[28,:WAKEUPSLAP],
		[31,:ASSIST],
		[34,:COVET],
		[37,:HEALBELL],
		[40,:DOUBLEEDGE],
		[43,:CAPTIVATE],
		[46,:PLAYROUGH]],
	:tmlist => [:SUCKERPUNCH,:PAYBACK,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:ZENHEADBUTT,:CALMMIND,:REST,:ROLLOUT,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Pink",
	:Habitat => "Forest",
	:EggGroups => [:Field,:Fairy],
	:Height => 6,
	:Weight => 110,
	:kind => "Kitten",
	:dexentry => "A Skitty's adorably cute behavior makes it highly popular. In battle, it makes its tail puff out. It threatens foes with a sharp growl.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 3,
	:evolutions => [
		[:DELCATTY,:Item,:MOONSTONE]
	]
},

:DELCATTY => {
	:name => "Delcatty",
	:dexnum => 301,
	:Type1 => :NORMAL,
	:BaseStats => [70, 65, 65, 90, 55, 55],
	:EVs => [1, 0, 0, 1, 0, 0],
	:Abilities => [:CUTECHARM,:NORMALIZE],
	:HiddenAbilities => :WONDERSKIN,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 133,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:FAKEOUT],
		[1,:SING],
		[1,:ATTRACT],
		[1,:DOUBLESLAP]],
	:tmlist => [:SUCKERPUNCH,:PAYBACK,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:ZENHEADBUTT,:CALMMIND,:REST,:ROLLOUT,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Purple",
	:Habitat => "Forest",
	:EggGroups => [:Field,:Fairy],
	:Height => 11,
	:Weight => 326,
	:kind => "Prim",
	:dexentry => "Rather than keeping a permanent lair, it habitually seeks comfortable spots and sleeps there. It is nocturnal and becomes active at dusk.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:SABLEYE => {
	:name => "Sableye",
	:dexnum => 302,
	:Type1 => :DARK,
	:Type2 => :GHOST,
	:BaseStats => [50, 75, 75, 50, 65, 65],
	:EVs => [0, 1, 1, 0, 0, 0],
	:Abilities => [:KEENEYE,:STALL],
	:HiddenAbilities => :PRANKSTER,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 133,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 6630,
	:EggMoves => [:CAPTIVATE,:FEINT,:FLATTER,:IMPRISON,:MEANLOOK,:METALBURST,:MOONLIGHT,:NASTYPLOT,:RECOVER,:SUCKERPUNCH,:TRICK],
	:Moveset => [
		[1,:LEER],
		[1,:SCRATCH],
		[4,:FORESIGHT],
		[6,:NIGHTSHADE],
		[9,:ASTONISH],
		[11,:FURYSWIPES],
		[14,:DETECT],
		[16,:SHADOWSNEAK],
		[19,:FEINTATTACK],
		[21,:FAKEOUT],
		[24,:PUNISHMENT],
		[26,:KNOCKOFF],
		[29,:SHADOWCLAW],
		[31,:CONFUSERAY],
		[34,:ZENHEADBUTT],
		[36,:POWERGEM],
		[39,:SHADOWBALL],
		[41,:FOULPLAY],
		[44,:QUASH],
		[46,:MEANLOOK]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:QUASH,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:OMINOUSWIND,:SPITE,:MUDSLAP,:ICEPUNCH,:ICYWIND,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:WONDERROOM,:ROCKTOMB,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,],
	:Color => "Purple",
	:Habitat => "Cave",
	:EggGroups => [:HumanLike],
	:Height => 5,
	:Weight => 110,
	:WildItemUncommon => :WIDELENS,
	:kind => "Darkness",
	:dexentry => "It digs branching holes in caves using its sharp claws in search of food-- raw gems. A Sableye lurks in darkness and is seen only rarely.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
},

:MAWILE => {
	:name => "Mawile",
	:dexnum => 303,
	:Type1 => :STEEL,
	:Type2 => :FAIRY,
	:BaseStats => [50, 85, 85, 50, 55, 55],
	:EVs => [0, 1, 1, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:INTIMIDATE],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 133,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:CAPTIVATE,:FIREFANG,:GUARDSWAP,:ICEFANG,:METALBURST,:MISTYTERRAIN,:POISONFANG,:POWERUPPUNCH,:PUNISHMENT,:SEISMICTOSS,:SLAM,:SUCKERPUNCH,:THUNDERFANG,:TICKLE],
	:Moveset => [
		[1,:PLAYROUGH],
		[1,:IRONHEAD],
		[1,:TAUNT],
		[1,:GROWL],
		[1,:FAIRYWIND],
		[1,:ASTONISH],
		[5,:FAKETEARS],
		[9,:BITE],
		[13,:SWEETSCENT],
		[17,:VICEGRIP],
		[21,:FEINTATTACK],
		[25,:BATONPASS],
		[29,:CRUNCH],
		[33,:IRONDEFENSE],
		[37,:SUCKERPUNCH],
		[41,:STOCKPILE],
		[41,:SPITUP],
		[41,:SWALLOW],
		[45,:IRONHEAD],
		[49,:PLAYROUGH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:CHARGEBEAM,:MAGNETRISE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Black",
	:Habitat => "Cave",
	:EggGroups => [:Field,:Fairy],
	:Height => 6,
	:Weight => 115,
	:WildItemUncommon => :IRONBALL,
	:kind => "Deceiver",
	:dexentry => "Its giant jaws are actually steel horns that transformed. It fools foes into complacency with its adorable gestures, then chomps them with its huge jaws.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
},

:ARON => {
	:name => "Aron",
	:dexnum => 304,
	:Type1 => :STEEL,
	:Type2 => :ROCK,
	:BaseStats => [50, 70, 100, 30, 40, 40],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:STURDY,:ROCKHEAD],
	:HiddenAbilities => :HEAVYMETAL,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 180,
	:Happiness => 35,
	:EggSteps => 9180,
	:EggMoves => [:BODYSLAM,:CURSE,:DRAGONRUSH,:ENDEAVOR,:HEADSMASH,:IRONHEAD,:REVERSAL,:SCREECH,:SMELLINGSALTS,:STEALTHROCK,:STOMP,:SUPERPOWER],
	:Moveset => [
		[1,:TACKLE],
		[1,:HARDEN],
		[4,:MUDSLAP],
		[7,:HEADBUTT],
		[10,:METALCLAW],
		[13,:ROCKTOMB],
		[16,:PROTECT],
		[19,:ROAR],
		[22,:IRONHEAD],
		[25,:ROCKSLIDE],
		[28,:TAKEDOWN],
		[31,:METALSOUND],
		[34,:IRONTAIL],
		[37,:IRONDEFENSE],
		[40,:DOUBLEEDGE],
		[43,:AUTOTOMIZE],
		[46,:HEAVYSLAM],
		[49,:METALBURST]],
	:tmlist => [:FURYCUTTER,:SHOCKWAVE,:MAGNETRISE,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 4,
	:Weight => 600,
	:WildItemUncommon => :HARDSTONE,
	:kind => "Iron Armor",
	:dexentry => "A Pokémon that is clad in steel armor. A new suit of armor is made when it evolves. The old armor is salvaged as metal for making iron products.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LAIRON,:Level,32]
	]
},

:LAIRON => {
	:name => "Lairon",
	:dexnum => 305,
	:Type1 => :STEEL,
	:Type2 => :ROCK,
	:BaseStats => [60, 90, 140, 40, 50, 50],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:STURDY,:ROCKHEAD],
	:HiddenAbilities => :HEAVYMETAL,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 151,
	:CatchRate => 90,
	:Happiness => 35,
	:EggSteps => 9180,
	:Moveset => [
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:MUDSLAP],
		[1,:HEADBUTT],
		[4,:MUDSLAP],
		[7,:HEADBUTT],
		[10,:METALCLAW],
		[13,:ROCKTOMB],
		[16,:PROTECT],
		[19,:ROAR],
		[22,:IRONHEAD],
		[25,:ROCKSLIDE],
		[28,:TAKEDOWN],
		[31,:METALSOUND],
		[35,:IRONTAIL],
		[39,:IRONDEFENSE],
		[43,:DOUBLEEDGE],
		[47,:AUTOTOMIZE],
		[51,:HEAVYSLAM],
		[55,:METALBURST]],
	:tmlist => [:FURYCUTTER,:SHOCKWAVE,:MAGNETRISE,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:WATERPULSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 9,
	:Weight => 1200,
	:WildItemUncommon => :HARDSTONE,
	:kind => "Iron Armor",
	:dexentry => "When two Lairon meet in the wild, they fight for territory by bashing into each other. The sound of their collision carries for miles.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:AGGRON,:Level,42]
	]
},

:AGGRON => {
	:name => "Aggron",
	:dexnum => 306,
	:Type1 => :STEEL,
	:Type2 => :ROCK,
	:BaseStats => [70, 110, 180, 50, 60, 60],
	:EVs => [0, 0, 3, 0, 0, 0],
	:Abilities => [:STURDY,:ROCKHEAD],
	:HiddenAbilities => :HEAVYMETAL,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 239,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 9180,
	:Moveset => [
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:MUDSLAP],
		[1,:HEADBUTT],
		[4,:MUDSLAP],
		[7,:HEADBUTT],
		[10,:METALCLAW],
		[13,:ROCKTOMB],
		[16,:PROTECT],
		[19,:ROAR],
		[22,:IRONHEAD],
		[25,:ROCKSLIDE],
		[28,:TAKEDOWN],
		[31,:METALSOUND],
		[35,:IRONTAIL],
		[39,:IRONDEFENSE],
		[45,:DOUBLEEDGE],
		[51,:AUTOTOMIZE],
		[57,:HEAVYSLAM],
		[63,:METALBURST]],
	:tmlist => [:FURYCUTTER,:DARKPULSE,:PAYBACK,:FLING,:TAUNT,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SPITE,:SOLARBEAM,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:SMARTSTRIKE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "Mountain",
	:EggGroups => [:Monster],
	:Height => 21,
	:Weight => 3600,
	:WildItemUncommon => :HARDSTONE,
	:kind => "Iron Armor",
	:dexentry => "Its iron horns grow longer a little at a time. They determine the Aggron's age. The gouges in its armor are worn with pride as mementos from battles.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:MEDITITE => {
	:name => "Meditite",
	:dexnum => 307,
	:Type1 => :FIGHTING,
	:Type2 => :PSYCHIC,
	:BaseStats => [30, 40, 55, 60, 40, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:PUREPOWER,:TELEPATHY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 56,
	:CatchRate => 180,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BATONPASS,:BULLETPUNCH,:DRAINPUNCH,:DYNAMICPUNCH,:FAKEOUT,:FIREPUNCH,:FORESIGHT,:GUARDSWAP,:ICEPUNCH,:POWERSWAP,:PSYCHOCUT,:QUICKGUARD,:SECRETPOWER,:THUNDERPUNCH],
	:Moveset => [
		[1,:BIDE],
		[4,:MEDITATE],
		[7,:CONFUSION],
		[9,:DETECT],
		[12,:ENDURE],
		[15,:FEINT],
		[17,:FORCEPALM],
		[20,:HIDDENPOWER],
		[23,:CALMMIND],
		[25,:MINDREADER],
		[28,:HIJUMPKICK],
		[31,:PSYCHUP],
		[33,:ACUPRESSURE],
		[36,:POWERTRICK],
		[39,:REVERSAL],
		[41,:RECOVER],
		[44,:COUNTER]],
	:tmlist => [:SIGNALBEAM,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Blue",
	:Habitat => "Mountain",
	:EggGroups => [:HumanLike],
	:Height => 6,
	:Weight => 112,
	:kind => "Meditate",
	:dexentry => "It continually meditates for hours every day. As a result of rigorous and dedicated yoga training, it has tempered its spiritual power so much it can fly.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MEDICHAM,:Level,37]
	]
},

:MEDICHAM => {
	:name => "Medicham",
	:dexnum => 308,
	:Type1 => :FIGHTING,
	:Type2 => :PSYCHIC,
	:BaseStats => [60, 60, 75, 80, 60, 75],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:PUREPOWER,:TELEPATHY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ZENHEADBUTT],
		[1,:FIREPUNCH],
		[1,:THUNDERPUNCH],
		[1,:ICEPUNCH],
		[1,:BIDE],
		[1,:MEDITATE],
		[1,:CONFUSION],
		[1,:DETECT],
		[1,:BIDE],
		[4,:MEDITATE],
		[7,:CONFUSION],
		[9,:DETECT],
		[12,:ENDURE],
		[15,:FEINT],
		[17,:FORCEPALM],
		[20,:HIDDENPOWER],
		[23,:CALMMIND],
		[25,:MINDREADER],
		[28,:HIJUMPKICK],
		[31,:PSYCHUP],
		[33,:ACUPRESSURE],
		[36,:POWERTRICK],
		[42,:REVERSAL],
		[47,:RECOVER],
		[53,:COUNTER]],
	:tmlist => [:SIGNALBEAM,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:HumanLike],
	:Height => 13,
	:Weight => 315,
	:kind => "Meditate",
	:dexentry => "Through crushingly harsh yoga training, it gained the power to foretell its foe's actions. It battles with elegant, dance- like movement.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:ELECTRIKE => {
	:name => "Electrike",
	:dexnum => 309,
	:Type1 => :ELECTRIC,
	:BaseStats => [40, 45, 40, 65, 65, 40],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:STATIC,:LIGHTNINGROD],
	:HiddenAbilities => :MINUS,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 59,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CRUNCH,:CURSE,:DISCHARGE,:EERIEIMPULSE,:ELECTROBALL,:FIREFANG,:FLAMEBURST,:HEADBUTT,:ICEFANG,:SHOCKWAVE,:SWIFT,:SWITCHEROO,:THUNDERFANG,:UPROAR],
	:Moveset => [
		[1,:TACKLE],
		[1,:THUNDERWAVE],
		[4,:LEER],
		[7,:HOWL],
		[10,:QUICKATTACK],
		[13,:SPARK],
		[16,:ODORSLEUTH],
		[19,:THUNDERFANG],
		[24,:BITE],
		[29,:DISCHARGE],
		[34,:ROAR],
		[39,:WILDCHARGE],
		[44,:CHARGE],
		[49,:THUNDER]],
	:tmlist => [:SIGNALBEAM,:SNARL,:THIEF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FLAMETHROWER,:MUDSLAP,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 152,
	:kind => "Lightning",
	:dexentry => "It generates electricity using friction from the atmosphere. In seasons with especially arid air, its entire body blazes with violent showers of sparks.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MANECTRIC,:Level,26]
	]
},

:MANECTRIC => {
	:name => "Manectric",
	:dexnum => 310,
	:Type1 => :ELECTRIC,
	:BaseStats => [70, 75, 60, 105, 105, 60],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:STATIC,:LIGHTNINGROD],
	:HiddenAbilities => :MINUS,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ELECTRICTERRAIN],
		[1,:FIREFANG],
		[1,:TACKLE],
		[1,:THUNDERWAVE],
		[1,:LEER],
		[1,:HOWL],
		[4,:LEER],
		[7,:HOWL],
		[10,:QUICKATTACK],
		[13,:SPARK],
		[16,:ODORSLEUTH],
		[19,:THUNDERFANG],
		[24,:BITE],
		[30,:DISCHARGE],
		[36,:ROAR],
		[42,:WILDCHARGE],
		[48,:CHARGE],
		[54,:THUNDER],
		[60,:ELECTRICTERRAIN]],
	:tmlist => [:SIGNALBEAM,:SNARL,:THIEF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:OVERHEAT,:FLAMETHROWER,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 15,
	:Weight => 402,
	:kind => "Discharge",
	:dexentry => "Because lightning falls in their vicinities, Manectric were thought to have been born from lightning. In battle, they create thunderclouds.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:PLUSLE => {
	:name => "Plusle",
	:dexnum => 311,
	:Type1 => :ELECTRIC,
	:BaseStats => [60, 50, 40, 95, 85, 75],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:PLUS,:LIGHTNINGROD],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 142,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CHARM,:DISCHARGE,:FAKETEARS,:LUCKYCHANT,:SING,:SWEETKISS,:TEARFULLOOK,:WISH],
	:Moveset => [
		[1,:NUZZLE],
		[1,:PLAYNICE],
		[1,:GROWL],
		[1,:THUNDERWAVE],
		[1,:QUICKATTACK],
		[4,:HELPINGHAND],
		[7,:SPARK],
		[10,:ENCORE],
		[13,:BESTOW],
		[16,:SWIFT],
		[19,:ELECTROBALL],
		[22,:COPYCAT],
		[25,:CHARM],
		[28,:CHARGE],
		[31,:DISCHARGE],
		[34,:BATONPASS],
		[37,:AGILITY],
		[40,:LASTRESORT],
		[43,:THUNDER],
		[46,:NASTYPLOT],
		[49,:ENTRAINMENT]],
	:tmlist => [:SIGNALBEAM,:FLING,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:GRASSKNOT,:MUDSLAP,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy],
	:Height => 4,
	:Weight => 42,
	:WildItemUncommon => :CELLBATTERY,
	:kind => "Cheering",
	:dexentry => "It has the trait of cheering on its fellow Pokémon. By shorting out the electricity it releases from its paws, it creates pom-poms for cheering.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:MINUN => {
	:name => "Minun",
	:dexnum => 312,
	:Type1 => :ELECTRIC,
	:BaseStats => [60, 40, 50, 95, 75, 85],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:MINUS,:VOLTABSORB],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 142,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CHARM,:DISCHARGE,:FAKETEARS,:LUCKYCHANT,:SING,:SWEETKISS,:TEARFULLOOK,:WISH],
	:Moveset => [
		[1,:NUZZLE],
		[1,:PLAYNICE],
		[1,:GROWL],
		[1,:THUNDERWAVE],
		[1,:QUICKATTACK],
		[4,:HELPINGHAND],
		[7,:SPARK],
		[10,:ENCORE],
		[13,:SWITCHEROO],
		[16,:SWIFT],
		[19,:ELECTROBALL],
		[22,:COPYCAT],
		[25,:FAKETEARS],
		[28,:CHARGE],
		[31,:DISCHARGE],
		[34,:BATONPASS],
		[37,:AGILITY],
		[40,:TRUMPCARD],
		[43,:THUNDER],
		[46,:NASTYPLOT],
		[49,:ENTRAINMENT]],
	:tmlist => [:SIGNALBEAM,:FLING,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:GRASSKNOT,:MUDSLAP,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Yellow",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy],
	:Height => 4,
	:Weight => 42,
	:WildItemUncommon => :CELLBATTERY,
	:kind => "Cheering",
	:dexentry => "At a meeting of Pokémon academics, it was announced that simultaneous exposure to electricity from a Minun will promote circulation and boost vitality.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:VOLBEAT => {
	:name => "Volbeat",
	:dexnum => 313,
	:Type1 => :BUG,
	:BaseStats => [65, 73, 75, 85, 47, 85],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:ILLUMINATE,:SWARM],
	:HiddenAbilities => :PRANKSTER,
	:GrowthRate => "Erratic",
	:GenderRatio => "FemZero",
	:BaseEXP => 140,
	:CatchRate => 150,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:BATONPASS,:BUGBUZZ,:DIZZYPUNCH,:ENCORE,:LUNGE,:SEISMICTOSS,:SILVERWIND,:TRICK],
	:Moveset => [
		[1,:FLASH],
		[1,:TACKLE],
		[5,:DOUBLETEAM],
		[8,:CONFUSERAY],
		[12,:QUICKATTACK],
		[15,:STRUGGLEBUG],
		[19,:MOONLIGHT],
		[22,:TAILGLOW],
		[26,:SIGNALBEAM],
		[29,:PROTECT],
		[33,:ZENHEADBUTT],
		[36,:HELPINGHAND],
		[40,:BUGBUZZ],
		[43,:PLAYROUGH],
		[47,:DOUBLEEDGE],
		[50,:INFESTATION]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:ICEPUNCH,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:LIGHTSCREEN,:REST,:TRICK,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Gray",
	:Habitat => "Forest",
	:EggGroups => [:Bug,:HumanLike],
	:Height => 7,
	:Weight => 177,
	:WildItemUncommon => :BRIGHTPOWDER,
	:kind => "Firefly",
	:dexentry => "With their taillights lit, Volbeat fly in a swarm, drawing geometric designs in the night sky. They move their nests if their pond water becomes dirty.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 10,
},

:ILLUMISE => {
	:name => "Illumise",
	:dexnum => 314,
	:Type1 => :BUG,
	:BaseStats => [65, 47, 75, 85, 73, 85],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:OBLIVIOUS,:TINTEDLENS],
	:HiddenAbilities => :PRANKSTER,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "MaleNever",
	:BaseEXP => 140,
	:CatchRate => 150,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:AROMATHERAPY,:BATONPASS,:BUGBUZZ,:CAPTIVATE,:CONFUSERAY,:ENCORE,:FAKETEARS,:GROWTH,:SILVERWIND],
	:Moveset => [
		[1,:PLAYNICE],
		[1,:TACKLE],
		[5,:SWEETSCENT],
		[9,:CHARM],
		[12,:QUICKATTACK],
		[15,:STRUGGLEBUG],
		[19,:MOONLIGHT],
		[22,:WISH],
		[26,:ENCORE],
		[29,:FLATTER],
		[33,:ZENHEADBUTT],
		[36,:HELPINGHAND],
		[40,:BUGBUZZ],
		[43,:PLAYROUGH],
		[47,:COVET],
		[50,:INFESTATION]],
	:tmlist => [:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:ICEPUNCH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:LIGHTSCREEN,:REST,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Purple",
	:Habitat => "Forest",
	:EggGroups => [:Bug,:HumanLike],
	:Height => 6,
	:Weight => 177,
	:WildItemUncommon => :BRIGHTPOWDER,
	:kind => "Firefly",
	:dexentry => "A nocturnal Pokémon that becomes active upon nightfall. It leads Volbeat swarms to draw patterns in the sky. Over 200 different patterns have been seen.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 10,
},

:ROSELIA => {
	:name => "Roselia",
	:dexnum => 315,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [50, 60, 45, 65, 100, 80],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:NATURALCURE,:POISONPOINT],
	:HiddenAbilities => :LEAFGUARD,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 140,
	:CatchRate => 150,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BULLETSEED,:COTTONSPORE,:GIGADRAIN,:GRASSWHISTLE,:LEAFSTORM,:MINDREADER,:NATURALGIFT,:PINMISSILE,:POWERWHIP,:RAZORLEAF,:SEEDBOMB,:SLEEPPOWDER,:SPIKES,:SYNTHESIS],
	:Moveset => [
		[1,:ABSORB],
		[4,:GROWTH],
		[7,:POISONSTING],
		[10,:STUNSPORE],
		[13,:MEGADRAIN],
		[16,:LEECHSEED],
		[19,:MAGICALLEAF],
		[22,:GRASSWHISTLE],
		[25,:GIGADRAIN],
		[28,:TOXICSPIKES],
		[31,:SWEETSCENT],
		[34,:INGRAIN],
		[37,:PETALBLIZZARD],
		[40,:TOXIC],
		[43,:AROMATHERAPY],
		[46,:SYNTHESIS],
		[50,:PETALDANCE]],
	:tmlist => [:FURYCUTTER,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy,:Grass],
	:Height => 3,
	:Weight => 20,
	:WildItemUncommon => :POISONBARB,
	:kind => "Thorn",
	:dexentry => "A Roselia that drinks nutritionally rich springwater blooms with lovely flowers. The fragrance of its flowers has the effect of making its foes careless.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ROSERADE,:Item,:SHINYSTONE]
	]
},

:GULPIN => {
	:name => "Gulpin",
	:dexnum => 316,
	:Type1 => :POISON,
	:BaseStats => [70, 43, 53, 40, 43, 53],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:LIQUIDOOZE,:STICKYHOLD],
	:HiddenAbilities => :GLUTTONY,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACIDARMOR,:CURSE,:DESTINYBOND,:GUNKSHOT,:MUDSLAP,:PAINSPLIT,:SMOG,:VENOMDRENCH],
	:Moveset => [
		[1,:POUND],
		[5,:YAWN],
		[8,:POISONGAS],
		[10,:SLUDGE],
		[12,:AMNESIA],
		[17,:ACIDSPRAY],
		[20,:ENCORE],
		[25,:TOXIC],
		[28,:STOCKPILE],
		[28,:SPITUP],
		[28,:SWALLOW],
		[33,:SLUDGEBOMB],
		[36,:GASTROACID],
		[41,:BELCH],
		[44,:WRINGOUT],
		[49,:GUNKSHOT]],
	:tmlist => [:SNATCH,:THUNDERPUNCH,:SHOCKWAVE,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:SEEDBOMB,:GIGADRAIN,:MUDSLAP,:ICEBEAM,:ICEPUNCH,:EXPLOSION,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:DREAMEATER,:REST,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Green",
	:Habitat => "Grassland",
	:EggGroups => [:Amorphous],
	:Height => 4,
	:Weight => 103,
	:WildItemCommon => :ORANBERRY,
	:WildItemUncommon => :SITRUSBERRY,
	:kind => "Stomach",
	:dexentry => "This Pokémon's stomach fluid can even digest scrap iron. In one gulp, it can swallow something that is as large as itself.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SWALOT,:Level,26]
	]
},

:SWALOT => {
	:name => "Swalot",
	:dexnum => 317,
	:Type1 => :POISON,
	:BaseStats => [100, 73, 83, 55, 73, 83],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:LIQUIDOOZE,:STICKYHOLD],
	:HiddenAbilities => :GLUTTONY,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 163,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:BODYSLAM],
		[1,:VENOMDRENCH],
		[1,:GUNKSHOT],
		[1,:WRINGOUT],
		[1,:POUND],
		[1,:YAWN],
		[1,:POISONGAS],
		[1,:SLUDGE],
		[5,:YAWN],
		[8,:POISONGAS],
		[10,:SLUDGE],
		[12,:AMNESIA],
		[17,:ACIDSPRAY],
		[20,:ENCORE],
		[25,:TOXIC],
		[30,:STOCKPILE],
		[30,:SPITUP],
		[30,:SWALLOW],
		[37,:SLUDGEBOMB],
		[42,:GASTROACID],
		[49,:BELCH],
		[54,:WRINGOUT],
		[61,:GUNKSHOT]],
	:tmlist => [:SNATCH,:THUNDERPUNCH,:SHOCKWAVE,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:SEEDBOMB,:GIGADRAIN,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEBEAM,:ICEPUNCH,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:DREAMEATER,:REST,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Purple",
	:Habitat => "Grassland",
	:EggGroups => [:Amorphous],
	:Height => 17,
	:Weight => 800,
	:WildItemCommon => :ORANBERRY,
	:WildItemUncommon => :SITRUSBERRY,
	:kind => "Poison Bag",
	:dexentry => "Its powerful stomach acid is capable of digesting almost anything. The one thing in the whole world a Swalot can't digest is its own stomach.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
},

:CARVANHA => {
	:name => "Carvanha",
	:dexnum => 318,
	:Type1 => :WATER,
	:Type2 => :DARK,
	:BaseStats => [45, 90, 20, 65, 65, 20],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:ROUGHSKIN,:SPEEDBOOST],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 225,
	:Happiness => 35,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:BRINE,:DESTINYBOND,:DOUBLEEDGE,:HYDROPUMP,:PSYCHICFANGS,:SWIFT,:THRASH],
	:Moveset => [
		[1,:LEER],
		[1,:BITE],
		[4,:RAGE],
		[8,:FOCUSENERGY],
		[11,:AQUAJET],
		[15,:ASSURANCE],
		[18,:SCREECH],
		[22,:SWAGGER],
		[25,:ICEFANG],
		[29,:SCARYFACE],
		[32,:POISONFANG],
		[36,:CRUNCH],
		[39,:AGILITY],
		[43,:TAKEDOWN]],
	:tmlist => [:FURYCUTTER,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:TAUNT,:TORMENT,:BOUNCE,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:ANCIENTPOWER,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Red",
	:Habitat => "Sea",
	:EggGroups => [:Water2],
	:Height => 8,
	:Weight => 208,
	:WildItemUncommon => :DEEPSEATOOTH,
	:kind => "Savage",
	:dexentry => "Carvanha attack ships in swarms, making them sink. Although it is said to be a very vicious Pokémon, it timidly flees as soon as it finds itself alone.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 10,
	:evolutions => [
		[:SHARPEDO,:Level,30]
	]
},

:SHARPEDO => {
	:name => "Sharpedo",
	:dexnum => 319,
	:Type1 => :WATER,
	:Type2 => :DARK,
	:BaseStats => [70, 120, 40, 95, 95, 40],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:ROUGHSKIN,:SPEEDBOOST],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 60,
	:Happiness => 35,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SLASH],
		[1,:NIGHTSLASH],
		[1,:FEINT],
		[1,:LEER],
		[1,:BITE],
		[1,:RAGE],
		[1,:FOCUSENERGY],
		[4,:RAGE],
		[8,:FOCUSENERGY],
		[11,:AQUAJET],
		[15,:ASSURANCE],
		[18,:SCREECH],
		[22,:SWAGGER],
		[25,:ICEFANG],
		[29,:SCARYFACE],
		[34,:POISONFANG],
		[40,:CRUNCH],
		[45,:AGILITY],
		[51,:SKULLBASH],
		[56,:TAUNT],
		[62,:NIGHTSLASH]],
	:tmlist => [:FURYCUTTER,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:TAUNT,:TORMENT,:ROCKSMASH,:BOUNCE,:SPITE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:ZENHEADBUTT,:REST,:ANCIENTPOWER,:ROCKTOMB,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water2],
	:Height => 18,
	:Weight => 888,
	:WildItemUncommon => :DEEPSEATOOTH,
	:kind => "Brutal",
	:dexentry => "The vicious and sly gangster of the sea. Its skin is specially textured to minimize drag in water. Its speed tops out at over 75 miles per hour.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 8,
},

:WAILMER => {
	:name => "Wailmer",
	:dexnum => 320,
	:Type1 => :WATER,
	:BaseStats => [130, 70, 35, 60, 70, 35],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:WATERVEIL,:OBLIVIOUS],
	:HiddenAbilities => :PRESSURE,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 80,
	:CatchRate => 125,
	:Happiness => 70,
	:EggSteps => 10455,
	:EggMoves => [:AQUARING,:BODYSLAM,:CLEARSMOG,:CURSE,:DEFENSECURL,:DOUBLEEDGE,:FISSURE,:SLEEPTALK,:SNORE,:SOAK,:THRASH,:TICKLE,:ZENHEADBUTT],
	:Moveset => [
		[1,:SPLASH],
		[4,:GROWL],
		[7,:WATERGUN],
		[10,:ROLLOUT],
		[13,:WHIRLPOOL],
		[16,:ASTONISH],
		[19,:WATERPULSE],
		[22,:MIST],
		[25,:BRINE],
		[29,:REST],
		[33,:WATERSPOUT],
		[37,:AMNESIA],
		[41,:DIVE],
		[45,:BOUNCE],
		[49,:HYDROPUMP],
		[53,:HEAVYSLAM]],
	:tmlist => [:ROCKSMASH,:BOUNCE,:EARTHQUAKE,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:ROCKTOMB,:ROLLOUT,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Field,:Water2],
	:Height => 20,
	:Weight => 1300,
	:kind => "Ball Whale",
	:dexentry => "While this Pokémon usually lives in the sea, it can survive on land, although not too long. It loses vitality if its body becomes dried out.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WAILORD,:Level,40]
	]
},

:WAILORD => {
	:name => "Wailord",
	:dexnum => 321,
	:Type1 => :WATER,
	:BaseStats => [170, 90, 45, 60, 90, 45],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:WATERVEIL,:OBLIVIOUS],
	:HiddenAbilities => :PRESSURE,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 10455,
	:Moveset => [
		[1,:SOAK],
		[1,:NOBLEROAR],
		[1,:HEAVYSLAM],
		[1,:SPLASH],
		[1,:GROWL],
		[1,:WATERGUN],
		[1,:ROLLOUT],
		[4,:GROWL],
		[7,:WATERGUN],
		[10,:ROLLOUT],
		[13,:WHIRLPOOL],
		[16,:ASTONISH],
		[19,:WATERPULSE],
		[22,:MIST],
		[25,:BRINE],
		[29,:REST],
		[33,:WATERSPOUT],
		[37,:AMNESIA],
		[44,:DIVE],
		[51,:BOUNCE],
		[58,:HYDROPUMP],
		[65,:HEAVYSLAM]],
	:tmlist => [:ROCKSMASH,:BOUNCE,:EARTHQUAKE,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:ROCKTOMB,:ROLLOUT,:IRONHEAD,:SURF,:DIVE,:SCALD,:WATERFALL,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Field,:Water2],
	:Height => 145,
	:Weight => 3980,
	:kind => "Float Whale",
	:dexentry => "It breathes through nostrils that it raises above the sea. By inhaling to its maximum capacity, a Wailord can dive close to 10,000 feet beneath the waves.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:NUMEL => {
	:name => "Numel",
	:dexnum => 322,
	:Type1 => :FIRE,
	:Type2 => :GROUND,
	:BaseStats => [60, 60, 40, 35, 65, 45],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:OBLIVIOUS,:SIMPLE],
	:HiddenAbilities => :OWNTEMPO,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ANCIENTPOWER,:BODYSLAM,:DEFENSECURL,:ENDURE,:GROWTH,:HEATWAVE,:HEAVYSLAM,:HOWL,:IRONHEAD,:MUDBOMB,:ROLLOUT,:SCARYFACE,:SPITUP,:STOCKPILE,:STOMP,:SWALLOW,:YAWN],
	:Moveset => [
		[1,:GROWL],
		[1,:TACKLE],
		[5,:EMBER],
		[8,:FOCUSENERGY],
		[12,:MAGNITUDE],
		[15,:FLAMEBURST],
		[19,:AMNESIA],
		[22,:LAVAPLUME],
		[26,:EARTHPOWER],
		[29,:CURSE],
		[31,:TAKEDOWN],
		[36,:YAWN],
		[40,:EARTHQUAKE],
		[43,:FLAMETHROWER],
		[47,:DOUBLEEDGE]],
	:tmlist => [:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:STEALTHROCK,:CONFIDE,],
	:Color => "Yellow",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 7,
	:Weight => 240,
	:kind => "Numb",
	:dexentry => "It stores boiling magma in the hump on its back. Numel is a hardy Pokémon that can transport a 220-pound load. It has served humans at work since long ago.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CAMERUPT,:Level,33]
	]
},

:CAMERUPT => {
	:name => "Camerupt",
	:dexnum => 323,
	:Type1 => :FIRE,
	:Type2 => :GROUND,
	:BaseStats => [70, 100, 70, 40, 105, 75],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:MAGMAARMOR,:SOLIDROCK],
	:HiddenAbilities => :ANGERPOINT,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 150,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:ROCKSLIDE],
		[1,:FISSURE],
		[1,:ERUPTION],
		[1,:GROWL],
		[1,:TACKLE],
		[1,:EMBER],
		[1,:FOCUSENERGY],
		[8,:EMBER],
		[8,:FOCUSENERGY],
		[12,:MAGNITUDE],
		[15,:FLAMEBURST],
		[19,:AMNESIA],
		[22,:LAVAPLUME],
		[26,:EARTHPOWER],
		[29,:CURSE],
		[31,:TAKEDOWN],
		[39,:YAWN],
		[46,:EARTHQUAKE],
		[52,:ERUPTION],
		[59,:FISSURE]],
	:tmlist => [:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Red",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 19,
	:Weight => 2200,
	:kind => "Eruption",
	:dexentry => "A Pokémon that lives in the crater of a volcano. Every 10 years, the volcanoes on its back erupt violently. Research is under way on the cause of eruption.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:TORKOAL => {
	:name => "Torkoal",
	:dexnum => 324,
	:Type1 => :FIRE,
	:BaseStats => [70, 85, 140, 20, 85, 70],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:WHITESMOKE,:DROUGHT],
	:HiddenAbilities => :SHELLARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 165,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CLEARSMOG,:ENDURE,:ERUPTION,:FISSURE,:FLAMEBURST,:SKULLBASH,:SLEEPTALK,:SUPERPOWER,:YAWN],
	:Moveset => [
		[1,:EMBER],
		[4,:SMOG],
		[7,:WITHDRAW],
		[10,:RAPIDSPIN],
		[13,:FIRESPIN],
		[15,:SMOKESCREEN],
		[18,:FLAMEWHEEL],
		[22,:CURSE],
		[25,:LAVAPLUME],
		[27,:BODYSLAM],
		[30,:PROTECT],
		[34,:FLAMETHROWER],
		[38,:IRONDEFENSE],
		[40,:AMNESIA],
		[42,:FLAIL],
		[45,:HEATWAVE],
		[47,:SHELLSMASH],
		[50,:INFERNO]],
	:tmlist => [:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:GYROBALL,:IRONDEFENSE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 804,
	:WildItemUncommon => :CHARCOAL,
	:kind => "Coal",
	:dexentry => "It battles using energy it gets from burning coal. When loosing smoke from its nostrils, it lets off a sound that is similar to a locomotive's horn.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:SPOINK => {
	:name => "Spoink",
	:dexnum => 325,
	:Type1 => :PSYCHIC,
	:BaseStats => [60, 25, 35, 60, 70, 80],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:THICKFAT,:OWNTEMPO],
	:HiddenAbilities => :GLUTTONY,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:ENDURE,:EXTRASENSORY,:FUTURESIGHT,:LUCKYCHANT,:MIRRORCOAT,:SIMPLEBEAM,:SKILLSWAP,:TRICK,:WHIRLWIND,:ZENHEADBUTT],
	:Moveset => [
		[1,:SPLASH],
		[7,:PSYWAVE],
		[10,:ODORSLEUTH],
		[14,:PSYBEAM],
		[15,:PSYCHUP],
		[18,:CONFUSERAY],
		[21,:MAGICCOAT],
		[26,:ZENHEADBUTT],
		[29,:POWERGEM],
		[29,:REST],
		[33,:SNORE],
		[38,:PSYSHOCK],
		[40,:PAYBACK],
		[44,:PSYCHIC],
		[50,:BOUNCE]],
	:tmlist => [:SIGNALBEAM,:PAYBACK,:THIEF,:SNATCH,:TAUNT,:TORMENT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:GRASSKNOT,:ICYWIND,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Black",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 7,
	:Weight => 306,
	:kind => "Bounce",
	:dexentry => "A Pokémon that manipulates psychic power at will. It doesn't stop bouncing even when it is asleep. It loves eating mushrooms that grow underground.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GRUMPIG,:Level,32]
	]
},

:GRUMPIG => {
	:name => "Grumpig",
	:dexnum => 326,
	:Type1 => :PSYCHIC,
	:BaseStats => [80, 45, 65, 80, 90, 110],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:THICKFAT,:OWNTEMPO],
	:HiddenAbilities => :GLUTTONY,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 165,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:TEETERDANCE],
		[1,:BELCH],
		[1,:SPLASH],
		[1,:PSYWAVE],
		[1,:ODORSLEUTH],
		[1,:PSYBEAM],
		[7,:PSYWAVE],
		[10,:ODORSLEUTH],
		[14,:PSYBEAM],
		[15,:PSYCHUP],
		[18,:CONFUSERAY],
		[21,:MAGICCOAT],
		[26,:ZENHEADBUTT],
		[29,:POWERGEM],
		[35,:REST],
		[35,:SNORE],
		[42,:PSYSHOCK],
		[46,:PAYBACK],
		[52,:PSYCHIC],
		[60,:BOUNCE]],
	:tmlist => [:SIGNALBEAM,:PAYBACK,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:IRONTAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Purple",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 9,
	:Weight => 715,
	:kind => "Manipulate",
	:dexentry => "Grumpig uses the black pearls on its body to amplify its psychic power for gaining total control over its foe. Its snorting grows labored when doing so.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:SPINDA => {
	:name => "Spinda",
	:dexnum => 327,
	:Type1 => :NORMAL,
	:BaseStats => [60, 60, 60, 60, 60, 60],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:OWNTEMPO,:TANGLEDFEET],
	:HiddenAbilities => :CONTRARY,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 126,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:ASSIST,:BATONPASS,:DISABLE,:ENCORE,:FAKEOUT,:FAKETEARS,:GUARDSPLIT,:ICYWIND,:PSYCHOCUT,:PSYCHOSHIFT,:RAPIDSPIN,:ROLEPLAY,:SMELLINGSALTS,:SPOTLIGHT,:TRICK,:WATERPULSE,:WISH],
	:Moveset => [
		[1,:TACKLE],
		[5,:COPYCAT],
		[10,:FEINTATTACK],
		[14,:PSYBEAM],
		[19,:HYPNOSIS],
		[23,:DIZZYPUNCH],
		[28,:SUCKERPUNCH],
		[32,:TEETERDANCE],
		[37,:UPROAR],
		[41,:PSYCHUP],
		[46,:DOUBLEEDGE],
		[50,:FLAIL],
		[55,:THRASH]],
	:tmlist => [:SUCKERPUNCH,:THIEF,:FLING,:SNATCH,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:MUDSLAP,:ICEPUNCH,:ICYWIND,:LASTRESORT,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:CALMMIND,:MAGICCOAT,:REST,:SKILLSWAP,:TRICK,:TRICKROOM,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:WATERPULSE,:RAINDANCE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Mountain",
	:EggGroups => [:Field,:HumanLike],
	:Height => 11,
	:Weight => 50,
	:kind => "Spot Panda",
	:dexentry => "It is distinguished by a pattern of spots that is always different. Its unsteady, tottering walk has the effect of fouling its foe's aim.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:TRAPINCH => {
	:name => "Trapinch",
	:dexnum => 328,
	:Type1 => :GROUND,
	:BaseStats => [45, 100, 45, 10, 45, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:ARENATRAP],
	:HiddenAbilities => :SHEERFORCE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BUGBITE,:EARTHPOWER,:ENDURE,:FLAIL,:FOCUSENERGY,:FURYCUTTER,:GUST,:MUDSHOT,:QUICKATTACK,:SIGNALBEAM],
	:Moveset => [
		[1,:SANDATTACK],
		[1,:BITE],
		[1,:FEINTATTACK],
		[1,:BIDE],
		[5,:MUDSLAP],
		[8,:BULLDOZE],
		[12,:SANDTOMB],
		[15,:ROCKSLIDE],
		[19,:DIG],
		[22,:CRUNCH],
		[26,:EARTHPOWER],
		[29,:FEINT],
		[33,:EARTHQUAKE],
		[36,:SANDSTORM],
		[40,:SUPERPOWER],
		[43,:HYPERBEAM],
		[47,:FISSURE]],
	:tmlist => [:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:GIGADRAIN,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:CONFIDE,],
	:Color => "Brown",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Bug],
	:Height => 7,
	:Weight => 150,
	:WildItemUncommon => :SOFTSAND,
	:kind => "Ant Pit",
	:dexentry => "Its big jaws crunch through boulders. Because its head is so big, it has a hard time getting back upright if it tips over onto its back.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:VIBRAVA,:Level,35]
	]
},

:VIBRAVA => {
	:name => "Vibrava",
	:dexnum => 329,
	:Type1 => :GROUND,
	:Type2 => :DRAGON,
	:BaseStats => [50, 70, 50, 70, 50, 50],
	:EVs => [0, 1, 0, 1, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 119,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:DRAGONBREATH],
		[1,:SANDATTACK],
		[1,:SONICBOOM],
		[1,:FEINTATTACK],
		[1,:BIDE],
		[5,:MUDSLAP],
		[8,:BULLDOZE],
		[12,:SANDTOMB],
		[15,:ROCKSLIDE],
		[19,:SUPERSONIC],
		[22,:SCREECH],
		[26,:EARTHPOWER],
		[29,:BUGBUZZ],
		[33,:EARTHQUAKE],
		[36,:SANDSTORM],
		[40,:UPROAR],
		[43,:HYPERBEAM],
		[47,:BOOMBURST]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:TWISTER,:SUPERPOWER,:ROCKSMASH,:HEATWAVE,:SUNNYDAY,:FLY,:AIRCUTTER,:DEFOG,:ROOST,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEELWING,:CONFIDE,:THROATCHOP,],
	:Color => "Green",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Bug],
	:Height => 11,
	:Weight => 153,
	:kind => "Vibration",
	:dexentry => "It looses ultrasonic waves by rubbing its wings together. Since a Vibrava's wings are still in the process of growing, it can only fly short distances.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 17,
	:evolutions => [
		[:FLYGON,:Level,45]
	]
},

:FLYGON => {
	:name => "Flygon",
	:dexnum => 330,
	:Type1 => :GROUND,
	:Type2 => :DRAGON,
	:BaseStats => [80, 100, 80, 100, 80, 80],
	:EVs => [0, 1, 0, 2, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 234,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:DRAGONCLAW],
		[1,:DRAGONBREATH],
		[1,:DRAGONDANCE],
		[1,:SANDATTACK],
		[1,:SONICBOOM],
		[1,:FEINTATTACK],
		[1,:BIDE],
		[5,:MUDSLAP],
		[8,:BULLDOZE],
		[12,:SANDTOMB],
		[15,:ROCKSLIDE],
		[19,:SUPERSONIC],
		[22,:SCREECH],
		[26,:EARTHPOWER],
		[29,:DRAGONTAIL],
		[33,:EARTHQUAKE],
		[36,:SANDSTORM],
		[40,:UPROAR],
		[43,:HYPERBEAM],
		[47,:DRAGONRUSH]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:TWISTER,:THUNDERPUNCH,:SUPERPOWER,:ROCKSMASH,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:IRONTAIL,:STEELWING,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:LASERFOCUS,:THROATCHOP,],
	:Color => "Green",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Bug],
	:Height => 20,
	:Weight => 820,
	:kind => "Mystic",
	:dexentry => "The flapping of its wings sounds like singing. To prevent detection by enemies, it hides itself by flapping up a cloud of desert sand.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 9,
},

:CACNEA => {
	:name => "Cacnea",
	:dexnum => 331,
	:Type1 => :GRASS,
	:BaseStats => [50, 85, 40, 35, 85, 40],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:SANDVEIL,:WATERABSORB],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 67,
	:CatchRate => 190,
	:Happiness => 35,
	:EggSteps => 5355,
	:EggMoves => [:ACID,:BELCH,:BLOCK,:COUNTER,:DISABLE,:DYNAMICPUNCH,:FELLSTINGER,:GRASSWHISTLE,:LOWKICK,:MAGICALLEAF,:NASTYPLOT,:POWERUPPUNCH,:ROTOTILLER,:SEEDBOMB,:SMELLINGSALTS,:SWITCHEROO,:TEETERDANCE,:WORRYSEED],
	:Moveset => [
		[1,:POISONSTING],
		[1,:LEER],
		[4,:ABSORB],
		[7,:GROWTH],
		[10,:LEECHSEED],
		[13,:SANDATTACK],
		[16,:NEEDLEARM],
		[19,:FEINTATTACK],
		[22,:INGRAIN],
		[26,:PAYBACK],
		[30,:SPIKES],
		[34,:SUCKERPUNCH],
		[38,:PINMISSILE],
		[42,:ENERGYBALL],
		[46,:COTTONSPORE],
		[50,:SANDSTORM],
		[54,:DESTINYBOND]],
	:tmlist => [:FURYCUTTER,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:FLING,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:LOWKICK,:SUNNYDAY,:SPITE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:VENOSHOCK,:TOXIC,:MAGICCOAT,:REST,:SANDSTORM,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Green",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Grass,:HumanLike],
	:Height => 4,
	:Weight => 513,
	:WildItemUncommon => :STICKYBARB,
	:kind => "Cactus",
	:dexentry => "Cacnea live in deserts with virtually no rainfall. It battles by swinging its thick, spiked arms. Once a year, a yellow flower blooms.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CACTURNE,:Level,32]
	]
},

:CACTURNE => {
	:name => "Cacturne",
	:dexnum => 332,
	:Type1 => :GRASS,
	:Type2 => :DARK,
	:BaseStats => [70, 115, 60, 55, 115, 60],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:SANDVEIL,:WATERABSORB],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 60,
	:Happiness => 35,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SPIKYSHIELD],
		[1,:DESTINYBOND],
		[1,:REVENGE],
		[1,:POISONSTING],
		[1,:LEER],
		[1,:ABSORB],
		[1,:GROWTH],
		[4,:ABSORB],
		[7,:GROWTH],
		[10,:LEECHSEED],
		[13,:SANDATTACK],
		[16,:NEEDLEARM],
		[19,:FEINTATTACK],
		[22,:INGRAIN],
		[26,:PAYBACK],
		[30,:SPIKES],
		[35,:SUCKERPUNCH],
		[38,:PINMISSILE],
		[44,:ENERGYBALL],
		[49,:COTTONSPORE],
		[54,:SANDSTORM],
		[59,:DESTINYBOND]],
	:tmlist => [:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:FLING,:EMBARGO,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:LOWKICK,:SUNNYDAY,:SPITE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:VENOSHOCK,:TOXIC,:MAGICCOAT,:REST,:SANDSTORM,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Green",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Grass,:HumanLike],
	:Height => 13,
	:Weight => 774,
	:WildItemUncommon => :STICKYBARB,
	:kind => "Scarecrow",
	:dexentry => "After spending thousands of years in harsh deserts, its blood transformed into the same substances as sand. It is nocturnal, so it hunts at night.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
},

:SWABLU => {
	:name => "Swablu",
	:dexnum => 333,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [45, 40, 60, 50, 40, 75],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:NATURALCURE,:CLOUDNINE],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 62,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:DRAGONRUSH,:FEATHERDANCE,:HAZE,:HYPERVOICE,:PLAYROUGH,:POWERSWAP,:PURSUIT,:RAGE,:ROOST,:STEELWING],
	:Moveset => [
		[1,:PECK],
		[1,:GROWL],
		[3,:ASTONISH],
		[5,:SING],
		[7,:FURYATTACK],
		[9,:SAFEGUARD],
		[11,:DISARMINGVOICE],
		[14,:MIST],
		[17,:ROUND],
		[20,:NATURALGIFT],
		[23,:TAKEDOWN],
		[26,:REFRESH],
		[30,:MIRRORMOVE],
		[34,:COTTONGUARD],
		[38,:DRAGONPULSE],
		[42,:PERISHSONG],
		[46,:MOONBLAST]],
	:tmlist => [:THIEF,:OUTRAGE,:DRAGONPULSE,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:MUDSLAP,:ICEBEAM,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HEALBELL,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:REST,:STEELWING,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Blue",
	:Habitat => "Forest",
	:EggGroups => [:Flying,:Dragon],
	:Height => 4,
	:Weight => 12,
	:kind => "Cotton Bird",
	:dexentry => "A Pokémon that has wings like cottony clouds. After enduring winter, in which little food is available, Swablu flocks move closer to towns in the spring.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 17,
	:evolutions => [
		[:ALTARIA,:Level,35]
	]
},

:ALTARIA => {
	:name => "Altaria",
	:dexnum => 334,
	:Type1 => :DRAGON,
	:Type2 => :FLYING,
	:BaseStats => [75, 70, 90, 80, 70, 105],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:NATURALCURE,:CLOUDNINE],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 172,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:DRAGONBREATH],
		[1,:SKYATTACK],
		[1,:PLUCK],
		[1,:PECK],
		[1,:GROWL],
		[1,:ASTONISH],
		[1,:SING],
		[3,:ASTONISH],
		[5,:SING],
		[7,:FURYATTACK],
		[9,:SAFEGUARD],
		[11,:DISARMINGVOICE],
		[14,:MIST],
		[17,:ROUND],
		[20,:NATURALGIFT],
		[23,:TAKEDOWN],
		[26,:REFRESH],
		[30,:DRAGONDANCE],
		[34,:COTTONGUARD],
		[40,:DRAGONPULSE],
		[46,:PERISHSONG],
		[52,:MOONBLAST],
		[59,:SKYATTACK]],
	:tmlist => [:THIEF,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:TWISTER,:ROCKSMASH,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEBEAM,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HEALBELL,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:REST,:WONDERROOM,:IRONTAIL,:STEELWING,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Blue",
	:Habitat => "Forest",
	:EggGroups => [:Flying,:Dragon],
	:Height => 11,
	:Weight => 206,
	:kind => "Humming",
	:dexentry => "It hums in a beautiful soprano voice. It flies among white clouds in the blue sky. It launches intensely hot fireballs from its mouth.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 15,
},

:ZANGOOSE => {
	:name => "Zangoose",
	:dexnum => 335,
	:Type1 => :NORMAL,
	:BaseStats => [73, 115, 60, 90, 60, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:IMMUNITY,:TOXICBOOST],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 160,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BELLYDRUM,:COUNTER,:CURSE,:DISABLE,:DOUBLEHIT,:DOUBLEKICK,:FEINT,:FINALGAMBIT,:FLAIL,:FURYSWIPES,:IRONTAIL,:METALCLAW,:NIGHTSLASH,:QUICKGUARD,:RAZORWIND],
	:Moveset => [
		[1,:SCRATCH],
		[1,:LEER],
		[5,:QUICKATTACK],
		[8,:FURYCUTTER],
		[12,:PURSUIT],
		[15,:HONECLAWS],
		[19,:SLASH],
		[22,:REVENGE],
		[26,:CRUSHCLAW],
		[29,:FALSESWIPE],
		[33,:EMBARGO],
		[36,:DETECT],
		[40,:XSCISSOR],
		[43,:TAUNT],
		[47,:SWORDSDANCE],
		[50,:CLOSECOMBAT]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LASTRESORT,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:THROATCHOP,],
	:Color => "White",
	:Habitat => "Grassland",
	:EggGroups => [:Field],
	:Height => 13,
	:Weight => 403,
	:WildItemUncommon => :QUICKCLAW,
	:kind => "Cat Ferret",
	:dexentry => "When it battles, it stands on its hind legs and attacks with its sharply clawed forelegs. Its fur bristles if it encounters any Seviper.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:SEVIPER => {
	:name => "Seviper",
	:dexnum => 336,
	:Type1 => :POISON,
	:BaseStats => [73, 100, 60, 65, 100, 60],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:SHEDSKIN,:INFILTRATOR],
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 160,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ASSURANCE,:BODYSLAM,:FINALGAMBIT,:IRONTAIL,:NIGHTSLASH,:PUNISHMENT,:SCARYFACE,:SPITUP,:STOCKPILE,:SWALLOW,:SWITCHEROO,:WRINGOUT],
	:Moveset => [
		[1,:WRAP],
		[1,:SWAGGER],
		[4,:BITE],
		[6,:LICK],
		[9,:POISONTAIL],
		[11,:FEINT],
		[14,:SCREECH],
		[16,:VENOSHOCK],
		[19,:GLARE],
		[21,:POISONFANG],
		[24,:VENOMDRENCH],
		[26,:NIGHTSLASH],
		[29,:GASTROACID],
		[31,:POISONJAB],
		[34,:HAZE],
		[36,:SWORDSDANCE],
		[39,:CRUNCH],
		[41,:BELCH],
		[44,:COIL],
		[46,:WRINGOUT]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:SNATCH,:TAUNT,:DRAGONTAIL,:ROCKSMASH,:FLAMETHROWER,:SUNNYDAY,:GIGADRAIN,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:INFESTATION,:BRUTALSWING,:THROATCHOP,],
	:Color => "Black",
	:Habitat => "Grassland",
	:EggGroups => [:Field,:Dragon],
	:Height => 27,
	:Weight => 525,
	:WildItemUncommon => :SHEDSHELL,
	:kind => "Fang Snake",
	:dexentry => "Seviper and Zangoose are eternal rivals. It counters a Zangoose's incredible agility with its swordlike tail, which also oozes a horrible poison.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:LUNATONE => {
	:name => "Lunatone",
	:dexnum => 337,
	:Type1 => :ROCK,
	:Type2 => :PSYCHIC,
	:BaseStats => [90, 55, 65, 70, 95, 85],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Fast",
	:GenderRatio => "Genderless",
	:BaseEXP => 154,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:POWERGEM],
		[1,:PSYSHOCK],
		[1,:MOONBLAST],
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:CONFUSION],
		[1,:ROCKTHROW],
		[5,:HYPNOSIS],
		[9,:ROCKPOLISH],
		[13,:PSYWAVE],
		[17,:EMBARGO],
		[21,:ROCKSLIDE],
		[25,:COSMICPOWER],
		[29,:PSYCHIC],
		[33,:HEALBLOCK],
		[37,:STONEEDGE],
		[41,:FUTURESIGHT],
		[45,:EXPLOSION],
		[49,:MAGICROOM]],
	:tmlist => [:SIGNALBEAM,:EMBARGO,:CHARGEBEAM,:ACROBATICS,:SHADOWBALL,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICKROOM,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:GYROBALL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Yellow",
	:Habitat => "Cave",
	:EggGroups => [:Mineral],
	:Height => 10,
	:Weight => 1680,
	:WildItemCommon => :STARDUST,
	:WildItemUncommon => :MOONSTONE,
	:kind => "Meteorite",
	:dexentry => "It becomes very active on the night of a full moon. This Pokémon was first discovered 40 years ago at the site of a meteor strike.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 14,
},

:SOLROCK => {
	:name => "Solrock",
	:dexnum => 338,
	:Type1 => :ROCK,
	:Type2 => :PSYCHIC,
	:BaseStats => [90, 95, 85, 70, 55, 65],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Fast",
	:GenderRatio => "Genderless",
	:BaseEXP => 154,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:FLAREBLITZ],
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:CONFUSION],
		[1,:ROCKTHROW],
		[5,:FIRESPIN],
		[9,:ROCKPOLISH],
		[13,:PSYWAVE],
		[17,:EMBARGO],
		[21,:ROCKSLIDE],
		[25,:COSMICPOWER],
		[29,:PSYCHIC],
		[33,:HEALBLOCK],
		[37,:STONEEDGE],
		[41,:SOLARBEAM],
		[45,:EXPLOSION],
		[49,:WONDERROOM]],
	:tmlist => [:SIGNALBEAM,:EMBARGO,:CHARGEBEAM,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:SUNNYDAY,:WILLOWISP,:ACROBATICS,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICKROOM,:WONDERROOM,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:GYROBALL,:IRONDEFENSE,:CONFIDE,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Red",
	:Habitat => "Cave",
	:EggGroups => [:Mineral],
	:Height => 12,
	:Weight => 1540,
	:WildItemCommon => :STARDUST,
	:WildItemUncommon => :SUNSTONE,
	:kind => "Meteorite",
	:dexentry => "Solar energy is the source of this Pokémon's power. On sunny days, groups of Solrock line up facing the sun and absorb its light.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 13,
},

:BARBOACH => {
	:name => "Barboach",
	:dexnum => 339,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [50, 48, 43, 60, 46, 41],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:OBLIVIOUS,:ANTICIPATION],
	:HiddenAbilities => :HYDRATION,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:DRAGONDANCE,:EARTHPOWER,:FLAIL,:HYDROPUMP,:MUDSHOT,:MUDDYWATER,:SPARK,:TAKEDOWN,:THRASH,:WHIRLPOOL],
	:Moveset => [
		[1,:MUDSLAP],
		[6,:MUDSPORT],
		[6,:WATERSPORT],
		[9,:WATERGUN],
		[13,:MUDBOMB],
		[15,:AMNESIA],
		[17,:WATERPULSE],
		[20,:MAGNITUDE],
		[25,:REST],
		[25,:SNORE],
		[28,:AQUATAIL],
		[32,:EARTHQUAKE],
		[35,:MUDDYWATER],
		[39,:FUTURESIGHT],
		[44,:FISSURE]],
	:tmlist => [:BOUNCE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKTOMB,:SANDSTORM,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water2],
	:Height => 4,
	:Weight => 19,
	:kind => "Whiskers",
	:dexentry => "Its body is covered with a slimy film. The film acts as a barrier to prevent germs in muddy water from entering the Barboach's body.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 12,
	:evolutions => [
		[:WHISCASH,:Level,30]
	]
},

:WHISCASH => {
	:name => "Whiscash",
	:dexnum => 340,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [110, 78, 73, 60, 76, 71],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:OBLIVIOUS,:ANTICIPATION],
	:HiddenAbilities => :HYDRATION,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 164,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:THRASH],
		[1,:BELCH],
		[1,:ZENHEADBUTT],
		[1,:TICKLE],
		[1,:MUDSLAP],
		[1,:MUDSPORT],
		[1,:WATERSPORT],
		[1,:WATERGUN],
		[6,:MUDSPORT],
		[6,:WATERSPORT],
		[9,:WATERGUN],
		[13,:MUDBOMB],
		[15,:AMNESIA],
		[17,:WATERPULSE],
		[20,:MAGNITUDE],
		[25,:REST],
		[25,:SNORE],
		[28,:AQUATAIL],
		[34,:EARTHQUAKE],
		[39,:MUDDYWATER],
		[45,:FUTURESIGHT],
		[52,:FISSURE]],
	:tmlist => [:ROCKSMASH,:BOUNCE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water2],
	:Height => 9,
	:Weight => 236,
	:kind => "Whiskers",
	:dexentry => "It can foretell earthquakes. In the daytime, it sleeps in mud at the bottom of a pond. When it awakens, it continually feeds throughout the night.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 10,
},

:CORPHISH => {
	:name => "Corphish",
	:dexnum => 341,
	:Type1 => :WATER,
	:BaseStats => [43, 80, 65, 35, 50, 35],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:SHELLARMOR],
	:HiddenAbilities => :ADAPTABILITY,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 62,
	:CatchRate => 205,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:ANCIENTPOWER,:AQUAJET,:BODYSLAM,:CHIPAWAY,:DOUBLEEDGE,:DRAGONDANCE,:ENDEAVOR,:KNOCKOFF,:METALCLAW,:MUDSPORT,:SUPERPOWER,:SWITCHEROO,:TRUMPCARD],
	:Moveset => [
		[1,:BUBBLE],
		[5,:HARDEN],
		[7,:VICEGRIP],
		[10,:LEER],
		[14,:BUBBLEBEAM],
		[17,:PROTECT],
		[20,:DOUBLEHIT],
		[23,:KNOCKOFF],
		[26,:NIGHTSLASH],
		[31,:RAZORSHELL],
		[34,:TAUNT],
		[37,:SWORDSDANCE],
		[39,:CRUNCH],
		[43,:CRABHAMMER],
		[48,:GUILLOTINE]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:AERIALACE,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:IRONDEFENSE,:SURF,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Red",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Water3],
	:Height => 6,
	:Weight => 115,
	:kind => "Ruffian",
	:dexentry => "Once it grips prey with its large pincers, it will never let go, no matter what. It is a hardy Pokémon that can thrive in any environment.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CRAWDAUNT,:Level,30]
	]
},

:CRAWDAUNT => {
	:name => "Crawdaunt",
	:dexnum => 342,
	:Type1 => :WATER,
	:Type2 => :DARK,
	:BaseStats => [63, 120, 85, 55, 90, 55],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:SHELLARMOR],
	:HiddenAbilities => :ADAPTABILITY,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 164,
	:CatchRate => 155,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:SWIFT],
		[1,:BUBBLE],
		[1,:HARDEN],
		[1,:VICEGRIP],
		[1,:LEER],
		[5,:HARDEN],
		[7,:VICEGRIP],
		[10,:LEER],
		[14,:BUBBLEBEAM],
		[17,:PROTECT],
		[20,:DOUBLEHIT],
		[23,:KNOCKOFF],
		[26,:NIGHTSLASH],
		[32,:RAZORSHELL],
		[36,:TAUNT],
		[40,:SWORDSDANCE],
		[43,:CRUNCH],
		[48,:CRABHAMMER],
		[54,:GUILLOTINE]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:DARKPULSE,:SNARL,:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:AERIALACE,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:IRONDEFENSE,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Red",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Water3],
	:Height => 11,
	:Weight => 328,
	:kind => "Rogue",
	:dexentry => "A brutish Pokémon that loves to battle. A veteran Crawdaunt that has prevailed in hundreds of battles has giant pincers marked with countless scars.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:BALTOY => {
	:name => "Baltoy",
	:dexnum => 343,
	:Type1 => :GROUND,
	:Type2 => :PSYCHIC,
	:BaseStats => [40, 40, 55, 55, 40, 70],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 60,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:HARDEN],
		[1,:CONFUSION],
		[4,:RAPIDSPIN],
		[7,:MUDSLAP],
		[10,:HEALBLOCK],
		[13,:ROCKTOMB],
		[16,:PSYBEAM],
		[19,:ANCIENTPOWER],
		[22,:COSMICPOWER],
		[25,:POWERTRICK],
		[28,:SELFDESTRUCT],
		[31,:EXTRASENSORY],
		[34,:GUARDSPLIT],
		[34,:POWERSPLIT],
		[37,:EARTHPOWER],
		[40,:SANDSTORM],
		[43,:IMPRISON],
		[46,:EXPLOSION]],
	:tmlist => [:SIGNALBEAM,:CHARGEBEAM,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:ICEBEAM,:EXPLOSION,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:GYROBALL,:RAINDANCE,],
	:Color => "Brown",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Mineral],
	:Height => 5,
	:Weight => 215,
	:WildItemUncommon => :LIGHTCLAY,
	:kind => "Clay Doll",
	:dexentry => "A Baltoy moves by spinning on its single foot. It has been depicted in murals adorning the walls of a once-bustling city in an ancient age.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 11,
	:evolutions => [
		[:CLAYDOL,:Level,36]
	]
},

:CLAYDOL => {
	:name => "Claydol",
	:dexnum => 344,
	:Type1 => :GROUND,
	:Type2 => :PSYCHIC,
	:BaseStats => [60, 70, 105, 75, 70, 120],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 175,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:HYPERBEAM],
		[1,:TELEPORT],
		[1,:HARDEN],
		[1,:CONFUSION],
		[1,:RAPIDSPIN],
		[4,:RAPIDSPIN],
		[7,:MUDSLAP],
		[10,:HEALBLOCK],
		[13,:ROCKTOMB],
		[16,:PSYBEAM],
		[19,:ANCIENTPOWER],
		[22,:COSMICPOWER],
		[25,:POWERTRICK],
		[28,:SELFDESTRUCT],
		[31,:EXTRASENSORY],
		[34,:GUARDSPLIT],
		[34,:POWERSPLIT],
		[40,:EARTHPOWER],
		[46,:SANDSTORM],
		[52,:IMPRISON],
		[58,:EXPLOSION]],
	:tmlist => [:SIGNALBEAM,:CHARGEBEAM,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:ICEBEAM,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:GYROBALL,:RAINDANCE,],
	:Color => "Black",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Mineral],
	:Height => 15,
	:Weight => 1080,
	:WildItemUncommon => :LIGHTCLAY,
	:kind => "Clay Doll",
	:dexentry => "A Claydol sleeps while hovering in midair. Its arms are separate from its body. They are kept floating by the Pokémon's manipulation of psychic power.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 11,
},

:LILEEP => {
	:name => "Lileep",
	:dexnum => 345,
	:Type1 => :ROCK,
	:Type2 => :GRASS,
	:BaseStats => [66, 41, 77, 23, 61, 87],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:SUCTIONCUPS,:STORMDRAIN],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemEighth",
	:BaseEXP => 71,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:BARRIER,:CURSE,:ENDURE,:MEGADRAIN,:MIRRORCOAT,:RECOVER,:STEALTHROCK,:TICKLE,:WRINGOUT],
	:Moveset => [
		[1,:ASTONISH],
		[1,:CONSTRICT],
		[5,:ACID],
		[9,:INGRAIN],
		[13,:CONFUSERAY],
		[17,:ANCIENTPOWER],
		[21,:BRINE],
		[26,:GIGADRAIN],
		[31,:GASTROACID],
		[36,:AMNESIA],
		[41,:ENERGYBALL],
		[46,:STOCKPILE],
		[46,:SWALLOW],
		[46,:SPITUP],
		[52,:WRINGOUT]],
	:tmlist => [:STRINGSHOT,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHPOWER,:MUDSLAP,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:GASTROACID,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:CONFIDE,:INFESTATION,],
	:Color => "Purple",
	:Habitat => "Sea",
	:EggGroups => [:Water3],
	:Height => 10,
	:Weight => 238,
	:WildItemUncommon => :BIGROOT,
	:kind => "Sea Lily",
	:dexentry => "It disguises itself as seaweed by swaying its tentacles. Unsuspecting prey that comes too close is swallowed whole.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CRADILY,:Level,40]
	]
},

:CRADILY => {
	:name => "Cradily",
	:dexnum => 346,
	:Type1 => :ROCK,
	:Type2 => :GRASS,
	:BaseStats => [86, 81, 97, 43, 81, 107],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:SUCTIONCUPS,:STORMDRAIN],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemEighth",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:Moveset => [
		[1,:WRINGOUT],
		[1,:ASTONISH],
		[1,:CONSTRICT],
		[1,:ACID],
		[1,:INGRAIN],
		[5,:ACID],
		[9,:INGRAIN],
		[13,:CONFUSERAY],
		[17,:ANCIENTPOWER],
		[21,:BRINE],
		[26,:GIGADRAIN],
		[31,:GASTROACID],
		[36,:AMNESIA],
		[44,:ENERGYBALL],
		[52,:STOCKPILE],
		[52,:SWALLOW],
		[52,:SPITUP],
		[61,:WRINGOUT]],
	:tmlist => [:STRINGSHOT,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEWAVE,:SLUDGEBOMB,:GASTROACID,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:CONFIDE,:INFESTATION,],
	:Color => "Green",
	:Habitat => "Sea",
	:EggGroups => [:Water3],
	:Height => 15,
	:Weight => 604,
	:WildItemUncommon => :BIGROOT,
	:kind => "Barnacle",
	:dexentry => "It drags its heavy body along the seafloor. It makes its nest in the shallows of warm seas. Cradily can be seen on beaches when the tide goes out.",
	:BattlerPlayerY => 7,
	:BattlerEnemyY => 3,
	:BattlerAltitude => 0,
},

:ANORITH => {
	:name => "Anorith",
	:dexnum => 347,
	:Type1 => :ROCK,
	:Type2 => :BUG,
	:BaseStats => [45, 95, 50, 75, 40, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:BATTLEARMOR,:SWIFTSWIM],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemEighth",
	:BaseEXP => 71,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:AQUAJET,:CROSSPOISON,:CURSE,:IRONDEFENSE,:KNOCKOFF,:RAPIDSPIN,:SANDATTACK,:SCREECH,:WATERPULSE],
	:Moveset => [
		[1,:SCRATCH],
		[1,:HARDEN],
		[4,:MUDSPORT],
		[7,:WATERGUN],
		[10,:FURYCUTTER],
		[13,:SMACKDOWN],
		[17,:METALCLAW],
		[21,:ANCIENTPOWER],
		[25,:BUGBITE],
		[29,:BRINE],
		[34,:SLASH],
		[39,:CRUSHCLAW],
		[44,:XSCISSOR],
		[49,:PROTECT],
		[55,:ROCKBLAST]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:STRINGSHOT,:KNOCKOFF,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:EARTHPOWER,:MUDSLAP,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONDEFENSE,:WATERPULSE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water3],
	:Height => 7,
	:Weight => 125,
	:kind => "Old Shrimp",
	:dexentry => "It was resurrected from a fossil. Anorith swims by undulating the eight wings at its sides. They were feet that adapted to life in the sea.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 32,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ARMALDO,:Level,40]
	]
},

:ARMALDO => {
	:name => "Armaldo",
	:dexnum => 348,
	:Type1 => :ROCK,
	:Type2 => :BUG,
	:BaseStats => [75, 125, 100, 45, 70, 80],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:BATTLEARMOR,:SWIFTSWIM],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemEighth",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:Moveset => [
		[1,:SCRATCH],
		[1,:HARDEN],
		[1,:MUDSPORT],
		[1,:WATERGUN],
		[4,:MUDSPORT],
		[7,:WATERGUN],
		[10,:FURYCUTTER],
		[13,:SMACKDOWN],
		[17,:METALCLAW],
		[21,:ANCIENTPOWER],
		[25,:BUGBITE],
		[29,:BRINE],
		[34,:SLASH],
		[39,:CRUSHCLAW],
		[46,:XSCISSOR],
		[53,:PROTECT],
		[61,:ROCKBLAST]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:STRINGSHOT,:KNOCKOFF,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:AERIALACE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONDEFENSE,:AQUATAIL,:WATERPULSE,:CONFIDE,:BRUTALSWING,:LIQUIDATION,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water3],
	:Height => 15,
	:Weight => 682,
	:kind => "Plate",
	:dexentry => "Armaldo usually lives on land. However, when it hunts for prey, it dives beneath the ocean. It swims around using its two large wings.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:FEEBAS => {
	:name => "Feebas",
	:dexnum => 349,
	:Type1 => :WATER,
	:BaseStats => [20, 15, 20, 80, 10, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SWIFTSWIM,:OBLIVIOUS],
	:HiddenAbilities => :ADAPTABILITY,
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 40,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:BRINE,:CAPTIVATE,:CONFUSERAY,:DRAGONBREATH,:DRAGONPULSE,:HAZE,:HYPNOSIS,:IRONTAIL,:MIRRORCOAT,:MIST,:MUDSPORT,:TICKLE],
	:Moveset => [
		[1,:SPLASH],
		[15,:TACKLE],
		[30,:FLAIL]],
	:tmlist => [:DRAGONPULSE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,],
	:Color => "Brown",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Dragon],
	:Height => 6,
	:Weight => 74,
	:kind => "Fish",
	:dexentry => "Feebas live in ponds that are heavily infested with weeds. Because of its hopelessly shabby appearance, it seems as if few Trainers raise it.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 12,
	:evolutions => [
		[:MILOTIC,:TradeItem,:PRISMSCALE]
	]
},

:MILOTIC => {
	:name => "Milotic",
	:dexnum => 350,
	:Type1 => :WATER,
	:BaseStats => [95, 60, 79, 81, 100, 125],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:MARVELSCALE,:COMPETITIVE],
	:HiddenAbilities => :CUTECHARM,
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 189,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:WATERPULSE],
		[1,:WRAP],
		[1,:WATERGUN],
		[1,:WATERSPORT],
		[1,:REFRESH],
		[4,:WATERSPORT],
		[7,:REFRESH],
		[11,:DISARMINGVOICE],
		[14,:TWISTER],
		[17,:AQUARING],
		[21,:CAPTIVATE],
		[24,:DRAGONTAIL],
		[27,:RECOVER],
		[31,:AQUATAIL],
		[34,:ATTRACT],
		[37,:SAFEGUARD],
		[41,:COIL],
		[44,:HYDROPUMP],
		[47,:RAINDANCE]],
	:tmlist => [:DRAGONPULSE,:DRAGONTAIL,:TWISTER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLEPLAY,:IRONTAIL,:IRONHEAD,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:BRUTALSWING,:LASERFOCUS,],
	:Color => "Pink",
	:Habitat => "WatersEdge",
	:EggGroups => [:Water1,:Dragon],
	:Height => 62,
	:Weight => 1620,
	:kind => "Tender",
	:dexentry => "It is said to live at the bottom of large lakes. Considered to be the most beautiful of all Pokémon, it has been depicted in paintings and statues.",
	:BattlerPlayerY => 10,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 3,
},

:CASTFORM => {
	:name => "Castform",
	:dexnum => 351,
	:Type1 => :NORMAL,
	:BaseStats => [70, 70, 70, 70, 70, 70],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:FORECAST],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 147,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:AMNESIA,:CLEARSMOG,:COSMICPOWER,:DISABLE,:FUTURESIGHT,:GUARDSWAP,:HEX,:LUCKYCHANT,:OMINOUSWIND,:REFLECTTYPE],
	:Moveset => [
		[1,:TACKLE],
		[10,:WATERGUN],
		[10,:EMBER],
		[10,:POWDERSNOW],
		[15,:HEADBUTT],
		[20,:RAINDANCE],
		[20,:SUNNYDAY],
		[20,:HAIL],
		[25,:WEATHERBALL],
		[35,:HYDROPUMP],
		[35,:FIREBLAST],
		[35,:BLIZZARD],
		[45,:HURRICANE]],
	:tmlist => [:THIEF,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:DEFOG,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:LASTRESORT,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:SANDSTORM,:SCALD,:WATERPULSE,:RAINDANCE,],
	:Color => "White",
	:Habitat => "Grassland",
	:EggGroups => [:Fairy,:Amorphous],
	:Height => 3,
	:Weight => 8,
	:WildItemCommon => :MYSTICWATER,
	:WildItemUncommon => :MYSTICWATER,
	:WildItemRare => :MYSTICWATER,
	:kind => "Weather",
	:dexentry => "It alters its form depending on the weather. Changes in the climate such as the temperature and humidity appear to affect its cellular structure.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 18,
},

:KECLEON => {
	:name => "Kecleon",
	:dexnum => 352,
	:Type1 => :NORMAL,
	:BaseStats => [60, 90, 70, 40, 60, 120],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:COLORCHANGE,:PROTEAN],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 154,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CAMOUFLAGE,:DISABLE,:DIZZYPUNCH,:FAKEOUT,:FOULPLAY,:MAGICCOAT,:NASTYPLOT,:POWERUPPUNCH,:RECOVER,:SKILLSWAP,:SNATCH,:TRICK],
	:Moveset => [
		[1,:THIEF],
		[1,:TAILWHIP],
		[1,:ASTONISH],
		[1,:LICK],
		[1,:SCRATCH],
		[4,:BIND],
		[7,:SHADOWSNEAK],
		[10,:FEINT],
		[13,:FURYSWIPES],
		[16,:FEINTATTACK],
		[18,:PSYBEAM],
		[21,:ANCIENTPOWER],
		[25,:SLASH],
		[30,:CAMOUFLAGE],
		[33,:SHADOWCLAW],
		[38,:SCREECH],
		[42,:SUBSTITUTE],
		[46,:SUCKERPUNCH],
		[50,:SYNCHRONOISE]],
	:tmlist => [:FURYCUTTER,:FOULPLAY,:SUCKERPUNCH,:THIEF,:KNOCKOFF,:FLING,:SNATCH,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:LOWKICK,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LASTRESORT,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:MAGICCOAT,:REST,:ROLEPLAY,:SKILLSWAP,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 220,
	:kind => "Color Swap",
	:dexentry => "A Pokémon that has the ability to alter its body colors to match its surroundings. A Kecleon reverts to its original colors if it is startled.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:SHUPPET => {
	:name => "Shuppet",
	:dexnum => 353,
	:Type1 => :GHOST,
	:BaseStats => [44, 75, 35, 45, 63, 33],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:INSOMNIA,:FRISK],
	:HiddenAbilities => :CURSEDBODY,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 59,
	:CatchRate => 225,
	:Happiness => 35,
	:EggSteps => 6630,
	:EggMoves => [:ASTONISH,:CONFUSERAY,:DESTINYBOND,:DISABLE,:FORESIGHT,:GUNKSHOT,:IMPRISON,:OMINOUSWIND,:PHANTOMFORCE,:PURSUIT,:SHADOWSNEAK],
	:Moveset => [
		[1,:KNOCKOFF],
		[4,:SCREECH],
		[7,:NIGHTSHADE],
		[10,:SPITE],
		[13,:SHADOWSNEAK],
		[16,:WILLOWISP],
		[19,:FEINTATTACK],
		[22,:HEX],
		[26,:CURSE],
		[30,:SHADOWBALL],
		[34,:EMBARGO],
		[38,:SUCKERPUNCH],
		[42,:SNATCH],
		[46,:GRUDGE],
		[50,:TRICK],
		[54,:PHANTOMFORCE]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:OMINOUSWIND,:SPITE,:ICYWIND,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:MAGICCOAT,:MAGICROOM,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Black",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 6,
	:Weight => 23,
	:WildItemUncommon => :SPELLTAG,
	:kind => "Puppet",
	:dexentry => "This Pokémon roams about deep in the night seeking such negative emotions as grudges and envy. It retreats to its nest when the sun begins to rise.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 17,
	:evolutions => [
		[:BANETTE,:Level,37]
	]
},

:BANETTE => {
	:name => "Banette",
	:dexnum => 354,
	:Type1 => :GHOST,
	:BaseStats => [64, 115, 65, 65, 83, 63],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INSOMNIA,:FRISK],
	:HiddenAbilities => :CURSEDBODY,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 159,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 6630,
	:Moveset => [
		[1,:PHANTOMFORCE],
		[1,:KNOCKOFF],
		[1,:SCREECH],
		[1,:NIGHTSHADE],
		[1,:SPITE],
		[4,:SCREECH],
		[7,:NIGHTSHADE],
		[10,:SPITE],
		[13,:SHADOWSNEAK],
		[16,:WILLOWISP],
		[19,:FEINTATTACK],
		[22,:HEX],
		[26,:CURSE],
		[30,:SHADOWBALL],
		[34,:EMBARGO],
		[40,:SUCKERPUNCH],
		[46,:SNATCH],
		[52,:GRUDGE],
		[58,:TRICK],
		[64,:PHANTOMFORCE]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SHADOWCLAW,:OMINOUSWIND,:SPITE,:MUDSLAP,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:MAGICCOAT,:MAGICROOM,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:INFESTATION,:THROATCHOP,],
	:Color => "Black",
	:Habitat => "Urban",
	:EggGroups => [:Amorphous],
	:Height => 11,
	:Weight => 125,
	:WildItemUncommon => :SPELLTAG,
	:kind => "Marionette",
	:dexentry => "An abandoned plush doll became this Pokémon. They are said to live in garbage dumps and wander about in search of the children that threw them away.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:DUSKULL => {
	:name => "Duskull",
	:dexnum => 355,
	:Type1 => :GHOST,
	:BaseStats => [20, 40, 90, 25, 30, 90],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:LEVITATE,:FRISK],
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 59,
	:CatchRate => 190,
	:Happiness => 35,
	:EggSteps => 6630,
	:EggMoves => [:DARKPULSE,:DESTINYBOND,:FEINTATTACK,:GRUDGE,:HAZE,:IMPRISON,:MEMENTO,:OMINOUSWIND,:PAINSPLIT,:SKILLSWAP],
	:Moveset => [
		[1,:LEER],
		[1,:NIGHTSHADE],
		[6,:DISABLE],
		[9,:ASTONISH],
		[14,:FORESIGHT],
		[17,:SHADOWSNEAK],
		[22,:PURSUIT],
		[25,:WILLOWISP],
		[30,:CONFUSERAY],
		[33,:CURSE],
		[38,:HEX],
		[41,:SHADOWBALL],
		[46,:MEANLOOK],
		[49,:PAYBACK],
		[54,:FUTURESIGHT]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:CHARGEBEAM,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:OMINOUSWIND,:SPITE,:BLIZZARD,:ICEBEAM,:ICYWIND,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:GRAVITY,:REST,:SKILLSWAP,:TELEKINESIS,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Black",
	:Habitat => "Forest",
	:EggGroups => [:Amorphous],
	:Height => 8,
	:Weight => 150,
	:WildItemUncommon => :SPELLTAG,
	:kind => "Requiem",
	:dexentry => "A glare from its single scarlet eye makes even burly grown-ups freeze in fear. It is a nocturnal Pokémon that roams about under the cloak of darkness.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 11,
	:evolutions => [
		[:DUSCLOPS,:Level,37]
	]
},

:DUSCLOPS => {
	:name => "Dusclops",
	:dexnum => 356,
	:Type1 => :GHOST,
	:BaseStats => [40, 70, 130, 25, 60, 130],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:PRESSURE,:FRISK],
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 159,
	:CatchRate => 90,
	:Happiness => 35,
	:EggSteps => 6630,
	:Moveset => [
		[0,:SHADOWPUNCH],
		[1,:FUTURESIGHT],
		[1,:FIREPUNCH],
		[1,:ICEPUNCH],
		[1,:THUNDERPUNCH],
		[1,:GRAVITY],
		[1,:BIND],
		[1,:LEER],
		[1,:NIGHTSHADE],
		[1,:DISABLE],
		[1,:ASTONISH],
		[6,:DISABLE],
		[9,:ASTONISH],
		[14,:FORESIGHT],
		[17,:SHADOWSNEAK],
		[22,:PURSUIT],
		[25,:WILLOWISP],
		[30,:CONFUSERAY],
		[33,:CURSE],
		[40,:HEX],
		[45,:SHADOWBALL],
		[52,:MEANLOOK],
		[57,:PAYBACK],
		[64,:FUTURESIGHT]],
	:tmlist => [:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:CHARGEBEAM,:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:OMINOUSWIND,:SPITE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:GRAVITY,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,],
	:Color => "Black",
	:Habitat => "Forest",
	:EggGroups => [:Amorphous],
	:Height => 16,
	:Weight => 306,
	:WildItemUncommon => :SPELLTAG,
	:kind => "Beckon",
	:dexentry => "It is thought that its body is hollow with only a spectral ball of fire burning inside. However, no one has been able to confirm this theory as fact.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DUSKNOIR,:TradeItem,:REAPERCLOTH]
	]
},

:TROPIUS => {
	:name => "Tropius",
	:dexnum => 357,
	:Type1 => :GRASS,
	:Type2 => :FLYING,
	:BaseStats => [99, 68, 83, 51, 72, 87],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:SOLARPOWER],
	:HiddenAbilities => :HARVEST,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:BULLETSEED,:CURSE,:DRAGONDANCE,:DRAGONHAMMER,:HEADBUTT,:LEAFBLADE,:LEAFSTORM,:LEECHSEED,:NATURALGIFT,:RAZORWIND,:SLAM,:SYNTHESIS],
	:Moveset => [
		[1,:LEAFSTORM],
		[1,:LEER],
		[1,:GUST],
		[1,:GROWTH],
		[1,:RAZORLEAF],
		[6,:SWEETSCENT],
		[10,:STOMP],
		[16,:MAGICALLEAF],
		[21,:WHIRLWIND],
		[26,:LEAFTORNADO],
		[30,:NATURALGIFT],
		[36,:AIRSLASH],
		[41,:BODYSLAM],
		[46,:BESTOW],
		[50,:SYNTHESIS],
		[56,:SOLARBEAM],
		[61,:LEAFSTORM]],
	:tmlist => [:FURYCUTTER,:OUTRAGE,:DRAGONPULSE,:TWISTER,:ROCKSMASH,:SUNNYDAY,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:STEELWING,:CONFIDE,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Green",
	:Habitat => "Forest",
	:EggGroups => [:Monster,:Grass],
	:Height => 20,
	:Weight => 1000,
	:kind => "Fruit",
	:dexentry => "It flies by flapping its broad leaves. The bunch of fruit that grows around its neck is deliciously sweet. In the spring, it scatters pollen from its neck.",
	:BattlerPlayerY => 8,
	:BattlerEnemyY => 2,
	:BattlerAltitude => 0,
},

:CHIMECHO => {
	:name => "Chimecho",
	:dexnum => 358,
	:Type1 => :PSYCHIC,
	:BaseStats => [75, 50, 80, 65, 95, 90],
	:EVs => [0, 0, 0, 0, 1, 1],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 149,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:COSMICPOWER,:CRAFTYSHIELD,:CURSE,:DISABLE,:FUTURESIGHT,:HYPNOSIS,:PERISHSONG,:RECOVER,:SKILLSWAP,:STOREDPOWER,:WISH],
	:Moveset => [
		[1,:HEALINGWISH],
		[1,:SYNCHRONOISE],
		[1,:WRAP],
		[1,:GROWL],
		[1,:ASTONISH],
		[1,:CONFUSION],
		[4,:GROWL],
		[7,:ASTONISH],
		[10,:CONFUSION],
		[13,:YAWN],
		[16,:PSYWAVE],
		[19,:TAKEDOWN],
		[22,:EXTRASENSORY],
		[27,:HEALBELL],
		[32,:UPROAR],
		[37,:SAFEGUARD],
		[42,:DOUBLEEDGE],
		[47,:HEALPULSE],
		[52,:SYNCHRONOISE],
		[57,:HEALINGWISH]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:DEFOG,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:ICYWIND,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:ROLLOUT,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,],
	:Color => "Blue",
	:Habitat => "Grassland",
	:EggGroups => [:Amorphous],
	:Height => 6,
	:Weight => 10,
	:WildItemUncommon => :CLEANSETAG,
	:kind => "Wind Chime",
	:dexentry => "They fly about very actively when the hot season arrives. They communicate among themselves using seven different and distinguishing cries.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 10,
},

:ABSOL => {
	:name => "Absol",
	:dexnum => 359,
	:Type1 => :DARK,
	:BaseStats => [65, 130, 60, 75, 75, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:PRESSURE,:SUPERLUCK],
	:HiddenAbilities => :JUSTIFIED,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 163,
	:CatchRate => 30,
	:Happiness => 35,
	:EggSteps => 6630,
	:EggMoves => [:ASSURANCE,:BATONPASS,:CURSE,:DOUBLEEDGE,:FEINTATTACK,:HEX,:MAGICCOAT,:MEFIRST,:MEANLOOK,:MEGAHORN,:PERISHSONG,:PLAYROUGH,:PUNISHMENT,:SUCKERPUNCH,:ZENHEADBUTT],
	:Moveset => [
		[1,:PERISHSONG],
		[1,:FUTURESIGHT],
		[1,:SCRATCH],
		[1,:FEINT],
		[1,:LEER],
		[1,:QUICKATTACK],
		[4,:LEER],
		[7,:QUICKATTACK],
		[10,:PURSUIT],
		[13,:TAUNT],
		[16,:BITE],
		[19,:DOUBLETEAM],
		[22,:SLASH],
		[25,:SWORDSDANCE],
		[29,:NIGHTSLASH],
		[33,:DETECT],
		[37,:PSYCHOCUT],
		[41,:MEFIRST],
		[45,:SUCKERPUNCH],
		[49,:RAZORWIND],
		[53,:FUTURESIGHT],
		[57,:PERISHSONG]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUPERPOWER,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:WILLOWISP,:BOUNCE,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:DREAMEATER,:ZENHEADBUTT,:CALMMIND,:MAGICCOAT,:REST,:ROLEPLAY,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:BRUTALSWING,:LASERFOCUS,:THROATCHOP,],
	:Color => "White",
	:Habitat => "Mountain",
	:EggGroups => [:Field],
	:Height => 12,
	:Weight => 470,
	:kind => "Disaster",
	:dexentry => "It sharply senses even subtle changes in sky and land to predict natural disasters. It is a long-lived Pokémon with a life-span of 100 years.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:WYNAUT => {
	:name => "Wynaut",
	:dexnum => 360,
	:Type1 => :PSYCHIC,
	:BaseStats => [95, 23, 48, 23, 23, 48],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:SHADOWTAG,:TELEPATHY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 52,
	:CatchRate => 125,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:SPLASH],
		[1,:CHARM],
		[1,:ENCORE],
		[15,:COUNTER],
		[15,:MIRRORCOAT],
		[15,:SAFEGUARD],
		[15,:DESTINYBOND]],
	:tmlist => [],
	:Color => "Blue",
	:Habitat => "Cave",
	:EggGroups => [:Undiscovered],
	:Height => 6,
	:Weight => 140,
	:kind => "Bright",
	:dexentry => "A Wynaut loves to eat sweet fruits. It cleverly picks fruits using its earlike arms. They gather in fruit gardens, drawn by the fragrance.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WOBBUFFET,:Level,15]
	]
},

:SNORUNT => {
	:name => "Snorunt",
	:dexnum => 361,
	:Type1 => :ICE,
	:BaseStats => [50, 50, 50, 50, 50, 50],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:INNERFOCUS,:ICEBODY],
	:HiddenAbilities => :MOODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AVALANCHE,:BIDE,:BLOCK,:DISABLE,:FAKETEARS,:HEX,:ROLLOUT,:SPIKES,:SWITCHEROO,:WEATHERBALL],
	:Moveset => [
		[1,:POWDERSNOW],
		[1,:LEER],
		[5,:DOUBLETEAM],
		[10,:ICESHARD],
		[14,:ICYWIND],
		[19,:BITE],
		[23,:ICEFANG],
		[28,:HEADBUTT],
		[32,:PROTECT],
		[37,:FROSTBREATH],
		[41,:CRUNCH],
		[46,:BLIZZARD],
		[50,:HAIL]],
	:tmlist => [:SHADOWBALL,:SPITE,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:Habitat => "Cave",
	:EggGroups => [:Fairy,:Mineral],
	:Height => 7,
	:Weight => 168,
	:WildItemUncommon => :SNOWBALL,
	:kind => "Snow Hat",
	:dexentry => "They tend to move about in groups of around five. In snowy regions, it is said that when they are seen late at night, snowfall will arrive by morning.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GLALIE,:Level,42],
		[:FROSLASS,:ItemFemale,:DAWNSTONE]
	]
},

:GLALIE => {
	:name => "Glalie",
	:dexnum => 362,
	:Type1 => :ICE,
	:BaseStats => [80, 80, 80, 80, 80, 80],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:INNERFOCUS,:ICEBODY],
	:HiddenAbilities => :MOODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 168,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:FREEZEDRY],
		[1,:SHEERCOLD],
		[1,:POWDERSNOW],
		[1,:LEER],
		[1,:DOUBLETEAM],
		[1,:ICESHARD],
		[5,:DOUBLETEAM],
		[10,:ICESHARD],
		[14,:ICYWIND],
		[19,:BITE],
		[23,:ICEFANG],
		[28,:HEADBUTT],
		[32,:PROTECT],
		[37,:FROSTBREATH],
		[41,:CRUNCH],
		[48,:BLIZZARD],
		[54,:HAIL],
		[61,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:DARKPULSE,:PAYBACK,:TAUNT,:TORMENT,:SHADOWBALL,:SPITE,:EARTHQUAKE,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONHEAD,:GYROBALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Gray",
	:Habitat => "Cave",
	:EggGroups => [:Fairy,:Mineral],
	:Height => 15,
	:Weight => 2565,
	:kind => "Face",
	:dexentry => "A Glalie has the power to immediately freeze moisture in the atmosphere. A dazzling cloud of diamondlike ice crystals forms around its body.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 10,
},

:SPHEAL => {
	:name => "Spheal",
	:dexnum => 363,
	:Type1 => :ICE,
	:Type2 => :WATER,
	:BaseStats => [70, 40, 50, 25, 55, 50],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:THICKFAT,:ICEBODY],
	:HiddenAbilities => :OBLIVIOUS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AQUARING,:BELLYDRUM,:CURSE,:FISSURE,:ROLLOUT,:SIGNALBEAM,:SLEEPTALK,:SPITUP,:STOCKPILE,:SWALLOW,:WATERPULSE,:WATERSPORT,:YAWN],
	:Moveset => [
		[1,:DEFENSECURL],
		[1,:POWDERSNOW],
		[1,:GROWL],
		[1,:WATERGUN],
		[5,:ROLLOUT],
		[9,:ENCORE],
		[13,:ICEBALL],
		[17,:BRINE],
		[21,:AURORABEAM],
		[26,:BODYSLAM],
		[31,:REST],
		[31,:SNORE],
		[36,:HAIL],
		[41,:BLIZZARD],
		[46,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:ROCKSMASH,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Field],
	:Height => 8,
	:Weight => 395,
	:kind => "Clap",
	:dexentry => "It is completely covered with plushy fur. As a result, it never feels the cold even when it is rolling about on ice floes or diving in the sea.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SEALEO,:Level,32]
	]
},

:SEALEO => {
	:name => "Sealeo",
	:dexnum => 364,
	:Type1 => :ICE,
	:Type2 => :WATER,
	:BaseStats => [90, 60, 70, 45, 75, 70],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:THICKFAT,:ICEBODY],
	:HiddenAbilities => :OBLIVIOUS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SWAGGER],
		[1,:DEFENSECURL],
		[1,:POWDERSNOW],
		[1,:GROWL],
		[1,:WATERGUN],
		[5,:ROLLOUT],
		[9,:ENCORE],
		[13,:ICEBALL],
		[17,:BRINE],
		[21,:AURORABEAM],
		[26,:BODYSLAM],
		[31,:REST],
		[31,:SNORE],
		[38,:HAIL],
		[45,:BLIZZARD],
		[52,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:ROCKSMASH,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Field],
	:Height => 11,
	:Weight => 876,
	:kind => "Ball Roll",
	:dexentry => "Sealeo live in herds on ice floes. Using its powerful flippers, it shatters ice. It dives into the sea to hunt prey five times a day.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WALREIN,:Level,44]
	]
},

:WALREIN => {
	:name => "Walrein",
	:dexnum => 365,
	:Type1 => :ICE,
	:Type2 => :WATER,
	:BaseStats => [110, 80, 90, 65, 95, 90],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:THICKFAT,:ICEBODY],
	:HiddenAbilities => :OBLIVIOUS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 239,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:ICEFANG],
		[1,:SWAGGER],
		[1,:CRUNCH],
		[1,:DEFENSECURL],
		[1,:POWDERSNOW],
		[1,:GROWL],
		[1,:WATERGUN],
		[7,:ROLLOUT],
		[7,:ENCORE],
		[13,:ICEBALL],
		[19,:BRINE],
		[19,:AURORABEAM],
		[25,:BODYSLAM],
		[31,:REST],
		[31,:SNORE],
		[38,:HAIL],
		[49,:BLIZZARD],
		[60,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:ROCKSMASH,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:IRONTAIL,:IRONHEAD,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Field],
	:Height => 14,
	:Weight => 1506,
	:kind => "Ice Break",
	:dexentry => "To protect its herd, the leader battles anything that invades its territory, even at the cost of its life. Its tusks may snap off in battle.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:CLAMPERL => {
	:name => "Clamperl",
	:dexnum => 366,
	:Type1 => :WATER,
	:BaseStats => [35, 64, 85, 32, 74, 55],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SHELLARMOR,:RATTLED],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 69,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AQUARING,:BARRIER,:BODYSLAM,:BRINE,:CONFUSERAY,:ENDURE,:MUDSPORT,:MUDDYWATER,:REFRESH,:SUPERSONIC,:WATERPULSE],
	:Moveset => [
		[1,:CLAMP],
		[1,:WATERGUN],
		[1,:WHIRLPOOL],
		[1,:IRONDEFENSE],
		[50,:SHELLSMASH]],
	:tmlist => [:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:IRONDEFENSE,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1],
	:Height => 4,
	:Weight => 525,
	:WildItemCommon => :PEARL,
	:WildItemUncommon => :BIGPEARL,
	:kind => "Bivalve",
	:dexentry => "A Clamperl slams its shell closed on prey to prevent escape. The pearl it creates upon evolution is said to be infused with a mysterious energy.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:HUNTAIL,:TradeItem,:DEEPSEATOOTH],
		[:GOREBYSS,:TradeItem,:DEEPSEASCALE]
	]
},

:HUNTAIL => {
	:name => "Huntail",
	:dexnum => 367,
	:Type1 => :WATER,
	:BaseStats => [55, 104, 105, 52, 94, 75],
	:EVs => [0, 1, 1, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:WATERVEIL],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 170,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:WHIRLPOOL],
		[1,:BITE],
		[5,:SCREECH],
		[9,:SCARYFACE],
		[11,:FEINTATTACK],
		[14,:WATERPULSE],
		[16,:ICEFANG],
		[19,:BRINE],
		[23,:SUCKERPUNCH],
		[26,:DIVE],
		[29,:BATONPASS],
		[34,:CRUNCH],
		[39,:AQUATAIL],
		[45,:COIL],
		[50,:HYDROPUMP]],
	:tmlist => [:SUCKERPUNCH,:SNATCH,:BOUNCE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKTOMB,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Water1],
	:Height => 17,
	:Weight => 270,
	:WildItemUncommon => :DEEPSEATOOTH,
	:kind => "Deep Sea",
	:dexentry => "To withstand the pressure of water deep under the sea, its spine is very sturdy. Its tail, which is shaped like a small fish, has eyes that light up.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 8,
},

:GOREBYSS => {
	:name => "Gorebyss",
	:dexnum => 368,
	:Type1 => :WATER,
	:BaseStats => [55, 84, 105, 52, 114, 75],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:SWIFTSWIM,:HYDRATION],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 170,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:WHIRLPOOL],
		[1,:CONFUSION],
		[5,:WATERSPORT],
		[9,:AGILITY],
		[11,:DRAININGKISS],
		[14,:WATERPULSE],
		[16,:AMNESIA],
		[19,:AQUARING],
		[23,:CAPTIVATE],
		[26,:DIVE],
		[29,:BATONPASS],
		[34,:PSYCHIC],
		[39,:AQUATAIL],
		[45,:COIL],
		[50,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:BOUNCE,:SHADOWBALL,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:REST,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Pink",
	:Habitat => "Sea",
	:EggGroups => [:Water1],
	:Height => 18,
	:Weight => 226,
	:WildItemUncommon => :DEEPSEASCALE,
	:kind => "South Sea",
	:dexentry => "A Gorebyss siphons the body fluids of prey through its thin, tubular mouth. Its light pink body color turns vivid when it finishes feeding.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 10,
},

:RELICANTH => {
	:name => "Relicanth",
	:dexnum => 369,
	:Type1 => :WATER,
	:Type2 => :ROCK,
	:BaseStats => [100, 90, 130, 55, 45, 65],
	:EVs => [1, 0, 1, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:ROCKHEAD],
	:HiddenAbilities => :STURDY,
	:GrowthRate => "Slow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 170,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 10455,
	:EggMoves => [:AMNESIA,:AQUATAIL,:BRINE,:MAGNITUDE,:MUDSHOT,:MUDSLAP,:MUDDYWATER,:SKULLBASH,:SLEEPTALK,:SNORE,:WATERSPORT,:ZENHEADBUTT],
	:Moveset => [
		[1,:FLAIL],
		[1,:HEADSMASH],
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:MUDSPORT],
		[1,:WATERGUN],
		[6,:MUDSPORT],
		[10,:WATERGUN],
		[15,:ROCKTOMB],
		[21,:ANCIENTPOWER],
		[26,:DIVE],
		[31,:TAKEDOWN],
		[35,:YAWN],
		[41,:REST],
		[46,:HYDROPUMP],
		[50,:DOUBLEEDGE],
		[56,:HEADSMASH]],
	:tmlist => [:ROCKSMASH,:BOUNCE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:CALMMIND,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "Sea",
	:EggGroups => [:Water1,:Water2],
	:Height => 10,
	:Weight => 234,
	:WildItemUncommon => :DEEPSEASCALE,
	:kind => "Longevity",
	:dexentry => "A Pokémon that was once believed to have been extinct. The species has not changed for 100 million years. It walks on the seafloor using its pectoral fins.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 11,
},

:LUVDISC => {
	:name => "Luvdisc",
	:dexnum => 370,
	:Type1 => :WATER,
	:BaseStats => [43, 30, 55, 97, 40, 65],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SWIFTSWIM,:HYDRATION],
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 116,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AQUAJET,:AQUARING,:BRINE,:CAPTIVATE,:ENTRAINMENT,:HEALPULSE,:MUDSPORT,:SPLASH,:SUPERSONIC,:WATERSPORT],
	:Moveset => [
		[1,:TACKLE],
		[1,:CHARM],
		[4,:WATERGUN],
		[7,:AGILITY],
		[9,:DRAININGKISS],
		[13,:LUCKYCHANT],
		[17,:WATERPULSE],
		[20,:ATTRACT],
		[22,:HEARTSTAMP],
		[26,:FLAIL],
		[31,:SWEETKISS],
		[34,:TAKEDOWN],
		[37,:CAPTIVATE],
		[40,:AQUARING],
		[42,:SOAK],
		[46,:HYDROPUMP],
		[49,:SAFEGUARD]],
	:tmlist => [:BOUNCE,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Pink",
	:Habitat => "Sea",
	:EggGroups => [:Water2],
	:Height => 6,
	:Weight => 87,
	:WildItemCommon => :HEARTSCALE,
	:kind => "Rendezvous",
	:dexentry => "Luvdisc make the branches of Corsola their nests. There is a custom from long ago of giving a Luvdisc as a gift to express one's feelings of love.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 14,
},

:BAGON => {
	:name => "Bagon",
	:dexnum => 371,
	:Type1 => :DRAGON,
	:BaseStats => [45, 75, 60, 50, 40, 30],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:SHEERFORCE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:EggMoves => [:DEFENSECURL,:DRAGONDANCE,:DRAGONPULSE,:DRAGONRAGE,:DRAGONRUSH,:ENDURE,:FIREFANG,:HYDROPUMP,:THRASH,:TWISTER],
	:Moveset => [
		[1,:RAGE],
		[4,:EMBER],
		[7,:LEER],
		[10,:BITE],
		[13,:DRAGONBREATH],
		[17,:HEADBUTT],
		[21,:FOCUSENERGY],
		[25,:CRUNCH],
		[29,:DRAGONCLAW],
		[34,:ZENHEADBUTT],
		[39,:SCARYFACE],
		[44,:FLAMETHROWER],
		[49,:DOUBLEEDGE]],
	:tmlist => [:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:TWISTER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:MUDSLAP,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Dragon],
	:Height => 6,
	:Weight => 421,
	:WildItemUncommon => :DRAGONFANG,
	:kind => "Rock Head",
	:dexentry => "Although it is small, this Pokémon is very powerful because its body is a bundle of muscles. It launches head-butts with its ironlike skull.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SHELGON,:Level,30]
	]
},

:SHELGON => {
	:name => "Shelgon",
	:dexnum => 372,
	:Type1 => :DRAGON,
	:BaseStats => [65, 95, 100, 50, 60, 50],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:ROCKHEAD,:OVERCOAT],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 147,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[0,:PROTECT],
		[1,:RAGE],
		[1,:EMBER],
		[1,:LEER],
		[1,:BITE],
		[4,:EMBER],
		[7,:LEER],
		[10,:BITE],
		[13,:DRAGONBREATH],
		[17,:HEADBUTT],
		[21,:FOCUSENERGY],
		[25,:CRUNCH],
		[29,:DRAGONCLAW],
		[35,:ZENHEADBUTT],
		[42,:SCARYFACE],
		[49,:FLAMETHROWER],
		[56,:DOUBLEEDGE]],
	:tmlist => [:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:TWISTER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:MUDSLAP,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:IRONDEFENSE,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Dragon],
	:Height => 11,
	:Weight => 1105,
	:WildItemUncommon => :DRAGONFANG,
	:kind => "Endurance",
	:dexentry => "It hardly eats while it awaits evolution. It becomes hardier by enduring hunger. Its shell peels off the instant it begins to evolve.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SALAMENCE,:Level,50]
	]
},

:SALAMENCE => {
	:name => "Salamence",
	:dexnum => 373,
	:Type1 => :DRAGON,
	:Type2 => :FLYING,
	:BaseStats => [95, 135, 80, 100, 110, 80],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:MOXIE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 270,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[0,:FLY],
		[1,:PROTECT],
		[1,:DRAGONTAIL],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:RAGE],
		[1,:EMBER],
		[1,:LEER],
		[1,:BITE],
		[4,:EMBER],
		[7,:LEER],
		[10,:BITE],
		[13,:DRAGONBREATH],
		[17,:HEADBUTT],
		[21,:FOCUSENERGY],
		[25,:CRUNCH],
		[29,:DRAGONCLAW],
		[35,:ZENHEADBUTT],
		[42,:SCARYFACE],
		[49,:FLAMETHROWER],
		[63,:DOUBLEEDGE]],
	:tmlist => [:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:TWISTER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:SUNNYDAY,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWCLAW,:OMINOUSWIND,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:IRONTAIL,:STEELWING,:AQUATAIL,:RAINDANCE,:CONFIDE,:BRUTALSWING,:LASERFOCUS,],
	:Color => "Blue",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Dragon],
	:Height => 15,
	:Weight => 1026,
	:WildItemUncommon => :DRAGONFANG,
	:kind => "Dragon",
	:dexentry => "After many long years, its cellular structure underwent a sudden mutation to grow wings. When angered, it loses all thought and rampages out of control.",
	:BattlerPlayerY => 10,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:BELDUM => {
	:name => "Beldum",
	:dexnum => 374,
	:Type1 => :STEEL,
	:Type2 => :PSYCHIC,
	:BaseStats => [40, 55, 80, 30, 35, 60],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:CLEARBODY,:LIGHTMETAL],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 60,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[1,:TAKEDOWN]],
	:tmlist => [:HEADBUTT,:ZENHEADBUTT,:IRONHEAD,:IRONDEFENSE,],
	:Color => "Blue",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Mineral],
	:Height => 6,
	:Weight => 952,
	:WildItemUncommon => :METALCOAT,
	:kind => "Iron Ball",
	:dexentry => "When Beldum gather in a swarm, they move in perfect unison as if they were but one Pokémon. They communicate with each other using brain waves.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 12,
	:evolutions => [
		[:METANG,:Level,20]
	]
},

:METANG => {
	:name => "Metang",
	:dexnum => 375,
	:Type1 => :STEEL,
	:Type2 => :PSYCHIC,
	:BaseStats => [60, 75, 100, 50, 55, 80],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:CLEARBODY,:LIGHTMETAL],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 147,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[0,:CONFUSION],
		[0,:METALCLAW],
		[1,:MAGNETRISE],
		[1,:TAKEDOWN],
		[23,:PURSUIT],
		[26,:BULLETPUNCH],
		[29,:MIRACLEEYE],
		[32,:ZENHEADBUTT],
		[35,:SCARYFACE],
		[38,:PSYCHIC],
		[41,:AGILITY],
		[44,:METEORMASH],
		[47,:IRONDEFENSE],
		[50,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:THUNDERPUNCH,:MAGNETRISE,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ICYWIND,:EXPLOSION,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:TELEKINESIS,:TRICK,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Blue",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Mineral],
	:Height => 12,
	:Weight => 2025,
	:WildItemUncommon => :METALCOAT,
	:kind => "Iron Claw",
	:dexentry => "The claws tipping its arms pack the destructive power to tear through thick iron sheets as if they were silk. It flies at over 60 miles per hour.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 3,
	:evolutions => [
		[:METAGROSS,:Level,45]
	]
},

:METAGROSS => {
	:name => "Metagross",
	:dexnum => 376,
	:Type1 => :STEEL,
	:Type2 => :PSYCHIC,
	:BaseStats => [80, 135, 130, 70, 95, 90],
	:EVs => [0, 0, 3, 0, 0, 0],
	:Abilities => [:CLEARBODY,:LIGHTMETAL],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 10455,
	:Moveset => [
		[0,:HAMMERARM],
		[1,:CONFUSION],
		[1,:METALCLAW],
		[1,:MAGNETRISE],
		[1,:TAKEDOWN],
		[23,:PURSUIT],
		[26,:BULLETPUNCH],
		[29,:MIRACLEEYE],
		[32,:ZENHEADBUTT],
		[35,:SCARYFACE],
		[38,:PSYCHIC],
		[41,:AGILITY],
		[44,:METEORMASH],
		[52,:IRONDEFENSE],
		[60,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:THUNDERPUNCH,:MAGNETRISE,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ICYWIND,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:TELEKINESIS,:TRICK,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Mineral],
	:Height => 16,
	:Weight => 5500,
	:WildItemUncommon => :METALCOAT,
	:kind => "Iron Leg",
	:dexentry => "Metagross has four brains that are joined by a complex neural network. As a result of integration, this Pokémon is smarter than a supercomputer.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 0,
},

:REGIROCK => {
	:name => "Regirock",
	:dexnum => 377,
	:Type1 => :ROCK,
	:BaseStats => [80, 100, 200, 50, 50, 100],
	:EVs => [0, 0, 3, 0, 0, 0],
	:Abilities => [:CLEARBODY,:STURDY],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:EXPLOSION],
		[1,:STOMP],
		[1,:ROCKTHROW],
		[1,:CHARGEBEAM],
		[1,:BULLDOZE],
		[7,:ROCKTHROW],
		[13,:CHARGEBEAM],
		[19,:BULLDOZE],
		[25,:CURSE],
		[31,:ANCIENTPOWER],
		[37,:IRONDEFENSE],
		[43,:STONEEDGE],
		[49,:HAMMERARM],
		[55,:LOCKON],
		[55,:ZAPCANNON],
		[61,:SUPERPOWER],
		[67,:HYPERBEAM]],
	:tmlist => [:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:IRONDEFENSE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:Habitat => "Cave",
	:EggGroups => [:Undiscovered],
	:Height => 17,
	:Weight => 2300,
	:kind => "Rock Peak",
	:dexentry => "A Pokémon that is made entirely of rocks and boulders. If parts of its body chip off in battle, Regirock repairs itself by adding new rocks.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:REGICE => {
	:name => "Regice",
	:dexnum => 378,
	:Type1 => :ICE,
	:BaseStats => [80, 50, 100, 50, 100, 200],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:CLEARBODY,:ICEBODY],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:EXPLOSION],
		[1,:STOMP],
		[1,:ICYWIND],
		[1,:CHARGEBEAM],
		[1,:BULLDOZE],
		[7,:ICYWIND],
		[13,:CHARGEBEAM],
		[19,:BULLDOZE],
		[25,:CURSE],
		[31,:ANCIENTPOWER],
		[37,:AMNESIA],
		[43,:ICEBEAM],
		[49,:HAMMERARM],
		[55,:LOCKON],
		[55,:ZAPCANNON],
		[61,:SUPERPOWER],
		[67,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:FLASHCANNON,:IRONHEAD,:RAINDANCE,:AURORAVEIL,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:Habitat => "Cave",
	:EggGroups => [:Undiscovered],
	:Height => 18,
	:Weight => 1750,
	:kind => "Iceberg",
	:dexentry => "Regice's body was made during an ice age. The deep-frozen body can't be melted, even by fire. This Pokémon controls frigid air of -328 degrees Fahrenheit.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:REGISTEEL => {
	:name => "Registeel",
	:dexnum => 379,
	:Type1 => :STEEL,
	:BaseStats => [80, 75, 150, 50, 75, 150],
	:EVs => [0, 0, 2, 0, 0, 1],
	:Abilities => [:CLEARBODY,:LIGHTMETAL],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 35,
	:EggSteps => 20655,
	:Moveset => [
		[1,:EXPLOSION],
		[1,:STOMP],
		[1,:METALCLAW],
		[1,:CHARGEBEAM],
		[1,:BULLDOZE],
		[7,:METALCLAW],
		[13,:CHARGEBEAM],
		[19,:BULLDOZE],
		[25,:CURSE],
		[31,:ANCIENTPOWER],
		[37,:IRONDEFENSE],
		[37,:AMNESIA],
		[43,:IRONHEAD],
		[43,:FLASHCANNON],
		[49,:HAMMERARM],
		[55,:LOCKON],
		[55,:ZAPCANNON],
		[61,:SUPERPOWER],
		[67,:HYPERBEAM]],
	:tmlist => [:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:Habitat => "Cave",
	:EggGroups => [:Undiscovered],
	:Height => 19,
	:Weight => 2050,
	:kind => "Iron",
	:dexentry => "Its body is harder than any other kind of metal. The body metal is composed of a mysterious substance. It can also shrink and stretch flexibly.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:LATIAS => {
	:name => "Latias",
	:dexnum => 380,
	:Type1 => :DRAGON,
	:Type2 => :PSYCHIC,
	:BaseStats => [80, 80, 90, 110, 110, 130],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 90,
	:EggSteps => 30855,
	:Moveset => [
		[1,:HEALINGWISH],
		[1,:HELPINGHAND],
		[1,:WISH],
		[1,:PSYWAVE],
		[1,:SAFEGUARD],
		[4,:WATERSPORT],
		[7,:CHARM],
		[10,:STOREDPOWER],
		[13,:REFRESH],
		[16,:HEALPULSE],
		[20,:DRAGONBREATH],
		[24,:MISTBALL],
		[28,:PSYCHOSHIFT],
		[32,:RECOVER],
		[36,:REFLECTTYPE],
		[41,:ZENHEADBUTT],
		[46,:GUARDSPLIT],
		[51,:PSYCHIC],
		[56,:DRAGONPULSE],
		[61,:HEALINGWISH]],
	:tmlist => [:FURYCUTTER,:SUCKERPUNCH,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:ENERGYBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:SANDSTORM,:STEELWING,:SURF,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:LASERFOCUS,],
	:Color => "Red",
	:Habitat => "WatersEdge",
	:EggGroups => [:Undiscovered],
	:Height => 14,
	:Weight => 400,
	:kind => "Eon",
	:dexentry => "They make a small herd of only several members. They rarely make contact with people or other Pokémon. They disappear if they sense enemies.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 11,
},

:LATIOS => {
	:name => "Latios",
	:dexnum => 381,
	:Type1 => :DRAGON,
	:Type2 => :PSYCHIC,
	:BaseStats => [80, 90, 80, 110, 130, 110],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemZero",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 90,
	:EggSteps => 30855,
	:Moveset => [
		[1,:MEMENTO],
		[1,:HELPINGHAND],
		[1,:HEALBLOCK],
		[1,:PSYWAVE],
		[1,:SAFEGUARD],
		[4,:PROTECT],
		[7,:DRAGONDANCE],
		[10,:STOREDPOWER],
		[13,:REFRESH],
		[16,:HEALPULSE],
		[20,:DRAGONBREATH],
		[24,:LUSTERPURGE],
		[28,:PSYCHOSHIFT],
		[32,:RECOVER],
		[36,:TELEKINESIS],
		[41,:ZENHEADBUTT],
		[46,:POWERSPLIT],
		[51,:PSYCHIC],
		[56,:DRAGONPULSE],
		[61,:MEMENTO]],
	:tmlist => [:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:SHADOWCLAW,:SOLARBEAM,:ENERGYBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:WONDERROOM,:SANDSTORM,:STEELWING,:SURF,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:LASERFOCUS,],
	:Color => "Blue",
	:Habitat => "WatersEdge",
	:EggGroups => [:Undiscovered],
	:Height => 20,
	:Weight => 600,
	:kind => "Eon",
	:dexentry => "Even in hiding, it can detect the locations of others and sense their emotions telepathically. Its intelligence allows it to understand human languages.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 10,
},

:KYOGRE => {
	:name => "Kyogre",
	:dexnum => 382,
	:Type1 => :WATER,
	:BaseStats => [100, 100, 90, 90, 150, 140],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:DRIZZLE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 302,
	:CatchRate => 5,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:ANCIENTPOWER],
		[1,:WATERPULSE],
		[5,:SCARYFACE],
		[15,:AQUATAIL],
		[20,:BODYSLAM],
		[30,:AQUARING],
		[35,:ICEBEAM],
		[45,:ORIGINPULSE],
		[50,:CALMMIND],
		[60,:MUDDYWATER],
		[65,:SHEERCOLD],
		[75,:HYDROPUMP],
		[80,:DOUBLEEDGE],
		[90,:WATERSPOUT]],
	:tmlist => [:SIGNALBEAM,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:BRICKBREAK,:ROCKSMASH,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:CALMMIND,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:IRONHEAD,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:LIQUIDATION,],
	:Color => "Blue",
	:Habitat => "Sea",
	:EggGroups => [:Undiscovered],
	:Height => 45,
	:Weight => 3520,
	:kind => "Sea Basin",
	:dexentry => "Kyogre has appeared in mythology as the creator of the sea. After long years of feuding with Groudon, it took to sleep at the bottom of the sea.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 4,
	:BattlerAltitude => 3,
},

:GROUDON => {
	:name => "Groudon",
	:dexnum => 383,
	:Type1 => :GROUND,
	:BaseStats => [100, 150, 140, 90, 100, 90],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:DROUGHT],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 302,
	:CatchRate => 5,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:ANCIENTPOWER],
		[1,:MUDSHOT],
		[5,:SCARYFACE],
		[15,:EARTHPOWER],
		[20,:LAVAPLUME],
		[30,:REST],
		[35,:EARTHQUAKE],
		[45,:PRECIPICEBLADES],
		[50,:BULKUP],
		[60,:SOLARBEAM],
		[65,:FISSURE],
		[75,:FIREBLAST],
		[80,:HAMMERARM],
		[90,:ERUPTION]],
	:tmlist => [:FURYCUTTER,:FLING,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:BULKUP,:OVERHEAT,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SOLARBEAM,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Red",
	:Habitat => "RoughTerrain",
	:EggGroups => [:Undiscovered],
	:Height => 35,
	:Weight => 9500,
	:kind => "Continent",
	:dexentry => "Groudon has appeared in mythology as the creator of the land. It sleeps in magma underground and is said to make volcanoes erupt on awakening.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
},

:RAYQUAZA => {
	:name => "Rayquaza",
	:dexnum => 384,
	:Type1 => :DRAGON,
	:Type2 => :FLYING,
	:BaseStats => [105, 150, 90, 95, 150, 90],
	:EVs => [0, 2, 0, 0, 1, 0],
	:Abilities => [:AIRLOCK],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 306,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:DRAGONASCENT],
		[1,:VCREATE],
		[1,:TWISTER],
		[5,:SCARYFACE],
		[15,:ANCIENTPOWER],
		[20,:CRUNCH],
		[30,:AIRSLASH],
		[35,:REST],
		[45,:EXTREMESPEED],
		[50,:DRAGONPULSE],
		[60,:DRAGONDANCE],
		[65,:FLY],
		[75,:HYPERVOICE],
		[80,:OUTRAGE],
		[90,:HYPERBEAM]],
	:tmlist => [:FURYCUTTER,:FLING,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:BULKUP,:OVERHEAT,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:FLY,:AERIALACE,:SKYDROP,:DEFOG,:TAILWIND,:SHADOWCLAW,:SOLARBEAM,:ENERGYBALL,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:IRONTAIL,:IRONHEAD,:GYROBALL,:SURF,:AQUATAIL,:DIVE,:WATERFALL,:WATERPULSE,:RAINDANCE,:DRAGONASCENT,:BRUTALSWING,:CELEBRATE,],
	:Color => "Green",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 70,
	:Weight => 2065,
	:kind => "Sky High",
	:dexentry => "A Pokémon that flies endlessly in the ozone layer. It is said it would descend to the ground if Kyogre and Groudon were to fight.",
	:BattlerPlayerY => 2,
	:BattlerEnemyY => 2,
	:BattlerAltitude => 5,
},

:JIRACHI => {
	:name => "Jirachi",
	:dexnum => 385,
	:Type1 => :STEEL,
	:Type2 => :PSYCHIC,
	:BaseStats => [100, 100, 100, 100, 100, 100],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:SERENEGRACE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 100,
	:EggSteps => 30855,
	:Moveset => [
		[1,:WISH],
		[1,:CONFUSION],
		[5,:REST],
		[10,:SWIFT],
		[15,:HELPINGHAND],
		[20,:PSYCHIC],
		[25,:REFRESH],
		[30,:LUCKYCHANT],
		[35,:ZENHEADBUTT],
		[40,:DOUBLEEDGE],
		[45,:GRAVITY],
		[50,:HEALINGWISH],
		[55,:FUTURESIGHT],
		[60,:COSMICPOWER],
		[65,:LASTRESORT],
		[70,:DOOMDESIRE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:DRAINPUNCH,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:ANCIENTPOWER,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:WATERPULSE,:RAINDANCE,],
	:Color => "Yellow",
	:Habitat => "Mountain",
	:EggGroups => [:Undiscovered],
	:Height => 3,
	:Weight => 11,
	:WildItemCommon => :STARPIECE,
	:WildItemUncommon => :STARPIECE,
	:WildItemRare => :STARPIECE,
	:kind => "Wish",
	:dexentry => "Jirachi is said to make wishes come true. While it sleeps, a tough crystalline shell envelops the body to protect it from enemies.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 14,
},

:DEOXYS => {
	:name => "Deoxys",
	:dexnum => 386,
	:Type1 => :PSYCHIC,
	:BaseStats => [50, 150, 50, 150, 150, 50],
	:EVs => [0, 1, 0, 1, 1, 0],
	:Abilities => [:PRESSURE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:LEER],
		[1,:WRAP],
		[7,:NIGHTSHADE],
		[13,:TELEPORT],
		[19,:KNOCKOFF],
		[25,:PURSUIT],
		[31,:PSYCHIC],
		[37,:SNATCH],
		[43,:PSYCHOSHIFT],
		[49,:ZENHEADBUTT],
		[55,:COSMICPOWER],
		[61,:RECOVER],
		[67,:PSYCHOBOOST],
		[73,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:STEALTHROCK,:FLASHCANNON,:WATERPULSE,:RAINDANCE,:BRUTALSWING,:LASERFOCUS,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Red",
	:Habitat => "Rare",
	:EggGroups => [:Undiscovered],
	:Height => 17,
	:Weight => 608,
	:kind => "DNA",
	:dexentry => "A Pokémon that mutated from an extraterrestrial virus exposed to a laser beam. Its body is configured for superior agility and speed.",
	:BattlerPlayerY => 10,
	:BattlerEnemyY => 5,
	:BattlerAltitude => 0,
},

:TURTWIG => {
	:name => "Turtwig",
	:dexnum => 387,
	:Type1 => :GRASS,
	:BaseStats => [55, 68, 64, 31, 45, 55],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:OVERGROW,:SHELLARMOR],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 64,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AMNESIA,:BODYSLAM,:DOUBLEEDGE,:EARTHPOWER,:GRASSYTERRAIN,:GROWTH,:HEAVYSLAM,:SANDTOMB,:SEEDBOMB,:SPITUP,:STOCKPILE,:SUPERPOWER,:SWALLOW,:THRASH,:TICKLE,:WIDEGUARD,:WORRYSEED],
	:Moveset => [
		[1,:TACKLE],
		[5,:WITHDRAW],
		[9,:ABSORB],
		[13,:RAZORLEAF],
		[17,:CURSE],
		[21,:BITE],
		[25,:MEGADRAIN],
		[29,:LEECHSEED],
		[33,:SYNTHESIS],
		[37,:CRUNCH],
		[41,:GIGADRAIN],
		[45,:LEAFSTORM]],
	:tmlist => [:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHPOWER,:MUDSLAP,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:STEALTHROCK,:IRONTAIL,],
	:Color => "Green",
	:EggGroups => [:Monster,:Grass],
	:Height => 4,
	:Weight => 102,
	:kind => "Tiny Leaf",
	:dexentry => "Made from soil, the shell on its back hardens when it drinks water. It lives along lakes.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GROTLE,:Level,18]
	]
},

:GROTLE => {
	:name => "Grotle",
	:dexnum => 388,
	:Type1 => :GRASS,
	:BaseStats => [75, 89, 85, 36, 55, 65],
	:EVs => [0, 1, 1, 0, 0, 0],
	:Abilities => [:OVERGROW,:SHELLARMOR],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:WITHDRAW],
		[1,:ABSORB],
		[5,:WITHDRAW],
		[9,:ABSORB],
		[13,:RAZORLEAF],
		[17,:CURSE],
		[22,:BITE],
		[27,:MEGADRAIN],
		[32,:LEECHSEED],
		[37,:SYNTHESIS],
		[42,:CRUNCH],
		[47,:GIGADRAIN],
		[52,:LEAFSTORM]],
	:tmlist => [:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHPOWER,:MUDSLAP,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:STEALTHROCK,:IRONTAIL,],
	:Color => "Green",
	:EggGroups => [:Monster,:Grass],
	:Height => 11,
	:Weight => 970,
	:kind => "Grove",
	:dexentry => "It lives along water in forests. In the daytime, it leaves the forest to sunbathe its treed shell.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
	:evolutions => [
		[:TORTERRA,:Level,32]
	]
},

:TORTERRA => {
	:name => "Torterra",
	:dexnum => 389,
	:Type1 => :GRASS,
	:Type2 => :GROUND,
	:BaseStats => [95, 109, 105, 56, 75, 85],
	:EVs => [0, 2, 1, 0, 0, 0],
	:Abilities => [:OVERGROW,:SHELLARMOR],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 236,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:EARTHQUAKE],
		[1,:WOODHAMMER],
		[1,:TACKLE],
		[1,:WITHDRAW],
		[1,:ABSORB],
		[1,:RAZORLEAF],
		[5,:WITHDRAW],
		[9,:ABSORB],
		[13,:RAZORLEAF],
		[17,:CURSE],
		[22,:BITE],
		[27,:MEGADRAIN],
		[33,:LEECHSEED],
		[39,:SYNTHESIS],
		[45,:CRUNCH],
		[51,:GIGADRAIN],
		[57,:LEAFSTORM]],
	:tmlist => [:OUTRAGE,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:FRENZYPLANT,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:STOMPINGTANTRUM,],
	:Color => "Green",
	:EggGroups => [:Monster,:Grass],
	:Height => 22,
	:Weight => 3100,
	:kind => "Continent",
	:dexentry => "Small Pokémon occasionally gather on its unmoving back to begin building their nests.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 3,
	:BattlerAltitude => 0,
},

:CHIMCHAR => {
	:name => "Chimchar",
	:dexnum => 390,
	:Type1 => :FIRE,
	:BaseStats => [44, 58, 44, 61, 58, 44],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:BLAZE,:IRONFIST],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 62,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ASSIST,:BLAZEKICK,:COUNTER,:DOUBLEKICK,:ENCORE,:FAKEOUT,:FIREPUNCH,:FOCUSENERGY,:FOCUSPUNCH,:HEATWAVE,:HELPINGHAND,:POWERUPPUNCH,:QUICKGUARD,:SUBMISSION,:THUNDERPUNCH],
	:Moveset => [
		[1,:SCRATCH],
		[1,:LEER],
		[7,:EMBER],
		[9,:TAUNT],
		[15,:FURYSWIPES],
		[17,:FLAMEWHEEL],
		[23,:NASTYPLOT],
		[25,:TORMENT],
		[31,:FACADE],
		[33,:FIRESPIN],
		[39,:ACROBATICS],
		[41,:SLACKOFF],
		[47,:FLAMETHROWER]],
	:tmlist => [:UTURN,:FLING,:TAUNT,:TORMENT,:THUNDERPUNCH,:FOCUSPUNCH,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:ACROBATICS,:SHADOWCLAW,:GRASSKNOT,:MUDSLAP,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:MAGICCOAT,:REST,:ROLLOUT,:STEALTHROCK,:IRONTAIL,],
	:Color => "Brown",
	:EggGroups => [:Field,:HumanLike],
	:Height => 5,
	:Weight => 62,
	:kind => "Chimp",
	:dexentry => "It agilely scales sheer cliffs to live atop craggy mountains. Its fire is put out when it sleeps.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MONFERNO,:Level,14]
	]
},

:MONFERNO => {
	:name => "Monferno",
	:dexnum => 391,
	:Type1 => :FIRE,
	:Type2 => :FIGHTING,
	:BaseStats => [64, 78, 52, 81, 78, 52],
	:EVs => [0, 0, 0, 1, 1, 0],
	:Abilities => [:BLAZE,:IRONFIST],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:MACHPUNCH],
		[1,:SCRATCH],
		[1,:LEER],
		[1,:EMBER],
		[7,:EMBER],
		[9,:TAUNT],
		[16,:FURYSWIPES],
		[19,:FLAMEWHEEL],
		[26,:FEINT],
		[29,:TORMENT],
		[36,:CLOSECOMBAT],
		[39,:FIRESPIN],
		[46,:ACROBATICS],
		[49,:SLACKOFF],
		[56,:FLAREBLITZ]],
	:tmlist => [:UTURN,:FLING,:TAUNT,:TORMENT,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:ACROBATICS,:SHADOWCLAW,:GRASSKNOT,:MUDSLAP,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:STEALTHROCK,:IRONTAIL,],
	:Color => "Brown",
	:EggGroups => [:Field,:HumanLike],
	:Height => 9,
	:Weight => 220,
	:kind => "Playful",
	:dexentry => "To intimidate attackers, it stretches the fire on its tail to make itself appear bigger.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
	:evolutions => [
		[:INFERNAPE,:Level,36]
	]
},

:INFERNAPE => {
	:name => "Infernape",
	:dexnum => 392,
	:Type1 => :FIRE,
	:Type2 => :FIGHTING,
	:BaseStats => [76, 104, 71, 108, 104, 71],
	:EVs => [0, 1, 0, 1, 1, 0],
	:Abilities => [:BLAZE,:IRONFIST],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 240,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:CLOSECOMBAT],
		[1,:MACHPUNCH],
		[1,:FLAREBLITZ],
		[1,:SCRATCH],
		[1,:LEER],
		[1,:EMBER],
		[1,:TAUNT],
		[7,:EMBER],
		[9,:TAUNT],
		[16,:FURYSWIPES],
		[19,:FLAMEWHEEL],
		[26,:FEINT],
		[29,:PUNISHMENT],
		[42,:FIRESPIN],
		[52,:ACROBATICS],
		[58,:CALMMIND],
		[68,:FLAREBLITZ]],
	:tmlist => [:UTURN,:FLING,:TAUNT,:TORMENT,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:BLASTBURN,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:ACROBATICS,:SHADOWCLAW,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GUNKSHOT,:POISONJAB,:TOXIC,:CALMMIND,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:LASERFOCUS,],
	:Color => "Brown",
	:EggGroups => [:Field,:HumanLike],
	:Height => 12,
	:Weight => 550,
	:kind => "Flame",
	:dexentry => "It uses a special kind of martial arts involving all its limbs. Its fire never goes out.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:PIPLUP => {
	:name => "Piplup",
	:dexnum => 393,
	:Type1 => :WATER,
	:BaseStats => [53, 51, 53, 40, 61, 56],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:TORRENT,:DEFIANT],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 63,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:AQUARING,:BIDE,:DOUBLEHIT,:FEATHERDANCE,:FLAIL,:HYDROPUMP,:ICYWIND,:MUDSPORT,:MUDSLAP,:POWERTRIP,:SNORE,:SUPERSONIC,:YAWN],
	:Moveset => [
		[1,:POUND],
		[4,:GROWL],
		[8,:BUBBLE],
		[11,:WATERSPORT],
		[15,:PECK],
		[18,:BUBBLEBEAM],
		[22,:BIDE],
		[25,:FURYATTACK],
		[29,:BRINE],
		[32,:WHIRLPOOL],
		[36,:MIST],
		[39,:DRILLPECK],
		[43,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:FLING,:QUASH,:BRICKBREAK,:AERIALACE,:DEFOG,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKTOMB,:STEALTHROCK,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,],
	:Color => "Blue",
	:EggGroups => [:Water1,:Field],
	:Height => 4,
	:Weight => 52,
	:kind => "Penguin",
	:dexentry => "Because it is very proud, it hates accepting food from people. Its thick down guards it from cold.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PRINPLUP,:Level,16]
	]
},

:PRINPLUP => {
	:name => "Prinplup",
	:dexnum => 394,
	:Type1 => :WATER,
	:BaseStats => [64, 66, 68, 50, 81, 76],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:TORRENT,:DEFIANT],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 142,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:METALCLAW],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:BUBBLE],
		[4,:GROWL],
		[8,:BUBBLE],
		[11,:WATERSPORT],
		[15,:PECK],
		[19,:BUBBLEBEAM],
		[24,:BIDE],
		[28,:FURYATTACK],
		[33,:BRINE],
		[37,:WHIRLPOOL],
		[42,:MIST],
		[46,:DRILLPECK],
		[51,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:FLING,:QUASH,:BRICKBREAK,:ROCKSMASH,:AERIALACE,:DEFOG,:SHADOWCLAW,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKTOMB,:STEALTHROCK,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,],
	:Color => "Blue",
	:EggGroups => [:Water1,:Field],
	:Height => 8,
	:Weight => 230,
	:kind => "Penguin",
	:dexentry => "It lives alone, away from others. Apparently, every one of them believes it is the most important.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
	:evolutions => [
		[:EMPOLEON,:Level,36]
	]
},

:EMPOLEON => {
	:name => "Empoleon",
	:dexnum => 395,
	:Type1 => :WATER,
	:Type2 => :STEEL,
	:BaseStats => [84, 86, 88, 60, 111, 101],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:TORRENT,:DEFIANT],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 239,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:AQUAJET],
		[1,:METALCLAW],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:BUBBLE],
		[4,:GROWL],
		[8,:BUBBLE],
		[11,:SWORDSDANCE],
		[15,:PECK],
		[19,:BUBBLEBEAM],
		[24,:SWAGGER],
		[28,:FURYATTACK],
		[33,:BRINE],
		[39,:WHIRLPOOL],
		[46,:MIST],
		[52,:DRILLPECK],
		[59,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:KNOCKOFF,:FLING,:QUASH,:BRICKBREAK,:ROCKSMASH,:AERIALACE,:DEFOG,:SHADOWCLAW,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:STEALTHROCK,:FLASHCANNON,:STEELWING,:IRONDEFENSE,:HYDROCANNON,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:LASERFOCUS,:LIQUIDATION,:THROATCHOP,],
	:Color => "Blue",
	:EggGroups => [:Water1,:Field],
	:Height => 17,
	:Weight => 845,
	:kind => "Emperor",
	:dexentry => "The three horns that extend from its beak attest to its power. The leader has the biggest horns.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 4,
	:BattlerAltitude => 0,
},

:STARLY => {
	:name => "Starly",
	:dexnum => 396,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [40, 55, 30, 60, 30, 30],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:KEENEYE,:RECKLESS],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 49,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:ASTONISH,:DETECT,:DOUBLEEDGE,:FEATHERDANCE,:FORESIGHT,:FURYATTACK,:MIRRORMOVE,:PURSUIT,:REVENGE,:ROOST,:SANDATTACK,:STEELWING,:UPROAR],
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[5,:QUICKATTACK],
		[9,:WINGATTACK],
		[13,:DOUBLETEAM],
		[17,:ENDEAVOR],
		[21,:WHIRLWIND],
		[25,:AERIALACE],
		[29,:TAKEDOWN],
		[33,:AGILITY],
		[37,:BRAVEBIRD],
		[41,:FINALGAMBIT]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:EggGroups => [:Flying],
	:Height => 3,
	:Weight => 20,
	:kind => "Starling",
	:dexentry => "They flock in great numbers. Though small, they flap their wings with great power.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:STARAVIA,:Level,14]
	]
},

:STARAVIA => {
	:name => "Staravia",
	:dexnum => 397,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [55, 75, 50, 80, 40, 40],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:INTIMIDATE,:RECKLESS],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 119,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[1,:QUICKATTACK],
		[5,:QUICKATTACK],
		[9,:WINGATTACK],
		[13,:DOUBLETEAM],
		[18,:ENDEAVOR],
		[23,:WHIRLWIND],
		[28,:AERIALACE],
		[33,:TAKEDOWN],
		[38,:AGILITY],
		[43,:BRAVEBIRD],
		[48,:FINALGAMBIT]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:EggGroups => [:Flying],
	:Height => 6,
	:Weight => 155,
	:kind => "Starling",
	:dexentry => "It flies around forests and fields in search of Bug Pokémon. It stays within a huge flock.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
	:evolutions => [
		[:STARAPTOR,:Level,34]
	]
},

:STARAPTOR => {
	:name => "Staraptor",
	:dexnum => 398,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [85, 120, 70, 100, 50, 60],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:RECKLESS],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 214,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:CLOSECOMBAT],
		[1,:TACKLE],
		[1,:GROWL],
		[1,:QUICKATTACK],
		[1,:WINGATTACK],
		[5,:QUICKATTACK],
		[9,:WINGATTACK],
		[13,:DOUBLETEAM],
		[18,:ENDEAVOR],
		[23,:WHIRLWIND],
		[28,:AERIALACE],
		[33,:TAKEDOWN],
		[41,:AGILITY],
		[49,:BRAVEBIRD],
		[57,:FINALGAMBIT]],
	:tmlist => [:UTURN,:THIEF,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Brown",
	:EggGroups => [:Flying],
	:Height => 12,
	:Weight => 249,
	:kind => "Predator",
	:dexentry => "It has a savage nature. It will courageously challenge foes that are much larger.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:BIDOOF => {
	:name => "Bidoof",
	:dexnum => 399,
	:Type1 => :NORMAL,
	:BaseStats => [59, 45, 40, 31, 35, 40],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:SIMPLE,:UNAWARE],
	:HiddenAbilities => :MOODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 50,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:EggMoves => [:AQUATAIL,:DEFENSECURL,:DOUBLEEDGE,:ENDURE,:FURYSWIPES,:MUDSPORT,:ODORSLEUTH,:QUICKATTACK,:ROCKCLIMB,:ROLLOUT,:SKULLBASH,:SLEEPTALK,:WATERSPORT],
	:Moveset => [
		[1,:TACKLE],
		[1,:GROWL],
		[5,:DEFENSECURL],
		[9,:ROLLOUT],
		[13,:HEADBUTT],
		[17,:HYPERFANG],
		[21,:YAWN],
		[25,:CRUNCH],
		[29,:TAKEDOWN],
		[33,:SUPERFANG],
		[37,:SWORDSDANCE],
		[41,:AMNESIA],
		[45,:SUPERPOWER],
		[49,:CURSE]],
	:tmlist => [:FURYCUTTER,:THIEF,:TAUNT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:LASTRESORT,:ROCKCLIMB,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:EggGroups => [:Water1,:Field],
	:Height => 5,
	:Weight => 200,
	:kind => "Plump Mouse",
	:dexentry => "With nerves of steel, nothing can perturb it. It is more agile and active than it appears.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BIBAREL,:Level,15]
	]
},

:BIBAREL => {
	:name => "Bibarel",
	:dexnum => 400,
	:Type1 => :NORMAL,
	:Type2 => :WATER,
	:BaseStats => [79, 85, 60, 71, 55, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SIMPLE,:UNAWARE],
	:HiddenAbilities => :MOODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 127,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:WATERGUN],
		[1,:AQUAJET],
		[1,:ROTOTILLER],
		[1,:TACKLE],
		[1,:GROWL],
		[5,:DEFENSECURL],
		[9,:ROLLOUT],
		[13,:HEADBUTT],
		[18,:HYPERFANG],
		[23,:YAWN],
		[28,:CRUNCH],
		[33,:TAKEDOWN],
		[38,:SUPERFANG],
		[43,:SWORDSDANCE],
		[48,:AMNESIA],
		[53,:SUPERPOWER],
		[58,:CURSE]],
	:tmlist => [:FURYCUTTER,:THIEF,:FLING,:TAUNT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:ROLLOUT,:STEALTHROCK,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Water1,:Field],
	:Height => 10,
	:Weight => 315,
	:kind => "Beaver",
	:dexentry => "It makes its nest by damming streams with bark and mud. It is known as an industrious worker.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:KRICKETOT => {
	:name => "Kricketot",
	:dexnum => 401,
	:Type1 => :BUG,
	:BaseStats => [37, 25, 41, 25, 25, 41],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SHEDSKIN,:RUNAWAY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 39,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:GROWL],
		[1,:BIDE],
		[6,:STRUGGLEBUG],
		[16,:BUGBITE]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:MUDSLAP,:UPROAR,:SNORE,:ENDEAVOR,:SLEEPTALK,],
	:Color => "Red",
	:EggGroups => [:Bug],
	:Height => 3,
	:Weight => 22,
	:WildItemUncommon => :METRONOME,
	:kind => "Cricket",
	:dexentry => "It shakes its head back to front, causing its antennae to hit each other and sound like a xylophone.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:KRICKETUNE,:Level,10]
	]
},

:KRICKETUNE => {
	:name => "Kricketune",
	:dexnum => 402,
	:Type1 => :BUG,
	:BaseStats => [77, 85, 51, 65, 55, 51],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SWARM,:TECHNICIAN],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 134,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:FURYCUTTER],
		[1,:GROWL],
		[1,:BIDE],
		[14,:ABSORB],
		[18,:SING],
		[22,:FOCUSENERGY],
		[26,:SLASH],
		[30,:XSCISSOR],
		[34,:SCREECH],
		[36,:FELLSTINGER],
		[38,:TAUNT],
		[42,:NIGHTSLASH],
		[44,:STICKYWEB],
		[46,:BUGBUZZ],
		[50,:PERISHSONG]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:LEECHLIFE,:STRINGSHOT,:KNOCKOFF,:TAUNT,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:RAINDANCE,:POWERUPPUNCH,:LASERFOCUS,:THROATCHOP,],
	:Color => "Red",
	:EggGroups => [:Bug],
	:Height => 10,
	:Weight => 255,
	:WildItemUncommon => :METRONOME,
	:kind => "Cricket",
	:dexentry => "It crosses its knifelike arms in front of its chest when it cries. It can compose melodies ad lib.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:SHINX => {
	:name => "Shinx",
	:dexnum => 403,
	:Type1 => :ELECTRIC,
	:BaseStats => [45, 65, 34, 45, 40, 34],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:RIVALRY,:INTIMIDATE],
	:HiddenAbilities => :GUTS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 53,
	:CatchRate => 235,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:DOUBLEKICK,:EERIEIMPULSE,:FAKETEARS,:FIREFANG,:HELPINGHAND,:HOWL,:ICEFANG,:NIGHTSLASH,:QUICKATTACK,:SHOCKWAVE,:SIGNALBEAM,:SWIFT,:TAKEDOWN,:THUNDERFANG],
	:Moveset => [
		[1,:TACKLE],
		[5,:LEER],
		[9,:CHARGE],
		[11,:BABYDOLLEYES],
		[13,:SPARK],
		[17,:BITE],
		[21,:ROAR],
		[25,:SWAGGER],
		[29,:THUNDERFANG],
		[33,:CRUNCH],
		[37,:SCARYFACE],
		[41,:DISCHARGE],
		[45,:WILDCHARGE]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:SNARL,:THIEF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 95,
	:kind => "Flash",
	:dexentry => "All of its fur dazzles if danger is sensed. It flees while the foe is momentarily blinded.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LUXIO,:Level,15]
	]
},

:LUXIO => {
	:name => "Luxio",
	:dexnum => 404,
	:Type1 => :ELECTRIC,
	:BaseStats => [60, 85, 49, 60, 60, 49],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:RIVALRY,:INTIMIDATE],
	:HiddenAbilities => :GUTS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 127,
	:CatchRate => 120,
	:Happiness => 100,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:LEER],
		[5,:LEER],
		[9,:CHARGE],
		[13,:SPARK],
		[18,:BITE],
		[23,:ROAR],
		[28,:SWAGGER],
		[33,:THUNDERFANG],
		[38,:CRUNCH],
		[43,:SCARYFACE],
		[48,:DISCHARGE],
		[53,:WILDCHARGE]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:SNARL,:THIEF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 9,
	:Weight => 305,
	:kind => "Spark",
	:dexentry => "Its claws loose electricity with enough amperage to cause fainting. They live in small groups.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LUXRAY,:Level,30]
	]
},

:LUXRAY => {
	:name => "Luxray",
	:dexnum => 405,
	:Type1 => :ELECTRIC,
	:BaseStats => [80, 120, 79, 70, 95, 79],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:RIVALRY,:INTIMIDATE],
	:HiddenAbilities => :GUTS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 235,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ELECTRICTERRAIN],
		[1,:TACKLE],
		[1,:LEER],
		[1,:CHARGE],
		[5,:LEER],
		[9,:CHARGE],
		[13,:SPARK],
		[18,:BITE],
		[23,:ROAR],
		[28,:SWAGGER],
		[35,:THUNDERFANG],
		[42,:CRUNCH],
		[49,:SCARYFACE],
		[56,:DISCHARGE],
		[63,:WILDCHARGE],
		[67,:ELECTRICTERRAIN]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:SNARL,:THIEF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:SUPERPOWER,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:THROATCHOP,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 14,
	:Weight => 420,
	:kind => "Gleam Eyes",
	:dexentry => "It has eyes that can see through anything. It spots and captures prey hiding behind objects.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:BUDEW => {
	:name => "Budew",
	:dexnum => 406,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [40, 30, 35, 55, 50, 70],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:NATURALCURE,:POISONPOINT],
	:HiddenAbilities => :LEAFGUARD,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 56,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:COTTONSPORE,:EXTRASENSORY,:GIGADRAIN,:GRASSWHISTLE,:LEAFSTORM,:MINDREADER,:NATURALGIFT,:PINMISSILE,:RAZORLEAF,:SEEDBOMB,:SLEEPPOWDER,:SPIKES,:SYNTHESIS],
	:Moveset => [
		[1,:ABSORB],
		[4,:GROWTH],
		[7,:WATERSPORT],
		[10,:STUNSPORE],
		[13,:MEGADRAIN],
		[16,:WORRYSEED]],
	:tmlist => [:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:REST,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Green",
	:EggGroups => [:Undiscovered],
	:Height => 2,
	:Weight => 12,
	:WildItemUncommon => :POISONBARB,
	:kind => "Bud",
	:dexentry => "Over the winter, it closes its bud and endures the cold. In spring, the bud opens and releases pollen.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ROSELIA,:HappinessDay,0]
	]
},

:ROSERADE => {
	:name => "Roserade",
	:dexnum => 407,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [60, 70, 65, 90, 125, 105],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:NATURALCURE,:POISONPOINT],
	:HiddenAbilities => :TECHNICIAN,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 227,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:VENOMDRENCH],
		[1,:GRASSYTERRAIN],
		[1,:WEATHERBALL],
		[1,:POISONSTING],
		[1,:MEGADRAIN],
		[1,:MAGICALLEAF],
		[1,:SWEETSCENT]],
	:tmlist => [:FURYCUTTER,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,],
	:Color => "Green",
	:EggGroups => [:Fairy,:Grass],
	:Height => 9,
	:Weight => 145,
	:WildItemUncommon => :POISONBARB,
	:kind => "Bouquet",
	:dexentry => "It attracts prey with a sweet aroma, then downs it with thorny whips hidden in its arms.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:CRANIDOS => {
	:name => "Cranidos",
	:dexnum => 408,
	:Type1 => :ROCK,
	:BaseStats => [67, 125, 40, 58, 30, 30],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:MOLDBREAKER,:SHEERFORCE],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemEighth",
	:BaseEXP => 70,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:CRUNCH,:CURSE,:DOUBLEEDGE,:HAMMERARM,:IRONHEAD,:IRONTAIL,:LEER,:SLAM,:STOMP,:THRASH,:WHIRLWIND],
	:Moveset => [
		[1,:HEADBUTT],
		[1,:LEER],
		[6,:FOCUSENERGY],
		[10,:PURSUIT],
		[15,:TAKEDOWN],
		[19,:SCARYFACE],
		[24,:ASSURANCE],
		[28,:CHIPAWAY],
		[33,:ANCIENTPOWER],
		[37,:ZENHEADBUTT],
		[42,:SCREECH],
		[46,:HEADSMASH]],
	:tmlist => [:PAYBACK,:THIEF,:FLING,:DRAGONPULSE,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:SUPERPOWER,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Blue",
	:EggGroups => [:Monster],
	:Height => 9,
	:Weight => 315,
	:kind => "Head Butt",
	:dexentry => "It lived in jungles around 100 million years ago. Its skull is as hard as iron.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
	:evolutions => [
		[:RAMPARDOS,:Level,30]
	]
},

:RAMPARDOS => {
	:name => "Rampardos",
	:dexnum => 409,
	:Type1 => :ROCK,
	:BaseStats => [97, 165, 60, 58, 65, 50],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:MOLDBREAKER,:SHEERFORCE],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemEighth",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:Moveset => [
		[0,:ENDEAVOR],
		[1,:HEADBUTT],
		[1,:LEER],
		[1,:FOCUSENERGY],
		[1,:PURSUIT],
		[6,:FOCUSENERGY],
		[10,:PURSUIT],
		[15,:TAKEDOWN],
		[19,:SCARYFACE],
		[24,:ASSURANCE],
		[28,:CHIPAWAY],
		[36,:ANCIENTPOWER],
		[43,:ZENHEADBUTT],
		[51,:SCREECH],
		[58,:HEADSMASH]],
	:tmlist => [:PAYBACK,:THIEF,:FLING,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:SURF,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:EggGroups => [:Monster],
	:Height => 16,
	:Weight => 1025,
	:kind => "Head Butt",
	:dexentry => "Its powerful head-butt has enough power to shatter even the most durable things upon impact.",
	:BattlerPlayerY => 8,
	:BattlerEnemyY => 2,
	:BattlerAltitude => 0,
},

:SHIELDON => {
	:name => "Shieldon",
	:dexnum => 410,
	:Type1 => :ROCK,
	:Type2 => :STEEL,
	:BaseStats => [30, 42, 118, 30, 42, 88],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:STURDY,:SOUNDPROOF],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemEighth",
	:BaseEXP => 70,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:BODYSLAM,:COUNTER,:CURSE,:DOUBLEEDGE,:FISSURE,:FOCUSENERGY,:GUARDSPLIT,:HEADBUTT,:ROCKBLAST,:SCARYFACE,:SCREECH,:STEALTHROCK,:WIDEGUARD],
	:Moveset => [
		[1,:TACKLE],
		[1,:PROTECT],
		[6,:TAUNT],
		[10,:METALSOUND],
		[15,:TAKEDOWN],
		[19,:IRONDEFENSE],
		[24,:SWAGGER],
		[28,:ANCIENTPOWER],
		[33,:ENDURE],
		[37,:METALBURST],
		[42,:IRONHEAD],
		[46,:HEAVYSLAM]],
	:tmlist => [:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:MAGNETRISE,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Monster],
	:Height => 5,
	:Weight => 570,
	:kind => "Shield",
	:dexentry => "A Pokémon that lived in jungles around 100 million years ago. Its facial hide is extremely hard.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BASTIODON,:Level,30]
	]
},

:BASTIODON => {
	:name => "Bastiodon",
	:dexnum => 411,
	:Type1 => :ROCK,
	:Type2 => :STEEL,
	:BaseStats => [60, 52, 168, 30, 47, 138],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:STURDY,:SOUNDPROOF],
	:GrowthRate => "Erratic",
	:GenderRatio => "FemEighth",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7905,
	:Moveset => [
		[0,:BLOCK],
		[1,:TACKLE],
		[1,:PROTECT],
		[1,:TAUNT],
		[1,:METALSOUND],
		[6,:TAUNT],
		[10,:METALSOUND],
		[15,:TAKEDOWN],
		[19,:IRONDEFENSE],
		[24,:SWAGGER],
		[28,:ANCIENTPOWER],
		[36,:ENDURE],
		[43,:METALBURST],
		[51,:IRONHEAD],
		[58,:HEAVYSLAM]],
	:tmlist => [:TAUNT,:TORMENT,:OUTRAGE,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:MAGNETRISE,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROLEPLAY,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:EggGroups => [:Monster],
	:Height => 13,
	:Weight => 1495,
	:kind => "Shield",
	:dexentry => "Any frontal attack is repulsed. It is a docile Pokémon that feeds on grass and berries.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:BURMY => {
	:name => "Burmy",
	:dexnum => 412,
	:Type1 => :BUG,
	:BaseStats => [40, 29, 45, 36, 29, 45],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:SHEDSKIN,:OVERCOAT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 45,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:PROTECT],
		[10,:TACKLE],
		[15,:BUGBITE],
		[20,:HIDDENPOWER]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:ELECTROWEB,:SNORE,:SLEEPTALK,],
	:Color => "Gray",
	:EggGroups => [:Bug],
	:Height => 2,
	:Weight => 34,
	:kind => "Bagworm",
	:dexentry => "To shelter itself from cold, wintry winds, it covers itself with a cloak made of twigs and leaves.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 15,
	:evolutions => [
		[:WORMADAM,:LevelFemale,20],
		[:MOTHIM,:LevelMale,20]
	]
},

:WORMADAM => {
	:name => "Wormadam",
	:dexnum => 413,
	:Type1 => :BUG,
	:Type2 => :GRASS,
	:BaseStats => [60, 59, 85, 36, 79, 105],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:ANTICIPATION,:OVERCOAT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 148,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:QUIVERDANCE],
		[1,:SUCKERPUNCH],
		[1,:TACKLE],
		[1,:PROTECT],
		[1,:BUGBITE],
		[10,:PROTECT],
		[15,:BUGBITE],
		[20,:HIDDENPOWER],
		[23,:CONFUSION],
		[26,:RAZORLEAF],
		[29,:GROWTH],
		[32,:PSYBEAM],
		[35,:CAPTIVATE],
		[38,:FLAIL],
		[41,:ATTRACT],
		[44,:PSYCHIC],
		[47,:LEAFSTORM],
		[50,:BUGBUZZ]],
	:tmlist => [:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:SUCKERPUNCH,:THIEF,:ELECTROWEB,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:VENOSHOCK,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:REST,:SKILLSWAP,:TELEKINESIS,:ROLLOUT,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Gray",
	:EggGroups => [:Bug],
	:Height => 5,
	:Weight => 65,
	:WildItemUncommon => :SILVERPOWDER,
	:kind => "Bagworm",
	:dexentry => "When Burmy evolved, its cloak became a part of this Pokémon's body. The cloak is never shed.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 12,
},

:MOTHIM => {
	:name => "Mothim",
	:dexnum => 414,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [70, 94, 50, 66, 94, 50],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:SWARM,:TINTEDLENS],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemZero",
	:BaseEXP => 148,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:QUIVERDANCE],
		[1,:TACKLE],
		[1,:PROTECT],
		[1,:BUGBITE],
		[10,:PROTECT],
		[15,:BUGBITE],
		[20,:HIDDENPOWER],
		[23,:CONFUSION],
		[26,:GUST],
		[29,:POISONPOWDER],
		[32,:PSYBEAM],
		[35,:CAMOUFLAGE],
		[38,:SILVERWIND],
		[41,:AIRSLASH],
		[44,:PSYCHIC],
		[47,:LUNGE],
		[50,:BUGBUZZ]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:STRINGSHOT,:THIEF,:TWISTER,:ELECTROWEB,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:GIGADRAIN,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:VENOSHOCK,:TOXIC,:DREAMEATER,:PSYCHIC,:REST,:SKILLSWAP,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Yellow",
	:EggGroups => [:Bug],
	:Height => 9,
	:Weight => 233,
	:WildItemUncommon => :SILVERPOWDER,
	:kind => "Moth",
	:dexentry => "It loves the honey of flowers and steals honey collected by Combee.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 14,
},

:COMBEE => {
	:name => "Combee",
	:dexnum => 415,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [30, 30, 42, 70, 30, 42],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:HONEYGATHER,:HUSTLE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 49,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[1,:SWEETSCENT],
		[1,:GUST],
		[13,:BUGBITE],
		[29,:BUGBUZZ]],
	:tmlist => [:BUGBITE,:STRINGSHOT,:AIRCUTTER,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:SWIFT,:SNORE,:ENDEAVOR,:SLEEPTALK,],
	:Color => "Yellow",
	:EggGroups => [:Bug],
	:Height => 3,
	:Weight => 55,
	:WildItemUncommon => :HONEY,
	:kind => "Tiny Bee",
	:dexentry => "A Pokémon formed by three others. It busily carries sweet floral honey to Vespiquen.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 13,
	:evolutions => [
		[:VESPIQUEN,:LevelFemale,21]
	]
},

:VESPIQUEN => {
	:name => "Vespiquen",
	:dexnum => 416,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [70, 80, 102, 40, 80, 102],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:PRESSURE,:UNNERVE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 166,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 4080,
	:Moveset => [
		[0,:SLASH],
		[1,:FELLSTINGER],
		[1,:DESTINYBOND],
		[1,:SWEETSCENT],
		[1,:GUST],
		[1,:POISONSTING],
		[1,:CONFUSERAY],
		[5,:FURYCUTTER],
		[9,:PURSUIT],
		[13,:FURYSWIPES],
		[17,:DEFENDORDER],
		[25,:POWERGEM],
		[29,:HEALORDER],
		[33,:TOXIC],
		[37,:AIRSLASH],
		[41,:CAPTIVATE],
		[45,:ATTACKORDER],
		[49,:SWAGGER],
		[53,:DESTINYBOND],
		[57,:FELLSTINGER]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:STRINGSHOT,:THIEF,:FLING,:QUASH,:SUNNYDAY,:AERIALACE,:ACROBATICS,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:REST,:RAINDANCE,:CONFIDE,:INFESTATION,:LASERFOCUS,],
	:Color => "Yellow",
	:EggGroups => [:Bug],
	:Height => 12,
	:Weight => 385,
	:WildItemUncommon => :POISONBARB,
	:kind => "Beehive",
	:dexentry => "Its abdomen is a honeycomb for grubs. It raises its grubs on honey collected by Combee.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 14,
},

:PACHIRISU => {
	:name => "Pachirisu",
	:dexnum => 417,
	:Type1 => :ELECTRIC,
	:BaseStats => [60, 45, 70, 95, 45, 90],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:RUNAWAY,:PICKUP],
	:HiddenAbilities => :VOLTABSORB,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 142,
	:CatchRate => 200,
	:Happiness => 100,
	:EggSteps => 2805,
	:EggMoves => [:BABYDOLLEYES,:BESTOW,:BITE,:CHARGE,:COVET,:DEFENSECURL,:FAKETEARS,:FLAIL,:FLATTER,:FOLLOWME,:IONDELUGE,:IRONTAIL,:ROLLOUT,:TAILWHIP],
	:Moveset => [
		[1,:GROWL],
		[1,:BIDE],
		[5,:QUICKATTACK],
		[9,:CHARM],
		[13,:SPARK],
		[17,:ENDURE],
		[19,:NUZZLE],
		[21,:SWIFT],
		[25,:ELECTROBALL],
		[29,:SWEETKISS],
		[33,:THUNDERWAVE],
		[37,:SUPERFANG],
		[41,:DISCHARGE],
		[45,:LASTRESORT],
		[49,:HYPERFANG]],
	:tmlist => [:UTURN,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:SEEDBOMB,:GRASSKNOT,:MUDSLAP,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:LIGHTSCREEN,:REST,:ROLLOUT,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "White",
	:EggGroups => [:Field,:Fairy],
	:Height => 4,
	:Weight => 39,
	:kind => "EleSquirrel",
	:dexentry => "It makes fur balls that crackle with static electricity. It stores them with berries in tree holes.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:BUIZEL => {
	:name => "Buizel",
	:dexnum => 418,
	:Type1 => :WATER,
	:BaseStats => [55, 65, 35, 85, 60, 30],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SWIFTSWIM,:WATERVEIL],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AQUARING,:AQUATAIL,:BATONPASS,:DOUBLESLAP,:FURYCUTTER,:FURYSWIPES,:HEADBUTT,:HELPINGHAND,:MEFIRST,:MUDSLAP,:ODORSLEUTH,:SLASH,:SOAK,:SWITCHEROO,:TAILSLAP],
	:Moveset => [
		[1,:SONICBOOM],
		[4,:GROWL],
		[7,:WATERSPORT],
		[11,:QUICKATTACK],
		[15,:WATERGUN],
		[18,:PURSUIT],
		[21,:SWIFT],
		[24,:AQUAJET],
		[27,:DOUBLEHIT],
		[31,:WHIRLPOOL],
		[35,:RAZORWIND],
		[38,:AQUATAIL],
		[41,:AGILITY],
		[45,:HYDROPUMP]],
	:tmlist => [:FOCUSPUNCH,:BRICKBREAK,:ROCKSMASH,:BULKUP,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKTOMB,:IRONTAIL,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Brown",
	:EggGroups => [:Water1,:Field],
	:Height => 7,
	:Weight => 295,
	:kind => "Sea Weasel",
	:dexentry => "It has a flotation sac that is like an inflatable collar. It floats on water with its head out.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
	:evolutions => [
		[:FLOATZEL,:Level,26]
	]
},

:FLOATZEL => {
	:name => "Floatzel",
	:dexnum => 419,
	:Type1 => :WATER,
	:BaseStats => [85, 105, 55, 115, 85, 50],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:SWIFTSWIM,:WATERVEIL],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 173,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ICEFANG],
		[1,:CRUNCH],
		[1,:SONICBOOM],
		[1,:GROWL],
		[1,:WATERSPORT],
		[1,:QUICKATTACK],
		[4,:GROWL],
		[7,:WATERSPORT],
		[11,:QUICKATTACK],
		[15,:WATERGUN],
		[18,:PURSUIT],
		[21,:SWIFT],
		[24,:AQUAJET],
		[29,:DOUBLEHIT],
		[35,:WHIRLPOOL],
		[41,:RAZORWIND],
		[46,:AQUATAIL],
		[51,:AGILITY],
		[57,:HYDROPUMP]],
	:tmlist => [:PAYBACK,:TAUNT,:TORMENT,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:BULKUP,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKTOMB,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LIQUIDATION,],
	:Color => "Brown",
	:EggGroups => [:Water1,:Field],
	:Height => 11,
	:Weight => 335,
	:kind => "Sea Weasel",
	:dexentry => "It floats using its well-developed flotation sac. It assists in the rescues of drowning people.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 5,
	:BattlerAltitude => 0,
},

:CHERUBI => {
	:name => "Cherubi",
	:dexnum => 420,
	:Type1 => :GRASS,
	:BaseStats => [45, 35, 45, 35, 62, 53],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:CHLOROPHYLL],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 55,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AROMATHERAPY,:DEFENSECURL,:FLOWERSHIELD,:GRASSWHISTLE,:GRASSYTERRAIN,:HEALPULSE,:HEALINGWISH,:NATURALGIFT,:NATUREPOWER,:RAZORLEAF,:ROLLOUT,:SEEDBOMB,:SWEETSCENT,:TICKLE,:WEATHERBALL],
	:Moveset => [
		[1,:MORNINGSUN],
		[1,:TACKLE],
		[7,:GROWTH],
		[10,:LEECHSEED],
		[13,:HELPINGHAND],
		[19,:MAGICALLEAF],
		[22,:SUNNYDAY],
		[28,:WORRYSEED],
		[31,:TAKEDOWN],
		[37,:SOLARBEAM],
		[40,:LUCKYCHANT],
		[47,:PETALBLIZZARD]],
	:tmlist => [:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:ROLLOUT,],
	:Color => "Pink",
	:EggGroups => [:Fairy,:Grass],
	:Height => 4,
	:Weight => 33,
	:WildItemUncommon => :MIRACLESEED,
	:kind => "Cherry",
	:dexentry => "The small ball holds the nutrients needed for evolution. Apparently, it is very sweet and tasty.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CHERRIM,:Level,25]
	]
},

:CHERRIM => {
	:name => "Cherrim",
	:dexnum => 421,
	:Type1 => :GRASS,
	:BaseStats => [70, 60, 70, 85, 87, 78],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:FLOWERGIFT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 158,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:PETALDANCE],
		[1,:MORNINGSUN],
		[1,:TACKLE],
		[1,:GROWTH],
		[1,:LEECHSEED],
		[7,:GROWTH],
		[10,:LEECHSEED],
		[13,:HELPINGHAND],
		[19,:MAGICALLEAF],
		[22,:SUNNYDAY],
		[30,:WORRYSEED],
		[35,:TAKEDOWN],
		[43,:SOLARBEAM],
		[48,:LUCKYCHANT],
		[50,:PETALBLIZZARD]],
	:tmlist => [:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:ROLLOUT,:LASERFOCUS,],
	:Color => "Pink",
	:EggGroups => [:Fairy,:Grass],
	:Height => 5,
	:Weight => 93,
	:WildItemUncommon => :MIRACLESEED,
	:kind => "Blossom",
	:dexentry => "It blooms during times of strong sunlight. It tries to make up for everything it endured as a bud.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
},

:SHELLOS => {
	:name => "Shellos",
	:dexnum => 422,
	:Type1 => :WATER,
	:BaseStats => [76, 48, 48, 34, 57, 62],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:STICKYHOLD,:STORMDRAIN],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 65,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ACIDARMOR,:AMNESIA,:BRINE,:CLEARSMOG,:COUNTER,:CURSE,:FISSURE,:MEMENTO,:MIRRORCOAT,:MIST,:SLUDGE,:SPITUP,:STOCKPILE,:SWALLOW,:TRUMPCARD,:YAWN],
	:Moveset => [
		[1,:MUDSLAP],
		[2,:MUDSPORT],
		[4,:HARDEN],
		[7,:WATERPULSE],
		[11,:MUDBOMB],
		[16,:HIDDENPOWER],
		[22,:RAINDANCE],
		[29,:BODYSLAM],
		[37,:MUDDYWATER],
		[46,:RECOVER]],
	:tmlist => [:STRINGSHOT,:EARTHPOWER,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ANCIENTPOWER,:SURF,:DIVE,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Purple",
	:EggGroups => [:Water1,:Amorphous],
	:Height => 3,
	:Weight => 63,
	:kind => "Sea Slug",
	:dexentry => "Its colors and shapes differ from region to region. In the Sinnoh region, two types are confirmed.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GASTRODON,:Level,30]
	]
},

:GASTRODON => {
	:name => "Gastrodon",
	:dexnum => 423,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [111, 83, 68, 39, 92, 82],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:STICKYHOLD,:STORMDRAIN],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:MUDSLAP],
		[1,:MUDSPORT],
		[1,:HARDEN],
		[1,:WATERPULSE],
		[2,:MUDSPORT],
		[4,:HARDEN],
		[7,:WATERPULSE],
		[11,:MUDBOMB],
		[16,:HIDDENPOWER],
		[22,:RAINDANCE],
		[29,:BODYSLAM],
		[41,:MUDDYWATER],
		[54,:RECOVER]],
	:tmlist => [:STRINGSHOT,:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:STOMPINGTANTRUM,],
	:Color => "Purple",
	:EggGroups => [:Water1,:Amorphous],
	:Height => 9,
	:Weight => 299,
	:kind => "Sea Slug",
	:dexentry => "It has a pliable body without any bones. If any part of its body is torn off, it grows right back.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:AMBIPOM => {
	:name => "Ambipom",
	:dexnum => 424,
	:Type1 => :NORMAL,
	:BaseStats => [75, 100, 66, 115, 60, 66],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:TECHNICIAN,:PICKUP],
	:HiddenAbilities => :SKILLLINK,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 169,
	:CatchRate => 45,
	:Happiness => 100,
	:EggSteps => 5355,
	:Moveset => [
		[1,:DUALCHOP],
		[1,:SCRATCH],
		[1,:TAILWHIP],
		[1,:SANDATTACK],
		[1,:ASTONISH],
		[4,:SANDATTACK],
		[8,:ASTONISH],
		[11,:BATONPASS],
		[15,:TICKLE],
		[18,:FURYSWIPES],
		[22,:SWIFT],
		[25,:SCREECH],
		[29,:AGILITY],
		[32,:DOUBLEHIT],
		[36,:FLING],
		[39,:NASTYPLOT],
		[43,:LASTRESORT]],
	:tmlist => [:UTURN,:FURYCUTTER,:FOULPLAY,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:SNATCH,:TAUNT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:AERIALACE,:ACROBATICS,:SHADOWBALL,:SHADOWCLAW,:SPITE,:SOLARBEAM,:SEEDBOMB,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:DREAMEATER,:MAGICCOAT,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Purple",
	:EggGroups => [:Field],
	:Height => 12,
	:Weight => 203,
	:kind => "Long Tail",
	:dexentry => "To eat, it deftly shucks nuts with its two tails. It rarely uses its arms now.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:DRIFLOON => {
	:name => "Drifloon",
	:dexnum => 425,
	:Type1 => :GHOST,
	:Type2 => :FLYING,
	:BaseStats => [90, 50, 34, 70, 60, 44],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:AFTERMATH,:UNBURDEN],
	:HiddenAbilities => :FLAREBOOST,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 70,
	:CatchRate => 125,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:BODYSLAM,:CLEARSMOG,:DEFOG,:DESTINYBOND,:DISABLE,:HAZE,:HYPNOSIS,:MEMENTO,:TAILWIND,:WEATHERBALL],
	:Moveset => [
		[1,:CONSTRICT],
		[1,:MINIMIZE],
		[4,:ASTONISH],
		[8,:GUST],
		[13,:FOCUSENERGY],
		[16,:PAYBACK],
		[20,:OMINOUSWIND],
		[25,:STOCKPILE],
		[27,:HEX],
		[32,:SWALLOW],
		[32,:SPITUP],
		[36,:SHADOWBALL],
		[40,:AMNESIA],
		[44,:BATONPASS],
		[50,:EXPLOSION]],
	:tmlist => [:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:WILLOWISP,:ACROBATICS,:AIRCUTTER,:DEFOG,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SPITE,:MUDSLAP,:ICYWIND,:EXPLOSION,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:ROLLOUT,:GYROBALL,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:EggGroups => [:Amorphous],
	:Height => 4,
	:Weight => 12,
	:kind => "Balloon",
	:dexentry => "A Pokémon formed by the spirits of people and Pokémon. It loves damp, humid seasons.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 9,
	:evolutions => [
		[:DRIFBLIM,:Level,28]
	]
},

:DRIFBLIM => {
	:name => "Drifblim",
	:dexnum => 426,
	:Type1 => :GHOST,
	:Type2 => :FLYING,
	:BaseStats => [150, 80, 44, 80, 90, 54],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:AFTERMATH,:UNBURDEN],
	:HiddenAbilities => :FLAREBOOST,
	:GrowthRate => "Fluctuating",
	:GenderRatio => "FemHalf",
	:BaseEXP => 174,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 7905,
	:Moveset => [
		[1,:PHANTOMFORCE],
		[1,:CONSTRICT],
		[1,:MINIMIZE],
		[1,:ASTONISH],
		[1,:GUST],
		[4,:ASTONISH],
		[8,:GUST],
		[13,:FOCUSENERGY],
		[16,:PAYBACK],
		[20,:OMINOUSWIND],
		[25,:STOCKPILE],
		[27,:HEX],
		[34,:SWALLOW],
		[34,:SPITUP],
		[40,:SHADOWBALL],
		[46,:AMNESIA],
		[52,:BATONPASS],
		[60,:EXPLOSION],
		[65,:PHANTOMFORCE]],
	:tmlist => [:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:WILLOWISP,:FLY,:ACROBATICS,:AIRCUTTER,:DEFOG,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SPITE,:MUDSLAP,:ICYWIND,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:ROLLOUT,:GYROBALL,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:EggGroups => [:Amorphous],
	:Height => 12,
	:Weight => 150,
	:kind => "Blimp",
	:dexentry => "It is drowzy in daytime, but flies off in the evening in big groups. No one knows where they go.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 14,
},

:BUNEARY => {
	:name => "Buneary",
	:dexnum => 427,
	:Type1 => :NORMAL,
	:BaseStats => [55, 66, 44, 85, 44, 56],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:RUNAWAY,:KLUTZ],
	:HiddenAbilities => :LIMBER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 70,
	:CatchRate => 190,
	:Happiness => 0,
	:EggSteps => 5355,
	:EggMoves => [:CIRCLETHROW,:COPYCAT,:COSMICPOWER,:DOUBLEHIT,:ENCORE,:FAKEOUT,:FAKETEARS,:FIREPUNCH,:FLAIL,:FOCUSPUNCH,:ICEPUNCH,:LOWKICK,:MUDSPORT,:POWERUPPUNCH,:SKYUPPERCUT,:SWEETKISS,:SWITCHEROO,:TEETERDANCE,:THUNDERPUNCH],
	:Moveset => [
		[1,:FRUSTRATION],
		[1,:DEFENSECURL],
		[1,:SPLASH],
		[1,:POUND],
		[1,:FORESIGHT],
		[6,:ENDURE],
		[13,:BABYDOLLEYES],
		[16,:QUICKATTACK],
		[23,:JUMPKICK],
		[26,:BATONPASS],
		[33,:AGILITY],
		[36,:DIZZYPUNCH],
		[43,:AFTERYOU],
		[46,:CHARM],
		[50,:ENTRAINMENT],
		[56,:BOUNCE],
		[63,:HEALINGWISH]],
	:tmlist => [:FLING,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:DRAINPUNCH,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:ICEBEAM,:ICEPUNCH,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HEALBELL,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROLEPLAY,:IRONTAIL,:WATERPULSE,:RAINDANCE,:POWERUPPUNCH,],
	:Color => "Brown",
	:EggGroups => [:Field,:HumanLike],
	:Height => 4,
	:Weight => 55,
	:kind => "Rabbit",
	:dexentry => "It slams foes by sharply uncoiling its rolled ears. It stings enough to make a grown-up cry in pain.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LOPUNNY,:Happiness,0]
	]
},

:LOPUNNY => {
	:name => "Lopunny",
	:dexnum => 428,
	:Type1 => :NORMAL,
	:BaseStats => [65, 76, 84, 105, 54, 96],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:CUTECHARM,:KLUTZ],
	:HiddenAbilities => :LIMBER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 168,
	:CatchRate => 60,
	:Happiness => 140,
	:EggSteps => 5355,
	:Moveset => [
		[0,:RETURN],
		[1,:HEALINGWISH],
		[1,:BOUNCE],
		[1,:ROTOTILLER],
		[1,:MIRRORCOAT],
		[1,:MAGICCOAT],
		[1,:DEFENSECURL],
		[1,:SPLASH],
		[1,:POUND],
		[1,:FORESIGHT],
		[6,:ENDURE],
		[13,:BABYDOLLEYES],
		[16,:QUICKATTACK],
		[23,:JUMPKICK],
		[26,:BATONPASS],
		[33,:AGILITY],
		[36,:DIZZYPUNCH],
		[43,:AFTERYOU],
		[46,:CHARM],
		[53,:ENTRAINMENT],
		[56,:BOUNCE],
		[63,:HEALINGWISH],
		[66,:HIJUMPKICK]],
	:tmlist => [:FURYCUTTER,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HEALBELL,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROLEPLAY,:IRONTAIL,:WATERPULSE,:RAINDANCE,:POWERUPPUNCH,:BRUTALSWING,:LASERFOCUS,],
	:Color => "Brown",
	:EggGroups => [:Field,:HumanLike],
	:Height => 12,
	:Weight => 333,
	:kind => "Rabbit",
	:dexentry => "An extremely cautious Pokémon. It cloaks its body with its fluffy ear fur when it senses danger.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:MISMAGIUS => {
	:name => "Mismagius",
	:dexnum => 429,
	:Type1 => :GHOST,
	:BaseStats => [60, 60, 60, 105, 105, 105],
	:EVs => [0, 0, 0, 0, 1, 1],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 6630,
	:Moveset => [
		[1,:MYSTICALFIRE],
		[1,:POWERGEM],
		[1,:PHANTOMFORCE],
		[1,:LUCKYCHANT],
		[1,:MAGICALLEAF],
		[1,:GROWL],
		[1,:PSYWAVE],
		[1,:SPITE],
		[1,:ASTONISH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWBALL,:OMINOUSWIND,:SPITE,:ENERGYBALL,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:MAGICROOM,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,],
	:Color => "Purple",
	:EggGroups => [:Amorphous],
	:Height => 9,
	:Weight => 44,
	:kind => "Magical",
	:dexentry => "Its cries sound like incantations. Those hearing them are tormented by headaches and hallucinations.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 8,
},

:HONCHKROW => {
	:name => "Honchkrow",
	:dexnum => 430,
	:Type1 => :DARK,
	:Type2 => :FLYING,
	:BaseStats => [100, 125, 52, 71, 105, 52],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INSOMNIA,:SUPERLUCK],
	:HiddenAbilities => :MOXIE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 177,
	:CatchRate => 30,
	:Happiness => 35,
	:EggSteps => 5355,
	:Moveset => [
		[1,:NIGHTSLASH],
		[1,:SUCKERPUNCH],
		[1,:ASTONISH],
		[1,:PURSUIT],
		[1,:HAZE],
		[1,:WINGATTACK],
		[25,:SWAGGER],
		[35,:NASTYPLOT],
		[45,:FOULPLAY],
		[55,:NIGHTSLASH],
		[65,:QUASH],
		[75,:DARKPULSE]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:EMBARGO,:QUASH,:SNATCH,:TAUNT,:TORMENT,:TWISTER,:THUNDERWAVE,:SUPERPOWER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SPITE,:MUDSLAP,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:CALMMIND,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Black",
	:EggGroups => [:Flying],
	:Height => 9,
	:Weight => 273,
	:kind => "Big Boss",
	:dexentry => "Becoming active at night, it is known to swarm with numerous Murkrow in tow.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:GLAMEOW => {
	:name => "Glameow",
	:dexnum => 431,
	:Type1 => :NORMAL,
	:BaseStats => [49, 55, 42, 85, 42, 37],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:LIMBER,:OWNTEMPO],
	:HiddenAbilities => :KEENEYE,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 62,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ASSURANCE,:BITE,:FAKETEARS,:FLAIL,:LASTRESORT,:QUICKATTACK,:SANDATTACK,:SNATCH,:TAILWHIP,:WAKEUPSLAP],
	:Moveset => [
		[1,:FAKEOUT],
		[5,:SCRATCH],
		[8,:GROWL],
		[13,:HYPNOSIS],
		[17,:FEINTATTACK],
		[20,:FURYSWIPES],
		[25,:CHARM],
		[29,:ASSIST],
		[32,:CAPTIVATE],
		[37,:SLASH],
		[41,:SUCKERPUNCH],
		[44,:ATTRACT],
		[48,:HONECLAWS],
		[50,:PLAYROUGH]],
	:tmlist => [:UTURN,:FURYCUTTER,:FOULPLAY,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:MUDSLAP,:LASTRESORT,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 39,
	:kind => "Catty",
	:dexentry => "It claws if displeased and purrs when affectionate. Its fickleness is very popular among some.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PURUGLY,:Level,38]
	]
},

:PURUGLY => {
	:name => "Purugly",
	:dexnum => 432,
	:Type1 => :NORMAL,
	:BaseStats => [71, 82, 64, 112, 64, 59],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:THICKFAT,:OWNTEMPO],
	:HiddenAbilities => :DEFIANT,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 158,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SWAGGER],
		[1,:FAKEOUT],
		[1,:SCRATCH],
		[1,:GROWL],
		[5,:SCRATCH],
		[8,:GROWL],
		[13,:HYPNOSIS],
		[17,:FEINTATTACK],
		[20,:FURYSWIPES],
		[25,:CHARM],
		[29,:ASSIST],
		[32,:CAPTIVATE],
		[37,:SLASH],
		[45,:BODYSLAM],
		[52,:ATTRACT],
		[60,:HONECLAWS]],
	:tmlist => [:UTURN,:FURYCUTTER,:FOULPLAY,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:REST,:ROLLOUT,:IRONTAIL,:WATERPULSE,:RAINDANCE,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 438,
	:kind => "Tiger Cat",
	:dexentry => "It is a brazen brute that barges its way into another Pokémon's nest and claims it as its own.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:CHINGLING => {
	:name => "Chingling",
	:dexnum => 433,
	:Type1 => :PSYCHIC,
	:BaseStats => [45, 30, 50, 45, 65, 50],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 57,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:COSMICPOWER,:CURSE,:DISABLE,:FUTURESIGHT,:HYPNOSIS,:RECOVER,:SKILLSWAP,:STOREDPOWER,:WISH],
	:Moveset => [
		[1,:WRAP],
		[4,:GROWL],
		[7,:ASTONISH],
		[10,:CONFUSION],
		[13,:YAWN],
		[16,:LASTRESORT],
		[19,:ENTRAINMENT],
		[32,:UPROAR]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:SHADOWBALL,:GRASSKNOT,:ICYWIND,:HYPERVOICE,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:ROLLOUT,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Yellow",
	:EggGroups => [:Undiscovered],
	:Height => 2,
	:Weight => 6,
	:WildItemUncommon => :CLEANSETAG,
	:kind => "Bell",
	:dexentry => "It emits cries by agitating an orb at the back of its throat. It moves with flouncing hops.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 12,
	:evolutions => [
		[:CHIMECHO,:HappinessNight,0]
	]
},

:STUNKY => {
	:name => "Stunky",
	:dexnum => 434,
	:Type1 => :POISON,
	:Type2 => :DARK,
	:BaseStats => [63, 63, 47, 74, 41, 41],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:STENCH,:AFTERMATH],
	:HiddenAbilities => :KEENEYE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 225,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:ASTONISH,:CRUNCH,:DOUBLEEDGE,:FLAMEBURST,:FOULPLAY,:HAZE,:IRONTAIL,:LEER,:PLAYROUGH,:PUNISHMENT,:PURSUIT,:SCARYFACE,:SMOG],
	:Moveset => [
		[1,:SCRATCH],
		[1,:FOCUSENERGY],
		[3,:POISONGAS],
		[7,:SCREECH],
		[9,:FURYSWIPES],
		[13,:SMOKESCREEN],
		[15,:FEINT],
		[19,:ACIDSPRAY],
		[21,:BITE],
		[25,:SLASH],
		[27,:TOXIC],
		[31,:NIGHTSLASH],
		[33,:MEMENTO],
		[39,:SUCKERPUNCH],
		[43,:BELCH],
		[45,:EXPLOSION]],
	:tmlist => [:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:SNATCH,:TAUNT,:TORMENT,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:DEFOG,:SHADOWBALL,:SHADOWCLAW,:MUDSLAP,:EXPLOSION,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:THROATCHOP,],
	:Color => "Purple",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 192,
	:kind => "Skunk",
	:dexentry => "It protects itself by spraying a noxious fluid from its rear. The stench lingers for 24 hours.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SKUNTANK,:Level,34]
	]
},

:SKUNTANK => {
	:name => "Skuntank",
	:dexnum => 435,
	:Type1 => :POISON,
	:Type2 => :DARK,
	:BaseStats => [103, 93, 67, 84, 71, 61],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:STENCH,:AFTERMATH],
	:HiddenAbilities => :KEENEYE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 168,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:FLAMETHROWER],
		[1,:SCRATCH],
		[1,:FOCUSENERGY],
		[1,:POISONGAS],
		[1,:SCREECH],
		[3,:POISONGAS],
		[7,:SCREECH],
		[9,:FURYSWIPES],
		[13,:SMOKESCREEN],
		[15,:FEINT],
		[19,:ACIDSPRAY],
		[21,:BITE],
		[25,:SLASH],
		[27,:TOXIC],
		[31,:NIGHTSLASH],
		[33,:MEMENTO],
		[37,:VENOMDRENCH],
		[39,:SUCKERPUNCH],
		[43,:BELCH],
		[45,:EXPLOSION]],
	:tmlist => [:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:SNATCH,:TAUNT,:TORMENT,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:DEFOG,:SHADOWBALL,:SHADOWCLAW,:MUDSLAP,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:THROATCHOP,],
	:Color => "Purple",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 380,
	:kind => "Skunk",
	:dexentry => "It sprays a vile-smelling fluid from the tip of its tail to attack. Its range is over 160 feet.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:BRONZOR => {
	:name => "Bronzor",
	:dexnum => 436,
	:Type1 => :STEEL,
	:Type2 => :PSYCHIC,
	:BaseStats => [57, 24, 86, 23, 24, 86],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:LEVITATE,:HEATPROOF],
	:HiddenAbilities => :HEAVYMETAL,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 60,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TACKLE],
		[1,:CONFUSION],
		[5,:HYPNOSIS],
		[9,:IMPRISON],
		[11,:CONFUSERAY],
		[15,:PSYWAVE],
		[19,:IRONDEFENSE],
		[21,:FEINTATTACK],
		[25,:SAFEGUARD],
		[29,:FUTURESIGHT],
		[31,:METALSOUND],
		[35,:GYROBALL],
		[39,:EXTRASENSORY],
		[41,:PAYBACK],
		[45,:HEALBLOCK],
		[49,:HEAVYSLAM]],
	:tmlist => [:SIGNALBEAM,:PAYBACK,:CHARGEBEAM,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,],
	:Color => "Green",
	:EggGroups => [:Mineral],
	:Height => 5,
	:Weight => 605,
	:WildItemUncommon => :METALCOAT,
	:kind => "Bronze",
	:dexentry => "Implements shaped like it were discovered in ancient tombs. It is unknown if they are related.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 13,
	:evolutions => [
		[:BRONZONG,:Level,33]
	]
},

:BRONZONG => {
	:name => "Bronzong",
	:dexnum => 437,
	:Type1 => :STEEL,
	:Type2 => :PSYCHIC,
	:BaseStats => [67, 89, 116, 33, 79, 116],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:LEVITATE,:HEATPROOF],
	:HiddenAbilities => :HEAVYMETAL,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 175,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:BLOCK],
		[1,:SUNNYDAY],
		[1,:RAINDANCE],
		[1,:TACKLE],
		[1,:CONFUSION],
		[1,:HYPNOSIS],
		[1,:IMPRISON],
		[5,:HYPNOSIS],
		[9,:IMPRISON],
		[11,:CONFUSERAY],
		[15,:PSYWAVE],
		[19,:IRONDEFENSE],
		[21,:FEINTATTACK],
		[25,:SAFEGUARD],
		[29,:FUTURESIGHT],
		[31,:METALSOUND],
		[36,:GYROBALL],
		[42,:EXTRASENSORY],
		[46,:PAYBACK],
		[52,:HEALBLOCK],
		[58,:HEAVYSLAM]],
	:tmlist => [:SIGNALBEAM,:PAYBACK,:CHARGEBEAM,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,],
	:Color => "Green",
	:EggGroups => [:Mineral],
	:Height => 13,
	:Weight => 1870,
	:WildItemUncommon => :METALCOAT,
	:kind => "Bronze Bell",
	:dexentry => "One caused a news sensation when it was dug up at a construction site after a 2,000-year sleep.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 13,
},

:BONSLY => {
	:name => "Bonsly",
	:dexnum => 438,
	:Type1 => :ROCK,
	:BaseStats => [50, 80, 95, 10, 10, 45],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:STURDY,:ROCKHEAD],
	:HiddenAbilities => :RATTLED,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:CURSE,:DEFENSECURL,:ENDURE,:HARDEN,:HEADBUTT,:ROLLOUT,:SANDTOMB,:SELFDESTRUCT,:STEALTHROCK],
	:Moveset => [
		[1,:FAKETEARS],
		[1,:COPYCAT],
		[5,:FLAIL],
		[8,:LOWKICK],
		[12,:ROCKTHROW],
		[15,:MIMIC],
		[19,:FEINTATTACK],
		[22,:TEARFULLOOK],
		[26,:ROCKTOMB],
		[29,:BLOCK],
		[33,:ROCKSLIDE],
		[36,:COUNTER],
		[40,:SUCKERPUNCH],
		[43,:DOUBLEEDGE]],
	:tmlist => [:FOULPLAY,:SUCKERPUNCH,:THIEF,:BRICKBREAK,:LOWKICK,:SUNNYDAY,:EARTHPOWER,:EXPLOSION,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:NATUREPOWER,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:CALMMIND,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Undiscovered],
	:Height => 5,
	:Weight => 150,
	:kind => "Bonsai",
	:dexentry => "It looks as if it is always crying. It is actually adjusting its body's fluid levels by eliminating excess.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SUDOWOODO,:HasMove,382]
	]
},

:MIMEJR => {
	:name => "Mime Jr.",
	:dexnum => 439,
	:Type1 => :PSYCHIC,
	:Type2 => :FAIRY,
	:BaseStats => [20, 25, 45, 60, 70, 90],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:SOUNDPROOF,:FILTER],
	:HiddenAbilities => :TECHNICIAN,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 62,
	:CatchRate => 145,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:CHARM,:CONFUSERAY,:FAKEOUT,:FUTURESIGHT,:HEALINGWISH,:HYPNOSIS,:ICYWIND,:MAGICROOM,:MIMIC,:NASTYPLOT,:POWERSPLIT,:PSYCHICTERRAIN,:TEETERDANCE,:TRICK,:WAKEUPSLAP],
	:Moveset => [
		[1,:TICKLE],
		[1,:BARRIER],
		[1,:POUND],
		[1,:CONFUSION],
		[4,:COPYCAT],
		[8,:MEDITATE],
		[11,:DOUBLESLAP],
		[15,:MIMIC],
		[18,:ENCORE],
		[22,:LIGHTSCREEN],
		[22,:REFLECT],
		[25,:PSYBEAM],
		[29,:SUBSTITUTE],
		[32,:RECYCLE],
		[36,:TRICK],
		[39,:PSYCHIC],
		[43,:ROLEPLAY],
		[46,:BATONPASS],
		[50,:SAFEGUARD]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:ICYWIND,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Pink",
	:EggGroups => [:Undiscovered],
	:Height => 6,
	:Weight => 130,
	:kind => "Mime",
	:dexentry => "It habitually mimics foes. Once mimicked, the foe cannot take its eyes off this Pokémon.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MRMIME,:HasMove,382]
	]
},

:HAPPINY => {
	:name => "Happiny",
	:dexnum => 440,
	:Type1 => :NORMAL,
	:BaseStats => [100, 5, 5, 30, 15, 65],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:NATURALCURE,:SERENEGRACE],
	:HiddenAbilities => :FRIENDGUARD,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 110,
	:CatchRate => 130,
	:Happiness => 140,
	:EggSteps => 10455,
	:EggMoves => [:AROMATHERAPY,:COUNTER,:ENDURE,:GRAVITY,:HEALBELL,:HELPINGHAND,:LASTRESORT,:METRONOME,:MUDBOMB,:NATURALGIFT,:PRESENT],
	:Moveset => [
		[1,:POUND],
		[1,:CHARM],
		[5,:COPYCAT],
		[9,:REFRESH],
		[12,:SWEETKISS]],
	:tmlist => [:FLING,:SHOCKWAVE,:THUNDERWAVE,:DRAINPUNCH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:ICYWIND,:HAIL,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:GRAVITY,:LIGHTSCREEN,:REST,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Pink",
	:EggGroups => [:Undiscovered],
	:Height => 6,
	:Weight => 244,
	:WildItemCommon => :OVALSTONE,
	:kind => "Playhouse",
	:dexentry => "It loves round white things. It carries an egg-shaped rock in imitation of Chansey.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CHANSEY,:DayHoldItem,:OVALSTONE]
	]
},

:CHATOT => {
	:name => "Chatot",
	:dexnum => 441,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [76, 65, 45, 91, 92, 42],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:KEENEYE,:TANGLEDFEET],
	:HiddenAbilities => :BIGPECKS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 30,
	:Happiness => 35,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:AIRCUTTER,:BOOMBURST,:DEFOG,:ENCORE,:NASTYPLOT,:NIGHTSHADE,:SLEEPTALK,:STEELWING,:SUPERSONIC],
	:Moveset => [
		[1,:HYPERVOICE],
		[1,:CHATTER],
		[1,:CONFIDE],
		[1,:TAUNT],
		[1,:PECK],
		[5,:GROWL],
		[9,:MIRRORMOVE],
		[13,:SING],
		[17,:FURYATTACK],
		[21,:CHATTER],
		[25,:TAUNT],
		[29,:ROUND],
		[33,:MIMIC],
		[37,:ECHOEDVOICE],
		[41,:ROOST],
		[45,:UPROAR],
		[49,:SYNCHRONOISE],
		[50,:FEATHERDANCE],
		[57,:HYPERVOICE]],
	:tmlist => [:UTURN,:THIEF,:TAUNT,:TORMENT,:TWISTER,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:OMINOUSWIND,:MUDSLAP,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:MAGICCOAT,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Black",
	:EggGroups => [:Flying],
	:Height => 5,
	:Weight => 19,
	:WildItemUncommon => :METRONOME,
	:kind => "Music Note",
	:dexentry => "It can learn and speak human words. If they gather, they all learn the same saying.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:SPIRITOMB => {
	:name => "Spiritomb",
	:dexnum => 442,
	:Type1 => :GHOST,
	:Type2 => :DARK,
	:BaseStats => [50, 92, 108, 35, 92, 108],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:PRESSURE,:INFILTRATOR],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 170,
	:CatchRate => 100,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:CAPTIVATE,:DESTINYBOND,:DISABLE,:FOULPLAY,:GRUDGE,:IMPRISON,:NIGHTMARE,:PAINSPLIT,:SHADOWSNEAK,:SMOKESCREEN],
	:Moveset => [
		[1,:CURSE],
		[1,:PURSUIT],
		[1,:CONFUSERAY],
		[1,:SPITE],
		[1,:SHADOWSNEAK],
		[7,:FEINTATTACK],
		[13,:HYPNOSIS],
		[19,:DREAMEATER],
		[25,:OMINOUSWIND],
		[31,:SUCKERPUNCH],
		[37,:NASTYPLOT],
		[43,:MEMENTO],
		[49,:DARKPULSE]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:THIEF,:EMBARGO,:QUASH,:SNATCH,:TAUNT,:TORMENT,:SHOCKWAVE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:OMINOUSWIND,:SPITE,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:REST,:TELEKINESIS,:TRICK,:WONDERROOM,:ROCKTOMB,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Purple",
	:EggGroups => [:Amorphous],
	:Height => 10,
	:Weight => 1080,
	:kind => "Forbidden",
	:dexentry => "A Pokémon that was formed by 108 spirits. It is bound to a fissure in an odd keystone.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:GIBLE => {
	:name => "Gible",
	:dexnum => 443,
	:Type1 => :DRAGON,
	:Type2 => :GROUND,
	:BaseStats => [58, 70, 45, 42, 40, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SANDVEIL,:ROUGHSKIN],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 10455,
	:EggMoves => [:BODYSLAM,:DOUBLEEDGE,:DRAGONBREATH,:IRONHEAD,:IRONTAIL,:METALCLAW,:MUDSHOT,:OUTRAGE,:ROCKCLIMB,:SANDTOMB,:SCARYFACE,:THRASH,:TWISTER],
	:Moveset => [
		[1,:TACKLE],
		[3,:SANDATTACK],
		[7,:DRAGONRAGE],
		[13,:SANDSTORM],
		[15,:TAKEDOWN],
		[19,:SANDTOMB],
		[25,:SLASH],
		[27,:DRAGONCLAW],
		[31,:DIG],
		[37,:DRAGONRUSH]],
	:tmlist => [:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:TWISTER,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:EggGroups => [:Monster,:Dragon],
	:Height => 7,
	:Weight => 205,
	:kind => "Land Shark",
	:dexentry => "It nests in small, horizontal holes in cave walls. It pounces to catch prey that strays too close.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GABITE,:Level,24]
	]
},

:GABITE => {
	:name => "Gabite",
	:dexnum => 444,
	:Type1 => :DRAGON,
	:Type2 => :GROUND,
	:BaseStats => [68, 90, 65, 82, 50, 55],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SANDVEIL,:ROUGHSKIN],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 10455,
	:Moveset => [
		[0,:DUALCHOP],
		[1,:TACKLE],
		[1,:SANDATTACK],
		[1,:DRAGONRAGE],
		[3,:SANDATTACK],
		[7,:DRAGONRAGE],
		[13,:SANDSTORM],
		[15,:TAKEDOWN],
		[19,:SANDTOMB],
		[28,:SLASH],
		[33,:DRAGONCLAW],
		[40,:DIG],
		[49,:DRAGONRUSH]],
	:tmlist => [:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DUALCHOP,:TWISTER,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Blue",
	:EggGroups => [:Monster,:Dragon],
	:Height => 14,
	:Weight => 560,
	:kind => "Cave",
	:dexentry => "There is a long-held belief that medicine made from its scales will heal even incurable illnesses.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GARCHOMP,:Level,48]
	]
},

:GARCHOMP => {
	:name => "Garchomp",
	:dexnum => 445,
	:Type1 => :DRAGON,
	:Type2 => :GROUND,
	:BaseStats => [108, 130, 95, 102, 80, 85],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:SANDVEIL,:ROUGHSKIN],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 270,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 10455,
	:Moveset => [
		[0,:CRUNCH],
		[1,:DUALCHOP],
		[1,:FIREFANG],
		[1,:TACKLE],
		[1,:SANDATTACK],
		[1,:DRAGONRAGE],
		[1,:SANDSTORM],
		[3,:SANDATTACK],
		[7,:DRAGONRAGE],
		[13,:SANDSTORM],
		[15,:TAKEDOWN],
		[19,:SANDTOMB],
		[28,:SLASH],
		[33,:DRAGONCLAW],
		[40,:DIG],
		[55,:DRAGONRUSH]],
	:tmlist => [:FURYCUTTER,:FLING,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:DUALCHOP,:TWISTER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:SURF,:AQUATAIL,:RAINDANCE,:CONFIDE,:BRUTALSWING,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:EggGroups => [:Monster,:Dragon],
	:Height => 19,
	:Weight => 950,
	:kind => "Mach",
	:dexentry => "When it folds up its body and extends its wings, it looks like a jet plane. It flies at sonic speed.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 4,
	:BattlerAltitude => 0,
},

:MUNCHLAX => {
	:name => "Munchlax",
	:dexnum => 446,
	:Type1 => :NORMAL,
	:BaseStats => [135, 85, 40, 5, 40, 85],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:PICKUP,:THICKFAT],
	:HiddenAbilities => :GLUTTONY,
	:GrowthRate => "Slow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 78,
	:CatchRate => 50,
	:Happiness => 70,
	:EggSteps => 10455,
	:EggMoves => [:AFTERYOU,:BELCH,:CHARM,:COUNTER,:CURSE,:DOUBLEEDGE,:LICK,:NATURALGIFT,:PURSUIT,:SELFDESTRUCT,:WHIRLWIND,:ZENHEADBUTT],
	:Moveset => [
		[1,:LASTRESORT],
		[1,:RECYCLE],
		[1,:LICK],
		[1,:METRONOME],
		[1,:ODORSLEUTH],
		[1,:TACKLE],
		[4,:DEFENSECURL],
		[9,:AMNESIA],
		[12,:LICK],
		[17,:CHIPAWAY],
		[20,:SCREECH],
		[25,:BODYSLAM],
		[28,:STOCKPILE],
		[33,:SWALLOW],
		[36,:ROLLOUT],
		[41,:FLING],
		[44,:BELLYDRUM],
		[49,:NATURALGIFT],
		[50,:SNATCH],
		[57,:LASTRESORT]],
	:tmlist => [:FLING,:SNATCH,:OUTRAGE,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:SEEDBOMB,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:PSYCHIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:SURF,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Black",
	:EggGroups => [:Undiscovered],
	:Height => 6,
	:Weight => 1050,
	:WildItemCommon => :LEFTOVERS,
	:WildItemUncommon => :LEFTOVERS,
	:WildItemRare => :LEFTOVERS,
	:kind => "Big Eater",
	:dexentry => "It wolfs down its weight in food once a day, swallowing food whole with almost no chewing.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SNORLAX,:Happiness,0]
	]
},

:RIOLU => {
	:name => "Riolu",
	:dexnum => 447,
	:Type1 => :FIGHTING,
	:BaseStats => [40, 70, 40, 60, 35, 40],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:STEADFAST,:INNERFOCUS],
	:HiddenAbilities => :PRANKSTER,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 57,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:AGILITY,:BITE,:BLAZEKICK,:BULLETPUNCH,:CIRCLETHROW,:CROSSCHOP,:CRUNCH,:DETECT,:FOLLOWME,:HIJUMPKICK,:IRONDEFENSE,:LOWKICK,:METEORMASH,:MINDREADER,:SKYUPPERCUT,:VACUUMWAVE],
	:Moveset => [
		[1,:FORESIGHT],
		[1,:QUICKATTACK],
		[1,:ENDURE],
		[6,:COUNTER],
		[11,:FEINT],
		[15,:FORCEPALM],
		[19,:COPYCAT],
		[24,:SCREECH],
		[29,:REVERSAL],
		[47,:NASTYPLOT],
		[50,:FINALGAMBIT]],
	:tmlist => [:FURYCUTTER,:PAYBACK,:FLING,:DUALCHOP,:THUNDERPUNCH,:MAGNETRISE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:SUNNYDAY,:SHADOWCLAW,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:ZENHEADBUTT,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Blue",
	:EggGroups => [:Undiscovered],
	:Height => 7,
	:Weight => 202,
	:kind => "Emanation",
	:dexentry => "The aura that emanates from its body intensifies to alert others if it is afraid or sad.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LUCARIO,:HappinessDay,0]
	]
},

:LUCARIO => {
	:name => "Lucario",
	:dexnum => 448,
	:Type1 => :FIGHTING,
	:Type2 => :STEEL,
	:BaseStats => [70, 110, 70, 90, 115, 70],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:STEADFAST,:INNERFOCUS],
	:HiddenAbilities => :JUSTIFIED,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 184,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[0,:AURASPHERE],
		[1,:LASERFOCUS],
		[1,:FORESIGHT],
		[1,:QUICKATTACK],
		[1,:DETECT],
		[1,:METALCLAW],
		[6,:COUNTER],
		[11,:FEINT],
		[15,:POWERUPPUNCH],
		[19,:SWORDSDANCE],
		[24,:METALSOUND],
		[29,:BONERUSH],
		[33,:QUICKGUARD],
		[37,:MEFIRST],
		[42,:WORKUP],
		[47,:CALMMIND],
		[51,:HEALPULSE],
		[55,:CLOSECOMBAT],
		[60,:DRAGONPULSE],
		[65,:EXTREMESPEED]],
	:tmlist => [:FURYCUTTER,:DARKPULSE,:PAYBACK,:FLING,:DRAGONPULSE,:DUALCHOP,:THUNDERPUNCH,:MAGNETRISE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:SUNNYDAY,:SHADOWBALL,:SHADOWCLAW,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:PSYCHIC,:ZENHEADBUTT,:CALMMIND,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:FLASHCANNON,:IRONDEFENSE,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Blue",
	:EggGroups => [:Field,:HumanLike],
	:Height => 12,
	:Weight => 540,
	:kind => "Aura",
	:dexentry => "It has the ability to sense the auras of all things. It understands human speech.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:HIPPOPOTAS => {
	:name => "Hippopotas",
	:dexnum => 449,
	:Type1 => :GROUND,
	:BaseStats => [68, 72, 78, 32, 38, 42],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SANDSTREAM,:SANDFORCE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 140,
	:Happiness => 70,
	:EggSteps => 7905,
	:EggMoves => [:BODYSLAM,:CURSE,:REVENGE,:SANDTOMB,:SLACKOFF,:SLEEPTALK,:SPITUP,:STOCKPILE,:SWALLOW,:WHIRLWIND],
	:Moveset => [
		[1,:TACKLE],
		[1,:SANDATTACK],
		[7,:BITE],
		[13,:YAWN],
		[19,:TAKEDOWN],
		[19,:DIG],
		[25,:SANDTOMB],
		[31,:CRUNCH],
		[37,:EARTHQUAKE],
		[44,:DOUBLEEDGE],
		[50,:FISSURE]],
	:tmlist => [:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:WATERPULSE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 8,
	:Weight => 495,
	:kind => "Hippo",
	:dexentry => "It lives in arid places. Instead of perspiration, it expels grainy sand from its body.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:HIPPOWDON,:Level,34]
	]
},

:HIPPOWDON => {
	:name => "Hippowdon",
	:dexnum => 450,
	:Type1 => :GROUND,
	:BaseStats => [108, 112, 118, 47, 68, 72],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SANDSTREAM,:SANDFORCE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 184,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 7905,
	:Moveset => [
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:TACKLE],
		[1,:SANDATTACK],
		[1,:BITE],
		[1,:YAWN],
		[7,:BITE],
		[13,:YAWN],
		[19,:TAKEDOWN],
		[19,:DIG],
		[25,:SANDTOMB],
		[31,:CRUNCH],
		[40,:EARTHQUAKE],
		[50,:DOUBLEEDGE],
		[60,:FISSURE]],
	:tmlist => [:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:WATERPULSE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 20,
	:Weight => 3000,
	:kind => "Heavyweight",
	:dexentry => "It blasts internally stored sand from ports on its body to create a towering twister for attack.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
},

:SKORUPI => {
	:name => "Skorupi",
	:dexnum => 451,
	:Type1 => :POISON,
	:Type2 => :BUG,
	:BaseStats => [40, 50, 90, 65, 30, 55],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:BATTLEARMOR,:SNIPER],
	:HiddenAbilities => :KEENEYE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:CONFUSERAY,:FEINTATTACK,:IRONTAIL,:NIGHTSLASH,:POISONTAIL,:PURSUIT,:SANDATTACK,:SCREECH,:SLASH,:TWINEEDLE,:WHIRLWIND],
	:Moveset => [
		[1,:BITE],
		[1,:POISONSTING],
		[1,:LEER],
		[5,:KNOCKOFF],
		[9,:PINMISSILE],
		[13,:ACUPRESSURE],
		[16,:PURSUIT],
		[20,:BUGBITE],
		[23,:POISONFANG],
		[27,:VENOSHOCK],
		[30,:HONECLAWS],
		[34,:TOXICSPIKES],
		[38,:NIGHTSLASH],
		[41,:SCARYFACE],
		[45,:CRUNCH],
		[47,:FELLSTINGER],
		[49,:CROSSPOISON]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:DARKPULSE,:PAYBACK,:THIEF,:FLING,:TAUNT,:TORMENT,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:MUDSLAP,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:ROCKTOMB,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Purple",
	:EggGroups => [:Bug,:Water3],
	:Height => 8,
	:Weight => 120,
	:WildItemUncommon => :POISONBARB,
	:kind => "Scorpion",
	:dexentry => "It grips prey with its tail claws and injects poison. It tenaciously hangs on until the poison takes.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DRAPION,:Level,40]
	]
},

:DRAPION => {
	:name => "Drapion",
	:dexnum => 452,
	:Type1 => :POISON,
	:Type2 => :DARK,
	:BaseStats => [70, 90, 110, 95, 60, 75],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:BATTLEARMOR,:SNIPER],
	:HiddenAbilities => :KEENEYE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 175,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:THUNDERFANG],
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:BITE],
		[1,:POISONSTING],
		[1,:LEER],
		[1,:KNOCKOFF],
		[5,:KNOCKOFF],
		[9,:PINMISSILE],
		[13,:ACUPRESSURE],
		[16,:PURSUIT],
		[20,:BUGBITE],
		[23,:POISONFANG],
		[27,:VENOSHOCK],
		[30,:HONECLAWS],
		[34,:TOXICSPIKES],
		[38,:NIGHTSLASH],
		[43,:SCARYFACE],
		[49,:CRUNCH],
		[53,:FELLSTINGER],
		[57,:CROSSPOISON]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:INFESTATION,:BRUTALSWING,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Purple",
	:EggGroups => [:Bug,:Water3],
	:Height => 13,
	:Weight => 615,
	:WildItemUncommon => :POISONBARB,
	:kind => "Ogre Scorp",
	:dexentry => "It has the power in its clawed arms to make scrap of a car. The tips of its claws release poison.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:CROAGUNK => {
	:name => "Croagunk",
	:dexnum => 453,
	:Type1 => :POISON,
	:Type2 => :FIGHTING,
	:BaseStats => [48, 61, 40, 50, 61, 40],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:ANTICIPATION,:DRYSKIN],
	:HiddenAbilities => :POISONTOUCH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 60,
	:CatchRate => 140,
	:Happiness => 100,
	:EggSteps => 2805,
	:EggMoves => [:ACUPRESSURE,:BULLETPUNCH,:COUNTER,:CROSSCHOP,:DRAINPUNCH,:DYNAMICPUNCH,:FAKEOUT,:FEINT,:HEADBUTT,:MEFIRST,:MEDITATE,:QUICKGUARD,:SMELLINGSALTS,:VACUUMWAVE,:WAKEUPSLAP],
	:Moveset => [
		[1,:ASTONISH],
		[3,:MUDSLAP],
		[8,:POISONSTING],
		[10,:TAUNT],
		[15,:PURSUIT],
		[17,:FEINTATTACK],
		[22,:REVENGE],
		[24,:SWAGGER],
		[29,:MUDBOMB],
		[31,:SUCKERPUNCH],
		[36,:VENOSHOCK],
		[38,:NASTYPLOT],
		[43,:POISONJAB],
		[45,:SLUDGEBOMB],
		[47,:BELCH],
		[50,:FLATTER]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SPITE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ICYWIND,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Blue",
	:EggGroups => [:HumanLike],
	:Height => 7,
	:Weight => 230,
	:WildItemUncommon => :BLACKSLUDGE,
	:kind => "Toxic Mouth",
	:dexentry => "Its cheeks hold poison sacs. It tries to catch foes off guard to jab them with toxic fingers.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:TOXICROAK,:Level,37]
	]
},

:TOXICROAK => {
	:name => "Toxicroak",
	:dexnum => 454,
	:Type1 => :POISON,
	:Type2 => :FIGHTING,
	:BaseStats => [83, 106, 65, 85, 86, 65],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:ANTICIPATION,:DRYSKIN],
	:HiddenAbilities => :POISONTOUCH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 172,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ASTONISH],
		[1,:MUDSLAP],
		[1,:POISONSTING],
		[3,:MUDSLAP],
		[8,:POISONSTING],
		[10,:TAUNT],
		[15,:PURSUIT],
		[17,:FEINTATTACK],
		[22,:REVENGE],
		[24,:SWAGGER],
		[29,:MUDBOMB],
		[31,:SUCKERPUNCH],
		[36,:VENOSHOCK],
		[41,:NASTYPLOT],
		[49,:POISONJAB],
		[54,:SLUDGEBOMB],
		[58,:BELCH],
		[62,:FLATTER]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SPITE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:MAGICCOAT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:THROATCHOP,],
	:Color => "Blue",
	:EggGroups => [:HumanLike],
	:Height => 13,
	:Weight => 444,
	:WildItemUncommon => :BLACKSLUDGE,
	:kind => "Toxic Mouth",
	:dexentry => "Its knuckle claws secrete a toxin so vile that even a scratch could prove fatal.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 0,
},

:CARNIVINE => {
	:name => "Carnivine",
	:dexnum => 455,
	:Type1 => :GRASS,
	:BaseStats => [74, 100, 72, 46, 90, 72],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 159,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:ACIDSPRAY,:GIGADRAIN,:GRASSWHISTLE,:LEECHSEED,:MAGICALLEAF,:RAGEPOWDER,:RAZORLEAF,:SLAM,:SLEEPPOWDER,:STUNSPORE,:SYNTHESIS,:WORRYSEED],
	:Moveset => [
		[1,:BIND],
		[1,:GROWTH],
		[7,:BITE],
		[11,:VINEWHIP],
		[17,:SWEETSCENT],
		[21,:INGRAIN],
		[27,:FEINTATTACK],
		[31,:LEAFTORNADO],
		[37,:STOCKPILE],
		[37,:SPITUP],
		[37,:SWALLOW],
		[41,:CRUNCH],
		[47,:WRINGOUT],
		[50,:POWERWHIP]],
	:tmlist => [:BUGBITE,:FURYCUTTER,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:SUNNYDAY,:DEFOG,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:GASTROACID,:TOXIC,:REST,:CONFIDE,:INFESTATION,:THROATCHOP,],
	:Color => "Green",
	:EggGroups => [:Grass],
	:Height => 14,
	:Weight => 270,
	:kind => "Bug Catcher",
	:dexentry => "It attracts prey with its sweet-smelling saliva, then chomps down. It takes a whole day to eat prey.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 10,
},

:FINNEON => {
	:name => "Finneon",
	:dexnum => 456,
	:Type1 => :WATER,
	:BaseStats => [49, 49, 56, 66, 49, 61],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SWIFTSWIM,:STORMDRAIN],
	:HiddenAbilities => :WATERVEIL,
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AGILITY,:AQUATAIL,:AURORABEAM,:BRINE,:CHARM,:CONFUSERAY,:FLAIL,:PSYBEAM,:SIGNALBEAM,:SPLASH,:SWEETKISS,:TICKLE],
	:Moveset => [
		[1,:POUND],
		[6,:WATERGUN],
		[10,:ATTRACT],
		[13,:RAINDANCE],
		[17,:GUST],
		[22,:WATERPULSE],
		[26,:CAPTIVATE],
		[29,:SAFEGUARD],
		[33,:AQUARING],
		[38,:WHIRLPOOL],
		[42,:UTURN],
		[45,:BOUNCE],
		[49,:SILVERWIND],
		[54,:SOAK]],
	:tmlist => [:SIGNALBEAM,:UTURN,:PAYBACK,:TWISTER,:BOUNCE,:AIRCUTTER,:DEFOG,:TAILWIND,:OMINOUSWIND,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,],
	:Color => "Blue",
	:EggGroups => [:Water2],
	:Height => 4,
	:Weight => 70,
	:kind => "Wing Fish",
	:dexentry => "After long exposure to sunlight, the patterns on its tail fins shine vividly when darkness arrives.",
	:BattlerPlayerY => 35,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 18,
	:evolutions => [
		[:LUMINEON,:Level,31]
	]
},

:LUMINEON => {
	:name => "Lumineon",
	:dexnum => 457,
	:Type1 => :WATER,
	:BaseStats => [69, 69, 76, 91, 69, 86],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:SWIFTSWIM,:STORMDRAIN],
	:HiddenAbilities => :WATERVEIL,
	:GrowthRate => "Erratic",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:SOAK],
		[1,:GUST],
		[1,:POUND],
		[1,:WATERGUN],
		[1,:ATTRACT],
		[6,:WATERGUN],
		[10,:ATTRACT],
		[13,:RAINDANCE],
		[17,:GUST],
		[22,:WATERPULSE],
		[26,:CAPTIVATE],
		[29,:SAFEGUARD],
		[35,:AQUARING],
		[42,:WHIRLPOOL],
		[48,:UTURN],
		[53,:BOUNCE],
		[59,:SILVERWIND],
		[66,:SOAK]],
	:tmlist => [:SIGNALBEAM,:UTURN,:PAYBACK,:TWISTER,:BOUNCE,:AIRCUTTER,:DEFOG,:TAILWIND,:OMINOUSWIND,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,],
	:Color => "Blue",
	:EggGroups => [:Water2],
	:Height => 12,
	:Weight => 240,
	:kind => "Neon",
	:dexentry => "It lives on the deep-sea floor. It attracts prey by flashing the patterns on its four tail fins.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 12,
},

:MANTYKE => {
	:name => "Mantyke",
	:dexnum => 458,
	:Type1 => :WATER,
	:Type2 => :FLYING,
	:BaseStats => [45, 20, 50, 50, 60, 120],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:SWIFTSWIM,:WATERABSORB],
	:HiddenAbilities => :WATERVEIL,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 69,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 6630,
	:EggMoves => [:AMNESIA,:HAZE,:HYDROPUMP,:MIRRORCOAT,:MUDSPORT,:SIGNALBEAM,:SLAM,:SPLASH,:TAILWIND,:TWISTER,:WATERSPORT,:WIDEGUARD],
	:Moveset => [
		[1,:TACKLE],
		[1,:BUBBLE],
		[3,:SUPERSONIC],
		[7,:BUBBLEBEAM],
		[11,:CONFUSERAY],
		[14,:WINGATTACK],
		[16,:HEADBUTT],
		[19,:WATERPULSE],
		[23,:WIDEGUARD],
		[27,:TAKEDOWN],
		[32,:AGILITY],
		[36,:AIRSLASH],
		[39,:AQUARING],
		[46,:BOUNCE],
		[49,:HYDROPUMP]],
	:tmlist => [:SIGNALBEAM,:BOUNCE,:AERIALACE,:ACROBATICS,:AIRCUTTER,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKSLIDE,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:EggGroups => [:Undiscovered],
	:Height => 10,
	:Weight => 650,
	:kind => "Kite",
	:dexentry => "A friendly Pokémon that captures the subtle flows of seawater using its two antennae.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 18,
	:evolutions => [
		[:MANTINE,:HasInParty,223]
	]
},

:SNOVER => {
	:name => "Snover",
	:dexnum => 459,
	:Type1 => :GRASS,
	:Type2 => :ICE,
	:BaseStats => [60, 62, 50, 40, 62, 60],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SNOWWARNING,:SOUNDPROOF],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 67,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5355,
	:EggMoves => [:AVALANCHE,:BULLETSEED,:DOUBLEEDGE,:GROWTH,:LEECHSEED,:MAGICALLEAF,:MIST,:NATURALGIFT,:SEEDBOMB,:SKULLBASH,:STOMP],
	:Moveset => [
		[1,:POWDERSNOW],
		[1,:LEER],
		[5,:RAZORLEAF],
		[9,:ICYWIND],
		[13,:GRASSWHISTLE],
		[17,:SWAGGER],
		[21,:MIST],
		[26,:ICESHARD],
		[31,:INGRAIN],
		[36,:WOODHAMMER],
		[41,:BLIZZARD],
		[46,:SHEERCOLD]],
	:tmlist => [:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:LIGHTSCREEN,:MAGICCOAT,:REST,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Monster,:Grass],
	:Height => 10,
	:Weight => 505,
	:WildItemUncommon => :NEVERMELTICE,
	:kind => "Frost Tree",
	:dexentry => "It lives on snowy mountains. Having had little contact with humans, it is boldly inquisitive.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ABOMASNOW,:Level,40]
	]
},

:ABOMASNOW => {
	:name => "Abomasnow",
	:dexnum => 460,
	:Type1 => :GRASS,
	:Type2 => :ICE,
	:BaseStats => [90, 92, 75, 60, 92, 85],
	:EVs => [0, 1, 0, 0, 1, 0],
	:Abilities => [:SNOWWARNING,:SOUNDPROOF],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 173,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:ICEPUNCH],
		[1,:POWDERSNOW],
		[1,:LEER],
		[1,:RAZORLEAF],
		[1,:ICYWIND],
		[5,:RAZORLEAF],
		[9,:ICYWIND],
		[13,:GRASSWHISTLE],
		[17,:SWAGGER],
		[21,:MIST],
		[26,:ICESHARD],
		[31,:INGRAIN],
		[36,:WOODHAMMER],
		[47,:BLIZZARD],
		[58,:SHEERCOLD]],
	:tmlist => [:FLING,:OUTRAGE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:LIGHTSCREEN,:MAGICCOAT,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "White",
	:EggGroups => [:Monster,:Grass],
	:Height => 22,
	:Weight => 1355,
	:WildItemUncommon => :NEVERMELTICE,
	:kind => "Frost Tree",
	:dexentry => "It whips up blizzards in mountains that are always buried in snow. It is the abominable snowman.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
},

:WEAVILE => {
	:name => "Weavile",
	:dexnum => 461,
	:Type1 => :DARK,
	:Type2 => :ICE,
	:BaseStats => [70, 120, 65, 125, 45, 85],
	:EVs => [0, 1, 0, 1, 0, 0],
	:Abilities => [:PRESSURE,:PICKPOCKET],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 179,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 5355,
	:Moveset => [
		[1,:EMBARGO],
		[1,:REVENGE],
		[1,:ASSURANCE],
		[1,:SCRATCH],
		[1,:LEER],
		[1,:TAUNT],
		[1,:QUICKATTACK],
		[8,:QUICKATTACK],
		[10,:FEINTATTACK],
		[14,:ICYWIND],
		[16,:FURYSWIPES],
		[20,:NASTYPLOT],
		[22,:METALCLAW],
		[25,:HONECLAWS],
		[28,:FLING],
		[32,:SCREECH],
		[35,:NIGHTSLASH],
		[40,:SNATCH],
		[44,:PUNISHMENT],
		[47,:DARKPULSE]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:DREAMEATER,:CALMMIND,:REFLECT,:REST,:IRONTAIL,:SURF,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:THROATCHOP,],
	:Color => "Black",
	:EggGroups => [:Field],
	:Height => 11,
	:Weight => 340,
	:WildItemUncommon => :QUICKCLAW,
	:kind => "Sharp Claw",
	:dexentry => "They live in cold regions, forming groups of four or five that hunt prey with impressive coordination.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:MAGNEZONE => {
	:name => "Magnezone",
	:dexnum => 462,
	:Type1 => :ELECTRIC,
	:Type2 => :STEEL,
	:BaseStats => [70, 70, 115, 60, 130, 90],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:MAGNETPULL,:STURDY],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 241,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TRIATTACK],
		[1,:ZAPCANNON],
		[1,:MAGNETICFLUX],
		[1,:MIRRORCOAT],
		[1,:BARRIER],
		[1,:ELECTRICTERRAIN],
		[1,:TACKLE],
		[1,:SUPERSONIC],
		[1,:THUNDERSHOCK],
		[1,:MAGNETBOMB],
		[5,:THUNDERSHOCK],
		[7,:MAGNETBOMB],
		[11,:THUNDERWAVE],
		[13,:LIGHTSCREEN],
		[17,:SONICBOOM],
		[19,:SPARK],
		[23,:MIRRORSHOT],
		[25,:METALSOUND],
		[29,:ELECTROBALL],
		[33,:FLASHCANNON],
		[39,:SCREECH],
		[43,:DISCHARGE],
		[49,:LOCKON],
		[53,:MAGNETRISE],
		[59,:GYROBALL],
		[63,:ZAPCANNON]],
	:tmlist => [:SIGNALBEAM,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:SUNNYDAY,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:ROLLOUT,:FLASHCANNON,:IRONHEAD,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Mineral],
	:Height => 12,
	:Weight => 1800,
	:WildItemUncommon => :METALCOAT,
	:kind => "Magnet Area",
	:dexentry => "It evolved from exposure to a special magnetic field. Three units generate magnetism.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 11,
},

:LICKILICKY => {
	:name => "Lickilicky",
	:dexnum => 463,
	:Type1 => :NORMAL,
	:BaseStats => [110, 85, 95, 50, 80, 95],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:OWNTEMPO,:OBLIVIOUS],
	:HiddenAbilities => :CLOUDNINE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 180,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:WRINGOUT],
		[1,:POWERWHIP],
		[1,:LICK],
		[5,:SUPERSONIC],
		[9,:DEFENSECURL],
		[13,:KNOCKOFF],
		[17,:WRAP],
		[21,:STOMP],
		[25,:DISABLE],
		[29,:SLAM],
		[33,:ROLLOUT],
		[37,:CHIPAWAY],
		[41,:MEFIRST],
		[45,:REFRESH],
		[49,:SCREECH],
		[53,:POWERWHIP],
		[57,:WRINGOUT],
		[61,:GYROBALL]],
	:tmlist => [:THIEF,:KNOCKOFF,:FLING,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:DREAMEATER,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:ROLLOUT,:SANDSTORM,:IRONTAIL,:GYROBALL,:SURF,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Pink",
	:EggGroups => [:Monster],
	:Height => 17,
	:Weight => 1400,
	:WildItemUncommon => :LAGGINGTAIL,
	:kind => "Licking",
	:dexentry => "It wraps things with its extensible tongue. Getting too close to it will leave you soaked with drool.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 0,
},

:RHYPERIOR => {
	:name => "Rhyperior",
	:dexnum => 464,
	:Type1 => :GROUND,
	:Type2 => :ROCK,
	:BaseStats => [115, 140, 130, 40, 55, 55],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:LIGHTNINGROD,:SOLIDROCK],
	:HiddenAbilities => :RECKLESS,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 241,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:HAMMERARM],
		[1,:ROCKWRECKER],
		[1,:HORNDRILL],
		[1,:POISONJAB],
		[1,:HORNATTACK],
		[1,:TAILWHIP],
		[1,:FURYATTACK],
		[1,:SCARYFACE],
		[5,:FURYATTACK],
		[9,:SCARYFACE],
		[13,:SMACKDOWN],
		[17,:STOMP],
		[21,:BULLDOZE],
		[25,:CHIPAWAY],
		[29,:ROCKBLAST],
		[33,:DRILLRUN],
		[37,:TAKEDOWN],
		[41,:STONEEDGE],
		[48,:EARTHQUAKE],
		[55,:MEGAHORN],
		[62,:HORNDRILL],
		[69,:ROCKWRECKER]],
	:tmlist => [:FURYCUTTER,:PAYBACK,:THIEF,:FLING,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWCLAW,:SPITE,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:SURF,:AQUATAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:SMARTSTRIKE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:EggGroups => [:Monster,:Field],
	:Height => 24,
	:Weight => 2828,
	:kind => "Drill",
	:dexentry => "It puts rocks in holes in its palms and uses its muscles to shoot them. Geodude are shot at rare times.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
},

:TANGROWTH => {
	:name => "Tangrowth",
	:dexnum => 465,
	:Type1 => :GRASS,
	:BaseStats => [100, 100, 125, 50, 110, 50],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:LEAFGUARD],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 187,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:BLOCK],
		[1,:INGRAIN],
		[1,:CONSTRICT],
		[4,:SLEEPPOWDER],
		[7,:VINEWHIP],
		[10,:ABSORB],
		[14,:POISONPOWDER],
		[17,:BIND],
		[20,:GROWTH],
		[23,:MEGADRAIN],
		[27,:KNOCKOFF],
		[30,:STUNSPORE],
		[33,:NATURALGIFT],
		[36,:GIGADRAIN],
		[40,:ANCIENTPOWER],
		[43,:SLAM],
		[46,:TICKLE],
		[49,:WRINGOUT],
		[50,:GRASSYTERRAIN],
		[53,:POWERWHIP],
		[56,:BLOCK]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:SHOCKWAVE,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:TOXIC,:REFLECT,:REST,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:CONFIDE,:INFESTATION,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:EggGroups => [:Grass],
	:Height => 20,
	:Weight => 1286,
	:kind => "Vine",
	:dexentry => "It ensnares prey by extending arms made of vines. Losing arms to predators does not trouble it.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
},

:ELECTIVIRE => {
	:name => "Electivire",
	:dexnum => 466,
	:Type1 => :ELECTRIC,
	:BaseStats => [75, 123, 67, 95, 95, 85],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:MOTORDRIVE,:VITALSPIRIT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 243,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:ELECTRICTERRAIN],
		[1,:IONDELUGE],
		[1,:FIREPUNCH],
		[1,:QUICKATTACK],
		[1,:LEER],
		[1,:THUNDERSHOCK],
		[1,:LOWKICK],
		[5,:THUNDERSHOCK],
		[8,:LOWKICK],
		[12,:SWIFT],
		[15,:SHOCKWAVE],
		[19,:THUNDERWAVE],
		[22,:ELECTROBALL],
		[26,:LIGHTSCREEN],
		[29,:THUNDERPUNCH],
		[36,:DISCHARGE],
		[42,:SCREECH],
		[49,:THUNDERBOLT],
		[55,:THUNDER],
		[62,:GIGAIMPACT],
		[65,:ELECTRICTERRAIN]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:TAUNT,:TORMENT,:DUALCHOP,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FLAMETHROWER,:FIREPUNCH,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:LIGHTSCREEN,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Yellow",
	:EggGroups => [:HumanLike],
	:Height => 18,
	:Weight => 1386,
	:WildItemUncommon => :ELECTIRIZER,
	:kind => "Thunderbolt",
	:dexentry => "It pushes the tips of its two tails against the foe, then lets loose with over 20,000 volts of power.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:MAGMORTAR => {
	:name => "Magmortar",
	:dexnum => 467,
	:Type1 => :FIRE,
	:BaseStats => [75, 95, 67, 83, 125, 95],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:FLAMEBODY,:VITALSPIRIT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 243,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 6630,
	:Moveset => [
		[1,:THUNDERPUNCH],
		[1,:SMOG],
		[1,:LEER],
		[1,:EMBER],
		[1,:SMOKESCREEN],
		[5,:EMBER],
		[8,:SMOKESCREEN],
		[12,:FEINTATTACK],
		[15,:FIRESPIN],
		[19,:CLEARSMOG],
		[22,:FLAMEBURST],
		[26,:CONFUSERAY],
		[29,:FIREPUNCH],
		[36,:LAVAPLUME],
		[42,:SUNNYDAY],
		[49,:FLAMETHROWER],
		[55,:FIREBLAST],
		[62,:HYPERBEAM]],
	:tmlist => [:THIEF,:FLING,:TAUNT,:TORMENT,:DUALCHOP,:THUNDERBOLT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Red",
	:EggGroups => [:HumanLike],
	:Height => 16,
	:Weight => 680,
	:WildItemUncommon => :MAGMARIZER,
	:kind => "Blast",
	:dexentry => "It blasts fireballs of over 3,600 degrees F from the ends of its arms. It lives in volcanic craters.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
},

:TOGEKISS => {
	:name => "Togekiss",
	:dexnum => 468,
	:Type1 => :FAIRY,
	:Type2 => :FLYING,
	:BaseStats => [85, 50, 95, 80, 120, 115],
	:EVs => [0, 0, 0, 0, 2, 1],
	:Abilities => [:HUSTLE,:SERENEGRACE],
	:HiddenAbilities => :SUPERLUCK,
	:GrowthRate => "Fast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 245,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 2805,
	:Moveset => [
		[1,:AFTERYOU],
		[1,:SKYATTACK],
		[1,:EXTREMESPEED],
		[1,:AURASPHERE],
		[1,:AIRSLASH]],
	:tmlist => [:SIGNALBEAM,:FLING,:TWISTER,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GRASSKNOT,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:LIGHTSCREEN,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:ANCIENTPOWER,:ROLLOUT,:STEELWING,:WATERPULSE,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,],
	:Color => "White",
	:EggGroups => [:Flying,:Fairy],
	:Height => 15,
	:Weight => 380,
	:kind => "Jubilee",
	:dexentry => "It will never appear where there is strife. Its sightings have become rare recently.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 18,
},

:YANMEGA => {
	:name => "Yanmega",
	:dexnum => 469,
	:Type1 => :BUG,
	:Type2 => :FLYING,
	:BaseStats => [86, 76, 86, 95, 116, 56],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SPEEDBOOST,:TINTEDLENS],
	:HiddenAbilities => :FRISK,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 180,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:BUGBUZZ],
		[1,:AIRSLASH],
		[1,:NIGHTSLASH],
		[1,:BUGBITE],
		[1,:TACKLE],
		[1,:FORESIGHT],
		[1,:QUICKATTACK],
		[1,:DOUBLETEAM],
		[6,:QUICKATTACK],
		[11,:DOUBLETEAM],
		[14,:SONICBOOM],
		[17,:DETECT],
		[22,:SUPERSONIC],
		[27,:UPROAR],
		[30,:PURSUIT],
		[33,:ANCIENTPOWER],
		[38,:FEINT],
		[43,:SLASH],
		[46,:SCREECH],
		[49,:UTURN],
		[54,:AIRSLASH],
		[57,:BUGBUZZ]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:STRINGSHOT,:THIEF,:SUNNYDAY,:AERIALACE,:AIRCUTTER,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:OMINOUSWIND,:SOLARBEAM,:GIGADRAIN,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:REST,:ANCIENTPOWER,:STEELWING,:CONFIDE,:LASERFOCUS,],
	:Color => "Green",
	:EggGroups => [:Bug],
	:Height => 19,
	:Weight => 515,
	:WildItemUncommon => :WIDELENS,
	:kind => "Ogre Darner",
	:dexentry => "By churning its wings, it creates shock waves that inflict critical internal injuries to foes.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 11,
},

:LEAFEON => {
	:name => "Leafeon",
	:dexnum => 470,
	:Type1 => :GRASS,
	:BaseStats => [65, 110, 130, 95, 60, 65],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:LEAFGUARD,:LEAFGUARD],
	:HiddenAbilities => :CHLOROPHYLL,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 184,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 9180,
	:Moveset => [
		[0,:RAZORLEAF],
		[1,:HELPINGHAND],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[5,:SANDATTACK],
		[9,:BABYDOLLEYES],
		[13,:QUICKATTACK],
		[17,:GRASSWHISTLE],
		[20,:MAGICALLEAF],
		[25,:GIGADRAIN],
		[29,:SWORDSDANCE],
		[33,:SYNTHESIS],
		[37,:SUNNYDAY],
		[41,:LASTRESORT],
		[45,:LEAFBLADE]],
	:tmlist => [:XSCISSOR,:FURYCUTTER,:KNOCKOFF,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:NATUREPOWER,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:CELEBRATE,],
	:Color => "Green",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 255,
	:kind => "Verdant",
	:dexentry => "Just like a plant, it uses photosynthesis. As a result, it is always enveloped in clear air.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:GLACEON => {
	:name => "Glaceon",
	:dexnum => 471,
	:Type1 => :ICE,
	:BaseStats => [65, 60, 110, 65, 130, 95],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:SNOWCLOAK,:SNOWCLOAK],
	:HiddenAbilities => :ICEBODY,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 184,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 9180,
	:Moveset => [
		[0,:ICYWIND],
		[1,:HELPINGHAND],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[5,:SANDATTACK],
		[9,:BABYDOLLEYES],
		[13,:QUICKATTACK],
		[17,:BITE],
		[20,:ICEFANG],
		[25,:ICESHARD],
		[29,:BARRIER],
		[33,:MIRRORCOAT],
		[37,:HAIL],
		[41,:LASTRESORT],
		[45,:BLIZZARD]],
	:tmlist => [:SIGNALBEAM,:ROCKSMASH,:SUNNYDAY,:SHADOWBALL,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HEALBELL,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:IRONTAIL,:AQUATAIL,:WATERPULSE,:RAINDANCE,:CONFIDE,:AURORAVEIL,:LASERFOCUS,:CELEBRATE,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 8,
	:Weight => 259,
	:kind => "Fresh Snow",
	:dexentry => "As a protective technique, it can completely freeze its fur to make its hairs stand like needles.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:GLISCOR => {
	:name => "Gliscor",
	:dexnum => 472,
	:Type1 => :GROUND,
	:Type2 => :FLYING,
	:BaseStats => [75, 95, 125, 95, 45, 75],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:HYPERCUTTER,:SANDVEIL],
	:HiddenAbilities => :POISONHEAL,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 179,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:GUILLOTINE],
		[1,:THUNDERFANG],
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:POISONJAB],
		[1,:SANDATTACK],
		[1,:HARDEN],
		[1,:KNOCKOFF],
		[4,:SANDATTACK],
		[7,:HARDEN],
		[10,:KNOCKOFF],
		[13,:QUICKATTACK],
		[16,:FURYCUTTER],
		[19,:FEINTATTACK],
		[22,:ACROBATICS],
		[27,:NIGHTSLASH],
		[30,:UTURN],
		[35,:SCREECH],
		[40,:XSCISSOR],
		[45,:SKYUPPERCUT],
		[50,:SWORDSDANCE],
		[55,:GUILLOTINE]],
	:tmlist => [:XSCISSOR,:UTURN,:BUGBITE,:STRUGGLEBUG,:FURYCUTTER,:DARKPULSE,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:BRICKBREAK,:ROCKSMASH,:SUNNYDAY,:SKYATTACK,:AERIALACE,:ACROBATICS,:DEFOG,:ROOST,:TAILWIND,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:STEELWING,:AQUATAIL,:RAINDANCE,:CONFIDE,:BRUTALSWING,:THROATCHOP,],
	:Color => "Purple",
	:EggGroups => [:Bug],
	:Height => 20,
	:Weight => 425,
	:kind => "Fang Scorp",
	:dexentry => "It observes prey while hanging inverted from branches. When the chance presents itself, it swoops.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 10,
},

:MAMOSWINE => {
	:name => "Mamoswine",
	:dexnum => 473,
	:Type1 => :ICE,
	:Type2 => :GROUND,
	:BaseStats => [110, 130, 80, 80, 70, 60],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:OBLIVIOUS,:SNOWCLOAK],
	:HiddenAbilities => :THICKFAT,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 239,
	:CatchRate => 50,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:FURYATTACK],
		[1,:SCARYFACE],
		[1,:ANCIENTPOWER],
		[1,:PECK],
		[1,:ODORSLEUTH],
		[1,:MUDSPORT],
		[1,:POWDERSNOW],
		[5,:MUDSPORT],
		[8,:POWDERSNOW],
		[11,:MUDSLAP],
		[14,:ENDURE],
		[18,:MUDBOMB],
		[21,:HAIL],
		[24,:ICEFANG],
		[28,:TAKEDOWN],
		[33,:DOUBLEHIT],
		[37,:MIST],
		[41,:THRASH],
		[46,:EARTHQUAKE],
		[52,:BLIZZARD],
		[58,:SCARYFACE]],
	:tmlist => [:KNOCKOFF,:SUPERPOWER,:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REFLECT,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 25,
	:Weight => 2910,
	:kind => "Twin Tusk",
	:dexentry => "A frozen Mamoswine was dug from ice dating back 10,000 years. This Pokémon has been around for a long, long time.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:PORYGONZ => {
	:name => "Porygon-Z",
	:dexnum => 474,
	:Type1 => :NORMAL,
	:BaseStats => [85, 80, 70, 90, 135, 75],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:ADAPTABILITY,:DOWNLOAD],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 241,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:TRICKROOM],
		[1,:ZAPCANNON],
		[1,:MAGICCOAT],
		[1,:CONVERSION2],
		[1,:TACKLE],
		[1,:CONVERSION],
		[1,:NASTYPLOT],
		[7,:PSYBEAM],
		[12,:AGILITY],
		[18,:RECOVER],
		[23,:MAGNETRISE],
		[29,:SIGNALBEAM],
		[34,:EMBARGO],
		[40,:DISCHARGE],
		[45,:LOCKON],
		[50,:TRIATTACK],
		[56,:MAGICCOAT],
		[62,:ZAPCANNON],
		[67,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:DARKPULSE,:THIEF,:EMBARGO,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SOLARBEAM,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:GRAVITY,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONTAIL,:RAINDANCE,],
	:Color => "Red",
	:EggGroups => [:Mineral],
	:Height => 9,
	:Weight => 340,
	:kind => "Virtual",
	:dexentry => "Additional software was installed to make it a better Pokémon. It began acting oddly, however.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 8,
},

:GALLADE => {
	:name => "Gallade",
	:dexnum => 475,
	:Type1 => :PSYCHIC,
	:Type2 => :FIGHTING,
	:BaseStats => [68, 125, 65, 80, 65, 115],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:STEADFAST,:JUSTIFIED],
	:GrowthRate => "Slow",
	:GenderRatio => "FemZero",
	:BaseEXP => 233,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 5355,
	:Moveset => [
		[0,:SLASH],
		[1,:STOREDPOWER],
		[1,:CLOSECOMBAT],
		[1,:LEAFBLADE],
		[1,:NIGHTSLASH],
		[1,:LEER],
		[1,:CONFUSION],
		[1,:DOUBLETEAM],
		[1,:TELEPORT],
		[4,:CONFUSION],
		[6,:DOUBLETEAM],
		[9,:TELEPORT],
		[11,:QUICKGUARD],
		[14,:FURYCUTTER],
		[17,:AERIALACE],
		[19,:HEALPULSE],
		[23,:WIDEGUARD],
		[26,:SWORDSDANCE],
		[31,:PSYCHOCUT],
		[35,:HELPINGHAND],
		[40,:FEINT],
		[44,:FALSESWIPE],
		[49,:PROTECT],
		[53,:CLOSECOMBAT],
		[58,:STOREDPOWER]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:FURYCUTTER,:THIEF,:KNOCKOFF,:FLING,:SNATCH,:TAUNT,:TORMENT,:DUALCHOP,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:VACUUMWAVE,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWBALL,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,:LASERFOCUS,:THROATCHOP,],
	:Color => "White",
	:EggGroups => [:Amorphous],
	:Height => 16,
	:Weight => 520,
	:kind => "Blade",
	:dexentry => "A master of courtesy and swordsmanship, it fights using extending swords on its elbows.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 8,
	:BattlerAltitude => 0,
},

:PROBOPASS => {
	:name => "Probopass",
	:dexnum => 476,
	:Type1 => :ROCK,
	:Type2 => :STEEL,
	:BaseStats => [60, 55, 145, 40, 75, 150],
	:EVs => [0, 0, 1, 0, 0, 2],
	:Abilities => [:STURDY,:MAGNETPULL],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 184,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:TRIATTACK],
		[1,:MAGNETICFLUX],
		[1,:MAGNETRISE],
		[1,:GRAVITY],
		[1,:WIDEGUARD],
		[1,:TACKLE],
		[1,:IRONDEFENSE],
		[1,:BLOCK],
		[1,:MAGNETBOMB],
		[4,:IRONDEFENSE],
		[7,:BLOCK],
		[10,:MAGNETBOMB],
		[13,:THUNDERWAVE],
		[16,:REST],
		[19,:SPARK],
		[22,:ROCKSLIDE],
		[25,:POWERGEM],
		[28,:ROCKBLAST],
		[31,:DISCHARGE],
		[34,:SANDSTORM],
		[37,:EARTHPOWER],
		[40,:STONEEDGE],
		[43,:LOCKON],
		[43,:ZAPCANNON]],
	:tmlist => [:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:GRAVITY,:REST,:ROLEPLAY,:TELEKINESIS,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROLLOUT,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:CONFIDE,:DAZZLINGGLEAM,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:EggGroups => [:Mineral],
	:Height => 14,
	:Weight => 3400,
	:WildItemUncommon => :MAGNET,
	:kind => "Compass",
	:dexentry => "It exudes strong magnetism from all over. It controls three small units called Mini-Noses.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:DUSKNOIR => {
	:name => "Dusknoir",
	:dexnum => 477,
	:Type1 => :GHOST,
	:BaseStats => [45, 100, 135, 45, 65, 135],
	:EVs => [0, 0, 1, 0, 0, 2],
	:Abilities => [:PRESSURE,:FRISK],
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 236,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 6630,
	:Moveset => [
		[1,:SHADOWPUNCH],
		[1,:FUTURESIGHT],
		[1,:FIREPUNCH],
		[1,:ICEPUNCH],
		[1,:THUNDERPUNCH],
		[1,:GRAVITY],
		[1,:BIND],
		[1,:LEER],
		[1,:NIGHTSHADE],
		[1,:DISABLE],
		[1,:ASTONISH],
		[6,:DISABLE],
		[9,:ASTONISH],
		[14,:FORESIGHT],
		[17,:SHADOWSNEAK],
		[22,:PURSUIT],
		[25,:WILLOWISP],
		[30,:CONFUSERAY],
		[33,:CURSE],
		[40,:HEX],
		[45,:SHADOWBALL],
		[52,:MEANLOOK],
		[57,:PAYBACK],
		[64,:FUTURESIGHT]],
	:tmlist => [:DARKPULSE,:SUCKERPUNCH,:PAYBACK,:THIEF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERPUNCH,:CHARGEBEAM,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:OMINOUSWIND,:SPITE,:EARTHQUAKE,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:GRAVITY,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Black",
	:EggGroups => [:Amorphous],
	:Height => 22,
	:Weight => 1066,
	:WildItemUncommon => :SPELLTAG,
	:kind => "Gripper",
	:dexentry => "The antenna on its head captures radio waves from the world of spirits that command it to take people there.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 7,
},

:FROSLASS => {
	:name => "Froslass",
	:dexnum => 478,
	:Type1 => :ICE,
	:Type2 => :GHOST,
	:BaseStats => [70, 80, 70, 110, 80, 70],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:SNOWCLOAK,:CURSEDBODY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 168,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[0,:OMINOUSWIND],
		[1,:DESTINYBOND],
		[1,:POWDERSNOW],
		[1,:LEER],
		[1,:DOUBLETEAM],
		[1,:ICESHARD],
		[5,:DOUBLETEAM],
		[10,:ICESHARD],
		[14,:ICYWIND],
		[19,:ASTONISH],
		[23,:DRAININGKISS],
		[28,:WILLOWISP],
		[32,:CONFUSERAY],
		[37,:WAKEUPSLAP],
		[41,:CAPTIVATE],
		[42,:SHADOWBALL],
		[48,:BLIZZARD],
		[54,:HAIL],
		[61,:DESTINYBOND]],
	:tmlist => [:SIGNALBEAM,:SUCKERPUNCH,:PAYBACK,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:SHADOWBALL,:OMINOUSWIND,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:LIGHTSCREEN,:REST,:TELEKINESIS,:TRICK,:ROLLOUT,:WATERPULSE,:RAINDANCE,:CONFIDE,:AURORAVEIL,:LASERFOCUS,],
	:Color => "White",
	:EggGroups => [:Fairy,:Mineral],
	:Height => 13,
	:Weight => 266,
	:kind => "Snow Land",
	:dexentry => "It freezes foes with an icy breath of nearly -60 degrees F. What seems to be its body is actually hollow.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 7,
},

:ROTOM => {
	:name => "Rotom",
	:dexnum => 479,
	:Type1 => :ELECTRIC,
	:Type2 => :GHOST,
	:BaseStats => [50, 50, 77, 91, 95, 77],
	:EVs => [0, 0, 0, 1, 1, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 154,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5355,
	:Moveset => [
		[1,:DISCHARGE],
		[1,:CHARGE],
		[1,:TRICK],
		[1,:ASTONISH],
		[1,:THUNDERWAVE],
		[1,:THUNDERSHOCK],
		[1,:CONFUSERAY],
		[8,:UPROAR],
		[15,:DOUBLETEAM],
		[22,:SHOCKWAVE],
		[29,:OMINOUSWIND],
		[36,:SUBSTITUTE],
		[43,:ELECTROBALL],
		[50,:HEX],
		[57,:CHARGE],
		[64,:DISCHARGE]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:THIEF,:SNATCH,:THUNDER,:THUNDERBOLT,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:WILLOWISP,:DEFOG,:SHADOWBALL,:OMINOUSWIND,:SPITE,:MUDSLAP,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:ALLYSWITCH,:LIGHTSCREEN,:REFLECT,:REST,:TELEKINESIS,:TRICK,:RAINDANCE,:CONFIDE,],
	:Color => "Red",
	:EggGroups => [:Amorphous],
	:Height => 3,
	:Weight => 3,
	:kind => "Plasma",
	:dexentry => "Its body is composed of plasma. It is known to infiltrate electronic devices and wreak havoc.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 13,
},

:UXIE => {
	:name => "Uxie",
	:dexnum => 480,
	:Type1 => :PSYCHIC,
	:BaseStats => [75, 75, 130, 95, 75, 130],
	:EVs => [0, 0, 2, 0, 0, 1],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 140,
	:EggSteps => 20655,
	:Moveset => [
		[1,:MEMENTO],
		[1,:NATURALGIFT],
		[1,:FLAIL],
		[1,:REST],
		[1,:CONFUSION],
		[6,:IMPRISON],
		[16,:ENDURE],
		[21,:SWIFT],
		[31,:YAWN],
		[36,:FUTURESIGHT],
		[46,:AMNESIA],
		[50,:EXTRASENSORY],
		[61,:FLAIL],
		[66,:NATURALGIFT],
		[76,:MEMENTO]],
	:tmlist => [:SIGNALBEAM,:UTURN,:FOULPLAY,:KNOCKOFF,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FIREPUNCH,:SUNNYDAY,:ACROBATICS,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:GIGADRAIN,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:WATERPULSE,:RAINDANCE,:LASERFOCUS,],
	:Color => "Yellow",
	:EggGroups => [:Undiscovered],
	:Height => 3,
	:Weight => 3,
	:kind => "Knowledge",
	:dexentry => "Known as “The Being of Knowledge.” It is said that it can wipe out the memory of those who see its eyes.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 18,
},

:MESPRIT => {
	:name => "Mesprit",
	:dexnum => 481,
	:Type1 => :PSYCHIC,
	:BaseStats => [80, 105, 105, 80, 105, 105],
	:EVs => [0, 1, 0, 0, 1, 1],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 140,
	:EggSteps => 20655,
	:Moveset => [
		[1,:HEALINGWISH],
		[1,:NATURALGIFT],
		[1,:COPYCAT],
		[1,:REST],
		[1,:CONFUSION],
		[6,:IMPRISON],
		[16,:PROTECT],
		[21,:SWIFT],
		[31,:LUCKYCHANT],
		[36,:FUTURESIGHT],
		[46,:CHARM],
		[50,:EXTRASENSORY],
		[61,:COPYCAT],
		[66,:NATURALGIFT],
		[76,:HEALINGWISH]],
	:tmlist => [:SIGNALBEAM,:UTURN,:KNOCKOFF,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FIREPUNCH,:SUNNYDAY,:ACROBATICS,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:WATERPULSE,:RAINDANCE,:LASERFOCUS,],
	:Color => "Pink",
	:EggGroups => [:Undiscovered],
	:Height => 3,
	:Weight => 3,
	:kind => "Emotion",
	:dexentry => "Known as “The Being of Emotion.” It taught humans the nobility of sorrow, pain, and joy.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 18,
},

:AZELF => {
	:name => "Azelf",
	:dexnum => 482,
	:Type1 => :PSYCHIC,
	:BaseStats => [75, 125, 70, 115, 125, 70],
	:EVs => [0, 2, 0, 0, 1, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 261,
	:CatchRate => 3,
	:Happiness => 140,
	:EggSteps => 20655,
	:Moveset => [
		[1,:NATURALGIFT],
		[1,:LASTRESORT],
		[1,:REST],
		[1,:CONFUSION],
		[6,:IMPRISON],
		[16,:DETECT],
		[21,:SWIFT],
		[31,:UPROAR],
		[36,:FUTURESIGHT],
		[46,:NASTYPLOT],
		[50,:EXTRASENSORY],
		[61,:LASTRESORT],
		[66,:NATURALGIFT],
		[76,:EXPLOSION]],
	:tmlist => [:SIGNALBEAM,:UTURN,:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:ACROBATICS,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:ICEPUNCH,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:WATERPULSE,:RAINDANCE,:LASERFOCUS,],
	:Color => "Blue",
	:EggGroups => [:Undiscovered],
	:Height => 3,
	:Weight => 3,
	:kind => "Willpower",
	:dexentry => "Known as “The Being of Willpower.” It sleeps at the bottom of a lake to keep the world in balance.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 20,
},

:DIALGA => {
	:name => "Dialga",
	:dexnum => 483,
	:Type1 => :STEEL,
	:Type2 => :DRAGON,
	:BaseStats => [100, 120, 120, 90, 150, 100],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:PRESSURE,:TELEPATHY],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 306,
	:CatchRate => 30,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:DRAGONBREATH],
		[1,:SCARYFACE],
		[6,:METALCLAW],
		[10,:ANCIENTPOWER],
		[15,:SLASH],
		[19,:POWERGEM],
		[24,:METALBURST],
		[28,:DRAGONCLAW],
		[33,:EARTHPOWER],
		[37,:AURASPHERE],
		[42,:IRONTAIL],
		[46,:ROAROFTIME],
		[50,:FLASHCANNON]],
	:tmlist => [:FURYCUTTER,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:MAGNETRISE,:THUNDERWAVE,:BRICKBREAK,:ROCKSMASH,:BULKUP,:OVERHEAT,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:TRICKROOM,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:STOMPINGTANTRUM,],
	:Color => "White",
	:EggGroups => [:Undiscovered],
	:Height => 54,
	:Weight => 6830,
	:kind => "Temporal",
	:dexentry => "It has the power to control time. It appears as an ancient deity in myths of the Sinnoh Region.",
	:BattlerPlayerY => 5,
	:BattlerEnemyY => 2,
	:BattlerAltitude => 0,
},

:PALKIA => {
	:name => "Palkia",
	:dexnum => 484,
	:Type1 => :WATER,
	:Type2 => :DRAGON,
	:BaseStats => [90, 120, 100, 100, 150, 120],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:PRESSURE,:TELEPATHY],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 306,
	:CatchRate => 30,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:DRAGONBREATH],
		[1,:SCARYFACE],
		[6,:WATERPULSE],
		[10,:ANCIENTPOWER],
		[15,:SLASH],
		[19,:POWERGEM],
		[24,:AQUARING],
		[28,:DRAGONCLAW],
		[33,:EARTHPOWER],
		[37,:AURASPHERE],
		[42,:AQUATAIL],
		[46,:SPACIALREND],
		[50,:HYDROPUMP]],
	:tmlist => [:FURYCUTTER,:FLING,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:BULKUP,:FIREBLAST,:FLAMETHROWER,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:TRICKROOM,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:SURF,:AQUATAIL,:DIVE,:WATERPULSE,:RAINDANCE,:LIQUIDATION,:STOMPINGTANTRUM,],
	:Color => "Purple",
	:EggGroups => [:Undiscovered],
	:Height => 42,
	:Weight => 3360,
	:kind => "Spatial",
	:dexentry => "It has the ability to distort space. It is described as a deity in the Sinnoh Region's mythology.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 4,
	:BattlerAltitude => 0,
},

:HEATRAN => {
	:name => "Heatran",
	:dexnum => 485,
	:Type1 => :FIRE,
	:Type2 => :STEEL,
	:BaseStats => [91, 90, 106, 77, 130, 106],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:FLASHFIRE,:FLAMEBODY],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 100,
	:EggSteps => 2805,
	:Moveset => [
		[1,:MAGMASTORM],
		[1,:HEATWAVE],
		[1,:EARTHPOWER],
		[1,:IRONHEAD],
		[1,:FIRESPIN],
		[1,:ANCIENTPOWER],
		[9,:LEER],
		[17,:FIREFANG],
		[25,:METALSOUND],
		[33,:CRUNCH],
		[41,:SCARYFACE],
		[49,:LAVAPLUME],
		[57,:FIRESPIN],
		[65,:IRONHEAD],
		[73,:EARTHPOWER],
		[81,:HEATWAVE],
		[88,:STONEEDGE],
		[96,:MAGMASTORM]],
	:tmlist => [:BUGBITE,:DARKPULSE,:PAYBACK,:TAUNT,:TORMENT,:DRAGONPULSE,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Undiscovered],
	:Height => 17,
	:Weight => 4300,
	:kind => "Lava Dome",
	:dexentry => "It dwells in volcanic caves. It digs in with its cross-shaped feet to crawl on ceilings and walls.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
},

:REGIGIGAS => {
	:name => "Regigigas",
	:dexnum => 486,
	:Type1 => :NORMAL,
	:BaseStats => [110, 160, 110, 100, 80, 110],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:SLOWSTART],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 302,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:HEAVYSLAM],
		[1,:CRUSHGRIP],
		[1,:FIREPUNCH],
		[1,:ICEPUNCH],
		[1,:THUNDERPUNCH],
		[1,:DIZZYPUNCH],
		[1,:KNOCKOFF],
		[1,:CONFUSERAY],
		[1,:FORESIGHT],
		[25,:REVENGE],
		[40,:WIDEGUARD],
		[50,:ZENHEADBUTT],
		[65,:PAYBACK],
		[75,:CRUSHGRIP],
		[90,:HEAVYSLAM],
		[100,:GIGAIMPACT]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:GRAVITY,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:IRONHEAD,:RAINDANCE,:STOMPINGTANTRUM,],
	:Color => "White",
	:EggGroups => [:Undiscovered],
	:Height => 37,
	:Weight => 4200,
	:kind => "Colossal",
	:dexentry => "There is an enduring legend that states this Pokémon having towed continents with ropes.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 0,
},

:GIRATINA => {
	:name => "Giratina",
	:dexnum => 487,
	:Type1 => :GHOST,
	:Type2 => :DRAGON,
	:BaseStats => [150, 100, 120, 90, 100, 120],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:PRESSURE,:TELEPATHY],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 306,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:DRAGONBREATH],
		[1,:SCARYFACE],
		[6,:OMINOUSWIND],
		[10,:ANCIENTPOWER],
		[15,:SLASH],
		[19,:SHADOWSNEAK],
		[24,:DESTINYBOND],
		[28,:DRAGONCLAW],
		[33,:EARTHPOWER],
		[37,:AURASPHERE],
		[42,:SHADOWCLAW],
		[46,:SHADOWFORCE],
		[50,:HEX]],
	:tmlist => [:FURYCUTTER,:DARKPULSE,:PAYBACK,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:WILLOWISP,:FLY,:AERIALACE,:AIRCUTTER,:DEFOG,:TAILWIND,:SHADOWBALL,:SHADOWCLAW,:OMINOUSWIND,:SPITE,:ENERGYBALL,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:PSYCHUP,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:CALMMIND,:GRAVITY,:MAGICCOAT,:REST,:ROLEPLAY,:TELEKINESIS,:STONEEDGE,:ANCIENTPOWER,:IRONTAIL,:IRONHEAD,:STEELWING,:AQUATAIL,:RAINDANCE,:BRUTALSWING,],
	:Color => "Black",
	:EggGroups => [:Undiscovered],
	:Height => 45,
	:Weight => 7500,
	:kind => "Renegade",
	:dexentry => "A Pokémon that is said to live in a world on the reverse side of ours. It appears in an ancient cemetery.",
	:BattlerPlayerY => 8,
	:BattlerEnemyY => 3,
	:BattlerAltitude => 0,
},

:CRESSELIA => {
	:name => "Cresselia",
	:dexnum => 488,
	:Type1 => :PSYCHIC,
	:BaseStats => [120, 70, 120, 85, 75, 130],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 100,
	:EggSteps => 30855,
	:Moveset => [
		[1,:LUNARDANCE],
		[1,:PSYCHOSHIFT],
		[1,:MOONLIGHT],
		[1,:CONFUSION],
		[1,:DOUBLETEAM],
		[11,:SAFEGUARD],
		[20,:MIST],
		[29,:AURORABEAM],
		[38,:FUTURESIGHT],
		[47,:SLASH],
		[57,:MOONLIGHT],
		[66,:PSYCHOCUT],
		[75,:PSYCHOSHIFT],
		[84,:LUNARDANCE],
		[93,:PSYCHIC],
		[99,:MOONBLAST]],
	:tmlist => [:SIGNALBEAM,:FURYCUTTER,:CHARGEBEAM,:THUNDERWAVE,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:RAINDANCE,],
	:Color => "Yellow",
	:EggGroups => [:Undiscovered],
	:Height => 15,
	:Weight => 856,
	:kind => "Lunar",
	:dexentry => "Shiny particles are released from its wings like a veil. It is said to represent the crescent moon.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 11,
},

:PHIONE => {
	:name => "Phione",
	:dexnum => 489,
	:Type1 => :WATER,
	:BaseStats => [80, 80, 80, 80, 80, 80],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:HYDRATION],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 216,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 10455,
	:Moveset => [
		[1,:BUBBLE],
		[1,:WATERSPORT],
		[9,:CHARM],
		[16,:SUPERSONIC],
		[24,:BUBBLEBEAM],
		[31,:ACIDARMOR],
		[39,:WHIRLPOOL],
		[46,:WATERPULSE],
		[54,:AQUARING],
		[61,:DIVE],
		[69,:RAINDANCE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:KNOCKOFF,:FLING,:BOUNCE,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:LASTRESORT,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ANCIENTPOWER,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:DAZZLINGGLEAM,:LIQUIDATION,],
	:Color => "Blue",
	:EggGroups => [:Water1,:Fairy],
	:Height => 4,
	:Weight => 31,
	:kind => "Sea Drifter",
	:dexentry => "A Pokémon that lives in warm seas. It inflates the flotation sac on its head to drift and search for food.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 17,
},

:MANAPHY => {
	:name => "Manaphy",
	:dexnum => 490,
	:Type1 => :WATER,
	:BaseStats => [100, 100, 100, 100, 100, 100],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:HYDRATION],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 70,
	:EggSteps => 2805,
	:Moveset => [
		[1,:TAILGLOW],
		[1,:BUBBLE],
		[1,:WATERSPORT],
		[9,:CHARM],
		[16,:SUPERSONIC],
		[24,:BUBBLEBEAM],
		[31,:ACIDARMOR],
		[39,:WHIRLPOOL],
		[46,:WATERPULSE],
		[54,:AQUARING],
		[61,:DIVE],
		[69,:RAINDANCE],
		[76,:HEARTSWAP]],
	:tmlist => [:SIGNALBEAM,:UTURN,:KNOCKOFF,:FLING,:BOUNCE,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:SKILLSWAP,:ANCIENTPOWER,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:DAZZLINGGLEAM,:LIQUIDATION,],
	:Color => "Blue",
	:EggGroups => [:Water1,:Fairy],
	:Height => 3,
	:Weight => 14,
	:kind => "Seafaring",
	:dexentry => "Born on a cold seafloor, it will swim great distances to return to its birthplace.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 17,
},

:DARKRAI => {
	:name => "Darkrai",
	:dexnum => 491,
	:Type1 => :DARK,
	:BaseStats => [70, 90, 90, 125, 135, 90],
	:EVs => [0, 0, 0, 1, 2, 0],
	:Abilities => [:BADDREAMS],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 270,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:OMINOUSWIND],
		[1,:DISABLE],
		[11,:QUICKATTACK],
		[20,:HYPNOSIS],
		[29,:FEINTATTACK],
		[38,:NIGHTMARE],
		[47,:DOUBLETEAM],
		[57,:HAZE],
		[66,:DARKVOID],
		[75,:NASTYPLOT],
		[84,:DREAMEATER],
		[93,:DARKPULSE]],
	:tmlist => [:XSCISSOR,:FOULPLAY,:DARKPULSE,:SUCKERPUNCH,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:SUNNYDAY,:WILLOWISP,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:OMINOUSWIND,:SPITE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:TOXIC,:DREAMEATER,:PSYCHIC,:CALMMIND,:REST,:TRICK,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:THROATCHOP,],
	:Color => "Black",
	:EggGroups => [:Undiscovered],
	:Height => 15,
	:Weight => 505,
	:kind => "Pitch-Black",
	:dexentry => "It can lull people to sleep and make them dream. It is active during nights of the new moon.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 9,
},

:SHAYMIN => {
	:name => "Shaymin",
	:dexnum => 492,
	:Type1 => :GRASS,
	:BaseStats => [100, 100, 100, 100, 100, 100],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:NATURALCURE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "Genderless",
	:BaseEXP => 270,
	:CatchRate => 45,
	:Happiness => 100,
	:EggSteps => 30855,
	:Moveset => [
		[1,:GROWTH],
		[10,:MAGICALLEAF],
		[19,:LEECHSEED],
		[28,:SYNTHESIS],
		[37,:SWEETSCENT],
		[46,:NATURALGIFT],
		[55,:WORRYSEED],
		[64,:AROMATHERAPY],
		[73,:ENERGYBALL],
		[82,:SWEETKISS],
		[91,:HEALINGWISH],
		[100,:SEEDFLARE]],
	:tmlist => [:SUNNYDAY,:AIRCUTTER,:TAILWIND,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:EARTHPOWER,:MUDSLAP,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:FACADE,:HEADBUTT,:SECRETPOWER,:COVET,:ROUND,:SWIFT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:PSYCHIC,:ZENHEADBUTT,:REST,:LASERFOCUS,:CELEBRATE,],
	:Color => "Green",
	:EggGroups => [:Undiscovered],
	:Height => 2,
	:Weight => 21,
	:WildItemCommon => :LUMBERRY,
	:WildItemUncommon => :LUMBERRY,
	:WildItemRare => :LUMBERRY,
	:kind => "Gratitude",
	:dexentry => "It lives in flower patches and avoids detection by curling up to look like a flowering plant.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
},

:ARCEUS => {
	:name => "Arceus",
	:dexnum => 493,
	:Type1 => :NORMAL,
	:BaseStats => [120, 120, 120, 120, 120, 120],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:MULTITYPE],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 324,
	:CatchRate => 3,
	:Happiness => 0,
	:EggSteps => 30855,
	:Moveset => [
		[1,:SEISMICTOSS],
		[1,:COSMICPOWER],
		[1,:NATURALGIFT],
		[1,:PUNISHMENT],
		[10,:GRAVITY],
		[20,:EARTHPOWER],
		[30,:HYPERVOICE],
		[40,:EXTREMESPEED],
		[50,:REFRESH],
		[60,:FUTURESIGHT],
		[70,:RECOVER],
		[80,:HYPERBEAM],
		[90,:PERISHSONG],
		[100,:JUDGMENT]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:FURYCUTTER,:DARKPULSE,:SNARL,:PAYBACK,:QUASH,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:TWISTER,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:SUNNYDAY,:WILLOWISP,:FLY,:AERIALACE,:DEFOG,:TAILWIND,:SHADOWBALL,:SHADOWCLAW,:OMINOUSWIND,:SOLARBEAM,:ENERGYBALL,:GIGADRAIN,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:MUDSLAP,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SWIFT,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:RECYCLE,:ROAR,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:SLUDGEBOMB,:POISONJAB,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:TELEKINESIS,:TRICK,:TRICKROOM,:STONEEDGE,:ROCKSLIDE,:ANCIENTPOWER,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:SURF,:AQUATAIL,:WATERFALL,:WATERPULSE,:RAINDANCE,:LASERFOCUS,:LIQUIDATION,],
	:Color => "Gray",
	:EggGroups => [:Undiscovered],
	:Height => 32,
	:Weight => 3200,
	:kind => "Alpha",
	:dexentry => "It is described in mythology as the Pokémon that shaped the universe with its 1,000 arms.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 0,
},

:VICTINI => {
	:name => "Victini",
	:dexnum => 494,
	:Type1 => :PSYCHIC,
	:Type2 => :FIRE,
	:BaseStats => [100, 100, 100, 100, 100, 100],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:VICTORYSTAR],
	:GrowthRate => "Slow",
	:GenderRatio => "Genderless",
	:BaseEXP => 255,
	:CatchRate => 3,
	:Happiness => 100,
	:EggSteps => 30720,
	:Moveset => [
		[1,:SEARINGSHOT],
		[1,:VCREATE],
		[1,:FUSIONFLARE],
		[1,:FUSIONBOLT],
		[1,:BOLTSTRIKE],
		[1,:BLUEFLARE],
		[1,:GLACIATE],
		[1,:FOCUSENERGY],
		[1,:CONFUSION],
		[1,:INCINERATE],
		[1,:QUICKATTACK],
		[9,:ENDURE],
		[17,:HEADBUTT],
		[25,:FLAMECHARGE],
		[33,:REVERSAL],
		[41,:FLAMEBURST],
		[49,:ZENHEADBUTT],
		[57,:INFERNO],
		[65,:DOUBLEEDGE],
		[73,:FLAREBLITZ],
		[81,:FINALGAMBIT],
		[89,:STOREDPOWER],
		[97,:OVERHEAT]],
	:tmlist => [:SIGNALBEAM,:UTURN,:FLING,:EMBARGO,:TAUNT,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:LIGHTSCREEN,:MAGICCOAT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:LASERFOCUS,:CELEBRATE,],
	:Color => "Yellow",
	:EggGroups => [:Undiscovered],
	:Height => 4,
	:Weight => 40,
	:kind => "Victory",
	:dexentry => "It creates an unlimited supply of energy inside its body, which it shares with those who touch it.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
},

:SNIVY => {
	:name => "Snivy",
	:dexnum => 495,
	:Type1 => :GRASS,
	:BaseStats => [45, 45, 55, 63, 45, 55],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:OVERGROW,:CONTRARY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 64,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:CAPTIVATE,:GLARE,:GRASSYTERRAIN,:IRONTAIL,:MAGICALLEAF,:MEANLOOK,:MIRRORCOAT,:NATURALGIFT,:PURSUIT,:SWEETSCENT,:TWISTER],
	:Moveset => [
		[1,:TACKLE],
		[4,:LEER],
		[7,:VINEWHIP],
		[10,:WRAP],
		[13,:GROWTH],
		[16,:LEAFTORNADO],
		[19,:LEECHSEED],
		[22,:MEGADRAIN],
		[25,:SLAM],
		[28,:LEAFBLADE],
		[31,:COIL],
		[34,:GIGADRAIN],
		[37,:WRINGOUT],
		[40,:GASTROACID],
		[43,:LEAFSTORM]],
	:tmlist => [:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:SUNNYDAY,:AERIALACE,:DEFOG,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GASTROACID,:TOXIC,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:IRONTAIL,:AQUATAIL,],
	:Color => "Green",
	:EggGroups => [:Field,:Grass],
	:Height => 6,
	:Weight => 81,
	:kind => "Grass Snake",
	:dexentry => "They photosynthesize by bathing their tails in sunlight. When they are not feeling well, their tails droop.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SERVINE,:Level,17]
	]
},

:SERVINE => {
	:name => "Servine",
	:dexnum => 496,
	:Type1 => :GRASS,
	:BaseStats => [60, 60, 75, 83, 60, 75],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:OVERGROW,:CONTRARY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 145,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:TACKLE],
		[1,:LEER],
		[1,:VINEWHIP],
		[1,:WRAP],
		[4,:LEER],
		[7,:VINEWHIP],
		[10,:WRAP],
		[13,:GROWTH],
		[16,:LEAFTORNADO],
		[20,:LEECHSEED],
		[24,:MEGADRAIN],
		[28,:SLAM],
		[32,:LEAFBLADE],
		[36,:COIL],
		[40,:GIGADRAIN],
		[44,:WRINGOUT],
		[48,:GASTROACID],
		[52,:LEAFSTORM]],
	:tmlist => [:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:SUNNYDAY,:AERIALACE,:DEFOG,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GASTROACID,:TOXIC,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:IRONTAIL,:AQUATAIL,],
	:Color => "Green",
	:EggGroups => [:Field,:Grass],
	:Height => 8,
	:Weight => 160,
	:kind => "Grass Snake",
	:dexentry => "They avoid attacks by sinking into the shadows of thick foliage. They retaliate with masterful whipping techniques.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SERPERIOR,:Level,36]
	]
},

:SERPERIOR => {
	:name => "Serperior",
	:dexnum => 497,
	:Type1 => :GRASS,
	:BaseStats => [75, 75, 95, 113, 75, 95],
	:EVs => [0, 0, 0, 3, 0, 0],
	:Abilities => [:OVERGROW,:CONTRARY],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 238,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:TACKLE],
		[1,:LEER],
		[1,:VINEWHIP],
		[1,:WRAP],
		[4,:LEER],
		[7,:VINEWHIP],
		[10,:WRAP],
		[13,:GROWTH],
		[16,:LEAFTORNADO],
		[20,:LEECHSEED],
		[24,:MEGADRAIN],
		[28,:SLAM],
		[32,:LEAFBLADE],
		[38,:COIL],
		[44,:GIGADRAIN],
		[50,:WRINGOUT],
		[56,:GASTROACID],
		[62,:LEAFSTORM]],
	:tmlist => [:KNOCKOFF,:SNATCH,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONTAIL,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:DEFOG,:FRENZYPLANT,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GASTROACID,:TOXIC,:CALMMIND,:LIGHTSCREEN,:REFLECT,:REST,:IRONTAIL,:AQUATAIL,:BRUTALSWING,],
	:Color => "Green",
	:EggGroups => [:Field,:Grass],
	:Height => 30,
	:Weight => 630,
	:kind => "Regal",
	:dexentry => "They raise their heads to intimidate opponents but only give it their all when fighting a powerful opponent.",
	:BattlerPlayerY => 12,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:TEPIG => {
	:name => "Tepig",
	:dexnum => 498,
	:Type1 => :FIRE,
	:BaseStats => [65, 63, 45, 45, 45, 45],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:BLAZE,:THICKFAT],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 64,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:BODYSLAM,:BURNUP,:COVET,:CURSE,:ENDEAVOR,:HEAVYSLAM,:MAGNITUDE,:SLEEPTALK,:SUCKERPUNCH,:SUPERPOWER,:THRASH,:YAWN],
	:Moveset => [
		[1,:TACKLE],
		[3,:TAILWHIP],
		[7,:EMBER],
		[9,:ODORSLEUTH],
		[13,:DEFENSECURL],
		[15,:FLAMECHARGE],
		[19,:SMOG],
		[21,:ROLLOUT],
		[25,:TAKEDOWN],
		[27,:HEATCRASH],
		[31,:ASSURANCE],
		[33,:FLAMETHROWER],
		[37,:HEADSMASH],
		[39,:ROAR],
		[43,:FLAREBLITZ]],
	:tmlist => [:TAUNT,:WILDCHARGE,:SUPERPOWER,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:GRASSKNOT,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROCKTOMB,:IRONTAIL,:GYROBALL,:STOMPINGTANTRUM,],
	:Color => "Red",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 99,
	:kind => "Fire Pig",
	:dexentry => "It blows fire through its nose. When it catches a cold, the fire becomes pitch-black smoke instead.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 35,
	:BattlerAltitude => 0,
	:evolutions => [
		[:PIGNITE,:Level,17]
	]
},

:PIGNITE => {
	:name => "Pignite",
	:dexnum => 499,
	:Type1 => :FIRE,
	:Type2 => :FIGHTING,
	:BaseStats => [90, 93, 55, 55, 70, 55],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:BLAZE,:THICKFAT],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 146,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:ARMTHRUST],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[1,:EMBER],
		[1,:ODORSLEUTH],
		[3,:TAILWHIP],
		[7,:EMBER],
		[9,:ODORSLEUTH],
		[13,:DEFENSECURL],
		[15,:FLAMECHARGE],
		[20,:SMOG],
		[23,:ROLLOUT],
		[28,:TAKEDOWN],
		[31,:HEATCRASH],
		[36,:ASSURANCE],
		[39,:FLAMETHROWER],
		[44,:HEADSMASH],
		[47,:ROAR],
		[52,:FLAREBLITZ]],
	:tmlist => [:FLING,:TAUNT,:WILDCHARGE,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:GRASSKNOT,:BULLDOZE,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:GYROBALL,:STOMPINGTANTRUM,],
	:Color => "Red",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 555,
	:kind => "Fire Pig",
	:dexentry => "Whatever it eats becomes fuel for the flame in its stomach. When it is angered, the intensity of the flame increases.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:EMBOAR,:Level,36]
	]
},

:EMBOAR => {
	:name => "Emboar",
	:dexnum => 500,
	:Type1 => :FIRE,
	:Type2 => :FIGHTING,
	:BaseStats => [110, 123, 65, 65, 100, 65],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:BLAZE,:RECKLESS],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 238,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:ARMTHRUST],
		[1,:HAMMERARM],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[1,:EMBER],
		[1,:ODORSLEUTH],
		[3,:TAILWHIP],
		[7,:EMBER],
		[9,:ODORSLEUTH],
		[13,:DEFENSECURL],
		[15,:FLAMECHARGE],
		[20,:SMOG],
		[23,:ROLLOUT],
		[28,:TAKEDOWN],
		[31,:HEATCRASH],
		[38,:ASSURANCE],
		[43,:FLAMETHROWER],
		[50,:HEADSMASH],
		[55,:ROAR],
		[62,:FLAREBLITZ]],
	:tmlist => [:FLING,:TAUNT,:WILDCHARGE,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:BLASTBURN,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:IRONTAIL,:IRONHEAD,:GYROBALL,:SCALD,:STOMPINGTANTRUM,],
	:Color => "Red",
	:EggGroups => [:Field],
	:Height => 16,
	:Weight => 1500,
	:kind => "Mega Firepig",
	:dexentry => "It has mastered fast and powerful fighting moves. It grows a beard of fire.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:OSHAWOTT => {
	:name => "Oshawott",
	:dexnum => 501,
	:Type1 => :WATER,
	:BaseStats => [55, 55, 45, 45, 63, 45],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:TORRENT,:SHELLARMOR],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 64,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AIRSLASH,:ASSURANCE,:BRINE,:COPYCAT,:DETECT,:NIGHTSLASH,:SACREDSWORD,:SCREECH,:TRUMPCARD],
	:Moveset => [
		[1,:TACKLE],
		[5,:TAILWHIP],
		[7,:WATERGUN],
		[11,:WATERSPORT],
		[13,:FOCUSENERGY],
		[17,:RAZORSHELL],
		[19,:FURYCUTTER],
		[23,:WATERPULSE],
		[25,:REVENGE],
		[29,:AQUAJET],
		[31,:ENCORE],
		[35,:AQUATAIL],
		[37,:RETALIATE],
		[41,:SWORDSDANCE],
		[43,:HYDROPUMP]],
	:tmlist => [:XSCISSOR,:FLING,:TAUNT,:ROCKSMASH,:AERIALACE,:GRASSKNOT,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 99,
	:kind => "Sea Otter",
	:dexentry => "The scalchop on its stomach is made from the same element as claws. It detaches the scalchop for use as a blade.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 32,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DEWOTT,:Level,17]
	]
},

:DEWOTT => {
	:name => "Dewott",
	:dexnum => 502,
	:Type1 => :WATER,
	:BaseStats => [75, 75, 60, 60, 83, 60],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:TORRENT,:SHELLARMOR],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 145,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:TACKLE],
		[1,:TAILWHIP],
		[1,:WATERGUN],
		[1,:WATERSPORT],
		[5,:TAILWHIP],
		[7,:WATERGUN],
		[11,:WATERSPORT],
		[13,:FOCUSENERGY],
		[18,:RAZORSHELL],
		[21,:FURYCUTTER],
		[26,:WATERPULSE],
		[29,:REVENGE],
		[34,:AQUAJET],
		[37,:ENCORE],
		[42,:AQUATAIL],
		[45,:RETALIATE],
		[50,:SWORDSDANCE],
		[53,:HYDROPUMP]],
	:tmlist => [:XSCISSOR,:FLING,:TAUNT,:ROCKSMASH,:AERIALACE,:GRASSKNOT,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 8,
	:Weight => 245,
	:kind => "Discipline",
	:dexentry => "Scalchop techniques differ from one Dewott to another. It never neglects maintaining its scalchops.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SAMUROTT,:Level,36]
	]
},

:SAMUROTT => {
	:name => "Samurott",
	:dexnum => 503,
	:Type1 => :WATER,
	:BaseStats => [95, 100, 85, 70, 108, 70],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:TORRENT,:SHELLARMOR],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 238,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:SLASH],
		[1,:MEGAHORN],
		[1,:TACKLE],
		[1,:TAILWHIP],
		[1,:WATERGUN],
		[1,:WATERSPORT],
		[5,:TAILWHIP],
		[7,:WATERGUN],
		[11,:WATERSPORT],
		[13,:FOCUSENERGY],
		[18,:RAZORSHELL],
		[21,:FURYCUTTER],
		[25,:WATERPULSE],
		[29,:REVENGE],
		[34,:AQUAJET],
		[39,:ENCORE],
		[46,:AQUATAIL],
		[51,:RETALIATE],
		[58,:SWORDSDANCE],
		[63,:HYDROPUMP]],
	:tmlist => [:XSCISSOR,:KNOCKOFF,:FLING,:TAUNT,:DRAGONTAIL,:SUPERPOWER,:ROCKSMASH,:AERIALACE,:GRASSKNOT,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:REST,:IRONTAIL,:HYDROCANNON,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:LIQUIDATION,:SMARTSTRIKE,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 15,
	:Weight => 946,
	:kind => "Formidable",
	:dexentry => "Part of the armor on its anterior legs becomes a giant sword. Its cry alone is enough to intimidate most enemies.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:PATRAT => {
	:name => "Patrat",
	:dexnum => 504,
	:Type1 => :NORMAL,
	:BaseStats => [45, 55, 39, 42, 35, 39],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:RUNAWAY,:KEENEYE],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 51,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:ASSURANCE,:BULLETSEED,:FLAIL,:FORESIGHT,:IRONTAIL,:PURSUIT,:REVENGE,:SCREECH,:TEARFULLOOK],
	:Moveset => [
		[1,:TACKLE],
		[3,:LEER],
		[6,:BITE],
		[8,:BIDE],
		[11,:DETECT],
		[13,:SANDATTACK],
		[16,:CRUNCH],
		[18,:HYPNOSIS],
		[21,:SUPERFANG],
		[23,:AFTERYOU],
		[26,:FOCUSENERGY],
		[28,:WORKUP],
		[31,:HYPERFANG],
		[33,:NASTYPLOT],
		[36,:MEANLOOK],
		[38,:BATONPASS],
		[41,:SLAM]],
	:tmlist => [:FLING,:THUNDERBOLT,:SHOCKWAVE,:LOWKICK,:SUNNYDAY,:SHADOWBALL,:SEEDBOMB,:GRASSKNOT,:LASTRESORT,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GUNKSHOT,:TOXIC,:ZENHEADBUTT,:REST,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 116,
	:kind => "Scout",
	:dexentry => "Extremely cautious, they take shifts to maintain a constant watch of their nest. They feel insecure without a lookout.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 29,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WATCHOG,:Level,20]
	]
},

:WATCHOG => {
	:name => "Watchog",
	:dexnum => 505,
	:Type1 => :NORMAL,
	:BaseStats => [60, 85, 69, 77, 60, 69],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:ILLUMINATE,:KEENEYE],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 147,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:CONFUSERAY],
		[1,:ROTOTILLER],
		[1,:TACKLE],
		[1,:LEER],
		[1,:BITE],
		[1,:LOWKICK],
		[3,:LEER],
		[6,:BITE],
		[8,:BIDE],
		[11,:DETECT],
		[13,:SANDATTACK],
		[16,:CRUNCH],
		[18,:HYPNOSIS],
		[22,:SUPERFANG],
		[25,:AFTERYOU],
		[29,:FOCUSENERGY],
		[32,:PSYCHUP],
		[36,:HYPERFANG],
		[39,:NASTYPLOT],
		[43,:MEANLOOK],
		[46,:BATONPASS],
		[50,:SLAM]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:FLING,:THUNDER,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:ROCKSMASH,:LOWKICK,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SEEDBOMB,:GRASSKNOT,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:GUNKSHOT,:TOXIC,:DREAMEATER,:ZENHEADBUTT,:LIGHTSCREEN,:REST,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 11,
	:Weight => 270,
	:kind => "Lookout",
	:dexentry => "They make the patterns on their bodies shine in order to threaten predators. Keen eyesight lets them see in the dark.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:LILLIPUP => {
	:name => "Lillipup",
	:dexnum => 506,
	:Type1 => :NORMAL,
	:BaseStats => [45, 60, 45, 55, 25, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:VITALSPIRIT,:PICKUP],
	:HiddenAbilities => :RUNAWAY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 55,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:AFTERYOU,:CHARM,:ENDURE,:FIREFANG,:HOWL,:ICEFANG,:LICK,:MUDSLAP,:PSYCHICFANGS,:PURSUIT,:SANDATTACK,:THUNDERFANG,:YAWN],
	:Moveset => [
		[1,:LEER],
		[1,:TACKLE],
		[5,:ODORSLEUTH],
		[8,:BITE],
		[10,:BABYDOLLEYES],
		[12,:HELPINGHAND],
		[15,:TAKEDOWN],
		[19,:WORKUP],
		[22,:CRUNCH],
		[26,:ROAR],
		[29,:RETALIATE],
		[33,:REVERSAL],
		[36,:LASTRESORT],
		[40,:GIGAIMPACT],
		[45,:PLAYROUGH]],
	:tmlist => [:SNARL,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:GIGAIMPACT,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKTOMB,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 41,
	:kind => "Puppy",
	:dexentry => "The long hair around its face provides an amazing radar that lets it sense subtle changes in its surroundings.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:HERDIER,:Level,16]
	]
},

:HERDIER => {
	:name => "Herdier",
	:dexnum => 507,
	:Type1 => :NORMAL,
	:BaseStats => [65, 80, 65, 60, 35, 65],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:SANDRUSH],
	:HiddenAbilities => :SCRAPPY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 130,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:LEER],
		[1,:TACKLE],
		[1,:ODORSLEUTH],
		[1,:BITE],
		[5,:ODORSLEUTH],
		[8,:BITE],
		[12,:HELPINGHAND],
		[15,:TAKEDOWN],
		[20,:WORKUP],
		[24,:CRUNCH],
		[29,:ROAR],
		[33,:RETALIATE],
		[38,:REVERSAL],
		[42,:LASTRESORT],
		[47,:GIGAIMPACT],
		[52,:PLAYROUGH]],
	:tmlist => [:SNARL,:PAYBACK,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:GIGAIMPACT,:LASTRESORT,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKTOMB,:SURF,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 9,
	:Weight => 147,
	:kind => "Loyal Dog",
	:dexentry => "It loyally follows its Trainer's orders. For ages, they have helped Trainers raise Pokémon.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:STOUTLAND,:Level,32]
	]
},

:STOUTLAND => {
	:name => "Stoutland",
	:dexnum => 508,
	:Type1 => :NORMAL,
	:BaseStats => [85, 110, 90, 80, 45, 90],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:SANDRUSH],
	:HiddenAbilities => :SCRAPPY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 221,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:ICEFANG],
		[1,:FIREFANG],
		[1,:THUNDERFANG],
		[1,:LEER],
		[1,:TACKLE],
		[1,:ODORSLEUTH],
		[1,:BITE],
		[5,:ODORSLEUTH],
		[8,:BITE],
		[12,:HELPINGHAND],
		[15,:TAKEDOWN],
		[20,:WORKUP],
		[24,:CRUNCH],
		[29,:ROAR],
		[36,:RETALIATE],
		[42,:REVERSAL],
		[51,:LASTRESORT],
		[59,:GIGAIMPACT],
		[63,:PLAYROUGH]],
	:tmlist => [:SNARL,:PAYBACK,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:SHOCKWAVE,:THUNDERWAVE,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKTOMB,:IRONHEAD,:SURF,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 12,
	:Weight => 610,
	:kind => "Big-Hearted",
	:dexentry => "This extremely wise Pokémon excels at rescuing people stranded at sea or in the mountains.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:PURRLOIN => {
	:name => "Purrloin",
	:dexnum => 509,
	:Type1 => :DARK,
	:BaseStats => [41, 50, 37, 66, 50, 37],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:LIMBER,:UNBURDEN],
	:HiddenAbilities => :PRANKSTER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 56,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:CHARM,:COPYCAT,:COVET,:ENCORE,:FAKETEARS,:FEINTATTACK,:FOULPLAY,:PAYDAY,:YAWN],
	:Moveset => [
		[1,:SCRATCH],
		[3,:GROWL],
		[6,:ASSIST],
		[10,:SANDATTACK],
		[12,:FURYSWIPES],
		[15,:PURSUIT],
		[19,:TORMENT],
		[21,:FAKEOUT],
		[24,:HONECLAWS],
		[28,:ASSURANCE],
		[30,:SLASH],
		[33,:CAPTIVATE],
		[37,:NIGHTSLASH],
		[39,:SNATCH],
		[42,:NASTYPLOT],
		[46,:SUCKERPUNCH],
		[49,:PLAYROUGH]],
	:tmlist => [:UTURN,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERWAVE,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:SEEDBOMB,:GRASSKNOT,:HYPERVOICE,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:DREAMEATER,:REST,:ROLEPLAY,:TRICK,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 101,
	:kind => "Devious",
	:dexentry => "Its cute act is a ruse. When victims let down their guard, they find their items taken. It attacks with sharp claws.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LIEPARD,:Level,20]
	]
},

:LIEPARD => {
	:name => "Liepard",
	:dexnum => 510,
	:Type1 => :DARK,
	:BaseStats => [64, 88, 50, 106, 88, 50],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:LIMBER,:UNBURDEN],
	:HiddenAbilities => :PRANKSTER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 156,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:SCRATCH],
		[1,:GROWL],
		[1,:ASSIST],
		[1,:SANDATTACK],
		[3,:GROWL],
		[6,:ASSIST],
		[10,:SANDATTACK],
		[12,:FURYSWIPES],
		[15,:PURSUIT],
		[19,:TORMENT],
		[22,:FAKEOUT],
		[26,:HONECLAWS],
		[31,:ASSURANCE],
		[34,:SLASH],
		[38,:TAUNT],
		[43,:NIGHTSLASH],
		[47,:SNATCH],
		[50,:NASTYPLOT],
		[55,:SUCKERPUNCH],
		[58,:PLAYROUGH]],
	:tmlist => [:UTURN,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:SEEDBOMB,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:TOXIC,:DREAMEATER,:REST,:ROLEPLAY,:TRICK,:IRONTAIL,:RAINDANCE,:CONFIDE,:LASERFOCUS,:THROATCHOP,],
	:Color => "Purple",
	:EggGroups => [:Field],
	:Height => 11,
	:Weight => 375,
	:kind => "Cruel",
	:dexentry => "Stealthily, it sneaks up on its target, striking from behind before its victim has a chance to react.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
},

:PANSAGE => {
	:name => "Pansage",
	:dexnum => 511,
	:Type1 => :GRASS,
	:BaseStats => [50, 53, 48, 64, 53, 48],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:GLUTTONY,:OVERGROW],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 63,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ASTONISH,:BULLETSEED,:COVET,:DISARMINGVOICE,:GRASSWHISTLE,:LEAFSTORM,:LOWKICK,:MAGICALLEAF,:NASTYPLOT,:ROLEPLAY,:SPIKYSHIELD,:TICKLE],
	:Moveset => [
		[1,:SCRATCH],
		[1,:PLAYNICE],
		[4,:LEER],
		[7,:LICK],
		[10,:VINEWHIP],
		[13,:FURYSWIPES],
		[16,:LEECHSEED],
		[19,:BITE],
		[22,:SEEDBOMB],
		[25,:TORMENT],
		[28,:FLING],
		[31,:ACROBATICS],
		[34,:GRASSKNOT],
		[37,:RECYCLE],
		[40,:NATURALGIFT],
		[43,:CRUNCH]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:FOCUSPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:ACROBATICS,:SHADOWCLAW,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:NATUREPOWER,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:GASTROACID,:TOXIC,:REST,:ROLEPLAY,:ROCKTOMB,:IRONTAIL,:CONFIDE,],
	:Color => "Green",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 105,
	:kind => "Grass Monkey",
	:dexentry => "It shares the leaf on its head with weary-looking Pokémon. These leaves are known to relieve stress.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SIMISAGE,:Item,:LEAFSTONE]
	]
},

:SIMISAGE => {
	:name => "Simisage",
	:dexnum => 512,
	:Type1 => :GRASS,
	:BaseStats => [75, 98, 63, 101, 98, 63],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:GLUTTONY,:OVERGROW],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 174,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:LEER],
		[1,:LICK],
		[1,:FURYSWIPES],
		[1,:SEEDBOMB]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:ACROBATICS,:SHADOWCLAW,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSPLEDGE,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:NATUREPOWER,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:GASTROACID,:TOXIC,:REST,:ROLEPLAY,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:CONFIDE,:POWERUPPUNCH,:THROATCHOP,],
	:Color => "Green",
	:EggGroups => [:Field],
	:Height => 11,
	:Weight => 305,
	:kind => "Thorn Monkey",
	:dexentry => "It attacks enemies with strikes of its thorn-covered tail. This Pokémon is wild tempered.",
	:BattlerPlayerY => 13,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:PANSEAR => {
	:name => "Pansear",
	:dexnum => 513,
	:Type1 => :FIRE,
	:BaseStats => [50, 53, 48, 64, 53, 48],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:GLUTTONY,:BLAZE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 63,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ASTONISH,:BELCH,:COVET,:DISARMINGVOICE,:FIREPUNCH,:FIRESPIN,:FLAREBLITZ,:HEATWAVE,:LOWKICK,:NASTYPLOT,:ROLEPLAY,:SLEEPTALK,:TICKLE],
	:Moveset => [
		[1,:SCRATCH],
		[1,:PLAYNICE],
		[4,:LEER],
		[7,:LICK],
		[10,:INCINERATE],
		[13,:FURYSWIPES],
		[16,:YAWN],
		[19,:BITE],
		[22,:FLAMEBURST],
		[25,:AMNESIA],
		[28,:FLING],
		[31,:ACROBATICS],
		[34,:FIREBLAST],
		[37,:RECYCLE],
		[40,:NATURALGIFT],
		[43,:CRUNCH]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:FOCUSPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:ACROBATICS,:SHADOWCLAW,:SOLARBEAM,:GRASSKNOT,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:GASTROACID,:TOXIC,:REST,:ROLEPLAY,:ROCKTOMB,:IRONTAIL,:CONFIDE,],
	:Color => "Red",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 110,
	:kind => "High Temp",
	:dexentry => "This Pokémon lives in caves in volcanoes. The fire within the tuft on its head can reach 600º F.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SIMISEAR,:Item,:FIRESTONE]
	]
},

:SIMISEAR => {
	:name => "Simisear",
	:dexnum => 514,
	:Type1 => :FIRE,
	:BaseStats => [75, 98, 63, 101, 98, 63],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:GLUTTONY,:BLAZE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 174,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:LEER],
		[1,:LICK],
		[1,:FURYSWIPES],
		[1,:FLAMEBURST]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FIREPLEDGE,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:ACROBATICS,:SHADOWCLAW,:SOLARBEAM,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:GASTROACID,:TOXIC,:REST,:ROLEPLAY,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:CONFIDE,:POWERUPPUNCH,:THROATCHOP,],
	:Color => "Red",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 280,
	:kind => "Ember",
	:dexentry => "A flame burns inside its body. It scatters embers from its head and tail to sear its opponents.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
},

:PANPOUR => {
	:name => "Panpour",
	:dexnum => 515,
	:Type1 => :WATER,
	:BaseStats => [50, 53, 48, 64, 53, 48],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:GLUTTONY,:TORRENT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 63,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AQUARING,:AQUATAIL,:ASTONISH,:COVET,:DISARMINGVOICE,:HYDROPUMP,:LOWKICK,:MUDSPORT,:NASTYPLOT,:ROLEPLAY,:TICKLE],
	:Moveset => [
		[1,:SCRATCH],
		[1,:PLAYNICE],
		[4,:LEER],
		[7,:LICK],
		[10,:WATERGUN],
		[13,:FURYSWIPES],
		[16,:WATERSPORT],
		[19,:BITE],
		[22,:SCALD],
		[25,:TAUNT],
		[28,:FLING],
		[31,:ACROBATICS],
		[34,:BRINE],
		[37,:RECYCLE],
		[40,:NATURALGIFT],
		[43,:CRUNCH]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:FOCUSPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:ACROBATICS,:SHADOWCLAW,:GRASSKNOT,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:GASTROACID,:TOXIC,:REST,:ROLEPLAY,:ROCKTOMB,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 135,
	:kind => "Spray",
	:dexentry => "It does not thrive in dry environments. It keeps itself damp by shooting water stored in its head tuft from its tail.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SIMIPOUR,:Item,:WATERSTONE]
	]
},

:SIMIPOUR => {
	:name => "Simipour",
	:dexnum => 516,
	:Type1 => :WATER,
	:BaseStats => [75, 98, 63, 101, 98, 63],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:GLUTTONY,:TORRENT],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 174,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:LEER],
		[1,:LICK],
		[1,:FURYSWIPES],
		[1,:SCALD]],
	:tmlist => [:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:TORMENT,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:ACROBATICS,:SHADOWCLAW,:GRASSKNOT,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:GASTROACID,:TOXIC,:REST,:ROLEPLAY,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:WATERPLEDGE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:THROATCHOP,],
	:Color => "Blue",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 290,
	:kind => "Geyser",
	:dexentry => "The high-pressure water expelled from its tail is so powerful, it can destroy a concrete wall.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:MUNNA => {
	:name => "Munna",
	:dexnum => 517,
	:Type1 => :PSYCHIC,
	:BaseStats => [76, 25, 45, 24, 67, 55],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:FOREWARN,:SYNCHRONIZE],
	:HiddenAbilities => :TELEPATHY,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 2560,
	:EggMoves => [:BARRIER,:BATONPASS,:CURSE,:HEALINGWISH,:HELPINGHAND,:MAGICCOAT,:SECRETPOWER,:SLEEPTALK,:SONICBOOM,:SWIFT],
	:Moveset => [
		[1,:PSYWAVE],
		[1,:DEFENSECURL],
		[5,:LUCKYCHANT],
		[7,:YAWN],
		[11,:PSYBEAM],
		[13,:IMPRISON],
		[17,:MOONLIGHT],
		[19,:HYPNOSIS],
		[23,:ZENHEADBUTT],
		[25,:SYNCHRONOISE],
		[29,:NIGHTMARE],
		[31,:FUTURESIGHT],
		[35,:CALMMIND],
		[37,:PSYCHIC],
		[41,:DREAMEATER],
		[43,:TELEKINESIS],
		[47,:STOREDPOWER]],
	:tmlist => [:SIGNALBEAM,:TORMENT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SHADOWBALL,:ENERGYBALL,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:GYROBALL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Pink",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 233,
	:kind => "Dream Eater",
	:dexentry => "It eats the dreams of people and Pokémon. When it eats a pleasant dream, it expels pink-colored mist.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 10,
	:evolutions => [
		[:MUSHARNA,:Item,:MOONSTONE]
	]
},

:MUSHARNA => {
	:name => "Musharna",
	:dexnum => 518,
	:Type1 => :PSYCHIC,
	:BaseStats => [116, 55, 85, 29, 107, 95],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:FOREWARN,:SYNCHRONIZE],
	:HiddenAbilities => :TELEPATHY,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 170,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 2560,
	:Moveset => [
		[1,:PSYCHICTERRAIN],
		[1,:DEFENSECURL],
		[1,:LUCKYCHANT],
		[1,:PSYBEAM],
		[1,:HYPNOSIS]],
	:tmlist => [:SIGNALBEAM,:TORMENT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SHADOWBALL,:ENERGYBALL,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:GYROBALL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Pink",
	:EggGroups => [:Field],
	:Height => 11,
	:Weight => 605,
	:kind => "Drowsing",
	:dexentry => "With the mist from its forehead, it can create shapes of things from dreams it has eaten.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 10,
},

:PIDOVE => {
	:name => "Pidove",
	:dexnum => 519,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [50, 55, 50, 43, 36, 30],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:BIGPECKS,:SUPERLUCK],
	:HiddenAbilities => :RIVALRY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 53,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:BESTOW,:HYPNOSIS,:LUCKYCHANT,:MORNINGSUN,:NIGHTSLASH,:STEELWING,:UPROAR,:WISH],
	:Moveset => [
		[1,:GUST],
		[4,:GROWL],
		[8,:LEER],
		[11,:QUICKATTACK],
		[15,:AIRCUTTER],
		[18,:ROOST],
		[22,:DETECT],
		[25,:TAUNT],
		[29,:AIRSLASH],
		[32,:RAZORWIND],
		[36,:FEATHERDANCE],
		[39,:SWAGGER],
		[43,:FACADE],
		[46,:TAILWIND],
		[50,:SKYATTACK]],
	:tmlist => [:UTURN,:TAUNT,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Flying],
	:Height => 3,
	:Weight => 21,
	:kind => "Tiny Pigeon",
	:dexentry => "These Pokémon live in cities. They are accustomed to people. Flocks often gather in parks and plazas.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:TRANQUILL,:Level,21]
	]
},

:TRANQUILL => {
	:name => "Tranquill",
	:dexnum => 520,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [62, 77, 62, 65, 50, 42],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:BIGPECKS,:SUPERLUCK],
	:HiddenAbilities => :RIVALRY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 125,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:GUST],
		[1,:GROWL],
		[1,:LEER],
		[1,:QUICKATTACK],
		[4,:GROWL],
		[8,:LEER],
		[11,:QUICKATTACK],
		[15,:AIRCUTTER],
		[18,:ROOST],
		[23,:DETECT],
		[27,:TAUNT],
		[32,:AIRSLASH],
		[36,:RAZORWIND],
		[41,:FEATHERDANCE],
		[45,:SWAGGER],
		[50,:FACADE],
		[54,:TAILWIND],
		[59,:SKYATTACK]],
	:tmlist => [:UTURN,:TAUNT,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Flying],
	:Height => 6,
	:Weight => 150,
	:kind => "Wild Pigeon",
	:dexentry => "Many people believe that, deep in the forest where Tranquill live, there is a peaceful place where there is no war.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 29,
	:BattlerAltitude => 0,
	:evolutions => [
		[:UNFEZANT,:Level,32]
	]
},

:UNFEZANT => {
	:name => "Unfezant",
	:dexnum => 521,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [80, 115, 80, 93, 65, 55],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:BIGPECKS,:SUPERLUCK],
	:HiddenAbilities => :RIVALRY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 215,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:GUST],
		[1,:GROWL],
		[1,:LEER],
		[1,:QUICKATTACK],
		[4,:GROWL],
		[8,:LEER],
		[11,:QUICKATTACK],
		[15,:AIRCUTTER],
		[18,:ROOST],
		[23,:DETECT],
		[27,:TAUNT],
		[33,:AIRSLASH],
		[38,:RAZORWIND],
		[44,:FEATHERDANCE],
		[49,:SWAGGER],
		[55,:FACADE],
		[60,:TAILWIND],
		[66,:SKYATTACK]],
	:tmlist => [:UTURN,:TAUNT,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Flying],
	:Height => 12,
	:Weight => 290,
	:kind => "Proud",
	:dexentry => "Males have plumage on their heads. They will never let themselves feel close to anyone other than their Trainers.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
},

:BLITZLE => {
	:name => "Blitzle",
	:dexnum => 522,
	:Type1 => :ELECTRIC,
	:BaseStats => [45, 60, 32, 76, 50, 32],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:LIGHTNINGROD,:MOTORDRIVE],
	:HiddenAbilities => :SAPSIPPER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 59,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:DOUBLEKICK,:DOUBLEEDGE,:ENDURE,:FEINT,:MEFIRST,:RAGE,:SANDATTACK,:SCREECH,:SHOCKWAVE,:SNATCH,:TAKEDOWN],
	:Moveset => [
		[1,:QUICKATTACK],
		[4,:TAILWHIP],
		[8,:CHARGE],
		[11,:SHOCKWAVE],
		[15,:THUNDERWAVE],
		[18,:FLAMECHARGE],
		[22,:PURSUIT],
		[25,:SPARK],
		[29,:STOMP],
		[32,:DISCHARGE],
		[36,:AGILITY],
		[39,:WILDCHARGE],
		[43,:THRASH]],
	:tmlist => [:SIGNALBEAM,:SNATCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:LOWKICK,:FLAMECHARGE,:BOUNCE,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:RAINDANCE,:CONFIDE,],
	:Color => "Black",
	:EggGroups => [:Field],
	:Height => 8,
	:Weight => 298,
	:kind => "Electrified",
	:dexentry => "When thunderclouds cover the sky, it will appear. It can catch lightning with its mane and store the electricity.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ZEBSTRIKA,:Level,27]
	]
},

:ZEBSTRIKA => {
	:name => "Zebstrika",
	:dexnum => 523,
	:Type1 => :ELECTRIC,
	:BaseStats => [75, 100, 63, 116, 80, 63],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:LIGHTNINGROD,:MOTORDRIVE],
	:HiddenAbilities => :SAPSIPPER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 174,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:IONDELUGE],
		[1,:QUICKATTACK],
		[1,:TAILWHIP],
		[1,:CHARGE],
		[1,:THUNDERWAVE],
		[4,:TAILWHIP],
		[8,:CHARGE],
		[11,:SHOCKWAVE],
		[15,:THUNDERWAVE],
		[18,:FLAMECHARGE],
		[22,:PURSUIT],
		[25,:SPARK],
		[31,:STOMP],
		[36,:DISCHARGE],
		[42,:AGILITY],
		[47,:WILDCHARGE],
		[53,:THRASH],
		[58,:IONDELUGE]],
	:tmlist => [:SIGNALBEAM,:SNATCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:LOWKICK,:OVERHEAT,:FLAMECHARGE,:BOUNCE,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:LIGHTSCREEN,:REST,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Black",
	:EggGroups => [:Field],
	:Height => 16,
	:Weight => 795,
	:kind => "Thunderbolt",
	:dexentry => "When this ill-tempered Pokémon runs wild, it shoots lightning from its mane in all directions.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
},

:ROGGENROLA => {
	:name => "Roggenrola",
	:dexnum => 524,
	:Type1 => :ROCK,
	:BaseStats => [55, 75, 85, 15, 25, 25],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:STURDY,:WEAKARMOR],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 56,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:AUTOTOMIZE,:CURSE,:GRAVITY,:HEAVYSLAM,:LOCKON,:MAGNITUDE,:ROCKTOMB,:TAKEDOWN,:WIDEGUARD],
	:Moveset => [
		[1,:TACKLE],
		[4,:HARDEN],
		[7,:SANDATTACK],
		[10,:HEADBUTT],
		[14,:ROCKBLAST],
		[17,:MUDSLAP],
		[20,:IRONDEFENSE],
		[23,:SMACKDOWN],
		[27,:ROCKSLIDE],
		[30,:STEALTHROCK],
		[33,:SANDSTORM],
		[36,:STONEEDGE],
		[40,:EXPLOSION]],
	:tmlist => [:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:EXPLOSION,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONDEFENSE,:CONFIDE,],
	:Color => "Blue",
	:EggGroups => [:Mineral],
	:Height => 4,
	:Weight => 180,
	:WildItemCommon => :EVERSTONE,
	:WildItemUncommon => :HARDSTONE,
	:kind => "Mantle",
	:dexentry => "They were discovered a hundred years ago in an earthquake fissure. Inside each one is an energy core.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BOLDORE,:Level,25]
	]
},

:BOLDORE => {
	:name => "Boldore",
	:dexnum => 525,
	:Type1 => :ROCK,
	:BaseStats => [70, 105, 105, 20, 50, 40],
	:EVs => [0, 1, 1, 0, 0, 0],
	:Abilities => [:STURDY,:WEAKARMOR],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 137,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[0,:POWERGEM],
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:SANDATTACK],
		[1,:HEADBUTT],
		[4,:HARDEN],
		[7,:SANDATTACK],
		[10,:HEADBUTT],
		[14,:ROCKBLAST],
		[17,:MUDSLAP],
		[20,:IRONDEFENSE],
		[23,:SMACKDOWN],
		[30,:ROCKSLIDE],
		[36,:STEALTHROCK],
		[42,:SANDSTORM],
		[48,:STONEEDGE],
		[55,:EXPLOSION]],
	:tmlist => [:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:EXPLOSION,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONDEFENSE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:EggGroups => [:Mineral],
	:Height => 9,
	:Weight => 1020,
	:WildItemCommon => :EVERSTONE,
	:WildItemUncommon => :HARDSTONE,
	:kind => "Ore",
	:dexentry => "Because its energy was too great to be contained, the energy leaked and formed orange crystals.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GIGALITH,:Trade,0]
	]
},

:GIGALITH => {
	:name => "Gigalith",
	:dexnum => 526,
	:Type1 => :ROCK,
	:BaseStats => [85, 135, 130, 25, 60, 80],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:STURDY,:SANDSTREAM],
	:HiddenAbilities => :SANDFORCE,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 227,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:POWERGEM],
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:SANDATTACK],
		[1,:HEADBUTT],
		[4,:HARDEN],
		[7,:SANDATTACK],
		[10,:HEADBUTT],
		[14,:ROCKBLAST],
		[17,:MUDSLAP],
		[20,:IRONDEFENSE],
		[23,:SMACKDOWN],
		[30,:ROCKSLIDE],
		[36,:STEALTHROCK],
		[42,:SANDSTORM],
		[48,:STONEEDGE],
		[55,:EXPLOSION]],
	:tmlist => [:SUPERPOWER,:ROCKSMASH,:SOLARBEAM,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:IRONDEFENSE,:CONFIDE,:LASERFOCUS,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Blue",
	:EggGroups => [:Mineral],
	:Height => 17,
	:Weight => 2600,
	:WildItemCommon => :EVERSTONE,
	:WildItemUncommon => :HARDSTONE,
	:kind => "Compressed",
	:dexentry => "The solar energy absorbed by its body's orange crystals is magnified internally and fired from its mouth.",
	:BattlerPlayerY => 10,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
},

:WOOBAT => {
	:name => "Woobat",
	:dexnum => 527,
	:Type1 => :PSYCHIC,
	:Type2 => :FLYING,
	:BaseStats => [65, 45, 43, 72, 55, 43],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:UNAWARE,:KLUTZ],
	:HiddenAbilities => :SIMPLE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 63,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:CAPTIVATE,:CHARM,:FAKETEARS,:FLATTER,:HELPINGHAND,:KNOCKOFF,:PSYCHOSHIFT,:ROOST,:STOREDPOWER,:SUPERSONIC,:SYNCHRONOISE,:VENOMDRENCH],
	:Moveset => [
		[1,:CONFUSION],
		[4,:ODORSLEUTH],
		[8,:GUST],
		[12,:ASSURANCE],
		[15,:HEARTSTAMP],
		[19,:IMPRISON],
		[21,:AIRCUTTER],
		[25,:ATTRACT],
		[29,:AMNESIA],
		[29,:CALMMIND],
		[32,:AIRSLASH],
		[36,:FUTURESIGHT],
		[41,:PSYCHIC],
		[47,:ENDEAVOR]],
	:tmlist => [:SIGNALBEAM,:UTURN,:THIEF,:KNOCKOFF,:EMBARGO,:TAUNT,:TORMENT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:HEATWAVE,:FLY,:AERIALACE,:ACROBATICS,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:ENERGYBALL,:GIGADRAIN,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:STEELWING,:GYROBALL,:RAINDANCE,:CONFIDE,],
	:Color => "Blue",
	:EggGroups => [:Flying,:Field],
	:Height => 4,
	:Weight => 21,
	:kind => "Bat",
	:dexentry => "Suction from its nostrils enables it to stick to cave walls during sleep. It leaves a heart-shaped mark behind.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 5,
	:evolutions => [
		[:SWOOBAT,:Happiness,0]
	]
},

:SWOOBAT => {
	:name => "Swoobat",
	:dexnum => 528,
	:Type1 => :PSYCHIC,
	:Type2 => :FLYING,
	:BaseStats => [67, 57, 55, 114, 77, 55],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:UNAWARE,:KLUTZ],
	:HiddenAbilities => :SIMPLE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 149,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:CONFUSION],
		[1,:ODORSLEUTH],
		[1,:GUST],
		[1,:ASSURANCE],
		[4,:ODORSLEUTH],
		[8,:GUST],
		[12,:ASSURANCE],
		[15,:HEARTSTAMP],
		[19,:IMPRISON],
		[21,:AIRCUTTER],
		[25,:ATTRACT],
		[29,:AMNESIA],
		[29,:CALMMIND],
		[32,:AIRSLASH],
		[36,:FUTURESIGHT],
		[41,:PSYCHIC],
		[47,:ENDEAVOR]],
	:tmlist => [:SIGNALBEAM,:UTURN,:THIEF,:KNOCKOFF,:EMBARGO,:TAUNT,:TORMENT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:HEATWAVE,:SKYATTACK,:FLY,:AERIALACE,:ACROBATICS,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:ENERGYBALL,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:STEELWING,:GYROBALL,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Blue",
	:EggGroups => [:Flying,:Field],
	:Height => 9,
	:Weight => 105,
	:kind => "Courting",
	:dexentry => "Anyone who comes into contact with the ultrasonic waves emitted by a courting male experiences a positive mood shift.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 5,
},

:DRILBUR => {
	:name => "Drilbur",
	:dexnum => 529,
	:Type1 => :GROUND,
	:BaseStats => [60, 85, 40, 68, 30, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SANDRUSH,:SANDFORCE],
	:HiddenAbilities => :MOLDBREAKER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:CRUSHCLAW,:EARTHPOWER,:IRONDEFENSE,:METALSOUND,:RAPIDSPIN,:ROCKCLIMB,:SKULLBASH,:SUBMISSION],
	:Moveset => [
		[1,:SCRATCH],
		[1,:MUDSPORT],
		[5,:RAPIDSPIN],
		[8,:MUDSLAP],
		[12,:FURYSWIPES],
		[15,:METALCLAW],
		[19,:DIG],
		[22,:HONECLAWS],
		[26,:SLASH],
		[29,:ROCKSLIDE],
		[33,:EARTHQUAKE],
		[36,:SWORDSDANCE],
		[40,:SANDSTORM],
		[43,:DRILLRUN],
		[47,:FISSURE]],
	:tmlist => [:XSCISSOR,:FLING,:BRICKBREAK,:ROCKSMASH,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:ROCKCLIMB,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONDEFENSE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 3,
	:Weight => 85,
	:kind => "Mole",
	:dexentry => "It makes its way swiftly through the soil by putting both claws together and rotating at high speed.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:EXCADRILL,:Level,31]
	]
},

:EXCADRILL => {
	:name => "Excadrill",
	:dexnum => 530,
	:Type1 => :GROUND,
	:Type2 => :STEEL,
	:BaseStats => [110, 135, 60, 88, 50, 65],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SANDRUSH,:SANDFORCE],
	:HiddenAbilities => :MOLDBREAKER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 178,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:HORNDRILL],
		[1,:ROTOTILLER],
		[1,:SCRATCH],
		[1,:MUDSPORT],
		[1,:RAPIDSPIN],
		[1,:MUDSLAP],
		[5,:RAPIDSPIN],
		[8,:MUDSLAP],
		[12,:FURYSWIPES],
		[15,:METALCLAW],
		[19,:DIG],
		[22,:HONECLAWS],
		[26,:SLASH],
		[29,:ROCKSLIDE],
		[36,:EARTHQUAKE],
		[42,:SWORDSDANCE],
		[49,:SANDSTORM],
		[55,:DRILLRUN],
		[62,:FISSURE]],
	:tmlist => [:XSCISSOR,:FLING,:MAGNETRISE,:FOCUSBLAST,:BRICKBREAK,:ROCKSMASH,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:DRILLRUN,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:IRONDEFENSE,:CONFIDE,:BRUTALSWING,:SMARTSTRIKE,:STOMPINGTANTRUM,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 7,
	:Weight => 404,
	:kind => "Subterenne",
	:dexentry => "More than 300 feet below the surface, they build mazelike nests. Their activity can be destructive to subway tunnels.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 29,
	:BattlerAltitude => 0,
},

:AUDINO => {
	:name => "Audino",
	:dexnum => 531,
	:Type1 => :NORMAL,
	:BaseStats => [103, 60, 86, 50, 60, 86],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:HEALER,:REGENERATOR],
	:HiddenAbilities => :KLUTZ,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 255,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AMNESIA,:BESTOW,:DRAININGKISS,:ENCORE,:HEALBELL,:HEALINGWISH,:LUCKYCHANT,:SLEEPTALK,:SWEETKISS,:WISH,:YAWN],
	:Moveset => [
		[1,:LASTRESORT],
		[1,:HYPERVOICE],
		[1,:MISTYTERRAIN],
		[1,:PLAYNICE],
		[1,:POUND],
		[1,:GROWL],
		[1,:HELPINGHAND],
		[5,:BABYDOLLEYES],
		[9,:REFRESH],
		[13,:DISARMINGVOICE],
		[17,:DOUBLESLAP],
		[21,:ATTRACT],
		[25,:SECRETPOWER],
		[29,:ENTRAINMENT],
		[33,:TAKEDOWN],
		[37,:HEALPULSE],
		[41,:AFTERYOU],
		[45,:SIMPLEBEAM],
		[49,:DOUBLEEDGE],
		[53,:HYPERVOICE],
		[57,:LASTRESORT]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:FLING,:SNATCH,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:CHARGEBEAM,:THUNDERWAVE,:FOCUSPUNCH,:DRAINPUNCH,:LOWKICK,:FIREBLAST,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICKROOM,:IRONTAIL,:SURF,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Pink",
	:EggGroups => [:Fairy],
	:Height => 11,
	:Weight => 310,
	:WildItemCommon => :ORANBERRY,
	:WildItemUncommon => :SITRUSBERRY,
	:kind => "Hearing",
	:dexentry => "Its auditory sense is astounding. It has a radar-like ability to understand its surrounding through slight sounds.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
},

:TIMBURR => {
	:name => "Timburr",
	:dexnum => 532,
	:Type1 => :FIGHTING,
	:BaseStats => [75, 80, 55, 35, 25, 35],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:GUTS,:SHEERFORCE],
	:HiddenAbilities => :IRONFIST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 61,
	:CatchRate => 180,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:COMETPUNCH,:COUNTER,:DETECT,:DRAINPUNCH,:ENDURE,:FORCEPALM,:FORESIGHT,:MACHPUNCH,:POWERUPPUNCH,:REVERSAL,:SMELLINGSALTS,:WIDEGUARD],
	:Moveset => [
		[1,:POUND],
		[1,:LEER],
		[4,:FOCUSENERGY],
		[8,:BIDE],
		[12,:LOWKICK],
		[16,:ROCKTHROW],
		[20,:WAKEUPSLAP],
		[24,:CHIPAWAY],
		[28,:BULKUP],
		[31,:ROCKSLIDE],
		[34,:DYNAMICPUNCH],
		[37,:SCARYFACE],
		[40,:HAMMERARM],
		[43,:STONEEDGE],
		[46,:FOCUSPUNCH],
		[49,:SUPERPOWER]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:GRASSKNOT,:ICEPUNCH,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,],
	:Color => "Gray",
	:EggGroups => [:HumanLike],
	:Height => 6,
	:Weight => 125,
	:kind => "Muscular",
	:dexentry => "These Pokémon appear at building sites and help out with construction. They always carry squared logs.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GURDURR,:Level,25]
	]
},

:GURDURR => {
	:name => "Gurdurr",
	:dexnum => 533,
	:Type1 => :FIGHTING,
	:BaseStats => [85, 105, 85, 40, 40, 50],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:GUTS,:SHEERFORCE],
	:HiddenAbilities => :IRONFIST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 142,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:POUND],
		[1,:LEER],
		[1,:FOCUSENERGY],
		[1,:BIDE],
		[4,:FOCUSENERGY],
		[8,:BIDE],
		[12,:LOWKICK],
		[16,:ROCKTHROW],
		[20,:WAKEUPSLAP],
		[24,:CHIPAWAY],
		[29,:BULKUP],
		[33,:ROCKSLIDE],
		[37,:DYNAMICPUNCH],
		[41,:SCARYFACE],
		[45,:HAMMERARM],
		[49,:STONEEDGE],
		[53,:FOCUSPUNCH],
		[57,:SUPERPOWER]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:GRASSKNOT,:ICEPUNCH,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,],
	:Color => "Gray",
	:EggGroups => [:HumanLike],
	:Height => 12,
	:Weight => 400,
	:kind => "Muscular",
	:dexentry => "They strengthen their bodies by carrying steel beams. They show off their big muscles to their friends.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 29,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CONKELDURR,:Trade,0]
	]
},

:CONKELDURR => {
	:name => "Conkeldurr",
	:dexnum => 534,
	:Type1 => :FIGHTING,
	:BaseStats => [105, 140, 95, 45, 55, 65],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:GUTS,:SHEERFORCE],
	:HiddenAbilities => :IRONFIST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemQuarter",
	:BaseEXP => 227,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:POUND],
		[1,:LEER],
		[1,:FOCUSENERGY],
		[1,:BIDE],
		[4,:FOCUSENERGY],
		[8,:BIDE],
		[12,:LOWKICK],
		[16,:ROCKTHROW],
		[20,:WAKEUPSLAP],
		[24,:CHIPAWAY],
		[29,:BULKUP],
		[33,:ROCKSLIDE],
		[37,:DYNAMICPUNCH],
		[41,:SCARYFACE],
		[45,:HAMMERARM],
		[49,:STONEEDGE],
		[53,:FOCUSPUNCH],
		[57,:SUPERPOWER]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:HumanLike],
	:Height => 14,
	:Weight => 870,
	:kind => "Muscular",
	:dexentry => "They use concrete pillars as walking canes. They know moves that enable them to swing the pillars freely in battle.",
	:BattlerPlayerY => 22,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
},

:TYMPOLE => {
	:name => "Tympole",
	:dexnum => 535,
	:Type1 => :WATER,
	:BaseStats => [50, 50, 40, 64, 50, 40],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:SWIFTSWIM,:HYDRATION],
	:HiddenAbilities => :WATERABSORB,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 59,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AFTERYOU,:EARTHPOWER,:MIST,:MUDBOMB,:MUDSPORT,:REFRESH,:SLEEPTALK,:SNORE,:VENOMDRENCH,:WATERPULSE],
	:Moveset => [
		[1,:BUBBLE],
		[1,:GROWL],
		[5,:SUPERSONIC],
		[9,:ROUND],
		[12,:BUBBLEBEAM],
		[16,:MUDSHOT],
		[20,:AQUARING],
		[23,:UPROAR],
		[27,:MUDDYWATER],
		[31,:RAINDANCE],
		[34,:FLAIL],
		[38,:ECHOEDVOICE],
		[42,:HYDROPUMP],
		[45,:HYPERVOICE]],
	:tmlist => [:BOUNCE,:EARTHPOWER,:ICYWIND,:HAIL,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:REST,:SURF,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Blue",
	:EggGroups => [:Water1],
	:Height => 5,
	:Weight => 45,
	:kind => "Tadpole",
	:dexentry => "By vibrating its cheeks, it emits sound waves imperceptible to humans. It uses the rhythm of these sounds to talk.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 2,
	:evolutions => [
		[:PALPITOAD,:Level,25]
	]
},

:PALPITOAD => {
	:name => "Palpitoad",
	:dexnum => 536,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [75, 65, 55, 69, 65, 55],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:HYDRATION],
	:HiddenAbilities => :WATERABSORB,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 134,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:BUBBLE],
		[1,:GROWL],
		[1,:SUPERSONIC],
		[1,:ROUND],
		[5,:SUPERSONIC],
		[9,:ROUND],
		[12,:BUBBLEBEAM],
		[16,:MUDSHOT],
		[20,:AQUARING],
		[23,:UPROAR],
		[28,:MUDDYWATER],
		[33,:RAINDANCE],
		[37,:FLAIL],
		[42,:ECHOEDVOICE],
		[47,:HYDROPUMP],
		[51,:HYPERVOICE]],
	:tmlist => [:FOCUSPUNCH,:ROCKSMASH,:BOUNCE,:EARTHPOWER,:BULLDOZE,:ICYWIND,:HAIL,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:GASTROACID,:TOXIC,:REST,:STEALTHROCK,:SURF,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Blue",
	:EggGroups => [:Water1],
	:Height => 8,
	:Weight => 170,
	:kind => "Vibration",
	:dexentry => "It lives in the water and on land. It uses its long, sticky tongue to capture prey.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SEISMITOAD,:Level,36]
	]
},

:SEISMITOAD => {
	:name => "Seismitoad",
	:dexnum => 537,
	:Type1 => :WATER,
	:Type2 => :GROUND,
	:BaseStats => [105, 95, 75, 74, 85, 75],
	:EVs => [3, 0, 0, 0, 0, 0],
	:Abilities => [:SWIFTSWIM,:POISONTOUCH],
	:HiddenAbilities => :WATERABSORB,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 225,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:ACID],
		[1,:BUBBLE],
		[1,:GROWL],
		[1,:SUPERSONIC],
		[1,:ROUND],
		[5,:SUPERSONIC],
		[9,:ROUND],
		[12,:BUBBLEBEAM],
		[16,:MUDSHOT],
		[20,:AQUARING],
		[23,:UPROAR],
		[28,:MUDDYWATER],
		[33,:RAINDANCE],
		[39,:FLAIL],
		[44,:DRAINPUNCH],
		[49,:ECHOEDVOICE],
		[53,:HYDROPUMP],
		[59,:HYPERVOICE]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:FLING,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:LOWKICK,:BOUNCE,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:ICEPUNCH,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:STEALTHROCK,:SURF,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Blue",
	:EggGroups => [:Water1],
	:Height => 15,
	:Weight => 620,
	:kind => "Vibration",
	:dexentry => "It increases the power of its punches by vibrating the bumps on its fists. It can turn a boulder to rubble with one punch.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
},

:THROH => {
	:name => "Throh",
	:dexnum => 538,
	:Type1 => :FIGHTING,
	:BaseStats => [120, 100, 85, 45, 30, 85],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:GUTS,:INNERFOCUS],
	:HiddenAbilities => :MOLDBREAKER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemZero",
	:BaseEXP => 163,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:MATBLOCK],
		[1,:BIND],
		[1,:LEER],
		[1,:BIDE],
		[1,:FOCUSENERGY],
		[5,:SEISMICTOSS],
		[9,:VITALTHROW],
		[13,:REVENGE],
		[17,:STORMTHROW],
		[21,:BODYSLAM],
		[25,:BULKUP],
		[29,:CIRCLETHROW],
		[33,:ENDURE],
		[37,:WIDEGUARD],
		[41,:SUPERPOWER],
		[45,:REVERSAL]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:ICEPUNCH,:GIGAIMPACT,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Red",
	:EggGroups => [:HumanLike],
	:Height => 13,
	:Weight => 555,
	:WildItemUncommon => :BLACKBELT,
	:kind => "Judo",
	:dexentry => "When they encounter foes bigger than themselves, they try to throw them. They always travel in packs of five.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
},

:SAWK => {
	:name => "Sawk",
	:dexnum => 539,
	:Type1 => :FIGHTING,
	:BaseStats => [75, 125, 75, 85, 30, 75],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:STURDY,:INNERFOCUS],
	:HiddenAbilities => :MOLDBREAKER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemZero",
	:BaseEXP => 163,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:ROCKSMASH],
		[1,:LEER],
		[1,:BIDE],
		[1,:FOCUSENERGY],
		[5,:DOUBLEKICK],
		[9,:LOWSWEEP],
		[13,:COUNTER],
		[17,:KARATECHOP],
		[21,:BRICKBREAK],
		[25,:BULKUP],
		[29,:RETALIATE],
		[33,:ENDURE],
		[37,:QUICKGUARD],
		[41,:CLOSECOMBAT],
		[45,:REVERSAL]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:ICEPUNCH,:GIGAIMPACT,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:HELPINGHAND,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:POISONJAB,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,:THROATCHOP,],
	:Color => "Blue",
	:EggGroups => [:HumanLike],
	:Height => 14,
	:Weight => 510,
	:WildItemUncommon => :BLACKBELT,
	:kind => "Karate",
	:dexentry => "Tying their belts gets them pumped and makes their punches more destructive. Disturbing their training angers them.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
},

:SEWADDLE => {
	:name => "Sewaddle",
	:dexnum => 540,
	:Type1 => :BUG,
	:Type2 => :GRASS,
	:BaseStats => [45, 53, 70, 42, 40, 60],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SWARM,:CHLOROPHYLL],
	:HiddenAbilities => :OVERCOAT,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 62,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:AGILITY,:AIRSLASH,:BATONPASS,:CAMOUFLAGE,:GRASSYTERRAIN,:MEFIRST,:MINDREADER,:RAZORWIND,:SCREECH,:SILVERWIND],
	:Moveset => [
		[1,:TACKLE],
		[1,:STRINGSHOT],
		[8,:BUGBITE],
		[15,:RAZORLEAF],
		[22,:STRUGGLEBUG],
		[29,:ENDURE],
		[31,:STICKYWEB],
		[36,:BUGBUZZ],
		[43,:FLAIL]],
	:tmlist => [:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:PAYBACK,:ELECTROWEB,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REST,:IRONDEFENSE,:CONFIDE,],
	:Color => "Yellow",
	:EggGroups => [:Bug],
	:Height => 3,
	:Weight => 25,
	:WildItemUncommon => :MENTALHERB,
	:kind => "Sewing",
	:dexentry => "This Pokémon makes clothes for itself. It chews up leaves and sews them with sticky thread extruded from its mouth.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SWADLOON,:Level,20]
	]
},

:SWADLOON => {
	:name => "Swadloon",
	:dexnum => 541,
	:Type1 => :BUG,
	:Type2 => :GRASS,
	:BaseStats => [55, 63, 90, 42, 50, 80],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:LEAFGUARD,:CHLOROPHYLL],
	:HiddenAbilities => :OVERCOAT,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 133,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[0,:PROTECT],
		[1,:GRASSWHISTLE],
		[1,:TACKLE],
		[1,:STRINGSHOT],
		[1,:BUGBITE],
		[1,:RAZORLEAF]],
	:tmlist => [:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:PAYBACK,:ELECTROWEB,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REST,:IRONDEFENSE,:CONFIDE,],
	:Color => "Green",
	:EggGroups => [:Bug],
	:Height => 5,
	:Weight => 73,
	:WildItemUncommon => :MENTALHERB,
	:kind => "Leaf-Wrapped",
	:dexentry => "It protects itself from the cold by wrapping up in leaves. It stays on the move, eating leaves in forests.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LEAVANNY,:Happiness,0]
	]
},

:LEAVANNY => {
	:name => "Leavanny",
	:dexnum => 542,
	:Type1 => :BUG,
	:Type2 => :GRASS,
	:BaseStats => [75, 103, 80, 92, 70, 80],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:SWARM,:CHLOROPHYLL],
	:HiddenAbilities => :OVERCOAT,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 221,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[0,:SLASH],
		[1,:FALSESWIPE],
		[1,:TACKLE],
		[1,:STRINGSHOT],
		[1,:BUGBITE],
		[1,:RAZORLEAF],
		[8,:BUGBITE],
		[15,:RAZORLEAF],
		[22,:STRUGGLEBUG],
		[29,:FELLSTINGER],
		[32,:HELPINGHAND],
		[36,:LEAFBLADE],
		[39,:XSCISSOR],
		[43,:ENTRAINMENT],
		[46,:SWORDSDANCE],
		[50,:LEAFSTORM]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:PAYBACK,:KNOCKOFF,:ELECTROWEB,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:DREAMEATER,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:STEELWING,:IRONDEFENSE,:CONFIDE,:LASERFOCUS,:THROATCHOP,],
	:Color => "Yellow",
	:EggGroups => [:Bug],
	:Height => 12,
	:Weight => 205,
	:WildItemUncommon => :MENTALHERB,
	:kind => "Nurturing",
	:dexentry => "It keeps its eggs warm with heat from fermenting leaves. It also uses leaves to make warm wrappings for Sewaddle.",
	:BattlerPlayerY => 8,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 0,
},

:VENIPEDE => {
	:name => "Venipede",
	:dexnum => 543,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [30, 45, 59, 57, 30, 39],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:POISONPOINT,:SWARM],
	:HiddenAbilities => :SPEEDBOOST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 52,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:PINMISSILE,:ROCKCLIMB,:SPIKES,:TAKEDOWN,:TOXICSPIKES,:TWINEEDLE],
	:Moveset => [
		[1,:DEFENSECURL],
		[1,:ROLLOUT],
		[5,:POISONSTING],
		[8,:SCREECH],
		[12,:PURSUIT],
		[15,:PROTECT],
		[19,:POISONTAIL],
		[22,:BUGBITE],
		[26,:VENOSHOCK],
		[29,:AGILITY],
		[33,:STEAMROLLER],
		[36,:TOXIC],
		[38,:VENOMDRENCH],
		[40,:ROCKCLIMB],
		[43,:DOUBLEEDGE]],
	:tmlist => [:BUGBITE,:STRUGGLEBUG,:PAYBACK,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ROCKCLIMB,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:GYROBALL,:IRONDEFENSE,:CONFIDE,:INFESTATION,],
	:Color => "Red",
	:EggGroups => [:Bug],
	:Height => 4,
	:Weight => 53,
	:kind => "Centipede",
	:dexentry => "It discovers what is going on around it by using the feelers on its head and tail. It is brutally aggresive.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 35,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WHIRLIPEDE,:Level,22]
	]
},

:WHIRLIPEDE => {
	:name => "Whirlipede",
	:dexnum => 544,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [40, 55, 99, 47, 40, 79],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:POISONPOINT,:SWARM],
	:HiddenAbilities => :SPEEDBOOST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 126,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[0,:IRONDEFENSE],
		[1,:DEFENSECURL],
		[1,:ROLLOUT],
		[1,:POISONSTING],
		[1,:SCREECH],
		[5,:POISONSTING],
		[8,:SCREECH],
		[12,:PURSUIT],
		[15,:PROTECT],
		[19,:POISONTAIL],
		[23,:BUGBITE],
		[28,:VENOSHOCK],
		[32,:AGILITY],
		[37,:STEAMROLLER],
		[41,:TOXIC],
		[43,:VENOMDRENCH],
		[46,:ROCKCLIMB],
		[50,:DOUBLEEDGE]],
	:tmlist => [:BUGBITE,:STRUGGLEBUG,:PAYBACK,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ROCKCLIMB,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:GYROBALL,:IRONDEFENSE,:CONFIDE,:INFESTATION,],
	:Color => "Gray",
	:EggGroups => [:Bug],
	:Height => 12,
	:Weight => 585,
	:kind => "Curlipede",
	:dexentry => "It is usually motionless, but when attacked, it rotates at high speed and then crashes into its opponent.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SCOLIPEDE,:Level,30]
	]
},

:SCOLIPEDE => {
	:name => "Scolipede",
	:dexnum => 545,
	:Type1 => :BUG,
	:Type2 => :POISON,
	:BaseStats => [60, 100, 89, 112, 55, 69],
	:EVs => [0, 0, 0, 3, 0, 0],
	:Abilities => [:POISONPOINT,:SWARM],
	:HiddenAbilities => :SPEEDBOOST,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 214,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[0,:BATONPASS],
		[1,:IRONDEFENSE],
		[1,:MEGAHORN],
		[1,:DEFENSECURL],
		[1,:ROLLOUT],
		[1,:POISONSTING],
		[1,:SCREECH],
		[5,:POISONSTING],
		[8,:SCREECH],
		[12,:PURSUIT],
		[15,:PROTECT],
		[19,:POISONTAIL],
		[23,:BUGBITE],
		[28,:VENOSHOCK],
		[33,:AGILITY],
		[39,:STEAMROLLER],
		[44,:TOXIC],
		[47,:VENOMDRENCH],
		[50,:ROCKCLIMB],
		[55,:DOUBLEEDGE],
		[65,:MEGAHORN]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:PAYBACK,:SNATCH,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:SLUDGEBOMB,:POISONJAB,:VENOSHOCK,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:GYROBALL,:IRONDEFENSE,:AQUATAIL,:CONFIDE,:INFESTATION,:SMARTSTRIKE,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Red",
	:EggGroups => [:Bug],
	:Height => 25,
	:Weight => 2005,
	:kind => "Megapede",
	:dexentry => "Highly aggressive, it uses the claws near its neck to dig into and poison its opponents.",
	:BattlerPlayerY => 8,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 0,
},

:COTTONEE => {
	:name => "Cottonee",
	:dexnum => 546,
	:Type1 => :GRASS,
	:Type2 => :FAIRY,
	:BaseStats => [40, 27, 60, 66, 37, 50],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:PRANKSTER,:INFILTRATOR],
	:HiddenAbilities => :CHLOROPHYLL,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 56,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:BEATUP,:CAPTIVATE,:ENCORE,:FAKETEARS,:GRASSWHISTLE,:MEMENTO,:MISTYTERRAIN,:NATURALGIFT,:SWITCHEROO,:TICKLE,:WORRYSEED],
	:Moveset => [
		[1,:ABSORB],
		[1,:FAIRYWIND],
		[4,:GROWTH],
		[8,:LEECHSEED],
		[10,:STUNSPORE],
		[13,:MEGADRAIN],
		[17,:COTTONSPORE],
		[19,:RAZORLEAF],
		[22,:POISONPOWDER],
		[26,:GIGADRAIN],
		[28,:CHARM],
		[31,:HELPINGHAND],
		[35,:ENERGYBALL],
		[37,:COTTONGUARD],
		[40,:SUNNYDAY],
		[44,:ENDEAVOR],
		[46,:SOLARBEAM]],
	:tmlist => [:KNOCKOFF,:TAUNT,:SUNNYDAY,:DEFOG,:TAILWIND,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:WORRYSEED,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:REST,:DAZZLINGGLEAM,],
	:Color => "Green",
	:EggGroups => [:Fairy,:Grass],
	:Height => 3,
	:Weight => 6,
	:WildItemUncommon => :ABSORBBULB,
	:kind => "Cotton Puff",
	:dexentry => "They go wherever the wind takes them. On rainy days, their bodies are heavier, so they take shelter beneath big trees.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 40,
	:BattlerAltitude => 0,
	:evolutions => [
		[:WHIMSICOTT,:Item,:SUNSTONE]
	]
},

:WHIMSICOTT => {
	:name => "Whimsicott",
	:dexnum => 547,
	:Type1 => :GRASS,
	:Type2 => :FAIRY,
	:BaseStats => [60, 67, 85, 116, 77, 75],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:PRANKSTER,:INFILTRATOR],
	:HiddenAbilities => :CHLOROPHYLL,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 168,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:GROWTH],
		[1,:LEECHSEED],
		[1,:MEGADRAIN],
		[1,:COTTONSPORE],
		[10,:GUST],
		[28,:TAILWIND],
		[46,:HURRICANE],
		[50,:MOONBLAST]],
	:tmlist => [:UTURN,:THIEF,:KNOCKOFF,:FLING,:TAUNT,:SUNNYDAY,:DEFOG,:TAILWIND,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:LIGHTSCREEN,:REST,:TRICKROOM,:DAZZLINGGLEAM,],
	:Color => "Green",
	:EggGroups => [:Fairy,:Grass],
	:Height => 7,
	:Weight => 66,
	:WildItemUncommon => :ABSORBBULB,
	:kind => "Windveiled",
	:dexentry => "Riding whirlwinds, they appear. These Pokémon sneak through gaps into houses and cause all sorts of mischief.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 0,
},

:PETILIL => {
	:name => "Petilil",
	:dexnum => 548,
	:Type1 => :GRASS,
	:BaseStats => [45, 35, 50, 30, 70, 50],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:CHLOROPHYLL,:OWNTEMPO],
	:HiddenAbilities => :LEAFGUARD,
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 56,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:BIDE,:CHARM,:ENCORE,:ENDURE,:GRASSWHISTLE,:HEALINGWISH,:INGRAIN,:NATURALGIFT,:SWEETSCENT,:WORRYSEED],
	:Moveset => [
		[1,:ABSORB],
		[4,:GROWTH],
		[8,:LEECHSEED],
		[10,:SLEEPPOWDER],
		[13,:MEGADRAIN],
		[17,:SYNTHESIS],
		[19,:MAGICALLEAF],
		[22,:STUNSPORE],
		[26,:GIGADRAIN],
		[28,:AROMATHERAPY],
		[31,:HELPINGHAND],
		[35,:ENERGYBALL],
		[37,:ENTRAINMENT],
		[40,:SUNNYDAY],
		[44,:AFTERYOU],
		[46,:LEAFSTORM]],
	:tmlist => [:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:REST,:CONFIDE,:LASERFOCUS,],
	:Color => "Green",
	:EggGroups => [:Grass],
	:Height => 5,
	:Weight => 66,
	:WildItemUncommon => :ABSORBBULB,
	:kind => "Bulb",
	:dexentry => "Since they prefer moist, nutrient-rich soil, the areas where Petilil live are known to be good for growing plants.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LILLIGANT,:Item,:SUNSTONE]
	]
},

:LILLIGANT => {
	:name => "Lilligant",
	:dexnum => 549,
	:Type1 => :GRASS,
	:BaseStats => [70, 60, 75, 90, 110, 75],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:CHLOROPHYLL,:OWNTEMPO],
	:HiddenAbilities => :LEAFGUARD,
	:GrowthRate => "MediumFast",
	:GenderRatio => "MaleNever",
	:BaseEXP => 168,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:GROWTH],
		[1,:LEECHSEED],
		[1,:MEGADRAIN],
		[1,:SYNTHESIS],
		[10,:TEETERDANCE],
		[28,:QUIVERDANCE],
		[46,:PETALDANCE],
		[50,:PETALBLIZZARD]],
	:tmlist => [:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:DREAMEATER,:LIGHTSCREEN,:REST,:ROLEPLAY,:CONFIDE,:LASERFOCUS,],
	:Color => "Green",
	:EggGroups => [:Grass],
	:Height => 11,
	:Weight => 163,
	:WildItemUncommon => :ABSORBBULB,
	:kind => "Flowering",
	:dexentry => "The fragrance of the garland on its head has a relaxing effect. It withers if a Trainer does not take good care of it.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
},

:BASCULIN => {
	:name => "Basculin",
	:dexnum => 550,
	:Type1 => :WATER,
	:BaseStats => [70, 92, 65, 98, 80, 55],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:RECKLESS,:ADAPTABILITY],
	:HiddenAbilities => :MOLDBREAKER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 10240,
	:EggMoves => [:AGILITY,:BRINE,:BUBBLEBEAM,:HEADSMASH,:MUDSHOT,:MUDDYWATER,:RAGE,:REVENGE,:SWIFT,:WHIRLPOOL],
	:Moveset => [
		[1,:TAILWHIP],
		[1,:TACKLE],
		[1,:WATERGUN],
		[3,:UPROAR],
		[5,:HEADBUTT],
		[7,:BITE],
		[9,:AQUAJET],
		[11,:CHIPAWAY],
		[14,:TAKEDOWN],
		[17,:CRUNCH],
		[20,:AQUATAIL],
		[23,:SOAK],
		[26,:DOUBLEEDGE],
		[30,:SCARYFACE],
		[34,:FLAIL],
		[38,:FINALGAMBIT],
		[42,:THRASH],
		[46,:HEADSMASH]],
	:tmlist => [:TAUNT,:SUPERPOWER,:BOUNCE,:ICEBEAM,:ICYWIND,:HAIL,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Green",
	:EggGroups => [:Water2],
	:Height => 10,
	:Weight => 180,
	:WildItemRare => :DEEPSEATOOTH,
	:kind => "Hostile",
	:dexentry => "Red and blue Basculin usually do not get along, but sometimes members of one school mingle with the other's school.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 1,
},

:SANDILE => {
	:name => "Sandile",
	:dexnum => 551,
	:Type1 => :GROUND,
	:Type2 => :DARK,
	:BaseStats => [50, 72, 35, 65, 35, 35],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:MOXIE],
	:HiddenAbilities => :ANGERPOINT,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 180,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:BEATUP,:COUNTER,:DOUBLEEDGE,:FIREFANG,:FOCUSENERGY,:MEFIRST,:MEANLOOK,:POWERTRIP,:PURSUIT,:ROCKCLIMB,:THUNDERFANG,:UPROAR],
	:Moveset => [
		[1,:LEER],
		[1,:RAGE],
		[4,:BITE],
		[7,:SANDATTACK],
		[10,:TORMENT],
		[13,:SANDTOMB],
		[16,:ASSURANCE],
		[19,:MUDSLAP],
		[22,:EMBARGO],
		[25,:SWAGGER],
		[28,:CRUNCH],
		[31,:DIG],
		[34,:SCARYFACE],
		[37,:FOULPLAY],
		[40,:SANDSTORM],
		[43,:EARTHQUAKE],
		[46,:THRASH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:ROCKCLIMB,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:AQUATAIL,:CONFIDE,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 7,
	:Weight => 152,
	:WildItemUncommon => :BLACKGLASSES,
	:kind => "Desert Croc",
	:dexentry => "It moves along below the sand's surface, except for its nose and eyes. A dark membrane shields its eyes from the sun.",
	:BattlerPlayerY => 35,
	:BattlerEnemyY => 41,
	:BattlerAltitude => 0,
	:evolutions => [
		[:KROKOROK,:Level,29]
	]
},

:KROKOROK => {
	:name => "Krokorok",
	:dexnum => 552,
	:Type1 => :GROUND,
	:Type2 => :DARK,
	:BaseStats => [60, 82, 45, 74, 45, 45],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:MOXIE],
	:HiddenAbilities => :ANGERPOINT,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 123,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:LEER],
		[1,:RAGE],
		[1,:BITE],
		[1,:SANDATTACK],
		[4,:BITE],
		[7,:SANDATTACK],
		[10,:TORMENT],
		[13,:SANDTOMB],
		[16,:ASSURANCE],
		[19,:MUDSLAP],
		[22,:EMBARGO],
		[25,:SWAGGER],
		[28,:CRUNCH],
		[32,:DIG],
		[36,:SCARYFACE],
		[40,:FOULPLAY],
		[44,:SANDSTORM],
		[48,:EARTHQUAKE],
		[52,:THRASH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:FOCUSPUNCH,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:SHADOWCLAW,:SPITE,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:AQUATAIL,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 10,
	:Weight => 334,
	:WildItemUncommon => :BLACKGLASSES,
	:kind => "Desert Croc",
	:dexentry => "The special membrane covering its eyes can sense the heat of objects, so it can see its surroundings even in darkness.",
	:BattlerPlayerY => 15,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
	:evolutions => [
		[:KROOKODILE,:Level,40]
	]
},

:KROOKODILE => {
	:name => "Krookodile",
	:dexnum => 553,
	:Type1 => :GROUND,
	:Type2 => :DARK,
	:BaseStats => [95, 117, 80, 92, 65, 70],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:INTIMIDATE,:MOXIE],
	:HiddenAbilities => :ANGERPOINT,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 229,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:POWERTRIP],
		[1,:LEER],
		[1,:RAGE],
		[1,:BITE],
		[1,:SANDATTACK],
		[4,:BITE],
		[7,:SANDATTACK],
		[10,:TORMENT],
		[13,:SANDTOMB],
		[16,:ASSURANCE],
		[19,:MUDSLAP],
		[22,:EMBARGO],
		[25,:SWAGGER],
		[28,:CRUNCH],
		[32,:DIG],
		[36,:SCARYFACE],
		[42,:FOULPLAY],
		[48,:SANDSTORM],
		[54,:EARTHQUAKE],
		[60,:OUTRAGE]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:AERIALACE,:SHADOWCLAW,:SPITE,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:AQUATAIL,:CONFIDE,:POWERUPPUNCH,:BRUTALSWING,:STOMPINGTANTRUM,:THROATCHOP,],
	:Color => "Red",
	:EggGroups => [:Field],
	:Height => 15,
	:Weight => 963,
	:WildItemUncommon => :BLACKGLASSES,
	:kind => "Intimidation",
	:dexentry => "It can expand the focus of its eyes, enabling it to see objects in the far distance as if it were using binoculars.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:DARUMAKA => {
	:name => "Darumaka",
	:dexnum => 554,
	:Type1 => :FIRE,
	:BaseStats => [70, 90, 45, 50, 15, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:HUSTLE,:INNERFOCUS],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 63,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ENCORE,:ENDURE,:EXTRASENSORY,:FLAMEWHEEL,:FOCUSENERGY,:FOCUSPUNCH,:HAMMERARM,:SLEEPTALK,:SNATCH,:TAKEDOWN,:YAWN],
	:Moveset => [
		[1,:TACKLE],
		[3,:ROLLOUT],
		[6,:INCINERATE],
		[9,:RAGE],
		[11,:FIREFANG],
		[14,:HEADBUTT],
		[17,:UPROAR],
		[19,:FACADE],
		[22,:FIREPUNCH],
		[25,:WORKUP],
		[27,:THRASH],
		[30,:BELLYDRUM],
		[33,:FLAREBLITZ],
		[35,:TAUNT],
		[39,:SUPERPOWER],
		[42,:OVERHEAT]],
	:tmlist => [:UTURN,:THIEF,:FLING,:SNATCH,:TAUNT,:FOCUSPUNCH,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:GRASSKNOT,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:ZENHEADBUTT,:REST,:ROCKSLIDE,:ROCKTOMB,:GYROBALL,],
	:Color => "Red",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 375,
	:kind => "Zen Charm",
	:dexentry => "Darumaka's droppings are hot, so people used to put them in their clothes to keep themselves warm.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 0,
	:evolutions => [
		[:DARMANITAN,:Level,35]
	]
},

:DARMANITAN => {
	:name => "Darmanitan",
	:dexnum => 555,
	:Type1 => :FIRE,
	:BaseStats => [105, 140, 55, 95, 30, 55],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SHEERFORCE,:ZENMODE],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 168,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:HAMMERARM],
		[1,:TACKLE],
		[1,:ROLLOUT],
		[1,:INCINERATE],
		[1,:RAGE],
		[3,:ROLLOUT],
		[6,:INCINERATE],
		[9,:RAGE],
		[11,:FIREFANG],
		[14,:HEADBUTT],
		[17,:SWAGGER],
		[19,:FACADE],
		[22,:FIREPUNCH],
		[25,:WORKUP],
		[27,:THRASH],
		[30,:BELLYDRUM],
		[33,:FLAREBLITZ],
		[39,:TAUNT],
		[47,:SUPERPOWER],
		[54,:OVERHEAT]],
	:tmlist => [:UTURN,:PAYBACK,:THIEF,:FLING,:SNATCH,:TAUNT,:TORMENT,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:BULKUP,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:PSYCHIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:GYROBALL,:LASERFOCUS,],
	:Color => "Red",
	:EggGroups => [:Field],
	:Height => 13,
	:Weight => 929,
	:kind => "Blazing",
	:dexentry => "When weakened in battle, it transforms into a stone statue. Then it sharpens its mind and fights on mentally.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
},

:MARACTUS => {
	:name => "Maractus",
	:dexnum => 556,
	:Type1 => :GRASS,
	:BaseStats => [75, 86, 67, 60, 106, 67],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:WATERABSORB,:CHLOROPHYLL],
	:HiddenAbilities => :STORMDRAIN,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 161,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:BOUNCE,:BULLETSEED,:GRASSWHISTLE,:GRASSYTERRAIN,:LEECHSEED,:SEEDBOMB,:SPIKES,:WOODHAMMER,:WORRYSEED],
	:Moveset => [
		[1,:SPIKYSHIELD],
		[1,:COTTONGUARD],
		[1,:AFTERYOU],
		[1,:PECK],
		[1,:ABSORB],
		[3,:SWEETSCENT],
		[6,:GROWTH],
		[10,:PINMISSILE],
		[13,:MEGADRAIN],
		[15,:SYNTHESIS],
		[18,:COTTONSPORE],
		[22,:NEEDLEARM],
		[26,:GIGADRAIN],
		[29,:ACUPRESSURE],
		[33,:INGRAIN],
		[38,:PETALDANCE],
		[42,:SUCKERPUNCH],
		[45,:SUNNYDAY],
		[48,:PETALBLIZZARD],
		[50,:SOLARBEAM],
		[55,:COTTONGUARD],
		[57,:AFTERYOU]],
	:tmlist => [:KNOCKOFF,:DRAINPUNCH,:SUNNYDAY,:BOUNCE,:AERIALACE,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:REST,:CONFIDE,:THROATCHOP,],
	:Color => "Green",
	:EggGroups => [:Grass],
	:Height => 10,
	:Weight => 280,
	:WildItemUncommon => :MIRACLESEED,
	:kind => "Cactus",
	:dexentry => "Arid regions are their habitat. They move rhythmically, making a sound similar to maracas.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:DWEBBLE => {
	:name => "Dwebble",
	:dexnum => 557,
	:Type1 => :BUG,
	:Type2 => :ROCK,
	:BaseStats => [50, 65, 85, 55, 35, 35],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:STURDY,:SHELLARMOR],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 65,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:BLOCK,:COUNTER,:CURSE,:ENDURE,:IRONDEFENSE,:NIGHTSLASH,:ROTOTILLER,:SANDTOMB,:SPIKES,:WIDEGUARD],
	:Moveset => [
		[1,:FURYCUTTER],
		[5,:ROCKBLAST],
		[7,:WITHDRAW],
		[11,:SANDATTACK],
		[13,:FEINTATTACK],
		[17,:SMACKDOWN],
		[19,:ROCKPOLISH],
		[23,:BUGBITE],
		[24,:STEALTHROCK],
		[29,:ROCKSLIDE],
		[31,:SLASH],
		[35,:XSCISSOR],
		[37,:SHELLSMASH],
		[41,:FLAIL],
		[43,:ROCKWRECKER]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:KNOCKOFF,:ROCKSMASH,:AERIALACE,:SHADOWCLAW,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONDEFENSE,:CONFIDE,],
	:Color => "Red",
	:EggGroups => [:Bug,:Mineral],
	:Height => 3,
	:Weight => 145,
	:WildItemUncommon => :HARDSTONE,
	:kind => "Rock Inn",
	:dexentry => "It makes a hole in a suitable rock. If that rock breaks, the Pokémon remains agitated until it locates a replacement.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 39,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CRUSTLE,:Level,34]
	]
},

:CRUSTLE => {
	:name => "Crustle",
	:dexnum => 558,
	:Type1 => :BUG,
	:Type2 => :ROCK,
	:BaseStats => [70, 105, 125, 45, 65, 75],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:STURDY,:SHELLARMOR],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:SHELLSMASH],
		[1,:ROCKBLAST],
		[1,:WITHDRAW],
		[1,:SANDATTACK],
		[5,:ROCKBLAST],
		[7,:WITHDRAW],
		[11,:SANDATTACK],
		[13,:FEINTATTACK],
		[17,:SMACKDOWN],
		[19,:ROCKPOLISH],
		[23,:BUGBITE],
		[24,:STEALTHROCK],
		[29,:ROCKSLIDE],
		[31,:SLASH],
		[38,:XSCISSOR],
		[43,:SHELLSMASH],
		[50,:FLAIL],
		[55,:ROCKWRECKER]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:KNOCKOFF,:ROCKSMASH,:AERIALACE,:SHADOWCLAW,:SOLARBEAM,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONDEFENSE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Red",
	:EggGroups => [:Bug,:Mineral],
	:Height => 14,
	:Weight => 2000,
	:WildItemUncommon => :HARDSTONE,
	:kind => "Stone Home",
	:dexentry => "It possesses legs of enormous strength, enabling it to carry heavy slabs for many days, even when crossing arid land.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:SCRAGGY => {
	:name => "Scraggy",
	:dexnum => 559,
	:Type1 => :DARK,
	:Type2 => :FIGHTING,
	:BaseStats => [50, 75, 70, 48, 35, 70],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SHEDSKIN,:MOXIE],
	:HiddenAbilities => :INTIMIDATE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 70,
	:CatchRate => 180,
	:Happiness => 35,
	:EggSteps => 3840,
	:EggMoves => [:ACIDSPRAY,:AMNESIA,:COUNTER,:DETECT,:DRAGONDANCE,:DRAINPUNCH,:FAKEOUT,:FEINTATTACK,:FIREPUNCH,:ICEPUNCH,:POWERUPPUNCH,:QUICKGUARD,:THUNDERPUNCH,:ZENHEADBUTT],
	:Moveset => [
		[1,:LEER],
		[1,:HEADBUTT],
		[5,:SANDATTACK],
		[9,:FEINTATTACK],
		[12,:SWAGGER],
		[16,:LOWKICK],
		[20,:PAYBACK],
		[23,:BRICKBREAK],
		[27,:CHIPAWAY],
		[31,:HIJUMPKICK],
		[34,:SCARYFACE],
		[38,:CRUNCH],
		[42,:FACADE],
		[45,:ROCKCLIMB],
		[48,:FOCUSPUNCH],
		[50,:HEADSMASH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:KNOCKOFF,:FLING,:SNATCH,:TAUNT,:TORMENT,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:SPITE,:GRASSKNOT,:ICEPUNCH,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:SLUDGEBOMB,:POISONJAB,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Yellow",
	:EggGroups => [:Field,:Dragon],
	:Height => 6,
	:Weight => 118,
	:WildItemUncommon => :SHEDSHELL,
	:kind => "Shedding",
	:dexentry => "It immediately headbutts anyone that makes eye contact with it. Its skull is massively thick.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 32,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SCRAFTY,:Level,39]
	]
},

:SCRAFTY => {
	:name => "Scrafty",
	:dexnum => 560,
	:Type1 => :DARK,
	:Type2 => :FIGHTING,
	:BaseStats => [65, 90, 115, 58, 45, 115],
	:EVs => [0, 0, 1, 0, 0, 1],
	:Abilities => [:SHEDSKIN,:MOXIE],
	:HiddenAbilities => :INTIMIDATE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 171,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:LEER],
		[1,:HEADBUTT],
		[1,:SANDATTACK],
		[1,:FEINTATTACK],
		[5,:SANDATTACK],
		[9,:FEINTATTACK],
		[12,:SWAGGER],
		[16,:LOWKICK],
		[20,:PAYBACK],
		[23,:BRICKBREAK],
		[27,:CHIPAWAY],
		[31,:HIJUMPKICK],
		[34,:SCARYFACE],
		[38,:CRUNCH],
		[45,:FACADE],
		[51,:ROCKCLIMB],
		[58,:FOCUSPUNCH],
		[65,:HEADSMASH]],
	:tmlist => [:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:SNATCH,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:DUALCHOP,:THUNDERPUNCH,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:FIREPUNCH,:SUNNYDAY,:SPITE,:GRASSKNOT,:ICEPUNCH,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:SLUDGEBOMB,:POISONJAB,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:THROATCHOP,],
	:Color => "Red",
	:EggGroups => [:Field,:Dragon],
	:Height => 11,
	:Weight => 300,
	:WildItemUncommon => :SHEDSHELL,
	:kind => "Hoodlum",
	:dexentry => "It can smash concrete blocks with its kicking attacks. The one with the biggest crest is the group leader.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
},

:SIGILYPH => {
	:name => "Sigilyph",
	:dexnum => 561,
	:Type1 => :PSYCHIC,
	:Type2 => :FLYING,
	:BaseStats => [72, 58, 80, 97, 103, 80],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:WONDERSKIN,:MAGICGUARD],
	:HiddenAbilities => :TINTEDLENS,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 172,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ANCIENTPOWER,:FUTURESIGHT,:PSYCHOSHIFT,:ROOST,:SKILLSWAP,:STEELWING,:STOREDPOWER],
	:Moveset => [
		[1,:GUST],
		[1,:MIRACLEEYE],
		[4,:HYPNOSIS],
		[8,:PSYWAVE],
		[11,:TAILWIND],
		[14,:WHIRLWIND],
		[18,:PSYBEAM],
		[21,:AIRCUTTER],
		[24,:LIGHTSCREEN],
		[28,:REFLECT],
		[31,:SYNCHRONOISE],
		[34,:MIRRORMOVE],
		[38,:GRAVITY],
		[41,:AIRSLASH],
		[44,:PSYCHIC],
		[48,:COSMICPOWER],
		[50,:SKYATTACK]],
	:tmlist => [:SIGNALBEAM,:DARKPULSE,:THIEF,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:HEATWAVE,:SKYATTACK,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:ICEBEAM,:ICYWIND,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:SMACKDOWN,:FLASHCANNON,:STEELWING,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Black",
	:EggGroups => [:Flying],
	:Height => 14,
	:Weight => 140,
	:kind => "Avianoid",
	:dexentry => "The guardians of an ancient city, they use their psychic power to attack enemies that invade their territory.",
	:BattlerPlayerY => 4,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 17,
},

:YAMASK => {
	:name => "Yamask",
	:dexnum => 562,
	:Type1 => :GHOST,
	:BaseStats => [38, 30, 85, 30, 55, 65],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:MUMMY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 6400,
	:EggMoves => [:ALLYSWITCH,:CRAFTYSHIELD,:DISABLE,:ENDURE,:FAKETEARS,:HEALBLOCK,:IMPRISON,:MEMENTO,:NASTYPLOT,:NIGHTMARE,:TOXICSPIKES],
	:Moveset => [
		[1,:ASTONISH],
		[1,:PROTECT],
		[5,:DISABLE],
		[9,:HAZE],
		[13,:NIGHTSHADE],
		[17,:HEX],
		[21,:WILLOWISP],
		[25,:OMINOUSWIND],
		[29,:CURSE],
		[33,:POWERSPLIT],
		[33,:GUARDSPLIT],
		[37,:SHADOWBALL],
		[41,:GRUDGE],
		[45,:MEANLOOK],
		[49,:DESTINYBOND]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:SHOCKWAVE,:WILLOWISP,:SHADOWBALL,:SPITE,:ENERGYBALL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:MAGICCOAT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONDEFENSE,:RAINDANCE,:INFESTATION,],
	:Color => "Black",
	:EggGroups => [:Mineral,:Amorphous],
	:Height => 5,
	:Weight => 15,
	:WildItemUncommon => :SPELLTAG,
	:kind => "Spirit",
	:dexentry => "These Pokémon arose from the spirits of people interred in graves in past ages. Each retains memories of its former life.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 2,
	:evolutions => [
		[:COFAGRIGUS,:Level,34]
	]
},

:COFAGRIGUS => {
	:name => "Cofagrigus",
	:dexnum => 563,
	:Type1 => :GHOST,
	:BaseStats => [58, 50, 145, 30, 95, 105],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:MUMMY],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 169,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 6400,
	:Moveset => [
		[0,:SCARYFACE],
		[1,:ASTONISH],
		[1,:PROTECT],
		[1,:DISABLE],
		[1,:HAZE],
		[5,:DISABLE],
		[9,:HAZE],
		[13,:NIGHTSHADE],
		[17,:HEX],
		[21,:WILLOWISP],
		[25,:OMINOUSWIND],
		[29,:CURSE],
		[33,:POWERSPLIT],
		[33,:GUARDSPLIT],
		[39,:SHADOWBALL],
		[45,:GRUDGE],
		[51,:MEANLOOK],
		[57,:DESTINYBOND]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:SHOCKWAVE,:WILLOWISP,:SHADOWBALL,:SPITE,:ENERGYBALL,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:BLOCK,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:MAGICCOAT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:IRONDEFENSE,:RAINDANCE,:INFESTATION,],
	:Color => "Yellow",
	:EggGroups => [:Mineral,:Amorphous],
	:Height => 17,
	:Weight => 765,
	:WildItemUncommon => :SPELLTAG,
	:kind => "Coffin",
	:dexentry => "They pretend to be elaborate coffins to teach lessons to grave robbers. Their bodies are covered in pure gold.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => -6,
	:BattlerAltitude => 0,
},

:TIRTOUGA => {
	:name => "Tirtouga",
	:dexnum => 564,
	:Type1 => :WATER,
	:Type2 => :ROCK,
	:BaseStats => [54, 78, 103, 22, 53, 45],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:SOLIDROCK,:STURDY],
	:HiddenAbilities => :SWIFTSWIM,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 71,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7680,
	:EggMoves => [:BIDE,:BODYSLAM,:FLAIL,:GUARDSWAP,:IRONDEFENSE,:KNOCKOFF,:LIQUIDATION,:ROCKTHROW,:SLAM,:WATERPULSE,:WHIRLPOOL],
	:Moveset => [
		[1,:BIDE],
		[1,:WITHDRAW],
		[1,:WATERGUN],
		[5,:ROLLOUT],
		[8,:BITE],
		[11,:PROTECT],
		[15,:AQUAJET],
		[18,:ANCIENTPOWER],
		[21,:CRUNCH],
		[25,:WIDEGUARD],
		[28,:BRINE],
		[31,:SMACKDOWN],
		[35,:CURSE],
		[38,:SHELLSMASH],
		[41,:AQUATAIL],
		[45,:ROCKSLIDE],
		[48,:RAINDANCE],
		[50,:HYDROPUMP]],
	:tmlist => [:KNOCKOFF,:ROCKSMASH,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONDEFENSE,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Blue",
	:EggGroups => [:Water1,:Water3],
	:Height => 7,
	:Weight => 165,
	:kind => "Prototurtle",
	:dexentry => "About 100 million years ago, these Pokémon swam in oceans. It is thought they also went on land to attack prey.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 2,
	:evolutions => [
		[:CARRACOSTA,:Level,37]
	]
},

:CARRACOSTA => {
	:name => "Carracosta",
	:dexnum => 565,
	:Type1 => :WATER,
	:Type2 => :ROCK,
	:BaseStats => [74, 108, 133, 32, 83, 65],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:SOLIDROCK,:STURDY],
	:HiddenAbilities => :SWIFTSWIM,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 173,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7680,
	:Moveset => [
		[1,:BIDE],
		[1,:WITHDRAW],
		[1,:WATERGUN],
		[1,:ROLLOUT],
		[5,:ROLLOUT],
		[8,:BITE],
		[11,:PROTECT],
		[15,:AQUAJET],
		[18,:ANCIENTPOWER],
		[21,:CRUNCH],
		[25,:WIDEGUARD],
		[28,:BRINE],
		[31,:SMACKDOWN],
		[35,:CURSE],
		[40,:SHELLSMASH],
		[45,:AQUATAIL],
		[51,:ROCKSLIDE],
		[56,:RAINDANCE],
		[61,:HYDROPUMP]],
	:tmlist => [:KNOCKOFF,:FOCUSBLAST,:SUPERPOWER,:ROCKSMASH,:LOWKICK,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:IRONHEAD,:IRONDEFENSE,:SURF,:AQUATAIL,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Blue",
	:EggGroups => [:Water1,:Water3],
	:Height => 12,
	:Weight => 810,
	:kind => "Prototurtle",
	:dexentry => "Incredible jaw strength enables them to chew up steel beams and rocks along with their prey.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
},

:ARCHEN => {
	:name => "Archen",
	:dexnum => 566,
	:Type1 => :ROCK,
	:Type2 => :FLYING,
	:BaseStats => [55, 112, 45, 70, 74, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:DEFEATIST],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 71,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7680,
	:EggMoves => [:ALLYSWITCH,:BITE,:DEFOG,:DRAGONPULSE,:EARTHPOWER,:HEADSMASH,:KNOCKOFF,:STEELWING,:SWITCHEROO],
	:Moveset => [
		[1,:QUICKATTACK],
		[1,:LEER],
		[1,:WINGATTACK],
		[5,:ROCKTHROW],
		[8,:DOUBLETEAM],
		[11,:SCARYFACE],
		[15,:PLUCK],
		[18,:ANCIENTPOWER],
		[21,:AGILITY],
		[25,:QUICKGUARD],
		[28,:ACROBATICS],
		[31,:DRAGONBREATH],
		[35,:CRUNCH],
		[38,:ENDEAVOR],
		[41,:UTURN],
		[45,:ROCKSLIDE],
		[48,:DRAGONCLAW],
		[50,:THRASH]],
	:tmlist => [:UTURN,:KNOCKOFF,:TAUNT,:TORMENT,:DRAGONPULSE,:DRAGONCLAW,:ROCKSMASH,:HEATWAVE,:BOUNCE,:AERIALACE,:ACROBATICS,:DEFOG,:ROOST,:TAILWIND,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:ALLYSWITCH,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:STEELWING,:IRONDEFENSE,:AQUATAIL,:CONFIDE,],
	:Color => "Yellow",
	:EggGroups => [:Flying,:Water3],
	:Height => 5,
	:Weight => 95,
	:kind => "First Bird",
	:dexentry => "Revived from a fossil, this Pokémon is thought to be the ancestor of all bird Pokémon.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ARCHEOPS,:Level,37]
	]
},

:ARCHEOPS => {
	:name => "Archeops",
	:dexnum => 567,
	:Type1 => :ROCK,
	:Type2 => :FLYING,
	:BaseStats => [75, 140, 65, 110, 112, 65],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:DEFEATIST],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemEighth",
	:BaseEXP => 177,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7680,
	:Moveset => [
		[1,:QUICKATTACK],
		[1,:LEER],
		[1,:WINGATTACK],
		[1,:ROCKTHROW],
		[5,:ROCKTHROW],
		[8,:DOUBLETEAM],
		[11,:SCARYFACE],
		[15,:PLUCK],
		[18,:ANCIENTPOWER],
		[21,:AGILITY],
		[25,:QUICKGUARD],
		[28,:ACROBATICS],
		[31,:DRAGONBREATH],
		[35,:CRUNCH],
		[40,:ENDEAVOR],
		[45,:UTURN],
		[51,:ROCKSLIDE],
		[56,:DRAGONCLAW],
		[61,:THRASH]],
	:tmlist => [:UTURN,:KNOCKOFF,:TAUNT,:TORMENT,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:FOCUSBLAST,:ROCKSMASH,:HEATWAVE,:SKYATTACK,:FLY,:BOUNCE,:AERIALACE,:ACROBATICS,:DEFOG,:ROOST,:TAILWIND,:SHADOWCLAW,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ZENHEADBUTT,:ALLYSWITCH,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONTAIL,:STEELWING,:IRONDEFENSE,:AQUATAIL,:CONFIDE,],
	:Color => "Yellow",
	:EggGroups => [:Flying,:Water3],
	:Height => 14,
	:Weight => 320,
	:kind => "First Bird",
	:dexentry => "It runs better than it flies. It catches prey by running at speeds comparable to those of an automobile.",
	:BattlerPlayerY => 3,
	:BattlerEnemyY => 5,
	:BattlerAltitude => 1,
},

:TRUBBISH => {
	:name => "Trubbish",
	:dexnum => 568,
	:Type1 => :POISON,
	:BaseStats => [50, 50, 62, 65, 40, 62],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:STENCH,:STICKYHOLD],
	:HiddenAbilities => :AFTERMATH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 66,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AUTOTOMIZE,:CURSE,:HAZE,:MUDSPORT,:ROCKBLAST,:ROLLOUT,:SANDATTACK,:SELFDESTRUCT,:SPIKES],
	:Moveset => [
		[1,:POUND],
		[1,:POISONGAS],
		[3,:RECYCLE],
		[7,:TOXICSPIKES],
		[12,:ACIDSPRAY],
		[14,:DOUBLESLAP],
		[18,:SLUDGE],
		[23,:STOCKPILE],
		[23,:SWALLOW],
		[25,:TAKEDOWN],
		[29,:SLUDGEBOMB],
		[34,:CLEARSMOG],
		[36,:TOXIC],
		[40,:AMNESIA],
		[42,:BELCH],
		[45,:GUNKSHOT],
		[47,:EXPLOSION]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:DRAINPUNCH,:SUNNYDAY,:SPITE,:SEEDBOMB,:GIGADRAIN,:EXPLOSION,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:REST,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Green",
	:EggGroups => [:Mineral],
	:Height => 6,
	:Weight => 310,
	:WildItemUncommon => :SILKSCARF,
	:kind => "Trash Bag",
	:dexentry => "The combination of garbage bags and industrial waste caused the chemical reaction that created this Pokémon.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 35,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GARBODOR,:Level,36]
	]
},

:GARBODOR => {
	:name => "Garbodor",
	:dexnum => 569,
	:Type1 => :POISON,
	:BaseStats => [80, 95, 82, 75, 60, 82],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:STENCH,:WEAKARMOR],
	:HiddenAbilities => :AFTERMATH,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:POUND],
		[1,:POISONGAS],
		[1,:RECYCLE],
		[1,:TOXICSPIKES],
		[3,:RECYCLE],
		[7,:TOXICSPIKES],
		[12,:ACIDSPRAY],
		[14,:DOUBLESLAP],
		[18,:SLUDGE],
		[23,:STOCKPILE],
		[23,:SWALLOW],
		[25,:BODYSLAM],
		[29,:SLUDGEBOMB],
		[34,:CLEARSMOG],
		[39,:TOXIC],
		[46,:AMNESIA],
		[49,:BELCH],
		[54,:GUNKSHOT],
		[59,:EXPLOSION]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:FLING,:THUNDERBOLT,:FOCUSBLAST,:DRAINPUNCH,:SUNNYDAY,:SPITE,:SOLARBEAM,:SEEDBOMB,:GIGADRAIN,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PAINSPLIT,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEWAVE,:SLUDGEBOMB,:VENOSHOCK,:TOXIC,:PSYCHIC,:REST,:SMACKDOWN,:ROCKPOLISH,:RAINDANCE,:CONFIDE,:INFESTATION,:STOMPINGTANTRUM,],
	:Color => "Green",
	:EggGroups => [:Mineral],
	:Height => 19,
	:Weight => 1073,
	:WildItemCommon => :SILKSCARF,
	:WildItemUncommon => :BLACKSLUDGE,
	:kind => "Trash Heap",
	:dexentry => "They absorb garbage and make it part of their bodies. They shoot a poisonous liquid from their right-hand fingertips.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:ZORUA => {
	:name => "Zorua",
	:dexnum => 570,
	:Type1 => :DARK,
	:BaseStats => [40, 65, 40, 65, 80, 40],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:ILLUSION],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 66,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 6400,
	:EggMoves => [:CAPTIVATE,:COPYCAT,:COUNTER,:DARKPULSE,:DETECT,:EXTRASENSORY,:MEMENTO,:SNATCH,:SUCKERPUNCH],
	:Moveset => [
		[1,:SCRATCH],
		[1,:LEER],
		[5,:PURSUIT],
		[9,:FAKETEARS],
		[13,:FURYSWIPES],
		[17,:FEINTATTACK],
		[21,:SCARYFACE],
		[25,:TAUNT],
		[29,:FOULPLAY],
		[33,:TORMENT],
		[37,:AGILITY],
		[41,:EMBARGO],
		[45,:PUNISHMENT],
		[49,:NASTYPLOT],
		[53,:IMPRISON],
		[57,:NIGHTDAZE]],
	:tmlist => [:UTURN,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:SUNNYDAY,:BOUNCE,:AERIALACE,:SHADOWBALL,:SPITE,:GRASSKNOT,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:CALMMIND,:REST,:TRICK,:RAINDANCE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 7,
	:Weight => 125,
	:kind => "Tricky Fox",
	:dexentry => "To protect themselves from danger, they hide their true identities by transforming into people and Pokémon.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ZOROARK,:Level,30]
	]
},

:ZOROARK => {
	:name => "Zoroark",
	:dexnum => 571,
	:Type1 => :DARK,
	:BaseStats => [60, 105, 60, 105, 120, 60],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:ILLUSION],
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemEighth",
	:BaseEXP => 179,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:NIGHTSLASH],
		[1,:NIGHTDAZE],
		[1,:IMPRISON],
		[1,:UTURN],
		[1,:SCRATCH],
		[1,:LEER],
		[1,:PURSUIT],
		[1,:HONECLAWS],
		[5,:PURSUIT],
		[9,:HONECLAWS],
		[13,:FURYSWIPES],
		[17,:FEINTATTACK],
		[21,:SCARYFACE],
		[25,:TAUNT],
		[29,:FOULPLAY],
		[34,:TORMENT],
		[39,:AGILITY],
		[44,:EMBARGO],
		[49,:PUNISHMENT],
		[54,:NASTYPLOT],
		[59,:IMPRISON],
		[64,:NIGHTDAZE]],
	:tmlist => [:UTURN,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:FOCUSBLAST,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FLAMETHROWER,:SUNNYDAY,:BOUNCE,:AERIALACE,:SHADOWBALL,:SHADOWCLAW,:SPITE,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:PSYCHUP,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:CALMMIND,:REST,:TRICK,:RAINDANCE,:CONFIDE,:LASERFOCUS,:THROATCHOP,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 16,
	:Weight => 811,
	:kind => "Illusion Fox",
	:dexentry => "Each has the ability to fool a large group of people simultaneously. They protect their lair with illusory scenery.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:MINCCINO => {
	:name => "Minccino",
	:dexnum => 572,
	:Type1 => :NORMAL,
	:BaseStats => [55, 50, 40, 75, 40, 40],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:CUTECHARM,:TECHNICIAN],
	:HiddenAbilities => :SKILLLINK,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 60,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:AQUATAIL,:ENDURE,:FAKETEARS,:FLAIL,:IRONTAIL,:KNOCKOFF,:MUDSLAP,:SLEEPTALK,:TAILWHIP],
	:Moveset => [
		[1,:POUND],
		[3,:BABYDOLLEYES],
		[7,:HELPINGHAND],
		[9,:TICKLE],
		[13,:DOUBLESLAP],
		[15,:ENCORE],
		[19,:SWIFT],
		[21,:SING],
		[25,:TAILSLAP],
		[27,:CHARM],
		[31,:WAKEUPSLAP],
		[33,:ECHOEDVOICE],
		[37,:SLAM],
		[39,:CAPTIVATE],
		[43,:HYPERVOICE],
		[45,:LASTRESORT],
		[49,:AFTERYOU]],
	:tmlist => [:UTURN,:THIEF,:KNOCKOFF,:FLING,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:SUNNYDAY,:SEEDBOMB,:GRASSKNOT,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:CALMMIND,:REST,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 58,
	:kind => "Chinchilla",
	:dexentry => "These Pokémon prefer a tidy habitat. They are always sweeping and dusting, using their tails as brooms.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:CINCCINO,:Item,:SHINYSTONE]
	]
},

:CINCCINO => {
	:name => "Cinccino",
	:dexnum => 573,
	:Type1 => :NORMAL,
	:BaseStats => [75, 95, 60, 115, 65, 60],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:CUTECHARM,:TECHNICIAN],
	:HiddenAbilities => :SKILLLINK,
	:GrowthRate => "Fast",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 165,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:BULLETSEED],
		[1,:ROCKBLAST],
		[1,:HELPINGHAND],
		[1,:TICKLE],
		[1,:SING],
		[1,:TAILSLAP]],
	:tmlist => [:UTURN,:THIEF,:KNOCKOFF,:FLING,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:THUNDERWAVE,:FOCUSBLAST,:SUNNYDAY,:SEEDBOMB,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:HYPERVOICE,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:GUNKSHOT,:TOXIC,:CALMMIND,:LIGHTSCREEN,:REST,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:DAZZLINGGLEAM,:LASERFOCUS,],
	:Color => "Gray",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 75,
	:kind => "Scarf",
	:dexentry => "Their white fur feels amazing to touch. Their fur repels dust and prevents static electricity from building up.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:GOTHITA => {
	:name => "Gothita",
	:dexnum => 574,
	:Type1 => :PSYCHIC,
	:BaseStats => [45, 30, 50, 45, 55, 65],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:FRISK,:COMPETITIVE],
	:HiddenAbilities => :SHADOWTAG,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 58,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:CAPTIVATE,:DARKPULSE,:HEALPULSE,:MEANLOOK,:MIRACLEEYE,:MIRRORCOAT,:UPROAR],
	:Moveset => [
		[1,:POUND],
		[3,:CONFUSION],
		[7,:TICKLE],
		[8,:PLAYNICE],
		[10,:FAKETEARS],
		[14,:DOUBLESLAP],
		[16,:PSYBEAM],
		[19,:EMBARGO],
		[24,:FEINTATTACK],
		[25,:PSYSHOCK],
		[28,:FLATTER],
		[31,:FUTURESIGHT],
		[33,:HEALBLOCK],
		[37,:PSYCHIC],
		[40,:TELEKINESIS],
		[46,:CHARM],
		[48,:MAGICROOM]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:DARKPULSE,:PAYBACK,:THIEF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:EggGroups => [:HumanLike],
	:Height => 4,
	:Weight => 58,
	:kind => "Fixation",
	:dexentry => "They intently observe both Trainers and Pokémon. Apparently, they are looking at something that only Gothita can see.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 31,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GOTHORITA,:Level,32]
	]
},

:GOTHORITA => {
	:name => "Gothorita",
	:dexnum => 575,
	:Type1 => :PSYCHIC,
	:BaseStats => [60, 45, 70, 55, 75, 85],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:FRISK,:COMPETITIVE],
	:HiddenAbilities => :SHADOWTAG,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 137,
	:CatchRate => 100,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:POUND],
		[1,:CONFUSION],
		[1,:TICKLE],
		[1,:PLAYNICE],
		[3,:CONFUSION],
		[7,:TICKLE],
		[10,:FAKETEARS],
		[14,:DOUBLESLAP],
		[16,:PSYBEAM],
		[19,:EMBARGO],
		[24,:FEINTATTACK],
		[25,:PSYSHOCK],
		[28,:FLATTER],
		[31,:FUTURESIGHT],
		[34,:HEALBLOCK],
		[39,:PSYCHIC],
		[43,:TELEKINESIS],
		[50,:CHARM],
		[53,:MAGICROOM]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:DARKPULSE,:PAYBACK,:THIEF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,],
	:Color => "Purple",
	:EggGroups => [:HumanLike],
	:Height => 7,
	:Weight => 180,
	:kind => "Manipulate",
	:dexentry => "Starlight is the source of their power. At night, they mark star positions by using psychic power to float stones.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 20,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GOTHITELLE,:Level,41]
	]
},

:GOTHITELLE => {
	:name => "Gothitelle",
	:dexnum => 576,
	:Type1 => :PSYCHIC,
	:BaseStats => [70, 55, 95, 65, 95, 110],
	:EVs => [0, 0, 0, 0, 0, 3],
	:Abilities => [:FRISK,:COMPETITIVE],
	:HiddenAbilities => :SHADOWTAG,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "MaleQuarter",
	:BaseEXP => 221,
	:CatchRate => 50,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:POUND],
		[1,:CONFUSION],
		[1,:TICKLE],
		[1,:PLAYNICE],
		[3,:CONFUSION],
		[7,:TICKLE],
		[10,:FAKETEARS],
		[14,:DOUBLESLAP],
		[16,:PSYBEAM],
		[19,:EMBARGO],
		[24,:FEINTATTACK],
		[25,:PSYSHOCK],
		[28,:FLATTER],
		[31,:FUTURESIGHT],
		[34,:HEALBLOCK],
		[39,:PSYCHIC],
		[45,:TELEKINESIS],
		[54,:CHARM],
		[59,:MAGICROOM]],
	:tmlist => [:SIGNALBEAM,:FOULPLAY,:DARKPULSE,:PAYBACK,:THIEF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:BRICKBREAK,:LOWSWEEP,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:COVET,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HEALBELL,:HELPINGHAND,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:MAGICROOM,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Purple",
	:EggGroups => [:HumanLike],
	:Height => 15,
	:Weight => 440,
	:kind => "Astral Body",
	:dexentry => "They can predict the future from the placement and movement of the stars. They can see Trainers' life spans.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:SOLOSIS => {
	:name => "Solosis",
	:dexnum => 577,
	:Type1 => :PSYCHIC,
	:BaseStats => [45, 30, 40, 20, 105, 50],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:OVERCOAT,:MAGICGUARD],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 58,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ACIDARMOR,:ASTONISH,:CONFUSERAY,:HELPINGHAND,:IMPRISON,:NIGHTSHADE,:SECRETPOWER,:TRICK],
	:Moveset => [
		[1,:PSYWAVE],
		[3,:REFLECT],
		[7,:ROLLOUT],
		[10,:SNATCH],
		[14,:HIDDENPOWER],
		[16,:LIGHTSCREEN],
		[19,:CHARM],
		[24,:RECOVER],
		[25,:PSYSHOCK],
		[28,:ENDEAVOR],
		[31,:FUTURESIGHT],
		[33,:PAINSPLIT],
		[37,:PSYCHIC],
		[40,:SKILLSWAP],
		[46,:HEALBLOCK],
		[48,:WONDERROOM]],
	:tmlist => [:SIGNALBEAM,:EMBARGO,:SNATCH,:THUNDER,:SHOCKWAVE,:THUNDERWAVE,:SHADOWBALL,:ENERGYBALL,:EXPLOSION,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Green",
	:EggGroups => [:Amorphous],
	:Height => 3,
	:Weight => 10,
	:kind => "Cell",
	:dexentry => "Because their bodies are enveloped in a special liquid, they can survive in any environment.",
	:BattlerPlayerY => 34,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 5,
	:evolutions => [
		[:DUOSION,:Level,32]
	]
},

:DUOSION => {
	:name => "Duosion",
	:dexnum => 578,
	:Type1 => :PSYCHIC,
	:BaseStats => [65, 40, 50, 30, 125, 60],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:OVERCOAT,:MAGICGUARD],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 130,
	:CatchRate => 100,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:PSYWAVE],
		[1,:REFLECT],
		[1,:ROLLOUT],
		[1,:SNATCH],
		[3,:REFLECT],
		[7,:ROLLOUT],
		[10,:SNATCH],
		[14,:HIDDENPOWER],
		[16,:LIGHTSCREEN],
		[19,:CHARM],
		[24,:RECOVER],
		[25,:PSYSHOCK],
		[28,:ENDEAVOR],
		[31,:FUTURESIGHT],
		[34,:PAINSPLIT],
		[39,:PSYCHIC],
		[43,:SKILLSWAP],
		[50,:HEALBLOCK],
		[53,:WONDERROOM]],
	:tmlist => [:SIGNALBEAM,:EMBARGO,:SNATCH,:THUNDER,:SHOCKWAVE,:THUNDERWAVE,:SHADOWBALL,:ENERGYBALL,:EXPLOSION,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Green",
	:EggGroups => [:Amorphous],
	:Height => 6,
	:Weight => 80,
	:kind => "Mitosis",
	:dexentry => "When their brains, now divided in two, are thinking the same thoughts, these Pokémon exhibit their maximum power.",
	:BattlerPlayerY => 27,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 5,
	:evolutions => [
		[:REUNICLUS,:Level,41]
	]
},

:REUNICLUS => {
	:name => "Reuniclus",
	:dexnum => 579,
	:Type1 => :PSYCHIC,
	:BaseStats => [110, 65, 75, 30, 125, 85],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:OVERCOAT,:MAGICGUARD],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 221,
	:CatchRate => 50,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:DIZZYPUNCH],
		[1,:PSYWAVE],
		[1,:REFLECT],
		[1,:ROLLOUT],
		[1,:SNATCH],
		[3,:REFLECT],
		[7,:ROLLOUT],
		[10,:SNATCH],
		[14,:HIDDENPOWER],
		[16,:LIGHTSCREEN],
		[19,:CHARM],
		[24,:RECOVER],
		[25,:PSYSHOCK],
		[28,:ENDEAVOR],
		[31,:FUTURESIGHT],
		[34,:PAINSPLIT],
		[39,:PSYCHIC],
		[45,:SKILLSWAP],
		[54,:HEALBLOCK],
		[59,:WONDERROOM]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:THUNDER,:THUNDERPUNCH,:SHOCKWAVE,:THUNDERWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:DRAINPUNCH,:ROCKSMASH,:FIREPUNCH,:SHADOWBALL,:ENERGYBALL,:GRASSKNOT,:ICEPUNCH,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:INFESTATION,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Green",
	:EggGroups => [:Amorphous],
	:Height => 10,
	:Weight => 201,
	:kind => "Multiplying",
	:dexentry => "These remarkably intelligent Pokémon fight by controlling arms that can grip with rock-crushing power.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 10,
},

:DUCKLETT => {
	:name => "Ducklett",
	:dexnum => 580,
	:Type1 => :WATER,
	:Type2 => :FLYING,
	:BaseStats => [62, 44, 50, 55, 44, 50],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:KEENEYE,:BIGPECKS],
	:HiddenAbilities => :HYDRATION,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AIRCUTTER,:AQUAJET,:BRINE,:GUST,:LUCKYCHANT,:MEFIRST,:MIRRORMOVE,:MUDSPORT,:STEELWING],
	:Moveset => [
		[1,:WATERGUN],
		[3,:WATERSPORT],
		[6,:DEFOG],
		[9,:WINGATTACK],
		[13,:WATERPULSE],
		[15,:AERIALACE],
		[19,:BUBBLEBEAM],
		[21,:FEATHERDANCE],
		[24,:AQUARING],
		[27,:AIRSLASH],
		[30,:ROOST],
		[34,:RAINDANCE],
		[37,:TAILWIND],
		[41,:BRAVEBIRD],
		[46,:HURRICANE]],
	:tmlist => [:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:ICEBEAM,:ICYWIND,:HAIL,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STEELWING,:SURF,:DIVE,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Blue",
	:EggGroups => [:Water1,:Flying],
	:Height => 5,
	:Weight => 55,
	:kind => "Water Bird",
	:dexentry => "When attacked, it uses its feathers to splash water, escaping under cover of the spray.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 31,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SWANNA,:Level,35]
	]
},

:SWANNA => {
	:name => "Swanna",
	:dexnum => 581,
	:Type1 => :WATER,
	:Type2 => :FLYING,
	:BaseStats => [75, 87, 63, 98, 87, 63],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:KEENEYE,:BIGPECKS],
	:HiddenAbilities => :HYDRATION,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:WATERGUN],
		[1,:WATERSPORT],
		[1,:DEFOG],
		[1,:WINGATTACK],
		[3,:WATERSPORT],
		[6,:DEFOG],
		[9,:WINGATTACK],
		[13,:WATERPULSE],
		[15,:AERIALACE],
		[19,:BUBBLEBEAM],
		[21,:FEATHERDANCE],
		[24,:AQUARING],
		[27,:AIRSLASH],
		[30,:ROOST],
		[34,:RAINDANCE],
		[40,:TAILWIND],
		[47,:BRAVEBIRD],
		[55,:HURRICANE]],
	:tmlist => [:SKYATTACK,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:STEELWING,:SURF,:DIVE,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "White",
	:EggGroups => [:Water1,:Flying],
	:Height => 13,
	:Weight => 242,
	:kind => "White Bird",
	:dexentry => "It administers sharp, powerful pecks with its bill. It whips its long neck to deliver forceful repeated strikes.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 0,
},

:VANILLITE => {
	:name => "Vanillite",
	:dexnum => 582,
	:Type1 => :ICE,
	:BaseStats => [36, 50, 50, 44, 65, 60],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:ICEBODY,:SNOWCLOAK],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AUTOTOMIZE,:ICESHARD,:IMPRISON,:IRONDEFENSE,:MAGNETRISE,:NATURALGIFT,:POWDERSNOW,:WATERPULSE],
	:Moveset => [
		[1,:ICICLESPEAR],
		[4,:HARDEN],
		[7,:ASTONISH],
		[10,:UPROAR],
		[13,:ICYWIND],
		[16,:MIST],
		[19,:AVALANCHE],
		[22,:TAUNT],
		[26,:MIRRORSHOT],
		[31,:ACIDARMOR],
		[35,:ICEBEAM],
		[40,:HAIL],
		[44,:MIRRORCOAT],
		[49,:BLIZZARD],
		[53,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:TAUNT,:MAGNETRISE,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:EXPLOSION,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:LIGHTSCREEN,:MAGICCOAT,:REST,:FLASHCANNON,:IRONDEFENSE,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Mineral],
	:Height => 4,
	:Weight => 57,
	:WildItemUncommon => :NEVERMELTICE,
	:kind => "Fresh Snow",
	:dexentry => "This Pokémon formed from icicles bathed in energy from the morning sun. It sleeps buried in snow.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 32,
	:BattlerAltitude => 0,
	:evolutions => [
		[:VANILLISH,:Level,35]
	]
},

:VANILLISH => {
	:name => "Vanillish",
	:dexnum => 583,
	:Type1 => :ICE,
	:BaseStats => [51, 65, 65, 59, 80, 75],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:ICEBODY,:SNOWCLOAK],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 138,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:ICICLESPEAR],
		[1,:HARDEN],
		[1,:ASTONISH],
		[1,:UPROAR],
		[4,:HARDEN],
		[7,:ASTONISH],
		[10,:UPROAR],
		[13,:ICYWIND],
		[16,:MIST],
		[19,:AVALANCHE],
		[22,:TAUNT],
		[26,:MIRRORSHOT],
		[31,:ACIDARMOR],
		[36,:ICEBEAM],
		[42,:HAIL],
		[47,:MIRRORCOAT],
		[53,:BLIZZARD],
		[58,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:TAUNT,:MAGNETRISE,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:EXPLOSION,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:LIGHTSCREEN,:MAGICCOAT,:REST,:FLASHCANNON,:IRONDEFENSE,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Mineral],
	:Height => 11,
	:Weight => 410,
	:WildItemUncommon => :NEVERMELTICE,
	:kind => "Icy Snow",
	:dexentry => "It conceals itself from enemy eyes by creating many small ice particles and hiding among them.",
	:BattlerPlayerY => 21,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 2,
	:evolutions => [
		[:VANILLUXE,:Level,47]
	]
},

:VANILLUXE => {
	:name => "Vanilluxe",
	:dexnum => 584,
	:Type1 => :ICE,
	:BaseStats => [71, 95, 85, 79, 110, 95],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:ICEBODY,:SNOWWARNING],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 241,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:SHEERCOLD],
		[1,:FREEZEDRY],
		[1,:WEATHERBALL],
		[1,:ICICLESPEAR],
		[1,:HARDEN],
		[1,:ASTONISH],
		[1,:UPROAR],
		[4,:HARDEN],
		[7,:ASTONISH],
		[10,:UPROAR],
		[13,:ICYWIND],
		[16,:MIST],
		[19,:AVALANCHE],
		[22,:TAUNT],
		[26,:MIRRORSHOT],
		[31,:ACIDARMOR],
		[36,:ICEBEAM],
		[42,:HAIL],
		[50,:MIRRORCOAT],
		[59,:BLIZZARD],
		[67,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:TAUNT,:MAGNETRISE,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:LIGHTSCREEN,:MAGICCOAT,:REST,:FLASHCANNON,:IRONDEFENSE,:WATERPULSE,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Mineral],
	:Height => 13,
	:Weight => 575,
	:WildItemUncommon => :NEVERMELTICE,
	:kind => "Snowstorm",
	:dexentry => "If both heads get angry simultaneously, this Pokémon expels a blizzard, burying everything in snow.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 7,
},

:DEERLING => {
	:name => "Deerling",
	:dexnum => 585,
	:Type1 => :NORMAL,
	:Type2 => :GRASS,
	:BaseStats => [60, 60, 50, 75, 40, 50],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:CHLOROPHYLL,:SAPSIPPER],
	:HiddenAbilities => :SERENEGRACE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 67,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AGILITY,:BATONPASS,:FAKETEARS,:GRASSWHISTLE,:HEADBUTT,:NATURALGIFT,:ODORSLEUTH,:SLEEPTALK,:SYNTHESIS,:WORRYSEED],
	:Moveset => [
		[1,:TACKLE],
		[1,:CAMOUFLAGE],
		[4,:GROWL],
		[7,:SANDATTACK],
		[10,:DOUBLEKICK],
		[13,:LEECHSEED],
		[16,:FEINTATTACK],
		[20,:TAKEDOWN],
		[24,:JUMPKICK],
		[28,:AROMATHERAPY],
		[32,:ENERGYBALL],
		[36,:CHARM],
		[41,:NATUREPOWER],
		[46,:DOUBLEEDGE],
		[51,:SOLARBEAM]],
	:tmlist => [:WILDCHARGE,:THUNDERWAVE,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:LASTRESORT,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:LIGHTSCREEN,:REST,:RAINDANCE,:CONFIDE,],
	:Color => "Yellow",
	:EggGroups => [:Field],
	:Height => 6,
	:Weight => 195,
	:kind => "Season",
	:dexentry => "The turning of the seasons changes the color and scent of this Pokémon's fur. People use it to mark the seasons.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 30,
	:BattlerAltitude => 0,
	:evolutions => [
		[:SAWSBUCK,:Level,34]
	]
},

:SAWSBUCK => {
	:name => "Sawsbuck",
	:dexnum => 586,
	:Type1 => :NORMAL,
	:Type2 => :GRASS,
	:BaseStats => [80, 100, 70, 95, 60, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:CHLOROPHYLL,:SAPSIPPER],
	:HiddenAbilities => :SERENEGRACE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 166,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:HORNLEECH],
		[1,:MEGAHORN],
		[1,:TACKLE],
		[1,:CAMOUFLAGE],
		[1,:GROWL],
		[1,:SANDATTACK],
		[4,:GROWL],
		[7,:SANDATTACK],
		[10,:DOUBLEKICK],
		[13,:LEECHSEED],
		[16,:FEINTATTACK],
		[20,:TAKEDOWN],
		[24,:JUMPKICK],
		[28,:AROMATHERAPY],
		[32,:ENERGYBALL],
		[36,:CHARM],
		[44,:NATUREPOWER],
		[52,:DOUBLEEDGE],
		[60,:SOLARBEAM]],
	:tmlist => [:WILDCHARGE,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:BOUNCE,:SHADOWBALL,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:LASTRESORT,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:TOXIC,:LIGHTSCREEN,:REST,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 19,
	:Weight => 925,
	:kind => "Season",
	:dexentry => "The plants growing on its horns change according to the season. The leaders of the herd possess magnificent horns.",
	:BattlerPlayerY => 10,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:EMOLGA => {
	:name => "Emolga",
	:dexnum => 587,
	:Type1 => :ELECTRIC,
	:Type2 => :FLYING,
	:BaseStats => [55, 75, 60, 103, 75, 60],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:STATIC,:MOTORDRIVE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 150,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AIRSLASH,:ASTONISH,:BATONPASS,:CHARM,:COVET,:IONDELUGE,:IRONTAIL,:ROOST,:SHOCKWAVE,:TICKLE,:SPEEDSWAP],
	:Moveset => [
		[1,:THUNDERSHOCK],
		[4,:QUICKATTACK],
		[7,:TAILWHIP],
		[10,:CHARGE],
		[13,:SPARK],
		[15,:NUZZLE],
		[16,:PURSUIT],
		[19,:DOUBLETEAM],
		[22,:SHOCKWAVE],
		[26,:ELECTROBALL],
		[30,:ACROBATICS],
		[34,:LIGHTSCREEN],
		[38,:ENCORE],
		[42,:VOLTSWITCH],
		[46,:AGILITY],
		[50,:DISCHARGE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:KNOCKOFF,:FLING,:TAUNT,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:THUNDERWAVE,:AERIALACE,:ACROBATICS,:DEFOG,:ROOST,:TAILWIND,:LASTRESORT,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:HELPINGHAND,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Field],
	:Height => 4,
	:Weight => 50,
	:kind => "Sky Squirrel",
	:dexentry => "They live on treetops and glide using the inside of a cape-like membrane while discharging electricity.",
	:BattlerPlayerY => 28,
	:BattlerEnemyY => 26,
	:BattlerAltitude => 10,
},

:KARRABLAST => {
	:name => "Karrablast",
	:dexnum => 588,
	:Type1 => :BUG,
	:BaseStats => [50, 75, 45, 60, 40, 45],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SWARM,:SHEDSKIN],
	:HiddenAbilities => :NOGUARD,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 63,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:BUGBITE,:COUNTER,:DRILLRUN,:FEINTATTACK,:HORNATTACK,:KNOCKOFF,:MEGAHORN,:PURSUIT,:SCREECH],
	:Moveset => [
		[1,:PECK],
		[4,:LEER],
		[8,:ENDURE],
		[13,:FURYCUTTER],
		[16,:FURYATTACK],
		[20,:HEADBUTT],
		[25,:FALSESWIPE],
		[28,:BUGBUZZ],
		[32,:SLASH],
		[37,:TAKEDOWN],
		[40,:SCARYFACE],
		[44,:XSCISSOR],
		[49,:FLAIL],
		[52,:SWORDSDANCE],
		[56,:DOUBLEEDGE]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:KNOCKOFF,:AERIALACE,:ENERGYBALL,:GIGADRAIN,:DRILLRUN,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Blue",
	:EggGroups => [:Bug],
	:Height => 5,
	:Weight => 59,
	:kind => "Clamping",
	:dexentry => "When they feel threatened, they spit an acidic liquid to drive attackers away. This Pokémon targets Shelmet.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 34,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ESCAVALIER,:Trade,0]
	]
},

:ESCAVALIER => {
	:name => "Escavalier",
	:dexnum => 589,
	:Type1 => :BUG,
	:Type2 => :STEEL,
	:BaseStats => [70, 135, 105, 20, 60, 105],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SWARM,:SHELLARMOR],
	:HiddenAbilities => :OVERCOAT,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 173,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:DOUBLEEDGE],
		[1,:FELLSTINGER],
		[1,:PECK],
		[1,:LEER],
		[1,:QUICKGUARD],
		[1,:TWINEEDLE],
		[4,:LEER],
		[8,:QUICKGUARD],
		[13,:TWINEEDLE],
		[16,:FURYATTACK],
		[20,:HEADBUTT],
		[25,:FALSESWIPE],
		[28,:BUGBUZZ],
		[32,:SLASH],
		[37,:IRONHEAD],
		[40,:IRONDEFENSE],
		[44,:XSCISSOR],
		[49,:REVERSAL],
		[52,:SWORDSDANCE],
		[56,:GIGAIMPACT],
		[60,:FELLSTINGER]],
	:tmlist => [:XSCISSOR,:BUGBITE,:STRUGGLEBUG,:KNOCKOFF,:FOCUSBLAST,:ROCKSMASH,:AERIALACE,:ENERGYBALL,:GIGADRAIN,:DRILLRUN,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:INFESTATION,:BRUTALSWING,:LASERFOCUS,:SMARTSTRIKE,],
	:Color => "Gray",
	:EggGroups => [:Bug],
	:Height => 10,
	:Weight => 330,
	:kind => "Cavalry",
	:dexentry => "These Pokémon evolve by wearing the shell covering of a Shelmet. The steel armor protects their whole body.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 6,
	:BattlerAltitude => 5,
},

:FOONGUS => {
	:name => "Foongus",
	:dexnum => 590,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [69, 55, 45, 15, 55, 55],
	:EVs => [1, 0, 0, 0, 0, 0],
	:Abilities => [:EFFECTSPORE,:REGENERATOR],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 59,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:BODYSLAM,:DEFENSECURL,:ENDURE,:GASTROACID,:GROWTH,:POISONPOWDER,:ROLLOUT,:STUNSPORE],
	:Moveset => [
		[1,:ABSORB],
		[6,:GROWTH],
		[8,:ASTONISH],
		[12,:BIDE],
		[15,:MEGADRAIN],
		[18,:INGRAIN],
		[20,:FEINTATTACK],
		[24,:SWEETSCENT],
		[28,:GIGADRAIN],
		[32,:TOXIC],
		[35,:SYNTHESIS],
		[39,:CLEARSMOG],
		[43,:SOLARBEAM],
		[45,:RAGEPOWDER],
		[50,:SPORE]],
	:tmlist => [:FOULPLAY,:PAYBACK,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Grass],
	:Height => 2,
	:Weight => 10,
	:WildItemCommon => :TINYMUSHROOM,
	:WildItemUncommon => :BIGMUSHROOM,
	:kind => "Mushroom",
	:dexentry => "For some reason, this Pokémon resembles a Poké Ball. They release poison spores to repel those who try to catch them.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 36,
	:BattlerAltitude => 0,
	:evolutions => [
		[:AMOONGUSS,:Level,39]
	]
},

:AMOONGUSS => {
	:name => "Amoonguss",
	:dexnum => 591,
	:Type1 => :GRASS,
	:Type2 => :POISON,
	:BaseStats => [114, 85, 70, 30, 85, 80],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:EFFECTSPORE,:REGENERATOR],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 162,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:ABSORB],
		[1,:GROWTH],
		[1,:ASTONISH],
		[1,:BIDE],
		[6,:GROWTH],
		[8,:ASTONISH],
		[12,:BIDE],
		[15,:MEGADRAIN],
		[18,:INGRAIN],
		[20,:FEINTATTACK],
		[24,:SWEETSCENT],
		[28,:GIGADRAIN],
		[32,:TOXIC],
		[35,:SYNTHESIS],
		[43,:CLEARSMOG],
		[49,:SOLARBEAM],
		[54,:RAGEPOWDER],
		[62,:SPORE]],
	:tmlist => [:FOULPLAY,:PAYBACK,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:SYNTHESIS,:WORRYSEED,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "White",
	:EggGroups => [:Grass],
	:Height => 6,
	:Weight => 105,
	:WildItemCommon => :TINYMUSHROOM,
	:WildItemUncommon => :BIGMUSHROOM,
	:kind => "Mushroom",
	:dexentry => "They show off their Poké Ball caps to lure prey, but very few Pokémon are fooled by this.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 0,
},

:FRILLISH => {
	:name => "Frillish",
	:dexnum => 592,
	:Type1 => :WATER,
	:Type2 => :GHOST,
	:BaseStats => [55, 40, 50, 40, 65, 85],
	:EVs => [0, 0, 0, 0, 0, 1],
	:Abilities => [:WATERABSORB,:CURSEDBODY],
	:HiddenAbilities => :DAMP,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 67,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ACIDARMOR,:CONFUSERAY,:CONSTRICT,:MIST,:PAINSPLIT,:RECOVER],
	:Moveset => [
		[1,:BUBBLE],
		[1,:WATERSPORT],
		[5,:ABSORB],
		[9,:NIGHTSHADE],
		[13,:BUBBLEBEAM],
		[17,:RECOVER],
		[22,:WATERPULSE],
		[27,:OMINOUSWIND],
		[32,:BRINE],
		[37,:RAINDANCE],
		[43,:HEX],
		[49,:HYDROPUMP],
		[55,:WRINGOUT],
		[61,:WATERSPOUT]],
	:tmlist => [:DARKPULSE,:TAUNT,:SHOCKWAVE,:WILLOWISP,:SHADOWBALL,:SPITE,:ENERGYBALL,:GIGADRAIN,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:DREAMEATER,:PSYCHIC,:MAGICCOAT,:REST,:TRICK,:TRICKROOM,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:DAZZLINGGLEAM,],
	:Color => "White",
	:EggGroups => [:Amorphous],
	:Height => 12,
	:Weight => 330,
	:kind => "Floating",
	:dexentry => "They paralyze prey with poison, then drag them down to their lairs, five miles below the surface.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 12,
	:BattlerAltitude => 3,
	:evolutions => [
		[:JELLICENT,:Level,40]
	]
},

:JELLICENT => {
	:name => "Jellicent",
	:dexnum => 593,
	:Type1 => :WATER,
	:Type2 => :GHOST,
	:BaseStats => [100, 60, 70, 60, 85, 105],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:WATERABSORB,:CURSEDBODY],
	:HiddenAbilities => :DAMP,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 168,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:WATERSPOUT],
		[1,:WRINGOUT],
		[1,:BUBBLE],
		[1,:WATERSPORT],
		[1,:ABSORB],
		[1,:NIGHTSHADE],
		[5,:ABSORB],
		[9,:NIGHTSHADE],
		[13,:BUBBLEBEAM],
		[17,:RECOVER],
		[22,:WATERPULSE],
		[27,:OMINOUSWIND],
		[32,:BRINE],
		[37,:RAINDANCE],
		[45,:HEX],
		[53,:HYDROPUMP],
		[61,:WRINGOUT],
		[69,:WATERSPOUT]],
	:tmlist => [:DARKPULSE,:TAUNT,:SHOCKWAVE,:WILLOWISP,:SHADOWBALL,:SPITE,:ENERGYBALL,:GIGADRAIN,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:DREAMEATER,:PSYCHIC,:MAGICCOAT,:REST,:TRICK,:TRICKROOM,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:DAZZLINGGLEAM,],
	:Color => "White",
	:EggGroups => [:Amorphous],
	:Height => 22,
	:Weight => 1350,
	:kind => "Floating",
	:dexentry => "They propel themselves by expelling absorbed seawater from their bodies. Their favorite food is life energy.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 9,
	:BattlerAltitude => 5,
},

:ALOMOMOLA => {
	:name => "Alomomola",
	:dexnum => 594,
	:Type1 => :WATER,
	:BaseStats => [165, 75, 80, 65, 40, 45],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:HEALER,:HYDRATION],
	:HiddenAbilities => :REGENERATOR,
	:GrowthRate => "Fast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 165,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 10240,
	:EggMoves => [:ENDURE,:MIRRORCOAT,:MIST,:PAINSPLIT,:REFRESH,:TICKLE],
	:Moveset => [
		[1,:PLAYNICE],
		[1,:HYDROPUMP],
		[1,:WIDEGUARD],
		[1,:HEALINGWISH],
		[1,:HELPINGHAND],
		[1,:POUND],
		[1,:WATERSPORT],
		[5,:AQUARING],
		[9,:AQUAJET],
		[13,:DOUBLESLAP],
		[17,:HEALPULSE],
		[21,:PROTECT],
		[25,:WATERPULSE],
		[29,:WAKEUPSLAP],
		[33,:SOAK],
		[37,:WISH],
		[41,:BRINE],
		[45,:SAFEGUARD],
		[49,:WHIRLPOOL],
		[53,:HELPINGHAND],
		[57,:HEALINGWISH],
		[61,:WIDEGUARD],
		[65,:HYDROPUMP]],
	:tmlist => [:KNOCKOFF,:BOUNCE,:SHADOWBALL,:BLIZZARD,:ICEBEAM,:ICYWIND,:HAIL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:CALMMIND,:LIGHTSCREEN,:MAGICCOAT,:REST,:SURF,:DIVE,:SCALD,:WATERFALL,:WATERPULSE,:RAINDANCE,:CONFIDE,:LIQUIDATION,],
	:Color => "Pink",
	:EggGroups => [:Water1,:Water2],
	:Height => 12,
	:Weight => 316,
	:kind => "Caring",
	:dexentry => "Floating in the open sea is how they live. When they find a wounded Pokémon, they embrace it and bring it to shore.",
	:BattlerPlayerY => 9,
	:BattlerEnemyY => 2,
	:BattlerAltitude => 0,
},

:JOLTIK => {
	:name => "Joltik",
	:dexnum => 595,
	:Type1 => :BUG,
	:Type2 => :ELECTRIC,
	:BaseStats => [50, 47, 50, 65, 57, 50],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:COMPOUNDEYES,:UNNERVE],
	:HiddenAbilities => :SWARM,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 64,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:CAMOUFLAGE,:CROSSPOISON,:DISABLE,:FEINTATTACK,:LUNGE,:PINMISSILE,:POISONSTING,:PURSUIT,:ROCKCLIMB],
	:Moveset => [
		[1,:STRINGSHOT],
		[1,:ABSORB],
		[1,:SPIDERWEB],
		[4,:THUNDERWAVE],
		[7,:SCREECH],
		[12,:FURYCUTTER],
		[15,:ELECTROWEB],
		[18,:BUGBITE],
		[23,:GASTROACID],
		[26,:SLASH],
		[29,:ELECTROBALL],
		[34,:SIGNALBEAM],
		[37,:AGILITY],
		[40,:SUCKERPUNCH],
		[45,:DISCHARGE],
		[48,:BUGBUZZ]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:THIEF,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:BOUNCE,:ENERGYBALL,:GIGADRAIN,:ROCKCLIMB,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:GASTROACID,:TOXIC,:LIGHTSCREEN,:REST,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Yellow",
	:EggGroups => [:Bug],
	:Height => 1,
	:Weight => 6,
	:kind => "Attaching",
	:dexentry => "They attach themselves to large-bodied Pokémon and absorb static electricity, which they store in an electric pouch.",
	:BattlerPlayerY => 33,
	:BattlerEnemyY => 37,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GALVANTULA,:Level,36]
	]
},

:GALVANTULA => {
	:name => "Galvantula",
	:dexnum => 596,
	:Type1 => :BUG,
	:Type2 => :ELECTRIC,
	:BaseStats => [70, 77, 60, 108, 97, 60],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:COMPOUNDEYES,:UNNERVE],
	:HiddenAbilities => :SWARM,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 165,
	:CatchRate => 70,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:STICKYWEB],
		[1,:STRINGSHOT],
		[1,:ABSORB],
		[1,:SPIDERWEB],
		[1,:THUNDERWAVE],
		[4,:THUNDERWAVE],
		[7,:SCREECH],
		[12,:FURYCUTTER],
		[15,:ELECTROWEB],
		[18,:BUGBITE],
		[23,:GASTROACID],
		[26,:SLASH],
		[29,:ELECTROBALL],
		[34,:SIGNALBEAM],
		[40,:AGILITY],
		[46,:SUCKERPUNCH],
		[54,:DISCHARGE],
		[60,:BUGBUZZ]],
	:tmlist => [:XSCISSOR,:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:THIEF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:ELECTROWEB,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:BOUNCE,:ENERGYBALL,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:GASTROACID,:TOXIC,:LIGHTSCREEN,:REST,:RAINDANCE,:CONFIDE,:INFESTATION,:THROATCHOP,],
	:Color => "Yellow",
	:EggGroups => [:Bug],
	:Height => 8,
	:Weight => 143,
	:kind => "Elespider",
	:dexentry => "They employ an electrically charged web to trap their prey. While it is immobilized by shock, they leisurely consume it.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 38,
	:BattlerAltitude => 0,
},

:FERROSEED => {
	:name => "Ferroseed",
	:dexnum => 597,
	:Type1 => :GRASS,
	:Type2 => :STEEL,
	:BaseStats => [44, 50, 91, 10, 24, 86],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:IRONBARBS],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ACIDSPRAY,:BULLETSEED,:GRAVITY,:LEECHSEED,:ROCKCLIMB,:SEEDBOMB,:SPIKES,:STEALTHROCK,:WORRYSEED],
	:Moveset => [
		[1,:TACKLE],
		[1,:HARDEN],
		[6,:ROLLOUT],
		[9,:CURSE],
		[14,:METALCLAW],
		[18,:PINMISSILE],
		[21,:GYROBALL],
		[26,:IRONDEFENSE],
		[30,:MIRRORSHOT],
		[35,:INGRAIN],
		[38,:SELFDESTRUCT],
		[43,:IRONHEAD],
		[47,:PAYBACK],
		[52,:FLASHCANNON],
		[55,:EXPLOSION]],
	:tmlist => [:PAYBACK,:THUNDERBOLT,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:WORRYSEED,:EXPLOSION,:ROCKCLIMB,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:GRAVITY,:REST,:ROCKPOLISH,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:GYROBALL,:IRONDEFENSE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Grass,:Mineral],
	:Height => 6,
	:Weight => 188,
	:WildItemUncommon => :STICKYBARB,
	:kind => "Thorn Seed",
	:dexentry => "They stick their spikes into cave walls and absorb the minerals they find in the rock.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 35,
	:BattlerAltitude => 0,
	:evolutions => [
		[:FERROTHORN,:Level,40]
	]
},

:FERROTHORN => {
	:name => "Ferrothorn",
	:dexnum => 598,
	:Type1 => :GRASS,
	:Type2 => :STEEL,
	:BaseStats => [74, 94, 131, 20, 54, 116],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:IRONBARBS,:ANTICIPATION],
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 171,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:POWERWHIP],
		[1,:ROCKCLIMB],
		[1,:TACKLE],
		[1,:HARDEN],
		[1,:ROLLOUT],
		[1,:CURSE],
		[6,:ROLLOUT],
		[9,:CURSE],
		[14,:METALCLAW],
		[18,:PINMISSILE],
		[21,:GYROBALL],
		[26,:IRONDEFENSE],
		[30,:MIRRORSHOT],
		[35,:INGRAIN],
		[38,:SELFDESTRUCT],
		[46,:IRONHEAD],
		[53,:PAYBACK],
		[61,:FLASHCANNON],
		[67,:EXPLOSION]],
	:tmlist => [:PAYBACK,:KNOCKOFF,:THUNDER,:THUNDERBOLT,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:SOLARBEAM,:ENERGYBALL,:SEEDBOMB,:GIGADRAIN,:GRASSKNOT,:WORRYSEED,:BULLDOZE,:EXPLOSION,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:FLASH,:NATUREPOWER,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:GRAVITY,:REST,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:FLASHCANNON,:IRONHEAD,:GYROBALL,:IRONDEFENSE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Grass,:Mineral],
	:Height => 10,
	:Weight => 1100,
	:WildItemUncommon => :STICKYBARB,
	:kind => "Thorn Pod",
	:dexentry => "They attach themselves to cave ceilings, firing steel spikes at targets passing beneath them.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 1,
},

:KLINK => {
	:name => "Klink",
	:dexnum => 599,
	:Type1 => :STEEL,
	:BaseStats => [40, 55, 70, 30, 45, 60],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:PLUS,:MINUS],
	:HiddenAbilities => :CLEARBODY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "Genderless",
	:BaseEXP => 60,
	:CatchRate => 130,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:VICEGRIP],
		[6,:CHARGE],
		[11,:THUNDERSHOCK],
		[16,:GEARGRIND],
		[21,:BIND],
		[26,:CHARGEBEAM],
		[31,:AUTOTOMIZE],
		[36,:MIRRORSHOT],
		[39,:SCREECH],
		[42,:DISCHARGE],
		[45,:METALSOUND],
		[48,:SHIFTGEAR],
		[50,:LOCKON],
		[54,:ZAPCANNON],
		[57,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:GRAVITY,:MAGICCOAT,:REST,:TELEKINESIS,:ROCKPOLISH,:SANDSTORM,:FLASHCANNON,:IRONDEFENSE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Mineral],
	:Height => 3,
	:Weight => 210,
	:kind => "Gear",
	:dexentry => "Interlocking two bodies and spinning around generates the energy they need to live.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 10,
	:evolutions => [
		[:KLANG,:Level,38]
	]
},

:KLANG => {
	:name => "Klang",
	:dexnum => 600,
	:Type1 => :STEEL,
	:BaseStats => [60, 80, 95, 50, 70, 85],
	:EVs => [0, 0, 2, 0, 0, 0],
	:Abilities => [:PLUS,:MINUS],
	:HiddenAbilities => :CLEARBODY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "Genderless",
	:BaseEXP => 154,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:VICEGRIP],
		[1,:CHARGE],
		[1,:THUNDERSHOCK],
		[1,:GEARGRIND],
		[6,:CHARGE],
		[11,:THUNDERSHOCK],
		[16,:GEARGRIND],
		[21,:BIND],
		[26,:CHARGEBEAM],
		[31,:AUTOTOMIZE],
		[36,:MIRRORSHOT],
		[40,:SCREECH],
		[44,:DISCHARGE],
		[48,:METALSOUND],
		[52,:SHIFTGEAR],
		[56,:LOCKON],
		[60,:ZAPCANNON],
		[64,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:GRAVITY,:MAGICCOAT,:REST,:TELEKINESIS,:ROCKPOLISH,:SANDSTORM,:FLASHCANNON,:IRONDEFENSE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Mineral],
	:Height => 6,
	:Weight => 510,
	:kind => "Gear",
	:dexentry => "Spinning minigears are rotated at high speed and repeatedly fired away. It is dangerous if the gears don't return.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 10,
	:evolutions => [
		[:KLINKLANG,:Level,49]
	]
},

:KLINKLANG => {
	:name => "Klinklang",
	:dexnum => 601,
	:Type1 => :STEEL,
	:BaseStats => [60, 100, 115, 90, 70, 85],
	:EVs => [0, 0, 3, 0, 0, 0],
	:Abilities => [:PLUS,:MINUS],
	:HiddenAbilities => :CLEARBODY,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "Genderless",
	:BaseEXP => 234,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:MAGNETICFLUX],
		[1,:GEARUP],
		[1,:VICEGRIP],
		[1,:CHARGE],
		[1,:THUNDERSHOCK],
		[1,:GEARGRIND],
		[6,:CHARGE],
		[11,:THUNDERSHOCK],
		[16,:GEARGRIND],
		[21,:BIND],
		[25,:CHARGEBEAM],
		[31,:AUTOTOMIZE],
		[36,:MIRRORSHOT],
		[40,:SCREECH],
		[44,:DISCHARGE],
		[48,:METALSOUND],
		[54,:SHIFTGEAR],
		[60,:LOCKON],
		[66,:ZAPCANNON],
		[72,:HYPERBEAM]],
	:tmlist => [:SIGNALBEAM,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:ROCKSMASH,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:DOUBLETEAM,:PROTECT,:RECYCLE,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:ALLYSWITCH,:GRAVITY,:MAGICCOAT,:REST,:TELEKINESIS,:TRICKROOM,:ROCKPOLISH,:SANDSTORM,:FLASHCANNON,:IRONDEFENSE,:CONFIDE,],
	:Color => "Gray",
	:EggGroups => [:Mineral],
	:Height => 6,
	:Weight => 810,
	:kind => "Gear",
	:dexentry => "The gear with the red core is rotated at high speed for a rapid energy charge.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 13,
	:BattlerAltitude => 10,
},

:TYNAMO => {
	:name => "Tynamo",
	:dexnum => 602,
	:Type1 => :ELECTRIC,
	:BaseStats => [35, 55, 40, 60, 45, 40],
	:EVs => [0, 0, 0, 1, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 55,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:TACKLE],
		[1,:THUNDERWAVE],
		[1,:SPARK],
		[1,:CHARGEBEAM]],
	:tmlist => [:MAGNETRISE,],
	:Color => "White",
	:EggGroups => [:Amorphous],
	:Height => 2,
	:Weight => 3,
	:kind => "Elefish",
	:dexentry => "These Pokémon move in schools. They have an electricity-generating organ, so they discharge electricity if in danger.",
	:BattlerPlayerY => 39,
	:BattlerEnemyY => 33,
	:BattlerAltitude => 5,
	:evolutions => [
		[:EELEKTRIK,:Level,39]
	]
},

:EELEKTRIK => {
	:name => "Eelektrik",
	:dexnum => 603,
	:Type1 => :ELECTRIC,
	:BaseStats => [65, 85, 70, 40, 75, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 142,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:CRUNCH],
		[1,:HEADBUTT],
		[1,:THUNDERWAVE],
		[1,:SPARK],
		[1,:CHARGEBEAM],
		[9,:BIND],
		[19,:ACID],
		[29,:DISCHARGE],
		[44,:THUNDERBOLT],
		[49,:ACIDSPRAY],
		[54,:COIL],
		[59,:WILDCHARGE],
		[64,:GASTROACID],
		[69,:ZAPCANNON],
		[74,:THRASH]],
	:tmlist => [:SIGNALBEAM,:UTURN,:KNOCKOFF,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:BOUNCE,:ACROBATICS,:GIGADRAIN,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GASTROACID,:TOXIC,:LIGHTSCREEN,:REST,:IRONTAIL,:FLASHCANNON,:AQUATAIL,:RAINDANCE,:THROATCHOP,],
	:Color => "Blue",
	:EggGroups => [:Amorphous],
	:Height => 12,
	:Weight => 220,
	:kind => "Elefish",
	:dexentry => "These Pokémon have a big appetite. When they spot their prey, they attack it and paralyze it with electricity.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 5,
	:evolutions => [
		[:EELEKTROSS,:Item,:THUNDERSTONE]
	]
},

:EELEKTROSS => {
	:name => "Eelektross",
	:dexnum => 604,
	:Type1 => :ELECTRIC,
	:BaseStats => [85, 115, 80, 50, 105, 80],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:LEVITATE],
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 232,
	:CatchRate => 30,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:CRUNCH],
		[1,:THRASH],
		[1,:ZAPCANNON],
		[1,:GASTROACID],
		[1,:COIL],
		[1,:IONDELUGE],
		[1,:CRUSHCLAW],
		[1,:HEADBUTT],
		[1,:ACID],
		[1,:DISCHARGE]],
	:tmlist => [:SIGNALBEAM,:UTURN,:KNOCKOFF,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:THUNDER,:THUNDERBOLT,:WILDCHARGE,:THUNDERPUNCH,:VOLTSWITCH,:SHOCKWAVE,:CHARGEBEAM,:MAGNETRISE,:THUNDERWAVE,:FOCUSPUNCH,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:ROCKSMASH,:FLAMETHROWER,:FIREPUNCH,:BOUNCE,:ACROBATICS,:GIGADRAIN,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:SUPERFANG,:ATTRACT,:DOUBLETEAM,:FLASH,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GASTROACID,:TOXIC,:LIGHTSCREEN,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:FLASHCANNON,:AQUATAIL,:RAINDANCE,:THROATCHOP,],
	:Color => "Blue",
	:EggGroups => [:Amorphous],
	:Height => 21,
	:Weight => 805,
	:kind => "Elefish",
	:dexentry => "With their sucker mouths, they suck in prey. Then they use their fangs to shock the prey with electricity.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 3,
},

:ELGYEM => {
	:name => "Elgyem",
	:dexnum => 605,
	:Type1 => :PSYCHIC,
	:BaseStats => [55, 55, 55, 30, 85, 55],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:TELEPATHY,:SYNCHRONIZE],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 67,
	:CatchRate => 255,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ALLYSWITCH,:ASTONISH,:BARRIER,:COSMICPOWER,:DISABLE,:GUARDSWAP,:NASTYPLOT,:POWERSWAP,:SKILLSWAP,:TELEPORT],
	:Moveset => [
		[1,:CONFUSION],
		[4,:GROWL],
		[8,:HEALBLOCK],
		[11,:MIRACLEEYE],
		[15,:PSYBEAM],
		[18,:HEADBUTT],
		[22,:HIDDENPOWER],
		[25,:IMPRISON],
		[29,:SIMPLEBEAM],
		[32,:ZENHEADBUTT],
		[36,:PSYCHUP],
		[39,:PSYCHIC],
		[43,:CALMMIND],
		[46,:RECOVER],
		[50,:GUARDSPLIT],
		[50,:POWERSPLIT],
		[53,:SYNCHRONOISE],
		[56,:WONDERROOM]],
	:tmlist => [:SIGNALBEAM,:DARKPULSE,:THIEF,:EMBARGO,:SNATCH,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SHADOWBALL,:ENERGYBALL,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:STEELWING,:RAINDANCE,],
	:Color => "Blue",
	:EggGroups => [:HumanLike],
	:Height => 5,
	:Weight => 90,
	:kind => "Cerebral",
	:dexentry => "This Pokémon had never been seen until it appeared from far in the desert 50 years ago.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 3,
	:evolutions => [
		[:BEHEEYEM,:Level,42]
	]
},

:BEHEEYEM => {
	:name => "Beheeyem",
	:dexnum => 606,
	:Type1 => :PSYCHIC,
	:BaseStats => [75, 75, 75, 40, 125, 95],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:TELEPATHY,:SYNCHRONIZE],
	:HiddenAbilities => :ANALYTIC,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 160,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:PSYCHICTERRAIN],
		[1,:WONDERROOM],
		[1,:SYNCHRONOISE],
		[1,:CONFUSION],
		[1,:GROWL],
		[1,:HEALBLOCK],
		[1,:MIRACLEEYE],
		[4,:GROWL],
		[8,:HEALBLOCK],
		[11,:MIRACLEEYE],
		[15,:PSYBEAM],
		[18,:HEADBUTT],
		[22,:HIDDENPOWER],
		[25,:IMPRISON],
		[29,:SIMPLEBEAM],
		[32,:ZENHEADBUTT],
		[36,:PSYCHUP],
		[39,:PSYCHIC],
		[45,:CALMMIND],
		[50,:RECOVER],
		[56,:GUARDSPLIT],
		[58,:POWERSPLIT],
		[63,:SYNCHRONOISE],
		[68,:WONDERROOM]],
	:tmlist => [:SIGNALBEAM,:DARKPULSE,:THIEF,:EMBARGO,:SNATCH,:THUNDERBOLT,:SHOCKWAVE,:CHARGEBEAM,:THUNDERWAVE,:SHADOWBALL,:ENERGYBALL,:GIGAIMPACT,:HYPERBEAM,:UPROAR,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:AFTERYOU,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:RECYCLE,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:PSYSHOCK,:ZENHEADBUTT,:ALLYSWITCH,:CALMMIND,:GRAVITY,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:ROLEPLAY,:SKILLSWAP,:TELEKINESIS,:TRICK,:TRICKROOM,:WONDERROOM,:ROCKSLIDE,:ROCKTOMB,:STEELWING,:RAINDANCE,],
	:Color => "Brown",
	:EggGroups => [:HumanLike],
	:Height => 10,
	:Weight => 345,
	:kind => "Cerebral",
	:dexentry => "It uses psychic power to control an opponent's brain and tamper with its memories.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 11,
	:BattlerAltitude => 10,
},

:LITWICK => {
	:name => "Litwick",
	:dexnum => 607,
	:Type1 => :GHOST,
	:Type2 => :FIRE,
	:BaseStats => [50, 30, 55, 20, 65, 55],
	:EVs => [0, 0, 0, 0, 1, 0],
	:Abilities => [:FLASHFIRE,:FLAMEBODY],
	:HiddenAbilities => :INFILTRATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 55,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ACID,:ACIDARMOR,:CAPTIVATE,:CLEARSMOG,:ENDURE,:HAZE,:HEATWAVE,:POWERSPLIT],
	:Moveset => [
		[1,:EMBER],
		[1,:ASTONISH],
		[3,:MINIMIZE],
		[5,:SMOG],
		[7,:FIRESPIN],
		[10,:CONFUSERAY],
		[13,:NIGHTSHADE],
		[16,:WILLOWISP],
		[20,:FLAMEBURST],
		[24,:IMPRISON],
		[28,:HEX],
		[33,:MEMENTO],
		[38,:INFERNO],
		[43,:CURSE],
		[49,:SHADOWBALL],
		[55,:PAINSPLIT],
		[61,:OVERHEAT]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:EMBARGO,:TAUNT,:SHOCKWAVE,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SPITE,:SOLARBEAM,:ENERGYBALL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:REST,:TELEKINESIS,:TRICK,:TRICKROOM,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Amorphous],
	:Height => 3,
	:Weight => 31,
	:kind => "Candle",
	:dexentry => "While shining a light and pretending to be a guide, it leeches off the life force of any who follow it.",
	:BattlerPlayerY => 30,
	:BattlerEnemyY => 36,
	:BattlerAltitude => 0,
	:evolutions => [
		[:LAMPENT,:Level,41]
	]
},

:LAMPENT => {
	:name => "Lampent",
	:dexnum => 608,
	:Type1 => :GHOST,
	:Type2 => :FIRE,
	:BaseStats => [60, 40, 60, 55, 95, 60],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:FLASHFIRE,:FLAMEBODY],
	:HiddenAbilities => :INFILTRATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 130,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:EMBER],
		[1,:ASTONISH],
		[1,:MINIMIZE],
		[1,:SMOG],
		[3,:MINIMIZE],
		[5,:SMOG],
		[7,:FIRESPIN],
		[10,:CONFUSERAY],
		[13,:NIGHTSHADE],
		[16,:WILLOWISP],
		[20,:FLAMEBURST],
		[24,:IMPRISON],
		[28,:HEX],
		[33,:MEMENTO],
		[38,:INFERNO],
		[45,:CURSE],
		[53,:SHADOWBALL],
		[61,:PAINSPLIT],
		[69,:OVERHEAT]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:EMBARGO,:TAUNT,:SHOCKWAVE,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SPITE,:SOLARBEAM,:ENERGYBALL,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:REST,:TELEKINESIS,:TRICK,:TRICKROOM,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Amorphous],
	:Height => 6,
	:Weight => 130,
	:kind => "Lamp",
	:dexentry => "It arrives near the moment of death and steals the spirit from the body.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 18,
	:BattlerAltitude => 5,
	:evolutions => [
		[:CHANDELURE,:Item,:DUSKSTONE]
	]
},

:CHANDELURE => {
	:name => "Chandelure",
	:dexnum => 609,
	:Type1 => :GHOST,
	:Type2 => :FIRE,
	:BaseStats => [60, 55, 90, 80, 145, 90],
	:EVs => [0, 0, 0, 0, 3, 0],
	:Abilities => [:FLASHFIRE,:FLAMEBODY],
	:HiddenAbilities => :INFILTRATOR,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 234,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:PAINSPLIT],
		[1,:SMOG],
		[1,:CONFUSERAY],
		[1,:FLAMEBURST],
		[1,:HEX]],
	:tmlist => [:DARKPULSE,:PAYBACK,:THIEF,:EMBARGO,:TAUNT,:SHOCKWAVE,:OVERHEAT,:FIREBLAST,:HEATWAVE,:FLAMETHROWER,:FLAMECHARGE,:SUNNYDAY,:WILLOWISP,:SHADOWBALL,:SPITE,:SOLARBEAM,:ENERGYBALL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:PSYCHUP,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:DREAMEATER,:PSYCHIC,:ALLYSWITCH,:CALMMIND,:REST,:TELEKINESIS,:TRICK,:TRICKROOM,:CONFIDE,:LASERFOCUS,],
	:Color => "White",
	:EggGroups => [:Amorphous],
	:Height => 10,
	:Weight => 343,
	:kind => "Luring",
	:dexentry => "Being consumed in Chandelure's flame burns up the spirit, leaving the body behind.",
	:BattlerPlayerY => 16,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 10,
},

:AXEW => {
	:name => "Axew",
	:dexnum => 610,
	:Type1 => :DRAGON,
	:BaseStats => [46, 87, 60, 57, 30, 40],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:RIVALRY,:MOLDBREAKER],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 64,
	:CatchRate => 75,
	:Happiness => 35,
	:EggSteps => 10240,
	:EggMoves => [:COUNTER,:DRAGONPULSE,:ENDEAVOR,:ENDURE,:FOCUSENERGY,:HARDEN,:IRONTAIL,:NIGHTSLASH,:RAZORWIND,:REVERSAL],
	:Moveset => [
		[1,:SCRATCH],
		[4,:LEER],
		[7,:ASSURANCE],
		[10,:DRAGONRAGE],
		[13,:DUALCHOP],
		[16,:SCARYFACE],
		[20,:SLASH],
		[24,:FALSESWIPE],
		[28,:DRAGONCLAW],
		[32,:DRAGONDANCE],
		[36,:TAUNT],
		[41,:DRAGONPULSE],
		[46,:SWORDSDANCE],
		[50,:GUILLOTINE],
		[56,:OUTRAGE],
		[61,:GIGAIMPACT]],
	:tmlist => [:XSCISSOR,:PAYBACK,:FLING,:TAUNT,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DUALCHOP,:SHOCKWAVE,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:GIGAIMPACT,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:ROCKTOMB,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,],
	:Color => "Green",
	:EggGroups => [:Monster,:Dragon],
	:Height => 6,
	:Weight => 180,
	:kind => "Tusk",
	:dexentry => "They mark their territory by leaving gashes in trees with their tusks. If a tusk breaks, a new one grows in quickly.",
	:BattlerPlayerY => 29,
	:BattlerEnemyY => 31,
	:BattlerAltitude => 0,
	:evolutions => [
		[:FRAXURE,:Level,38]
	]
},

:FRAXURE => {
	:name => "Fraxure",
	:dexnum => 611,
	:Type1 => :DRAGON,
	:BaseStats => [66, 117, 70, 67, 40, 50],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:RIVALRY,:MOLDBREAKER],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 144,
	:CatchRate => 60,
	:Happiness => 35,
	:EggSteps => 10240,
	:Moveset => [
		[1,:SCRATCH],
		[1,:LEER],
		[1,:ASSURANCE],
		[1,:DRAGONRAGE],
		[4,:LEER],
		[7,:ASSURANCE],
		[10,:DRAGONRAGE],
		[13,:DUALCHOP],
		[16,:SCARYFACE],
		[20,:SLASH],
		[24,:FALSESWIPE],
		[28,:DRAGONCLAW],
		[32,:DRAGONDANCE],
		[36,:TAUNT],
		[42,:DRAGONPULSE],
		[48,:SWORDSDANCE],
		[54,:GUILLOTINE],
		[60,:OUTRAGE],
		[66,:GIGAIMPACT]],
	:tmlist => [:XSCISSOR,:PAYBACK,:FLING,:TAUNT,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:DUALCHOP,:SHOCKWAVE,:SUPERPOWER,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:GIGAIMPACT,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:ROCKTOMB,:IRONTAIL,:AQUATAIL,:RAINDANCE,:CONFIDE,:STOMPINGTANTRUM,],
	:Color => "Green",
	:EggGroups => [:Monster,:Dragon],
	:Height => 10,
	:Weight => 360,
	:kind => "Axe Jaw",
	:dexentry => "Their tusks can shatter rocks. Territory battles between Fraxure can be intensely violent.",
	:BattlerPlayerY => 20,
	:BattlerEnemyY => 25,
	:BattlerAltitude => 0,
	:evolutions => [
		[:HAXORUS,:Level,48]
	]
},

:HAXORUS => {
	:name => "Haxorus",
	:dexnum => 612,
	:Type1 => :DRAGON,
	:BaseStats => [76, 147, 90, 97, 60, 70],
	:EVs => [0, 3, 0, 0, 0, 0],
	:Abilities => [:RIVALRY,:MOLDBREAKER],
	:HiddenAbilities => :UNNERVE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 243,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 10240,
	:Moveset => [
		[1,:OUTRAGE],
		[1,:SCRATCH],
		[1,:LEER],
		[1,:ASSURANCE],
		[1,:DRAGONRAGE],
		[4,:LEER],
		[7,:ASSURANCE],
		[10,:DRAGONRAGE],
		[13,:DUALCHOP],
		[16,:SCARYFACE],
		[20,:SLASH],
		[24,:FALSESWIPE],
		[28,:DRAGONCLAW],
		[32,:DRAGONDANCE],
		[36,:TAUNT],
		[42,:DRAGONPULSE],
		[50,:SWORDSDANCE],
		[58,:GUILLOTINE],
		[66,:OUTRAGE],
		[74,:GIGAIMPACT]],
	:tmlist => [:XSCISSOR,:PAYBACK,:FLING,:TAUNT,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:DUALCHOP,:SHOCKWAVE,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:GRASSKNOT,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:IRONTAIL,:SURF,:AQUATAIL,:RAINDANCE,:CONFIDE,:BRUTALSWING,:LASERFOCUS,:STOMPINGTANTRUM,],
	:Color => "Yellow",
	:EggGroups => [:Monster,:Dragon],
	:Height => 18,
	:Weight => 1055,
	:kind => "Axe Jaw",
	:dexentry => "Their sturdy tusks will stay sharp even if used to cut steel beams. These Pokémon are covered in hard armor.",
	:BattlerPlayerY => 5,
	:BattlerEnemyY => 10,
	:BattlerAltitude => 0,
},

:CUBCHOO => {
	:name => "Cubchoo",
	:dexnum => 613,
	:Type1 => :ICE,
	:BaseStats => [55, 70, 40, 40, 60, 40],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:SNOWCLOAK,:SLUSHRUSH],
	:HiddenAbilities => :RATTLED,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 120,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ASSURANCE,:AVALANCHE,:ENCORE,:FOCUSPUNCH,:ICEPUNCH,:NIGHTSLASH,:PLAYROUGH,:SLEEPTALK,:YAWN],
	:Moveset => [
		[1,:GROWL],
		[5,:POWDERSNOW],
		[9,:BIDE],
		[13,:ICYWIND],
		[17,:FURYSWIPES],
		[21,:BRINE],
		[25,:ENDURE],
		[29,:CHARM],
		[33,:SLASH],
		[36,:FLAIL],
		[41,:REST],
		[45,:BLIZZARD],
		[49,:HAIL],
		[53,:THRASH],
		[57,:SHEERCOLD]],
	:tmlist => [:FLING,:FOCUSPUNCH,:SUPERPOWER,:ROCKSMASH,:LOWKICK,:AERIALACE,:SHADOWCLAW,:GRASSKNOT,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKTOMB,:SURF,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "White",
	:EggGroups => [:Field],
	:Height => 5,
	:Weight => 85,
	:kind => "Chill",
	:dexentry => "Its nose is always running. It sniffs the snot back up because the mucus provides the raw material for its moves.",
	:BattlerPlayerY => 32,
	:BattlerEnemyY => 37,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BEARTIC,:Level,37]
	]
},

:BEARTIC => {
	:name => "Beartic",
	:dexnum => 614,
	:Type1 => :ICE,
	:BaseStats => [95, 130, 80, 50, 70, 80],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:SNOWCLOAK,:SLUSHRUSH],
	:HiddenAbilities => :SWIFTSWIM,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 170,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:ICICLECRASH],
		[1,:SHEERCOLD],
		[1,:THRASH],
		[1,:SUPERPOWER],
		[1,:AQUAJET],
		[1,:GROWL],
		[1,:POWDERSNOW],
		[1,:BIDE],
		[1,:ICYWIND],
		[5,:POWDERSNOW],
		[9,:BIDE],
		[13,:ICYWIND],
		[17,:FURYSWIPES],
		[21,:BRINE],
		[25,:ENDURE],
		[29,:SWAGGER],
		[33,:SLASH],
		[36,:FLAIL],
		[41,:REST],
		[45,:BLIZZARD],
		[53,:HAIL],
		[59,:THRASH],
		[66,:SHEERCOLD]],
	:tmlist => [:FLING,:TAUNT,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:ROCKSMASH,:LOWKICK,:BULKUP,:AERIALACE,:SHADOWCLAW,:GRASSKNOT,:BULLDOZE,:BLIZZARD,:ICEBEAM,:ICEPUNCH,:ICYWIND,:FROSTBREATH,:HAIL,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:COVET,:ROUND,:CUT,:ECHOEDVOICE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SURF,:DIVE,:WATERPULSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:THROATCHOP,],
	:Color => "White",
	:EggGroups => [:Field],
	:Height => 26,
	:Weight => 2600,
	:kind => "Freezing",
	:dexentry => "It freezes its breath to create fangs and claws of ice to fight with. Cold northern areas are its habitat.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 16,
	:BattlerAltitude => 0,
},

:CRYOGONAL => {
	:name => "Cryogonal",
	:dexnum => 615,
	:Type1 => :ICE,
	:BaseStats => [80, 50, 50, 105, 95, 135],
	:EVs => [0, 0, 0, 0, 0, 2],
	:Abilities => [:LEVITATE],
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 170,
	:CatchRate => 25,
	:Happiness => 70,
	:EggSteps => 6400,
	:Moveset => [
		[1,:SHEERCOLD],
		[1,:NIGHTSLASH],
		[1,:BIND],
		[1,:ICESHARD],
		[1,:SHARPEN],
		[1,:RAPIDSPIN],
		[5,:ICYWIND],
		[9,:MIST],
		[9,:HAZE],
		[13,:AURORABEAM],
		[17,:ACIDARMOR],
		[21,:ANCIENTPOWER],
		[25,:ICEBEAM],
		[29,:LIGHTSCREEN],
		[33,:REFLECT],
		[37,:SLASH],
		[41,:CONFUSERAY],
		[45,:RECOVER],
		[49,:FREEZEDRY],
		[50,:SOLARBEAM],
		[53,:NIGHTSLASH],
		[57,:SHEERCOLD]],
	:tmlist => [:SIGNALBEAM,:KNOCKOFF,:ACROBATICS,:DEFOG,:SOLARBEAM,:BLIZZARD,:ICEBEAM,:ICYWIND,:FROSTBREATH,:HAIL,:EXPLOSION,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:BIND,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:POISONJAB,:TOXIC,:LIGHTSCREEN,:MAGICCOAT,:REFLECT,:REST,:FLASHCANNON,:IRONDEFENSE,:WATERPULSE,:RAINDANCE,:CONFIDE,:AURORAVEIL,:LASERFOCUS,],
	:Color => "Blue",
	:EggGroups => [:Mineral],
	:Height => 11,
	:Weight => 1480,
	:WildItemUncommon => :NEVERMELTICE,
	:kind => "Crystalizing",
	:dexentry => "They are born in snow clouds. They use chains made of ice crystals to capture prey.",
	:BattlerPlayerY => 14,
	:BattlerEnemyY => 7,
	:BattlerAltitude => 8,
},

:SHELMET => {
	:name => "Shelmet",
	:dexnum => 616,
	:Type1 => :BUG,
	:BaseStats => [50, 40, 85, 25, 40, 65],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:HYDRATION,:SHELLARMOR],
	:HiddenAbilities => :OVERCOAT,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 61,
	:CatchRate => 200,
	:Happiness => 70,
	:EggSteps => 3840,
	:EggMoves => [:BATONPASS,:DOUBLEEDGE,:ENCORE,:ENDURE,:FEINT,:GUARDSPLIT,:MINDREADER,:MUDSLAP,:PURSUIT,:SPIKES,:TOXICSPIKES],
	:Moveset => [
		[1,:ABSORB],
		[4,:ACID],
		[8,:BIDE],
		[13,:CURSE],
		[16,:STRUGGLEBUG],
		[20,:MEGADRAIN],
		[25,:YAWN],
		[28,:PROTECT],
		[32,:ACIDARMOR],
		[37,:GIGADRAIN],
		[40,:BODYSLAM],
		[44,:BUGBUZZ],
		[49,:RECOVER],
		[50,:GUARDSWAP],
		[56,:FINALGAMBIT]],
	:tmlist => [:SIGNALBEAM,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:ENERGYBALL,:GIGADRAIN,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:RAINDANCE,:CONFIDE,:INFESTATION,],
	:Color => "Red",
	:EggGroups => [:Bug],
	:Height => 4,
	:Weight => 77,
	:kind => "Snail",
	:dexentry => "It evolves when bathed in an electric-like energy along with Karrablast. The reason is still unknown.",
	:BattlerPlayerY => 31,
	:BattlerEnemyY => 36,
	:BattlerAltitude => 0,
	:evolutions => [
		[:ACCELGOR,:Trade,0]
	]
},

:ACCELGOR => {
	:name => "Accelgor",
	:dexnum => 617,
	:Type1 => :BUG,
	:BaseStats => [80, 70, 40, 145, 100, 60],
	:EVs => [0, 0, 0, 2, 0, 0],
	:Abilities => [:HYDRATION,:STICKYHOLD],
	:HiddenAbilities => :UNBURDEN,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 173,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 3840,
	:Moveset => [
		[1,:WATERSHURIKEN],
		[1,:FINALGAMBIT],
		[1,:POWERSWAP],
		[1,:ABSORB],
		[1,:ACIDSPRAY],
		[1,:DOUBLETEAM],
		[1,:QUICKATTACK],
		[4,:ACIDSPRAY],
		[8,:DOUBLETEAM],
		[13,:QUICKATTACK],
		[16,:STRUGGLEBUG],
		[20,:MEGADRAIN],
		[25,:SWIFT],
		[28,:MEFIRST],
		[32,:AGILITY],
		[37,:GIGADRAIN],
		[40,:UTURN],
		[44,:BUGBUZZ],
		[49,:RECOVER],
		[52,:POWERSWAP],
		[56,:FINALGAMBIT]],
	:tmlist => [:SIGNALBEAM,:UTURN,:BUGBITE,:STRUGGLEBUG,:LEECHLIFE,:KNOCKOFF,:FOCUSBLAST,:ENERGYBALL,:GIGADRAIN,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEBOMB,:VENOSHOCK,:GASTROACID,:TOXIC,:REST,:SANDSTORM,:RAINDANCE,:CONFIDE,:INFESTATION,:LASERFOCUS,],
	:Color => "Red",
	:EggGroups => [:Bug],
	:Height => 8,
	:Weight => 253,
	:kind => "Shell Out",
	:dexentry => "Having removed its heavy shell, it becomes very light and can fight with ninja-like movements.",
	:BattlerPlayerY => 19,
	:BattlerEnemyY => 17,
	:BattlerAltitude => 0,
},

:STUNFISK => {
	:name => "Stunfisk",
	:dexnum => 618,
	:Type1 => :GROUND,
	:Type2 => :ELECTRIC,
	:BaseStats => [109, 66, 84, 32, 81, 99],
	:EVs => [2, 0, 0, 0, 0, 0],
	:Abilities => [:STATIC,:LIMBER],
	:HiddenAbilities => :SANDVEIL,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 165,
	:CatchRate => 75,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:ASTONISH,:CURSE,:EARTHPOWER,:EERIEIMPULSE,:MEFIRST,:PAINSPLIT,:REFLECTTYPE,:SHOCKWAVE,:SLEEPTALK,:SPARK,:SPITE,:YAWN],
	:Moveset => [
		[1,:FISSURE],
		[1,:FLAIL],
		[1,:TACKLE],
		[1,:WATERGUN],
		[1,:MUDSLAP],
		[1,:MUDSPORT],
		[5,:BIDE],
		[9,:THUNDERSHOCK],
		[13,:MUDSHOT],
		[17,:CAMOUFLAGE],
		[21,:MUDBOMB],
		[25,:DISCHARGE],
		[30,:ENDURE],
		[35,:BOUNCE],
		[40,:MUDDYWATER],
		[45,:THUNDERBOLT],
		[50,:REVENGE],
		[55,:FLAIL],
		[61,:FISSURE]],
	:tmlist => [:FOULPLAY,:PAYBACK,:THUNDER,:THUNDERBOLT,:SHOCKWAVE,:ELECTROWEB,:MAGNETRISE,:THUNDERWAVE,:BOUNCE,:SPITE,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:UPROAR,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:FLASH,:PAINSPLIT,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SLUDGEWAVE,:SLUDGEBOMB,:TOXIC,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:SANDSTORM,:STEALTHROCK,:SURF,:AQUATAIL,:SCALD,:WATERPULSE,:RAINDANCE,:CONFIDE,:INFESTATION,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Water1,:Amorphous],
	:Height => 7,
	:Weight => 110,
	:WildItemUncommon => :SOFTSAND,
	:kind => "Trap",
	:dexentry => "It conceals itself in the mud of the seashore. Then it waits. When prey touches it, it delivers a jolt of energy.",
	:BattlerPlayerY => 35,
	:BattlerEnemyY => 21,
	:BattlerAltitude => 1,
},

:MIENFOO => {
	:name => "Mienfoo",
	:dexnum => 619,
	:Type1 => :FIGHTING,
	:BaseStats => [45, 85, 50, 65, 55, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:INNERFOCUS,:REGENERATOR],
	:HiddenAbilities => :RECKLESS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 70,
	:CatchRate => 180,
	:Happiness => 70,
	:EggSteps => 6400,
	:EggMoves => [:ALLYSWITCH,:BATONPASS,:ENDURE,:FEINT,:KNOCKOFF,:LOWKICK,:MEFIRST,:SMELLINGSALTS,:VITALTHROW],
	:Moveset => [
		[1,:POUND],
		[5,:MEDITATE],
		[9,:DETECT],
		[13,:FAKEOUT],
		[17,:DOUBLESLAP],
		[21,:SWIFT],
		[25,:CALMMIND],
		[29,:FORCEPALM],
		[33,:DRAINPUNCH],
		[37,:JUMPKICK],
		[41,:UTURN],
		[45,:QUICKGUARD],
		[49,:BOUNCE],
		[50,:HIJUMPKICK],
		[57,:REVERSAL],
		[61,:AURASPHERE]],
	:tmlist => [:UTURN,:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:DUALCHOP,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:SUNNYDAY,:BOUNCE,:AERIALACE,:ACROBATICS,:GRASSKNOT,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:ALLYSWITCH,:CALMMIND,:REFLECT,:REST,:ROLEPLAY,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Yellow",
	:EggGroups => [:Field,:HumanLike],
	:Height => 9,
	:Weight => 200,
	:kind => "Martial Arts",
	:dexentry => "They have mastered elegant combos. As they concentrate, their battle moves become swifter and more precise.",
	:BattlerPlayerY => 26,
	:BattlerEnemyY => 28,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MIENSHAO,:Level,50]
	]
},

:MIENSHAO => {
	:name => "Mienshao",
	:dexnum => 620,
	:Type1 => :FIGHTING,
	:BaseStats => [65, 125, 60, 105, 95, 60],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:INNERFOCUS,:REGENERATOR],
	:HiddenAbilities => :RECKLESS,
	:GrowthRate => "MediumSlow",
	:GenderRatio => "FemHalf",
	:BaseEXP => 179,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 6400,
	:Moveset => [
		[1,:AURASPHERE],
		[1,:REVERSAL],
		[1,:POUND],
		[1,:MEDITATE],
		[1,:DETECT],
		[1,:FAKEOUT],
		[5,:MEDITATE],
		[9,:DETECT],
		[13,:FAKEOUT],
		[17,:DOUBLESLAP],
		[21,:SWIFT],
		[25,:CALMMIND],
		[29,:FORCEPALM],
		[33,:DRAINPUNCH],
		[37,:JUMPKICK],
		[41,:UTURN],
		[45,:WIDEGUARD],
		[49,:BOUNCE],
		[56,:HIJUMPKICK],
		[63,:REVERSAL],
		[70,:AURASPHERE]],
	:tmlist => [:UTURN,:PAYBACK,:KNOCKOFF,:FLING,:TAUNT,:DUALCHOP,:FOCUSPUNCH,:FOCUSBLAST,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:BULKUP,:SUNNYDAY,:BOUNCE,:AERIALACE,:ACROBATICS,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:HELPINGHAND,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:ALLYSWITCH,:CALMMIND,:REFLECT,:REST,:ROLEPLAY,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:LASERFOCUS,],
	:Color => "Purple",
	:EggGroups => [:Field,:HumanLike],
	:Height => 14,
	:Weight => 355,
	:kind => "Martial Arts",
	:dexentry => "They use the long fur on their arms as a whip to strike their opponents.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 19,
	:BattlerAltitude => 0,
},

:DRUDDIGON => {
	:name => "Druddigon",
	:dexnum => 621,
	:Type1 => :DRAGON,
	:BaseStats => [77, 120, 90, 48, 60, 90],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:ROUGHSKIN,:SHEERFORCE],
	:HiddenAbilities => :MOLDBREAKER,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 170,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 7680,
	:EggMoves => [:CRUSHCLAW,:FEINTATTACK,:FIREFANG,:GLARE,:IRONTAIL,:METALCLAW,:POISONTAIL,:PURSUIT,:SNATCH,:SUCKERPUNCH,:THUNDERFANG],
	:Moveset => [
		[1,:LEER],
		[1,:SCRATCH],
		[5,:HONECLAWS],
		[9,:BITE],
		[13,:SCARYFACE],
		[18,:DRAGONRAGE],
		[21,:SLASH],
		[25,:CRUNCH],
		[27,:DRAGONCLAW],
		[31,:CHIPAWAY],
		[35,:REVENGE],
		[40,:NIGHTSLASH],
		[45,:DRAGONTAIL],
		[49,:ROCKCLIMB],
		[55,:SUPERPOWER],
		[62,:OUTRAGE]],
	:tmlist => [:DARKPULSE,:SNARL,:PAYBACK,:FLING,:SNATCH,:TAUNT,:TORMENT,:DRACOMETEOR,:OUTRAGE,:DRAGONPULSE,:DRAGONCLAW,:DRAGONTAIL,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:FOCUSBLAST,:SUPERPOWER,:ROCKSMASH,:HEATWAVE,:FLAMETHROWER,:FIREPUNCH,:SUNNYDAY,:AERIALACE,:SHADOWCLAW,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:HYPERBEAM,:ROCKCLIMB,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:ROAR,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:GUNKSHOT,:SLUDGEBOMB,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:SMACKDOWN,:STEALTHROCK,:IRONTAIL,:FLASHCANNON,:IRONHEAD,:SURF,:AQUATAIL,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Red",
	:EggGroups => [:Monster,:Dragon],
	:Height => 16,
	:Weight => 1390,
	:WildItemUncommon => :DRAGONFANG,
	:kind => "Cave",
	:dexentry => "It races through narrow caves, using its sharp claws to catch prey. The skin on its face is harder than a rock.",
	:BattlerPlayerY => 17,
	:BattlerEnemyY => 22,
	:BattlerAltitude => 0,
},

:GOLETT => {
	:name => "Golett",
	:dexnum => 622,
	:Type1 => :GROUND,
	:Type2 => :GHOST,
	:BaseStats => [59, 74, 50, 35, 35, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:IRONFIST,:KLUTZ],
	:HiddenAbilities => :NOGUARD,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 61,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 6400,
	:Moveset => [
		[1,:POUND],
		[1,:ASTONISH],
		[1,:DEFENSECURL],
		[5,:MUDSLAP],
		[9,:ROLLOUT],
		[13,:SHADOWPUNCH],
		[17,:IRONDEFENSE],
		[21,:STOMPINGTANTRUM],
		[25,:MEGAPUNCH],
		[30,:MAGNITUDE],
		[35,:DYNAMICPUNCH],
		[40,:NIGHTSHADE],
		[45,:CURSE],
		[50,:EARTHQUAKE],
		[55,:HAMMERARM],
		[61,:FOCUSPUNCH]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:THUNDERPUNCH,:SHOCKWAVE,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:SHADOWBALL,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:ALLYSWITCH,:GRAVITY,:MAGICCOAT,:REST,:TELEKINESIS,:ROCKSLIDE,:ROCKTOMB,:ROCKPOLISH,:STEALTHROCK,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Green",
	:EggGroups => [:Mineral],
	:Height => 10,
	:Weight => 920,
	:WildItemUncommon => :LIGHTCLAY,
	:kind => "Automaton",
	:dexentry => "These Pokémon are thought to have been created by the science of an ancient and mysterious civilization.",
	:BattlerPlayerY => 18,
	:BattlerEnemyY => 24,
	:BattlerAltitude => 0,
	:evolutions => [
		[:GOLURK,:Level,43]
	]
},

:GOLURK => {
	:name => "Golurk",
	:dexnum => 623,
	:Type1 => :GROUND,
	:Type2 => :GHOST,
	:BaseStats => [89, 124, 80, 55, 55, 80],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:IRONFIST,:KLUTZ],
	:HiddenAbilities => :NOGUARD,
	:GrowthRate => "MediumFast",
	:GenderRatio => "Genderless",
	:BaseEXP => 169,
	:CatchRate => 90,
	:Happiness => 70,
	:EggSteps => 6400,
	:Moveset => [
		[0,:HEAVYSLAM],
		[1,:HIGHHORSEPOWER],
		[1,:POUND],
		[1,:ASTONISH],
		[1,:DEFENSECURL],
		[1,:MUDSLAP],
		[5,:MUDSLAP],
		[9,:ROLLOUT],
		[13,:SHADOWPUNCH],
		[17,:IRONDEFENSE],
		[21,:STOMPINGTANTRUM],
		[25,:MEGAPUNCH],
		[30,:MAGNITUDE],
		[35,:DYNAMICPUNCH],
		[40,:NIGHTSHADE],
		[47,:CURSE],
		[54,:EARTHQUAKE],
		[61,:HAMMERARM],
		[69,:FOCUSPUNCH],
		[76,:PHANTOMFORCE]],
	:tmlist => [:SIGNALBEAM,:THIEF,:FLING,:THUNDERBOLT,:THUNDERPUNCH,:SHOCKWAVE,:CHARGEBEAM,:FOCUSPUNCH,:FOCUSBLAST,:SUPERPOWER,:BRICKBREAK,:DRAINPUNCH,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:FIREPUNCH,:FLY,:SHADOWBALL,:SOLARBEAM,:GRASSKNOT,:EARTHQUAKE,:EARTHPOWER,:BULLDOZE,:ICEBEAM,:ICEPUNCH,:ICYWIND,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:BLOCK,:DOUBLETEAM,:FLASH,:PROTECT,:SAFEGUARD,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:PSYCHIC,:ZENHEADBUTT,:ALLYSWITCH,:GRAVITY,:MAGICCOAT,:REST,:TELEKINESIS,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:ROCKPOLISH,:STEALTHROCK,:FLASHCANNON,:GYROBALL,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,:STOMPINGTANTRUM,],
	:Color => "Green",
	:EggGroups => [:Mineral],
	:Height => 28,
	:Weight => 3300,
	:WildItemUncommon => :LIGHTCLAY,
	:kind => "Automaton",
	:dexentry => "It is said that Golurk were ordered to protect people and Pokémon by the ancient people who made them.",
	:BattlerPlayerY => 7,
	:BattlerEnemyY => 14,
	:BattlerAltitude => 0,
},

:PAWNIARD => {
	:name => "Pawniard",
	:dexnum => 624,
	:Type1 => :DARK,
	:Type2 => :STEEL,
	:BaseStats => [45, 85, 70, 60, 40, 40],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:DEFIANT,:INNERFOCUS],
	:HiddenAbilities => :PRESSURE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 68,
	:CatchRate => 120,
	:Happiness => 35,
	:EggSteps => 5120,
	:EggMoves => [:HEADBUTT,:MEANLOOK,:PSYCHOCUT,:PURSUIT,:QUICKGUARD,:REVENGE,:STEALTHROCK,:SUCKERPUNCH],
	:Moveset => [
		[1,:SCRATCH],
		[6,:LEER],
		[9,:FURYCUTTER],
		[14,:TORMENT],
		[17,:FEINTATTACK],
		[22,:SCARYFACE],
		[25,:METALCLAW],
		[30,:SLASH],
		[33,:ASSURANCE],
		[38,:METALSOUND],
		[41,:EMBARGO],
		[46,:IRONDEFENSE],
		[49,:NIGHTSLASH],
		[54,:IRONHEAD],
		[57,:SWORDSDANCE],
		[62,:GUILLOTINE]],
	:tmlist => [:XSCISSOR,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:DUALCHOP,:MAGNETRISE,:THUNDERWAVE,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:AERIALACE,:SHADOWCLAW,:SPITE,:GRASSKNOT,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:ROLEPLAY,:ROCKTOMB,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:CONFIDE,:POWERUPPUNCH,],
	:Color => "Black",
	:EggGroups => [:HumanLike],
	:Height => 5,
	:Weight => 102,
	:kind => "Sharp Blade",
	:dexentry => "They fight at Bisharp's command. They cling to their prey and inflict damage by sinking their blades into it.",
	:BattlerPlayerY => 25,
	:BattlerEnemyY => 29,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BISHARP,:Level,52]
	]
},

:BISHARP => {
	:name => "Bisharp",
	:dexnum => 625,
	:Type1 => :DARK,
	:Type2 => :STEEL,
	:BaseStats => [65, 125, 100, 70, 60, 70],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:DEFIANT,:INNERFOCUS],
	:HiddenAbilities => :PRESSURE,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 172,
	:CatchRate => 45,
	:Happiness => 35,
	:EggSteps => 5120,
	:Moveset => [
		[1,:GUILLOTINE],
		[1,:IRONHEAD],
		[1,:METALBURST],
		[1,:SCRATCH],
		[1,:LEER],
		[1,:FURYCUTTER],
		[1,:TORMENT],
		[6,:LEER],
		[9,:FURYCUTTER],
		[14,:TORMENT],
		[17,:FEINTATTACK],
		[22,:SCARYFACE],
		[25,:METALCLAW],
		[30,:SLASH],
		[33,:ASSURANCE],
		[38,:METALSOUND],
		[41,:EMBARGO],
		[46,:IRONDEFENSE],
		[49,:NIGHTSLASH],
		[57,:IRONHEAD],
		[63,:SWORDSDANCE],
		[71,:GUILLOTINE]],
	:tmlist => [:XSCISSOR,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:FLING,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:DUALCHOP,:MAGNETRISE,:THUNDERWAVE,:FOCUSBLAST,:BRICKBREAK,:LOWSWEEP,:ROCKSMASH,:LOWKICK,:AERIALACE,:SHADOWCLAW,:SPITE,:GRASSKNOT,:GIGAIMPACT,:HYPERBEAM,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:FALSESWIPE,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:POISONJAB,:TOXIC,:REST,:ROLEPLAY,:STONEEDGE,:ROCKTOMB,:ROCKPOLISH,:SANDSTORM,:STEALTHROCK,:IRONHEAD,:IRONDEFENSE,:RAINDANCE,:POWERUPPUNCH,:LASERFOCUS,:THROATCHOP,],
	:Color => "Red",
	:EggGroups => [:HumanLike],
	:Height => 16,
	:Weight => 700,
	:kind => "Sharp Sword",
	:dexentry => "Bisharp pursues prey in the company of a large group of Pawniard. Then Bisharp finishes off the prey.",
	:BattlerPlayerY => 11,
	:BattlerEnemyY => 15,
	:BattlerAltitude => 0,
},

:BOUFFALANT => {
	:name => "Bouffalant",
	:dexnum => 626,
	:Type1 => :NORMAL,
	:BaseStats => [95, 110, 95, 55, 40, 95],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:RECKLESS,:SAPSIPPER],
	:HiddenAbilities => :SOUNDPROOF,
	:GrowthRate => "MediumFast",
	:GenderRatio => "FemHalf",
	:BaseEXP => 172,
	:CatchRate => 45,
	:Happiness => 70,
	:EggSteps => 5120,
	:EggMoves => [:AMNESIA,:BELCH,:COTTONGUARD,:HEADBUTT,:IRONHEAD,:MUDSHOT,:MUDSLAP,:ROCKCLIMB,:SKULLBASH,:STOMP],
	:Moveset => [
		[1,:PURSUIT],
		[1,:LEER],
		[6,:RAGE],
		[11,:FURYATTACK],
		[16,:HORNATTACK],
		[21,:SCARYFACE],
		[26,:REVENGE],
		[31,:HEADCHARGE],
		[36,:FOCUSENERGY],
		[41,:MEGAHORN],
		[46,:REVERSAL],
		[50,:THRASH],
		[56,:SWORDSDANCE],
		[61,:GIGAIMPACT]],
	:tmlist => [:PAYBACK,:TAUNT,:OUTRAGE,:WILDCHARGE,:SUPERPOWER,:ROCKSMASH,:SUNNYDAY,:AERIALACE,:EARTHQUAKE,:BULLDOZE,:GIGAIMPACT,:ROCKCLIMB,:UPROAR,:STRENGTH,:FACADE,:HEADBUTT,:SECRETPOWER,:ROUND,:CUT,:SNORE,:ENDEAVOR,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:SWORDSDANCE,:WORKUP,:POISONJAB,:TOXIC,:ZENHEADBUTT,:REST,:STONEEDGE,:ROCKSLIDE,:ROCKTOMB,:IRONHEAD,:SURF,:RAINDANCE,:SMARTSTRIKE,:STOMPINGTANTRUM,],
	:Color => "Brown",
	:EggGroups => [:Field],
	:Height => 16,
	:Weight => 946,
	:kind => "Bash Buffalo",
	:dexentry => "They charge wildly and headbutt everything. Their headbutts have enough destructive force to derail a train.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 23,
	:BattlerAltitude => 0,
},

:RUFFLET => {
	:name => "Rufflet",
	:dexnum => 627,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [70, 83, 50, 60, 37, 50],
	:EVs => [0, 1, 0, 0, 0, 0],
	:Abilities => [:KEENEYE,:SHEERFORCE],
	:HiddenAbilities => :HUSTLE,
	:GrowthRate => "Slow",
	:GenderRatio => "FemZero",
	:BaseEXP => 70,
	:CatchRate => 190,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[1,:PECK],
		[1,:LEER],
		[5,:FURYATTACK],
		[10,:WINGATTACK],
		[14,:HONECLAWS],
		[19,:SCARYFACE],
		[23,:AERIALACE],
		[28,:SLASH],
		[32,:DEFOG],
		[37,:TAILWIND],
		[41,:AIRSLASH],
		[46,:CRUSHCLAW],
		[50,:SKYDROP],
		[55,:WHIRLWIND],
		[59,:BRAVEBIRD],
		[64,:THRASH]],
	:tmlist => [:UTURN,:SUPERPOWER,:ROCKSMASH,:BULKUP,:HEATWAVE,:SUNNYDAY,:FLY,:AERIALACE,:SKYDROP,:DEFOG,:ROOST,:TAILWIND,:SHADOWCLAW,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:STEELWING,:RAINDANCE,:CONFIDE,],
	:Color => "White",
	:EggGroups => [:Flying],
	:Height => 5,
	:Weight => 105,
	:kind => "Eaglet",
	:dexentry => "They will challenge anything, even strong opponents, without fear. Their frequent fights help them become stronger.",
	:BattlerPlayerY => 24,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:BRAVIARY,:Level,54]
	]
},

:BRAVIARY => {
	:name => "Braviary",
	:dexnum => 628,
	:Type1 => :NORMAL,
	:Type2 => :FLYING,
	:BaseStats => [100, 123, 75, 80, 57, 75],
	:EVs => [0, 2, 0, 0, 0, 0],
	:Abilities => [:KEENEYE,:SHEERFORCE],
	:HiddenAbilities => :DEFIANT,
	:GrowthRate => "Slow",
	:GenderRatio => "FemZero",
	:BaseEXP => 179,
	:CatchRate => 60,
	:Happiness => 70,
	:EggSteps => 5120,
	:Moveset => [
		[0,:SUPERPOWER],
		[1,:THRASH],
		[1,:BRAVEBIRD],
		[1,:WHIRLWIND],
		[1,:PECK],
		[1,:LEER],
		[1,:FURYATTACK],
		[1,:WINGATTACK],
		[5,:FURYATTACK],
		[10,:WINGATTACK],
		[14,:HONECLAWS],
		[19,:SCARYFACE],
		[23,:AERIALACE],
		[28,:SLASH],
		[32,:DEFOG],
		[37,:TAILWIND],
		[41,:AIRSLASH],
		[46,:CRUSHCLAW],
		[50,:SKYDROP],
		[57,:WHIRLWIND],
		[63,:BRAVEBIRD],
		[70,:THRASH]],
	:tmlist => [:UTURN,:SUPERPOWER,:ROCKSMASH,:BULKUP,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:SKYDROP,:DEFOG,:ROOST,:TAILWIND,:SHADOWCLAW,:GIGAIMPACT,:HYPERBEAM,:STRENGTH,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:DOUBLETEAM,:PROTECT,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:WORKUP,:TOXIC,:REST,:ROCKSLIDE,:ROCKTOMB,:STEELWING,:RAINDANCE,:CONFIDE,:LASERFOCUS,],
	:Color => "Red",
	:EggGroups => [:Flying],
	:Height => 15,
	:Weight => 410,
	:kind => "Valiant",
	:dexentry => "The more scars they have, the more respect these brave soldiers of the sky get from their peers.",
	:BattlerPlayerY => 2,
	:BattlerEnemyY => 1,
	:BattlerAltitude => 10,
},

:VULLABY => {
	:name => "Vullaby",
	:dexnum => 629,
	:Type1 => :DARK,
	:Type2 => :FLYING,
	:BaseStats => [70, 55, 75, 60, 45, 65],
	:EVs => [0, 0, 1, 0, 0, 0],
	:Abilities => [:BIGPECKS,:OVERCOAT],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "Slow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 74,
	:CatchRate => 190,
	:Happiness => 35,
	:EggSteps => 5120,
	:EggMoves => [:FAKETEARS,:FOULPLAY,:KNOCKOFF,:MEANLOOK,:ROOST,:SCARYFACE,:STEELWING],
	:Moveset => [
		[1,:GUST],
		[1,:LEER],
		[5,:FURYATTACK],
		[10,:PLUCK],
		[14,:NASTYPLOT],
		[19,:FLATTER],
		[23,:FEINTATTACK],
		[28,:PUNISHMENT],
		[32,:DEFOG],
		[37,:TAILWIND],
		[41,:AIRSLASH],
		[46,:DARKPULSE],
		[50,:EMBARGO],
		[55,:WHIRLWIND],
		[59,:BRAVEBIRD],
		[64,:MIRRORMOVE]],
	:tmlist => [:UTURN,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:ROCKSMASH,:HEATWAVE,:SUNNYDAY,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:HIDDENPOWER,:RETURN,:ATTRACT,:BLOCK,:DOUBLETEAM,:PROTECT,:PSYCHUP,:SLEEPTALK,:SUBSTITUTE,:SWAGGER,:TOXIC,:REST,:ROCKTOMB,:STEELWING,:IRONDEFENSE,:RAINDANCE,:CONFIDE,],
	:Color => "Brown",
	:EggGroups => [:Flying],
	:Height => 5,
	:Weight => 90,
	:kind => "Diapered",
	:dexentry => "They tend to guard their posteriors with suitable bones they have found. They pursue weak Pokémon.",
	:BattlerPlayerY => 23,
	:BattlerEnemyY => 27,
	:BattlerAltitude => 0,
	:evolutions => [
		[:MANDIBUZZ,:Level,54]
	]
},

:MANDIBUZZ => {
	:name => "Mandibuzz",
	:dexnum => 630,
	:Type1 => :DARK,
	:Type2 => :FLYING,
	:BaseStats => [110, 65, 105, 80, 55, 95],
	:EVs => [0, 0, 0, 0, 2, 0],
	:Abilities => [:BIGPECKS,:OVERCOAT],
	:HiddenAbilities => :WEAKARMOR,
	:GrowthRate => "Slow",
	:GenderRatio => "MaleNever",
	:BaseEXP => 179,
	:CatchRate => 60,
	:Happiness => 35,
	:EggSteps => 5120,
	:Moveset => [
		[0,:BONERUSH],
		[1,:MIRRORMOVE],
		[1,:BRAVEBIRD],
		[1,:WHIRLWIND],
		[1,:GUST],
		[1,:LEER],
		[1,:FURYATTACK],
		[1,:PLUCK],
		[5,:FURYATTACK],
		[10,:PLUCK],
		[14,:NASTYPLOT],
		[19,:FLATTER],
		[23,:FEINTATTACK],
		[28,:PUNISHMENT],
		[32,:DEFOG],
		[37,:TAILWIND],
		[41,:AIRSLASH],
		[46,:DARKPULSE],
		[50,:EMBARGO],
		[57,:WHIRLWIND],
		[63,:BRAVEBIRD],
		[70,:MIRRORMOVE]],
	:tmlist => [:UTURN,:FOULPLAY,:DARKPULSE,:SNARL,:PAYBACK,:THIEF,:KNOCKOFF,:EMBARGO,:SNATCH,:TAUNT,:TORMENT,:ROCKSMASH,:HEATWAVE,:SUNNYDAY,:SKYATTACK,:FLY,:AERIALACE,:DEFOG,:ROOST,:TAILWIND,:SHADOWBALL,:GIGAIMPACT,:HYPERBEAM,:FACADE,:SECRETPOWER,:ROUND,:CUT,:SNORE,:FRUSTRATION,:H